.TH lkbib @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
lkbib \- search bibliographic databases
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_lkbib_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.de @@
.  de MR
.    ie \n(.$=1 \
.      I %\$1
.    el \
.      IR %\$1 (\$2)\$3
.  \\.
..
.if  \n(.g .if !d MR .@@
.if !\n(.g .@@
.rm @@
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY lkbib
.RB [ \-n ]
.RB [ \-i\~\c
.IR fields ]
.RB [ \-p\~\c
.IR file ]
.RB [ \-t\~\c
.IR n ]
.I key
\&.\|.\|.\&
.YS
.
.
.SY lkbib
.B \-\-help
.YS
.
.
.SY lkbib
.B \-v
.
.SY lkbib
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I lkbib
searches bibliographic databases for references that contain the keys
.I key
\&.\|.\|.\& and prints any references found on the standard output.
.
.I lkbib
will search any databases given by
.B \-p
options,
and then
(unless
.B \-n
is given)
a default database.
.
The default database is taken from the
.I \%REFER
environment variable if it is set,
otherwise it is
.IR @DEFAULT_INDEX@ .
.
For each database
.I file
to be searched,
if an index
.RI file @INDEX_SUFFIX@
created by
.MR @g@indxbib @MAN1EXT@
exists, then it will be searched instead;
each index can cover multiple databases.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-i\~ string
When searching files for which no index exists,
ignore the contents of fields whose names are in
.IR string .
.
.
.TP
.B \-n
Suppress search of default database.
.
.
.TP
.BI \-p\~ file
Search
.IR file .
.
Multiple
.B \-p
options can be used.
.
.
.TP
.BI \-t\~ n
Only require the first
.I n
characters of keys to be given.
.
Initially,
.I n
is\~6.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I REFER
Default database.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@DEFAULT_INDEX@
Default database to be used if the
.I \%REFER
environment variable is not set.
.
.
.TP
.RI file @INDEX_SUFFIX@
Index files.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Some Applications of Inverted Indexes on the Unix System\[rq],
by M.\& E.\& Lesk,
1978,
AT&T Bell Laboratories Computing Science Technical Report No.\& 69.
.
.
.LP
.MR @g@refer @MAN1EXT@ ,
.MR @g@lookbib @MAN1EXT@ ,
.MR @g@indxbib @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_lkbib_1_man_C]
.do rr *groff_lkbib_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
