'\" t
.TH groff_mm @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff_mm \- memorandum macros for GNU
.I roff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2023 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_mm_7_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.de @@
.  de MR
.    ie \n(.$=1 \
.      I %\$1
.    el \
.      IR %\$1 (\$2)\$3
.  \\.
..
.if  \n(.g .if !d MR .@@
.if !\n(.g .@@
.rm @@
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY "groff \-m@TMAC_M_PREFIX@m"
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.
.SY "groff \-m m@TMAC_M_PREFIX@m"
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU implementation of the
.I mm
macro package is part of the
.I groff
document formatting system.
.
The
.I mm
package is suitable for the composition of
letters,
memoranda,
reports,
and books.
.
.
.P
.I groff mm
is intended to be compatible with the
.I mm
implementation found in the AT&T Documenter's Workbench (DWB),
with the following limitations.
.
.
.IP \[bu] 2n
Omitted features include
the logo and company name strings,
.B }Z
and
.BR ]S ,
respectively;
the encoded company site location addresses recognized as the third
argument to the
.B AU
macro;
the
.B Pv
(\[lq]private\[rq] heading)
register;
and the
.B OK
(other keywords),
and
.B PM
(proprietary markings)
macros.
.
.
.IP \[bu] 2n
The
.B CS
(output cover sheet)
macro is implemented only for memorandum type 4.
.
.
.IP \[bu]
The
.I grap
preprocessor is not explicitly supported;
no
.B G1
and
.B G2
macros
are defined.
.
.
.IP \[bu]
The registers
.BR A ,
.BR C ,
.BR E ,
.BR T ,
and
.BR U ,
typically set from the
.I troff \" generic
or
.I nroff \" generic
command lines with DWB
.IR mm ,
are not recognized.
.
.
.IP \[bu]
When setting the registers
.B L
or
.B W
from the command line,
use an explicit scaling unit to avoid surprises.
.
.
.IP \[bu]
DWB
.IR mm 's
.B nP
macro indented the second line of a paragraph to align it with the start
of the text of the first
(after the paragraph number);
.IR "groff mm" 's
does not.
.
.
.IP \[bu]
Cut marks are not supported.
.
.
.P
DWB
.I mm
supported only seven levels of heading.
.
As a compatible extension,
.I groff mm
supports fourteen,
introducing new registers
.B H8
through
.BR H14 ,
and affecting the interpretation of the
.B HF
and
.B HP
strings.
.
.
.P
Macro,
register,
and string descriptions in this page frequently mention each other;
most cross references are to macros.
.
Where a register or string is referenced,
its type is explicitly identified.
.
.IR mm 's
macro names are usually in full capitals;
registers and strings tend to have mixed-case names.
.
.
.\" ====================================================================
.SS "Document styles"
.\" ====================================================================
.
.I groff mm
offers three different frameworks for document organization.
.
.BR \%COVER /\: \%COVEND
is a flexible means of preparing any document requiring a cover page.
.
.BR LT / LO
aids preparation of typical Anglophone correspondence
(business letters,
for example).
.
The
.B MT
memorandum type mechanism implements a group of formal styles
historically used by AT&T Bell Laboratories.
.
Your document can select at most one of these approaches;
when used,
each disables the others.
.
A simple
.I mm
document might use only
.B H
(or
.BR HU )
and
.B P
for headings and paragraphing,
respectively.
.
.
.\" ====================================================================
.SS Localization
.\" ====================================================================
.
.I groff mm
is designed to be easily localized.
.
For languages other than English,
strings that can appear in output are collected in the file
.IR @MACRODIR@/\: xx \:.tmac ,
where
.I xx
is an ISO\~639 two-letter language identifier.
.
For Swedish,
this is
.IR sv.tmac ;
\[lq]sv\[rq],
not
\[lq]se\[rq].
.
.
.P
This package can also be localized by site or territory;
for example,
.I @MACRODIR@/\:@TMAC_M_PREFIX@mse\:.tmac
illustrates how to adapt the output to a national standard using its ISO
3166 territory code.
.
Such a package can define a string that causes a macro file
.IR @MACRODIR@/\:mm/\:\% territory _locale
to be loaded at package initialization.
.
If this mechanism is not used,
.I @MACRODIR@/\:mm/\:\%locale
is loaded instead.
.
No diagnostic is produced if these files do not exist.
.
.
.\" ====================================================================
.SS "Registers and strings"
.\" ====================================================================
.
Much
.I mm
behavior can be configured by registers and strings.
.
A register is assigned with the
.B nr
request.
.
.
.RS
.P
.B .nr
.I ident
.RB [ \[+-] ]\c
.I n
.RI [ i ]
.RE
.
.
.P
.I ident
is the name of the register,
and
.IR n \~is
the value to be assigned.
.
.IR n \~can
be prefixed with a plus or minus sign if incrementation or
decrementation (respectively) of the register's existing value
.RI by\~ n
is desired.
.
If assignment of a (possibly) negative
.IR n \~is
required,
further prefix it with a zero or enclose it in parentheses.
.
If
.IR i \~is
specified,
the register is automatically modified
.RI by \~i
prior to interpolation if a plus or minus sign is included in the escape
sequence as follows.
.
.
.RS
.P
.B \[rs]n\c
.RB [ \[+-] ]\c
.BI [ ident ]
.RE
.
.
.P
.IR i \~can
be negative;
it combines algebraically with the sign in the interpolation escape
sequence.
.
.
.P
Strings are defined with the
.B ds
request.
.
.
.RS
.P
.B .ds
.I ident contents
.RE
.
.
.P
.I contents
consumes everything up to the end of the line,
including trailing spaces.
.
It is a good practice to end
.I contents
with a comment escape sequence
.RB ( \[rs]\[dq] )
so that extraneous spaces do not intrude during document maintenance.
.
To include leading spaces in
.IR contents ,
prefix it with a double quote.
.
Strings are interpolated with the
.B \[rs]*
escape sequence.
.
.
.RS
.P
.B \[rs]*\c
.BI [ ident ]
.RE
.
.
.P
Register and string name spaces are distinct,
but strings and macros share a name space.
.
Defining a string with the same name as an
.I mm
macro is not supported and may cause incorrect rendering,
the emission of diagnostic messages,
and an error exit status from
.IR @g@troff .
.
.
.\" ====================================================================
.SS "Register format"
.\" ====================================================================
.
A register is interpolated using Arabic numerals if no other format has
been assigned to it.
.
Assign a format to a register with the
.B af
request.
.
.
.RS
.LP
.BI .af\~ "R c"
.RE
.
.
.LP
.IR R \~is
the name of the register,
and
.IR c \~is
the format.
.
If
.IR c \~is
a sequence of Arabic numerals,
their quantity defines a zero-padded minimum width for the interpolated
register value.
.
.
.RS
.LP
.TS
tab(@);
lb lb
l l.
Form@Sequence
1@0, 1, 2, 3, .\|.\|., 10, .\|.\|.
001@000, 001, 002, 003, .\|.\|., 1000, .\|.\|.
i@0, i, ii, iii, iv, .\|.\|.
I@0, I, II, III, IV, .\|.\|.
a@0, a, b, c, .\|.\|., z, aa, ab, .\|.\|.
A@0, A, B, C, .\|.\|., Z, AA, AB, .\|.\|.
.TE
.RE
.
.
.\" ====================================================================
.SS Fonts
.\" ====================================================================
.
In
.IR "groff mm" ,
the fonts
(or rather,
font styles)
.BR R \~(roman),
.BR I \~(italic),
and
.BR B \~(bold)
are mounted at font positions
.BR 1 ,
.BR 2 ,
.RB and\~ 3 ,
respectively.
.
Internally,
font positions are used for backwards compatibility.
.
From a practical point of view,
it doesn't make a big difference\[em]a different font family can still
be selected by invoking
.IR groff 's
.B fam
request or using its
.B \-f
command-line option.
.
On the other hand,
if you want to replace just,
for example,
.RB font\~ I
with Zapf Chancery Medium italic
(available on
.IR groff 's
.B pdf
and
.B ps
output devices),
you have to use the
.B fp
request,
replacing the font at position\~2 with
.RB \[lq] .fp\~2\~ZCMI \[rq]).
.
Because the cover sheet,
memorandum type,
and
.MR @g@refer @MAN1EXT@
integration macros explicitly request fonts named
.BR B ,
.BR I ,
and
.BR R ,
you will also need to remap these font names with the
.B ftr
request,
for instance with
.RB \[lq] .ftr\~I\~ZCMI \[rq].
.
.
.\" ====================================================================
.SH Macros
.\" ====================================================================
.
An explicitly empty argument may be specified with a pair of double
quotes;
to call a macro
.B XX
with an empty second argument but non-empty first and third ones,
you could input the following.
.
.
.P
.RS
.EX
\&.XX foo \[dq]\[dq] baz
.EE
.RE
.
.
.P
Macro names longer than two characters are GNU extensions;
some shorter names were not part of DWB
.IR mm 's
published interface but are documented aspects of
.I groff mm.
.
.
.TP
.BI )E\  "level text"
Add heading text
.I text
to the table of contents with
.IR level ,
which is either\~0 or in the range 1 to\~7.
.
See also
.BR .H .
.
This undocumented DWB
.I mm
macro is exposed by
.I groff mm
to enable customized tables of contents.
.
.
.TP
.BR 1C\~ [ 1 ]
Begin one-column formatting after breaking the page.
.
.RB A\~ 1
argument suppresses the page break,
but if a footnote is pending,
it may be overprinted.
.
See
.BR 2C ,
.BR MC ,
and
.BR NCOL .
.
.
.TP
.B 2C
Begin two-column formatting.
.
This is a special case of
.BR MC .
.
See
.B 1C
and
.BR NCOL .
.
.
.TP
.B AE
Abstract end;
stop collecting abstract text.
.
See
.BR AS .
.
.
.TP
.BI AF\ \fR[\fP name-of-firm \fR]\fP
Author's firm, should be called before
.BR AU ,
see also
.BR \%COVER .
.
.
.TP
.BI AL\~ \fR[\fPtype\~\fR[\fPtext-indent\~ \fR[\fP1\fR]]]\fP
Start an auto-incrementing list.
.
Items are numbered beginning with one.
.
The
.I type
argument assigns the register format
(see above)
of the list item enumerators.
.
The default
.RB is\~ 1 .
.
An explicitly empty
.I type
also indicates the default.
.
.I text-indent
sets the indentation in ens,
overriding register
.BR Li .
.
If a third argument,
conventionally
.BR 1 ,
is given,
the blank line that normally precedes each list item is suppressed.
.
Use
.B LI
to declare list items,
and
.B LE
to end the list.
.
.
.TP
.BR APP \~\c
.RI [ id\~ [ title ]]
Begin an appendix.
.
If the identifier
.I id
is omitted,
it is incremented
(or initialized,
if necessary).
.
The register format used for
.I id
is \[lq]A\[rq].
.
The page is broken.
.
The register
.B Aph
determines whether an appendix heading is then formatted.
.
This heading uses the string
.B App
followed by
.IR id .
.
Appendices appear in any table of contents
(see
.BR TC ).
.
The string
.B Apptxt
is set to
.I title
if the latter is present,
and made empty otherwise.
.
.
.TP
.BI APPSK\~ "id n" \~\c
.RI [ title ]
As
.BR .APP ,
but increment the page number by
.IR n .
.
Use this macro to \[lq]skip pages\[rq] when diagrams or other materials
not formatted by
.I @g@troff
are included in appendices.
.
.
.TP
.BR AS\~ [\c
.IR placement \~[ indentation ]]
Abstract start;
begin collecting abstract.
.
Input up to the next
.B AE
call is included in the abstract.
.
.I placement
influences the location of the abstract on the cover sheet of a
memorandum
(see
.BR MT ).
.
.BR \%COVER ,
by contrast,
ignores
.I placement
by default,
but can be customized to interpret it.
.
.
.IP
.TS
tab(@);
lf(BI) lb
l lx.
placement@Effect
0@T{
The abstract appears on page\~1 and cover sheet if the document is a
\[lq]released paper\[rq] memorandum
.RB ( ".MT 4" );
otherwise,
it appears on page\~1 without a cover sheet.
T}
1@T{
The abstract appears only on the cover sheet
.RB ( ".MT 4"
only).
T}
.\" XXX: This does not appear to be implemented.
.\"2@T{
.\"The abstract is printed only on the cover sheet (if not
.\".BR ".MT 4" )
.\".
.\"The cover sheet is printed without a need for \fBCS\fP.
.\"T}
.TE
.
.
.IP
An abstract does not appear at all in external letters
.RB ( ".MT 5" ).
.
.RI A\~ placement
of
.B 2
was supported by DWB
.I mm
but is not by
.IR "groff mm" .
.
.
.IP
A second argument increases the indentation by
.I indentation
and reduces the line length by twice this amount.
.
A scaling unit of ens is assumed.
.
The default is\~0.
.
.
.\" XXX: Do we need a macro for this?  Why is it not a string like App
.\" or Licon?  It is usefully localizable.
.TP
.BR AST \~\c
.RI [ heading ]
Set the heading above the abstract to
.IR heading ,
or clear it if there is no argument.
.
The default is \[lq]ABSTRACT\[rq].
.
.
.TP
.BI AT\~ title\c
\~[.\|.\|.]
Author's title(s).
.
If present,
.B AT
must appear just after the corresponding author's
.BR AU .
.
Each title shows up on a separate output line after the name in the
signature block and in the
.B ms
cover sheet style.
.
.
.TP
.BR AU \~\c
.RI [ name\~\c
.RI [ initials\~\c
.RI [ loc\~\c
.RI [ dept\~\c
.RI [ ext\~\c
.RI [ room\~\c
.RI [ arg1\~\c
.RI [ arg2\~\c
.RI [ arg3 ]]]]]]]]]
Specify author.
.
.B AU
terminates a document title being collected with
.BR TL ,
and can be called without arguments for that sole purpose.
.
Author information is used by cover sheets and predefined memorandum
types
.RB ( MT ).
.
It can contain initials,
location,
department,
telephone extension,
room number or name,
and up to three additional arguments.
.
Repeat
.B AU
to identify multiple authors.
.
.
.IP
Use
.BR WA / WE
instead to identify the author for documents employing
.BR LT .
.
.
.TP
.BI AV\  \fR[\fPname\  \fR[\fP1\fR]]\fP
Approval signature.
.
Generates an approval line with place for signature and date.
.
The text \[lq]APPROVED:\[rq] can be changed with the string
.BR Letapp ;
it is replaced with an empty line if there is a second argument.
.
The text \[lq]Date\[rq] can be changed with the string
.BR Letdate .
.
.
.\" XXX: AVL is misnamed; it should have been called SGL or similar.
.TP
.BI AVL\  \fR[\fPname\fR]\fP
Letter signature.
.
Generates a line with place for signature.
.
.
.TP
.BR B \~\c \" space in roman; we must use 2-font macro with \c
.RI [ bold-text\~\c
.RI [ previous-font-text ]]\~.\|.\|.
Join
.I bold-text
in boldface with
.I previous-font-text
in the previous font,
without space between the arguments.
.
If no arguments,
switch font to bold style.
.
.
.TP
.B B1
Begin boxed,
kept display.
.
The text is indented one character,
and the right margin is one character shorter.
.
This is a GNU extension.
.
.
.TP
.B B2
End boxed,
kept display.
.
This is a GNU extension.
.
.
.TP
.B BE
End bottom block, see
.BR BS .
.
.
.TP
.BR BI \~\c \" space in roman; we must use 2-font macro with \c
.RI [ bold-text\~\c
.RI [ italic-text ]]\~.\|.\|.
Join
.I bold-text
in boldface with
.I italic-text
in italics,
without space between the arguments.
.
.
.TP
.BI BL\  \fR[\fPtext-indent\  \fR[\fP1\fR]]\fP
Start bullet list.
.
Initializes a list with a bullet and a space in the beginning of each
list item (see
.BR LI ).
.
.I text-indent
sets the indentation in ens,
overriding register
.BR Pi .
.
A third argument prohibits printing of a blank line before each item.
.
.
.TP
.BR BR \~\c \" space in roman; we must use 2-font macro with \c
.RI [ bold-text\~\c
.RI [ roman-text ]]\~.\|.\|.
Join
.I bold-text
in boldface with
.I roman-text
in roman style,
without space between the arguments.
.
.
.TP
.B BS
Bottom block start.
.
Begins the definition of a text block which is printed at the bottom
of each page.
.
The block ends with
.BR BE .
.
.TP
.BI BVL\  "text-indent \fR[\fPmark-indent\ " \fR[\fP1\fR]]\fP
Start of broken variable-item list.
.
Broken variable-item list has no fixed mark,
it assumes that every
.B LI
has a mark instead.
.
The text always begins at the next line after the mark.
.
.I text-indent
sets the indentation to the text, and
.I mark-indent
the distance from the current indentation to the mark.
.
A third argument prohibits printing of a blank line before each item.
.
.
.TP
.BR \%COVER \~\c \" space in roman; we must use 2-font macro with \c
.RI [ style ]
Begin a cover sheet description.
.
It is important that
.B \%COVER
appear before any of the body text
(or main matter)
of a document.
.
The argument
.I style
is used to construct the file name
.IR @TMAC_MDIR@/\: style \:.cov
and load it with the
.B mso
request.
.
Therefore it is possible to create unlimited types of cover sheets.
.
The default
.I style
is
.BR ms ;
it structures a cover sheet to resemble that used by the
.I ms
package.
.
.B \%COVER
requires a
.B \%COVEND
at the end of the cover description.
.
Always use the following ordering of the cover sheet macros.
.
.
.RS
.IP
.EX
\&.COVER
\&.TL
\&.AF
\&.AU
\&.AT
\&.AS
\&.AE
\&.COVEND
.EE
.RE
.
.
.IP
Only
.B .TL
and
.B .AU
are required.
.
.
.TP
.B COVEND
End the cover description and output the cover page.
.
This macro is defined in the cover sheet macro file.
.
.
.TP
.B DE
Display end.
.
Ends a block of text or display that begins with
.B DS
or
.BR DF .
.
.
.TP
.BR DF\~ [\c
.IR format \~[ fill \~[ rindent ]]]
Begin floating display.
.
A floating display is saved in a queue and is printed in the order
entered.
.
The arguments
.I format,
.I fill,
and
.I rindent
are handled as in
.BR DS .
.
Floating displays cannot be nested.
.
Floating display output is controlled by the registers
.B De
and
.BR Df .
.
.
.TP
.BI DL\  \fR[\fPtext-indent\  "\fR[\fP\fB1\fP \fR[\fP\fB1\fP\fR]]]\fP"
Dash list start.
.
Begins a list where each item is printed after a dash.
.
.I text-indent
sets the indentation in ens,
overriding register
.BR Pi .
.
A second argument prevents an empty line between each list item.
.
See
.BR LI .
.
A third argument prohibits printing of a blank line before each item.
.
.TP
.BI DS\  "\fR[\fPformat \fR[\fPfill \fR[\fPrindent\fR]]]\fP"
Static display start.
.
Begins collection of text until
.BR DE .
.
The text is printed together on the same page, unless it is longer
than the height of the page.
.
.B DS
can be nested arbitrarily.
.
.
.IP
.TS
tab(@);
Lf(BI) Lb
L Lx.
format@Effect
\[dq]\[dq]@No indentation.
none@No indentation.
L@No indentation.
I@T{
Indent text by
.B \[rs]n[Si]
ens.
T}
C@Center each line.
CB@Center the whole display as a block.
R@Right-adjust the lines.
RB@Right-adjust the whole display as a block.
.TE
.
.
.IP
The values \[lq]L\[rq],
\[lq]I\[rq],
\[lq]C\[rq],
and \[lq]CB\[rq] can also be specified as \[lq]0\[rq],
\[lq]1\[rq],
\[lq]2\[rq],
and
\[lq]3\[rq],
respectively,
for compatibility reasons.
.
.
.IP
.TS
tab(@);
Lf(BI) Lb
L Lx.
fill@Effect
\[dq]\[dq]@Line-filling turned off.
none@Line-filling turned off.
N@Line-filling turned off.
F@Line-filling turned on.
.TE
.
.
.IP
\[lq]N\[rq] and \[lq]F\[rq] can also be specified as \[lq]0\[rq] and
\[lq]1\[rq],
respectively.
.
.IP
By default, an empty line is printed before and after the display.
.
Setting register
.B Ds
to\~0 prevents this.
.
.I rindent
shortens the line length by that amount.
.
.
.TP
.BR EC \~\c
.RI [ title \~[ override \~[ flag \~[  refname ]]]]
Caption an equation.
.
The caption consists of the string
.B Liec
followed by an automatically incrementing counter stored in the register
.BR Ec ,
punctuation configured by the register
.BR Of ,
then
.I title
(if any).
.
Use the
.B af
request to configure
.BR Ec 's
number format.
.
.I override
and
.I flag
alter the equation number as follows.
.
Omitting
.I flag
and specifying
.B 0
in its place are equivalent.
.
.
.IP
.TS
tab(@);
Lf(BI) Lb
L Lx.
flag@Effect
0@T{
Prefix number with
.IR override .
T}
1@T{
Suffix number with
.IR override .
T}
2@T{
Replace number with
.IR override .
T}
.TE
.
.
.IP
Equation captions are centered irrespective of the alignment of any
enclosing display.
.
.
.IP
.I refname
stores the equation number using
.BR SETR ;
it can be retreived with
.RB \[lq] .GETST
.IR refname \[rq].
.
This argument is a GNU extension.
.
.
.IP
Captioned equations are listed in a table of contents
(see
.BR TC )
if the Boolean register
.B Le
is true.
.
Such a list uses the string
.B Le
as a heading.
.
.
.TP
.BI EF\  \fR[\fParg\fR]\fP
Even-page footer,
printed just above the normal page footer on even pages.
.
See
.BR PF .
.
.IP
This macro defines string
.BR EOPef .
.
.TP
.BI EH\  \fR[\fParg\fR]\fP
Even-page header,
printed just below the normal page header on even pages.
.
See
.BR PH .
.
.IP
This macro defines string
.BR TPeh .
.
.
.TP
.B EN
End equation input preprocessed by
.MR @g@eqn @MAN1EXT@ ;
see
.BR EQ .
.
.
.TP
.B EOP
End-of-page user-defined macro.
.
This macro is called instead of the normal printing of the footer.
.
The macro is executed in a separate environment,
without any trap active.
.
See
.BR TP .
.
.IP
.B Strings available to EOP
.RS
.TS
tab(@);
l l.
EOPf@argument of \fBPF\fP
EOPef@argument of \fBEF\fP
EOPof@argument of \fBOF\fP
.TE
.RE
.
.TP
.BI EPIC\  "\fR[\fP\fB\-L\fP\fR]\fP width height \fR[\fPname\fR]\fP"
Draw a box with the given
.I width
and
.IR height .
.
It also prints the text
.I name
or a default string if
.I name
is not specified.
.
This is used to include external pictures;
just give the size of the picture.
.
.B \-L
left-aligns the picture;
the default is to center.
.
See
.BR PIC .
.
.
.TP
.BR EQ \~[\c
.IR label ]
Start equation input preprocessed by
.MR @g@eqn @MAN1EXT@ .
.
.B EQ
and
.B EN
macro calls bracket an equation region.
.
Such regions must be contained in displays
.RB ( DS / DE ),
except when the region is used only to configure
.I @g@eqn
and not to produce output.
.
If present,
.I label
appears at the aligned to the right and
centered vertically within the display;
see register
.BR Eq .
.
.
If multiple
.I eqn \" generic
regions occur within a display,
only the last
.I label
(if any)
is used.
.
.
.TP
.BR EX \~\c
.RI [ title \~[ override \~[ flag \~[  refname ]]]]
Caption an exhibit.
.
Arguments are handled analogously to
.BR EC .
.
The register
.B Ex
is the exhibit counter.
.
The string
.B Liex
precedes the exhibit number and any
.I title.
.
Exhibit captions are centered irrespective of the alignment of any
enclosing display.
.
.
.IP
Captioned exhibits are listed in a table of contents
(see
.BR TC )
if the Boolean register
.B Lx
is true.
.
Such a list uses the string
.B Lx
as a heading.
.
.
.TP
.BI FC\  \fR[\fPclosing\fR]\fP
Print \[lq]Yours very truly,\[rq]
as a formal closing of a letter or memorandum.
.
The argument replaces the default string.
.
The default is stored in the string
.BR Letfc .
.
.TP
.BI FD\  \fR[\fParg\  \fR[\fP1\fR]]\fP
Footnote default format.
.
Controls the hyphenation (hyphen),
adjustment to the right margin (adjust),
and indentation of footnote text (indent).
.
It can also change the label justification (ljust).
.
.RS
.IP
.TS
tab(@);
lb lb lb lb lb
l l l l l.
arg@hyphen@adjust@indent@ljust
0@no@yes@yes@left
1@yes@yes@yes@left
2@no@no@yes@left
3@yes@no@yes@left
4@no@yes@no@left
5@yes@yes@no@left
6@no@no@no@left
7@yes@no@no@left
8@no@yes@yes@right
9@yes@yes@yes@right
10@no@no@yes@right
11@yes@no@yes@right
.TE
.RE
.
.IP
An argument greater than or equal to 11 is considered as value\~0.
.
The default for
.I mm
is 10.
.
.
.TP
.B FE
Footnote end;
see
.BR FS .
.
.
.TP
.BR FG \~\c
.RI [ title \~[ override \~[ flag \~[  refname ]]]]
Caption a figure.
.
Arguments are handled analogously to
.BR EC .
.
The register
.B Fg
is the figure counter.
.
The string
.B Lifg
precedes the figure number and any
.I title.
.
Figure captions are centered irrespective of the alignment of any
enclosing display.
.
.
.IP
Captioned figures are listed in a table of contents
(see
.BR TC )
if the Boolean register
.B Lf
is true.
.
Such a list uses the string
.B Lf
as a heading.
.
.
.TP
.BR FS \~[\c
.IR label ]
Footnote start.
.
Text until
.B FE
is called is collected into a footnote.
.
By default,
footnotes are automatically numbered starting at 1;
the number is available in register
.B :p
and,
with a trailing period,
in
.RB string\~ F .
.
This string precedes the footnote text at the bottom of the column or
page.
.
Footnotes are vertically separated by the product of
.RB registers\~ Fs
and
.BR Lsp .
.
In
.IR "groff mm" ,
footnotes may be used in displays.
.
.
.IP
A
.I label
argument replaces the contents of the string
.BR F ;
it need not be numeric.
.
In this event,
the footnote marker in the body text must be explicitly written.
.
.
.TP
.BI GETHN\  "refname \fR[\fPvarname\fR]\fP"
Include the header number where the corresponding
.RB \[lq] .SETR
.IR refname \[rq]
was placed.
.
This is displayed as \[lq]X.X.X.\[rq] in pass\~1.
.
See
.BR INITR .
.
If
.I varname
is used,
.B GETHN
sets the string
.I varname
to the header number.
.
.TP
.BI GETPN\  "refname \fR[\fPvarname\fR]\fP"
Include the page number where the corresponding
.RB \[lq] .SETR
.IR refname \[rq]
was placed.
.
This is displayed as \[lq]9999\[rq] in pass\~1.
.
See
.BR INITR .
.
If
.I varname
is used,
.B GETPN
sets the string
.I varname
to the page number.
.
.TP
.BI GETR\  refname
Combine
.B GETHN
and
.B GETPN
with the text \[lq]chapter\[rq] and \[lq],\~page\[rq].
.
The string
.B Qrf
contains the text for the cross reference:
.
.RS
.IP
\&.ds Qrf See chapter \[rs]\[rs]*[Qrfh], page \[rs]\[rs]*[Qrfp].
.RE
.
.IP
.B Qrf
may be changed to support other languages.
.
Strings
.B Qrfh
and
.B Qrfp
are set by
.B GETR
and contain the page and header number, respectively.
.
.TP
.BI GETST\  "refname \fR[\fPvarname\fR]\fP"
Include the string saved with the second argument to
.BR .SETR .
.
This is a dummy string in pass\~1.
.
If
.I varname
is used,
.B GETST
sets it to the saved string.
.
See
.BR INITR .
.
.
.TP
.BI H\~ level\~\c
.RI [ title \~[ suffix ]]
Set a numbered section heading at
.IR level .
.
.I mm
produces numbered headings in the form
.IR a . b . c .\|.\|.,
with up to fourteen levels of nesting.
.
The numbering of each level increases automatically and is
reset to zero when a more significant level is specified.
.
.RB \[lq] 1 \[rq]\~is
the most significant or coarsest division of the document.
.
Text after an
.B H
call is formatted as a paragraph;
calling
.B P
is unnecessary.
.
.
.IP
.I title
specifies an optional title;
it must be double-quoted if it contains spaces.
.
.I suffix
is appended to the heading title in the body of the document,
but omitted from any table of contents
(see
.BR TC ).
.
This facility can be used to annotate the heading title with a footnote.
.
.I suffix
should not include
.BR \[rs]*F ;
specify a footnote mark explicitly.
.
See
.BR FS .
.
.
.IP
Heading behavior is highly configurable.
.
Several registers set a
.I threshold,
where heading levels at or below the threshold value are handled in one
way,
and those above it another.
.
For example,
a heading level within the threshold of register
.B Cl
is included in the table of contents
(see
.BR TC ).
.
.
.IP
.I Heading layout.
.
Register
.B Ej
sets a threshold for page breaking (ejection) prior to a heading.
.
If not preceded by a page break,
a heading level below the threshold in register
.B Hps
is preceded by the amount of vertical space in register
.BR Hps1 ,
and by the amount in
.B Hps2
otherwise.
.
The
.B Hb
register sets a threshold below which a break occurs after the heading,
and register
.B Hs
sets a threshold below which vertical space follows it.
.
If the heading level is not less than both of these,
a
.I run-in heading
is produced;
paragraph text follows on the same output line.
.
Otherwise,
register
.B Hi
configures the indentation of text after headings.
.
Threshold register
.B Hc
enables the centering of headers;
a heading level below both of the
.B Hb
and
.B Hc
thresholds is centered.
.
.
.IP
.I Heading typeface and size.
.
The fonts used for heading numbers and titles at each level are
configured by the
.B HF
string.
.
The string
.B HP
likewise assigns a type size to each heading level.
.
.\" XXX: Why not an "Hvs" string?
The vertical spacing used by headings may be controlled by
the user-definable macros
.B HX
and/or
.BR HZ .
.
.
.IP
.I Heading number format.
.
Registers named
.B H1
through
.B H14
store counters for each heading level.
.
Their values are printed using Arabic numerals by default;
see
.BR HM .
.
The heading levels are catenated with dots for formatting;
to typeset only the deepest,
set the
.B Ht
register.
.
Heading numbers are not suffixed with a trailing dot except when only
the first level is output;
to omit a dot in this case as well,
clear the
.B H1dot
register.
.
.
.IP
.I Customizing heading behavior.
.
.I mm
calls
.I hook
macros to enable further customization of headings.
.
(DWB
.I mm
called these \[lq]exits\[rq].)
.
They can be used to change the heading's
.I mark
(the numbered portion before any heading title),
its vertical spacing,
and its vertical space requirements
(for instance,
to require a minimum quantity of subsequent output lines).
.
Define hook macros in expectation of the following parameters.
.
The argument
.I declared-level
is the
.I level
argument to
.BR H ,
.RB or\~ 0
for unnumbered headings (see
.BR HU ).
.
.I actual-level
is the same as
.I declared-level
for numbered headings,
and the value of
.RB register\~ Hu
for unnumbered headings.
.
.I title
is the corresponding argument to
.B H
or
.BR HU .
.
.
.RS
.TP
.BI HX\~ "declared-level actual-level title"
.I mm
calls
.B HX
before setting the heading.
.
Your definition may alter
.BR }0 ,
.BR }2 ,
and
.BR ;3 .
.
.
.\" XXX: These names are ugly and of no obvious meaning.  Make
.\" documented aliases for them.
.RS
.TP
.BR }0\~ (string)
contains the heading mark plus two spaces if
.I declared-level
is non-zero,
and otherwise is empty.
.
.
.TP
.BR ;0\~ (register)
encodes a position for the text after the heading.
.
0\~means that the heading is to be run in,
1\~means that a break is to occur before the text,
and 2\~means that vertical space is to separate heading and text.
.
.
.TP
.BR }2\~ (string)
is the suffix that separates a run-in heading from the text.
.
It contains two spaces if register
.B ;0
is\~0,
and otherwise is empty.
.
.
.TP
.BR ;3\~ (register)
contains the vertical space required for the heading to be typeset.
.
If that amount is not available,
the page is broken prior to the heading.
.
The default is
.BR 2v .
.RE
.
.
.TP
.BI HY\~ "declared-level actual-level title"
.I mm
calls
.B HY
after determing the header typeface and size.
.
It might be used to change indentation.
.
.
.TP
.BI HZ\~ "declared-level actual-level title"
.I mm
calls
.B HZ
after formatting the heading,
just before
.B H
or
.B HU
returns.
.
It might be used to change the page header to include a section heading.
.\" XXX: ...but only for the _next_ page, not the current one.  See
.\" Savannah #62825.
.RE
.
.
.TP
.BI HC\  \fR[\fPhyphenation-character\fR]\fP
Set hyphenation character.
.
Default value is \[lq]\[rs]%\[rq].
.
Resets to the default if called without argument.
.
Hyphenation can be turned off by setting register
.B Hy
to\~0 at the beginning of the file.
.
.
.TP
.BI HM\  "\fR[\fParg1 \fR[\fParg2 \fR[.\|.\|.\& [\fParg14\fR]]]]\fP"
Set the heading mark style.
.
Each argument assigns the specified register format
(see above)
to the corresponding heading level.
.
The default
.RB is\~ 1
for all levels.
.
An explicitly empty argument also indicates the default.
.
.
.TP
.BI HU\~ heading-text
Set an unnumbered section heading.
.
Except for a heading number,
it is treated as a numbered heading of the level stored in
.RB register\~ Hu ;
.RB see\~ H .
see\~\c
.BR H .
.
.
.TP
.B HX
.TQ
.B HY
.TQ
.B HZ
See
.B H
for descriptions of these user-definable hooks.
.
.
.TP
.BR I \~\c \" space in roman; we must use 2-font macro with \c
.RI [ italic-text\~\c
.RI [ previous-font-text ]]\~.\|.\|.
Join
.I italic-text
in italics with
.I previous-font-text
in the previous font,
without space between the arguments.
.
If no arguments,
switch font to italic style.
.
.
.TP
.BI IA\  "\fR[\fPaddressee-name \fR[\fPtitle\fR]]\fP"
Begin specification of the addressee and addressee's address in
letter style.
.
Several names can be specified with empty
.BR IA / IE -pairs,
but only one address.
.
See
.BR LT .
.
.
.TP
.BR IB \~\c \" space in roman; we must use 2-font macro with \c
.RI [ italic-text\~\c
.RI [ bold-text ]]\~.\|.\|.
Join
.I italic-text
in italics with
.I bold-text
in boldface,
without space between the arguments.
.
.
.TP
.B IE
End the address specification after
.BR IA .
.
.TP
.BI INITI\  "type filename \fR[\fPmacro\fR]\fP"
Initialize the new index system and set the filename to collect index
lines in with
.BR IND .
.
Argument
.I type
selects the type of index: page number, header marks or both.
.
The default is page numbers.
.
.IP
It is also possible to create a macro that is responsible
for formatting each row;
just add the name of the macro as a third argument.
.
The macro is then called with the index as argument(s).
.
.
.IP
.TS
tab(@);
Lf(BI) Lb
L Lx.
type@entry format
N@Page numbers
H@Header marks
B@T{
Both page numbers and header marks,
separated with a tab character.
T}
.TE
.
.
.TP
.BI INITR\~ id
Initialize the cross reference macros.
.
Cross references are written to the standard error stream,
which should be redirected into a file named
.RI id .qrf .
.
.MR mmroff @MAN1EXT@
handles this and the two formatting passes it requires.
.\".
.\"This program exists because
.\".MR groff @MAN1EXT@
.\"by default deactivates the unsafe operations that are required by
.\".BR INITR .
.
The first pass identifies cross references,
and the second one includes them.
.\"
.\".B INITR
.\"can be used several times,
.\"but it is only the first occurrence of
.\".B INITR
.\"that is active.
.
.
.IP
See
.BR SETR ,
.BR GETPN ,
and
.BR GETHN .
.
.
.TP
.BI IND\  "arg1 \fR[\fParg2 \fR[.\|.\|.]]\fP"
Write a line in the index file selected by
.B INITI
with all arguments and the page number or header mark separated by tabs.
.
.RS
.IP
.B Examples
.
.IP
arg1\[rs]tpage number
.br
arg1\[rs]targ2\[rs]tpage number
.br
arg1\[rs]theader mark
.br
arg1\[rs]tpage number\[rs]theader mark
.RE
.
.TP
.B INDP
Print the index by running the command specified by the string
.BR Indcmd ,
which has
.RB \[lq] sort\~\-t\[rs]t \[rq]
as the default value.
.
.B INDP
reads the output from the command to form the index,
by default in two columns (this can be changed by defining
.BR TYIND ).
.
The index is printed with the string
.B Index
as header;
the default is \[lq]INDEX\[rq].
.
One-column processing is reactivated after the list.
.
.B INDP
calls the user-defined macros
.BR TXIND ,
.BR TYIND ,
and
.B TZIND
if defined.
.
.B TXIND
is called before printing the string \[lq]INDEX\[rq],
.B TYIND
is called instead of printing \[lq]INDEX\[rq],
and
.B TZIND
is called after the printing and should take care of restoring to
normal operation again.
.
.
.TP
.BR IR \~\c \" space in roman; we must use 2-font macro with \c
.RI [ italic-text\~\c
.RI [ roman-text ]]\~.\|.\|.
Join
.I italic-text
in italics with
.I roman-text
in roman style,
without space between the arguments.
.
.
.TP
.BR ISODATE\~ [ 0 ]
Use ISO\~8601 format for the date string
.B DT
used by some cover sheet and memorandum types;
that is,
.IR YYYY - MM - DD .
.
Must be called before
.B ND
to be effective.
.
If given an argument
.RB of\~ 0,
the traditional date format for the
.I groff
locale is used;
this is also the default.
.
.
.TP
.BI LB\  "text-indent mark-indent pad type \fR[\fPmark \fR[\fPLI-space \fR[\fPLB-space\fR]]]\fP"
List-begin macro.
.
This is the common macro used for all lists.
.
.I text-indent
is the number of spaces to indent the text from the current indentation.
.
.IP
.I pad
and
.I mark-indent
control where to put the mark.
.
The mark is placed within the mark area, and
.I mark-indent
sets the number of spaces before this area.
.
By default it is\~0.
.
The mark area ends where the text begins.
.
The start of the text is still controlled by
.IR text-indent .
.
.IP
The mark is left-justified within the mark area if
.I pad
is\~0.
.
If
.I pad
is greater than\~0,
.I mark-indent
is ignored,
and the mark is placed
.I pad
spaces before the text.
.
This right-justifies the mark.
.
.
.IP
.I type
selects one of six possible ways to display the mark.
.
.
.IP
.TS
tab(@);
Lf(BI) Lb
L L.
type@Output for a mark \[lq]x\[rq]
1@x.
2@x)
3@(x)
4@[x]
5@<x>
6@{x}
.TE
.
.
.IP
If
.I type
is\~0 the list either has a hanging indentation or,
if argument
.I mark
is given,
the string
.I mark
as a mark.
.
.IP
If
.I type
is greater than\~0 automatic numbering occurs,
using Arabic numerals if
.I mark
is empty.
.
.I mark
can then be any of \[lq]1\[rq],
\[lq]A\[rq],
\[lq]a\[rq],
\[lq]I\[rq],
or \[lq]i\[rq].
.
.
.IP
Every item in the list gets
.I LI-space
number of blank lines before them.
.
Default is\~1.
.
.IP
.B LB
itself prints
.I LB-space
blank lines.
.
Default is\~0.
.
.TP
.BI LC\  \fR[\fPlist-level\fR]\fP
List-status clear.
.
Terminates all current active lists down to
.IR list-level ,
or\~0 if no argument is given.
.
This is used by\~\c
.B H
to clear any active list.
.
.
.TP
.BR LE \~[ 1 ]
List end.
.
The current list is terminated.
.
If an argument
.B 1
is present,
vertical space in the amount of register
.B Lsp
follows.
.
.
.TP
.BI LI\  \fR[\fPmark\  \fR[\fP1\fR|\fP2\fR]]\fP
List item preceding every item in a list.
.
Without argument,
.B LI
prints the mark determined by the current list type.
.
By giving
.B LI
one argument, it uses that as the mark instead.
.
Two arguments to
.B LI
makes
.I mark
a prefix to the current mark.
.
There is no separating space between the prefix and the mark if the
second argument is \[lq]2\[rq] instead of \[lq]1\[rq].
.
This behaviour can also be achieved by setting register
.B Limsp
to zero.
.
A zero length
.I mark
makes a hanging indentation instead.
.
.IP
A list item is preceded by vertical space unless its nesting level is
greater than the value of register
.BR Ls .
.
The amount of space is determined by the register
.B Lsp
and an argument to
.BR LB .
.
.
.IP
The
.B Li
register configures the indentation amount in ens.
.
.
.IP
All lists begin with a list initialization macro,
.BR LB .
.
There are, however, seven predefined list types to make lists easier
to use.
.
They all call
.B LB
with different default values.
.
.RS
.IP
.TS
tab(@);
l l.
\fBAL\fP@Automatically Incremented List
\fBML\fP@Marked List
\fBVL\fP@Variable-Item List
\fBBL\fP@Bullet List
\fBDL\fP@Dash List
\fBRL\fP@Reference List
\fBBVL\fP@Broken Variable List.
.TE
.RE
.
.
.TP
.BI LO\  "type \fR[\fParg\fR]\fP"
Specify options in letter (see
.BR .LT ).
.
This is a list of the standard options:
.
.RS
.IP
.TS
tab(@);
l lx.
CN@T{
Confidential notation.
Prints \[lq]CONFIDENTIAL\[rq] on the second line below the date line.
.
Any argument replaces \[lq]CONFIDENTIAL\[rq].
.
See also string
.BR LetCN .
T}
RN@T{
Reference notation.
Prints \[lq]In reference to:\[rq] and the argument two lines below the
date line.
.
See also string
.BR LetRN .
T}
AT@T{
Attention.
Prints \[lq]ATTENTION:\[rq] and the argument below the inside address.
See also string
.BR LetAT .
T}
SA@T{
Salutation.
Prints \[rq]To Whom It May Concern:\[rq] or the argument if it was
present.
.
The salutation is printed two lines below the inside address.
See also string
.BR LetSA .
T}
SJ@T{
Subject line.
Prints the argument as subject prefixed with \[lq]SUBJECT:\[rq]
two lines below the inside address,
except in letter type \[lq]SP\[rq],
where the subject is printed in all-capital without any prefix.
See also string
.BR LetSJ .
T}
.TE
.RE
.
.
.TP
.BI LT\  \fR[\fIarg\/\fR]\fI
Format a letter in one of four different styles depending
on the argument.
.
Also see section \[lq]Internals\[rq] below.
.
.RS
.IP
.TS
tab(@);
lb lb
l lx.
Arg@Style
BL@T{
Blocked.
Date line, return address, writer's address and closing
begins at the center of the line.
.
All other lines begin at the left margin.
T}
SB@T{
Semi-blocked.
Same as blocked,
except that the first line in every paragraph is indented five spaces.
T}
FB@T{
Full-blocked.
All lines begin at the left margin.
T}
SP@T{
Simplified.
As full-blocked,
but the salutation is replaced by a fully-capitalized subject,
any formal closing is omitted,
and the author's signature is presented on a single line in full
capitals.
T}
.TE
.RE
.
.
.TP
.BI MC\~ column-width\~\c
.RI [ gutter-width ]
Begin multi-column layout.
.
.I groff mm
creates as many columns of
.I column-width
as the line length will permit.
.
.I gutter-width
is the interior spacing between columns.
.
It defaults to
.IR column-width /15.
.
.B 1C
returns to single-column layout.
.
.B MC
is a GNU extension.
.
See
.B MULB
for an alternative.
.
.
.TP
.BI ML\~ "mark \fR[\fPtext-indent\~" \fR[\fP1\fR]]\fP
Start a list with the
.I mark
argument preceding each list item.
.
.I text-indent
overrides the default indentation of the list items set by register
.BR Li .
.
If a third argument,
conventionally
.BR 1 ,
is given,
the blank line that normally precedes each list item is suppressed.
.
Use
.B LI
to declare list items,
and
.B LE
to end the list.
.
.
.TP
.BR MT \~\c \" space in roman; we must use 2-font macro with \c
.RI [ type \~[ addressee ]]
Select memorandum type.
.
These correspond to formats used by AT&T Bell Laboratories,
where the
.I mm
package was initially developed,
affecting the document layout.
.
Some of these included a cover page with a caption categorizing the
document.
.
.I groff mm
uses
.I type
to construct the file name
.IR @TMAC_MDIR@/\:\% type \:.MT
and load it with the
.B mso
request.
.
Memorandum types 0 to\~5 are supported;
any other value of
.I type
is mapped to type\~6.
.
If
.I type
is omitted,
.B 0
is implied.
.
.I addressee
sets a string analogous to one used by AT&T cover sheet macros that are
not implemented in
.IR "groff mm" .
.
.
.IP
.TS
tab(@);
Lf(BI) Lb
L L.
type@Description
0@normal memorandum; no caption
1@captioned \[lq]MEMORANDUM FOR FILE\[rq]
2@captioned \[lq]PROGRAMMER'S NOTES\[rq]
3@captioned \[lq]ENGINEER'S NOTES\[rq]
4@released paper
5@external letter
.TE
.
.
.IP
See
.B \%COVER
for a more flexible cover sheet mechanism.
.
.
.TP
.BI MOVE\  "y-pos \fR[\fPx-pos \fR[\fPline-length\fR]]\fP"
Move to a position, setting page offset to
.IR x-pos .
.
If
.I line-length
is not given, the difference between current and new page offset is
used.
.
Use
.B PGFORM
without arguments to return to normal.
.
.
.TP
.BR MULB \~\c \" space in roman; we must use 2-font macro with \c
.IR "cw1 space1\~" [ "cw2 space2" "] .\|.\|.\~" cwn
Begin alternative multi-column mode.
.
All column widths must be specified,
as must the amount of space between each column pair.
.
The default unit for the width and space arguments is \[lq]n\[rq].
.
.B .MULB
uses a diversion and operates in a separate environment.
.
.
.TP
.B MULN
Begin next column in alternative column mode.
.
.
.TP
.B MULE
End alternative multi-column mode and emit the columns.
.
.
.TP
.B NCOL
Move to the start of the next column
(only when using
.B 2C
or
.BR MC ).
.
Contrast with
.BR MULN .
.
.
.TP
.BI ND\  new-date
New date.
.
Overrides the current date.
.
Date is not printed if
.I new-date
is an empty string.
.
.
.TP
.B NE
End notation begun with
.BR NS ;
filling is enabled.
.
.
.TP
.BI nP\  \fR[\fPtype\fR]\fP
Print numbered paragraph with header level two.
.
See
.BR .P .
.
.
.TP
.BI NS\  \fR[\fParg\  \fR[\fP1\fR]]\fP
Collect notations of the type specified by
.I arg
until
.B NE
is called;
filling is disabled.
.
If a second argument,
conventionally
.BR 1 ,
is given,
then the argument becomes the entire notation and
.B NE
is not necessary.
.
If
.I arg
does not match one of the predefined types listed below,
the notations are prefixed with
.RI "\[lq]Copy (" arg ") to\[rq]."
.
In
.IR "groff mm" ,
you can set up further notations to be recognized by
.BR NS ;
see the strings
.B Letns
and
.B Letnsdef
below.
.
.
.RS
.IP
.TS
tab(@);
l l.
\fBArg@Notation\fP
\fInone\/\fP@Copy To
\[dq]\[dq]@Copy To
1@Copy To (with att.\&) to
2@Copy To (without att.\&) to
3@Att.
4@Atts.
5@Enc.
6@Encs.
7@Under separate cover
8@Letter to
9@Memorandum to
10@Copy (with atts.\&) to
11@Copy (without atts.\&) to
12@Abstract Only to
13@Complete Memorandum to
14@CC
.TE
.RE
.
.
.TP
.BI OF\  \fR[\fParg\fR]\fP
Odd-page footer, a line printed just above the normal footer.
.
See
.B EF
and
.BR PF .
.
.IP
This macro defines string
.BR EOPof .
.
.TP
.BI OH\  \fR[\fParg\fR]\fP
Odd-page header, a line printed just below the normal header.
.
See
.B EH
and
.BR PH .
.
.IP
This macro defines string
.BR TPoh .
.
.TP
.B OP
Make sure that the following text is printed at the top of an
odd-numbered page.
.
Does not output an empty page if currently at the top of an odd page.
.
.TP
.BI P\  \fR[\fPtype\fR]\fP
Begin new paragraph.
.
.BR P \~without
argument produces left\-justified text,
even the first line of the paragraph.
.
This is the same as setting
.I type
to\~0.
.
If
.I type
is\~1,
the first output line of the paragraph is indented by
.B \[rs][Pi]
ens.
.
.IP
Instead of giving an argument to\~\c
.B P
it is possible to set the paragraph type in register
.BR Pt .
.
Using 0 and\~1 is the same as adding that value to
.BR P .
.
A value of\~2 indents all paragraphs, except after headings, lists,
and displays (this value can't be used as an argument to
.B P
itself).
.
.IP
The space between two paragraphs is controlled by register
.BR Ps ,
and is\~1 by default (one blank line).
.
.TP
.BI PGFORM\  "\fR[\fPlinelength \fR[\fPpagelength \fR[\fPpageoffset\ " \fR[\fP1\fR]]]]\fP
Set line length, page length, and/or page offset.
.
This macro can be used for special formatting,
like letter heads and other.
.
It is normally the first macro call in a file,
though it is not necessary.
.
.B PGFORM
can be used without arguments to reset everything after a
.B MOVE
call.
.
A line break is done unless the fourth argument is given.
.
This can be used to avoid the page number on the first page
while setting new width and length.
.
(It seems as if this macro sometimes doesn't work too well.
.
Use the command-line arguments to change
line length, page length, and page offset instead.)
.
.TP
.B PGNH
No header is printed on the next page.
.
Used to get rid of the header in letters or other special texts.
.
This macro must be used before any text to inhibit the page header
on the first page.
.
.
.TP
.BR PIC \~\c
.RB [ \-B ]\~\c
.RB [ \-C |\c
.BI \-I\~ n\c
.RB | \-L \c
.RB | \-R ]\~\c
.IR file \~[ width \~[ height ]]
Include PostScript document
.IR file .
.
This macro depends on
.MR mmroff @MAN1EXT@
and
.BR INITR .
.
The optional
.B \-B
argument draws a box around the picture.
.
The optional
.BR \-L ,
.BR \-C ,
.BR \-R ,
and
.BI \-I\~ n
arguments align the picture or indent it by
.I n
(assuming a scaling unit of
.BR m ).
.
By default,
the picture is left-aligned.
.
Optional
.I width
and
.I height
arguments resize the picture.
.
.
.TP
.B PE
Picture end;
see
.MR @g@pic @MAN1EXT@ .
.
.
.TP
.BI PF\  \fR[\fParg\fR]\fP
Page footer.
.B PF
sets the line to be printed at the bottom of each page.
.
Empty by default.
.
See
.B PH
for the argument specification.
.
.IP
This macro defines string
.BR EOPf .
.
.TP
.BI PH\  \fR[\fParg\fR]\fP
Page header, a line printed at the top of each page.
.
The argument should be specified as
.
.RS
.IP
.RI \[dq]\[aq] left-part \[aq] center-part \[aq] right-part \[aq]\[dq]
.RE
.
.IP
where
.IR left-part ,
.IR center-part ,
and
.I right-part
are printed left-justified, centered, and right justified, respectively.
.
Within the argument to
.BR PH ,
the character \[lq]%\[rq] is changed to the current page number.
.
The default argument is
.
.RS
.IP
\[dq]\[aq]\[aq]\- % \-\[aq]\[aq]\[dq]
.RE
.
.IP
which gives the page number between two dashes.
.
.IP
This macro defines string
.BR TPh .
.
.
.TP
.B PS
Picture start; see
.MR @g@pic @MAN1EXT@ .
.
.
.TP
.B PX
Page header hook.
.
This macro is called just after the printing of the page header in
no-space mode.
.
.
.TP
.B PY
Picture end with flyback.
.
Ends a
.MR @g@pic @MAN1EXT@
picture,
returning the vertical position to where it was prior to the picture.
.
This is a GNU extension.
.
.
.TP
.BR R \~\c \" space in roman; we must use 2-font macro with \c
.RI [ roman-text\~\c
.RI [ previous-font-text ]]\~.\|.\|.
Join
.I roman-text
in roman style with
.I previous-font-text
in the previous font,
without space between the arguments.
.
If no arguments,
switch font to roman style.
.
.
.TP
.BR RB \~\c \" space in roman; we must use 2-font macro with \c
.RI [ roman-text\~\c
.RI [ bold-text ]]\~.\|.\|.
Join
.I roman-text
in roman style with
.I bold-text
in boldface,
without space between the arguments.
.
.
.TP
.BI RD\  "\fR[\fPprompt \fR[\fPdiversion \fR[\fPstring\fR]]]\fP"
Read from standard input to diversion and/or string.
.
The text is saved in a diversion named
.IR diversion .
.
Recall the text by writing the name of the diversion after a dot
on an empty line.
.
A string is also defined if
.I string
is given.
.
.I Diversion
and/or
.I prompt
can be empty (\[dq]\[dq]).
.
.TP
.B RF
Reference end.
.
Ends a reference definition and returns to normal processing.
.
See
.BR RS .
.
.
.TP
.BR RI \~\c \" space in roman; we must use 2-font macro with \c
.RI [ roman-text\~\c
.RI [ italic-text ]]\~.\|.\|.
Join
.I roman-text
in roman style with
.I italic-text
in italics,
without space between the arguments.
.
.
.TP
.BI RL\  \fR[\fPtext-indent \fR[\fP1\fR]]\fP
Reference list start.
.
Begins a list where each item is preceded with an automatically
incremented number between square brackets.
.
.I text-indent
changes the default indentation.
.
.
.TP
.BR RP \~\c \" space in roman; we must use 2-font macro with \c
.RI [ suppress-counter-reset \~[ page-ejection-policy ]]
Format a reference page,
listing items accumulated within
.BR RS / RF
pairs.
.
The reference counter is reset unless the first argument
.RB is\~ 1 .
.
Normally,
page breaks occur before and after the references are output;
the register
.B Rpe
configures this behavior,
and a second argument overrides its value.
.
.B TC
calls
.B RP
automatically if references have accumulated.
.
.
.IP
References are list items,
and thus are vertically separated
(see
.BR LB ).
.
Setting register
.B Ls
.RB to\~ 0
suppresses this spacing.
.
The string
.B Rp
contains the reference page caption.
.
.
.TP
.BI RS\  \fR[\fPstring-name\fR]\fP
Begin an automatically numbered reference definition.
.
Put the string
.B \[rs]*(Rf
where the reference mark should be and write the reference between
.BR RS / RF
at next new line after the reference mark.
.
The reference number is stored in register
.BR :R .
.
If
.I string-name
is given, a string with that name is defined and contains the current
reference mark.
.
The string can be referenced as
.BI \[rs]*[ string-name ]
later in the text.
.
.TP
.BI S\  "\fR[\fPsize \fR[\fPspacing\fR]]\fP"
Set point size and vertical spacing.
.
If any argument is equal to \[lq]P\[rq],
the previous value is used.
.
A \[lq]C\[rq] means the current value,
and \[lq]D\[rq] the default value.
.
If \[lq]+\[rq] or \[lq]\-\[rq] is used before the value,
the current value is incremented or decremented, respectively.
.
.
.TP
.BR SA \~\c
.RI [ mode ]
Set or restore the default enablement of adjustment.
.
Specify
.B 0
or
.B 1
as
.I mode
to set a document's default explicitly;
.B 1
is assumed by
.IR mm .
.
Adjustment can be temporarily suspended with the
.B na
request.
.
When the
.B H
or
.B HU
macros are used to format a heading,
or when
.B SA
is called without a
.I mode
argument,
the default adjustment is restored.
.
.
.TP
.BI SETR\  "refname \fR[\fPstring\fR]\fP"
Remember the current header and page number as
.IR refname .
.
Saves
.I string
if
.I string
is defined.
.
.I string
is retrieved with
.BR .GETST .
.
See
.BR INITR .
.
.TP
.BI SG\  \fR[\fParg\  \fR[\fP1\fR]]\fP
Signature line.
.
Prints the authors name(s) after the formal closing.
.
The argument is appended to the reference data, printed at either the
first or last author.
.
The reference data is the location, department, and initials specified
with
.BR .AU .
.
It is printed at the first author if the second argument is given,
otherwise at the last.
.
No reference data is printed if the author(s) is specified through
.BR .WA / .WE .
.
See section \[lq]Internals\[rq] below.
.
.
.TP
.BR SK \~\c
.RI [ n ]
Skip
.I n
pages.
.
If
.I n
is\~0 or omitted,
the page is broken unless the drawing position is already at the top of
a page.
.
Otherwise,
.I n
pages,
blank except for any headers and footers,
are printed.
.
.
.TP
.BI SM\  "string1 \fR[\fPstring2 \fR[\fPstring3\fR]]\fP"
Make a string smaller.
.
If
.I string2
is given,
.I string1
is made smaller and
.I string2
stays at normal size,
concatenated with
.IR string1 .
.
With three arguments, everything is concatenated, but only
.I string2
is made smaller.
.
.TP
.BI SP\  \fR[\fPlines\fR]\fP
Space vertically.
.
.I lines
can have any scaling factor,
like \[lq]3i\[rq] or \[lq]8v\[rq].
.
Several
.B SP
calls in a line only produces the maximum number of lines, not the sum.
.
.B SP
is ignored also until the first text line in a page.
.
Add
.B \[rs]&
before a call to
.B SP
to avoid this.
.
.
.TP
.B TAB
Reset tab stops to every 5\~ens.
.
.
.br
.ne 4v
.TP
.BR TB \~\c
.RI [ title \~[ override \~[ flag \~[  refname ]]]]
Caption a table.
.
Arguments are handled analogously to
.BR EC .
.
The register
.B Tb
is the table counter.
.
The string
.B Litb
precedes the table number and any
.I title.
.
Table captions are centered irrespective of the alignment of any
enclosing display.
.
.
.IP
Captioned tables are listed in a table of contents
(see
.BR TC )
if the Boolean register
.B Lt
is true.
.
Such a list uses the string
.B Lt
as a heading.
.
.
.TP
.BI TC\  "\fR[\fPslevel \fR[\fPspacing \fR[\fPtlevel \fR[\fPtab \fR[\fPh1 \fR[\fPh2 \fR[\fPh3 \fR[\fPh4 \fR[\fPh5\fR]]]]]]]]]\fP"
Table of contents.
.
This macro is normally used as the last line of the document.
.
It flushes any pending displays and,
if any references are pending
(see
.BR RS ),
calls
.BR RP .
.
The pages of the table of contents are numbered with Roman numerals;
their appearance can be suppressed with the
.B Oc
register.
.
It generates a table of contents with headings up to the level
controlled by register
.BR Cl .
.
Note that
.B Cl
controls the saving of headings, it has nothing to do with
.BR TC .
.
Headings with a level less than or equal to
.I slevel
get
.I spacing
number of lines before them.
.
Headings with a level less than or equal to
.I tlevel
have their page numbers right\-justified with dots or spaces separating
the text and the page number.
.
Spaces are used if
.I tab
is greater than zero, dots otherwise.
.
Other headings have the page number directly at the end of the heading
text
.RI ( ragged-right ).
.
.IP
The rest of the arguments is printed, centered, before the table of
contents.
.
.IP
The user-defined macros
.B TX
and
.B TY
are used if
.B TC
is called with at most four arguments.
.
.B TX
is called before the printing of the string \[lq]CONTENTS\[rq],
and
.B TY
is called instead of printing \[lq]CONTENTS\[rq].
.
.IP
Equivalent macros can be defined for list of figures, tables, equations
and exhibits by defining
.BI TX xx
or
.BI TY xx\fR,\fP
where
.I xx
is \[lq]Fg\[rq],
\[lq]TB\[rq],
\[lq]EC\[rq],
or \[lq]EX\[rq],
respectively.
.
.IP
String
.B Ci
can be set to control the indentations for each heading-level.
.
It must be scaled, like
.
.RS
.IP
.EX
\&.ds Ci .25i .5i .75i 1i 1i
.EE
.RE
.
.IP
By default, the indentation is controlled by the maximum length of
headings in each level.
.
.IP
The strings
.BR Lifg ,
.BR Litb ,
.BR Liex ,
.BR Liec ,
and
.B Licon
contain \[lq]Figure\[rq],
\[lq]TABLE\[rq],
\[lq]Exhibit\[rq],
\[lq]Equation\[rq],
and \[lq]CONTENTS\[rq],
respectively.
.
These can be redefined to other languages.
.
.TP
.B TE
Table end.
.
See
.BR TS .
.
.TP
.B TH \fR[\fPN\fR]\fP
Table header.
.
See
.BR TS .
.
.B TH
ends the header of the table.
.
This header is printed again if a page break occurs.
.
Argument \[lq]N\[rq] isn't implemented yet.
.
.
.TP
.BR TL \~[\c
.IR charging-case-number \~[\c
.IR filing-case-number ]]
Begin collecting document title.
.
Text up to the next
.B AU
call is included in the title.
.
.I charging-case-number
and
.I filing-case-number
are saved for use in memorandum types 0 and 5.
.
See
.BR MT .
.
.
.TP
.BI TM\~ number\c
\~.\|.\|.
Declare technical memorandum number(s) used by
.BR MT .
.
.
.TP
.B TP
Top-of-page user-defined macro.
.
This macro is called instead of the normal page header.
.
It is possible to get complete control over the header.
.
Note that the header and the footer are printed in a separate
environment.
.
Line length is preserved, though.
.
See
.BR EOP .
.
.IP
.B strings available to TP
.RS
.TS
tab(@);
l l.
TPh@argument of \fBPH\fP
TPeh@argument of \fBEH\fP
TPoh@argument of \fBOH\fP
.TE
.RE
.
.TP
.B TS \fR[\fPH\fR]\fP
Table start.
.
This is the start of a table specification to
.MR @g@tbl @MAN1EXT@ .
.
.B TS
ends with
.BR TE .
.
Argument \[lq]H\[rq] tells
.I mm
that the table has a header.
.
See
.BR TH .
.
.TP
.B TX
.TQ
.B TY
See
.B TC
for descriptions of these user-definable hooks.
.
.
.TP
.BR VERBON \~\c \" space in roman; we must use 2-font macro with \c
.RI [ format \~[ type-size \~[ font ]]]
Begin verbatim display,
where characters have equal width.
.
.I format
controls several parameters.
.
Add up the values of desired features;
the default
.RB is\~ 0 .
.
.
.IP
.TS
tab(@);
lb lb
l lx.
Value@Effect
1@Disable the formatter's escape character (\[rs]).
2@Vertically space before the display.
4@Vertically space after the display.
8@T{
Number output lines; call formatter's
.B nm
request with arguments in string
.BR Verbnm .
T}
16@T{
Indent by the amount stored in register
.BR Verbin .
T}
.TE
.
.
.IP
On typesetting devices,
.I type-size
selects a different type size in scaled points,
and
.I font
chooses a face\[em]the default is Courier roman.
.
.
.TP
.B VERBOFF
End verbatim display.
.
.
.TP
.BI VL\  "text-indent \fR[\fPmark-indent\ " \fR[\fP1\fR]]\fP
Variable-item list.
.
It has no fixed mark, it assumes that every
.B LI
has a mark instead.
.
.I text-indent
sets the indent to the text, and
.I mark-indent
the distance from the current indentation to the mark.
.
A third argument prohibits printing of a blank line before each item.
.
.TP
.BI "VM \fR[\fP\-T\fR] [\fP" "top \fR[\fPbottom\fR]]\fP"
Vertical margin.
.
Increase the top and bottom margin by
.I top
and
.IR bottom ,
respectively.
.
If option
.B \-T
is specified, set those margins to
.I top
and
.IR bottom .
.
If no argument is given, reset the margin to zero, or to the default
(\[lq]7v 5v\[rq])
if
.B \-T
is used.
.
It is highly recommended that macros
.B TP
and/or
.B EOP
are defined if using
.B \-T
and setting top and/or bottom margin to less than the default.
.
This undocumented DWB
.I mm
macro is exposed by
.I groff mm
to increase user control of page layout.
.
.
.TP
.BI WA\  "\fR[\fPwriter-name \fR[\fPtitle\fR]]\fP"
Begin specification of the writer and writer's address.
.
Several names can be specified with empty
.BR WA / WE
pairs, but only one address.
.
.
.TP
.BI WC\  "\fR[\fPformat1\fR] [\fPformat2\fR] [.\|.\|.]\fP"
Footnote and display width control.
.
.RS
.TS
tab(@);
l lx.
N@T{
Set default mode which is equal to using the options
.BR \-WF ,
.BR \-FF ,
.BR \-WD ,
and
.BR FB .
T}
WF@T{
Wide footnotes, wide also in two-column mode.
T}
\-WF@Normal footnote width, follow column mode.
FF@T{
All footnotes gets the same width as the first footnote encountered.
T}
\-FF@T{
Normal footnotes, width follows \fBWF\fP and \fB\-WF\fP.
T}
WD@T{
Wide displays, wide also in two-column mode.
T}
\-WD@T{
Normal display width, follow column mode.
T}
FB@T{
Floating displays generates a line break when printed on the current
page.
T}
\-FB@T{
Floating displays does not generate line break.
T}
.TE
.RE
.
.
.TP
.B WE
End the address specification after
.BR WA .
.
.
.\" ====================================================================
.SH Strings
.\" ====================================================================
.
Many
.I mm
strings interpolate predefined,
localizable text.
.
These are presented in quotation marks.
.
.
.TP
.B App
\[lq]APPENDIX\[rq]
.
.
.TP
.B Apptxt
stores the
.I title
argument to the last
.B APP
call.
.
.
.TP
.B BU
interpolates a bullet
(see
.BR BL ).
.
.
.TP
.B Ci
list of indentation amounts to use for table of contents heading levels,
overriding automatic computation
.
.
.TP
.B DT
The date;
set by the
.B ND
macro
(defaults to the date the document is formatted).
.
The format is the conventional one for the
.I groff
locale,
but see the
.B ISODATE
macro and
.B Iso
register.
.
.
.TP
.B EM
interpolates an em dash.
.
.
.TP
.B F
interpolates an automatically numbered footnote marker;
the number is used by the next
.B FS
call without an argument.
.
In
.I troff
mode,
the marker is superscripted;
in
.I nroff
mode,
it is surrounded by square brackets.
.
.
.TP
.B H1txt
Updated by
.B .H
and
.B .HU
to the current heading text.
.
Also updated in table of contents & friends.
.
.
.TP
.B HF
assigns font identifiers,
separated by spaces,
to heading levels in one-to-one correspondence.
.
Each identifier may be a font mounting position,
font name,
or style name.
.
Omitted values are assumed to be\~1.
.
The default is
.RB \[lq] "2 2 2 2 2 2 2 2 2 2 2 2 2 2" \[rq],
which places all headings in italics.
.
DWB
.IR mm 's
default was
.RB \[lq] "3 3 2 2 2 2 2" \[rq].
.
.
.TP
.B HP
assigns type sizes,
separated by spaces,
to heading levels in one-to-one correspondence.
.
Each size is interpreted in scaled points;
zero values are translated to
.BR 10 .
.
Omitted values are assumed to be\~0
(and are translated accordingly).
.
The default is
.RB \[lq] "0 0 0 0 0 0 0 0 0 0 0 0 0 0" \[rq].
.
.
.TP
.B Index
\[lq]INDEX\[rq]
.
.
.TP
.B Indcmd
Contains the index command.
.
Default value is
.RB \[lq] sort\~\-t\[rs]t \[rq].
.
.
.TP
.B Le
\[lq]LIST OF EQUATIONS\[rq]
.
.
.TP
.B Letfc
\[lq]Yours very truly,\[rq]
(see
.BR FC )
.
.
.TP
.B Letapp
\[lq]APPROVED:\[rq]
(see
.BR AV )
.
.
.TP
.B LetAT
\[lq]ATTENTION:\[rq]
(see
.BR LO )
.
.
.TP
.B LetCN
\[lq]CONFIDENTIAL\[rq]
(see
.BR LO )
.
.
.TP
.B Letdate
\[lq]Date\[rq]
(see
.BR AV )
.
.
.TP
.B Letns
is an array containing the different strings used in
.BR .NS .
.
Since
.I roff
languages lack true array types,
it is implemented as a set of strings prefixed with
.BR Letns! .
.
If the argument doesn't exist, it is included between
.B ()
with
.B Letns!copy
as a prefix and
.B Letns!to
as a suffix.
.
Observe the space after \[lq]Copy\[rq] and before \[lq]to\[rq].
.
.
.RS
.IP
.TS
tab(@);
lb lb
l l.
Name@Value
Letns!0@Copy to
Letns!1@Copy (with att.\&) to
Letns!2@Copy (without att.\&) to
Letns!3@Att.
Letns!4@Atts.
Letns!5@Enc.
Letns!6@Encs.
Letns!7@Under separate cover
Letns!8@Letter to
Letns!9@Memorandum to
Letns!10@Copy (with atts.\&) to
Letns!11@Copy (without atts.\&) to
Letns!12@Abstract Only to
Letns!13@Complete Memorandum to
Letns!14@CC
Letns!copy@Copy \fI(with trailing space)\fP
Letns!to@ to \fI(note leading space)\fP
.TE
.RE
.
.
.TP
.B Letnsdef
Define the standard notation used when no argument is given to
.BR .NS .
.
Default is\~0.
.
.
.TP
.B LetRN
\[lq]In reference to:\[rq]
(see
.BR LO )
.
.
.TP
.B LetSA
\[lq]To Whom It May Concern:\[rq]
(see
.BR LO )
.
.
.TP
.B LetSJ
\[lq]SUBJECT:\[rq]
(see
.BR LO )
.
.
.TP
.B Lf
\[lq]LIST OF FIGURES\[rq]
.
.
.TP
.B Licon
\[lq]CONTENTS\[rq]
.
.
.TP
.B Liec
\[lq]Equation\[rq]
.
.
.TP
.B Liex
\[lq]Exhibit\[rq]
.
.
.TP
.B Lifg
\[lq]Figure\[rq]
.
.
.TP
.B Litb
\[lq]TABLE\[rq]
.
.
.TP
.B Lt
\[lq]LIST OF TABLES\[rq]
.
.
.TP
.B Lx
\[lq]LIST OF EXHIBITS\[rq]
.
.
.TP
.BR MO1 \|.\|.\|.\| MO12
\[lq]January\[rq] through \[lq]December\[rq]
.
.
.TP
.B Qrf
\[lq]See chapter \[rs]\[rs]*[Qrfh],
page \[rs]\[rs]n[Qrfp].\[rq]
.
.
.TP
.B Rp
\[lq]REFERENCES\[rq]
.
.
.
.TP
.B Sm
interpolates
.if c \[u2120] \[u2120],
the service mark sign.
.
.
.TP
.B Tcst
Contains the current status of the table of contents and list of
figures, etc.
.
Empty outside of
.BR .TC .
.
Useful in user-defined macros like
.BR .TP .
.
.RS
.IP
.TS
tab(@);
lb lb
l l.
Value@Meaning
co@Table of contents
fg@List of figures
tb@List of tables
ec@List of equations
ex@List of exhibits
ap@Appendix
.TE
.RE
.
.
.TP
.B Tm
interpolates
.if c \[tm] \[tm],
the trade mark sign.
.
.
.TP
.B Verbnm
Argument to
.B .nm
in the
.B .VERBON
macro.
.
Default is\~1.
.
.
.br
.ne 4v
.\" ====================================================================
.SH Registers
.\" ====================================================================
.
Default register values,
where meaningful,
are shown in parentheses.
.
Many are also marked as Boolean-valued,
meaning that they are considered \[lq]true\[rq]
(on,
enabled)
when they have a positive value,
and \[lq]false\[rq]
(off,
disabled)
otherwise.
.
.
.TP
.B .mgm
indicates that
.I groff mm
is in use
(Boolean-valued;
.BR 1 ).
.
.
.TP
.B :p
is an auto-incrementing footnote counter;
see
.BR FS .
.
.
.TP
.B :R
is an auto-incrementing reference counter;
see
.BR RS .
.
.
.TP
.B Aph
formats an appendix heading
(and title,
if supplied);
see
.B APP
(Boolean-valued;
.BR 1 ).
.
.
.TP
.B Au
includes supplemental author information
(the third and subsequent arguments to
.BR AU )
in memorandum \[lq]from\[rq] information;
see
.B COVER
and
.B MT
(Boolean-valued;
.BR 1 ).
.
.
.TP
.B Cl
sets the threshold for inclusion of headings in a table of contents.
.
Headings at levels above this value are excluded;
see
.B H
and
.B TC
.RB ( 2 ).
.
.
.TP
.B Cp
suppresses page breaks before lists of captioned
equations,
exhibits,
figures,
and tables,
and before an index;
see
.BR EC ,
.BR EX ,
.BR FG ,
.BR TB ,
and
.B INDP
(Boolean-valued;
.\" DWB 3.3's manual said this was 1, but the code said 0.
.BR 0 ).
.
.
.TP
.B D
produces debugging information for the
.I mm
package on the standard error stream.
.
A value of\~0 outputs nothing;
1\~reports formatting progress.
.
Higher values communicate internal state information of increasing
verbosity
.RB ( 0 ).
.
.
.TP
.B De
causes a page break after a floating display is output;
see
.B DF
(Boolean-valued;
.BR 0 ).
.
.
.TP
.B Df
configures the behavior of
.BR DF .
.
The following values are recognized;
4 and 5 do not override the
.B De
register
.RB ( 5 ).
.
.
.IP
.TS
tab(@);
Lb Lb
L Lx.
Value@Effect
0@T{
Flush pending displays
at the end of each section
when section-page numbering is active,
otherwise at the end of the document.
T}
1@T{
Flush a pending display
on the current page or column
if there is enough space,
otherwise at the end of the document.
T}
2@T{
Flush one pending display
at the top of each page or column.
T}
3@T{
Flush a pending display
on the current page or column
if there is enough space,
otherwise at the top of the next.
T}
4@T{
Flush as many pending displays
as possible in a new page or column.
T}
5@T{
Fill columns or pages with flushed displays
until none remain.
T}
.TE
.
.
.TP
.B Ds
puts vertical space in the amount of register
.B Dsp
(if defined) or
.B Lsp
before and after each static display;
see
.B DS
(Boolean-valued;
.BR 1 ).
.
.
.TP
.B Dsp
configures the amount of vertical space placed
before and after static displays;
see
.B DS
and register
.B Ds
.RI ( undefined ).
.
.
.TP
.B Ec
is an auto-incrementing equation counter;
see
.BR EC .
.
.
.TP
.B Ej
sets the threshold for page breaks (ejection) prior to the format of
headings.
.
Headings at levels above this value are set on the same page and column
if possible;
see
.B H
.RB ( 0 ).
.
.
.TP
.B Eq
aligns an equation label to the left of a display instead of the right
(Boolean-valued;
.BR 0 ).
.
.
.TP
.B Ex
is an auto-incrementing exhibit counter;
see
.BR EX .
.
.
.TP
.B Fg
is an auto-incrementing figure counter;
see
.BR FG .
.
.
.TP
.B Fs
is multiplied by register
.B Lsp
to vertically separate footnotes;
see
.B FS
.RB ( 1 ).
.
.
.TP
.BR H1 \|.\|.\|.\| H14
are auto-incrementing counters corresponding to each heading level;
see
.BR H .
.
.
.\" XXX: This could be generalized to an "Hdot" threshold register with
.\" a default of 2.
.TP
.B H1dot
appends a period to the number of a level one heading;
see
.B H
(Boolean-valued;
.BR 1 ).
.
.
.\" XXX: This may be insufficiently general; see Savannah #62825.
.TP
.B H1h
is a copy of
A copy of register
.RB register\~ H1 ,
but it is incremented just before a page break.
.
This can be useful in user-defined macros;
see
.B H
and
.BR HX .
.
.
.TP
.B Hb
sets the threshold for breaking the line after formatting a heading.
.
Text after headings at levels above this value are set on the same
output line if possible;
see
.B H
.RB ( 2 ).
.
.
.TP
.B Hc
sets the threshold for centering a heading.
.
Headings at levels above this value use the prevailing alignment
(that is,
they are not centered);
see
.B H
.RB ( 0 ).
.
.
.TP
.B Hi
configures the indentation of text after headings.
.
It does not affect \[lq]run-in\[rq] headings.
.
The following values are recognized;
see
.B H
and
.B P
.RB ( 1 ).
.
.
.IP
.TS
tab(@);
Lb Lb
L Lx.
Value@Effect
0@no indentation
1@indent per the paragraph type
2@indent to align with heading title
.TE
.
.
.TP
.B Hps
sets the heading level threshold for application of preceding vertical
space;
see
.BR H .
.
Headings at levels above the value in register
.B Hps
use the amount of space in register
.BR Hps1 ;
otherwise that in
.BR Hps2 .
.
The value of
.B Hps
should be strictly greater than that of
.B Ej
.RB ( 1 ).
.
.
.TP
.B Hps1
configures the amount of vertical space preceding a heading above the
.B Hps
threshold;
see
.B H
.RI ( troff
devices:
.BR 0.5v ;
.I nroff
devices:
.BR 1v ).
.
.
.TP
.B Hps2
configures the amount of vertical space preceding a heading at or below
the
.B Hps
threshold;
see
.B H
.RI ( troff
devices:
.BR 1v ;
.I nroff
devices:
.BR 2v ).
.
.
.TP
.B Hs
sets the heading level threshold for application of succeeding vertical
space.
.
If the heading level is greater than this value,
the heading is followed by vertical space in the amount of
.RB register\~ Hss ;
see
.B H
.RB ( 2 ).
.
.
.TP
.B Hss
is multiplied by register
.B Lsp
to produce vertical space after headings above the
threshold in
.RB register\~ Hs ;
see
.B H
.RB ( 1 ).
.
.
.TP
.B Ht
suppresses output of heading level counters above the lowest when the
heading is formatted;
see
.B H
(Boolean-valued;
.BR 0 ).
.
.
.
.TP
.B Hu
sets the heading level used by unnumbered headings;
see
.B HU
.RB ( 2 ).
.
.
.TP
.B Hy
enables automatic hyphenation of words
(Boolean-valued;
.BR 0 ).
.
.
.TP
.B Iso
configures the use of ISO\~8601 date format
if specified
(with any value)
on the command line;
see
.BR ISODATE .
.
The default is determined by localization files.
.
.
.TP
.B L
defines the page length for the document,
and must be set from the command line.
.
A scaling unit should be appended.
.
The default is that of the selected
.I groff
output device.
.
.
.TP
.B Le
.TQ
.B Lf
.TQ
.B Lt
.TQ
.B Lx
configures the report of lists of equation,
figure,
table,
and exhibit captions,
respectively,
after a table of contents;
see
.B TC
(Boolean-valued;
.BR Le :\~ 0 ;
.BR Lf ,
.BR Lt ,
.BR Lx :\~ 1 ).
.
.
.\" XXX: What is the rationale for this feature?
.TP
.B Letwam
sets the maximum number of input lines permitted in a writer's address;
see
.B WA
and
.B WE
.RB ( 14 ).
.
.
.TP
.B Li
configures the amount of indentation in ens applied to list items;
see
.B LI
.RB ( 6 ).
.
.
.TP
.B Limsp
inserts a space between the prefix and the mark
in automatically numbered lists;
see
.B AL
(Boolean-valued;
.BR 1 ).
.
.
.TP
.B Ls
sets a threshold for placement of vertical space before list items.
.
If the list nesting level is greater than this value,
no such spacing occurs;
see
.B LI
.RB ( 99 ).
.
.
.TP
.B Lsp
configures the base amount of vertical space used for separation
in the document.
.
.I mm
applies this spacing to many contexts,
sometimes with multipliers;
see
.BR DS ,
.BR FS ,
.BR H ,
.BR LI ,
and
.B P
.RI ( troff
devices:
.BR 0.5v ;
.I nroff
devices:
.BR 1v ).
.
.
.TP
.B N
configures the header and footer placements used by
.BR PH .
.
The default footer is empty.
.
If \[lq]section-page\[rq] numbering is selected,
the default header becomes empty
and the default footer becomes
.RI \[lq] x - y \[rq],
where
.IR x \~is
is the section number
(the number of the current first-level heading)
.RI and\~ y
the page number within the section.
.\" XXX: section-figure numbering needs more documentation.
.
The following values are recognized;
for finer control,
see
.BR PH ,
.BR PF ,
.BR EH ,
.BR EF ,
.BR OH ,
and
.BR OF ,
and registers
.B Sectf
and
.BR Sectp .
.
Value 5 is a GNU extension
.RB ( 0 ).
.
.
.IP
.TS
tab(@);
Lb Lb
L Lx.
Value@Effect
0@Set header on all pages.
1@Move header to footer on page 1.
2@Omit header on page 1.
3@Use \[lq]section-page\[rq] numbering style on all pages.
4@Omit header on all pages.
5@T{
Use \[lq]section-page\[rq] and \[lq]section-figure\[rq] \
numbering style on all pages.
T}
.TE
.
.
.TP
.B Np
causes paragraphs after first-level headings (only) to be numbered
in the format
.IR s . p ,
where
.IR s \~is
is the section number
(the number of the current first-level heading)
and
.IR p \~is
the paragraph number,
starting at 1;
see
.B H
and
.B P
(Boolean-valued;
.BR 0 ).
.
.
.TP
.B O
defines the page offset of the document,
and must be set from the command line.
.
A scaling unit should be appended.
.
The default
.RB is\~ \&.75i
on terminal devices.
.
On typesetters,
it is
.B \&.963i
or set to
.B 1i
by the
.I papersize.tmac
package;
see
.MR groff_tmac @MAN5EXT@ .
.
.
.TP
.B Oc
suppresses the appearance of page numbers in the table of contents;
see
.B TC
(Boolean-valued;
.BR 0 ).
.
.
.\" XXX: This really should just be a string, shouldn't it?
.TP
.B Of
selects a separator format within equation,
exhibit,
figure,
and table captions;
see
.BR EC ,
.BR EX ,
.BR FG ,
and
.BR TB .
.
The following values are recognized;
the spaces shown are unpaddable
.RB ( 0 ).
.
.
.IP
.TS
tab(@);
Lb Lb
L Lx.
Value@Effect
0@\[dq].  \[dq]
1@\[dq] \[em] \[dq]
.TE
.
.
.TP
.B P
interpolates the current page number;
it is the same as
.RB register\~ %
except when
\[lq]section-page\[rq] numbering is enabled.
.
.
.TP
.B Pi
configures the amount of indentation in ens applied to the first line of
a paragraph;
see
.B P
.RB ( 5 ).
.
.
.TP
.B Pgps
causes the type size and vertical spacing set by
.B S
to apply to headers and footers,
overriding the
.B HP
string.
.
If not set,
.B S
calls affect headers and footers only when followed by
.BR PH ,
.BR PF ,
.BR OH ,
.BR EH ,
.BR OF ,
or
.B OE
calls
(Boolean-valued;
.BR 1 ).
.
.
.TP
.B Ps
is multiplied by register
.B Lsp
to vertically separate paragraphs;
see
.B P
.RB ( 1 ).
.
.
.TP
.B Pt
determines when a first-line indentation is applied to a paragraph;
see
.B P
.RB ( 0 ).
.
.
.IP
.TS
tab(@);
Lb Lb
L Lx.
Value@Effect
0@never
1@always
2@T{
always,
except immediately after
.BR H ,
.BR DE ,
or
.B LE
T}
.TE
.
.
.\" XXX: Why is this not named `Rpej`?
.TP
.B Rpe
configures the default page ejection policy for reference pages;
see
.B RP
.RB ( 0 ).
.
.
.IP
.TS
tab(@);
Lb Lb
L Lx.
Value@Effect
0@Break the page before and after the list of references.
1@Suppress page break after the list.
2@Suppress page break before the list.
3@Suppress page breaks before and after the list.
.TE
.
.
.TP
.B S
defines the type size for the document,
and must be set from the command line.
.
A scaling unit should be appended;
.B p
is typical
.RB ( 10p ).
.
.
.TP
.B Sectf
selects the \[lq]section-figure\[rq] numbering style.
.
Its default
.RB is\~ 0
unless
.RB register\~ N
is set
.RB to\~ 5
at the command line
(Boolean-valued).
.
.
.TP
.B Sectp
selects the \[lq]section-page\[rq] numbering style.
.
Its default
.RB is\~ 0
unless
.RB register\~ N
is set
.RB to\~ 3
.RB or\~ 5
at the command line
(Boolean-valued).
.
.
.TP
.B Si
configures the amount of display indentation in ens;
see
.B DS
.RB ( 5 ).
.
.
.TP
.B Tb
is an auto-incrementing table counter;
see
.BR TB .
.
.
.TP
.B V
defines the vertical spacing for the document,
and must be set from the command line.
.
A scaling unit should be appended;
.B p
is typical.
.
The default vertical spacing is 120% of the type size.
.
.
.TP
.B Verbin
configures the amount of indentation for verbatim displays
when indentation is selected;
see
.B \%VERBON
.RB ( 5n ).
.
.
.TP
.B W
defines the \[lq]width\[rq]
of the document
(that is,
the length of an output line with no indentation);
it must be set from the command line.
.
A scaling unit should be appended.
.
The default
.RB is\~ 6i
or assigned by the
.I papersize.tmac
package;
see
.MR groff_tmac @MAN5EXT@ .
.
.
.
.\" ====================================================================
.SH Internals
.\" ====================================================================
.
The letter macros use different submacros depending on the
letter type.
.
The name of the submacro has the letter type as suffix.
.
It is therefore possible to define other letter types,
either in the territory-specific macro file,
or as local additions.
.
.B .LT
sets the registers
.B Pt
and
.B Pi
to 0 and\~5,
respectively.
.
The following strings and macros must be defined for a new letter type.
.
.TP
.BI let@init_ type
This macro is called directly by
.BR .LT .
.
It is supposed to initialize registers and other stuff.
.
.TP
.BI let@head_ type
This macro prints the letter head,
and is called instead of the normal page header.
.
It is supposed to remove the alias
.BR let@header ,
otherwise it is called for all pages.
.
.
.TP
.BI let@sg_ type\~\c
.IR "name title n is-surname\~" [ SG-arg\~ .\|.\|.]
.B .SG
calls this macro only for letters;
memoranda have their own processing.
.
.I name
and
.I title
are specified through
.BR .WA / .WE .
.
.IR n \~is
the index of the
.IR n th
author,
and
.I is-surname
is true for the last name.
.
Further
.B .SG
arguments are appended to the signature line.
.
.
.TP
.BI let@fc_ "type closing"
This macro is called by
.BR .FC ,
and has the formal closing as the argument.
.
.
.LP
.B .LO
is implemented as a general option-macro.
.
It demands that a string named
.BI Let type
is defined, where
.I type
is the letter type.
.
.B .LO
then assigns the argument to the string
.BI let*lo- type\fR.\fP
.
.
.\" ====================================================================
.\".SH BUGS
.\" ====================================================================
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @MACRODIR@/@TMAC_M_PREFIX@m.tmac
is the
.I groff
implementation of the memorandum macros.
.
.
.TP
.I @MACRODIR@/mm.tmac
is wrapper to load
.IR m.tmac .
.
.
.TP
.I @MACRODIR@/refer\-mm.tmac
implements
.MR @g@refer @MAN1EXT@
support for
.IR mm .
.
.
.TP
.I @TMAC_MDIR@/ms.cov
implements an
.IR ms -like
cover sheet.
.
.
.TP
.I @TMAC_MDIR@/0.MT
implements memorandum types 0\[en]3 and 6.
.
.
.TP
.I @TMAC_MDIR@/4.MT
implements memorandum type 4.
.
.
.TP
.I @TMAC_MDIR@/5.MT
implements memorandum type 5.
.
.
.TP
.I @TMAC_MDIR@/locale
performs any (further) desired necessary localization;
empty by default.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The GNU version of the
.I mm
macro package was written by
.MT jh@\:axis\:.se
J\[:o]rgen H\[:a]gg
.ME
of Lund, Sweden.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.UR https://tkurtbond\:.github\:.io/\:troff/\:mm\-all\:.pdf
.I MM \- A Macro Package for Generating Documents
.UE ,
the DWB\~3.3
.I mm
manual,
introduces the package but does not document GNU extensions.
.
.
.P
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.P
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR @g@tbl @MAN1EXT@ ,
.MR @g@pic @MAN1EXT@ ,
.MR @g@eqn @MAN1EXT@ ,
.MR @g@refer @MAN1EXT@ ,
.MR groff_mmse @MAN7EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_mm_7_man_C]
.do rr *groff_groff_mm_7_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
