.TH afmtodit @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
afmtodit \- adapt Adobe Font Metrics files for groff \-Tps and \-Tpdf
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_afmtodit_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY afmtodit
.OP \-ckmnsx
.OP \-a n
.OP \-d desc-file
.OP \-e enc-file
.OP \-f internal-name
.OP \-i n
.OP \-o output-file
.I afm-file
.I map-file
.I font
.YS
.
.
.SY afmtodit
.B \-v
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I afmtodit
converts an
Adobe Font Metric
file,
.IR afm-file ,
for use with the
.B ps
and
.B pdf
output drivers of
.IR groff (@MAN1EXT@).
.
.I map-file
associates a
.I groff
character name with a PostScript character name.
.
Output is written to
.IR font,
a file named for the intended
.I groff
font name
(but see the
.B -o
option).
.
.
.LP
.I afm-file
should contain a sequence of lines of the form
.
.RS
.EX
.I ps-char groff-char
.EE
.RE
.
where
.I ps-char
is the PostScript name of the character and
.I groff-char
is the
.I groff
name of the character
(as used in the
.I groff
font file).
.
The same
.I ps-char
can occur multiple times in the file;
each
.I groff-char
must occur at most once.
.
Lines starting with \[lq]#\[rq] and blank lines are ignored.
.
If the file isn't found in the current directory,
it is sought in the
.I devps/generate
subdirectory of the default font directory.
.
.
.LP
If a PostScript character is not mentioned in
.IR map-file ,
and a generic
.I groff
glyph name can't be deduced using the Adobe Glyph List
(AGL,
built into
.IR afmtodit ),
then
.I afmtodit
puts the PostScript character into the
.I groff
font file as an unnamed character which can only be accessed by the
\[lq]\eN\[rq] escape sequence in a
.I roff
document.
.
In particular,
this is true for glyph variants named in the form
.RI \[lq] foo . bar \[lq];
all glyph names containing one or more periods are mapped to unnamed
entities.
.
Unless
.B \-e
is specified,
the encoding defined in the AFM file
(i.e.,
entries
with non-negative character codes)
is used.
.
Refer to section \[lq]Using Symbols\[rq] in
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual,
which describes how
.I groff
glyph names are constructed.
.
.
.LP
Characters not encoded in the AFM file
(i.e.,
entries which have \[lq]\-1\[rq] as the character code)
are still available in
.IR groff ;
they get glyph index values greater than 255
(or greater than the biggest character code used in the AFM file in the
unlikely case that it is greater than 255)
in the
.I groff
font file.
.
Glyph indices of unencoded characters don't have a specific order;
it is best to access them with glyph names only.
.
.
.LP
If there is a downloadable font file for the font,
it may be listed in the file
.IR \%@FONTDIR@/\:\%devps/\:\%download ;
see
.IR grops (@MAN1EXT@).
.
.
.LP
If the
.B \-i
option is used,
.I afmtodit
automatically generates an italic correction,
a left italic correction,
and a subscript correction for each character
(the significance of these is explained in
.IR groff_font (@MAN5EXT@));
they be specified for individual characters by
adding to the
.I afm-file
lines of the form:
.
.RS
.EX
.RI italicCorrection \~ps-char\~n
.RI leftItalicCorrection \~ps-char\~n
.RI subscriptCorrection \~ps-char\~n
.EE
.RE
.
where
.I ps-char
is the PostScript name of the character,
and
.I n
is the desired value of the corresponding parameter in thousandths of an
em.
.
Such parameters are normally needed only for italic
(or oblique)
fonts.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.TP
.BI \-a\~ n
Use
.I n
as the slant parameter in the font file;
this is used by
.I groff
in the positioning of accents.
.
By default
.I afmtodit
uses the negative of the
.B ItalicAngle
specified in the AFM file;
with true italic fonts it is sometimes desirable to use a slant that is
less than this.
.
If you find that characters from an italic font have accents placed too
far to the right over them,
then use the
.B \-a
option to give the font a smaller slant.
.
.
.TP
.B \-c
Include comments in the font file in order to identify the PostScript
font.
.
.
.TP
.BI \-d\~ desc-file
The device description file is
.I desc-file
rather than the default
.IR DESC .
.
If not found in the current directory,
the
.I devps
subdirectory of the default font directory is searched
(this is true for both the default device description file and a file
given with option
.BR \-d ).
.
.
.TP
.BI \-e\~ enc-file
The PostScript font should be reencoded to use the encoding described
in
.IR enc-file .
.
The format of
.I enc-file
is described in
.IR grops (@MAN1EXT@).
.
If not found in the current directory,
the
.I devps
subdirectory of the default font directory is searched.
.
.
.TP
.BI \-f\~ name
The internal name of the
.I groff
font is set to
.IR name .
.
.
.TP
.BI \-i\~ n
Generate an italic correction for each character so that the
character's width plus the character's italic correction is equal to
.I n
thousandths of an em
plus the amount by which the right edge of the character's bounding box
is to the right of the character's origin.
.
If this would result in a negative italic correction,
use a zero italic correction instead.
.
.
.IP
Also generate a subscript correction equal to the
product of the tangent of the slant of the font and
four fifths of the x-height of the font.
.
If this would result in a subscript correction greater than the italic
correction,
use a subscript correction equal to the italic correction instead.
.
.
.IP
Also generate a left italic correction for each character
equal to
.I n
thousandths of an em
plus the amount by which the left edge of the character's bounding box
is to the left of the character's origin.
.
The left italic correction may be negative unless option
.B \-m
is given.
.
.
.IP
This option is normally needed only with italic
(or oblique)
fonts.
.
The font files distributed with
.I groff
were created using an option of
.B \-i50
for italic fonts.
.
.
.TP
.BI \-o\~ output-file
The output file is
.I output-file
instead of
.IR font .
.
.
.TP
.B \-k
Omit any kerning data from the
.I groff
font;
use only for monospaced (constant-width) fonts.
.
.
.TP
.B \-m
Prevent negative left italic correction values.
.
Roman font files distributed with
.I groff
were created with
.B \-i0\ \-m
to improve spacing with
.IR \%@g@eqn (@MAN1EXT@).
.
.
.TP
.B \-n
Don't output a
.B ligatures
command for this font;
use with monospaced (constant-width) fonts.
.
.
.TP
.B \-s
The font is special;
add the
.B special
command to the font file.
.
.
.TP
.B \-v
Write version information to the standard output stream and exit.
.
.
.TP
.B \-x
Don't use the built-in Adobe Glyph List.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@FONTDIR@/\:\%devps/\:DESC
Device description file.
.
.
.TP
.IR \%@FONTDIR@/\:\%devps/\: F
Font description file for font
.IR F .
.
.
.TP
.I \%@FONTDIR@/\:\%devps/\:\%download
List of downloadable fonts.
.
.
.TP
.I \%@FONTDIR@/\:\%devps/\:text.enc
Encoding used for text fonts.
.
.
.TP
.I \%@FONTDIR@/\:\%devps/\:\%generate/\:textmap
Standard mapping.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
Section \[lq]Using Symbols\[rq] may be of particular note.
.
You can browse it interactively with \[lq]info \[aq](groff)Using
\%Symbols\[aq]\[rq].
.
.
.LP
.IR groff (@MAN1EXT@),
.IR gropdf (@MAN1EXT@),
.IR grops (@MAN1EXT@),
.IR groff_font (@MAN5EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_afmtodit_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
