.TH addftinfo @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
addftinfo \- add font metrics to troff fonts for use with groff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_addftinfo_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY addftinfo
.OP \-asc\-height n
.OP \-body\-depth n
.OP \-body\-height n
.OP \-cap\-height n
.OP \-comma\-depth n
.OP \-desc\-depth n
.OP \-fig\-height n
.OP \-x\-height n
.I resolution
.I unit-width
.I font
.YS
.
.
.SY addftinfo
.B \-\-help
.YS
.
.
.SY addftinfo
.B \-v
.
.SY addftinfo
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I addftinfo
reads an
.RI AT&T \~troff
font file
.IR font ,
adds additional font metric information required by
.IR groff ,
and writes the combined result to the standard output.
.
The information added is guessed using some parametric information about
the font and assumptions about the traditional
.I troff
names for characters.
.
Among the font metrics added are the heights and depths of characters
(how far each extends vertically above and below the baseline).
.
The
.I resolution
and
.I unit-width
arguments should be the same as the corresponding parameters in the
.I DESC
file.
.
.I font
is the name of the file describing the font;
if
.I font
ends with
.RB \[lq] I \[rq],
the font is assumed to be italic.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.LP
All other options change one of the parameters that are used to derive
the heights and depths.
.
Like the existing quantities in the font file,
each
.RI value\~ n
is in
.RI inches/ resolution
for a font whose point size is
.IR unit-width .
.
.
.TP
.BI \-asc\-height \~n
The height of characters with ascenders,
such as \[lq]b\[rq], \[lq]d\[rq], or \[lq]l\[rq].
.
.
.TP
.BI \-body\-depth \~n
The depth of characters such as parentheses.
.
.
.TP
.BI \-body\-height \~n
The height of characters such as parentheses.
.
.
.TP
.BI \-cap\-height \~n
The height of uppercase letters such as \[lq]A\[rq].
.
.
.TP
.BI \-comma\-depth \~n
The depth of a comma.
.
.
.TP
.BI \-desc\-depth \~n
The depth of characters with descenders,
such as \[lq]p\[rq], \[lq]q\[rq], or \[lq]y\[rq].
.
.
.TP
.B \-fig\-height
The height of figures (digits, numerals).
.
.
.TP
.BI \-x\-height \~n
The height of lowercase letters without ascenders such as \[lq]x\[rq].
.
.
.LP
.I addftinfo
makes no attempt to use the specified parameters to guess the
unspecified parameters.
.
If a parameter is not specified,
the default will be used.
.
The defaults are chosen to have reasonable values for a Times font.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR groff_font (@MAN5EXT@),
.IR groff (@MAN1EXT@),
.IR groff_char (@MAN7EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_addftinfo_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
