'\" p
.TH @g@soelim @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@soelim \- recursively interpolate source requests in roff files
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_soelim_1_man_C \n[.cp]
.cp 0
.\" Man pages are seldom preprocessed with pic(1).
.mso pic.tmac
.
.
.\" ====================================================================
.\" Definitions
.\" ====================================================================
.
.ie t .ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el   .ds tx TeX
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@soelim
.RB [ \-Crt ]
.RB [ \-I
.IR dir ]
.RI [ input-file
\&.\|.\|.\&]
.YS
.
.
.SY @g@soelim
.B \-\-help
.YS
.
.
.SY @g@soelim
.B \-v
.
.SY @g@soelim
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I \%@g@soelim
replaces lines of the form
.RB \[lq] .so
.IR macro-file \[rq]
within each
.I input-file
with the contents of
.IR macro-file ,
recursively.
.
It is useful if files included with
.B .so
need to be preprocessed.
.
Output is written to the standard output stream.
.
Normally,
.I \%@g@soelim
should be invoked with
.IR groff 's
.B \-s
option.
.
In the absence of
.I input-file
arguments,
.I soelim
reads the standard input stream.
.
.
.PP
To embed a backslash
.RB \[lq] \[rs] \[rq]
in the name of a
.IR macro-file ,
write
.RB \[lq] \[rs]\[rs] \[rq]
or
.RB \[lq] \[rs]e \[rq].
.
To embed a space,
write
.RB \[lq] \[rs]\~ \[rq]
(backslash followed by a space).
.
Any other escape sequence in
.IR macro-file ,
including
.RB \[lq] \[rs][rs] \[rq],
makes
.I \%@g@soelim
ignore the whole line.
.
.
.PP
There must be no whitespace between the leading dot and the two
characters \[lq]s\[rq] and \[lq]o\[rq].
.
Otherwise,
only
.I groff
will interpret the
.B .so
request;
.I \%@g@soelim
will ignore it
(but see the
.B \-C
option below).
.
.
.PP
The normal processing sequence of
.I groff
is as follows.
.
.\" Does this groff installation use a command prefix?  In installed
.\" pages, this comparison will not look like it needs to be dynamically
.\" decided.
.\"
.\" This is done so that the box sizes (in the pic(1) diagram) and arrow
.\" alignments (in the text alternative) can remain fixed.
.if !'@g@'' \{\
In the diagrams below,
the traditional names for
.I soelim
and
.I troff
are used;
on this system,
the GNU versions are installed as
.I \%@g@soelim
and
.IR \%@g@troff .
.\}
.
.
.PP
.ie t \{\
.PS
.ps 10
.vs 12
box invisible width 0.5 height 0.4 "input" "file";
move to last box .bottom;
down;
arrow 0.3;
box invisible width 0.8 height 0.2 "preprocessor";
move to last box .right
right;
arrow 0.3;
A: box invisible width 0.35 height 0.2 "troff";
move to last box .top;
up;
move 0.3;
box invisible width 0.6 height 0.4 "sourced" "file";
line <- up 0.3 from A.top;
move to A.right;
right;
arrow 0.3;
box invisible width 0.85 height 0.2 "postprocessor";
move to last box .bottom;
down;
arrow 0.3;
box invisible width 0.5 height 0.4 "output" "file"
.ps
.vs
.PE
.\}
.el \{\
.EX
          input        sourced
          file          file
            \[bv]             \[bv]
            \[da]             \[da]
        preprocessor \[an]\[->] troff \[an]\[->] postprocessor
                                      \[bv]
                                      \[da]
                                   output
                                    file
.EE
.\}
.PP
That is,
files sourced with
.B .so
are normally read
.I only
by
.I \%@g@troff
(the actual formatter).
.
.I \%@g@soelim
is
.I not
required for
.I \%@g@troff
to source files.
.
.
.PP
If a file to be sourced should also be preprocessed,
it must already be read
.I before
the input file passes through the preprocessor.
.
.I \%@g@soelim
handles this.
.
.PP
.ie t \{\
.PS
.ps 10
.vs 12
box invisible width 0.5 height 0.4 "input" "file";
move to last box .bottom;
down;
arrow 0.3;
A: box invisible width 0.5 height 0.2 "soelim";
line <- 0.3;
box invisible width 0.5 height 0.4 "sourced" "file";
move to A.right;
right;
arrow 0.3;
box invisible width 0.8 height 0.2 "preprocessor";
arrow 0.3;
box invisible width 0.35 height 0.2 "troff";
arrow 0.3
box invisible width 0.85 height 0.2 "postprocessor";
move to last box .bottom;
down;
arrow 0.3;
box invisible width 0.5 height 0.4 "output" "file"
.ps
.vs
.PE
.\}
.el \{\
.EX
          input
          file
            \[bv]
            \[da]
          soelim \[an]\[->] preprocessor \[an]\[->] troff \[an]\[->] \
postprocessor
            \[ua]                                     \[bv]
            \[bv]                                     \[da]
         sourced                               output
          file                                  file
.EE
.\}
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-C
Recognize
.B .so
even when followed by a character other than space or newline.
.
.TP
.BI \-I\~ dir
Add the directory
.I dir
to the search path for macro files
(both those on the command line and those named in
.B .so
requests).
.
The search path is initialized with the current directory.
.
This option may be specified more than once;
the directories are then searched in the order specified
(but before the current directory).
.
If you want to search the current directory before other directories,
add
.RB \[lq] \-I\~.\& \[rq]
at the appropriate place.
.
.IP
No directory search is performed for files with an absolute file name.
.
.
.TP
.B \-r
Write files \[lq]raw\[rq];
do not add
.B .lf
requests
(for general use,
with
.RI non- groff
files).
.
.
.TP
.B \-t
Emit \*[tx] comment lines starting with
.RB \[lq] % \[rq]
indicating the current file and line number,
rather than
.B .lf
requests for the same purpose.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.BR groff (@MAN1EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_soelim_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
