.TH @g@pic @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@pic \- compile pictures for troff or TeX
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_pic_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.\" Definitions
.\" ====================================================================
.
.ie t \{\
.  ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.  ds lx L\h'-0.36m'\v'-0.22v'\s-2A\s0\h'-0.15m'\v'0.22v'\*[tx]
.\}
.el \{\
.  ds tx TeX
.  ds lx LaTeX
.\}
.
.ie \n(.g .ds ic \/
.el       .ds ic \^
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@pic
.OP \-nCSU
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY @g@pic
.B \-t
.OP \-czCSU
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY @g@pic
.B \-\-help
.YS
.
.
.SY @g@pic
.B \-v
.
.SY @g@pic
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
This manual page describes the GNU version of
.IR pic , \" GNU
which is part of the
.I groff
document formatting system.
.
.I \%@g@pic
compiles descriptions of pictures embedded within
.I troff \" generic
or \*[tx] input files into commands that are understood by \*[tx] or
.IR troff .
.
Each picture starts with a line beginning with
.B .PS
and ends with a line beginning with
.BR .PE .
.
Anything outside of
.B .PS
and
.B .PE
is passed through without change.
.
.
.LP
It is the user's responsibility to provide appropriate definitions
of the
.B PS
and
.B PE
macros.
.
When the macro package being used does not supply such definitions
(for example,
old versions of \-ms),
appropriate definitions can be
obtained with
.BR \-mpic :
these will center each picture.
.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-c
Be more compatible with
.IR tpic .
.
Implies
.BR \-t .
.
Lines beginning with
.B \[rs]
are not passed through transparently.
.
Lines beginning with
.B .
are passed through with the initial
.B .
changed to
.BR \[rs] .
.
A line beginning with
.B .ps
is given special treatment:
it takes an optional integer argument specifying the line thickness
(pen size)
in milliinches;
a missing argument restores the previous line thickness;
the default line thickness is 8 milliinches.
.
The line thickness thus specified takes effect only when a
non-negative line thickness has not been specified by use of the
.B thickness
attribute or by setting the
.B linethick
variable.
.
.
.TP
.B \-C
Recognize
.B .PS
and
.B .PE
even when followed by a character other than space or newline.
.
.
.TP
.B \-n
Don't use
.I groff
extensions to the
.I troff \" generic
drawing commands.
.
You should use this if you are using a postprocessor that doesn't
support these extensions.
.
The extensions are described in
.IR groff_out (@MAN5EXT@).
.
The
.B \-n
option also causes
.I \%@g@pic
not to use zero-length lines to draw dots in
.I troff \" generic
mode.
.
.
.TP
.B \-S
Safer mode;
do not execute
.B sh
commands.
.
This option,
enabled by default,
can be useful when operating on untrustworthy input.
.
.
.TP
.B \-t
\*[tx] mode.
.
.
.TP
.B \-U
Unsafe mode;
revert the default option
.BR \-S .
.
.
.TP
.B \-z
In \*[tx] mode draw dots using zero-length lines.
.
.
.LP
The following options supported by other versions of
.I pic \" generic
are ignored:
.
.TP
.B \-D
Draw all lines using the \[rs]D escape sequence.
.I \%@g@pic
always does this.
.
.TP
.BI \-T \ dev
Generate output for the
.I troff \" generic
device
.IR dev .
.
This is unnecessary because the
.I troff \" generic
output generated by
.I \%@g@pic
is device-independent.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
This section describes only the differences between GNU
.I pic \" GNU
and the original version of
.IR pic . \" AT&T
.
Many of these differences also apply to newer versions of Unix
.BR pic .
.
A complete documentation is available in the file
.
.
.LP
.RS
.I @DOCDIR@/pic.ms
.RE
.
.
.\" ====================================================================
.SS "\*[tx] mode"
.\" ====================================================================
.
\*[tx] mode is enabled by the
.B \-t
option.
.
In \*[tx] mode,
.I \%@g@pic
will define a vbox called
.B \[rs]graph
for each picture.
.
Use the
.B figname
command to change the name of the vbox.
.
You must yourself print that vbox using,
for example,
the command
.
.
.RS
.LP
.EX
\[rs]centerline{\[rs]box\[rs]graph}
.EE
.RE
.
.
.LP
Actually,
since the vbox has a height of zero
(it is defined with \[rs]vtop)
this will produce slightly more vertical space above the picture than
below it;
.
.
.RS
.LP
.B
\[rs]centerline{\[rs]raise 1em\[rs]box\[rs]graph}
.RE
.
.
.LP
would avoid this.
.
.
.LP
To make the vbox having a positive height and a depth of zero
(as used e.g., by \*[lx]'s
.BR \%graphics.sty ),
define the following macro in your document:
.
.
.RS
.LP
.B \[rs]def\[rs]gpicbox#1{%
.br
.B "   \[rs]vbox{\[rs]unvbox\[rs]csname #1\[rs]endcsname\[rs]kern 0pt}}
.RE
.
.
.LP
Now you can simply say
.B \[rs]gpicbox{graph}
instead of \[rs]box\[rs]graph.
.
.
.LP
You must use a \*[tx] driver that supports
.I tpic
version 2 specials.
.
.RI ( tpic
was a fork of AT&T
.I pic \" AT&T
by Tim Morgan of the University of California at Irvine that diverged
from its source around 1984.
.
It is best known today for lending its name to a group of
.B \[rs]special
commands it produced for \*[tx].)
.\" http://ftp.cs.stanford.edu/tex/texhax/texhax90.019
.
.
.LP
Lines beginning with
.B \[rs]
are passed through transparently;
a
.B %
is added to the end of the line to avoid unwanted spaces.
.
You can safely use this feature to change fonts or to
change the value of
.BR \[rs]baselineskip .
.
Anything else may well produce undesirable results;
use at your own risk.
.
Lines beginning with a period are not given any special treatment.
.
.
.\" ====================================================================
.SS Commands
.\" ====================================================================
.
.TP
\fBfor\fR \fIvariable\fR \fB=\fR \fIexpr1\fR \fBto\fR \fIexpr2\fR \
[\fBby\fR [\fB*\fR]\,\fIexpr3\/\fR] \fBdo\fR \fIX\fR \fIbody\fR \fIX\fR
Set
.I variable
to
.IR expr1 .
.
While the value of
.I variable
is less than or equal to
.IR expr2 ,
do
.I body
and increment
.I variable
by
.IR expr3 ;
if
.B by
is not given,
increment
.I variable
by 1.
.
If
.I expr3
is prefixed by
.B *
then
.I variable
will instead be multiplied by
.IR expr3 .
.
The value of
.I expr3
can be negative for the additive case;
.I variable
is then tested whether it is greater than or equal to
.IR expr2 .
.
For the multiplicative case,
.I expr3
must be greater than zero.
.
If the constraints aren't met,
the loop isn't executed.
.
.I X
can be any character not occurring in
.IR body .
.
.TP
\fBif\fR \fIexpr\fR \fBthen\fR \fIX\fR \fIif-true\fR \fIX\fR \
[\fBelse\fR \fIY\fR \fIif-false\fR \fIY\fR]
Evaluate
.IR expr ;
if it is non-zero then do
.IR if-true ,
otherwise do
.IR if-false .
.
.I X
can be any character not occurring in
.IR if-true .
.
.I Y
can be any character not occurring in
.IR if-false .
.
.TP
\fBprint\fR \fIarg\fR\|.\|.\|.
Concatenate the arguments and print as a line on the standard error
stream.
.
Each
.I arg
must be an expression,
a position,
or text.
.
This is useful for debugging.
.
.TP
\fBcommand\fR \fIarg\fR\|.\|.\|.
Concatenate the arguments
and pass them through as a line to
.I troff
or \*[tx].
.
Each
.I arg
must be an expression,
a position,
or text.
.
This has a similar effect to a line beginning with
.B .\&
or
.BR \[rs] ,
but allows the values of variables to be passed through.
.
For example,
.
.
.RS
.IP
.EX
\&.PS
x = 14
command ".ds string x is " x "."
\&.PE
\[rs]*[string]
.EE
.RE
.
.
.IP
prints
.
.
.RS
.IP
.EX
x is 14.
.EE
.RE
.
.
.TP
\fBsh\fR \fIX\fR \fIcommand\fR \fIX\fR
Pass
.I command
to a shell.
.
.I X
can be any character not occurring in
.IR command .
.
.
.TP
\fBcopy\fR \fB"\,\fIfilename\/\fB"\fR
Include
.I filename
at this point in the file.
.
.
.TP
.BR copy\~ [ \[dq]\c
.IB filename \[dq]\c
.RB ]\~ thru\~\c
.I X body X\~\c
.RB [ until\~ \[dq]\c
.IB word \[dq]\c
]
.TQ
.BR copy\~ [ \[dq]\c
.IB filename \[dq]\c
.RB ]\~ thru\~\c
.I macro\~\c
.RB [ until\~ \[dq]\c
.IB word \[dq]\c
]
This construct does
.I body
once for each line of
.IR filename ;
the line is split into blank-delimited words,
and occurrences of
.BI $ i
in
.IR body ,
for
.I i
between 1 and 9,
are replaced by the
.IR i -th
word of the line.
.
If
.I filename
is not given,
lines are taken from the current input up to
.BR .PE .
.
If an
.B until
clause is specified,
lines will be read only until a line the first word of which is
.IR word ;
that line will then be discarded.
.
.I X
can be any character not occurring in
.IR body .
.
For example,
.
.
.RS
.IP
.EX
\&.PS
copy thru % circle at ($1,$2) % until "END"
1 2
3 4
5 6
END
box
\&.PE
.EE
.RE
.
.
.IP
is equivalent to
.
.
.RS
.IP
.EX
\&.PS
circle at (1,2)
circle at (3,4)
circle at (5,6)
box
\&.PE
.EE
.RE
.
.
.IP
The commands to be performed for each line can also be taken
from a macro defined earlier by giving the name of the macro
as the argument to
.BR thru .
.
.
.LP
.B reset
.br
.ns
.TP
\fBreset\fI variable1\/\fR[\fB,\fR]\fI variable2 .\^.\^.
Reset pre-defined variables
.IR variable1 ,
.I variable2
\&.\^.\^.\& to their default values.
.
If no arguments are given,
reset all pre-defined variables to their default values.
.
Assigning a value to
.B scale
also causes all pre-defined variables that control dimensions to be
reset to their default values times the new value of scale.
.
.
.TP
\fBplot\fR \fIexpr\fR [\fB"\,\fItext\*(ic\fB"\fR]
This is a text object which is constructed by using
.I text
as a format string for sprintf
with an argument of
.IR expr .
.
If
.I text
is omitted a format string of
.B \[dq]%g\[dq]
is used.
.
Attributes can be specified in the same way as for a normal text
object.
Be very careful that you specify an appropriate format string;
.I \%@g@pic
does only very limited checking of the string.
.
This is deprecated in favour of
.BR sprintf .
.
.TP
.IB variable\  := \ expr
This is similar to
.B =
except
.I variable
must already be defined,
and
.I expr
will be assigned to
.I variable
without creating a variable local to the current block.
.
(By contrast,
.B =
defines the variable in the current block if it is not already defined
there,
and then changes the value in the current block only.)
.
For example,
the following:
.
.
.RS
.IP
.EX
\&.PS
x = 3
y = 3
[
  x := 5
  y = 5
]
print x " " y
\&.PE
.EE
.RE
.
.
.IP
prints
.
.
.RS
.IP
.EX
.B 5 3
.EE
.RE
.
.
.LP
Arguments of the form
.IP
.I X anything X
.LP
are also allowed to be of the form
.IP
.BI {\  anything\  }
.
.
.LP
In this case
.I anything
can contain balanced occurrences of
.B {
and
.BR } .
Strings may contain
.I X
or imbalanced occurrences of
.B {
and
.BR } .
.
.
.\" ====================================================================
.SS Expressions
.\" ====================================================================
.
The syntax for expressions has been significantly extended:
.
.
.LP
.IB  x\  ^\  y
(exponentiation)
.br
.BI sin( x )
.br
.BI cos( x )
.br
.BI atan2( y , \ x )
.br
.BI log( x )
(base 10)
.br
.BI exp( x )
(base 10, i.e.\&
.ie t 10\v'-.4m'\fIx\*(ic\fR\v'.4m')
.el   10^\fIx\fR)
.br
.BI sqrt( x )
.br
.BI int( x )
.br
.B rand()
(return a random number between 0 and 1)
.br
.BI rand( x )
(return a random number between 1 and
.IR x ;
deprecated)
.br
.BI srand( x )
(set the random number seed)
.br
.BI max( e1 , \ e2 )
.br
.BI min( e1 , \ e2 )
.br
.BI ! e
.br
\fIe1\fB && \fIe2\fR
.br
\fIe1\fB || \fIe2\fR
.br
\fIe1\fB == \fIe2\fR
.br
\fIe1\fB != \fIe2\fR
.br
\fIe1\fB >= \fIe2\fR
.br
\fIe1\fB > \fIe2\fR
.br
\fIe1\fB <= \fIe2\fR
.br
\fIe1\fB < \fIe2\fR
.br
\fB"\,\fIstr1\*(ic\fB" == "\,\fIstr2\*(ic\fB"\fR
.br
\fB"\,\fIstr1\*(ic\fB" != "\,\fIstr2\*(ic\fB"\fR
.br
.
.
.LP
String comparison expressions must be parenthesised in some contexts
to avoid ambiguity.
.
.
.\" ====================================================================
.SS "Other changes"
.\" ====================================================================
.
A bare expression,
.IR expr ,
is acceptable as an attribute;
it is equivalent to
.IR dir\ expr ,
where
.I dir
is the current direction.
.
For example
.LP
.RS
.B line 2i
.RE
.LP
means draw a line 2\ inches long in the current direction.
.
The \[oq]i\[cq]
(or \[oq]I\[cq])
character is ignored;
to use another measurement unit,
set the
.I scale
variable to an appropriate value.
.
.
.LP
The maximum width and height of the picture are taken from the variables
.B maxpswid
and
.BR maxpsht .
.
Initially,
these have values 8.5 and 11.
.
.
.LP
Scientific notation is allowed for numbers.
For example
.
.
.RS
.LP
.B
x = 5e\-2
.RE
.
.
.LP
Text attributes can be compounded.
.
For example,
.
.RS
.LP
.B
"foo" above ljust
.RE
.
.
.LP
is valid.
.
.
.LP
There is no limit to the depth to which blocks can be examined.
.
For example,
.RS
.LP
.B
[A: [B: [C: box ]]] with .A.B.C.sw at 1,2
.br
.B
circle at last [\^].A.B.C
.RE
.
.
.LP
is acceptable.
.
.
.LP
Arcs now have compass points determined by the circle of which the arc
is a part.
.
.
.LP
Circles,
ellipses,
and arcs can be dotted or dashed.
.
In \*[tx] mode splines can be dotted or dashed also.
.
.
.LP
Boxes can have rounded corners.
.
The
.B rad
attribute specifies the radius of the quarter-circles at each corner.
If no
.B rad
or
.B diam
attribute is given,
a radius of
.B boxrad
is used.
.
Initially,
.B boxrad
has a value of\ 0.
.
A box with rounded corners can be dotted or dashed.
.
.
.LP
Boxes can have slanted sides.
.
This effectively changes the shape of a box from a rectangle to an
arbitrary parallelogram.
.
The
.B xslanted
and
.B yslanted
attributes specify the x and y\~offset of the box's upper right
corner from its default position.
.
.
.LP
The
.B .PS
line can have a second argument specifying a maximum height for
the picture.
.
If the width of zero is specified the width will be ignored in computing
the scaling factor for the picture.
.
GNU
.I pic \" GNU
will always scale a picture by the same amount vertically as well as
horizontally.
.
This is different from DWB 2.0
.I pic \" foreign
which may scale a picture by a different amount vertically than
horizontally if a height is specified.
.
.
.LP
Each text object has an invisible box associated with it.
.
The compass points of a text object are determined by this box.
.
The implicit motion associated with the object is also determined
by this box.
.
The dimensions of this box are taken from the width and height
attributes;
if the width attribute is not supplied then the width will be taken to
be
.BR textwid ;
if the height attribute is not supplied then the height will be taken to
be the number of text strings associated with the object times
.BR textht .
.
Initially,
.B textwid
and
.B textht
have a value of 0.
.
.
.LP
In
(almost all)
places where a quoted text string can be used,
an expression of the form
.
.
.IP
.BI sprintf(\[dq] format \[dq],\  arg ,\fR.\|.\|.\fB)
.
.
.LP
can also be used;
this will produce the arguments formatted according to
.IR format ,
which should be a string as described in
.IR printf (3)
appropriate for the number of arguments supplied.
.
Only the flags
.RB \[lq] # \[rq],
.RB \[lq] \- \[rq],
.RB \[lq] + \[rq],
and \[lq]\~\[rq] [sp]ace),
a minimum field width,
an optional precision,
and the conversion specifications
.BR %e ,
.BR %E ,
.BR %f ,
.BR %g ,
.BR %G ,
and
.B %%
are supported.
.
.
.LP
The thickness of the lines used to draw objects is controlled by the
.B linethick
variable.
.
This gives the thickness of lines in points.
.
A negative value means use the default thickness:
in \*[tx] output mode,
this means use a thickness of 8 milliinches;
in \*[tx] output mode with the
.B \-c
option,
this means use the line thickness specified by
.B .ps
lines;
in
.I troff
output mode,
this means use a thickness proportional to the pointsize.
.
A zero value means draw the thinnest possible line supported by
the output device.
.
Initially,
it has a value of \-1.
.
There is also a
.BR thick [ ness ]
attribute.
.
For example,
.
.
.RS
.LP
.B circle thickness 1.5
.RE
.
.
.LP
would draw a circle using a line with a thickness of 1.5 points.
.
The thickness of lines is not affected by the
value of the
.B scale
variable,
nor by the width or height given in the
.B .PS
line.
.
.
.LP
Boxes
(including boxes with rounded corners or slanted sides),
circles and ellipses can be filled by giving them an attribute of
.BR fill [ ed ].
.
This takes an optional argument of an expression with a value between
0 and 1;
0 will fill it with white,
1 with black,
values in between with a proportionally gray shade.
.
A value greater than 1 can also be used:
this means fill with the
shade of gray that is currently being used for text and lines.
.
Normally this will be black,
but output devices may provide a mechanism for changing this.
.
Without an argument,
then the value of the variable
.B fillval
will be used.
.
Initially,
this has a value of 0.5.
.
The invisible attribute does not affect the filling of objects.
.
Any text associated with a filled object will be added after the object
has been filled,
so that the text will not be obscured by the filling.
.
.
.LP
Three additional modifiers are available to specify colored objects:
.BR outline [ d ]
sets the color of the outline,
.B shaded
the fill color,
and
.B colo\fR[\fPu\fR]\fPr\fR[\fPed\fR]
sets both.
.
All three keywords expect a suffix specifying the color,
as shown below.
.
.
.RS
.LP
.B circle shaded """green""" outline """black"""
.RE
.
.
.LP
Currently,
color support isn't available in \*[tx] mode.
.
Predefined color names for
.I groff
are in the device macro files,
for example
.BR ps.tmac ;
additional colors can be defined with the
.B .defcolor
request
(see the manual page of
.IR \%@g@troff (@MAN1EXT@)
for more details).
.
.
.LP
To change the name of the vbox in \*[tx] mode,
set the pseudo-variable
.B figname
(which is actually a specially parsed command)
within a picture.
.
Example:
.RS
.LP
.B .PS
.br
.B figname = foobar;
.br
.B ...
.br
.B .PE
.RE
.
.
.LP
The picture is then available in the box
.BR \[rs]foobar .
.
.
.LP
.I \%@g@pic
assumes that at the beginning of a picture both glyph and fill color are
set to the default value.
.
.
.LP
Arrow heads will be drawn as solid triangles if the variable
.B arrowhead
is non-zero and either \*[tx] mode is enabled or the
.B \-n
option has not been given.
.
Initially,
.B arrowhead
has a value of\ 1.
.
Solid arrow heads are always filled with the current outline color.
.
.
.LP
The
.I troff
output of
.I \%@g@pic
is device-independent.
.
The
.B \-T
option is therefore redundant.
.
All numbers are taken to be in inches;
numbers are never interpreted to be in
.I troff
machine units.
.
.
.LP
Objects can have an
.B aligned
attribute.
.
This will only work if the postprocessor is
.IR grops (@MAN1EXT@)
or
.IR gropdf (@MAN1EXT@).
.
Any text associated with an object having the
.B aligned
attribute will be rotated about the center of the object
so that it is aligned in the direction from the start point
to the end point of the object.
.
This attribute will have no effect on objects whose start and end points
are coincident.
.
.
.LP
In places where
.IB n th
is allowed
.BI \[oq] expr \[cq]th
is also allowed.
.
.B \[cq]th
is a single token: no space is allowed between the
.B \[cq]
and the
.BR th .
.
.
For example,
.IP
.EX
for i = 1 to 4 do {
   line from \[aq]i\[aq]th box.nw to \[aq]i+1\[aq]th box.se
}
.EE
.
.
.\" ====================================================================
.SH Conversion
.\" ====================================================================
.
To obtain a stand-alone picture from a
.I \%@g@pic
file,
enclose your
.I pic \" language
code with
.B .PS
and
.B .PE
requests;
.I roff
configuration commands may be added at the beginning of the file,
but no
.I roff
text.
.
.
.LP
It is necessary to feed this file into
.I groff
without adding any page information,
so you must check which
.B .PS
and
.B .PE
requests are actually called.
.
For example,
the
.I mm
macro package adds a page number,
which is very annoying.
.
At the moment,
calling standard
.I groff
without any macro package works.
.
Alternatively,
you can define your own requests,
e.g.,
to do nothing:
.
.
.LP
.RS
.EX
\&.de PS
\&..
\&.de PE
\&..
.EE
.RE
.
.
.LP
.I groff
itself does not provide direct conversion into other graphics file
formats.
.
But there are lots of possibilities if you first transform your
picture into PostScript\*R format using the
.I groff
option
.BR \-Tps .
.
Since this
.IR ps -file
lacks BoundingBox information it is not very useful by itself, but it
may be fed into other conversion programs, usually named
.BI ps2 other
or
.BI psto other
or the like.
.
Moreover, the PostScript interpreter
.B ghostscript
.RI ( gs (1))
has built-in graphics conversion devices that are called with the option
.
.
.LP
.RS
.BI "gs \-sDEVICE=" <devname>
.RE
.
.
.LP
Call
.
.
.LP
.RS
.B gs \-\-help
.RE
.
.
.LP
for a list of the available devices.
.
.
.LP
An alternative may be to use the
.B \-Tpdf
option to convert your picture directly into
.B PDF
format.
.
The MediaBox of the file produced can be controlled by passing a
.B \-P\-p
papersize to
.IR groff .
.
.
.LP
As the Encapsulated PostScript File Format
.B EPS
is getting more and more important,
and the conversion wasn't regarded trivial in the past you might be
interested to know that there is a conversion tool named
.I ps2eps
which does the right job.
.
It is much better than the tool
.I ps2epsi
packaged with
.IR gs .
.
.
.LP
For bitmapped graphic formats,
you should use
.IR pstopnm ;
the resulting (intermediate)
.IR pnm (5)
file can be then converted to virtually any graphics format using the
tools of the
.B netpbm
package.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @MACRODIR@/pic.tmac
Example definitions of the
.B PS
and
.B PE
macros.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
Characters that are invalid as input to GNU
.I troff \" GNU
(see the
.I groff
Texinfo manual or
.IR groff_char (@MAN7EXT@)
for a list)
are rejected even in \*[tx] mode.
.
.
.LP
The interpretation of
.B fillval
is incompatible with the
.I pic \" AT&T
in Tenth Edition Research Unix,
which interprets 0 as black and 1 as white.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.TP
.I \%@DOCDIR@/\:pic\:.ps
\[lq]Making Pictures with GNU pic\[rq],
by Eric S.\& Raymond.
.
This file,
together with its source,
.IR pic.ms ,
is part of the
.I groff
distribution.
.
.
.LP
\[lq]PIC\[em]A Graphics Language for Typesetting: User Manual\[rq],
by Brian W.\& Kernighan,
1991,
AT&T Bell Laboratories Computing Science Technical Report No.\& 116
.
.
.LP
.B ps2eps
is available from CTAN mirrors, e.g.,
.UR ftp://\:ftp\:.dante\:.de/\:tex\-archive/\:support/\:ps2eps/
.UE
.
.
.LP
W.\& Richard Stevens,
.UR http://\:www\:.kohala\:.com/\:start/\:troff/\:pic2html\:.html
.I Turning PIC into HTML
.UE
.
.
.LP
W.\& Richard Stevens,
.UR http://\:www\:.kohala\:.com/\:start/\:troff/\:pic\:.examples\:.ps
.IR "Examples of " pic " Macros"
.UE
.
.
.LP
.IR \%@g@troff (@MAN1EXT@),
.IR groff_out (@MAN5EXT@),
.IR tex (1),
.IR gs (1),
.IR ps2eps (1),
.IR pstopnm (1),
.IR ps2epsi (1),
.IR pnm (5)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_pic_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
