'\" t
.TH @g@eqn @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
@g@eqn \- format equations for groff or MathML
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_eqn_1_man_C \n[.cp]
.cp 0
.
.
.ie \n(.V<\n(.v \
.  ds tx T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el \
.  ds tx TeX
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY @g@eqn
.RB [ \-rCNR ]
.RB [ \- d
.IR xy ]
.RB [ \-f
.IR F ]
.RB [ \-m
.IR n ]
.RB [ \-M
.IR dir ]
.RB [ \-p
.IR n ]
.RB [ \-s
.IR n ]
.RB [ \-T
.IR name ]
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY @g@eqn
.B \-\-help
.YS
.
.
.SY @g@eqn
.B \-v
.
.SY @g@eqn
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU version of
.I eqn \" GNU
is part of the
.IR groff (@MAN7EXT@)
document formatting system.
.
.I \%@g@eqn
compiles descriptions of equations embedded in
.IR roff (@MAN7EXT@)
input files into commands that are understood by
.IR \%@g@troff (@MAN1EXT@).
.
Normally,
it should be invoked using the
.B \-e
option of
.IR groff (@MAN1EXT@).
.
Although its syntax is compatible with
AT&T
.IR eqn , \" AT&T
its output cannot be processed with AT&T
.IR troff ; \" AT&T
it must be processed with GNU
.IR troff . \" GNU
.
If no
.I file
operands are given on the command line,
or if
.I file
is
.RB \[lq] \- \[rq],
the standard input stream is read.
.
.
.LP
Unless the
.B \-R
option is given,
.I \%@g@eqn
searches for the file
.I eqnrc
in the directories given with the
.B \-M
option first,
then in
.IR @SYSTEMMACRODIR@ ,
.IR @LOCALMACRODIR@ ,
and finally in the standard macro directory
.IR @MACRODIR@ .
.
If it exists,
.I \%@g@eqn
processes it before the other input files.
.
.
.LP
Only the differences between GNU
.I eqn \" GNU
and AT&T
.I eqn \" AT&T
are described in this document.
.
Most of the new features of the GNU
.I eqn \" GNU
input language are based on \*[tx].
.
There are some references to the differences between \*[tx] and GNU
.I eqn \" GNU
below;
these may safely be ignored if you do not know \*[tx].
.
.
.LP
Three points are worth special note. \" good, bad, and different
.
.
.IP \[bu]
GNU
.I eqn \" GNU
emits Presentation MathML output when invoked with the
.RB \[lq] "\-T\~MathML" \[rq]
option.
.
.
.IP \[bu]
GNU
.I eqn \" GNU
does not provide the functionality of
.IR neqn : \" AT&T
it does not support low-resolution,
typewriter-like devices
(although it may work adequately for very simple input).
.
.
.IP \[bu]
GNU
.I eqn
sets the input token
.RB \[lq] .\|.\|.\& \[rq]
as three periods or low dots,
rather than the three centered dots of
AT&T
.IR eqn . \" AT&T
.
To get three centered dots,
write
.B "cdots"
or
.RB \[lq] "cdot cdot cdot" \[rq].
.
.
.\" ====================================================================
.SS "Controlling delimiters"
.\" ====================================================================
.
If not in compatibility mode,
.I eqn
recognizes
.
.RS
.EX
delim on
.EE
.RE
.
as a command to restore the delimiters which have been previously
disabled with a call to
.RB \[lq] "delim off" \[rq].
.
If delimiters haven't been specified,
the call has no effect.
.
.
.\" ====================================================================
.SS "Automatic spacing"
.\" ====================================================================
.
.I eqn
gives each component of an equation a type,
and adjusts the spacing between components using that type.
.
Possible types are described in the table below.
.
.
.IP
.TS
lf(CR) l.
ordinary	T{
an ordinary character such as \[lq]1\[rq] or
.RI \[lq] x \[rq]
T}
operator	T{
a large operator such as
.ds Su \[lq]\s+5\[*S]\s0\[rq]
.if \n(.g .if !c\[*S] .ds Su the summation operator
\*[Su]
T}
binary	a binary operator such as \[lq]\[pl]\[rq]
relation	a relation such as \[lq]=\[rq]
opening	an opening bracket such as \[lq](\[rq]
closing	a closing bracket such as \[lq])\[rq]
punctuation	a punctuation character such as \[lq],\[rq]
inner	a sub-formula contained within brackets
suppress	a type without automatic spacing adjustment
.TE
.
.
.LP
Components of an equation get a type in one of two ways.
.
.
.TP
.BI type\~ "t e"
This yields an equation component that
.RI contains\~ e
but that has
.RI type\~ t ,
where
.I t
is one of the types mentioned above.
.
For example,
.B times
is defined as follows.
.
.
.RS
.IP
.EX
type "binary" \[rs](mu
.EE
.RE
.
.
.IP
The name of the type doesn't have to be quoted,
but quoting it protects it from macro expansion.
.
.
.TP
.BI chartype\~ "t text"
Unquoted groups of characters are split up into individual characters,
and the type of each character is looked up;
this changes the type that is stored for each character;
it says that the characters in
.I text
from now on have
.RI type\~ t .
.
For example,
.
.
.RS
.IP
.EX
chartype "punctuation" .,;:
.EE
.RE
.
.
.IP
would make the characters \[lq].,;:\[rq] have type punctuation whenever
they subsequently appeared in an equation.
.
The
.RI type\~ t
can also be
.B letter
or
.BR digit ;
in these cases
.B chartype
changes the font type of the characters.
.
See subsection \[lq]Fonts\[rq] below.
.
.
.\" ====================================================================
.SS "New primitives"
.\" ====================================================================
.
.TP
.BI big\~ e
Enlarges the expression it modifies;
intended to have semantics like
CSS \[lq]large\[rq].
.
In
.I \%@g@troff
output,
the point size is increased by\~5;
in MathML output,
the expression uses
.
.
.RS
.IP
.EX
<mstyle \%mathsize=\[aq]big\[aq]>
.EE
.RE
.
.
.TP
.I e1 \c
.B smallover \c
.I e2
This is similar to
.BR over ;
.B smallover
reduces the size of
.I e1
and
.IR e2 ;
it also puts less vertical space between
.I e1
or
.I e2
and the fraction bar.
.
The
.B over
primitive corresponds to the \*[tx]
.B \[rs]over
primitive in display styles;
.B smallover
corresponds to
.B \[rs]over
in non-display styles.
.
.
.TP
.BI vcenter\~ e
This vertically centers
.I e
about the math axis.
.
The math axis is the vertical position about which characters such as
\[lq]\[pl]\[rq] and \[lq]\[mi]\[rq] are centered;
it is also the vertical position used for fraction bars.
.
For example,
.B sum
is defined as follows.
.
.RS
.IP
.EX
{ type "operator" vcenter size +5 \[rs](*S }
.EE
.RE
.
.IP
.B vcenter
is silently ignored when generating MathML.
.
.
.TP
.I e1 \c
.B accent \c
.I e2
This sets
.I e2
as an accent over
.IR e1 .
.I e2
is assumed to be at the correct height for a lowercase letter;
.I e2
is moved down according to whether
.I e1
is taller or shorter than a lowercase letter.
.
For example,
.B hat
is defined as follows.
.
.
.RS
.IP
.EX
accent { "^" }
.EE
.RE
.
.
.IP
.BR dotdot ,
.BR dot ,
.BR tilde ,
.BR vec ,
and
.B dyad
are also defined using the
.B accent
primitive.
.
.
.TP
.I e1 \c
.B uaccent \c
.I e2
This sets
.I e2
as an accent under
.IR e1 .
.I e2
is assumed to be at the correct height for a character without a
descender;
.I e2
is moved down if
.I e1
has a descender.
.
.B utilde
is pre-defined using
.B uaccent
as a tilde accent below the baseline.
.
.
.TP
.BI "split \[dq]" text \[dq]
This has the same effect as simply
.
.
.RS
.IP
.EX
.I text
.EE
.RE
.
.
.IP
but
.I text
is not subject to macro expansion because it is quoted;
.I text
is split up and the spacing between individual characters is adjusted.
.
.
.TP
.BI nosplit\~ text
This has the same effect as
.
.
.RS
.IP
.EX
.RI \[dq] text \[dq]
.EE
.RE
.
.
.IP
but because
.I text
is not quoted it is subject to macro expansion;
.I text
is not split up and the spacing between individual characters is not
adjusted.
.
.
.TP
.IB e\~ opprime
This is a variant of
.B prime
that acts as an operator
.RI on\~ e .
.
It produces a different result from
.B prime
in a case such as
.RB \[lq] "A opprime sub 1" \[rq]:
with
.B opprime
the\~\[lq]1\[rq] is tucked under the prime as a subscript to
the\~\[lq]A\[rq]
(as is conventional in mathematical typesetting),
whereas with
.B prime
the\~\[lq]1\[rq] is a subscript to the prime character.
.
The precedence of
.B opprime
is the same as that of
.B bar
and
.BR under ,
which is higher than that of everything except
.B accent
and
.BR uaccent .
.
In unquoted text,
a neutral apostrophe
.RB ( \[aq] )
that is not the first character on the input line is treated like
.BR opprime .
.
.
.TP
.BI special\~ "text e"
This constructs a new object
.RI from\~ e
using a
.IR \%@g@troff (@MAN1EXT@)
macro named
.IR text .
.
When the macro is called,
the string
.B 0s
contains the output
.RI for\~ e ,
and the number registers
.BR 0w ,
.BR 0h ,
.BR 0d ,
.BR 0skern ,
and
.B 0skew
contain the width,
height,
depth,
subscript kern,
and skew
.RI of\~ e .
.
(The
.I subscript kern
of an object indicates how much a subscript on that object should be
\[lq]tucked in\[rq],
or placed to the left relative to a non-subscripted glyph of the same
size.
.
The
.I skew
of an object is how far to the right of the center of the object an
accent over it should be placed.)
.
The macro must modify
.B 0s
so that it outputs the desired result with its origin at the current
point,
and increase the current horizontal position by the width of the object.
.
The number registers must also be modified so that they correspond to
the result.
.
.
.IP
For example,
suppose you wanted a construct that \[lq]cancels\[rq] an expression by
drawing a diagonal line through it.
.
.
.RS
.IP
.if t .ne 10v+\n(.Vu
.EX
\&.EQ
define cancel \[aq]special Ca\[aq]
\&.EN
\&.de Ca
\&.  ds 0s \[rs]
\[rs]Z\[aq]\[rs]\[rs]*(0s\[aq]\[rs]
\[rs]v\[aq]\[rs]\[rs]n(0du\[aq]\[rs]
\[rs]D\[aq]l \[rs]\[rs]n(0wu \-\[rs]\[rs]n(0hu-\[rs]\[rs]n(0du\[aq]\[rs]
\[rs]v\[aq]\[rs]\[rs]n(0hu\[aq]
\&..
.EE
.RE
.
.
.IP
You could then cancel an
.RI expression\~ e
with
.RB \[lq] "cancel {"
.I e
.BR } \[rq].
.
.
.IP
Here's a more complicated construct that draws a box around an
expression.
.
.
.RS
.IP
.if t .ne 18v+\n(.Vu
.EX
\&.EQ
define box \[aq]special Bx\[aq]
\&.EN
\&.de Bx
\&.ds 0s \[rs]
\[rs]Z\[aq]\[rs]h\[aq]1n\[aq]\[rs]\[rs]*(0s\[aq]\[rs]
\[rs]Z\[aq]\[rs]
\[rs]v\[aq]\[rs]\[rs]n(0du+1n\[aq]\[rs]
\[rs]D\[aq]l \[rs]\[rs]n(0wu+2n 0\[aq]\[rs]
\[rs]D\[aq]l 0 \-\[rs]\[rs]n(0hu\-\[rs]\[rs]n(0du-2n\[aq]\[rs]
\[rs]D\[aq]l \-\[rs]\[rs]n(0wu\-2n 0\[aq]\[rs]
\[rs]D\[aq]l 0 \[rs]\[rs]n(0hu+\[rs]\[rs]n(0du+2n\[aq]\[rs]
\&\[aq]\[rs]
\[rs]h\[aq]\[rs]\[rs]n(0wu+2n\[aq]
\&.nr 0w +2n
\&.nr 0d +1n
\&.nr 0h +1n
\&..
.EE
.RE
.
.
.TP
.BI space\~ n
A positive value of the
.RI integer\~ n
(in hundredths of an em)
sets the vertical spacing before the equation,
a negative value sets the spacing after the equation,
replacing the default values.
.
This primitive provides an interface to
.IR groff 's
.B \[rs]x
escape
(but with opposite sign).
.
.
.IP
This keyword has no effect if the equation is part of a
.I pic
picture.
.
.
.\" ====================================================================
.SS "Extended primitives"
.\" ====================================================================
.
.TP
.B col \c
.I n \c
.BR {\~ .\|.\|.\& \~}
.TQ
.B ccol \c
.I n \c
.BR {\~ .\|.\|.\& \~}
.TQ
.B lcol \c
.I n \c
.BR {\~ .\|.\|.\& \~}
.TQ
.B rcol \c
.I n \c
.BR {\~ .\|.\|.\& \~}
.TQ
.B pile \c
.I n \c
.BR {\~ .\|.\|.\& \~}
.TQ
.B cpile \c
.I n \c
.BR {\~ .\|.\|.\& \~}
.TQ
.B lpile \c
.I n \c
.BR {\~ .\|.\|.\& \~}
.TQ
.B rpile \c
.I n \c
.BR {\~ .\|.\|.\& \~}
The integer
.RI value\~ n
(in hundredths of an em)
increases the vertical spacing between rows,
using
.IR groff 's
.B \[rs]x
escape
(the value has no effect in MathML mode).
.
Negative values are possible but have no effect.
.
If there is more than a single value given in a matrix,
the biggest one is used.
.
.
.\" ====================================================================
.SS Customization
.\" ====================================================================
.
When
.I eqn
is generating
.I troff \" generic
markup,
the appearance of equations is controlled by a large number of
parameters.
.
They have no effect when generating MathML mode,
which pushes typesetting and fine motions downstream to a MathML
rendering engine.
.
These parameters can be set using the
.B set
command.
.
.
.TP
.BI set\~ "p n"
This sets
.RI parameter\~ p
to
.RI value\~ n ,
where
.IR n \~is
an integer.
.
For example,
.
.
.RS
.IP
.EX
set x_height 45
.EE
.RE
.
.
.IP
says that
.I \%@g@eqn
should assume an x\~height of 0.45\~ems.
.
.
.RS
.LP
Possible parameters are as follows.
.
Values are in units of hundredths of an em unless otherwise stated.
.
These descriptions are intended to be expository rather than
definitive.
.
.
.TP
.B minimum_size
.I \%@g@eqn
won't set anything at a smaller point size than this.
.
The value is in points.
.
.
.TP
.B fat_offset
The
.B fat
primitive emboldens an equation by overprinting two copies of the
equation horizontally offset by this amount.
.
This parameter is not used in MathML mode;
instead,
fat text uses
.
.
.RS
.IP
.EX
<mstyle mathvariant=\[aq]double\-struck\[aq]>
.EE
.RE
.
.
.TP
.B over_hang
A fraction bar is longer by twice this amount than
the maximum of the widths of the numerator and denominator;
in other words,
it overhangs the numerator and denominator by at least this amount.
.
.
.TP
.B accent_width
When
.B bar
or
.B under
is applied to a single character,
the line is this long.
.
Normally,
.B bar
or
.B under
produces a line whose length is the width of the object to which it
applies;
in the case of a single character,
this tends to produce a line that looks too long.
.
.
.TP
.B delimiter_factor
Extensible delimiters produced with the
.B left
and
.B right
primitives have a combined height and depth of at least this many
thousandths of twice the maximum amount by which the sub-equation that
the delimiters enclose extends away from the axis.
.
.
.TP
.B delimiter_shortfall
Extensible delimiters produced with the
.B left
and
.B right
primitives have a combined height and depth not less than the
difference of twice the maximum amount by which the sub-equation that
the delimiters enclose extends away from the axis and this amount.
.
.
.TP
.B null_delimiter_space
This much horizontal space is inserted on each side of a fraction.
.
.
.TP
.B script_space
The width of subscripts and superscripts is increased by this amount.
.
.
.TP
.B thin_space
This amount of space is automatically inserted after punctuation
characters.
.
.
.TP
.B medium_space
This amount of space is automatically inserted on either side of
binary operators.
.
.
.TP
.B thick_space
This amount of space is automatically inserted on either side of
relations.
.
.
.TP
.B x_height
The height of lowercase letters without ascenders such as \[lq]x\[rq].
.
.
.TP
.B axis_height
The height above the baseline of the center of characters such as
\[lq]\[pl]\[rq] and \[lq]\[mi]\[rq].
.
It is important that this value is correct for the font
you are using.
.
.
.TP
.B default_rule_thickness
This should set to the thickness of the
.B \[rs][ru]
character,
or the thickness of horizontal lines produced with the
.B \[rs]D
escape sequence.
.
.
.TP
.B num1
The
.B over
command shifts up the numerator by at least this amount.
.
.
.TP
.B num2
The
.B smallover
command shifts up the numerator by at least this amount.
.
.
.TP
.B denom1
The
.B over
command shifts down the denominator by at least this amount.
.
.
.TP
.B denom2
The
.B smallover
command shifts down the denominator by at least this amount.
.
.
.TP
.B sup1
Normally superscripts are shifted up by at least this amount.
.
.
.TP
.B sup2
Superscripts within superscripts or upper limits
or numerators of
.B smallover
fractions are shifted up by at least this amount.
.
This is usually less than
.BR sup1 .
.
.
.TP
.B sup3
Superscripts within denominators or square roots
or subscripts or lower limits are shifted up by at least
this amount.
.
This is usually less than
.BR sup2 .
.
.
.TP
.B sub1
Subscripts are normally shifted down by at least this amount.
.
.
.TP
.B sub2
When there is both a subscript and a superscript,
the subscript is shifted down by at least this amount.
.
.
.TP
.B sup_drop
The baseline of a superscript is no more than this much amount below
the top of the object on which the superscript is set.
.
.
.TP
.B sub_drop
The baseline of a subscript is at least this much below the bottom of
the object on which the subscript is set.
.
.
.TP
.B big_op_spacing1
The baseline of an upper limit is at least this much above the top of
the object on which the limit is set.
.
.
.TP
.B big_op_spacing2
The baseline of a lower limit is at least this much below the bottom
of the object on which the limit is set.
.
.
.TP
.B big_op_spacing3
The bottom of an upper limit is at least this much above the top of
the object on which the limit is set.
.
.
.TP
.B big_op_spacing4
The top of a lower limit is at least this much below the bottom of the
object on which the limit is set.
.
.
.TP
.B big_op_spacing5
This much vertical space is added above and below limits.
.
.
.TP
.B baseline_sep
The baselines of the rows in a pile or matrix are normally this far
apart.
.
In most cases this should be equal to the sum of
.B num1
and
.BR denom1 .
.
.
.TP
.B shift_down
The midpoint between the top baseline and the bottom baseline in a
matrix or pile is shifted down by this much from the axis.
.
In most cases this should be equal to
.BR axis_height .
.
.
.TP
.B column_sep
This much space is added between columns in a matrix.
.
.
.TP
.B matrix_side_sep
This much space is added at each side of a matrix.
.
.
.TP
.B draw_lines
If this is non-zero,
lines are drawn using the
.B \[rs]D
escape sequence,
rather than with the
.B \[rs]l
escape sequence and the
.B \[rs][ru]
character.
.
.
.TP
.B body_height
The amount by which the height of the equation exceeds this is added as
extra space before the line containing the equation
(using
.BR \[rs]x ).
.
The default value is 85.
.
.
.TP
.B body_depth
The amount by which the depth of the equation exceeds this is added as
extra space after the line containing the equation
(using
.BR \[rs]x ).
.
The default value is 35.
.
.
.TP
.B nroff
If this is non-zero,
then
.B ndefine
behaves like
.B define
and
.B tdefine
is ignored,
otherwise
.B tdefine
behaves like
.B define
and
.B ndefine
is ignored.
.
The default value is\~0.
.
(This is typically changed to\~1 by the
.I eqnrc
file for the
.BR ascii ,
.BR latin1 ,
.BR utf8 ,
and
.B cp1047
drivers.)
.
.
.LP
A more precise description of the role of many of these
parameters can be found in Appendix\~H of
.IR "The \*[tx]book" .
.RE
.
.
.\" ====================================================================
.SS Macros
.\" ====================================================================
.
Macros can take arguments.
.
In a macro body,
.BI $ n
where
.I n
is between 1 and\~9,
is replaced by the
.IR n th
argument if the macro is called with arguments;
if there are fewer than
.IR n \~arguments,
it is replaced by nothing.
.
A word containing a left parenthesis where the part of the word before
the left parenthesis has been defined using the
.B define
command is recognized as a macro call with arguments;
characters following the left parenthesis up to a matching right
parenthesis are treated as comma-separated arguments.
.
Commas inside nested parentheses
do not terminate an argument.
.
.
.TP
.BI sdefine\~ "name X anything X"
This is like the
.B define
command,
but
.I name
is not recognized if called with arguments.
.
.
.TP
.BI "include \[dq]" file \[dq]
.TQ
.BI "copy \[dq]" file \[dq]
Include the contents of
.I file
.RB ( include
and
.B copy
are synonyms).
.
Lines of
.I file
beginning with
.B .EQ
or
.B .EN
are ignored.
.
.
.TP
.BI ifdef\~ "name X anything X"
If
.I name
has been defined by
.B define
(or has been automatically defined because
.I name
is the output driver)
process
.IR anything ;
otherwise ignore
.IR anything .
.
.I X
can be any character not appearing in
.IR anything .
.
.
.TP
.BI undef\~ name
Remove definition of
.IR name ,
making it undefined.
.
.
.LP
Besides the macros mentioned above,
the following definitions are available:
.BR Alpha ,
.BR Beta ,
\&.\|.\|.,
.B Omega
(this is the same as
.BR ALPHA ,
.BR BETA ,
\&.\|.\|.,
.BR OMEGA ),
.B ldots
(three dots on the baseline),
and
.BR dollar .
.
.
.\" ====================================================================
.SS Fonts
.\" ====================================================================
.
.I \%@g@eqn
normally uses at least two fonts to set an equation:
an italic font for letters,
and a roman font for everything else.
.
The AT&T
.I eqn
.B gfont
command changes the font that is used as the italic font.
.
By default this
.RB is\~ I .
.
The font that is used as the roman font can be changed using the new
.B grfont
command.
.
.
.TP
.BI grfont\~ f
Set the roman font
.RI to\~ f .
.
.
.LP
The
.B italic
primitive uses the current italic font set by
.BR gfont ;
the
.B roman
primitive uses the current roman font set by
.BR grfont .
.
There is also a new
.B gbfont
command,
which changes the font used by the
.B bold
primitive.
.
If you only use the
.BR roman ,
.B italic
and
.B bold
primitives to changes fonts within an equation,
you can change all the fonts used by your equations just by using
.BR gfont ,
.B grfont
and
.B gbfont
commands.
.
.
.LP
You can control which characters are treated as letters
(and therefore set in italics)
by using the
.B chartype
command described above.
.
A type of
.B letter
causes a character to be set in italic type.
.
A type of
.B digit
causes a character to be set in roman type.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-C
Recognize
.B .EQ
and
.B .EN
even when followed by a character other than space or newline,
and do not handle the
.RB \[lq] "delim on" \[rq]
statement specially.
.
.
.TP
.BI \-d\~ xy
Specify delimiters
.I x
.RI and\~ y
for the left and right ends,
respectively,
of inline equations.
.
Any
.B delim
statements in the source file override this.
.
.
.TP
.BI \-f\~ F
This is equivalent to a
.RB \[lq] gfont
.IR F \[rq]
command.
.
.
.TP
.BI \-m\~ n
Set the minimum point size
.RI to\~ n .
.
.I \%@g@eqn
will not reduce the size of subscripts or superscripts to
a smaller size
.RI than\~ n .
.
.
.TP
.BI \-M\~ dir
Search
.I dir
for
.I eqnrc
before the default directories.
.
.
.TP
.B \-N
Don't allow newlines within delimiters.
.
This option allows
.I \%@g@eqn
to recover better from missing closing delimiters.
.
.
.TP
.BI \-p\~ n
This says that subscripts and superscripts should be
.IR n \~points
smaller than the surrounding text.
.
This option is deprecated.
.
Normally,
.I \%@g@eqn
sets subscripts and superscripts at 70% of the size of the surrounding
text.
.
.
.TP
.B \-r
Only one size reduction.
.
.
.TP
.B \-R
Don't load
.IR eqnrc .
.
.
.TP
.BI \-s\~ n
This is equivalent to a
.RB \[lq] gsize
.IR n \[rq]
command.
.
This option is deprecated.
.I \%@g@eqn
normally sets equations at whatever the current point size is when the
equation is encountered.
.
.
.TP
.BI \-T\~ name
The output is for output driver
.IR name .
.
Normally,
the only effect of this is to define a macro
.I name
with a value
.RB of\~ 1 ;
.I eqnrc
uses this to provide definitions appropriate for the output driver.
.
However,
if the specified driver is \[lq]MathML\[rq],
the output is MathML markup rather than
.I \%@g@troff
commands,
and
.I eqnrc
is not loaded at all.
.
The default output driver is
.BR @DEVICE@ .
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I \%@MACRODIR@/\:\%eqnrc
Initialization file.
.
.
.\" ====================================================================
.SH "MathML Mode Limitations"
.\" ====================================================================
.
MathML is designed on the assumption that it cannot know the exact
physical characteristics of the media and devices on which it will
be rendered.
.
It does not support fine control of motions and sizes to the same
degree
.I \%@g@troff
does.
.
Thus:
.
.IP \[bu]
.I \%@g@eqn
parameters have no effect on the generated MathML.
.
.IP \[bu]
The
.BR special ,
.BR up ,
.BR down ,
.BR fwd ,
and
.B back
operations cannot be implemented,
and yield a MathML \[lq]<merror>\[rq] message instead.
.
.IP \[bu]
The
.B vcenter
keyword is silently ignored,
as centering on the math axis is the MathML default.
.
.IP \[bu]
Characters that
.I \%@g@eqn
sets extra large in
.I troff \" mode
mode\[em]notably the integral sign\[em]may appear too small and need to
have their \[lq]<mstyle>\[rq] wrappers adjusted by hand.
.
.
.LP
As in its
.I troff \" mode
mode,
.I \%@g@eqn
in MathML mode leaves the
.B .EQ
and
.B .EN
delimiters in place for displayed equations,
but emits no explicit delimiters around inline equations.
.
They can,
however,
be recognized as strings that begin with \[lq]<math>\[rq] and end with
\[lq]</math>\[rq] and do not cross line boundaries.
.
.
.LP
See section \[lq]Bugs\[rq] below for translation limits specific to
.IR \%@g@eqn .
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
Inline equations are set at the point size that is current at the
beginning of the input line.
.
.
.LP
In MathML mode,
the
.B mark
and
.B lineup
features don't work.
.
These could,
in theory,
be implemented with \[lq]<maligngroup>\[rq] elements.
.
.
.LP
In MathML mode,
each digit of a numeric literal gets a separate \[lq]<mn>\:</mn>\[rq]
pair,
and decimal points are tagged with \[lq]<mo>\:</mo>\[rq].
.
This is allowed by the specification,
but inefficient.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Typesetting Mathematics\[em]User's Guide\[rq]
(2nd edition),
by Brian W.\& Kernighan
and Lorinda L.\& Cherry,
1978,
AT&T Bell Laboratories Computing Science Technical Report No.\& 17.
.
.
.LP
.IR The\~\*[tx]book ,
by Donald E.\& Knuth,
1984,
Addison-Wesley Professional.
.
.
.LP
.IR groff (@MAN1EXT@),
.IR \%@g@troff (@MAN1EXT@),
.IR \%@g@pic (@MAN1EXT@),
.IR groff_font (@MAN5EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_eqn_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" tab-width: 12
.\" End:
.\" vim: set filetype=groff tabstop=12 textwidth=72:
