.TH grotty @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grotty \- groff output driver for typewriter-like (terminal) devices
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grotty_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grotty
.OP \-dfho
.RB [ \-i | \-r ]
.OP \-F dir
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY "grotty \-c"
.OP \-bBdfhouU
.OP \-F dir
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY grotty
.B \-\-help
.YS
.
.
.SY grotty
.B \-v
.
.SY grotty
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU
.I roff
TTY
(\[lq]Teletype\[rq])
output driver translates the output of
.IR \%@g@troff (@MAN1EXT@)
into a form suitable for typewriter-like devices,
including terminal emulators.
.
Normally,
.I grotty
is invoked by
.IR groff (@MAN1EXT@)
when the latter is given one of the
.BR \-Tascii ,
.B \-Tlatin1
or
.B \-Tutf8
options on systems using ISO character encoding standards,
or with
.B \-Tcp1047
or
.B \-Tutf8
on EBCDIC-based hosts.
.
If no
.I file
arguments are given,
or if
.I file
is \[lq]\-\[rq],
.I grotty
reads the standard input stream.
.
Output is written to the standard output stream.
.
.
.LP
By default,
.I grotty
emits SGR escape sequences
(from ISO\~6429,
popularly called \[lq]ANSI escapes\[rq])
to change text attributes
(bold, italic, underline, reverse-video, and colors).
.
Devices supporting the appropriate sequences can view
.I roff
documents using eight different background and foreground colors.
.
.
.LP
In keeping with long-standing practice and the rarity of terminals,
hardware or emulated,
that support oblique or italic fonts,
italicized text is represented with underlining by default\[em]but see
the
.B \-i
option below.
.
.
.LP
Following ISO\~6429,
the following colors are defined in
.IR tty.tmac :
black, white, red, green, blue, yellow, magenta, and cyan.
.
Unrecognized colors are mapped to the default color,
which is dependent on the settings of the terminal.
.
.
.\" ====================================================================
.SS "SGR support in pagers"
.\" ====================================================================
.
When paging
.IR grotty 's
output with
.IR less (1),
the latter program must be instructed to pass SGR sequences through to
the device;
its
.B \-R
option is one way to achieve this.
.
Consequently,
programs like
.IR man (1)
which page
.I roff
documents with
.I less
must call it with an appopriate option.
.
.
.\" ====================================================================
.SS "Legacy output format"
.\" ====================================================================
.
The
.B \-c
option tells
.I grotty
to use an output format compatible with paper terminals,
like the Teletype machines for which
.I roff
and
.I nroff
were first developed but which are no longer in wide use.
.
SGR escape sequences are not emitted.
.
Instead,
.I grotty
overstrikes,
representing a bold character
.I c
with the sequence
.RI \[lq] c\~\c
BACKSPACE\~\c
.IR c \[rq]
an italic character
.I c
with the sequence
.RB \[lq] _\~\c
BACKSPACE\~\c
.IR c \[rq],
and bold italics with
.RB \[lq] _\~\c
BACKSPACE\~\c
.I c
BACKSPACE\~\c
.IR c \[rq].
Furthermore, color output is disabled.
.
The same effect can be achieved either by setting the
.I GROFF_NO_SGR
environment variable or by using a
.I groff
escape sequence within the document;
see subsection \[lq]Device control commands\[rq],
below.
.
.
.LP
The legacy output format can be rendered on a video terminal
(or emulator)
by piping
.IR grotty 's
output through
.IR ul (1),
.\" from bsdmainutils 11.1.2+b1 (on Debian Buster)
which may render bold italics as reverse video.
.
.\" 'more' from util-linux 2.33.1 (on Debian Buster) neither renders
.\" double-struck characters as bold nor supports -b, but does render
.\" SGR sequences (including color) with no flags required.
Some implementations of
.IR more (1)
are also able to display these sequences;
you may wish to experiment with that command's
.B \-b
option.
.
.\" Version 487 of...
.I less
renders legacy bold and italics without requiring options.
.
In contrast to the terminal output drivers of some other
.I roff
implementations,
.I grotty
never outputs reverse line feeds.
.
There is therefore no need to filter its output through
.IR col (1).
.
.
.\" ====================================================================
.SS "Device control commands"
.\" ====================================================================
.
.I grotty
understands a single device control function produced using the
.I roff
.B \[rs]X
escape sequence in a document.
.
.
.TP
.BR "\[rs]X\[aq]tty: sgr " [\c
.IR n ]\c
.B \[aq]
.
If
.I n
is non-zero or missing, enable SGR sequences
(this is the default);
otherwise,
use the legacy output format.
.
.
.\" ====================================================================
.SS "Device description files"
.\" ====================================================================
.
.LP
If
.I DESC
file for the character encoding contains the keyword
.RB \[lq] unicode \[rq],
.I grotty
emits Unicode characters in UTF-8 encoding.
.
Otherwise, it emits characters in a single-byte encoding depending on
the data in the font description files.
.
See
.IR groff_font (@MAN5EXT@)
for more details.
.
.
.LP
A font description file may contain a command
.RB \[lq] internalname\~\c
.IR n \[rq]
where
.I n
is a decimal integer.
.
If the 01 bit in
.I n
is set,
then the font is treated as an italic font;
if the 02 bit is set,
then it is treated as a bold font.
.
.\" The following seems to say nothing that is not true of font
.\" description files in general; if so, it belongs in groff_font(5).
.\"The code field in the font description field gives the code which is
.\"used to output the character.
.\".
.\"This code can also be used in the
.\".I groff
.\".B \[rs]N
.\"escape sequence in a document.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.TP
.B \-b
Suppress the use of overstriking for bold characters.
.
Ignored if
.B \-c
isn't used.
.
.
.TP
.B \-B
Use only overstriking for bold-italic characters.
Ignored if
.B \-c
isn't used.
.
.
.TP
.B \-c
Use
.IR grotty 's
legacy output format
(see subsection \[lq]Legacy output format\[rq] above).
.
.
.TP
.B \-d
Ignore all
.B \[rs]D
.I roff
escapes
(draw commands).
.
By default,
.I grotty
renders
.BR \[rs]D\[aq]l \|.\|.\|.\& \[aq]
commands that have at least one zero argument
(and so are either horizontal or vertical)
using Unicode box drawing characters
(for the \[lq]utf8\[rq] device)
or the
.BR \- ,
.BR | ,
and
.B +
characters
(for all other devices).
.
In a similar way,
.I grotty
handles
.BR \[rs]D\[aq]p \|.\|.\|.\& \[aq]
commands which consist entirely of horizontal and vertical lines.
.
.
.TP
.B \-f
Use form feeds in the output.
.
A form feed is output at the end of each page that has no output on
its last line.
.
.
.TP
.BI \-F\~ dir
Prepend directory
.RI dir /dev name
to the search path for font and device description files;
.I name
describes the output device's character encoding,
one of
.BR ascii ,
.BR latin1 ,
.BR utf8 ,
or
.BR cp1047 .
.
.
.TP
.B \-h
Use literal horizontal tab characters in the output.
.
Tabs are assumed to be set every 8 columns.
.
.
.TP
.B \-i
Render italic-styled text
(fonts \[lq]I\[rq] and \[lq]BI\[rq])
with the SGR attribute for italic text
rather than underlined text.
.
Note that many terminals don't support this attribute;
however,
.IR xterm (1),
since patch\~#314 (2014-12-28),
does.
.
Ignored if
.B \-c
is also specified.
.
.
.TP
.B \-o
Suppress overstriking
(other than for bold and/or underlined characters when the legacy output
format is in use).
.
.
.TP
.B \-r
Render italic-styled text
(fonts \[lq]I\[rq] and \[lq]BI\[rq])
with the SGR attribute for reverse-video text
.\" ECMA-48, 2nd edition (1979) calls it "negative image".
rather than underlined text.
.
Ignored if
.B \-c
or
.B \-i
is also specified.
.
.
.TP
.B \-u
Suppress the use of underlining for italic characters.
.
Ignored if
.B \-c
isn't used.
.
.
.TP
.B \-U
Use only underlining for bold-italic characters.
.
Ignored if
.B \-c
isn't used.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
A list of directories in which to search for the
.IR dev name
directory in addition to the default ones.
.
See
.IR \%@g@troff (@MAN1EXT@)
and
.IR groff_font (@MAN5EXT@)
for more details.
.
.
.TP
.I GROFF_NO_SGR
If set,
.IR grotty 's
legacy output format is used;
see subsection \[lq]Legacy output format\[rq] above.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/devascii/DESC
Device description file for the \[lq]ascii\[rq] device.
.
.
.TP
.IR @FONTDIR@/devascii/ F
Font description file for font
.I F
of the \[lq]ascii\[rq] device.
.
.
.TP
.I @FONTDIR@/devcp1047/DESC
Device description file for the \[lq]cp1047\[rq] device.
.
.
.TP
.IR @FONTDIR@/devcp1047/ F
Font description file for font
.I F
of the \[lq]cp1047\[rq] device.
.
.
.TP
.I @FONTDIR@/devlatin1/DESC
Device description file for the \[lq]latin1\[rq] device.
.
.
.TP
.IR @FONTDIR@/devlatin1/ F
Font description file for font
.I F
of the \[lq]latin1\[rq] device.
.
.
.TP
.I @FONTDIR@/devutf8/DESC
Device description file for the \[lq]utf8\[rq] device.
.
.
.TP
.IR @FONTDIR@/devutf8/ F
Font description file for font
.I F
of the \[lq]utf8\[rq] device.
.
.
.TP
.I @MACRODIR@/tty.tmac
Macros for use with
.IR grotty .
.
.
.TP
.I @MACRODIR@/tty\-char.tmac
Additional character definitions for use with
.IR grotty .
.
.
.\" The following no longer seems to be true; an inspection of the
.\" font/*/dev*.am files suggests no evidence of it, at any rate.
.\".LP
.\"Note that on EBCDIC hosts,
.\"only files for the \[lq]cp1047\[rq] device are installed.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
.I grotty
is intended only for simple documents.
.
.
.LP
There is no support for fractional horizontal or vertical motions.
.
.
.LP
There is no support for the
.I roff
.B \[rs]D
escape sequence (draw command) other than horizontal and vertical lines.
.
.
.LP
Characters above the first line
(i.e., with a vertical position of\~0)
cannot be printed.
.
.
.LP
Color handling differs from
.IR grops (@MAN1EXT@).
.
The
.I groff
.B \[rs]M
escape sequence doesn't set the fill color for closed graphic objects
(which
.I grotty
doesn't support anyway)
but instead changes the background color of the character cell,
affecting all subsequent operations.
.
.
.\" ====================================================================
.SH Example
.\" ====================================================================
.
The following
.I groff
document exercises several features,
not all of which may be supported by a given output device:
(1)\~bold style;
(2)\~italic (underline) style;
(3)\~bold-italic style;
(4)\~character composition by overstriking (\[lq]co\[:o]perate\[rq]);
(5)\~foreground color;
(6)\~background color; and
(7)\~horizontal and vertical line-drawing.
.
.
.LP
.RS
.EX
You might see \ef[B]bold\ef[] and \ef[I]italic\ef[].
Some people see \ef[BI]both\ef[].
If the output device does (not) co\ez\e[ad]operate,
you might see \em[red]red\em[].
Black on cyan can have a \eM[cyan]\em[black]prominent\em[]\eM[]
\eD\[aq]l 1i 0\[aq]\eD\[aq]l 0 2i\[aq]\eD\[aq]l 1i 0\[aq] look.
\&.\e" If in nroff mode, end page now.
\&.if n .pl \en[nl]u
.EE
.RE
.
.
.LP
Compare and contrast the output of the following:
.
.
.LP
.RS
.EX
$ \c
.B nroff \c
.I file
$ \c
.B groff \-T ascii \c
.I file
$ \c
.B groff \-T utf8 \-Z \c
.I file \c
.B | grotty \-i
$ \c
.B groff \-T utf8 \-Z \c
.I file \c
.B | grotty \-c | ul
.EE
.RE
.
.
.\" I wish this went without saying...
.LP
Note that the example file above is a \[lq]raw\[rq]
.I groff
document,
not a man page.
.
.\" Yes, using \f[BI] here is slightly hypocritical.
Use of color escapes in man pages is \f[BI]strongly discouraged\f[].
.
Some implementations of
.IR man (1)
.\" ...like man-db 2.8.5-2 on Debian Buster...
completely disable them.
.
See subsection \[lq]Portability\[rq] of
.IR groff_man_style (@MAN7EXT@)
for guidance on writing man pages that are viewable by as many readers
as possible.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
\[lq]Control Functions for Coded Character Sets\[rq]
(ECMA-48)
5th\~edition,
Ecma International,
June\~1991.
.
A gratis version of ISO\~6429,
this document includes a normative description of SGR escape sequences.
.
Available at
.UR http://\:www\:.ecma\-international\:.org/\:publications/\:files/\:\
ECMA\-ST/\:Ecma\-048\:.pdf
.UE .
.
.
.LP
.IR groff (@MAN1EXT@),
.IR \%@g@troff (@MAN1EXT@),
.IR groff_out (@MAN5EXT@),
.IR groff_font (@MAN5EXT@),
.IR groff_char (@MAN7EXT@),
.IR ul (1),
.IR more (1),
.IR less (1),
.IR man (1)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grotty_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
