.TH grohtml @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
grohtml \- groff output driver for HTML
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1999-2020 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_grohtml_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY grohtml
.OP \-bhlnprVy
.OP \-a aa-text-bits
.OP \-D dir
.OP \-F dir
.OP \-g aa-graphic-bits
.OP \-i resolution
.OP \-I image-stem
.OP \-j filename
.OP \-o image-vertical-offset
.OP \-s size
.OP \-S level
.OP \-x html-dialect
.RI [ file
\&.\|.\|.\&]
.YS
.
.
.SY grohtml
.B \-\-help
.YS
.
.
.SY grohtml
.B \-v
.
.SY grohtml
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The
.I grohtml
front end (which consists of a preprocessor,
.IR pre-grohtml ,
and a device driver,
.IR post-grohtml )
translates the output of GNU
.I roff
to HTML.
.
Users should always invoke
.I grohtml
via the
.IR groff (@MAN1EXT@)
command with the
.B \-Thtml
option.
.
If no operands are given,
or if
.I file
is
.RB \[lq] \- \[rq],
.I grohtml
reads the standard input stream.
.
HTML output is written to the standard output stream.
.
When
.I grohtml
is run by
.IR groff ,
options can be passed to
.I grohtml
using
.IR groff 's
.B \-P
option.
.
.
.PP
.I grohtml
invokes
.I groff
twice.
.
In the first pass,
pictures,
equations,
and tables are rendered using the
.B ps
device,
and in the second pass HTML output is generated by the
.B html
device.
.
.
.PP
.I grohtml
always writes output in \%UTF-8 encoding and has built-in entities for
all non-composite Unicode characters.
.
In spite of this,
.I groff
may issue warnings about unknown special characters if they can't be
found during the first pass.
.
Such warnings can be safely ignored unless the special characters
appear inside a table or equation.
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message
and
.B \-v
shows version information;
both exit afterward.
.
.
.TP
.BI \-a \~aa-text-bits
Number of bits of antialiasing information to be used by
.I text
when generating PNG images.
.
The default is\~4 but valid values are 0,
1,
2,
and\~4.
.
Note that your version of
.I gs
needs to support the
.B \%\-dTextAlphaBits
and
.B \%\-dGraphicAlphaBits
options in order to exploit antialiasing.
.
A value of\~0 stops
.I grohtml
from issuing antialiasing commands to
.IR gs .
.
.
.TP
.B \-b
Initialize the background color to white.
.
.
.TP
.BI \-D \~dir
Instruct
.I grohtml
to place all image files into directory
.IR dir .
.
.
.TP
.B \-e
This option should not be directly specified;
it is an internal option used by
.I groff
when
.B \-Thtml
or
.B \-Txhtml
is specified.
.
.IR grohtml 's
preprocessor uses it to determine whether
.I eqn
should be directed to produce MathML
(if
.B \-Txhtml
is specified).
.
.
.TP
.BI \-F \~dir
Prepend directory
.RI dir /dev name
to the search path for font and device description files;
.I name
is the name of the device,
usually
.BR html .
.
.
.TP
.BI \-g \~aa-graphic-bits
Number of bits of antialiasing information to be used by
.I graphics
when generating PNG images.
.
The default is\~4 but valid values are 0,
1,
2,
and\~4.
.
Note your version of
.I gs
needs to support the
.B \%\-dTextAlphaBits
and
.B \%\-dGraphicAlphaBits
options in order to exploit antialiasing.
.
A value of\~0 stops
.I grohtml
from issuing antialiasing commands to
.IR gs .
.
.
.TP
.B \-h
Generate section and number headings by using
.BR <B> .\|.\|. </B>
and increasing the font size,
rather than using the
.BI <H n >\c
\&.\|.\|.\c
.BI </H n >
tags.
.
.
.TP
.BI \-i \~resolution
Select the resolution for all images.
.
By default this is 100 pixels per inch.
.
Example:
.B \-i200
indicates 200 pixels per inch.
.
.
.TP
.BI \-I \~stem
Determine the image stem name.
.
If omitted grohtml uses
.IR \%grohtml\- XXXXX
(where
.I XXXXX
is the process ID).
.
.
.TP
.BI \-j \~filename
Instruct
.I grohtml
to split the HTML output into multiple files.
.
The
.I filename
is the stem and output is written to a new file at each section heading
(but see option
.B \-S
below)
named
.IR filename\- n .html .
.
.
.TP
.B \-l
Turn off the production of automatic section links at the top of the
document.
.
.
.TP
.B \-n
Generate simple heading anchors whenever a section/number heading is
found.
.
Without the option the anchor value is the textual heading.
.
This can cause problems when a heading contains a \[lq]?\[rq] on older
versions of some browsers.
.
This flag is automatically turned on if a heading contains an image.
.
.
.TP
.BI \-o \~vertical-offset
Specify the vertical offset of images in points.
.
.
.TP
.B \-p
Display page rendering progress to the standard error stream.
.
.I grohtml
only displays a page number when an image is required.
.
.
.TP
.B \-r
Turn off the automatic header and footer line
(HTML rule).
.
.
.TP
.BI \-s \~size
Set the base point size of the source file.
.
Thereafter when this point size is used in the source it will correspond
to the HTML base size.
.
Every increase of two points in the source will yield a
.B <big>
tag, and conversely when a decrease of two points is seen a
.B <small>
tag is emitted.
.
.
.TP
.BI \-S \~level
When splitting HTML output
(see option
.B \-j
above),
split at each nested heading level defined by
.IR level ,
or higher).
.
The default is
.BR 1 .
.
.
.TP
.B \-V
Create an XHTML or HTML validator button at the bottom of each page of
the document.
.
.
.TP
.BI \-x \~dialect
Select HTML dialect.
.
Currently,
.I dialect
should be either the
.RB digit\~ 4
or the
.RB letter\~ x ,
which indicates whether
.I grohtml
should generate HTML\~4 or XHTML,
respectively.
.
This option should not be directly invoked by the user as it is
an internal option utilized by
.I groff
when
.B \-Thtml
or
.B \-Txhtml
is specified.
.
.
.TP
.B \-y
Produce a right-justified
.I groff
signature at the end of the document.
.
This is only generated if the
.B \-V
flag is also specified.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
There are styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to\~4.
.
.
.\" ====================================================================
.SH Dependencies
.\" ====================================================================
.
.I grohtml
is dependent upon the PNG utilities
.RI ( \%pnmcut ,
.IR \%pnmcrop ,
.IR \%pnmtopng )
and GhostScript
.RI ( gs ).
.
.I \%pnmtopng
(version 2.37.6 or greater)
and
.I \%pnmcut
from the netpbm package (version 9.16 or greater) will work also.
.
It is also dependent upon
.I \%psselect
from the PSUtils package.
.
Images are generated whenever a table,
picture,
equation or line
(such as a baseline rule or box rule)
is encountered.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.I grohtml
uses temporary files.
.
See
.IR groff (@MAN1EXT@)
for details about where such files are created.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
A list of directories in which to search for the
.IR dev name
directory in addition to the default ones.
.
See
.IR \%@g@troff (@MAN1EXT@)
and
.IR groff_font (@MAN5EXT@)
for more details.
.
.
.TP
.I SOURCE_DATE_EPOCH
A timestamp
(expressed as seconds since the Unix epoch)
to use as the creation timestamp in place of the current time.
.
.
.\" ====================================================================
.SH Bugs
.\" ====================================================================
.
.I grohtml
is still beta code.
.
.
.PP
.I grohtml
does not truly support hyphenation,
but you can fool it into hyphenating long input lines,
which can appear in HTML output with a hyphenated word followed by a
space but no line break.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.\" IR afmtodit (@MAN1EXT@),
.IR groff (@MAN1EXT@),
.IR \%@g@troff (@MAN1EXT@),
.\" IR psbb (1), \" XXX: what is this?
.\" IR groff_out (@MAN5EXT@),
.\" IR groff_char (@MAN7EXT@),
.IR groff_font (@MAN5EXT@)
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_grohtml_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
