.TH ditroff @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
ditroff \- device-independent typesetter roff
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2001-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of groff, the GNU roff type-setting system.
.\"
.\" Permission is granted to copy, distribute and/or modify this
.\" document under the terms of the GNU Free Documentation License,
.\" Version 1.3 or any later version published by the Free Software
.\" Foundation; with no Invariant Sections, with no Front-Cover Texts,
.\" and with no Back-Cover Texts.
.\"
.\" A copy of the Free Documentation License is included as a file
.\" called FDL in the main directory of the groff source package.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_ditroff_7_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The name
.I ditroff
refers to a historical development stage of the
.IR roff (@MAN7EXT@)
text processing system.
.
In
.I roff
systems extant today, the name
.I troff
is a synonym for
.IR ditroff .
.
.
.P
Early versions of
.I roff
by Joe Ossanna generated two programs from the same sources,
using conditional compilation to distinguish them.
.
.I nroff
produced text-oriented TTY output, while
.I troff
generated graphical output for exactly one output device, the
Wang Graphic Systems CAT phototypesetter.
.
.
.P
In 1979, Brian Kernighan rewrote
.I troff
to support more devices by creating an intermediate output format for
.I troff
that could be fed into postprocessor programs which actually do the
printout on the device.
.
Kernighan's version marks what is known as \(lqclassical troff\(rq
today.
.
In order to distinguish it from Ossanna's original version, it was
called
.I ditroff
.RI ( d "evice " i "ndependent " t roff)
on some systems, though this naming isn't mentioned in the classical
documentation.
.
.
.P
Today, all existing
.I roff
systems are based on Kernighan's multi-device
.IR troff .
.
The distinction between
.I troff
and
.I ditroff
is no longer necessary; each modern
.I troff
provides the complete functionality of
.IR ditroff .
.
.
.P
The easiest way to use
.I ditroff
is via the GNU
.I roff
system,
.IR groff .
.
The
.IR groff (@MAN1EXT@)
program is a wrapper around
.I (di)troff
that automatically handles device postprocessing.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
This document was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.TP
CSTR\~#54
refers to the 1992 revision of the
.I Nroff/Troff User's Manual
by J.\& F.\& Ossanna and Brian Kernighan.
.
.
.TP
CSTR\~#97
refers to
.IR "A Typesetter-independent TROFF" ,
by Brian Kernighan and is the original documentation of the first
multi-device
.I troff
.RI ( ditroff ).
.
.
.TP
.IR roff (@MAN7EXT@)
provides a history and conceptual overview of
.I roff
systems.
.
.
.TP
.IR \%@g@troff (@MAN1EXT@)
describes the GNU implementation of
.IR (di)troff .
.
.
.TP
.IR groff (@MAN1EXT@)
documents the GNU
.I roff
program and includes pointers to further documentation about
.IR groff .
.
.
.TP
.IR groff_out (@MAN5EXT@)
describes the
.I groff
version of the intermediate output language, the basis for
multi-device output.
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_ditroff_7_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
