'\" t
.TH gpinyin @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
gpinyin \- use Hanyu Pinyin Chinese in groff documents
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 2014-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of gpinyin, which is part of groff, a free
.\" software project.
.\"
.\" You can redistribute it and/or modify it under the terms of the GNU
.\" General Public License version 2 as published by the Free Software
.\" Foundation.
.\"
.\" The license text is available in the internet at
.\" <http://www.gnu.org/licenses/gpl-2.0.html>.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_gpinyin_1_man_C \n[.cp]
.cp 0
.
.
.\" ====================================================================
.\" Local definitions
.\" ====================================================================
.
.\" Define a string for the TeX logo.
.ie t .ds TeX T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el   .ds TeX TeX
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY gpinyin
.RI [ input-file \~.\|.\|.\&]
.YS
.
.
.SY gpinyin
.B \-h
.
.SY gpinyin
.B \-\-help
.YS
.
.SY gpinyin
.B \-v
.
.SY gpinyin
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I gpinyin
is a preprocessor for
.IR groff (@MAN1EXT@)
that facilitates use of Hanyu Pinyin in
.IR groff (@MAN7EXT@)
files.
.
Pinyin is a method for writing the Chinese language with the Latin
alphabet.
.
The Chinese language consists of more than four hundred syllables,
each with one of five different tones.
.
In Pinyin,
a syllable is written in the Latin alphabet and a numeric tone indicator
can be appended to each syllable.
.
.
.P
Each
.I input-file
is a file name or the hyphen-minus character \[lq]\-\[rq] to indicate
that the standard input stream should be read.
.
As usual,
the argument \[lq]\-\-\[rq] can be used in order to force interpretation
of all remaining arguments as file names,
even if an
.I input-file
argument begins with the hyphen-minus character.
.
.B \-h
and
.B \-\-help
display a usage message,
while
.B \-v
and
.B \-\-version
show version information;
all exit afterward.
.
.
.\" ====================================================================
.SS "Pinyin sections"
.\" ====================================================================
.
Pinyin sections in
.I groff
files are enclosed by two
.B .pinyin
requests with different arguments.
.
The starting request is
.RS
.EX
\&.pinyin start
.EE
.RE
or
.RS
.EX
\&.pinyin begin
.EE
.RE
and the ending request is
.RS
.EX
\&.pinyin stop
.EE
.RE
or
.RS
.EX
\&.pinyin end
.EE
.RE
\&.
.
.
.\" ====================================================================
.SS Syllables
.\" ====================================================================
.
The phonetic Chinese language comprises about four hundred syllables.
.
In Pinyin,
each syllable is represented by one to six letters drawn from the
fifty-two upper- and lowercase letters of the Unicode basic Latin
character set,
plus the letter \[lq]U\[rq] with dieresis (umlaut) in both cases\[em]in
other words,
the members of the set \[lq][a\[en]zA\[en]Z\[:u]\[:U]]\[rq].
.
.
.P
In
.I groff
input,
all basic Latin letters are written as themselves.
.
The \[lq]u with dieresis\[rq] can be written as
\[lq]\e[:u]\[rq]
in lowercase or
\[lq]\e[:U]\[rq]
in uppercase.
.
Within
.B .pinyin
sections,
.I gpinyin
supports the form
\[lq]ue\[rq]
for lowercase and the forms
\[lq]Ue\[rq]
and
\[lq]UE\[rq]
for uppercase.
.
.
.\" ====================================================================
.SS Tones
.\" ====================================================================
.
Each syllable has exactly one of five
.IR tones .
.
The fifth tone is not explicitly written at all,
but each of the first through fourth tones is indicated with a diacritic
above a specific vowel within the syllable.
.
.
.P
In a
.I gpinyin
source file,
these tones are written by adding a numeral in the range 0 to 5 after
the syllable.
.
The tone numbers 1 to 4 are transformed into accents above vowels in the
output.
.
The tone numbers 0 and 5 are synonymous.
.
.
.P
The following table summarizes the tones.
.
Some output devices will not be able to render every output example.
.
.
.P
.if t .ne 8 \" Try to keep the table on one page for printed output.
.TS
l l l l l.
Tone	Description	Diacritic	Example Input	Example Output
_
first	flat	\[a-]	ma1	m\[u0061_0304]
second	rising	\[aa]	ma2	m\[u0061_0301]
third	falling-rising	\[ah]	ma3	m\[u0061_030C]
fourth	falling	\[ga]	ma4	m\[u0061_0300]
fifth	neutral	(none)	ma0	ma
\^	\^	\^	ma5	\^
.TE
.
.
.P
The neutral tone number can be omitted from a word-final syllable,
but not otherwise.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I gpinyin
was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
Useful documents on the World Wide Web related to Pinyin include
.RS 4n
.UR http://\:www\:.foolsworkshop\:.com/\:ptou/\:index\:.html
.I Pinyin to Unicode
.UE ,
.
.br
.UR http://\:www\:.mandarintools\:.com/
.I On-line Chinese Tools \" sic: On-line
.UE ,
.
.br
.UR http://\:www\:.pinyin\:.info/\:index\:.html
.I Pinyin.info: a guide to the writing of Mandarin Chinese in \
romanization
.UE ,
.
.br
.UR http://\:www\:.pinyin\:.info/\:rules/\:where.html
\[lq]Where do the tone marks go?\[rq]
.UE ,
.
.br
.UR http://\:git\:.savannah\:.gnu\:.org/\:gitweb/\:\
?p=cjk\:.git\:;a=blob_plain\:;f=doc/\:pinyin\:.txt\:;hb=HEAD
.I pinyin.txt
from the CJK macro package for \*[TeX]
.UE ,
.br
.RS -4n
and
.RE
.
.br
.UR http://\:git\:.savannah\:.gnu\:.org/\:gitweb/\:\
?p=cjk\:.git\:;a=blob_plain\:;f=texinput/\:pinyin\:.sty\:;hb=HEAD
.I pinyin.sty
from the CJK macro package for \*[TeX]
.UE .
.
.RE
.
.
.P
.IR groff (@MAN1EXT@)
and
.IR grog (@MAN1EXT@)
explain how to view
.I roff
documents.
.
.
.P
.IR groff (@MAN7EXT@)
and
.IR groff_char (@MAN7EXT@)
are comprehensive references covering the language elements of GNU
.I troff \" GNU
and the available glyph repertoire,
respectively.
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_gpinyin_1_man_C]
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
