.TH PIC2GRAPH @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH NAME
pic2graph \- convert a PIC diagram into a cropped image
.
.
.\" ====================================================================
.\" Legalese
.\" ====================================================================
.\"
.\" This documentation is released to the public domain.
.
.
.\" ====================================================================
.SH SYNOPSIS
.\" ====================================================================
.
.SY pic2graph
.OP \-unsafe
.OP \-format output-format
.OP \-eqn delimiters
.RI [ convert-arguments ]
.YS
.
.SY pic2graph
.B \-\-help
.YS
.
.SY pic2graph
.B \-v
.SY pic2graph
.B \-\-version
.YS
.
.
.\" ====================================================================
.SH DESCRIPTION
.\" ====================================================================
.
.I pic2graph
reads a
.BR @g@pic (@MAN1EXT@)
program from the standard input and writes an image file,
by default in Portable Network Graphics (PNG) format,
to the standard output.
.
It furthermore translates
.BR @g@eqn (@MAN1EXT@)
constructs, so it can be used for generating images of mathematical
formulae.
.
.
.PP
The input
.I PIC
code should
.I not
be wrapped with the
.B \&.PS
and
.B \&.PE
macros that normally guard it within
.BR groff (@MAN1EXT@)
documents.
.
.
.\" FIXME: How old?  This text hasn't been touched since 2008 at latest.
.\" Older versions of
.\" .I \%convert
.\" will produce a black-on-white graphic; newer ones may produce a
.\" black-on-transparent graphic.
.
.PP
Arguments not recognized by
.I pic2graph
are passed to the ImageMagick or GraphicsMagick program
.BR \%convert (1).
.
.
By specifying these, you can give your image a border,
.\" Transparent backgrounds are the default in 2018.
.\" force the background transparent,
set the image's pixel density,
or perform other useful transformations.
.
.
.PP
The output image is clipped using
.IR convert 's
.B \-trim
option to the smallest possible bounding box that contains all the black
pixels.
.
.
.\" ====================================================================
.SH OPTIONS
.\" ====================================================================
.
.TP
.B \-unsafe
Run
.I groff
in
.I unsafe
mode, enabling the
.I PIC
command
.B sh
to execute arbitrary Unix shell commands.
.
The
.I groff
default is to forbid this.
.
.
.TP
.BI "\-format " output-format
Write the image in
.IR output-format ,
which must be understood by
.IR convert ;
the default is PNG.
.
.
.TP
.BI "\-eqn " delimeters
Use
.I delimeters
as the opening and closing
characters that delimit
.I @g@eqn
directives;
the default is \(lq$$\(rq.
.
The option argument
.I delimeters
should be a two-character string,
but an empty string (\(dq\(dq) is accepted as a directive to disable
.I @g@eqn
processing.
.
.
.TP
.B \-\-help
Display a brief usage message and exit.
.
.
.TP
.B \-v
.TQ
.B \-\-version
Display
.IR pic2graph 's
version string and exit.
.
.
.\" ====================================================================
.SH ENVIRONMENT
.\" ====================================================================
.
.TP
.B \%GROFF_TMPDIR
.TQ
.B \%TMPDIR
.TQ
.B \%TMP
.TQ
.B \%TEMP
These environment variables are searched in the given order to determine
the directory where temporary files will be created.
.
If none are set,
.I /tmp
is used.
.
.
.\" ====================================================================
.SH AUTHORS
.\" ====================================================================
.
.I pic2graph
was written by
.MT esr@\:thyrsus.com
Eric S.\& Raymond
.ME ,
based on a recipe by W.\& Richard Stevens.
.
.
.\" ====================================================================
.SH "SEE ALSO"
.\" ====================================================================
.
.BR eqn2graph (@MAN1EXT@),
.BR grap2graph (@MAN1EXT@),
.BR @g@pic (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR groff (@MAN1EXT@),
.BR \%convert (1)
.
.
.PP
W.\& Richard Stevens,
.UR http://\:www.kohala.com/\:start/\:troff/\:pic2html.html
.I Turning PIC into HTML
.UE
.
.
.\" Local Variables:
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff:
