/*
 * GNU Paint
 * Copyright 2000-2003, 2007  Li-Cheng (Andy) Tai
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glade/glade.h>
#include "global.h"
#include "debug.h"
#include "canvas.h"
#include "tool_palette.h"
#include "util.h"


static GList *window_list = 0;
static void create_window(void);
extern void text_set_fontpicker(gpaint_tool *tool, GtkFontButton *fontpicker);



#define WIDTH  740
#define HEIGHT 680


int
main (int argc, char *argv[])
{


    debug_fn();
#ifdef ENABLE_NLS
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
    textdomain (GETTEXT_PACKAGE);
#endif


    gtk_init(&argc, &argv);
    glade_init();

    canvas_init_arg(argc, argv);
    create_window();

    gtk_main();
    debug("main() returning");
    return 0;
}

static void main_window_ui_initial_adjustment(GtkWidget *main_window)
{
    GtkWidget *widget;
    tool_palette_set_active_button(main_window, "pen_button");
        /* make the pen tool the default initial tool so the user can draw right away */

    gpaint_tool *text_tool = tool_palette_get_tool(main_window, "text");
    widget = lookup_widget(main_window, "fontpicker");
    text_set_fontpicker(text_tool, widget);

#if (!defined(HAVE_GTK_PRINT) && !defined(HAVE_GNOME_PRINT))
/* disable print menus and buttons if no print support available*/
    widget = lookup_widget(main_window, "print_button");
    g_assert(widget);
    gtk_widget_set_sensitive(widget, FALSE);
    widget = lookup_widget(main_window, "print_menu");
    g_assert(widget);
    gtk_widget_set_sensitive(widget, FALSE);
    widget = lookup_widget(main_window, "print_preview_menu");
    if (widget)
        gtk_widget_set_sensitive(widget, FALSE);

#endif

}

static void
create_window(void)
{
    GladeXML *glade_xml = glade_xml_new(GLADE_DATA_FILE, NULL, NULL);
    GtkWidget *main_window ;
    g_assert(glade_xml);
    glade_xml_signal_autoconnect(glade_xml);

    main_window = glade_xml_get_widget(glade_xml, "main_window");
    debug_fn1("main_window = %p", main_window);

    g_object_set_data_full((gpointer) main_window, GLADE_XML, (gpointer) glade_xml,
    g_object_unref);

    gtk_window_set_default_size(GTK_WINDOW(main_window), WIDTH, HEIGHT);
    gtk_widget_show_all(main_window);

    main_window_ui_initial_adjustment(main_window);

}


void
on_mainwindow_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
    debug_fn1("widget = %p", widget);
    gtk_widget_ref(widget);
    window_list = g_list_prepend(window_list, (gpointer*)widget);
}

gboolean
on_mainwindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gpaint_canvas *canvas;
    gboolean cancel_exit;

    /* The window is about to be destroyed. Give the user a
     * chance to save their changes before the program exits! */
    debug_fn();
    canvas = canvas_lookup(widget);
    canvas_commit_change(canvas);
    cancel_exit = drawing_prompt_to_save(canvas->drawing);
    debug1("cancel_exit is %d", cancel_exit);

    /* When this function returns FALSE, the delete-event signal
     * generates a destroy signal. */
    return cancel_exit;
}

void
on_mainwindow_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
    GtkWidget *widget = GTK_WIDGET(object);

    debug_fn();
    window_list = g_list_remove(window_list, (gpointer)widget);

    gtk_widget_unref(widget);   /* removed from list */
    gtk_widget_destroy(widget); /* cleanup window and child objects */
    if (!window_list)  /* if window list is empty */
    {
        debug("window list is empty, exiting application...");
        gtk_main_quit();
    }
}

gboolean
on_mainwindow_focus_in_event           (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
    gpaint_canvas *canvas = canvas_lookup(widget);
    GtkWidget *drawing_area = GTK_WIDGET(canvas->drawing_area);

    debug_fn();
    canvas_focus_gained(canvas);
    gtk_widget_grab_focus(drawing_area);
    gtk_widget_grab_default(drawing_area);
    return FALSE;
}

gboolean
on_mainwindow_focus_out_event          (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
    gpaint_canvas *canvas = canvas_lookup(widget);
    debug_fn();
    canvas_focus_lost(canvas);
    return FALSE;
}

void
on_mainwindow_set_focus_child          (GtkContainer    *container,
                                        GtkWidget       *widget,
                                        gpointer         user_data)
{
    gpaint_canvas *canvas = canvas_lookup(GTK_WIDGET(container));
    GtkWidget *drawing_area = GTK_WIDGET(canvas->drawing_area);
    if (widget != drawing_area)
    {
        canvas_focus_lost(canvas);
    }
}

void
on_mainwindow_set_focus                (GtkWindow       *window,
                                        GtkWidget       *widget,
                                        gpointer         user_data)
{
    gpaint_canvas *canvas = canvas_lookup(GTK_WIDGET(window));
    GtkWidget *drawing_area = GTK_WIDGET(canvas->drawing_area);
    if (widget != drawing_area)
    {
        canvas_focus_lost(canvas);
    }
}

/* todo: move to menu handlers to menu.c */
void
on_create_new_window(GtkMenuItem *menuitem, gpointer user_data)
{
    create_window();
}

/* todo: move to menu handlers to menu.c */
void
on_close_window_activate(GtkMenuItem *menuitem, gpointer user_data)
{
    gpaint_canvas *canvas;
    GtkWidget *top_level_widget;
    gboolean cancel_exit;
    debug_fn();

    /* Give the user a chance to save their changes before the program exits! */
    canvas = canvas_lookup(GTK_WIDGET(menuitem));
    top_level_widget = GTK_WIDGET(canvas->top_level);
    debug1("top_level_widget=%p", top_level_widget);
    canvas_commit_change(canvas);

    cancel_exit = drawing_prompt_to_save(canvas->drawing);
    debug1("cancel_exit is %d", cancel_exit);

    if (!cancel_exit)
    {
        gtk_widget_destroy(top_level_widget);
    }
}

/* todo: move to menu handlers to menu.c */
static gboolean
main_prompt_to_quit(GtkWidget *widget)
{
    gpaint_canvas *canvas = canvas_lookup(widget);
    GtkWidget *dialog;
    gint result;
    gboolean quit = FALSE;

    dialog = gtk_message_dialog_new(
               GTK_WINDOW(canvas->drawing->top_level),
               GTK_DIALOG_MODAL,
               GTK_MESSAGE_WARNING,
               GTK_BUTTONS_NONE,
               "You have more than one window open.\nDo you really want to quit?");
    gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_NO,  GTK_RESPONSE_NO);
    gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_YES, GTK_RESPONSE_YES);

    result = gtk_dialog_run(GTK_DIALOG(dialog));
    gtk_widget_destroy(GTK_WIDGET(dialog));
    while (gtk_events_pending())
    {
       gtk_main_iteration();
    }
    switch (result)
    {
        case GTK_RESPONSE_YES:
            quit = TRUE;
            break;
        case GTK_RESPONSE_NO:
            quit = FALSE;
    }
    return quit;
}

/* todo: move to menu handlers to menu.c */
void
on_quit_menu_activate(GtkMenuItem *menuitem, gpointer user_data)
{
    GList *list = NULL;
    GList *node = NULL;
    GtkWidget *widget = NULL;
    gpaint_canvas *canvas = NULL;
    debug_fn();

    /* Make a local copy of the list so elements can be removed
     * from the window_list as windows are destroyed. */
    list = g_list_copy(window_list);

    if (g_list_length(list)>1)
    {
        if (!main_prompt_to_quit(GTK_WIDGET(menuitem)))
        {
            return;
        }
    }

    node = g_list_first(list);
    debug1("first node => %p", node);
    while (node)
    {
        g_assert(node->data);
        widget = GTK_WIDGET(node->data);
        canvas = canvas_lookup(widget);
        canvas_commit_change(canvas);
        if (!drawing_prompt_to_save(canvas->drawing))
        {
            gtk_widget_destroy(widget);
        }

        node = g_list_next(node);
        debug1("next node => %p", node);
    }
}

GtkWidget*
create_new_canvas_window (void)
{
    GladeXML *glade_xml = 0;
    GtkWidget *widget;
    if (glade_xml == 0)
    {
        glade_xml = glade_xml_new(GLADE_DATA_FILE, NULL, NULL);
        glade_xml_signal_autoconnect(glade_xml);
    }
    g_assert(glade_xml);
    widget = glade_xml_get_widget(glade_xml, "new_canvas_window");

    g_object_set_data_full((gpointer) widget, GLADE_XML, (gpointer) glade_xml,
        g_object_unref);
    return widget;

}
