
/*
    Copyright 2000  Li-Cheng (Andy) Tai

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __UTIL_H__
#define __UTIL_H__

#include <gtk/gtk.h>
#include "image_buf.h"
#include "fileio.h"

#define DEFAULT_WIDTH 640
#define DEFAULT_HEIGHT 480

extern GdkCursor *busycursor; 
GtkWidget *widget_get_toplevel_parent(GtkWidget *widget);

image_buf *widget_get_image(GtkWidget *widget);

void new_canvas();

GtkWidget *create_scroll_frame_widget(void);
GtkWidget *create_scroll_frame_widget_content(GtkWidget *, GtkWidget *);

void open_canvas(image_buf *ibuf);

void save_canvas(image_buf *ibuf);


void set_button_pixmap(GtkButton *button, unsigned char **pixmap);

void set_drawing_tool(image_buf *, DRAWING_TOOL);

void select_toolbar_toggle_button(GtkToggleButton *selected, int setmode);

void StateTimeStep();


void handle_button_press(image_buf *, int x, int y);
void handle_button_move(image_buf *, int x, int y);
void handle_button_release(image_buf *, int x, int y);


void handle_key_release(image_buf *, GdkEventKey *);

void image_buf_set_tool(image_buf *ibuf, DRAWING_TOOL tool);

void image_buf_set_fill(image_buf *ibuf, int filled);

void spreadimage(image_buf * input, image_buf *output);

void GdkColor_to_rgb(const GdkColor *color, unsigned char *r, unsigned char *g, unsigned char *b);

#endif
