/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_COM_INTERFACE_BUILDER
    Description : Produces COM-Like Interfaces
    Author      : David Martnez Oliveira
    Date        : 30 January 2009
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class EDMA_COM_INTERFACE_BUILDER
***************************************************
*/
 
typedef struct
{
	EPChar		FileName;
	EUint32		h;
}DtEDMA_COM_INTERFACE_BUILDER;
/*
***************************************************
  Method Declaration for class EDMA_COM_INTERFACE_BUILDER
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_COM_INTERFACE_BUILDERbuildU32Z(OBJID IdObj, OBJID id, EPChar filename)
{
  DtEDMA_COM_INTERFACE_BUILDER	*m;
  EPChar                        h_filename;
  FILE                          *f;
  EUint32                       i, n;
  ESint32                       major_version, minor_version;
  EUint32                       m_virtual, m_abstract, m_static;
  EChar                         return_type[EDMA_GENERAL_ID_LEN];
  EChar                         temp[EDMA_GENERAL_ID_LEN];
  EChar                         temp1[EDMA_GENERAL_ID_LEN];
  EChar                         ClassName[EDMA_CLASS_NAME_LEN];


  m = (DtEDMA_COM_INTERFACE_BUILDER *) edma_get_data_ref (IdObj);

  edma_rprop3 (id, "ClassName", ClassName);
  edma_rprop3 (id, "MajorVersion", &major_version);
  edma_rprop3 (id, "MinorVersion", &minor_version);


  /* Open file to store warpper */
  h_filename = malloc (strlen (ClassName) + 4);
  memset (h_filename, 0, strlen (ClassName) + 4);
  sprintf (h_filename, "I%s.h", ClassName);


  edma_printf ("Producing file: '%s'", h_filename);
  if ((f = fopen (h_filename,"wt")) == NULL)
    {
      edma_printf_obj(IdObj,"Can't open file %s for writting",filename);
      return -1;
    }


  /* FIXME: Before beginning to generate the file, 
     we'd test if our class is pure abstract
     In that case, code generation has no sense*/
  

  /* Write GPL Notice on source file*/


  fprintf (f, "/*\n");
  fprintf (f, "* EDMA: Entorno de Desarrollo Modular y Abierto\n");
  fprintf (f, "* Object Oriented and Componetware Framework\n");
  fprintf (f, "* Copyright (C) __DATE__\n");
  fprintf (f, "*    __AUTHOR__\n");
  fprintf (f, "*\n");
  fprintf (f, "* This file is part of __PACKAGE__\n");
  fprintf (f, "*\n");
  fprintf (f, "* This program is free software: you can redistribute "
	   "it and/or modify\n");
  fprintf (f, "* it under the terms of the GNU Lesser General Public License "
	   "as published by\n");
  fprintf (f, "* the Free Software Foundation, either version 3 "
	   "of the License, or\n");
  fprintf (f, "* (at your option) any later version.\n");
  fprintf (f, "*\n");
  fprintf (f, "* This program is distributed in the hope that "
	   "it will be useful,\n");
  fprintf (f, "* but WITHOUT ANY WARRANTY; without even the "
	   "implied warranty of\n");
  fprintf (f, "* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  "
	   "See the\n");
  fprintf (f, "* GNU Lesser General Public License for more details.\n");
  fprintf (f, "*\n");
  fprintf (f, "* You should have received a copy of the "
	   "GNU Lesser General Public License\n");
  fprintf (f, "* along with program.  "
	   "If not, see <http://www.gnu.org/licenses/>.\n");
  fprintf (f, "*/\n");




  /* Generate Class Record */
  fprintf (f, "\n/*\n**************************************************");
  fprintf (f, "\n    Entorno de Desarrollo Modular y Abierto (EDMA)");
  fprintf (f, "\n    (c) David Martnez Oliveira");
  fprintf (f, "\n    File generated by : EDMA COM Interface Builder class");
  fprintf (f, "\n------------------------------------------------------");
  fprintf (f, "\n    Module Type : CLASS COM INTERFACE");
  fprintf (f, "\n    Class List  : %s", ClassName);
  fprintf (f, "\n    Description :");
  fprintf (f, "\n    Author      :");
  fprintf (f, "\n    Date        :");
  fprintf (f, "\n    Version     : %ld.%ld", major_version, minor_version);
  fprintf (f, "\n-----------------------------------------------------");
  fprintf (f, "\n  REVISIONS :");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n ");

  /* Generate include files */
  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  General Header Files");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n "); 

  fprintf (f, "\n/* Add here the includes you need for your class*/");
  fprintf (f, "\n");

  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  EDMA Header Files");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n "); 
  fprintf (f,"\n#include <edma.h>");
  fprintf (f,"\n");

  /* Generate COM Like Iface struct */
  edma_rprop3 (id, "nMet", &n);
  fprintf (f, "\n/*****************************************************/\n");
  fprintf (f, "typedef struct %s_com_iface_t {\n", ClassName);
  edma_printf ("Dumping %d methods...", n);
  for (i = 0; i < n; i++)
    {
      strcpy (return_type, "ESint32") ;
      edma_met3 (id, "GetMet", i, temp, temp1, &m_virtual
		 , &m_abstract, &m_static);
      fprintf (f, "  %s (%s*)(OBJID id,", return_type, temp);
      fprintf (f, ");\n");
    }
  fprintf (f, "} *I%s;\n\n", ClassName);


  
  fprintf (f, "\n\n/********** END COM Like Interface SKELETON ***********/");
  fclose (f);

  free (h_filename);
  return 0;
}


ESint32
EDMA_COM_INTERFACE_BUILDER_class_factory ()
{
CLASSID    cid;

cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

edma_idf_set_class_name (cid, "EDMA_COM_INTERFACE_BUILDER");

edma_idf_set_class_namespace (cid, "tools/idfw");
edma_idf_set_class_version (cid, 0, 0);

edma_add_local_class_property (cid, "FileName", DT_EZSTRING, E_L, 0);

 /* Method registration */
edma_add_local_class_method (cid, "build", "U32Z", (PPROC)EDMA_COM_INTERFACE_BUILDERbuildU32Z, 0, 0, 0);

edma_idf_set_class_id (cid);

return 0;
}


/********** END C IMPLEMENTATION SKELETON ******************/
