/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */


/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_SCRIPT
    Description : Runs System-Related scripts
    Author      : David Martnez Oliveira
    Date        : September, 18th, 2005
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
#include <stdio.h>
#include <string.h>
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class EDMA_SCRIPT
***************************************************
*/
 
typedef struct
{
	EPChar		script_code;
	OBJID		interpreter;
	EDMAT_BUFFER	private;
}DtEDMA_SCRIPT;
/*
***************************************************
  Method Declaration for class EDMA_SCRIPT
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_SCRIPTset_scriptZrS32(OBJID IdObj, EPChar script_name)
{
  DtEDMA_SCRIPT	*m;

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);
  // Determines the kind of interpreter to use
  // XXX: Should take them from a table somewhere
  //      For now just a quick hack for testing
  if (strstr (script_name, ".py"))
    {
      // Specialise to ANNA_PYTHON_INTERPRETER
      edma_met3 (IdObj, "ANNA_PYTHON_INTERP@INTERPRETER<Initialize");
      edma_met3 (IdObj, "Run_Script", script_name);
      return 0;
    }
  return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTupdate_objectOOrS32(OBJID IdObj, OBJID newid, OBJID oldid)
{
  DtEDMA_SCRIPT	*m;
  EChar         cmd[1024];

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);
  // Run function and setup parameters 
  // First run script to define function...
  sprintf (cmd, "update (%ld,%ld);", newid, oldid);
  edma_met3 (IdObj, "Run_SimpleString", cmd);
  return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTrunrS32(OBJID IdObj)
{
  DtEDMA_SCRIPT	*m;

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);

  return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTborn(OBJID IdObj)
{
  DtEDMA_SCRIPT	*m;

 m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);
 m->script_code = NULL;
 m->interpreter = -1;

 return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTrip(OBJID IdObj)
{
  DtEDMA_SCRIPT	*m;

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "Ddestroying Object...");
  edma_met3 (IdObj,"Finalize");
  if (m->interpreter != -1) edma_free_obj (m->interpreter);

  return 0;
}


ESint32
EDMA_SCRIPT_class_factory ()
{
  CLASSID    cid;

  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "EDMA_SCRIPT");
  
  edma_idf_set_class_namespace (cid, "system");
  edma_idf_set_class_version (cid, 0, 0);
  
  edma_add_local_class_property (cid, "script_code", DT_EZSTRING, E_L, 0);
  edma_add_local_class_property (cid, "interpreter", DT_EOBJECT, E_L, 0);
  edma_add_local_class_property (cid, "private", DT_EBUFFER, E_L, 0);
  
  /*UNKNOW (~@~@~@)*/
  /*UNKNOW (~@~@~@)*/
  /* Method registration */
  edma_add_local_class_method (cid, "set_script", "ZrS32", 
			       (PPROC)EDMA_SCRIPTset_scriptZrS32, 1, 0, 0);
  edma_add_local_class_method (cid, "update_object", "OOrS32", 
			       (PPROC)EDMA_SCRIPTupdate_objectOOrS32, 1, 0, 0);
  edma_add_local_class_method (cid, "run", "rS32", 
			       (PPROC)EDMA_SCRIPTrunrS32, 1, 0, 0);
  edma_add_local_class_method (cid, "born", "", 
			       (PPROC)EDMA_SCRIPTborn, 0, 0, 0);
  edma_add_local_class_method (cid, "rip", "", 
			       (PPROC)EDMA_SCRIPTrip, 0, 0, 0);
  
  edma_idf_set_class_id (cid);
 
  return 0;
}

/********** END C IMPLEMENTATION SKELETON ******************/
