/* translation of file(s)
	"petrinet-patterns-basic.k"
	"petrinet-patterns-structured.k"
	"petrinet-patterns-scopes.k"
	"petrinet-patterns-handlers.k"
	"petrinet-patterns-links.k"
	"petrinet-patterns-shortcuts.k"
	"ast-grammar.k"
	"ast-config.k"
	"ast-to-petrinet.k"
	"ast-to-xml.k"
	"ast-to-cfg.k"
	"ast-postprocess.k"
	"ast-rewrite.k"
	"ast-to-visualization.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_UNPARSE

#include <stdio.h>
#include <string>
#include <stdlib.h>
#include "ast-system-k.h"
#include "ast-system-unpk.h"


namespace kc {
base_uview_class base_uview;
petrinetsmall_class petrinetsmall;
petrinetnew_class petrinetnew;
xml_class xml;
cfg_class cfg;
postprocessing_class postprocessing;
evaluation_class evaluation;
visualization_class visualization;

impl_uviews uviews[] = {
    {"base_uview",&base_uview},
    {"petrinetsmall",&petrinetsmall},
    {"petrinetnew",&petrinetnew},
    {"xml",&xml},
    {"cfg",&cfg},
    {"postprocessing",&postprocessing},
    {"evaluation",&evaluation},
    {"visualization",&visualization},
    {0,0}
};

} // namespace kc
namespace kc { }
using namespace kc;
/* included stuff */
#line 98 "ast-config.k"
#include <iostream>
#include <cmath>
#include <cassert>
#include <map>
#include <set>
#include <climits>
#include <string>

#include "petrinet-patterns-basic.h"
#include "petrinet-patterns-structured.h"
#include "petrinet-patterns-scopes.h"
#include "petrinet-patterns-handlers.h"
#include "petrinet-patterns-links.h"
#include "extension-wsdl.h"			// for class WSDL
#include "options.h"
#include "cfg.h"
#include "helpers.h"
#include "ast-details.h"
#include "ast-tools.h"
#include "globals.h"
#include "extension-chor.h"

using std::endl;
using std::cerr;

extern PetriNet PN;				// introduced in main.c
extern CFGBlock * CFG;				// introduced in cfg.cc

#line  85 "ast-system-unpk.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void
impl_abstract_phylum::unparse(printer_function opf, uview uv)
{
    printer_functor_function_wrapper pf(opf);
    do_unparse(pf, uv);
}

// Everything given as a pointer is expected to have an unparse-method (we
// believe it's a phylum), unless there's a specialisation for it

void
unparse(abstract_phylum kc_p, printer_functor kc_printer, uview kc_current_view)
{
    kc_p->unparse(kc_printer, kc_current_view);
}

void
unparse(void *kc_p, printer_functor kc_printer, uview kc_current_view)
{
    // MPi: 20020628 there shouldn't be any left
    assertionFailed("Unparse called for untyped pointer");
    // MPi: cast should be unnecessary, but there are still void*
    reinterpret_cast<impl_abstract_phylum*>(kc_p)->unparse(kc_printer, kc_current_view);
}

void
unparse(int kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_integer(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(double kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_real(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(kc_char_t *kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v, kc_current_view);
}

void
unparse(kc_string_t kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v.c_str(), kc_current_view);
}

#line  148 "ast-system-unpk.cc"
void
impl_abstract_phylum::default_unparse(printer_functor kc_printer, uview kc_current_view)
{
    register int no_sons = operator_info[prod_sel()].no_sons;
    for (int i=0; i < no_sons; i++)
    subphylum(i)->unparse(kc_printer, kc_current_view);
}

void
impl_casestring__Str::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_nocasestring_NoCaseStr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_integer__Int::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_real__Real::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_voidptr__VoidPtr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(pointer, kc_printer, kc_current_view);
}


#line  188 "ast-system-unpk.cc"
void
impl_tProcess_Process::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 60 "ast-to-visualization.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 60 "ast-to-visualization.k"
		const tPartner_list b = this->tPartner_list_1;
#line 60 "ast-to-visualization.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 60 "ast-to-visualization.k"
		const tVariable_list c = this->tVariable_list_1;
#line 60 "ast-to-visualization.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 60 "ast-to-visualization.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 60 "ast-to-visualization.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 60 "ast-to-visualization.k"
		const activity i = this->activity_1;
#line 60 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 63 "ast-to-visualization.k"

		globals::visArcs = "";
		(*output) << "digraph N {" << endl;
		(*output) << " graph [fontname=\"Helvetica\" label=\"";
		(*output) << "Visualization of the BPEL-Process generated from " << globals::filename << "\"]" << endl;
		(*output) << "compound = true;" << endl;
		globals::ASTEmap[_id->value]->visConnection = "Process_Start";

#line  223 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 72 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Process activity\";" << endl;  

#line  234 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 76 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[i->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[i->id]->secVisConnection;
		(*output) << "}" << endl;    

		unsigned int linkId;
		unsigned int source;
		unsigned int target;
		for(set<string>::iterator names = globals::ASTE_linkNames.begin(); names != globals::ASTE_linkNames.end(); names++)
		{
		    linkId = globals::ASTE_linkIdMap[(*names)];

		    source = globals::ASTEmap[linkId]->sourceActivity;
		    target = globals::ASTEmap[linkId]->targetActivity;

		    globals::visArcs += globals::ASTEmap[source]->visConnection + " -> " + globals::ASTEmap[target]->secVisConnection + "["; 
		    if (globals::ASTEmap[target]->structured())
		    {
			globals::visArcs += "lhead=";
			globals::visArcs += "cluster";          
			globals::visArcs += toString(target);          
			globals::visArcs += " ";          
		    } 
		    if (globals::ASTEmap[source]->structured())
		    {
			globals::visArcs += "ltail=";
			globals::visArcs += "cluster";          
			globals::visArcs += toString(source);          
		    }
		    globals::visArcs += "];\n";
		}
		(*output) << globals::visArcs;
		(*output) << "}" << endl;

#line  271 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 59 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 59 "ast-postprocess.k"
		const tPartner_list b = this->tPartner_list_1;
#line 59 "ast-postprocess.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 59 "ast-postprocess.k"
		const tVariable_list c = this->tVariable_list_1;
#line 59 "ast-postprocess.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 59 "ast-postprocess.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 59 "ast-postprocess.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 59 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 59 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 61 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = myid;
		myself->parentActivityId = myid;
		globals::PPcurrentScope = myid;


		myself->checkAttributes();
		myself->hasEH = (string(g->op_name()) == "EventHandlers");


		assert(globals::ASTEmap[e->id] != NULL);
		assert(globals::ASTEmap[g->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[g->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = e->id;

#line  323 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(messageExchange, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 90 "ast-postprocess.k"


		bool callableFH = false;
		for ( set< string >::iterator fault = globals::ASTEmap[ e->id ]->catches.begin(); fault != globals::ASTEmap[ e->id ]->catches.end(); fault++)
		{
		    string faultName = fault->substr( fault->find_first_of( "|" ) + 1 );
		    faultName = faultName.substr( 0, faultName.find_first_of( "|" ) );
		    if (faultName.find_first_of(":") < faultName.npos)
		    {
			faultName = faultName.substr( faultName.find_first_of(":") + 1 );
		    }
		    if ( myself->possiblyTriggeredFaults.find( faultName ) != myself->possiblyTriggeredFaults.end() )
		    {

			callableFH = true;
		    }
		}
		if ( globals::ASTEmap[ e->id ]->hasCatchAll && ! myself->possiblyTriggeredFaults.empty() )
		{
		    callableFH = true;
		}

		globals::ASTEmap[ e->id ]->callable = callableFH;


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = globals::ASTEmap[i->id]->enclosedSourceLinks;
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks );
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[g->id]->enclosedSourceLinks );

		myself->enclosedTargetLinks = globals::ASTEmap[i->id]->enclosedTargetLinks;
		myself->enclosedTargetLinks = setUnion( myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks );
		myself->enclosedTargetLinks = setUnion( myself->enclosedTargetLinks, globals::ASTEmap[g->id]->enclosedTargetLinks );

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ e->id ]->enclosedActivities;
		faultIds.insert( e->id );

		enterConflictingActivities( innerIds, faultIds );




		if (globals::ASTE_startActivities.empty())
		{
		    SAerror(15, "", myself->attributes["referenceLine"]);
		}
		else
		{
		    for ( set< unsigned int >::iterator it = globals::ASTE_startActivities.begin(); it != globals::ASTE_startActivities.end(); it++ )
		    {

			for ( set< unsigned int >::iterator it2 = globals::ASTEmap[ i->id ]->enclosedActivities.begin(); it2 != globals::ASTEmap[ i->id ]->enclosedActivities.end(); it2++)
			{
			    int j = *it2;
			    if (globals::ASTEmap[j] != NULL)
			    {
				activityRelationType type = activityRelation( j, *it );
				if ( (type == AR_BEFORE || type == AR_CONCURRENT) &&
				    (
					globals::ASTEmap[j]->activityTypeName() == "pick" ||
					globals::ASTEmap[j]->activityTypeName() == "reply" ||
					globals::ASTEmap[j]->activityTypeName() == "invoke" ||      
					globals::ASTEmap[j]->activityTypeName() == "empty" ||     
					globals::ASTEmap[j]->activityTypeName() == "receive" ||      
					globals::ASTEmap[j]->activityTypeName() == "wait" ||      
					globals::ASTEmap[j]->activityTypeName() == "assign" ||      
					globals::ASTEmap[j]->activityTypeName() == "throw" ||      
					globals::ASTEmap[j]->activityTypeName() == "exit" ||      
					globals::ASTEmap[j]->activityTypeName() == "rethrow" ||      
					globals::ASTEmap[j]->activityTypeName() == "if" ||      
					globals::ASTEmap[j]->activityTypeName() == "while" ||      
					globals::ASTEmap[j]->activityTypeName() == "foreach" ||      
					globals::ASTEmap[j]->activityTypeName() == "repeatUntil"
				    ) &&      
				    globals::ASTEmap[j]->isStartActivity == false )
				{
				    SAerror( 56, globals::ASTEmap[j]->activityTypeName(), globals::ASTEmap[j]->attributes["referenceLine"] );
				}
			    }
			}
		    }
		}




		bool linksOK = true;
		for(map<string, unsigned int>::iterator it = globals::ASTE_linkIdMap.begin(); it != globals::ASTE_linkIdMap.end(); it++)
		{
		    if ( it-> first != "" )
		    {
			assert(globals::ASTEmap[it->second] != NULL);

			if ((globals::ASTEmap[it->second]->targetActivity == 0) || (globals::ASTEmap[it->second]->sourceActivity == 0))
			{
			    SAerror(66, it->first, globals::ASTEmap[it->second]->attributes["referenceLine"]);
			    linksOK = false;
			}


			if (linksOK)
			{
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity] != NULL);
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity] != NULL);
			    set<unsigned int> otherSources = globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity]->sourceLinks;
			    set<unsigned int> otherTargets = globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity]->targetLinks;
			    set<unsigned int> jointLinks = setIntersection(otherSources, otherTargets);
			    jointLinks.erase(it->second);

			    if (jointLinks.size() > 0)
			    SAerror(67, "`" + it->first + "' and <link> `" + globals::ASTEmap[*(jointLinks.begin())]->attributes["name"] + "'", globals::ASTEmap[it->second]->attributes["referenceLine"]);
			}
		    }
		}



		set<string> reallySharedCorrelationSets;
		if (globals::ASTE_startActivities.size() > 1)
		{
		    for (set<unsigned int>::iterator it = globals::ASTE_startActivities.begin(); it != globals::ASTE_startActivities.end(); it++)
		    {
			if (it == globals::ASTE_startActivities.begin())
			reallySharedCorrelationSets = globals::ASTEmap[*it]->sharedCorrelationSets;
			else
			reallySharedCorrelationSets = setIntersection(reallySharedCorrelationSets, globals::ASTEmap[*it]->sharedCorrelationSets);

			if (reallySharedCorrelationSets.empty())
			{
			    SAerror(57, "", globals::ASTEmap[*it]->attributes["referenceLine"]);
			    break;
			}
		    }
		}




		if (linksOK)
		{
		    assert(myself->enclosedSourceLinks.size() == globals::ASTE_linkNames.size());
		    assert(myself->enclosedTargetLinks.size() == globals::ASTE_linkNames.size());
		}



		globals::ASTE_correlationSetNames.clear(); 
		globals::ASTE_partnerLinkNames.clear();    
		globals::ASTE_startActivities.clear();	

#line  485 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 62 "ast-to-cfg.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 62 "ast-to-cfg.k"
		const tPartner_list b = this->tPartner_list_1;
#line 62 "ast-to-cfg.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 62 "ast-to-cfg.k"
		const tVariable_list c = this->tVariable_list_1;
#line 62 "ast-to-cfg.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 62 "ast-to-cfg.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 62 "ast-to-cfg.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 62 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 62 "ast-to-cfg.k"
		const integer j = this->integer_1;
#line 63 "ast-to-cfg.k"


		globals::cfgMap = map<std::string, CFGBlock *>();
		sources = map<std::string, CFGBlock *>();
		targets = map<std::string, CFGBlock *>();


		trace(TRACE_DEBUG, "[CFG] Process\n");
		CFGBlock* firstBlock = new CFGBlock(CFGProcess, this->id, "Process_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGProcess, this->id, "Process_end");


		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		CFG = firstBlock;
		globals::cfgMap[toString(this->id)] = CFG; 

#line  529 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 82 "ast-to-cfg.k"


		CFGBlock *fhFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock *fhLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;


		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);

#line  541 "ast-system-unpk.cc"
		kc::unparse(g, kc_printer, kc_current_view);
#line 102 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(g->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(g->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  552 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 111 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  562 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 62 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 62 "ast-to-xml.k"
		const tPartner_list b = this->tPartner_list_1;
#line 62 "ast-to-xml.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 62 "ast-to-xml.k"
		const tVariable_list c = this->tVariable_list_1;
#line 62 "ast-to-xml.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 62 "ast-to-xml.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 62 "ast-to-xml.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 62 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 62 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 63 "ast-to-xml.k"
		inup(); 
#line  589 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<process id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 63 "ast-to-xml.k"
		listAttributes( _id ); 
#line  595 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 65 "ast-to-xml.k"
		if (a->length() == 0) 
#line  599 "ast-system-unpk.cc"
		{
		}
#line 67 "ast-to-xml.k"
		else 
#line  604 "ast-system-unpk.cc"
		{
#line 68 "ast-to-xml.k"
		    inup(); 
#line  608 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partnerLinks>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 68 "ast-to-xml.k"
		    indown(); 
#line  613 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partnerLinks>\n"), kc_current_view); }
		}
#line 70 "ast-to-xml.k"
		if (b->length() == 0) 
#line  618 "ast-system-unpk.cc"
		{
		}
#line 72 "ast-to-xml.k"
		else 
#line  623 "ast-system-unpk.cc"
		{
#line 73 "ast-to-xml.k"
		    inup(); 
#line  627 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partners>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 73 "ast-to-xml.k"
		    indown(); 
#line  632 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partners>\n"), kc_current_view); }
		}
#line 75 "ast-to-xml.k"
		if (c->length() == 0) 
#line  637 "ast-system-unpk.cc"
		{
		}
#line 77 "ast-to-xml.k"
		else 
#line  642 "ast-system-unpk.cc"
		{
#line 78 "ast-to-xml.k"
		    inup(); 
#line  646 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables>\n"), kc_current_view); }
		    kc::unparse(c, kc_printer, kc_current_view);
#line 78 "ast-to-xml.k"
		    indown(); 
#line  651 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
#line 80 "ast-to-xml.k"
		if (d->length() == 0) 
#line  656 "ast-system-unpk.cc"
		{
		}
#line 82 "ast-to-xml.k"
		else 
#line  661 "ast-system-unpk.cc"
		{
#line 83 "ast-to-xml.k"
		    inup(); 
#line  665 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlationSets>\n"), kc_current_view); }
		    kc::unparse(d, kc_printer, kc_current_view);
#line 83 "ast-to-xml.k"
		    indown(); 
#line  670 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlationSets>\n"), kc_current_view); }
		}
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 85 "ast-to-xml.k"
		indown(); 
#line  678 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</process>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 169 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  691 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 169 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  703 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  708 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  721 "ast-system-unpk.cc"
void
impl_activity_activityScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  727 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  740 "ast-system-unpk.cc"
void
impl_activity_activityFlow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  746 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  759 "ast-system-unpk.cc"
void
impl_activity_activityPick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  765 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  778 "ast-system-unpk.cc"
void
impl_activity_activityForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  784 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  797 "ast-system-unpk.cc"
void
impl_activity_activityRepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  803 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  816 "ast-system-unpk.cc"
void
impl_activity_activityWhile::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  822 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  835 "ast-system-unpk.cc"
void
impl_activity_activityIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  841 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  854 "ast-system-unpk.cc"
void
impl_activity_activitySequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  860 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  873 "ast-system-unpk.cc"
void
impl_activity_activityCompensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  879 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  892 "ast-system-unpk.cc"
void
impl_activity_activityRethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  898 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  911 "ast-system-unpk.cc"
void
impl_activity_activityThrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  917 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  930 "ast-system-unpk.cc"
void
impl_activity_activityExit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  936 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  949 "ast-system-unpk.cc"
void
impl_activity_activityWait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  955 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  968 "ast-system-unpk.cc"
void
impl_activity_activityOpaqueActivity::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  974 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  987 "ast-system-unpk.cc"
void
impl_activity_activityEmpty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  993 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1006 "ast-system-unpk.cc"
void
impl_activity_activityValidate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1012 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1025 "ast-system-unpk.cc"
void
impl_activity_activityAssign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1031 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1044 "ast-system-unpk.cc"
void
impl_activity_activityInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1050 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1063 "ast-system-unpk.cc"
void
impl_activity_activityReply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1069 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1082 "ast-system-unpk.cc"
void
impl_activity_activityReceive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1088 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_activity_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1108 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (activity_list iterator_ = this; iterator_->activity_list_1 != 0; iterator_ = iterator_->activity_list_1)
		    iterator_->activity_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_activity_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1126 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1145 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartnerLink_list iterator_ = this; iterator_->tPartnerLink_list_1 != 0; iterator_ = iterator_->tPartnerLink_list_1)
		    iterator_->tPartnerLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1163 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1175 "ast-system-unpk.cc"
void
impl_tPartnerLink_PartnerLink::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 117 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 250 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 252 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();


		if(globals::WSDLInfo.partnerLinkTypes[myself->attributes["partnerLinkType"]] != NULL)
		globals::WSDLInfo.partnerLinkTypes[myself->attributes["partnerLinkType"]]->correctOrder(myself);

		myself->definePartnerLink();



#line  1211 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 93 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 94 "ast-to-xml.k"
		in(); 
#line  1222 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partnerLink id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 94 "ast-to-xml.k"
		listAttributes( _id ); 
#line  1228 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  1234 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1254 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartner_list iterator_ = this; iterator_->tPartner_list_1 != 0; iterator_ = iterator_->tPartner_list_1)
		    iterator_->tPartner_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1272 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1284 "ast-system-unpk.cc"
void
impl_tPartner_Partner::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 126 "ast-to-visualization.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 126 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 277 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 277 "ast-postprocess.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 102 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 102 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 103 "ast-to-xml.k"
		inup(); 
#line  1319 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partner id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 103 "ast-to-xml.k"
		indown(); 
#line  1326 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</partner>\n"), kc_current_view); }
	    }
	    break;
	}

#line  1332 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1345 "ast-system-unpk.cc"
void
impl_tFaultHandlers_FaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 135 "ast-to-visualization.k"
		const tCatch_list a = this->tCatch_list_1;
#line 135 "ast-to-visualization.k"
		const tCatchAll b = this->tCatchAll_1;
#line 135 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 137 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  1361 "ast-system-unpk.cc"
		{
		}
#line 139 "ast-to-visualization.k"
		else 
#line  1366 "ast-system-unpk.cc"
		{
#line 141 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"FaultHandlers\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  1378 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
		    kc::unparse(b, kc_printer, kc_current_view);
#line 151 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  1385 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 286 "ast-postprocess.k"
		const tCatch_list a = this->tCatch_list_1;
#line 286 "ast-postprocess.k"
		const tCatchAll b = this->tCatchAll_1;
#line 286 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 288 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		myself->hasCatchAll = (string(b->op_name()) == "CatchAll");





		{
#line 303 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1419 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 303 "ast-postprocess.k"
			    {
#line 304 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 304 "ast-postprocess.k"
#line 303 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 303 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 304 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid; 
				    globals::ASTEmap[branch->id]->parentActivityId = myid;
				    globals::ASTEmap[branch->id]->parentScopeId = myself->parentScopeId;
				    globals::ASTEmap[innerActivity->id]->controlFlow = FHCF;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  1443 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1448 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 303 "ast-postprocess.k"

#line  1453 "ast-system-unpk.cc"
		    }
		}
#line 312 "ast-postprocess.k"



		{
#line 315 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 318 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 318 "ast-postprocess.k"
#line 317 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 317 "ast-postprocess.k"
			const integer _id = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 318 "ast-postprocess.k"

			assert(globals::ASTEmap[c->id] != NULL);

			globals::ASTEmap[b->id]->parentActivityId = myid;
			globals::ASTEmap[c->id]->controlFlow = FHCF;
			globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;

#line  1478 "ast-system-unpk.cc"
		    } else
		    {
#line 326 "ast-postprocess.k"
#line 326 "ast-postprocess.k"


			if (a->length() == 0)
			SAerror(80, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));

#line  1488 "ast-system-unpk.cc"
		    }
		}
#line 332 "ast-postprocess.k"

#line  1493 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 334 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		{
#line 339 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1506 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 339 "ast-postprocess.k"
			    {
#line 340 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 340 "ast-postprocess.k"
#line 339 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 339 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 339 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->integer_1;
#line 340 "ast-postprocess.k"

				    {
#line 341 "ast-postprocess.k"
					tCatch_list kc_fe_selvar_1 =  a;

#line  1529 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
					    ) {
					    tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
					    {
#line 341 "ast-postprocess.k"
						{
#line 342 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 342 "ast-postprocess.k"
#line 341 "ast-postprocess.k"
							const tCatch otherbranch = kc_selvar_1_1;
#line 341 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 341 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 342 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if ( _id2->value < _id3->value )
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  1555 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1560 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 341 "ast-postprocess.k"

#line  1565 "ast-system-unpk.cc"
					}
				    }
#line 350 "ast-postprocess.k"

#line  1570 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1575 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 339 "ast-postprocess.k"

#line  1580 "ast-system-unpk.cc"
		    }
		}
#line 351 "ast-postprocess.k"

		{
#line 352 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 355 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 355 "ast-postprocess.k"
#line 354 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 354 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 355 "ast-postprocess.k"

			{
#line 356 "ast-postprocess.k"
			    tCatch_list kc_fe_selvar_1 =  a;

#line  1601 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
				) {
				tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
				{
#line 356 "ast-postprocess.k"
				    {
#line 357 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 357 "ast-postprocess.k"
#line 356 "ast-postprocess.k"
					    const tCatch otherbranch = kc_selvar_1_1;
#line 356 "ast-postprocess.k"
					    const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 356 "ast-postprocess.k"
					    const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 357 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(_id3 != NULL);
					    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );

#line  1624 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1629 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 356 "ast-postprocess.k"

#line  1634 "ast-system-unpk.cc"
			    }
			}
#line 362 "ast-postprocess.k"

#line  1639 "ast-system-unpk.cc"
		    } else
		    {
#line 364 "ast-postprocess.k"
#line 364 "ast-postprocess.k"


#line  1646 "ast-system-unpk.cc"
		    }
		}
#line 367 "ast-postprocess.k"


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  1655 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tCatchAll_1->prod_sel() == sel_CatchAll)) {
#line 135 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 135 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 135 "ast-to-cfg.k"
		const tCatchAll catchAll = this->tCatchAll_1;
#line 135 "ast-to-cfg.k"
		const activity b = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->activity_1;
#line 135 "ast-to-cfg.k"
		const integer c = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->integer_1;
#line 135 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 136 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined)\n");
		CFGBlock* firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1684 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 146 "ast-to-cfg.k"

		{
#line 147 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1692 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 147 "ast-to-cfg.k"
			    {
#line 148 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 148 "ast-to-cfg.k"
#line 147 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 148 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1715 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1720 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 147 "ast-to-cfg.k"

#line  1725 "ast-system-unpk.cc"
		    }
		}
#line 157 "ast-to-cfg.k"

#line  1730 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 159 "ast-to-cfg.k"

		CFGBlock * catchAllBlock = new CFGBlock(CFGCatchAll, catchAll->id, "CatchAll");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(firstBlock, catchAllBlock);
		connectBlocks(catchAllBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  1742 "ast-system-unpk.cc"
	    } else
		if ((this->tCatchAll_1->prod_sel() == sel_NoCatchAll)) {
#line 170 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 170 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 170 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 171 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined, no catchAll)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1761 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 181 "ast-to-cfg.k"

		{
#line 182 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1769 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 182 "ast-to-cfg.k"
			    {
#line 183 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 183 "ast-to-cfg.k"
#line 182 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 183 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1792 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1797 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 182 "ast-to-cfg.k"

#line  1802 "ast-system-unpk.cc"
		    }
		}
#line 192 "ast-to-cfg.k"

#line  1807 "ast-system-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 111 "ast-to-xml.k"
		const tCatch_list a = this->tCatch_list_1;
#line 111 "ast-to-xml.k"
		const tCatchAll b = this->tCatchAll_1;
#line 111 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 112 "ast-to-xml.k"
		inup(); 
#line  1823 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<faultHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" callable=\""), kc_current_view); }
#line 112 "ast-to-xml.k"
		*output << globals::ASTEmap[ _id->value ]->callable; 
#line  1829 "ast-system-unpk.cc"
			{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 112 "ast-to-xml.k"
		indown(); 
#line  1835 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</faultHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 190 "ast-to-petrinet.k"
		PFaultHandlers(this, kc_current_view_base); 
#line  1845 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  1850 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1864 "ast-system-unpk.cc"
void
impl_tFaultHandlers_volatile_standardFaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1870 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1890 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCatch_list iterator_ = this; iterator_->tCatch_list_1 != 0; iterator_ = iterator_->tCatch_list_1)
		    iterator_->tCatch_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1908 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1920 "ast-system-unpk.cc"
void
impl_tCatch_Catch::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 158 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 158 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 160 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Catch\";" << endl;  

#line  1936 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 164 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  1942 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 375 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 375 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 377 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();


		if (globals::ASTEmap[globals::PPcurrentScope]->attributes["exitOnStandardFault"] == "yes")
		{
		    if ( myself->attributes["faultName"] == "ambiguousReceive" ||
			myself->attributes["faultName"] == "completionConditionFailure" ||
			myself->attributes["faultName"] == "conflictingReceive" ||
			myself->attributes["faultName"] == "conflictingRequest" ||
			myself->attributes["faultName"] == "correlationViolation" ||
			myself->attributes["faultName"] == "invalidBranchCondition" ||
			myself->attributes["faultName"] == "invalidExpressionValue" ||
			myself->attributes["faultName"] == "invalidVariables" ||
			myself->attributes["faultName"] == "joinFailurea" ||
			myself->attributes["faultName"] == "mismatchedAssignmentFailurei" ||
			myself->attributes["faultName"] == "missingReply" ||
			myself->attributes["faultName"] == "missingRequest" ||
			myself->attributes["faultName"] == "scopeInitializationFailure" ||
			myself->attributes["faultName"] == "selectionFailure" ||
			myself->attributes["faultName"] == "subLanguageExecutionFaultx" ||
			myself->attributes["faultName"] == "uninitializedPartnerRole" ||
			myself->attributes["faultName"] == "uninitializedVariablez" ||
			myself->attributes["faultName"] == "unsupportedReference" ||
			myself->attributes["faultName"] == "xsltInvalidSourcel" ||
			myself->attributes["faultName"] == "xsltStylesheetNotFound" )

		    SAerror( 3, myself->attributes["faultName"], myself->attributes["referenceLine"]);
		}


		if (myself->attributes["faultVariable"] != "")
		{
		    globals::ASTE_variableNames.insert(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"]);
		    if (myself->attributes["faultMessageType"] != "")
		    globals::ASTE_variableMap[(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"])] = myself->attributes["faultMessageType"];
		}

#line  1997 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 421 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );

#line  2017 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 115 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 115 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 116 "ast-to-xml.k"
		inup(); 
#line  2030 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catch id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 116 "ast-to-xml.k"
		listAttributes( _id ); 
#line  2036 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 116 "ast-to-xml.k"
		indown(); 
#line  2041 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catch>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2047 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2060 "ast-system-unpk.cc"
void
impl_tCatchAll_NoCatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2066 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2078 "ast-system-unpk.cc"
void
impl_tCatchAll_CatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 170 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 170 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 172 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"CatchAll\";" << endl;  

#line  2094 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 176 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  2100 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 441 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 441 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 443 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  2119 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 451 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );

#line  2139 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 119 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 119 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 120 "ast-to-xml.k"
		inup(); 
#line  2152 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catchAll id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 120 "ast-to-xml.k"
		listAttributes( _id ); 
#line  2158 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 120 "ast-to-xml.k"
		indown(); 
#line  2163 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catchAll>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2169 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2182 "ast-system-unpk.cc"
void
impl_tTerminationHandler_TerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 260 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 260 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 262 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  2196 "ast-system-unpk.cc"
		{
		}
#line 264 "ast-to-visualization.k"
		else 
#line  2201 "ast-system-unpk.cc"
		{
#line 266 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"TerminationHandler\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  2213 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
#line 276 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  2219 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 759 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 759 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 761 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = THCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  2249 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 779 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00071( myid );


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  2268 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 290 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 290 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 291 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] TerminationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  2289 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 301 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  2299 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 170 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 170 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 171 "ast-to-xml.k"
		inup(); 
#line  2312 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<terminationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 171 "ast-to-xml.k"
		indown(); 
#line  2319 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</terminationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 194 "ast-to-petrinet.k"
		PTerminationHandler(this, kc_current_view_base); 
#line  2329 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2334 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2347 "ast-system-unpk.cc"
void
impl_tTerminationHandler_volatile_standardTerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2353 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2366 "ast-system-unpk.cc"
void
impl_tCompensationHandler_CompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 232 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 232 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 234 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  2380 "ast-system-unpk.cc"
		{
		}
#line 236 "ast-to-visualization.k"
		else 
#line  2385 "ast-system-unpk.cc"
		{
#line 238 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"CompensationHandler\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  2397 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
#line 248 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  2403 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 684 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 684 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 686 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = CHCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  2433 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 704 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00070( myid );










		vector<unsigned int> ancestors = myself->ancestorActivities();
		if (myself->isUserDefined && ancestors.size() > 1)
		{
		    unsigned int i = 1;
		    while(i < ancestors.size())
		    {
			string ancestor = globals::ASTEmap[ancestors[i]]->activityTypeName();
			if (ancestor == "catch" ||
			    ancestor == "catchAll" ||
			    ancestor == "terminationHandler" ||
			    ancestor == "compensationHandler")
			{
			    SAerror(79, ancestor);
			    break;
			}
			i++;
		    }
		}


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  2483 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 263 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 263 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 264 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  2504 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 274 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  2514 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 161 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 161 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 162 "ast-to-xml.k"
		inup(); 
#line  2527 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" callable=\""), kc_current_view); }
#line 162 "ast-to-xml.k"
		*output << globals::ASTEmap[ _id->value ]->callable; 
#line  2533 "ast-system-unpk.cc"
			{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 162 "ast-to-xml.k"
		indown(); 
#line  2538 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 198 "ast-to-petrinet.k"
		PCompensationHandler(this, kc_current_view_base); 
#line  2548 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2553 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2566 "ast-system-unpk.cc"
void
impl_tCompensationHandler_volatile_standardCompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2572 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2585 "ast-system-unpk.cc"
void
impl_tEventHandlers_EventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 191 "ast-to-visualization.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 191 "ast-to-visualization.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 191 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 193 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"EventHandlers\";" << endl;  

#line  2603 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 197 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  2610 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 493 "ast-postprocess.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 493 "ast-postprocess.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 493 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 495 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		if (a->length() == 0 && b->length() == 0)
		SAerror(83, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));


		{
#line 511 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2644 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 511 "ast-postprocess.k"
			    {
#line 512 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 512 "ast-postprocess.k"
#line 511 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 511 "ast-postprocess.k"
				    const tCorrelation_list _cor = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 511 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 511 "ast-postprocess.k"
				    const activity _act = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 511 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 512 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;


#line  2674 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2679 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 511 "ast-postprocess.k"

#line  2684 "ast-system-unpk.cc"
		    }
		}
#line 520 "ast-postprocess.k"
		{
#line 520 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2692 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 520 "ast-postprocess.k"
			    {
#line 521 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 521 "ast-postprocess.k"
#line 520 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 520 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 520 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 521 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  2717 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2722 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 520 "ast-postprocess.k"

#line  2727 "ast-system-unpk.cc"
		    }
		}
#line 528 "ast-postprocess.k"

#line  2732 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 530 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  2743 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 200 "ast-to-cfg.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 200 "ast-to-cfg.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 200 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 201 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "EventHandler_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "EventHandler_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;









		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  2775 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 221 "ast-to-cfg.k"

		int i = 1;
		{
#line 223 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2785 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 223 "ast-to-cfg.k"
			    {
#line 224 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 224 "ast-to-cfg.k"
#line 223 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 223 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 224 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2811 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2816 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 223 "ast-to-cfg.k"

#line  2821 "ast-system-unpk.cc"
		    }
		}
#line 234 "ast-to-cfg.k"
		i = 1; 
		{
#line 235 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2830 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 235 "ast-to-cfg.k"
			    {
#line 236 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 236 "ast-to-cfg.k"
#line 235 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 235 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 236 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2855 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2860 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 235 "ast-to-cfg.k"

#line  2865 "ast-system-unpk.cc"
		    }
		}
#line 244 "ast-to-cfg.k"


#line  2871 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 132 "ast-to-xml.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 132 "ast-to-xml.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 132 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 133 "ast-to-xml.k"
		inup(); 
#line  2886 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<eventHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 133 "ast-to-xml.k"
		indown(); 
#line  2894 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</eventHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 202 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2904 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 202 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2913 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2918 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2931 "ast-system-unpk.cc"
void
impl_tEventHandlers_emptyEventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 187 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 476 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 478 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  2962 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 249 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 250 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (implicit)\n");
		CFGBlock * block = new CFGBlock(CFGEventHandler, this->id, "implicitEventHandler"); 
		globals::cfgMap[toString(this->id)] = block;
		trace(TRACE_DEBUG, "[CFG] ~EventHandler (implicit)\n");

#line  2978 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 128 "ast-to-xml.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  2991 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3011 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnMessage_list iterator_ = this; iterator_->tOnMessage_list_1 != 0; iterator_ = iterator_->tOnMessage_list_1)
		    iterator_->tOnMessage_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3029 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3041 "ast-system-unpk.cc"
void
impl_tOnMessage_OnMessage::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 203 "ast-to-visualization.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 203 "ast-to-visualization.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 203 "ast-to-visualization.k"
		const activity c = this->activity_1;
#line 203 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 205 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"OnMessage\";" << endl;  

#line  3061 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 209 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  3069 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 540 "ast-postprocess.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 540 "ast-postprocess.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 540 "ast-postprocess.k"
		const activity c = this->activity_1;
#line 540 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 542 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		myself->checkAttributes();

		myself->checkPartnerLink();

		myself->checkMessageExchange();

		globals::ASTE_IMAs.insert(myid);

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}


		if (b->length() != 0 && myself->attributes["variable"] != "")
		SAerror(63, "", myself->attributes["referenceLine"]);


		if (globals::wsdl_filename != "")
		{
		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <onMessage>"),myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->channelName = myself->createChannel();



		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if(globals::ASTEmap[myself->parentActivityId]->activityTypeName() == "eventHandlers")
		{
		    if(max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    {
			myself->max_occurrences = max_loops * myself-> max_occurrences;
		    } 
		    else
		    {
			myself->max_occurrences = UINT_MAX;
		    }
		}

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;





		{
#line 612 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  a;

#line  3159 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 612 "ast-postprocess.k"
			    {
#line 613 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 613 "ast-postprocess.k"
#line 612 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 612 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 613 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  3180 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  3185 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 612 "ast-postprocess.k"

#line  3190 "ast-system-unpk.cc"
		    }
		}
#line 618 "ast-postprocess.k"

#line  3195 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 620 "ast-postprocess.k"


		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[c->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  3210 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 136 "ast-to-xml.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 136 "ast-to-xml.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 136 "ast-to-xml.k"
		const activity c = this->activity_1;
#line 136 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 137 "ast-to-xml.k"
		inup(); 
#line  3227 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onMessage id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 137 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3233 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 139 "ast-to-xml.k"
		if (a->length() == 0) 
#line  3237 "ast-system-unpk.cc"
		{
		}
#line 141 "ast-to-xml.k"
		else 
#line  3242 "ast-system-unpk.cc"
		{
#line 142 "ast-to-xml.k"
		    inup(); 
#line  3246 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlations>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 142 "ast-to-xml.k"
		    indown(); 
#line  3251 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlations>\n"), kc_current_view); }
		}
#line 144 "ast-to-xml.k"
		if (b->length() == 0) 
#line  3256 "ast-system-unpk.cc"
		{
		}
#line 146 "ast-to-xml.k"
		else 
#line  3261 "ast-system-unpk.cc"
		{
#line 147 "ast-to-xml.k"
		    inup(); 
#line  3265 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<fromParts>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 147 "ast-to-xml.k"
		    indown(); 
#line  3270 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</fromParts>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
#line 149 "ast-to-xml.k"
		indown(); 
#line  3276 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onMessage>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3282 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3302 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnAlarm_list iterator_ = this; iterator_->tOnAlarm_list_1 != 0; iterator_ = iterator_->tOnAlarm_list_1)
		    iterator_->tOnAlarm_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3320 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3332 "ast-system-unpk.cc"
void
impl_tOnAlarm_OnAlarm::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 215 "ast-to-visualization.k"
		const tRepeatEvery a = this->tRepeatEvery_1;
#line 215 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 215 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 217 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"OnAlarm\";" << endl;  

#line  3350 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 221 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  3356 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 633 "ast-postprocess.k"
		const tRepeatEvery b = this->tRepeatEvery_1;
#line 633 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 633 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 635 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);

		if(string(b->op_name())=="RepeatEvery")
		{
		    myself->cyclic=true;
		    globals::ASTEmap[a->id]->max_occurrences = UINT_MAX;
		} 
		else
		{

		    unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		    if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences * max_loops;
		    else
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;
		}


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  3400 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 666 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  3413 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 152 "ast-to-xml.k"
		const tRepeatEvery a = this->tRepeatEvery_1;
#line 152 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 152 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 153 "ast-to-xml.k"
		inup(); 
#line  3428 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onAlarm"), kc_current_view); }
#line 153 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3432 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 153 "ast-to-xml.k"
		indown(); 
#line  3437 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onAlarm>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3443 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3456 "ast-system-unpk.cc"
void
impl_tRepeatEvery_RepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3462 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3475 "ast-system-unpk.cc"
void
impl_tRepeatEvery_emptyRepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3481 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3501 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tVariable_list iterator_ = this; iterator_->tVariable_list_1 != 0; iterator_ = iterator_->tVariable_list_1)
		    iterator_->tVariable_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3519 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3531 "ast-system-unpk.cc"
void
impl_tVariable_Variable::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 288 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 806 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 808 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineVariable();

#line  3560 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 179 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 180 "ast-to-xml.k"
		in(); 
#line  3571 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<variable id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 180 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3577 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3583 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tMessageExchange_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3603 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tMessageExchange_list iterator_ = this; iterator_->tMessageExchange_list_1 != 0; iterator_ = iterator_->tMessageExchange_list_1)
		    iterator_->tMessageExchange_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tMessageExchange_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3621 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3633 "ast-system-unpk.cc"
void
impl_tMessageExchange_MessageExchange::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 826 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 828 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineMessageExchange();

#line  3654 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  3659 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3679 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelationSet_list iterator_ = this; iterator_->tCorrelationSet_list_1 != 0; iterator_ = iterator_->tCorrelationSet_list_1)
		    iterator_->tCorrelationSet_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3697 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3709 "ast-system-unpk.cc"
void
impl_tCorrelationSet_CorrelationSet::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 297 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 846 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 848 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineCorrelationSet();

#line  3738 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 188 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 189 "ast-to-xml.k"
		in(); 
#line  3749 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlationSet"), kc_current_view); }
#line 189 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3753 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3759 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3779 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelation_list iterator_ = this; iterator_->tCorrelation_list_1 != 0; iterator_ = iterator_->tCorrelation_list_1)
		    iterator_->tCorrelation_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3797 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3809 "ast-system-unpk.cc"
void
impl_tCorrelation_Correlation::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 306 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 866 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 868 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		string correlationSetName = myself->checkCorrelationSet();


		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		if (globals::ASTEmap[myself->parentActivityId]->isStartActivity &&
		    myself->attributes["initiate"] == "join")
		{
		    globals::ASTEmap[myself->parentActivityId]->sharedCorrelationSets.insert(correlationSetName);
		}

#line  3846 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 197 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 198 "ast-to-xml.k"
		in(); 
#line  3857 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlation"), kc_current_view); }
#line 198 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3861 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3867 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3887 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tToPart_list iterator_ = this; iterator_->tToPart_list_1 != 0; iterator_ = iterator_->tToPart_list_1)
		    iterator_->tToPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3905 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3917 "ast-system-unpk.cc"
void
impl_tToPart_ToPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 314 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 894 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 896 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  3944 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 205 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 206 "ast-to-xml.k"
		in(); 
#line  3955 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<toPart"), kc_current_view); }
#line 206 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3959 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3965 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3985 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tFromPart_list iterator_ = this; iterator_->tFromPart_list_1 != 0; iterator_ = iterator_->tFromPart_list_1)
		    iterator_->tFromPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4003 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  4015 "ast-system-unpk.cc"
void
impl_tFromPart_FromPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 318 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 907 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 909 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  4042 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 209 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 210 "ast-to-xml.k"
		in(); 
#line  4053 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<fromPart"), kc_current_view); }
#line 210 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4057 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4063 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4076 "ast-system-unpk.cc"
void
impl_tReceive_Receive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 344 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 344 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 344 "ast-to-visualization.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 344 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 346 "ast-to-visualization.k"

		(*output) << "receive" << toString(_id->value) << " [shape=rectangle style=filled label=\"receive\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "receive" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "receive" + toString(_id->value);

#line  4101 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1044 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1044 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 1044 "ast-postprocess.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 1044 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1046 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->checkMessageExchange();
		globals::ASTE_IMAs.insert(myid);




		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(55, "", myself->attributes["referenceLine"]);


		if (globals::wsdl_filename != "")
		{

		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <receive>"), myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 1092 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4167 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1092 "ast-postprocess.k"
			    {
#line 1093 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1093 "ast-postprocess.k"
#line 1092 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1092 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1093 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4188 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4193 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1092 "ast-postprocess.k"

#line  4198 "ast-system-unpk.cc"
		    }
		}
#line 1098 "ast-postprocess.k"

#line  4203 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1100 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);




		}

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4219 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 408 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 408 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 408 "ast-to-cfg.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 408 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 409 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Receive\n");
		CFGBlock * block = new CFGBlock(CFGReceive, this->id, "Receive"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4244 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 218 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 218 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 218 "ast-to-xml.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 218 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 219 "ast-to-xml.k"
		inup(); 
#line  4262 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<receive id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 219 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4268 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 219 "ast-to-xml.k"
		indown(); 
#line  4275 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</receive>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 81 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  4285 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 81 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  4294 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4299 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4312 "ast-system-unpk.cc"
void
impl_tReply_Reply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 362 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 362 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 362 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 362 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 364 "ast-to-visualization.k"

		(*output) << "reply" << toString(_id->value) << " [shape=rectangle style=filled label=\"reply\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "reply" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "reply" + toString(_id->value);

#line  4337 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1120 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1120 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 1120 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 1120 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1122 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->checkMessageExchange();




		if (globals::wsdl_filename != "")
		{
		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <reply>"), myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}


		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(59, "", myself->attributes["referenceLine"]);

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 1166 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4401 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1166 "ast-postprocess.k"
			    {
#line 1167 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1167 "ast-postprocess.k"
#line 1166 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1166 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1167 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4422 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4427 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1166 "ast-postprocess.k"

#line  4432 "ast-system-unpk.cc"
		    }
		}
#line 1172 "ast-postprocess.k"

#line  4437 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1174 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4444 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 427 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 427 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 427 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 427 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 428 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Reply\n");
		CFGBlock * block = new CFGBlock(CFGReply, this->id, "Reply"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4469 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 227 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 227 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 227 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 227 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 228 "ast-to-xml.k"
		inup(); 
#line  4487 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<reply id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 228 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4493 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 228 "ast-to-xml.k"
		indown(); 
#line  4500 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</reply>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 85 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  4510 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 85 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  4519 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4524 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4537 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_annotatedInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4543 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4556 "ast-system-unpk.cc"
void
impl_tInvoke_AsynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 393 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 393 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 393 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 393 "ast-to-visualization.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 393 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 395 "ast-to-visualization.k"

		(*output) << "invoke" << toString(_id->value) << " [shape=rectangle style=filled label=\"invoke\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "invoke" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "invoke" + toString(_id->value);

#line  4583 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 389 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 389 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 389 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 389 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 389 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 390 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4610 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 240 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 240 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 240 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 240 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 240 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 241 "ast-to-xml.k"
		inup(); 
#line  4630 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 241 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4636 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 241 "ast-to-xml.k"
		indown(); 
#line  4644 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 73 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  4654 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 73 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  4663 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4668 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4681 "ast-system-unpk.cc"
void
impl_tInvoke_SynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 380 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 380 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 380 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 380 "ast-to-visualization.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 380 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 382 "ast-to-visualization.k"

		(*output) << "invoke" << toString(_id->value) << " [shape=rectangle style=filled label=\"invoke\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "invoke" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "invoke" + toString(_id->value);

#line  4708 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 376 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 376 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 376 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 376 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 376 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 377 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4735 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 236 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 236 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 236 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 236 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 236 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 237 "ast-to-xml.k"
		inup(); 
#line  4755 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 237 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4761 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 237 "ast-to-xml.k"
		indown(); 
#line  4769 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 77 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  4779 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 77 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  4788 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4793 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4806 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_Invoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 975 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 975 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 975 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 975 "ast-postprocess.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 975 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 977 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		if (c->length() != 0 && myself->attributes["inputVariable"] != "")
		SAerror(51, "", myself->attributes["referenceLine"]);


		if (d->length() != 0 && myself->attributes["outputVariable"] != "")
		SAerror(52, "", myself->attributes["referenceLine"]);

		if (globals::wsdl_filename != "")
		{

		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["partnerRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <invoke>"),myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}

		myself->channelName = myself->createChannel((myself->attributes["outputVariable"] != ""));
		myself->inputVariableName = myself->checkVariable("inputVariable");
		myself->outputVariableName = myself->checkVariable("outputVariable");

		{
#line 1025 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4877 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1025 "ast-postprocess.k"
			    {
#line 1026 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1026 "ast-postprocess.k"
#line 1025 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1025 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1026 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4898 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4903 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1025 "ast-postprocess.k"

#line  4908 "ast-system-unpk.cc"
		    }
		}
#line 1031 "ast-postprocess.k"

#line  4913 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1033 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4920 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4925 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4938 "ast-system-unpk.cc"
void
impl_tAssign_Assign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 411 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 411 "ast-to-visualization.k"
		const tCopy_list b = this->tCopy_list_1;
#line 411 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 413 "ast-to-visualization.k"

		(*output) << "assign" << toString(_id->value) << " [shape=rectangle style=filled label=\"assign\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "assign" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "assign" + toString(_id->value);

#line  4961 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1185 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1185 "ast-postprocess.k"
		const tCopy_list b = this->tCopy_list_1;
#line 1185 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1187 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4986 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1199 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4993 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 446 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 446 "ast-to-cfg.k"
		const tCopy_list b = this->tCopy_list_1;
#line 446 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 447 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Assign\n");
		CFGBlock * firstBlock = new CFGBlock(CFGAssign, this->id, "Assign_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGAssign, this->id, "Assign_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 459 "ast-to-cfg.k"
		    tCopy_list kc_fe_selvar_1 =  b;

#line  5023 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCopy_list
			) {
			tCopy kc_selvar_0_1 = kc_fe_selvar_1->tCopy_1;
			{
#line 459 "ast-to-cfg.k"
			    {
#line 460 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Copy)) {
#line 460 "ast-to-cfg.k"
#line 459 "ast-to-cfg.k"
				    const tFrom from = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tFrom_1;
#line 459 "ast-to-cfg.k"
				    const tTo to = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tTo_1;
#line 460 "ast-to-cfg.k"




				    CFGBlock * fromBlock = new CFGBlock(CFGFrom, from->id, "From_" + toString(i));
				    CFGBlock * toBlock   = new CFGBlock(CFGTo,   to->id, "To_" + toString(i++));
				    connectBlocks(last,fromBlock);
				    connectBlocks(fromBlock, toBlock);
				    last = toBlock;

#line  5049 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  5054 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCopy_list_1;
#line 459 "ast-to-cfg.k"

#line  5059 "ast-system-unpk.cc"
		    }
		}
#line 469 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  5066 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 249 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 249 "ast-to-xml.k"
		const tCopy_list b = this->tCopy_list_1;
#line 249 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 250 "ast-to-xml.k"
		inup(); 
#line  5082 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<assign id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 250 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5088 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 250 "ast-to-xml.k"
		indown(); 
#line  5094 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</assign>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 89 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  5104 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 89 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  5113 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5118 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  5138 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCopy_list iterator_ = this; iterator_->tCopy_list_1 != 0; iterator_ = iterator_->tCopy_list_1)
		    iterator_->tCopy_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  5156 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  5168 "ast-system-unpk.cc"
void
impl_tCopy_Copy::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 424 "ast-to-visualization.k"
		const tFrom a = this->tFrom_1;
#line 424 "ast-to-visualization.k"
		const tTo b = this->tTo_1;
#line 424 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1205 "ast-postprocess.k"
		const tFrom a = this->tFrom_1;
#line 1205 "ast-postprocess.k"
		const tTo b = this->tTo_1;
#line 1205 "ast-postprocess.k"
		const integer c = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 253 "ast-to-xml.k"
		const tFrom a = this->tFrom_1;
#line 253 "ast-to-xml.k"
		const tTo b = this->tTo_1;
#line 253 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 254 "ast-to-xml.k"
		inup(); 
#line  5212 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<copy id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 254 "ast-to-xml.k"
		indown(); 
#line  5220 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</copy>\n"), kc_current_view); }
	    }
	    break;
	}

#line  5226 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5239 "ast-system-unpk.cc"
void
impl_tFrom_From::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 428 "ast-to-visualization.k"
		const integer a = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1209 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1211 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);


		if (myself->attributes["has_literal"] == "")
		{
		    if(myself->attributes["has_expression"] == "")
		    {
			if (myself->attributes["variable"] == "")
			{
			    if (myself->attributes["endpointReference"] == "")
			    {
				if (! (myself->attributes["property"] == "" && myself->attributes["partnerLink"] == ""
					&& myself->attributes["expressionLanguage"] == "" && myself->attributes["has_query"] == ""
					&& myself->attributes["part"] == ""))
				SAerror(32, "from", myself->attributes["referenceLine"]);
			    }
			    else
			    {
				if (! (myself->attributes["property"] == "" && myself->attributes["partnerLink"] != ""
					&& myself->attributes["expressionLanguage"] == "" && myself->attributes["has_query"] == ""
					&& myself->attributes["part"] == ""))
				SAerror(32, "from", myself->attributes["referenceLine"]);
			    }
			}
			else
			{
			    if (! (myself->attributes["endpointReference"] == "" && myself->attributes["property"] != "" 
				    && myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == ""
				    && myself->attributes["has_query"] == "" && myself->attributes["part"] == "")
				&&
				! (myself->attributes["endpointReference"] == "" && myself->attributes["property"] == "" 
				    && myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == "")
			    )
			    SAerror(32, "from", myself->attributes["referenceLine"]);           
			}
		    }
		    else
		    {
			if (! (myself->attributes["has_query"] == "" && myself->attributes["variable"] == "" 
				&& myself->attributes["endpointReference"] == "" && myself->attributes["property"] == "" 
				&& myself->attributes["partnerLink"] == ""&& myself->attributes["part"] == ""))
			SAerror(32, "from", myself->attributes["referenceLine"]);
		    }
		}
		else
		{
		    if (! (myself->attributes["has_query"] == "" && myself->attributes["has_expression"] == ""
			    && myself->attributes["variable"] == "" && myself->attributes["endpointReference"] == ""
			    && myself->attributes["property"] == "" && myself->attributes["partnerLink"] == ""
			    && myself->attributes["expressionLanguage"] == "" && myself->attributes["part"] == ""))
		    SAerror(32, "from", myself->attributes["referenceLine"]);
		}


		if (myself->attributes["endpointReference"] == "myRole")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["myRole"] == "")
		SAerror(35, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);


		if (myself->attributes["endpointReference"] == "partnerRole")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["partnerRole"] == "")
		SAerror(36, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  5332 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 257 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 258 "ast-to-xml.k"
		in(); 
#line  5343 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<from />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5349 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5362 "ast-system-unpk.cc"
void
impl_tTo_To::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 432 "ast-to-visualization.k"
		const integer b = this->integer_1;
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1287 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1289 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		if(myself->attributes["has_expression"] == "")
		{
		    if (myself->attributes["variable"] == "")
		    {
			if (! (myself->attributes["property"] == "" && myself->attributes["expressionLanguage"] == "" 
				&& myself->attributes["has_query"] == "" && myself->attributes["part"] == ""))
			SAerror(32, "to", myself->attributes["referenceLine"]);
		    }
		    else
		    {
			if (! (myself->attributes["property"] != "" && myself->attributes["part"] == ""
				&& myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == ""
				&& myself->attributes["has_query"] == "")
			    &&
			    ! (myself->attributes["expressionLanguage"] == "" && myself->attributes["property"] == "" 
				&& myself->attributes["partnerLink"] == "")
			)
			SAerror(32, "to", myself->attributes["referenceLine"]);           
		    }
		}
		else
		{
		    if (! (myself->attributes["has_query"] == "" && myself->attributes["variable"] == "" 
			    && myself->attributes["part"] == "" && myself->attributes["property"] == "" 
			    && myself->attributes["partnerLink"] == ""))
		    SAerror(32, "to", myself->attributes["referenceLine"]);
		}


		if (myself->attributes["partnerLink"] != "")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["partnerRole"] == "")
		SAerror(37, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  5427 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 261 "ast-to-xml.k"
		const integer b = this->integer_1;
#line 262 "ast-to-xml.k"
		in(); 
#line  5438 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<to />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5444 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5457 "ast-system-unpk.cc"
void
impl_tValidate_Validate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 441 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 441 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 443 "ast-to-visualization.k"

		(*output) << "validate" << toString(_id->value) << " [shape=rectangle style=filled label=\"validate\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "validate" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "validate" + toString(_id->value);

#line  5478 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1342 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1342 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1344 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5501 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1356 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5507 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 332 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 332 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 333 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Validate\n");
		CFGBlock * block = new CFGBlock(CFGValidate, this->id, "Validate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5525 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 270 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 270 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 271 "ast-to-xml.k"
		inup(); 
#line  5539 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<validate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 271 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5545 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 271 "ast-to-xml.k"
		indown(); 
#line  5550 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</validate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 93 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  5560 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 93 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  5569 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5574 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5587 "ast-system-unpk.cc"
void
impl_tEmpty_Empty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 458 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 458 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 460 "ast-to-visualization.k"

		(*output) << "empty" << toString(_id->value) << " [shape=rectangle style=filled label=\"empty\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "empty" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "empty" + toString(_id->value);

#line  5608 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 925 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 925 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 927 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5631 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 939 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5637 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 346 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 346 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 347 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Empty\n");
		CFGBlock * block = new CFGBlock(CFGEmpty, this->id, "Empty"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5655 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 278 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 278 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 279 "ast-to-xml.k"
		inup(); 
#line  5669 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<empty id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 279 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5675 "ast-system-unpk.cc"
#line 280 "ast-to-xml.k"

		{
#line 281 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 283 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 283 "ast-to-xml.k"
#line 283 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 283 "ast-to-xml.k"
			*output << " />";  indown(); *output << endl; 
#line  5688 "ast-system-unpk.cc"
				} else
		    {
#line 284 "ast-to-xml.k"
#line 284 "ast-to-xml.k"
			*output << ">\n"; 
#line  5694 "ast-system-unpk.cc"
		    }
		}
#line 286 "ast-to-xml.k"

#line  5699 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 288 "ast-to-xml.k"

		{
#line 289 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 291 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 291 "ast-to-xml.k"
#line 291 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 291 "ast-to-xml.k"

#line  5713 "ast-system-unpk.cc"
		    } else
		    {
#line 292 "ast-to-xml.k"
#line 292 "ast-to-xml.k"
			indown(); *output << "</empty>\n"; 
#line  5719 "ast-system-unpk.cc"
		    }
		}
#line 294 "ast-to-xml.k"

#line  5724 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 65 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  5733 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 65 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  5742 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5747 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5760 "ast-system-unpk.cc"
void
impl_tOpaqueActivity_OpaqueActivity::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 326 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 326 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 328 "ast-to-visualization.k"

		(*output) << "opaqueActivity" << toString(_id->value) << " [shape=rectangle style=filled label=\"opaqueActivity\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "opaqueActivity" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "opaqueActivity" + toString(_id->value);

#line  5781 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 950 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 950 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 952 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5804 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 964 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5810 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 361 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 361 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 362 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] OpaqueActivity\n");
		CFGBlock * block = new CFGBlock(CFGOpaqueActivity, this->id, "OpaqueActivity"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5828 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 303 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 303 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 304 "ast-to-xml.k"
		inup(); 
#line  5842 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<opaqueActivity id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 304 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5848 "ast-system-unpk.cc"
#line 305 "ast-to-xml.k"

		{
#line 306 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 308 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 308 "ast-to-xml.k"
#line 308 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 308 "ast-to-xml.k"
			*output << " />";  indown(); *output << endl; 
#line  5861 "ast-system-unpk.cc"
				} else
		    {
#line 309 "ast-to-xml.k"
#line 309 "ast-to-xml.k"
			*output << ">\n"; 
#line  5867 "ast-system-unpk.cc"
		    }
		}
#line 311 "ast-to-xml.k"

#line  5872 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 313 "ast-to-xml.k"

		{
#line 314 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 316 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 316 "ast-to-xml.k"
#line 316 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 316 "ast-to-xml.k"

#line  5886 "ast-system-unpk.cc"
		    } else
		    {
#line 317 "ast-to-xml.k"
#line 317 "ast-to-xml.k"
			indown(); *output << "</opaqueActivity>\n"; 
#line  5892 "ast-system-unpk.cc"
		    }
		}
#line 319 "ast-to-xml.k"

#line  5897 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 69 "ast-to-petrinet.k"
		POpaqueActivity(this, kc_current_view_base); 
#line  5906 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 69 "ast-to-petrinet.k"
		POpaqueActivity(this, kc_current_view_base); 
#line  5915 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5920 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5933 "ast-system-unpk.cc"
void
impl_tWait_Wait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 476 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 476 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 478 "ast-to-visualization.k"

		(*output) << "wait" << toString(_id->value) << " [shape=rectangle style=filled label=\"wait\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "wait" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "wait" + toString(_id->value);

#line  5954 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1367 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1367 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1369 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5977 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1381 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5983 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 482 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 482 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 483 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Wait\n");
		CFGBlock * block = new CFGBlock(CFGWait, this->id, "Wait"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6001 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 328 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 328 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 329 "ast-to-xml.k"
		inup(); 
#line  6015 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<wait id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 329 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6021 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 329 "ast-to-xml.k"
		indown(); 
#line  6026 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</wait>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 97 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  6036 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 97 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  6045 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6050 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6063 "ast-system-unpk.cc"
void
impl_tExit_Exit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 494 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 494 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 496 "ast-to-visualization.k"

		(*output) << "exit" << toString(_id->value) << " [shape=rectangle style=filled label=\"exit\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "exit" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "exit" + toString(_id->value);

#line  6084 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1590 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1590 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1592 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  6107 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1604 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6118 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 560 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 560 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 561 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Exit\n");
		CFGBlock * block = new CFGBlock(CFGExit, this->id, "Exit"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6136 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 337 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 337 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 338 "ast-to-xml.k"
		inup(); 
#line  6150 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<exit id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 338 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6156 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 338 "ast-to-xml.k"
		indown(); 
#line  6161 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</exit>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 109 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  6171 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 109 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  6180 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6185 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6198 "ast-system-unpk.cc"
void
impl_tThrow_Throw::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 512 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 512 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 514 "ast-to-visualization.k"

		(*output) << "throw" << toString(_id->value) << " [shape=rectangle style=filled label=\"throw\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "throw" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "throw" + toString(_id->value);

#line  6219 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1392 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1392 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1394 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		globals::ASTEmap[ myself->parentScopeId ]->enterFault( myself->attributes[ "faultName" ] );

#line  6243 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1407 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6254 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 498 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 498 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 499 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Throw\n");
		CFGBlock * block = new CFGBlock(CFGThrow, this->id, "Throw"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6272 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 346 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 346 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 347 "ast-to-xml.k"
		inup(); 
#line  6286 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<throw id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 347 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6292 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 347 "ast-to-xml.k"
		indown(); 
#line  6297 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</throw>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 101 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  6307 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 101 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  6316 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6321 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6334 "ast-system-unpk.cc"
void
impl_tRethrow_Rethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 530 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 530 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 532 "ast-to-visualization.k"

		(*output) << "rethrow" << toString(_id->value) << " [shape=rectangle style=filled label=\"rethrow\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "rethrow" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "rethrow" + toString(_id->value);

#line  6355 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1423 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1423 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1425 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    assert(globals::ASTEmap[*it] != NULL);
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(6, "", myself->attributes["referenceLine"]);

#line  6395 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1454 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  6401 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 513 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 513 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 514 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Rethrow\n");
		CFGBlock * block = new CFGBlock(CFGRethrow, this->id, "Rhrow"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6419 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 355 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 355 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 356 "ast-to-xml.k"
		inup(); 
#line  6433 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<rethrow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 356 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6439 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 356 "ast-to-xml.k"
		indown(); 
#line  6444 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</rethrow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 105 "ast-to-petrinet.k"
		PRethrow(this, kc_current_view_base); 
#line  6454 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6459 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6472 "ast-system-unpk.cc"
void
impl_tCompensate_CompensateScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 562 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 562 "ast-to-visualization.k"
		const casestring b = this->casestring_1;
#line 562 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 564 "ast-to-visualization.k"

		(*output) << "compensateScope" << toString(_id->value) << " [shape=rectangle style=filled label=\"compensateScope\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "compensateScope" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "compensateScope" + toString(_id->value);

#line  6495 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1523 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1523 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 1523 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1525 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;



		if (myself->attributes["target"] == "")
		myself->attributes["target"] = string(b->name);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(7, "", myself->attributes["referenceLine"]);



		if (globals::ASTE_scopeNames[myself->attributes["target"]] == 0)
		SAerror(78, myself->attributes["target"], myself->attributes["referenceLine"]);
		else if (globals::ASTEmap[myself->parentScopeId]->enclosedScopes.find(globals::ASTE_scopeNames[myself->attributes["target"]]) == globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end())
		SAerror(77, myself->attributes["target"], myself->attributes["referenceLine"]);

		globals::ASTEmap[ 
		globals::ASTEmap[ 
		*(globals::ASTEmap[myself->parentScopeId]->enclosedScopes.find(globals::ASTE_scopeNames[myself->attributes["target"]])) 
		]->enclosedCH 
		]->callable = true;

#line  6557 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1574 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6568 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 544 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 544 "ast-to-cfg.k"
		const casestring name = this->casestring_1;
#line 544 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 545 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensateScope\n");
		CFGBlock * block = new CFGBlock(CFGCompensateScope, this->id, "CompensateScope"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6588 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 368 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 368 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 368 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 369 "ast-to-xml.k"
		inup(); 
#line  6604 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensateScope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" target=\""), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 369 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6612 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 369 "ast-to-xml.k"
		indown(); 
#line  6617 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensateScope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 117 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  6627 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 117 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  6636 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6641 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6654 "ast-system-unpk.cc"
void
impl_tCompensate_Compensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 548 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 548 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 550 "ast-to-visualization.k"

		(*output) << "compensate" << toString(_id->value) << " [shape=rectangle style=filled label=\"compensate\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "compensate" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "compensate" + toString(_id->value);

#line  6675 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1465 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1465 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1467 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();

		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(8, "", myself->attributes["referenceLine"]);


		globals::ASTEmap[myself->parentActivityId]->hasCompensate = true;
		for (set< unsigned int >::iterator scope =  globals::ASTEmap[myself->parentActivityId]->enclosedScopes.begin();
		    scope != globals::ASTEmap[myself->parentActivityId]->enclosedScopes.begin(); 
		    scope++)
		{
		    globals::ASTEmap[ globals::ASTEmap[ *scope ]->enclosedCH ]->callable = true;
		}

#line  6726 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1507 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6737 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 529 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 529 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 530 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Compensate\n");
		CFGBlock * block = new CFGBlock(CFGCompensate, this->id, "Compensate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6755 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 364 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 364 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 365 "ast-to-xml.k"
		inup(); 
#line  6769 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 365 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6775 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 365 "ast-to-xml.k"
		indown(); 
#line  6780 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 113 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  6790 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 113 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  6799 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6804 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6817 "ast-system-unpk.cc"
void
impl_tSequence_Sequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 580 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 580 "ast-to-visualization.k"
		const activity_list b = this->activity_list_1;
#line 580 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 582 "ast-to-visualization.k"


		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Sequence\";" << endl;  

#line  6836 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 587 "ast-to-visualization.k"


		bool startlist=true;
		bool laststructured = false;
		int lastid = 0;   
		{
#line 592 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6849 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 592 "ast-to-visualization.k"
			    {
				{
#line 593 "ast-to-visualization.k"
#line 592 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 593 "ast-to-visualization.k"

				    if (startlist)
				    {
					startlist=false;
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    else
				    {

					globals::visArcs += globals::ASTEmap[_id->value]->visConnection + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
					if (globals::ASTEmap[innerActivity->id]->structured())
					{
					    globals::visArcs += "lhead=";
					    globals::visArcs += "cluster";          
					    globals::visArcs += toString(innerActivity->id);          
					    globals::visArcs += " ";          
					}
					if (laststructured)
					{
					    globals::visArcs += "ltail=";
					    globals::visArcs += "cluster";          
					    globals::visArcs += toString(lastid);          
					}
					globals::visArcs += "];\n";
				    }
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					lastid = innerActivity->id;
					laststructured = true;
				    }
				    else
				    laststructured = false;

				    globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;

#line  6897 "ast-system-unpk.cc"
				}
			    }

#line  6901 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 592 "ast-to-visualization.k"

#line  6906 "ast-system-unpk.cc"
		    }
		}
#line 628 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  6912 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1959 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1959 "ast-postprocess.k"
		const activity_list b = this->activity_list_1;
#line 1959 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1961 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 1977 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6946 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1977 "ast-postprocess.k"
			    {
				{
#line 1978 "ast-postprocess.k"
#line 1977 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1978 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  6965 "ast-system-unpk.cc"
				}
			    }

#line  6969 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1977 "ast-postprocess.k"

#line  6974 "ast-system-unpk.cc"
		    }
		}
#line 1984 "ast-postprocess.k"

#line  6979 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1986 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );



		int activityCount = 1;
		{
#line 1994 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6995 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1994 "ast-postprocess.k"
			    {
				{
#line 1995 "ast-postprocess.k"
#line 1994 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1995 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);

				    bool before = true;
				    {
#line 1999 "ast-postprocess.k"
					activity_list kc_fe_selvar_1 =  b;

#line  7016 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
					    ) {
					    activity kc_selvar_1_1 = kc_fe_selvar_1->activity_1;
					    {
#line 1999 "ast-postprocess.k"
						{
						    {
#line 2000 "ast-postprocess.k"
#line 1999 "ast-postprocess.k"
							const activity innerActivity2 = kc_selvar_1_1;
#line 2000 "ast-postprocess.k"

							if ( innerActivity2->id == innerActivity->id)
							{
							    before = false;
							}
							else if (before == true)
							{
							    enterConsecutiveActivities( innerActivity2->id, innerActivity->id );
							}

#line  7039 "ast-system-unpk.cc"
						    }
						}

#line  7043 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1999 "ast-postprocess.k"

#line  7048 "ast-system-unpk.cc"
					}
				    }
#line 2010 "ast-postprocess.k"


				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);





#line  7061 "ast-system-unpk.cc"
				}
			    }

#line  7065 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1994 "ast-postprocess.k"

#line  7070 "ast-system-unpk.cc"
		    }
		}
#line 2019 "ast-postprocess.k"


#line  7076 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 778 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 778 "ast-to-cfg.k"
		const activity_list b = this->activity_list_1;
#line 778 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 779 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Sequence\n");
		CFGBlock * firstBlock = new CFGBlock(CFGSequence, this->id, "Sequence_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGSequence, this->id, "Sequence_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7100 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 790 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		{
#line 792 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  7109 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 792 "ast-to-cfg.k"
			    {
				{
#line 793 "ast-to-cfg.k"
#line 792 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 793 "ast-to-cfg.k"

				    CFGBlock * current = globals::cfgMap.find(toString(innerActivity->id))->second;

				    connectBlocks(last, current->firstBlock);
				    last = current->lastBlock;

#line  7128 "ast-system-unpk.cc"
				}
			    }

#line  7132 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 792 "ast-to-cfg.k"

#line  7137 "ast-system-unpk.cc"
		    }
		}
#line 798 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  7144 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 802 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Sequence\n");

#line  7150 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 377 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 377 "ast-to-xml.k"
		const activity_list b = this->activity_list_1;
#line 377 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 378 "ast-to-xml.k"
		inup(); 
#line  7165 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sequence id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 378 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7171 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 378 "ast-to-xml.k"
		indown(); 
#line  7177 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sequence>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 139 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  7187 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 139 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  7196 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7201 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7214 "ast-system-unpk.cc"
void
impl_tIf_If::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 638 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 638 "ast-to-visualization.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 638 "ast-to-visualization.k"
		const tElse c = this->tElse_1;
#line 638 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 640 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"If\";" << endl;  
		(*output) << "if" << toString(_id->value) << " [shape=diamond style=filled label=\"\"];" << endl;
		globals::ASTEmap[_id->value]->secVisConnection = "if" + toString(_id->value);

#line  7236 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 646 "ast-to-visualization.k"

		int middle = 0;

		{
#line 649 "ast-to-visualization.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7248 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 649 "ast-to-visualization.k"
			    {
#line 650 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 650 "ast-to-visualization.k"
#line 649 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 650 "ast-to-visualization.k"

				    middle += 1;

#line  7265 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7270 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 649 "ast-to-visualization.k"

#line  7275 "ast-system-unpk.cc"
		    }
		}
#line 653 "ast-to-visualization.k"

		{
#line 654 "ast-to-visualization.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 657 "ast-to-visualization.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 657 "ast-to-visualization.k"
#line 656 "ast-to-visualization.k"
			const tElse c = kc_selvar_0_1;
#line 656 "ast-to-visualization.k"
			const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 656 "ast-to-visualization.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 657 "ast-to-visualization.k"

			middle += 1;

#line  7296 "ast-system-unpk.cc"
		    } else
			kc_no_default_in_with( "", __LINE__, __FILE__ );
		}
#line 661 "ast-to-visualization.k"

		middle = middle/2 + (middle % 2);
		int childcounter=1;

		{
#line 665 "ast-to-visualization.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7309 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 665 "ast-to-visualization.k"
			    {
#line 666 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 666 "ast-to-visualization.k"
#line 665 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 666 "ast-to-visualization.k"

				    globals::visArcs += "if" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter+=1;

#line  7340 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7345 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 665 "ast-to-visualization.k"

#line  7350 "ast-system-unpk.cc"
		    }
		}
#line 682 "ast-to-visualization.k"

		{
#line 683 "ast-to-visualization.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 686 "ast-to-visualization.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 686 "ast-to-visualization.k"
#line 685 "ast-to-visualization.k"
			const tElse c = kc_selvar_0_1;
#line 685 "ast-to-visualization.k"
			const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 685 "ast-to-visualization.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 686 "ast-to-visualization.k"

			globals::visArcs += "if" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
			if (globals::ASTEmap[innerActivity->id]->structured())
			{
			    globals::visArcs += "lhead=";
			    globals::visArcs += "cluster";          
			    globals::visArcs += toString(innerActivity->id);          
			    globals::visArcs += " ";          
			}
			globals::visArcs += "];\n";

			if (childcounter<=middle)
			{
			    globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
			}

#line  7384 "ast-system-unpk.cc"
		    } else
		    {
#line 702 "ast-to-visualization.k"
#line 702 "ast-to-visualization.k"


#line  7391 "ast-system-unpk.cc"
		    }
		}
#line 705 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  7398 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1728 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1728 "ast-postprocess.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 1728 "ast-postprocess.k"
		const tElse c = this->tElse_1;
#line 1728 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1730 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);


		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		globals::if_branches[myid] = 1;




		{
#line 1751 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7439 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1751 "ast-postprocess.k"
			    {
#line 1752 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1752 "ast-postprocess.k"
#line 1751 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1751 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1751 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1752 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

				    globals::if_branches[myid]++;

#line  7465 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7470 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1751 "ast-postprocess.k"

#line  7475 "ast-system-unpk.cc"
		    }
		}
#line 1760 "ast-postprocess.k"


		{
#line 1762 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1765 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1765 "ast-postprocess.k"
#line 1764 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1764 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1764 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1765 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			globals::ASTEmap[d->id]->parentActivityId = myid;
			globals::ASTEmap[d->id]->controlFlow = myself->controlFlow;
			globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;

#line  7500 "ast-system-unpk.cc"
		    } else
		    {
#line 1771 "ast-postprocess.k"
#line 1771 "ast-postprocess.k"

#line  7506 "ast-system-unpk.cc"
		    }
		}
#line 1773 "ast-postprocess.k"

#line  7511 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1775 "ast-postprocess.k"


		{
#line 1777 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7522 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1777 "ast-postprocess.k"
			    {
#line 1778 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1778 "ast-postprocess.k"
#line 1777 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1777 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1777 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1778 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

#line  7545 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7550 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1777 "ast-postprocess.k"

#line  7555 "ast-system-unpk.cc"
		    }
		}
#line 1783 "ast-postprocess.k"

		{
#line 1784 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1787 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1787 "ast-postprocess.k"
#line 1786 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1786 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1786 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1787 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks);
			myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[d->id]->enclosedTargetLinks);

#line  7578 "ast-system-unpk.cc"
		    } else
		    {
#line 1792 "ast-postprocess.k"
#line 1792 "ast-postprocess.k"

#line  7584 "ast-system-unpk.cc"
		    }
		}
#line 1794 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7593 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tElse_1->prod_sel() == sel_Else)) {
#line 610 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 610 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 610 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 610 "ast-to-cfg.k"
		const activity c = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->activity_1;
#line 610 "ast-to-cfg.k"
		const integer d = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->integer_1;
#line 610 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 611 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7623 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 623 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 626 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7634 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 626 "ast-to-cfg.k"
			    {
#line 627 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 627 "ast-to-cfg.k"
#line 626 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 626 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 627 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  7663 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7668 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 626 "ast-to-cfg.k"

#line  7673 "ast-system-unpk.cc"
		    }
		}
#line 639 "ast-to-cfg.k"

		CFGBlock * elseBlock = new CFGBlock(CFGElse, this->id, "Else");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(last, elseBlock);
		connectBlocks(elseBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  7686 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		if ((this->tElse_1->prod_sel() == sel_NoElse)) {
#line 652 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 652 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 652 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 652 "ast-to-cfg.k"
		const integer _id = phylum_cast<const impl_tElse_NoElse*>(this->tElse_1)->integer_1;
#line 652 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 653 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7711 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 664 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 667 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7721 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 667 "ast-to-cfg.k"
			    {
#line 668 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 668 "ast-to-cfg.k"
#line 667 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 667 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 668 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  7750 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7755 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 667 "ast-to-cfg.k"

#line  7760 "ast-system-unpk.cc"
		    }
		}
#line 680 "ast-to-cfg.k"










		connectBlocks(last, lastBlock);

#line  7776 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tElseIf_list_1->prod_sel() == sel_ConstElseIf_list) && ((this->tElseIf_list_1)->tElseIf_1->prod_sel() == sel_ElseIf)) {
#line 386 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 386 "ast-to-xml.k"
		const activity b = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->activity_1;
#line 386 "ast-to-xml.k"
		const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->integer_1;
#line 386 "ast-to-xml.k"
		const tElseIf_list c = (this->tElseIf_list_1)->tElseIf_list_1;
#line 386 "ast-to-xml.k"
		const tElse d = this->tElse_1;
#line 386 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 387 "ast-to-xml.k"
		inup(); 
#line  7799 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<if id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 387 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7805 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 387 "ast-to-xml.k"

#line  7809 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 387 "ast-to-xml.k"
		indown(); 
#line  7816 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</if>\n"), kc_current_view); }
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 151 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  7827 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 151 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  7836 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7841 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  7862 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tElseIf_list iterator_ = this; iterator_->tElseIf_list_1 != 0; iterator_ = iterator_->tElseIf_list_1)
		    iterator_->tElseIf_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  7881 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  7894 "ast-system-unpk.cc"
void
impl_tElseIf_ElseIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 711 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 711 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1802 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1802 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1804 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  7927 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1814 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7935 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 390 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 390 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 391 "ast-to-xml.k"
		inup(); 
#line  7948 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<elseif id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 391 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7954 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 391 "ast-to-xml.k"
		indown(); 
#line  7959 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</elseif>\n"), kc_current_view); }
	    }
	    break;
	}

#line  7965 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7978 "ast-system-unpk.cc"
void
impl_tElse_NoElse::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1841 "ast-postprocess.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  7992 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8005 "ast-system-unpk.cc"
void
impl_tElse_Else::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 716 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 716 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1822 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1822 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1824 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;

#line  8037 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1833 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  8045 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 394 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 394 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 395 "ast-to-xml.k"
		inup(); 
#line  8058 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<else id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 395 "ast-to-xml.k"
		indown(); 
#line  8065 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</else>\n"), kc_current_view); }
	    }
	    break;
	}

#line  8071 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8084 "ast-system-unpk.cc"
void
impl_tWhile_While::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 725 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 725 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 725 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 727 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"While\";" << endl;  

#line  8102 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 731 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[b->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[b->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8111 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1848 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1848 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1848 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1850 "ast-postprocess.k"


		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  8155 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1881 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[b->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8171 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 701 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 701 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 701 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 702 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] While\n");
		CFGBlock * block = new CFGBlock(CFGWhile, this->id, "While"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  8191 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 709 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  8201 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 403 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 403 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 403 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 404 "ast-to-xml.k"
		inup(); 
#line  8217 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<while id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 404 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8223 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 404 "ast-to-xml.k"
		indown(); 
#line  8229 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</while>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 131 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  8239 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 131 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  8248 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8253 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8266 "ast-system-unpk.cc"
void
impl_tRepeatUntil_RepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 744 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 744 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 744 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 746 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"RepeatUntil\";" << endl;  

#line  8284 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 750 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[b->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[b->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8293 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1904 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1904 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1904 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1906 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  8336 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1936 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[b->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8352 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 749 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 749 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 749 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 750 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] RepeatUntil\n");
		CFGBlock * repeat = new CFGBlock(CFGRepeatUntil, this->id, "Repeat"); 
		CFGBlock * until = new CFGBlock(CFGRepeatUntil, this->id, "Until"); 

		repeat->firstBlock = until->firstBlock = repeat;
		repeat->lastBlock  = until->lastBlock  = until;

		globals::cfgMap[toString(this->id)] = repeat; 

#line  8376 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 761 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(repeat, innerFirst);
		connectBlocks(innerLast, until);
		connectBlocks(until, repeat);

#line  8387 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 412 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 412 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 412 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 413 "ast-to-xml.k"
		inup(); 
#line  8403 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<repeatUntil id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 413 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8409 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 413 "ast-to-xml.k"
		indown(); 
#line  8415 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 135 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  8425 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 135 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  8434 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8439 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8452 "ast-system-unpk.cc"
void
impl_tForEach_ForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 763 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 763 "ast-to-visualization.k"
		const casestring b = this->casestring_1;
#line 763 "ast-to-visualization.k"
		const casestring c = this->casestring_2;
#line 763 "ast-to-visualization.k"
		const casestring d = this->casestring_3;
#line 763 "ast-to-visualization.k"
		const tScope e = this->tScope_1;
#line 763 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 765 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"ForEach\";" << endl;  

#line  8476 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 769 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[e->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[e->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8484 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2129 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2129 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 2129 "ast-postprocess.k"
		const casestring c = this->casestring_2;
#line 2129 "ast-postprocess.k"
		const casestring d = this->casestring_3;
#line 2129 "ast-postprocess.k"
		const tScope e = this->tScope_1;
#line 2129 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2131 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);    

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();



		myself->checkVariable("counterName");


		assert(globals::ASTEmap[e->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->controlFlow = myself->controlFlow;


		unsigned int startCounter = toUInt(b->name);
		unsigned int finalCounter = toUInt(c->name);
		unsigned int completion = toUInt(d->name);

		if (startCounter != UINT_MAX && finalCounter != UINT_MAX)
		{
		    if (startCounter >= finalCounter)
		    {
			string error = "constant <finalCounterValue> `" + toString(finalCounter) +
			"' less or equal than constant <startCounterValue> `" + toString(startCounter) + "'";
			SAerror(74, error, myself->attributes["referenceLine"]);
		    }
		    else
		    {
			if (myself->attributes["hu:maxloops"] != "")
			cerr << "ignoring attribute `hu:maxloops'" << endl; 
			globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * (finalCounter - startCounter);
			myself->max_loops = (finalCounter - startCounter);
		    }

		    if ((completion != UINT_MAX) && ((completion > (finalCounter-startCounter))))
		    SAerror(75, "", myself->attributes["referenceLine"]);
		}
		else
		{

		    if ((globals::choreography_filename != "") && (string(b->name) == "opaque") && (string(c->name) == "opaque"))
		    {

			myself->max_loops = globals::BPEL4ChorInfo.forEach_count(myid);
		    }
		    else
		    {

			unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
			if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
			globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * max_loops;
			else
			globals::ASTEmap[e->id]->max_occurrences = UINT_MAX;

			myself->max_loops = max_loops;
		    }
		}

#line  8569 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
#line 2197 "ast-postprocess.k"


		{
#line 2199 "ast-postprocess.k"
		    tScope kc_selvar_0_1 = phylum_cast<tScope>(e);
#line 2202 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Scope)) {
#line 2202 "ast-postprocess.k"
#line 2201 "ast-postprocess.k"
			const tScope e = kc_selvar_0_1;
#line 2201 "ast-postprocess.k"
			const tVariable_list _variables = phylum_cast<const impl_tScope_Scope*>(kc_selvar_0_1)->tVariable_list_1;
#line 2201 "ast-postprocess.k"
			const tMessageExchange_list messageExchange = phylum_cast<const impl_tScope_Scope*>(kc_selvar_0_1)->tMessageExchange_list_1;
#line 2202 "ast-postprocess.k"

			{
#line 2203 "ast-postprocess.k"
			    tVariable_list kc_fe_selvar_1 =  _variables;

#line  8593 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstVariable_list
				) {
				tVariable kc_selvar_1_1 = kc_fe_selvar_1->tVariable_1;
				{
#line 2203 "ast-postprocess.k"
				    {
#line 2204 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Variable)) {
#line 2204 "ast-postprocess.k"
#line 2203 "ast-postprocess.k"
					    const tVariable variable = kc_selvar_1_1;
#line 2203 "ast-postprocess.k"
					    const integer _id2 = phylum_cast<const impl_tVariable_Variable*>(kc_selvar_1_1)->integer_1;
#line 2204 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(globals::ASTEmap[_id2->value] != NULL);
					    if (globals::ASTEmap[_id2->value]->attributes["name"] == globals::ASTEmap[_id->value]->attributes["counterName"])
					    SAerror(76, globals::ASTEmap[_id2->value]->attributes["name"], globals::ASTEmap[_id2->value]->attributes["referenceLine"]);

#line  8615 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  8620 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tVariable_list_1;
#line 2203 "ast-postprocess.k"

#line  8625 "ast-system-unpk.cc"
			    }
			}
#line 2209 "ast-postprocess.k"


#line  8631 "ast-system-unpk.cc"
		    } else
			kc_no_default_in_with( "", __LINE__, __FILE__ );
		}
#line 2212 "ast-postprocess.k"


		assert(globals::ASTEmap[e->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8648 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 725 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 725 "ast-to-cfg.k"
		const casestring b = this->casestring_1;
#line 725 "ast-to-cfg.k"
		const casestring c = this->casestring_2;
#line 725 "ast-to-cfg.k"
		const casestring d = this->casestring_3;
#line 725 "ast-to-cfg.k"
		const tScope e = this->tScope_1;
#line 725 "ast-to-cfg.k"
		const integer f = this->integer_1;
#line 726 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ForEach\n");
		CFGBlock * block = new CFGBlock(CFGForEach, this->id, "ForEach"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  8674 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 733 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  8684 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 421 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 421 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 421 "ast-to-xml.k"
		const casestring c = this->casestring_2;
#line 421 "ast-to-xml.k"
		const casestring d = this->casestring_3;
#line 421 "ast-to-xml.k"
		const tScope e = this->tScope_1;
#line 421 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 422 "ast-to-xml.k"
		inup(); 
#line  8706 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<foreach id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 422 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8712 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 424 "ast-to-xml.k"
		inup(); 
#line  8717 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<startCounterValue>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 424 "ast-to-xml.k"
		indown(); 
#line  8722 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</startCounterValue>\n"), kc_current_view); }
#line 425 "ast-to-xml.k"
		inup(); 
#line  8726 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<finalCounterValue>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 425 "ast-to-xml.k"
		indown(); 
#line  8731 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</finalCounterValue>\n"), kc_current_view); }
#line 426 "ast-to-xml.k"
		inup(); 
#line  8735 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<completionCondition>\n"), kc_current_view); }
		kc::unparse(d, kc_printer, kc_current_view);
#line 426 "ast-to-xml.k"
		indown(); 
#line  8740 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</completionCondition>\n"), kc_current_view); }
		kc::unparse(e, kc_printer, kc_current_view);
#line 428 "ast-to-xml.k"
		indown(); 
#line  8745 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 155 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  8755 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 155 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  8764 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8769 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8782 "ast-system-unpk.cc"
void
impl_tPick_Pick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 782 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 782 "ast-to-visualization.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 782 "ast-to-visualization.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 782 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 784 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Pick\";" << endl;  
		(*output) << "pick" << toString(_id->value) << " [shape=diamond style=filled label=\"?\"];" << endl;
		globals::ASTEmap[_id->value]->secVisConnection = "pick" + toString(_id->value);

#line  8804 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 790 "ast-to-visualization.k"

		int middle = 0;
		{
#line 792 "ast-to-visualization.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  8815 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 792 "ast-to-visualization.k"
			    {
#line 793 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 793 "ast-to-visualization.k"
#line 792 "ast-to-visualization.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 792 "ast-to-visualization.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 792 "ast-to-visualization.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 792 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 792 "ast-to-visualization.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 793 "ast-to-visualization.k"

				    middle+=1;

#line  8840 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8845 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 792 "ast-to-visualization.k"

#line  8850 "ast-system-unpk.cc"
		    }
		}
#line 796 "ast-to-visualization.k"
		{
#line 796 "ast-to-visualization.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  8858 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 796 "ast-to-visualization.k"
			    {
#line 797 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 797 "ast-to-visualization.k"
#line 796 "ast-to-visualization.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 796 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 796 "ast-to-visualization.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 797 "ast-to-visualization.k"

				    middle+=1;

#line  8879 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8884 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 796 "ast-to-visualization.k"

#line  8889 "ast-system-unpk.cc"
		    }
		}
#line 800 "ast-to-visualization.k"

		middle = middle/2 + (middle % 2);
		int childcounter = 1;

		{
#line 804 "ast-to-visualization.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  8901 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 804 "ast-to-visualization.k"
			    {
#line 805 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 805 "ast-to-visualization.k"
#line 804 "ast-to-visualization.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 804 "ast-to-visualization.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 804 "ast-to-visualization.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 804 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 804 "ast-to-visualization.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 805 "ast-to-visualization.k"

				    globals::visArcs += "pick" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  8940 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8945 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 804 "ast-to-visualization.k"

#line  8950 "ast-system-unpk.cc"
		    }
		}
#line 822 "ast-to-visualization.k"
		{
#line 822 "ast-to-visualization.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  8958 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 822 "ast-to-visualization.k"
			    {
#line 823 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 823 "ast-to-visualization.k"
#line 822 "ast-to-visualization.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 822 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 822 "ast-to-visualization.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 823 "ast-to-visualization.k"

				    globals::visArcs += "pick" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  8993 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8998 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 822 "ast-to-visualization.k"

#line  9003 "ast-system-unpk.cc"
		    }
		}
#line 840 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9009 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2029 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2029 "ast-postprocess.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 2029 "ast-postprocess.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 2029 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2031 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 2047 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9045 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 2047 "ast-postprocess.k"
			    {
#line 2048 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 2048 "ast-postprocess.k"
#line 2047 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 2047 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 2047 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 2047 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 2047 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 2048 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;

#line  9074 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9079 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2047 "ast-postprocess.k"

#line  9084 "ast-system-unpk.cc"
		    }
		}
#line 2055 "ast-postprocess.k"
		{
#line 2055 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9092 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 2055 "ast-postprocess.k"
			    {
#line 2056 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 2056 "ast-postprocess.k"
#line 2055 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 2055 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 2055 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 2056 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  9117 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9122 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2055 "ast-postprocess.k"

#line  9127 "ast-system-unpk.cc"
		    }
		}
#line 2063 "ast-postprocess.k"

#line  9132 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 2065 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);


		    if (c->length() != 0)
		    SAerror(62, "", myself->attributes["referenceLine"]);




		}


		{
#line 2080 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9156 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 2080 "ast-postprocess.k"
			    {
#line 2081 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 2081 "ast-postprocess.k"
#line 2080 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 2080 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 2080 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 2080 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 2080 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 2081 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

				    {
#line 2086 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  9187 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 2086 "ast-postprocess.k"
						{
#line 2087 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 2087 "ast-postprocess.k"
#line 2086 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 2086 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 2086 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 2087 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if (_id2->value < _id3->value)
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  9213 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9218 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2086 "ast-postprocess.k"

#line  9223 "ast-system-unpk.cc"
					}
				    }
#line 2095 "ast-postprocess.k"

#line  9228 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9233 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2080 "ast-postprocess.k"

#line  9238 "ast-system-unpk.cc"
		    }
		}
#line 2096 "ast-postprocess.k"
		{
#line 2096 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9246 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 2096 "ast-postprocess.k"
			    {
#line 2097 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 2097 "ast-postprocess.k"
#line 2096 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 2096 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 2097 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

				    {
#line 2102 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  9271 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 2102 "ast-postprocess.k"
						{
#line 2103 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 2103 "ast-postprocess.k"
#line 2102 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 2102 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 2103 "ast-postprocess.k"

							enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );

#line  9290 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9295 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2102 "ast-postprocess.k"

#line  9300 "ast-system-unpk.cc"
					}
				    }
#line 2106 "ast-postprocess.k"

				    {
#line 2107 "ast-postprocess.k"
					tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9309 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
					    ) {
					    tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
					    {
#line 2107 "ast-postprocess.k"
						{
#line 2108 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 2108 "ast-postprocess.k"
#line 2107 "ast-postprocess.k"
							const tOnAlarm otherbranch = kc_selvar_1_1;
#line 2107 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 2108 "ast-postprocess.k"

							if (innerActivity->id < secondActivity->id)
							{
							    enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );
							}

#line  9331 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9336 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2107 "ast-postprocess.k"

#line  9341 "ast-system-unpk.cc"
					}
				    }
#line 2114 "ast-postprocess.k"

#line  9346 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9351 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2096 "ast-postprocess.k"

#line  9356 "ast-system-unpk.cc"
		    }
		}
#line 2115 "ast-postprocess.k"


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  9366 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 813 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 813 "ast-to-cfg.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 813 "ast-to-cfg.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 813 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 814 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Pick\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "Pick_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "Pick_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  9392 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 826 "ast-to-cfg.k"

		int i = 1;
		{
#line 828 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9402 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 828 "ast-to-cfg.k"
			    {
#line 829 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 829 "ast-to-cfg.k"
#line 828 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 828 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 829 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  9428 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9433 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 828 "ast-to-cfg.k"

#line  9438 "ast-system-unpk.cc"
		    }
		}
#line 838 "ast-to-cfg.k"

		i = 1; 
		{
#line 840 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9448 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 840 "ast-to-cfg.k"
			    {
#line 841 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 841 "ast-to-cfg.k"
#line 840 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 840 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 841 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  9473 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9478 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 840 "ast-to-cfg.k"

#line  9483 "ast-system-unpk.cc"
		    }
		}
#line 849 "ast-to-cfg.k"


#line  9489 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 436 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 436 "ast-to-xml.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 436 "ast-to-xml.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 436 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 437 "ast-to-xml.k"
		inup(); 
#line  9507 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<pick id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 437 "ast-to-xml.k"
		listAttributes( _id ); 
#line  9513 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 437 "ast-to-xml.k"
		indown(); 
#line  9520 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</pick>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 147 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  9530 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 147 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  9539 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  9544 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  9557 "ast-system-unpk.cc"
void
impl_tFlow_Flow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 850 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 850 "ast-to-visualization.k"
		const activity_list c = this->activity_list_1;
#line 850 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 852 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Flow\";" << endl;  

#line  9575 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 856 "ast-to-visualization.k"

		int middle = 0;
		{
#line 858 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9585 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 858 "ast-to-visualization.k"
			    {
				{
#line 859 "ast-to-visualization.k"
#line 858 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 859 "ast-to-visualization.k"

				    middle+=1;

#line  9601 "ast-system-unpk.cc"
				}
			    }

#line  9605 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 858 "ast-to-visualization.k"

#line  9610 "ast-system-unpk.cc"
		    }
		}
#line 862 "ast-to-visualization.k"
		middle = middle/2 + (middle % 2);
		int childcounter = 1;
		{
#line 864 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9620 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 864 "ast-to-visualization.k"
			    {
				{
#line 865 "ast-to-visualization.k"
#line 864 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 865 "ast-to-visualization.k"

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->secVisConnection;
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  9641 "ast-system-unpk.cc"
				}
			    }

#line  9645 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 864 "ast-to-visualization.k"

#line  9650 "ast-system-unpk.cc"
		    }
		}
#line 873 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9656 "ast-system-unpk.cc"
	    } else
	    {
#line 878 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 878 "ast-to-visualization.k"
		const tLink_list b = this->tLink_list_1;
#line 878 "ast-to-visualization.k"
		const activity_list c = this->activity_list_1;
#line 878 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 880 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Flow\";" << endl;  

#line  9671 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 884 "ast-to-visualization.k"

		int middle = 0;
		{
#line 886 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9682 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 886 "ast-to-visualization.k"
			    {
				{
#line 887 "ast-to-visualization.k"
#line 886 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 887 "ast-to-visualization.k"

				    middle+=1;

#line  9698 "ast-system-unpk.cc"
				}
			    }

#line  9702 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 886 "ast-to-visualization.k"

#line  9707 "ast-system-unpk.cc"
		    }
		}
#line 890 "ast-to-visualization.k"
		middle = middle/2 + (middle % 2);
		int childcounter = 1;    

		{
#line 893 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9718 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 893 "ast-to-visualization.k"
			    {
				{
#line 894 "ast-to-visualization.k"
#line 893 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 894 "ast-to-visualization.k"

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->secVisConnection;
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  9739 "ast-system-unpk.cc"
				}
			    }

#line  9743 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 893 "ast-to-visualization.k"

#line  9748 "ast-system-unpk.cc"
		    }
		}
#line 902 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9754 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1620 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1620 "ast-postprocess.k"
		const tLink_list b = this->tLink_list_1;
#line 1620 "ast-postprocess.k"
		const activity_list c = this->activity_list_1;
#line 1620 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1622 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		{
#line 1639 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9791 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1639 "ast-postprocess.k"
			    {
				{
#line 1640 "ast-postprocess.k"
#line 1639 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1640 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  9810 "ast-system-unpk.cc"
				}
			    }

#line  9814 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1639 "ast-postprocess.k"

#line  9819 "ast-system-unpk.cc"
		    }
		}
#line 1646 "ast-postprocess.k"
		{
#line 1646 "ast-postprocess.k"
		    tLink_list kc_fe_selvar_1 =  b;

#line  9827 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstLink_list
			) {
			tLink kc_selvar_0_1 = kc_fe_selvar_1->tLink_1;
			{
#line 1646 "ast-postprocess.k"
			    {
				{
#line 1647 "ast-postprocess.k"
#line 1646 "ast-postprocess.k"
				    const tLink link = kc_selvar_0_1;
#line 1647 "ast-postprocess.k"

				    assert(globals::ASTEmap[link->id] != NULL);
				    globals::ASTEmap[ link->id ]->parentActivityId = myid;
				    globals::ASTEmap[ myid ]->enclosedActivities.insert( link->id );

#line  9845 "ast-system-unpk.cc"
				}
			    }

#line  9849 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tLink_list_1;
#line 1646 "ast-postprocess.k"

#line  9854 "ast-system-unpk.cc"
		    }
		}
#line 1652 "ast-postprocess.k"

#line  9859 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1654 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		{
#line 1659 "ast-postprocess.k"
		    tLink_list kc_fe_selvar_1 =  b;

#line  9873 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstLink_list
			) {
			tLink kc_selvar_0_1 = kc_fe_selvar_1->tLink_1;
			{
#line 1659 "ast-postprocess.k"
			    {
				{
#line 1660 "ast-postprocess.k"
#line 1659 "ast-postprocess.k"
				    const tLink link = kc_selvar_0_1;
#line 1660 "ast-postprocess.k"

				    assert(globals::ASTEmap[link->id] != NULL);
				    enterConsecutiveActivities( globals::ASTEmap[ link->id ]->sourceActivity, globals::ASTEmap[ link->id ]->targetActivity );

#line  9890 "ast-system-unpk.cc"
				}
			    }

#line  9894 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tLink_list_1;
#line 1659 "ast-postprocess.k"

#line  9899 "ast-system-unpk.cc"
		    }
		}
#line 1664 "ast-postprocess.k"


		unsigned int startActivityId = 0;

		{
#line 1668 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9911 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1668 "ast-postprocess.k"
			    {
				{
#line 1669 "ast-postprocess.k"
#line 1668 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1669 "ast-postprocess.k"


				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);


				    if (globals::ASTEmap[innerActivity->id]->isStartActivity)
				    startActivityId = innerActivity->id;

#line  9934 "ast-system-unpk.cc"
				}
			    }

#line  9938 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1668 "ast-postprocess.k"

#line  9943 "ast-system-unpk.cc"
		    }
		}
#line 1679 "ast-postprocess.k"


		if (startActivityId != 0)
		{
		    {
#line 1683 "ast-postprocess.k"
			activity_list kc_fe_selvar_1 =  c;

#line  9955 "ast-system-unpk.cc"
			while(
				kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			    ) {
			    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			    {
#line 1683 "ast-postprocess.k"
				{
				    {
#line 1684 "ast-postprocess.k"
#line 1683 "ast-postprocess.k"
					const activity innerActivity = kc_selvar_0_1;
#line 1684 "ast-postprocess.k"

					assert(globals::ASTEmap[innerActivity->id] != NULL);

					if (!globals::ASTEmap[innerActivity->id]->isStartActivity &&
					    globals::ASTEmap[innerActivity->id]->targetLinks.empty())
					{
					    SAerror(56, "<" + globals::ASTEmap[startActivityId]->activityTypeName() + ">", globals::ASTEmap[startActivityId]->attributes["referenceLine"]);
					    break;
					}

#line  9978 "ast-system-unpk.cc"
				    }
				}

#line  9982 "ast-system-unpk.cc"
			    }
			    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1683 "ast-postprocess.k"

#line  9987 "ast-system-unpk.cc"
			}
		    }
#line 1694 "ast-postprocess.k"
		}





#line  9997 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 576 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 576 "ast-to-cfg.k"
		const tLink_list b = this->tLink_list_1;
#line 576 "ast-to-cfg.k"
		const activity_list c = this->activity_list_1;
#line 576 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 577 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Flow\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFlow, this->id, "Flow_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGFlow, this->id, "Flow_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  10023 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 588 "ast-to-cfg.k"

		{
#line 589 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  10031 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 589 "ast-to-cfg.k"
			    {
				{
#line 590 "ast-to-cfg.k"
#line 589 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 590 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(firstBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  10051 "ast-system-unpk.cc"
				}
			    }

#line  10055 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 589 "ast-to-cfg.k"

#line  10060 "ast-system-unpk.cc"
		    }
		}
#line 596 "ast-to-cfg.k"


#line  10066 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 599 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Flow\n");

#line  10072 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 445 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 445 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 445 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 446 "ast-to-xml.k"
		inup(); 
#line  10087 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 446 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10093 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 446 "ast-to-xml.k"
		indown(); 
#line  10099 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    } else
	    {
#line 449 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 449 "ast-to-xml.k"
		const tLink_list b = this->tLink_list_1;
#line 449 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 449 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 450 "ast-to-xml.k"
		inup(); 
#line  10113 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 450 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10119 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 450 "ast-to-xml.k"
		inup(); 
#line  10124 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<links>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 450 "ast-to-xml.k"
		indown(); 
#line  10129 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</links>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 450 "ast-to-xml.k"
		indown(); 
#line  10134 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 143 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  10144 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 143 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  10153 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  10158 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  10178 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tLink_list iterator_ = this; iterator_->tLink_list_1 != 0; iterator_ = iterator_->tLink_list_1)
		    iterator_->tLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  10196 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  10208 "ast-system-unpk.cc"
void
impl_tLink_Link::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 907 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1703 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1705 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->linkName = myself->defineLink();

		globals::ASTE_linkIdMap[ myself->linkName ] = myid;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  10242 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 453 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 454 "ast-to-xml.k"
		in(); 
#line  10253 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<link id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 454 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10259 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  10265 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  10278 "ast-system-unpk.cc"
void
impl_tScope_Scope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 916 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 916 "ast-to-visualization.k"
		const tVariable_list b = this->tVariable_list_1;
#line 916 "ast-to-visualization.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 916 "ast-to-visualization.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 916 "ast-to-visualization.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 916 "ast-to-visualization.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 916 "ast-to-visualization.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 916 "ast-to-visualization.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 916 "ast-to-visualization.k"
		const activity i = this->activity_1;
#line 916 "ast-to-visualization.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 916 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 918 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value+1000) << " { label = \"Scope\";" << endl;  

#line  10312 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 922 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Scope Activity\";" << endl;  

#line  10324 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 926 "ast-to-visualization.k"

		(*output) << "}" << endl;    

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[i->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[i->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  10334 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2232 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2232 "ast-postprocess.k"
		const tVariable_list b = this->tVariable_list_1;
#line 2232 "ast-postprocess.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 2232 "ast-postprocess.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 2232 "ast-postprocess.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 2232 "ast-postprocess.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 2232 "ast-postprocess.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 2232 "ast-postprocess.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 2232 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 2232 "ast-postprocess.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 2232 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2234 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		a->parentId = myid;




		myself->parentScopeId = globals::PPcurrentScope;


		globals::PPcurrentScope = myid;

		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		assert(globals::ASTEmap[myself->parentScopeId] != NULL);
		myself->checkAttributes();

		for ( std::set<unsigned int>::iterator peerScope = globals::ASTEmap[myself->parentScopeId]->enclosedScopes.begin(); 
		    peerScope != globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end(); 
		    peerScope++)
		{
		    globals::ASTEmap[*peerScope]->peerScopes.insert(myid);
		    globals::ASTEmap[myid]->peerScopes.insert(*peerScope);
		}




		if (myself->controlFlow == POSITIVECF)
		globals::ASTEmap[myself->parentScopeId]->enclosedScopes.insert(myid);

		myself->hasEH = (string(f->op_name()) == "EventHandlers");



		assert(globals::ASTEmap[c->id] != NULL);
		assert(globals::ASTEmap[d->id] != NULL);
		assert(globals::ASTEmap[e->id] != NULL);
		assert(globals::ASTEmap[f->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;
		globals::ASTEmap[d->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[f->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = c->id;
		myself->enclosedCH = d->id;

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[f->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[i->id]->max_occurrences = myself->max_occurrences;


		if (myself->attributes["name"] != "")
		{

		    if (globals::ASTE_scopeNames[myself->attributes["name"]] != 0)
		    SAerror(92, myself->attributes["name"], myself->attributes["referenceLine"]);

		    globals::ASTE_scopeNames[myself->attributes["name"]] = myid;
		}


		if (myself->attributes["isolated"] == "yes" &&
		    globals::ASTEmap[myself->parentScopeId]->findIsolatedAncestor())
		SAerror(91, "", myself->attributes["referenceLine"]);

#line  10436 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(messageExchange, kc_printer, kc_current_view);
		kc::unparse(j, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
#line 2309 "ast-postprocess.k"


		bool callableFH = false;
		for ( set< string >::iterator fault = globals::ASTEmap[ c->id ]->catches.begin(); fault != globals::ASTEmap[ c->id ]->catches.end(); fault++)
		{
		    string faultName = fault->substr( fault->find_first_of( "|" ) + 1 );
		    faultName = faultName.substr( 0, faultName.find_first_of( "|" ) );
		    if (faultName.find_first_of(":") < faultName.npos)
		    {
			faultName = faultName.substr( faultName.find_first_of(":") + 1 );
		    }

		    if ( myself->possiblyTriggeredFaults.find( faultName ) != myself->possiblyTriggeredFaults.end() )
		    {
			callableFH = true;


		    }
		}
		if ( globals::ASTEmap[ c->id ]->hasCatchAll && ! myself->possiblyTriggeredFaults.empty() )
		{
		    callableFH = true;
		}

		globals::ASTEmap[ c->id ]->callable = callableFH;

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ c->id ]->enclosedActivities;
		faultIds.insert( c->id );
		set< unsigned int > compIds = globals::ASTEmap[ d->id ]->enclosedActivities;
		compIds.insert( d->id );

		enterConflictingActivities( innerIds, faultIds );
		enterConflictingActivities( faultIds, compIds );


		globals::ASTEmap[d->id]->enclosedScopes = myself->enclosedScopes;


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[i->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[f->id]->enclosedSourceLinks);

		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[i->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[c->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[d->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[f->id]->enclosedTargetLinks);



		globals::PPcurrentScope = myself->parentScopeId;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );



		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(120, "", myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  10515 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 860 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 860 "ast-to-cfg.k"
		const tVariable_list b = this->tVariable_list_1;
#line 860 "ast-to-cfg.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 860 "ast-to-cfg.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 860 "ast-to-cfg.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 860 "ast-to-cfg.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 860 "ast-to-cfg.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 860 "ast-to-cfg.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 860 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 860 "ast-to-cfg.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 860 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 861 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Scope\n");
		CFGBlock * firstBlock = new CFGBlock(CFGScope, this->id, "Scope_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGScope, this->id, "Scope_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  10555 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 872 "ast-to-cfg.k"

		CFGBlock * fhFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * fhLast  = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);


#line  10566 "ast-system-unpk.cc"
		kc::unparse(d, kc_printer, kc_current_view);
#line 881 "ast-to-cfg.k"

		CFGBlock * chFirst = globals::cfgMap.find(toString(d->id))->second->firstBlock;
		CFGBlock * chLast  = globals::cfgMap.find(toString(d->id))->second->lastBlock;

		connectBlocks(firstBlock, chFirst);
		connectBlocks(chLast, lastBlock);


#line  10577 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 890 "ast-to-cfg.k"

		CFGBlock * thFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * thLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(firstBlock, thFirst);
		connectBlocks(thLast, lastBlock);


#line  10588 "ast-system-unpk.cc"
		kc::unparse(f, kc_printer, kc_current_view);
#line 899 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(f->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(f->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  10599 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 908 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  10609 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 916 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Scope\n");

#line  10615 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 462 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 462 "ast-to-xml.k"
		const tVariable_list b = this->tVariable_list_1;
#line 462 "ast-to-xml.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 462 "ast-to-xml.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 462 "ast-to-xml.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 462 "ast-to-xml.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 462 "ast-to-xml.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 462 "ast-to-xml.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 462 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 462 "ast-to-xml.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 462 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 463 "ast-to-xml.k"
		inup(); 
#line  10646 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<scope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 463 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10652 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 467 "ast-to-xml.k"
		if (b->length() == 0) 
#line  10657 "ast-system-unpk.cc"
		{
		}
#line 469 "ast-to-xml.k"
		else 
#line  10662 "ast-system-unpk.cc"
		{
#line 470 "ast-to-xml.k"
		    inup(); 
#line  10666 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables id=\""), kc_current_view); }
		    kc::unparse(_id, kc_printer, kc_current_view);
		    { kc_printer(kc_t("\">\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 470 "ast-to-xml.k"
		    indown(); 
#line  10673 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 474 "ast-to-xml.k"
		indown(); 
#line  10684 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</scope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 176 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  10694 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 176 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  10703 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  10708 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  10721 "ast-system-unpk.cc"
void
impl_standardElements_NoStandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  10727 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  10739 "ast-system-unpk.cc"
void
impl_standardElements_StandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 941 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 942 "ast-to-visualization.k"
		const tSource_list a = this->tSource_list_1;
#line 942 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 943 "ast-to-visualization.k"
		const tTarget_list a = this->tTarget_list_1;
#line 943 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
	    {
#line 944 "ast-to-visualization.k"
		const tTarget_list a = this->tTarget_list_1;
#line 944 "ast-to-visualization.k"
		const tSource_list b = this->tSource_list_1;
#line 944 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2384 "ast-postprocess.k"
		const tTarget_list a = this->tTarget_list_1;
#line 2384 "ast-postprocess.k"
		const tSource_list b = this->tSource_list_1;
#line 2384 "ast-postprocess.k"
		const joinCondition _joinCondition = this->joinCondition_1;
#line 2386 "ast-postprocess.k"

		assert(globals::ASTEmap[this->parentId] != NULL);
		this->suppressJF = (globals::ASTEmap[this->parentId]->attributes["suppressJoinFailure"] == "yes");


		_joinCondition->parentId = this->parentId;

#line  10789 "ast-system-unpk.cc"
		kc::unparse(_joinCondition, kc_printer, kc_current_view);
#line 2394 "ast-postprocess.k"

		unsigned int linkCount = 0;
		{
#line 2396 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10798 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 2396 "ast-postprocess.k"
			    {
				{
#line 2397 "ast-postprocess.k"
#line 2396 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 2397 "ast-postprocess.k"

				    assert(globals::ASTEmap[targetLink->id] != NULL);
				    globals::ASTEmap[targetLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[targetLink->id]->parentActivityId = this->parentId;


				    globals::joinCondition_links[globals::ASTEmap[targetLink->id]->attributes["linkName"]] = ++linkCount; 

#line  10819 "ast-system-unpk.cc"
				}
			    }

#line  10823 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 2396 "ast-postprocess.k"

#line  10828 "ast-system-unpk.cc"
		    }
		}
#line 2405 "ast-postprocess.k"

		{
#line 2406 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  10837 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 2406 "ast-postprocess.k"
			    {
				{
#line 2407 "ast-postprocess.k"
#line 2406 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 2407 "ast-postprocess.k"

				    assert(globals::ASTEmap[sourceLink->id] != NULL);
				    globals::ASTEmap[sourceLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[sourceLink->id]->parentActivityId = this->parentId;

#line  10855 "ast-system-unpk.cc"
				}
			    }

#line  10859 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 2406 "ast-postprocess.k"

#line  10864 "ast-system-unpk.cc"
		    }
		}
#line 2412 "ast-postprocess.k"











		unsigned int assignments = (unsigned int)pow(2.0, a->length());
		for (unsigned int assignment = 0; assignment < assignments; assignment++)
		{

		    for (unsigned int link = 0; link < linkCount; link++)
		    {
			if (((assignment >> link) % 2) == 0) 
			globals::joinCondition_linkStatus[link] = true;
			else
			globals::joinCondition_linkStatus[link] = false;
		    }


		    _joinCondition->unparse(pseudoPrinter, evaluation);


		    {
#line 2439 "ast-postprocess.k"
			joinCondition kc_selvar_0_1 = phylum_cast<joinCondition>(_joinCondition);
#line 2442 "ast-postprocess.k"
			if ((kc_selvar_0_1->prod_sel() == sel_userDefinedJoinCondition)) {
#line 2442 "ast-postprocess.k"
#line 2441 "ast-postprocess.k"
			    const joinCondition _joinCondition = kc_selvar_0_1;
#line 2441 "ast-postprocess.k"
			    const expression _exp = phylum_cast<const impl_joinCondition_userDefinedJoinCondition*>(kc_selvar_0_1)->expression_1;
#line 2442 "ast-postprocess.k"
			    globals::joinCondition_result[_joinCondition->parentId][assignment] = _exp->value; 
#line  10907 "ast-system-unpk.cc"
			    	} else
			{
#line 2443 "ast-postprocess.k"
#line 2443 "ast-postprocess.k"

#line  10913 "ast-system-unpk.cc"
			}
		    }
#line 2445 "ast-postprocess.k"
		}


		globals::joinCondition_links.clear();
		globals::joinCondition_linkStatus.clear();


#line  10924 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 2453 "ast-postprocess.k"


		set<string> targetLinks;
		{
#line 2456 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10935 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 2456 "ast-postprocess.k"
			    {
				{
#line 2457 "ast-postprocess.k"
#line 2456 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 2457 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[targetLink->id]->linkName;
				    if (targetLinks.find(linkName) != targetLinks.end())
				    SAerror(69, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    targetLinks.insert(linkName);

#line  10957 "ast-system-unpk.cc"
				}
			    }

#line  10961 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 2456 "ast-postprocess.k"

#line  10966 "ast-system-unpk.cc"
		    }
		}
#line 2466 "ast-postprocess.k"

		set<string> sourceLinks;
		{
#line 2468 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  10976 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 2468 "ast-postprocess.k"
			    {
				{
#line 2469 "ast-postprocess.k"
#line 2468 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 2469 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[sourceLink->id]->linkName;
				    if (sourceLinks.find(linkName) != sourceLinks.end())
				    SAerror(68, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    sourceLinks.insert(linkName);

#line  10998 "ast-system-unpk.cc"
				}
			    }

#line  11002 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 2468 "ast-postprocess.k"

#line  11007 "ast-system-unpk.cc"
		    }
		}
#line 2478 "ast-postprocess.k"


#line  11013 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 927 "ast-to-cfg.k"
		const standardElements This = this/**/;
#line 927 "ast-to-cfg.k"
		const tTarget_list a = this->tTarget_list_1;
#line 927 "ast-to-cfg.k"
		const tSource_list b = this->tSource_list_1;
#line 927 "ast-to-cfg.k"
		const joinCondition jc = this->joinCondition_1;
#line 929 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(This->parentId))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(This->parentId))->second->lastBlock;
		{
#line 932 "ast-to-cfg.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  11036 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 932 "ast-to-cfg.k"
			    {
				{
#line 933 "ast-to-cfg.k"
#line 932 "ast-to-cfg.k"
				    const tTarget link = kc_selvar_0_1;
#line 933 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Target\n");



				    CFGBlock * target = new CFGBlock(CFGTarget, link->id, "Target_" + globals::ASTEmap[link->id]->linkName);

				    targets["Source_" + globals::ASTEmap[link->id]->linkName] = target;









				    connectBlocks(target, innerFirst->firstBlock);
				    innerFirst->firstBlock = target;
				    target->lastBlock = innerLast->lastBlock;

#line  11070 "ast-system-unpk.cc"
				}
			    }

#line  11074 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 932 "ast-to-cfg.k"

#line  11079 "ast-system-unpk.cc"
		    }
		}
#line 954 "ast-to-cfg.k"

		{
#line 955 "ast-to-cfg.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  11088 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 955 "ast-to-cfg.k"
			    {
				{
#line 956 "ast-to-cfg.k"
#line 955 "ast-to-cfg.k"
				    const tSource link = kc_selvar_0_1;
#line 956 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Source\n");



				    CFGBlock * source = new CFGBlock(CFGSource, link->id, "Source_" + globals::ASTEmap[link->id]->linkName);

				    sources["Target_" + globals::ASTEmap[link->id]->linkName] = source;













				    connectBlocks(innerLast->lastBlock, source);
				    innerLast->lastBlock = innerFirst->lastBlock = source;

				    innerFirst->firstBlock->lastBlock = source;
				    trace(TRACE_DEBUG, "[CFG] ~Source\n");


#line  11129 "ast-system-unpk.cc"
				}
			    }

#line  11133 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 955 "ast-to-cfg.k"

#line  11138 "ast-system-unpk.cc"
		    }
		}
#line 984 "ast-to-cfg.k"



#line  11145 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 482 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 483 "ast-to-xml.k"
		const tSource_list a = this->tSource_list_1;
#line 483 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 483 "ast-to-xml.k"
		inup(); 
#line  11162 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 483 "ast-to-xml.k"
		indown(); 
#line  11167 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 484 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 484 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 484 "ast-to-xml.k"
		inup(); 
#line  11177 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 484 "ast-to-xml.k"
		indown(); 
#line  11182 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
	    } else
	    {
#line 485 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 485 "ast-to-xml.k"
		const tSource_list b = this->tSource_list_1;
#line 485 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 485 "ast-to-xml.k"
		inup(); 
#line  11194 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 485 "ast-to-xml.k"
		indown(); 
#line  11199 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
#line 485 "ast-to-xml.k"
		inup(); 
#line  11203 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 485 "ast-to-xml.k"
		indown(); 
#line  11208 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 215 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 216 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  11220 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 219 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 219 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 220 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  11229 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 223, this))) {
#line 223 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 223 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 223 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 224 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  11240 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 227, this))) {
#line 227 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 227 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 227 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 228 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  11251 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 231, this))) {
#line 231 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 231 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 231 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 231 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 232 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  11264 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 235, this))) {
#line 235 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 235 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 235 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 235 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 236 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  11277 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 215 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 216 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  11289 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 219 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 219 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 220 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  11298 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 223, this))) {
#line 223 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 223 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 223 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 224 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  11309 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 227, this))) {
#line 227 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 227 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 227 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 228 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  11320 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 231, this))) {
#line 231 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 231 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 231 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 231 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 232 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  11333 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 235, this))) {
#line 235 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 235 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 235 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 235 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 236 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  11346 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}

#line  11352 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  11373 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tTarget_list iterator_ = this; iterator_->tTarget_list_1 != 0; iterator_ = iterator_->tTarget_list_1)
		    iterator_->tTarget_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11392 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11405 "ast-system-unpk.cc"
void
impl_tTarget_Target::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 946 "ast-to-visualization.k"
		const integer a = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2483 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2485 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();



		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		globals::ASTEmap[myself->parentActivityId]->enclosedTargetLinks.insert(linkId);
		globals::ASTEmap[myself->parentActivityId]->targetLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->targetActivity != 0) 
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->targetActivity = myself->parentActivityId;
		}

		if ( myself->attributes["suppressJoinFailure"]  == "no" )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( "joinFailure" );
		}

#line  11454 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 487 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 488 "ast-to-xml.k"
		in(); 
#line  11465 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<target"), kc_current_view); }
#line 488 "ast-to-xml.k"
		listAttributes( a ); 
#line  11469 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  11475 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tSource_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  11495 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tSource_list iterator_ = this; iterator_->tSource_list_1 != 0; iterator_ = iterator_->tSource_list_1)
		    iterator_->tSource_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tSource_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11513 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11525 "ast-system-unpk.cc"
void
impl_tSource_Source::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 950 "ast-to-visualization.k"
		const integer a = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2518 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2520 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();




		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		globals::ASTEmap[myself->parentActivityId]->enclosedSourceLinks.insert(linkId);
		globals::ASTEmap[myself->parentActivityId]->sourceLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->sourceActivity != 0)
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->sourceActivity = myself->parentActivityId;
		}

#line  11570 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 491 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 492 "ast-to-xml.k"
		in(); 
#line  11581 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<source"), kc_current_view); }
#line 492 "ast-to-xml.k"
		listAttributes( a ); 
#line  11585 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  11591 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11604 "ast-system-unpk.cc"
void
impl_joinCondition_userDefinedJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2549 "ast-postprocess.k"
		const expression _exp = this->expression_1;
#line 2551 "ast-postprocess.k"
		_exp->parentId = this->parentId; 
#line  11616 "ast-system-unpk.cc"
		kc::unparse(_exp, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11622 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11635 "ast-system-unpk.cc"
void
impl_joinCondition_standardJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11641 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11653 "ast-system-unpk.cc"
void
impl_expression_Disjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2611 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2611 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2615 "ast-postprocess.k"
		this->value = (_exp1->value || _exp2->value); 
#line  11669 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2563 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2563 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2565 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  11682 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11689 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11702 "ast-system-unpk.cc"
void
impl_expression_Conjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2603 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2603 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2607 "ast-postprocess.k"
		this->value = (_exp1->value && _exp2->value); 
#line  11718 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2556 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2556 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2558 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  11731 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11738 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11751 "ast-system-unpk.cc"
void
impl_expression_Term::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2579 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
#line 2581 "ast-postprocess.k"


		string linkname_string = string(_linkname->name);
		if (linkname_string[0] == '$')
		linkname_string = linkname_string.substr(1, linkname_string.length() -1);



		if (globals::joinCondition_links[linkname_string] == 0)
		{
		    assert(globals::ASTEmap[this->parentId] != NULL);
		    SAerror(73, linkname_string, globals::ASTEmap[this->parentId]->attributes["referenceLine"]);
		}
		else
		{

		    this->value = globals::joinCondition_linkStatus[globals::joinCondition_links[linkname_string] -1];
		}

#line  11781 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2570 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
	    }
	    break;
	}

#line  11794 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


} // namespace kc
