// Copyright (C) 2005 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "module.h"
#include "private.h"

namespace moduleWebservice {
using namespace ost;
using namespace std;

void Session::htmlFooter(void)
{
	const char *sl = sla;
	unsigned long upt = uptime();
	char dur[65];

	if(upt < 3600)
		snprintf(dur, sizeof(dur), "%ld minute(s)", upt / 60);
	else if(upt < (36000l))
		snprintf(dur, sizeof(dur), "%ld hour(s), %ld minute(s)",
			upt / 3600, (upt / 60) % 60);
	else if(upt < (360000l))
		snprintf(dur, sizeof(dur), "%ld hours", upt / 3600);
	else
		snprintf(dur, sizeof(dur), "%ld days", upt / (3600l * 24l));

	if(!sl || !*sl)
		sl = "up";

	snprintf(buffer, sizeof(buffer),
		"<HR>Bayonne server version " VERSION "; node=%s timeslots=%d service level=%s; running %s<BR>\r\n", 
		server->getLast("servername"), ts_used, sl, dur);
	sendText(buffer);
	sendText("</BODY></HTML>\r\n");
	sendText("\r\n");
	syncExit();
}

void Session::htmlHeader(const char *title, bool refresh)
{
	sendHeader();
	snprintf(buffer, sizeof(buffer), "<HTML><HEAD><TITLE>%s</TITLE>\r\n", title);
	sendText(buffer);
	if(refresh)
	{
		snprintf(buffer, sizeof(buffer),
			"<META HTTP-EQUIV=Refresh CONTENT=\"%s\"/>\r\n",
			Service::webservice.getLast("refresh"));
		sendText(buffer);
	}
	sendText("</HEAD><BODY>\r\n");
}

void Session::htmlCalls(void)
{
	BayonneSession *s;
	timeslot_t index = 0;

	htmlHeader("Bayonne Calls", true);
	sendText("<H1>Bayonne Calls</H1><P>\r\n");
	sendText("<TABLE border=\"1\" summary=\"Active Calls\">\r\n");
	sendText("<CAPTION><EM>Active Calls</EM></CAPTION>\r\n");
	sendText("<TR><TH>Session<TH>Parent<TH>Type<TH>Time<TH>Duration<TH>From<TH>Caller<TH>Line\r\n");

	while(index < ts_used)
	{
		s = getSession(index++);
		if(!s)
			continue;

		s->enter();
		if(s->isIdle())
		{
			s->leave();
			continue;
		}
		snprintf(buffer, sizeof(buffer),
			"<TR><TD>%s<TD>%s<TD>%s<TD>%s<TD>%s<TD>%s<TD>%s<TD>%s\r\n",
			s->getExternal("session.id"),
			s->getExternal("session.pid"),
			s->getExternal("session.type"),
			s->getExternal("session.time"),
			s->getExternal("session.duration"),
			s->getSymbol("session.caller"),
			s->getSymbol("session.display"),
			s->getExternal("session.line"));
		sendText(buffer);
		s->leave();
	}
	sendText("</TABLE>\r\n");
	htmlFooter();
}

void Session::htmlControl(void)
{
	const char *cmd = NULL;
	bool valid = true;
	bool success = false;
	const char *sid = NULL;
	char *tok;
	const char *qtarget = NULL;
	const char *qscript = NULL;
	const char *qcaller = NULL;
	const char *qdisplay = NULL;
	
	const char *qsid = NULL;
	const char *errmsg = NULL;
	BayonneSession *s;
	Event event;

	if(req_query)
		req_query = strtok_r(req_query, "&\r\n", &tok);

	while(req_query)
	{
		if(!strnicmp(req_query, "command=", 8)) 
			cmd = urlDecode(req_query + 8);
		else if(!strnicmp(req_query, "session=", 8))
			qsid = urlDecode(req_query + 8);
		else if(!strnicmp(req_query, "target=", 7))
			qtarget = urlDecode(req_query + 7);
		else if(!strnicmp(req_query, "script=", 7))
			qscript = urlDecode(req_query + 7);
		else if(!strnicmp(req_query, "caller=", 7))
			qcaller = urlDecode(req_query + 7);
		else if(!strnicmp(req_query, "display=", 8))
			qdisplay = urlDecode(req_query + 8); 
		
		req_query = strtok_r(NULL, "&\r\n", &tok);
	}

	htmlHeader("Bayonne Control", false);
	sendText("<H1>Bayonne Control</H1><P>\r\n");

	if(!cmd)
	{
		sendText("Request: missing<BR>\r\n");
		htmlFooter();
	}

	if(!stricmp(cmd, "start"))
	{
		if(!qscript)
		{
			errmsg = "script name missing";
			goto results;
		}
		if(!qtarget)
		{
			errmsg = "destination missing";
			goto results;
		}
		s = Bayonne::startDialing(qtarget, qscript, qcaller, qdisplay);
		if(s)
		{
			sid = s->getExternal("session.id");
			success = true;
			s->leave();
		}
		goto results;
	}			

	if(!stricmp(cmd, "stop"))
	{
		if(!qsid)		
		{
			errmsg = "session id missing";
			goto results;
		}
		s = getSid(qsid);
		if(!s)
		{
			errmsg = "session id invalid";
			goto results;
		}
		memset(&event, 0, sizeof(event));
		event.id = STOP_SCRIPT;
		if(s->postEvent(&event))
			success = true;
		else
			errmsg = "stop ignored";
		goto results;				
	}
	else if(!stricmp(cmd, "reload"))
	{
		Bayonne::reload();
		success = true;
	}
	else if(!stricmp(cmd, "shutdown"))
	{
		Service::active = false;
		Bayonne::down();
		success = true;
	}
	else
		valid = false;

results:
	snprintf(buffer, sizeof(buffer), "Request: %s<BR>\r\n", cmd);
	sendText(buffer);

	if(!valid)
	{
		sendText("Result: command invalid<BR>\r\n");
		htmlFooter();
	}

	if(success)
		sendText("Result: success<BR>\r\n");
	else if(errmsg)
	{
		snprintf(buffer, sizeof(buffer),
			"Result: %s<BR>\r\n", errmsg);
		sendText(buffer);
	}
	else
		sendText("Result: failed<BR>\r\n");

	if(sid)
	{
		snprintf(buffer, sizeof(buffer), "Session: %s<BR>\r\n", sid);
		sendText(buffer);
	}
	htmlFooter();
}

void Session::htmlStatus(void)
{	
	BayonneDriver *d = BayonneDriver::getPrimary();
	unsigned count;
	regauth_t *r;

	htmlHeader("Bayonne Status", true);
	sendText("<H1>Bayonne Status</H1><P>\r\n");

	sendText("<TABLE border=\"1\" summary=\"Installed Drivers\">\r\n");
	sendText("<CAPTION><EM>Drivers loaded into server</EM></CAPTION>\r\n");
	sendText("<TR><TH rowspan=\"2\">Name<TH colspan=\"2\">Timeslots<TH colspan=\"2\">Spans\r\n");
	sendText("<TR><TH>first<TH>count<TH>first<TH>count\r\n");
	while(d)
	{
		snprintf(buffer, sizeof(buffer), "<TR><TD>%s<TD>%d<TD>%d<TD>%d<TD>%d\r\n",
			d->getName(), (int)d->getFirst(), (int)d->getCount(),
 			(int)d->getSpanFirst(), (int)d->getSpansUsed());

		sendText(buffer);
		d = d->getNext();
	}	
	sendText("</TABLE>\r\n");

	d = BayonneDriver::getPrimary();
	sendText("<TABLE border=\"1\" summary=\"Server Registrations\">\r\n");
	sendText("<CAPTION><EM>Server Registrations</EM></CAPTION>\r\n");
	sendText("<TR><TH>Remote<TH>User<TH>Type<TH>Status\r\n");
	while(d)
	{
		count = d->getRegistration(regs, 1024);
		r = regs;
		while(count--)
		{
			snprintf(buffer, sizeof(buffer),
				"<TR><TD>%s<TD>%s<TD>%s<TD>%s\r\n",
				r->remote, r->userid, r->type, r->status);
			sendText(buffer);
			++r;
		} 
		d = d->getNext();
	}
	sendText("</TABLE>\r\n");

	snprintf(buffer, sizeof(buffer), "Activity: %s<BR>\r\n", Bayonne::status);
	sendText(buffer);

	htmlFooter();	
}

} // namespace 
