#!/bin/sh

if [ ! -r VERSION ] ; then
	echo "$0: No VERSION file! "
	exit 1
fi
version="`cat VERSION`"
if [ "$version" != "kehpager V1.22" ] ; then
	echo "This patch must run agaist kehpager V1.22!"
	echo "This source is: $version"
	exit 1
fi
 
if [ ! -r COPYRIGHT ] ; then
	echo "Creating file COPYRIGHT ..."
else
	echo "Updating file COPYRIGHT ..."
	mv COPYRIGHT COPYRIGHT.orig || exit 1
fi
if cp patch3.COPYRIGHT COPYRIGHT ; then
	echo "OK"
else
	exit 1
fi

echo "Updating file charset.c ..."
mv charset.c charset.c.orig || exit 1
if cp patch3.charset.c charset.c ; then
	echo "OK"
else
	exit 1
fi

echo "Patching rest of source..."
if patch -c -N <patch3.diff ; then
	echo "Patching OK"
else
	exit 1
fi
echo "Kehpager is updated to version 1.23"
exit 0
