/*  file: charset.c
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994, 1995 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#include <string.h>
#include <limits.h>
#include <ctype.h>
#include <stdio.h>

#include "kehpager.h"
#include "memory.h"

#include "charset.h"
#include "rc.h"
#include "terminal.h"
#include "control.h"

CHAR_IDX CH_WRA;
CHAR_IDX CH_NL;
CHAR_IDX CH_SUB_M;
CHAR_IDX CH_SUP_M;
CHAR_IDX CH_END_M;
CHAR_IDX CH_SPC_C;
CHAR_IDX CH_IND_B;
CHAR_IDX CH_IND_E;
CHAR_IDX CH_MAR_B;
CHAR_IDX CH_MAR_E;
CHAR_IDX CH_NP;
CHAR_IDX CH_OVER;

CHAR_IDX CH_SPC;
CHAR_IDX CH_TAB;
CHAR_IDX CH_SHY;
CHAR_IDX CH_SHY2;
CHAR_IDX CH_NBSP;
CHAR_IDX CH_HY;
CHAR_IDX CH_NBHY;
CHAR_IDX CH_HY2;
CHAR_IDX CH_UL;
CHAR_IDX CH_GT;
CHAR_IDX CH_LT;
CHAR_IDX CH_ZERO;
CHAR_IDX CH_FF;
CHAR_IDX CH_PLUS;
CHAR_IDX CH_LSEP;
CHAR_IDX CH_PSEP;

struct CV chars [] = {
  /*              ASCII,   LATIN1,   MULT, SPECIAL, FINNISH 
                     UK    NORWEGIAN,  SWEDISH, LATIN4,  LATIN5,
		     ISO-8859-*,LATIN2, BELGIAN, GERMAN, CAN,
		     LATIN3,  CP437, TECHNICAL, SPANISH, MAC,
		     ITAL, Unicode 1.1, ISO646-SE, ISO646-SE2, ISO646-NO,
		     ISO646-NO2, ISO646-CN, ISO646-CA2, ISO646-FR, SWISS,
		     ISO646-JP, ISO646-PT, ISO646-PT2, ISO646-ES, ISO646-ES2,
                     ISO646-HU, ISO646-YU, ISO646-CU */
  /* Mnemonics */
   { "[NUL]", {0,0}, 0, NULL, 
      {               0,        0,      0,        0,       0,
		      0,        0,      0,        0,       0,
		      0,        0,      0,        0,       0,
	              0,        0,      0,        0,       0,
		      0,        0,      0,        0,        0,
		      0,        0,      0,      0,     0,
                     0,       0,      0,      0,      0,
                     0,      0,      0,      0 },
      {  NULL, NULL  } },

  { "\\",    {0,0}, 0, &CH_WRA,
      {              -1,       -1,     -1,       -1,      -1,
		     -1,       -1,     -1,       -1,      -1,
		     -1,       -1,     -1,       -1,      -1,
		     -1,       -1,     -1,       -1,      -1,
		     -1,       -1,     -1,        -1,        -1,
		     -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } },  
  { "[NL]",  {0,0}, 0, &CH_NL,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } },  
  { "_(",  {0,0}, 0, &CH_SUB_M,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } },
  { "^(",  {0,0}, 0, &CH_SUP_M,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } }, 
  { ")",  {0,0}, 0, &CH_END_M,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } },
  { " ",  {0,0}, 0, &CH_SPC_C,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } },
  { " ",  {0,0}, 0, &CH_IND_B,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } }, 
  { " ",  {0,0}, 0, &CH_IND_E,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } }, 
  { " ",  {0,0}, 0, &CH_MAR_B,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } }, 
  { " ",  {0,0}, 0, &CH_MAR_E,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } }, 
  { "[NP]",  {0,0}, 0, &CH_NP,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } },
  { "[*OVER*]",  {0,0}, 0, &CH_OVER,
      {                -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
		       -1,       -1,     -1,     -1,      -1,
	               -1,       -1,     -1,     -1,    -1,
		       -1,       -1,     -1,        -1,        -1,
		       -1,        -1,      -1,      -1,     -1,
                     -1,       -1,      -1,      -1,      -1,
                     -1,      -1,      -1,      -1 },
      {  NULL, NULL } },

  /* Control characters */
  { "[BEL]", {0,0}, 0, NULL,
      {               7,        7,      7,       7,       7,
		      7,        7,      7,       7,       7,
                      7,        7,      7,       7,       7,
       	              7,        7,      7,       7,       7,
		      7,        7,      7,        7,        7,
		      7,        7,      7,      7,     7,
                     7,       7,      7,      7,      7,
                     7,      7,      7,      7 },
      { NULL, NULL } },
  { "[BS]",  {0,0}, 0, NULL,
      {               8,        8,      8,       8,       8,
                      8,        8,      8,       8,       8,
                      8,        8,      8,       8,       8,
       	              8,        8,      8,       8,       8,
		      8,        8,      8,        8,        8,
		      8,        8,      8,      8,     8,
                     8,       8,      8,      8,      8,
                     8,      8,      8,      8 },
      { NULL, NULL } },
  { "[HT]",  {0,0}, 0, &CH_TAB,
      {               9,        9,      9,       9,       9,
                      9,        9,      9,       9,       9,
                      9,        9,      9,       9,       9,
                      9,        9,      9,       9,       9,
		      9,        9,      9,        9,        9,
		      9,        9,      9,      9,     9,
                     9,       9,      9,      9,      9,
                     9,      9,      9,      9 },
      { NULL, NULL } },
  { "[LF]",  {0,0}, 0, NULL,
      {              10,       10,     10,      10,      10,
                     10,       10,     10,      10,      10,
                     10,       10,     10,      10,      10 ,
                     10,       10,     10 ,     10,      10,
		     10,        10,     10,        10,        10,
		     10,        10,      10,      10,     10,
                     10,       10,      10,      10,      10,
                     10,      10,      10,      10 },
      { NULL, NULL } },
  { "[VT]",  {0,0}, 0, NULL,
      {              11,       11,     11,      11,      11,
		     11,       11,     11,      11,      11,
                     11,       11,     11,      11,      11 ,
                     11,       11,     11,      11,     11,
		     11,        11,     11,        11,        11,
		     11,        11,      11,      11,     11,
                     11,       11,      11,      11,      11,
                     11,      11,      11,      11 },
      { NULL, NULL } },
  { "[FF]",  {0,0}, 0, &CH_FF,
      {              12,       12,     12,      12,      12,
		     12,       12,     12,      12,      12,
                     12,       12,     12,      12,      12 ,
                     12,       12,     12,      12,    12,
		     12,        12,     12,        12,        12,
		     12,        12,      12,      12,     12,
                     12,       12,      12,      12,      12,
                     12,      12,      12,      12 },
      { NULL, NULL } },
  { "[CR]",  {0,0}, 0, NULL,
      {              13,       13,     13,      13,      13,
		     13,       13,     13,      13,      13,
                     13,       13,     13,      13,      13 ,
                     13,       13,     13,      13,    13,
		     13,       13,     13,        13,        13,
		     13,        13,      13,      13,     13,
                     13,       13,      13,      13,      13,
                     13,      13,      13,      13 },
      { NULL, NULL } },
  { "[ESC]",  {0,0}, 0, NULL,
      {              27,       27,     27,      27,      27,
		     27,       27,     27,      27,      27,
                     27,       27,     27,      27,      27 ,
                     27,       27,     27,      27,      27,
		     27,       27,     27,        27,        27,
		     27,        27,      27,      27,     27,
                     27,       27,      27,      27,      27,
                     27,      27,      27,      27 },
      { NULL, NULL } },

  { "[DEL]", {0,0}, 0, NULL,
      {            0x7F,     0x7F,   0x7F,   0x7F,     0x7F,
		   0x7F,     0x7F,   0x7F,   0x7F,     0x7F,
                   0x7F,     0x7F,   0x7F,   0x7F,     0x7F,
                   0x7F,     0x7F,   0x7F,   0x7F,     0x7F,
		   0x7F,     0x7F,   0x7F,        0x7F,        0x7F,
		   0x7F,        0x7F,      0x7F,      0x7F,     0x7F,
                     0x7F,       0x7F,      0x7F,      0x7F,      0x7F,
                     0x7F,      0x7F,      0x7F,      0x7F },
      { "DT",      NULL } },

  /* printable characters */
  { " ",  {0,0},  1, &CH_SPC,
      {          0x20,     0x20,   0x20,    0x20,    0x20,
		 0x20,     0x20,   0x20,    0x20,    0x20,
                 0x20,     0x20,   0x20,    0x20,    0x20,
                 0x20,     0x20,   0x20,    0x20,    0x20,
	         0x20,   0x0020,   0x20,        0x20,        0x20,
		 0x20,        0x20,      0x20,      0x20,     0x20,
                     0x20,       0x20,      0x20,      0x20,      0x20,
                     0x20,      0x20,      0x20,      0x20 },
      { "SP", "SPACE" } },
  { "!",  {0,0},  1, NULL,
      {          0x21,     0x21,   0x21,    0x21,    0x21,
		 0x21,     0x21,   0x21,    0x21,    0x21,
                 0x21,     0x21,   0x21,    0x21,    0x21,
                 0x21,     0x21,     -1,    0x21,    0x21,
	         0x21,   0x0021,   0x21,        0x21,        0x21,
		 0x21,        0x21,      0x21,      0x21,     0x21,
                     0x21,       0x21,      0x21,      0x21,      0x21,
                     0x21,      0x21,      0x21,      0x21 },
      { "!", "EXCLAMATION MARK" } },
  { "\"",  {0,0}, 1, NULL,
      {          0x22,     0x22,   0x22,    0x22,    0x22,
		 0x22,     0x22,   0x22,    0x22,    0x22,
                 0x22,     0x22,   0x22,    0x22,    0x22,
                 0x22,     0x22,   -1  ,    0x22,    0x22,
	         0x22,   0x0022,   0x22,    0x22,    0x22,
		 0x22,        0x22,      0x22,      0x22,     0x22,
                     0x22,       0x22,      0x22,      0x22,      0x22,
                     0x22,      0x22,      0x22,      0x22 },
       { "\"", "QUOTATION MARK" } },
  { "#",  {'+','+'},  1, NULL,
      {          0x23,     0x23,   0x23,    0x23,    0x23,
		   -1,     0x23,   0x23,    0x23,    0x23,
                 0x23,     0x23,     -1,    0x23,    0x23,
                 0x23,     0x23,   -1,        -1,    0x23,
	           -1,   0x0023,   0x23,    0x23,    0x23,
		   -1,     0x23,   0x23,      -1,      -1,
                 0x23,     0x23,   0x23,      -1,    0x23,
                 0x23,     0x23,   0x23,    0x23 },
      { "Nb", "NUMBER SIGN" } }, /* NAT 1 */
  { "$",  {'S','S'},  1, NULL,
      {          0x24,     0x24,   0x24,    0x24,    0x24, 
		 0x24,     0x24,   0x24,    0x24,    0x24,
                 0x24,     0x24,   0x24,    0x24,    0x24,
                 0x24,     0x24,     -1,    0x24,    0x24,
	         0x24,   0x0024,     -1,      -1,    0x24,
		 0x24,       -1,   0x24,    0x24,    0x24,
                 0x24,     0x24,   0x24,    0x24,    0x24,
                   -1,     0x24,     -1,    0x24 },
       { "DO", "DOLLAR SIGN" } }, /* NAT 2 */
  { "%",  {0,0},  1, NULL,
      {          0x25,     0x25,   0x25,    0x25,    0x25,
		 0x25,     0x25,   0x25,    0x25,    0x25,
                 0x25,     0x25,   0x25,    0x25,    0x25,
                 0x25,     0x25,     -1,    0x25,    0x25,
	         0x25,   0x0025,   0x25,    0x25,    0x25,
		 0x25,     0x25,   0x25,    0x25,    0x25,
                 0x25,     0x25,   0x25,    0x25,      0x25,
                 0x25,     0x25,   0x25,    0x25 },
       { "%", "PERCENT SIGN" } },
  { "&",  {0,0},  1, NULL,
      {          0x26,     0x26,   0x26,    0x26,    0x26,
		 0x26,     0x26,   0x26,    0x26,    0x26,
                 0x26,     0x26,   0x26,    0x26,    0x26,
                 0x26,     0x26,     -1,    0x26,   0x26,
	         0x26,   0x0026,   0x26,        0x26,        0x26,
		 0x26,        0x26,      0x26,      0x26,     0x26,
                     0x26,       0x26,      0x26,      0x26,      0x26,
                     0x26,      0x26,      0x26,      0x26 },
       { "&", "AMPERSAND" } },
  /* APOSTROPHE 
     APOSTROPHE-QUOTE */
  { "'",  {0,0},  1, NULL,
      {          0x27,     0x27,   0x27,    0x27,    0x27,
		 0x27,     0x27,   0x27,    0x27,    0x27,
                 0x27,     0x27,   0x27,    0x27,    0x27,
                 0x27,     0x27,     -1,    0x27,    0x27,
	         0x27,   0x0027,   0x27,    0x27,    0x27,
		 0x27,        0x27,      0x27,      0x27,     0x27,
                     0x27,       0x27,      0x27,      0x27,      0x27,
                     0x27,      0x27,      0x27,      0x27 },
      { "'", "APOSTROPHE" } },
  /* LEFT PARENTHESIS
     OPENING PARENTHESIS */
  { "(",  {0,0}, 1, NULL,
      {          0x28,     0x28,   0x28,    0x28,    0x28,
		 0x28,     0x28,   0x28,    0x28,    0x28,
                 0x28,     0x28,   0x28,    0x28,    0x28,
                 0x28,     0x28,     -1,    0x28,   0x28,
	         0x28,   0x0028,   0x28,        0x28,        0x28,
		 0x28,        0x28,      0x28,      0x28,     0x28,
                     0x28,       0x28,      0x28,      0x28,      0x28,
                     0x28,      0x28,      0x28,      0x28 },
      { "(", "LEFT PARENTHESIS" } },
  /* RIGHT PARENTHESIS
     CLOSING PARENTHESIS */
  { ")",  {0,0}, 1, NULL,
      {          0x29,     0x29,   0x29,    0x29,    0x29,
		 0x29,     0x29,   0x29,    0x29,    0x29,
                 0x29,     0x29,   0x29,    0x29,    0x29,
                 0x29,     0x29,     -1,    0x29,    0x29,
	         0x29,   0x0029,   0x29,        0x29,        0x29,
		 0x29,        0x29,      0x29,      0x29,     0x29,
                     0x29,       0x29,      0x29,      0x29,      0x29,
                     0x29,      0x29,      0x29,      0x29 },
      { ")", "RIGHT PARENTHESIS" } },
  { "*",  {0,0}, 1, NULL,
      {          0x2A,     0x2A,   0x2A,    0x2A,    0x2A,
		 0x2A,     0x2A,   0x2A,    0x2A,    0x2A,
                 0x2A,     0x2A,   0x2A,    0x2A,    0x2A,
                 0x2A,     0x2A,     -1,    0x2A,    0x2A,
	         0x2A,   0x002a,   0x2A,        0x2A,        0x2A,
		 0x2A,        0x2A,      0x2A,      0x2A,     0x2A,
                     0x2A,       0x2A,      0x2A,      0x2A,      0x2A,
                     0x2A,      0x2A,      0x2A,      0x2A },
      { "*", "ASTERISK" } },
  { "+",  {0,0}, 1, &CH_PLUS,
      {          0x2B,     0x2B,   0x2B,    0x2B,    0x2B,
		 0x2B,     0x2B,   0x2B,    0x2B,    0x2B,
                 0x2B,     0x2B,   0x2B,    0x2B,    0x2B,
                 0x2B,     0x2B,     -1,    0x2B,   0x2B,
	         0x2B,   0x002b,   0x2B,        0x2B,        0x2B,
		 0x2B,        0x2B,      0x2B,      0x2B,     0x2B,
                     0x2B,       0x2B,      0x2B,      0x2B,      0x2B,
                     0x2B,      0x2B,      0x2B,      0x2B },  
      { "+", "PLUS SIGN" } },
  { ",",  {0,0}, 1, NULL,
      {          0x2C,     0x2C,   0x2C,    0x2C,    0x2C,
		 0x2C,     0x2C,   0x2C,    0x2C,    0x2C,
                 0x2C,     0x2C,   0x2C,    0x2C,    0x2C,
                 0x2C,     0x2C,     -1,    0x2C,   0x2C,
	         0x2C,   0x002c,   0x2C,        0x2C,        0x2C,
		 0x2C,        0x2C,      0x2C,      0x2C,     0x2C,
                     0x2C,       0x2C,      0x2C,      0x2C,      0x2C,
                     0x2C,      0x2C,      0x2C,      0x2C },
      { ",", "COMMA" } },
  { "-",  {0,0}, 1, &CH_HY,
      {          0x2D,     0x2D,   0x2D,    0x2D,    0x2D,
		 0x2D,     0x2D,   0x2D,    0x2D,    0x2D,
                 0x2D,     0x2D,   0x2D,    0x2D,    0x2D,
                 0x2D,     0x2D,     -1,    0x2D,   0x2D,
	         0x2D,   0x002d,   0x2D,        0x2D,        0x2D,
		 0x2D,        0x2D,      0x2D,      0x2D,     0x2D,
                     0x2D,       0x2D,      0x2D,      0x2D,      0x2D,
                     0x2D,      0x2D,      0x2D,      0x2D },
      { "-", "HYPHEN-MINUS" } },
  /* FULL STOP
     PERIOD */
  { ".",  {0,0}, 1, NULL,
      {          0x2E,     0x2E,   0x2E,    0x2E,    0x2E,
		 0x2E,     0x2E,   0x2E,    0x2E,    0x2E,
                 0x2E,     0x2E,   0x2E,    0x2E,    0x2E,
                 0x2E,     0x2E,     -1,    0x2E,   0x2E,
	         0x2E,   0x002e,   0x2E,        0x2E,        0x2E,
		 0x2E,        0x2E,      0x2E,      0x2E,     0x2E,
                     0x2E,       0x2E,      0x2E,      0x2E,      0x2E,
                     0x2E,      0x2E,      0x2E,      0x2E },
      { ".", "FULL STOP" } },
  /* SOLIDUS
     SLASH */
  { "/",  {0,0}, 1, NULL,
      {          0x2F,     0x2F,   0x2F,    0x2F,    0x2F,
		 0x2F,     0x2F,   0x2F,    0x2F,    0x2F,
                 0x2F,     0x2F,   0x2F,    0x2F,    0x2F,
                 0x2F,     0x2F,     -1,    0x2F,   0x2F,
	         0x2F,   0x002f,   0x2F,        0x2F,        0x2F,
		 0x2F,        0x2F,      0x2F,      0x2F,     0x2F,
                     0x2F,       0x2F,      0x2F,      0x2F,      0x2F,
                     0x2F,      0x2F,      0x2F,      0x2F },
      { "/", "SOLIDUS" } },

  { "0",  {0,0}, 1, &CH_ZERO,
      {          0x30,     0x30,   0x30,    0x30,    0x30,
		 0x30,     0x30,   0x30,    0x30,    0x30,
                 0x30,     0x30,   0x30,    0x30,    0x30,
                 0x30,     0x30,     -1,    0x30,   0x30,
	         0x30,   0x0030,   0x30,        0x30,        0x30,
		 0x30,        0x30,      0x30,      0x30,     0x30,
                     0x30,       0x30,      0x30,      0x30,      0x30,
                     0x30,      0x30,      0x30,      0x30 },
      { "0", "DIGIT ZERO" } },
  { "1",  {0,0}, 1, NULL,
      {          0x31,     0x31,   0x31,    0x31,    0x31,
		 0x31,     0x31,   0x31,    0x31,    0x31,
                 0x31,     0x31,   0x31,    0x31,    0x31,
                 0x31,     0x31,     -1,    0x31,   0x31,
	         0x31,   0x0031,   0x31,        0x31,        0x31,
		 0x31,        0x31,      0x31,      0x31,     0x31,
                     0x31,       0x31,      0x31,      0x31,      0x31,
                     0x31,      0x31,      0x31,      0x31 },
      { "1", "DIGIT ONE" } },
  { "2",  {0,0}, 1, NULL,
      {          0x32,     0x32,   0x32,    0x32,    0x32,
		 0x32,     0x32,   0x32,    0x32,    0x32,
                 0x32,     0x32,   0x32,    0x32,    0x32,
                 0x32,     0x32,     -1,    0x32,   0x32,
	         0x32,   0x0032,   0x32,        0x32,        0x32,
		 0x32,        0x32,      0x32,      0x32,     0x32,
                     0x32,       0x32,      0x32,      0x32,      0x32,
                     0x32,      0x32,      0x32,      0x32 },
      { "2", "DIGIT TWO" } },
  { "3",  {0,0}, 1, NULL,
      {          0x33,     0x33,   0x33,    0x33,    0x33,
		 0x33,     0x33,   0x33,    0x33,    0x33,
                 0x33,     0x33,   0x33,    0x33,    0x33,
                 0x33,     0x33,     -1,    0x33,   0x33,
	         0x33,   0x0033,   0x33,        0x33,        0x33,
		 0x33,        0x33,      0x33,      0x33,     0x33,
                     0x33,       0x33,      0x33,      0x33,      0x33,
                     0x33,      0x33,      0x33,      0x33 },
      { "3", "DIGIT THREE" } },
  { "4",  {0,0}, 1, NULL,
      {          0x34,     0x34,   0x34,    0x34,    0x34,
		 0x34,     0x34,   0x34,    0x34,    0x34,
                 0x34,     0x34,   0x34,    0x34,    0x34,
                 0x34,     0x34,     -1,    0x34,   0x34,
	         0x34,   0x0034,   0x34,        0x34,        0x34,
		 0x34,        0x34,      0x34,      0x34,     0x34,
                     0x34,       0x34,      0x34,      0x34,      0x34,
                     0x34,      0x34,      0x34,      0x34 },
      { "4", "DIGIT FOUR" } },
  { "5",  {0,0}, 1, NULL,
      {          0x35,     0x35,   0x35,    0x35,    0x35,
		 0x35,     0x35,   0x35,    0x35,    0x35,
                 0x35,     0x35,   0x35,    0x35,    0x35,
                 0x35,     0x35,     -1,    0x35,   0x35,
	         0x35,   0x0035,   0x35,        0x35,        0x35,
		 0x35,        0x35,      0x35,      0x35,     0x35,
                     0x35,       0x35,      0x35,      0x35,      0x35,
                     0x35,      0x35,      0x35,      0x35 },
      { "5", "DIGIT FIVE" } },
  { "6",  {0,0}, 1, NULL,
      {          0x36,     0x36,   0x36,    0x36,    0x36,
		 0x36,     0x36,   0x36,    0x36,    0x36,
                 0x36,     0x36,   0x36,    0x36,    0x36,
                 0x36,     0x36,     -1,    0x36,   0x36,
	         0x36,   0x0036,   0x36,        0x36,        0x36,
		 0x36,        0x36,      0x36,      0x36,     0x36,
                     0x36,       0x36,      0x36,      0x36,      0x36,
                     0x36,      0x36,      0x36,      0x36 },
      { "6", "DIGIT SIX" } },
  { "7",  {0,0}, 1, NULL,
      {          0x37,     0x37,   0x37,    0x37,    0x37,
		 0x37,     0x37,   0x37,    0x37,    0x37,
                 0x37,     0x37,   0x37,    0x37,    0x37,
                 0x37,     0x37,     -1,    0x37,   0x37,
	         0x37,   0x0037,   0x37,        0x37,        0x37,
		 0x37,        0x37,      0x37,      0x37,     0x37,
                     0x37,       0x37,      0x37,      0x37,      0x37,
                     0x37,      0x37,      0x37,      0x37 },
      { "7", "DIGIT SEVEN" } },
  { "8",  {0,0}, 1, NULL,
      {          0x38,     0x38,   0x38,    0x38,    0x38,
		 0x38,     0x38,   0x38,    0x38,    0x38,
                 0x38,     0x38,   0x38,    0x38,    0x38,
                 0x38,     0x38,     -1,    0x38,   0x38,
	         0x38,   0x0038,   0x38,        0x38,        0x38,
		 0x38,        0x38,      0x38,      0x38,     0x38,
                     0x38,       0x38,      0x38,      0x38,      0x38,
                     0x38,      0x38,      0x38,      0x38 },
      { "8", "DIGIT EIGHT" } },
  { "9",  {0,0}, 1, NULL,
      {          0x39,     0x39,   0x39,    0x39,    0x39,
		 0x39,     0x39,   0x39,    0x39,    0x39,
                 0x39,     0x39,   0x39,    0x39,    0x39,
                 0x39,     0x39,     -1,    0x39,   0x39,
	         0x39,   0x0039,   0x39,        0x39,        0x39,
		 0x39,        0x39,      0x39,      0x39,     0x39,
                     0x39,       0x39,      0x39,      0x39,      0x39,
                     0x39,      0x39,      0x39,      0x39 },
      { "9", "DIGIT NINE" } },
  { ":",  {0,0}, 1, NULL,
      {          0x3A,     0x3A,   0x3A,    0x3A,    0x3A,
		 0x3A,     0x3A,   0x3A,    0x3A,    0x3A,
                 0x3A,     0x3A,   0x3A,    0x3A,    0x3A,
                 0x3A,     0x3A,     -1,    0x3A,   0x3A,
	         0x3A,   0x003a,   0x3A,        0x3A,        0x3A,
		 0x3A,        0x3A,      0x3A,      0x3A,     0x3A,
                     0x3A,       0x3A,      0x3A,      0x3A,      0x3A,
                     0x3A,      0x3A,      0x3A,      0x3A },
      { ":", "COLON" } },

  { ";",  {0,0}, 1, NULL,
      {          0x3B,     0x3B,   0x3B,    0x3B,    0x3B,
		 0x3B,     0x3B,   0x3B,    0x3B,    0x3B,
                 0x3B,     0x3B,   0x3B,    0x3B,    0x3B,
                 0x3B,     0x3B,     -1,    0x3B,   0x3B,
	         0x3B,   0x003b,   0x3B,        0x3B,        0x3B,
		 0x3B,        0x3B,      0x3B,      0x3B,     0x3B,
                     0x3B,       0x3B,      0x3B,      0x3B,      0x3B,
                     0x3B,      0x3B,      0x3B,      0x3B },
      { ";", "SEMICOLON" } },
  { "<",  {0,0}, 1, &CH_LT,
      {          0x3C,     0x3C,   0x3C,    0x3C,    0x3C,
		 0x3C,     0x3C,   0x3C,    0x3C,    0x3C,
                 0x3C,     0x3C,   0x3C,    0x3C,    0x3C,
                 0x3C,     0x3C,     -1,    0x3C,   0x3C,
	         0x3C,   0x003c,   0x3C,        0x3C,        0x3C,
		 0x3C,        0x3C,      0x3C,      0x3C,     0x3C,
                     0x3C,       0x3C,      0x3C,      0x3C,      0x3C,
                     0x3C,      0x3C,      0x3C,      0x3C },
      { "<", "LESS-THAN SIGN" } },
  { "=",  {0,0}, 1, NULL,
      {          0x3D,     0x3D,   0x3D,    0x3D,    0x3D,
		 0x3D,     0x3D,   0x3D,    0x3D,    0x3D,
                 0x3D,     0x3D,   0x3D,    0x3D,    0x3D,
                 0x3D,     0x3D,   0x3D,    0x3D,   0x3D,
	         0x3D,   0x003d,   0x3D,        0x3D,        0x3D,
		 0x3D,        0x3D,      0x3D,      0x3D,     0x3D,
                     0x3D,       0x3D,      0x3D,      0x3D,      0x3D,
                     0x3D,      0x3D,      0x3D,      0x3D },
      { "=", "EQUALS SIGN" } },
  { ">",  {0,0}, 1, &CH_GT,
      {          0x3E,     0x3E,   0x3E,    0x3E,    0x3E,
		 0x3E,     0x3E,   0x3E,    0x3E,    0x3E,
                 0x3E,     0x3E,   0x3E,    0x3E,    0x3E,
                 0x3E,     0x3E,   -1,      0x3E,     0x3E,
	         0x3E,   0x003e,   0x3E,        0x3E,        0x3E,
		 0x3E,        0x3E,      0x3E,      0x3E,     0x3E,
                     0x3E,       0x3E,      0x3E,      0x3E,      0x3E,
                     0x3E,      0x3E,      0x3E,      0x3E },
      { ">", "GREATER-THAN SIGN" } },
  { "?",  {0,0}, 1, NULL,
      {          0x3F,     0x3F,   0x3F,    0x3F,    0x3F,
		 0x3F,     0x3F,   0x3F,    0x3F,    0x3F,
                 0x3F,     0x3F,   0x3F,    0x3F,    0x3F,
                 0x3F,     0x3F,     -1,    0x3F,   0x3F,
	         0x3F,   0x003f,   0x3F,        0x3F,        0x3F,
		 0x3F,        0x3F,      0x3F,      0x3F,     0x3F,
                     0x3F,       0x3F,      0x3F,      0x3F,      0x3F,
                     0x3F,      0x3F,      0x3F,      0x3F },
      { "?", "QUESTION MARK" } },

  /*             ASCII,   LATIN1,   MULT, SPECIAL, FINNISH 
                 UK    NORWEGIAN,  SWEDISH, LATIN4, LATIN5
                 ISO-8859-* LATIN2, BELGIAN, GERMAN, CANADIAN,
                 LATIN3,   CP437,                    MAC,
		 ITAL,    UNICODE */
  { "AT",  {'A','A'},1, NULL,
      {          0x40,     0x40,   0x40,    0x40,    0x40 | FC_uncertain,
		 0x40,     0x40,   0x40,    0x40,    0x40,
                 0x40,     0x40,     -1,      -1,      -1,
	         0x40,     0x40,     -1,      -1,    0x40,
	           -1,   0x0040,   0x40,      -1,    0x40,
		 0x40,     0x40,     -1,      -1,      -1,
                 0x40,       -1,     -1,      -1,      -1,
                   -1,       -1,   0x40,    0x40 },
      { "At", "COMMERCIAL AT" } }, /* NAT 3 */
  { "A",  {0,0}, 1, NULL,
      {          0x41,     0x41,   0x41,    0x41,    0x41,
		 0x41,     0x41,   0x41,    0x41,    0x41,
                 0x41,     0x41,   0x41,    0x41,    0x41,
                 0x41,     0x41,     -1,    0x41,    0x41,
	         0x41,   0x0041,   0x41,        0x41,        0x41,
		 0x41,        0x41,      0x41,      0x41,     0x41,
                     0x41,       0x41,      0x41,      0x41,      0x41,
                     0x41,      0x41,      0x41,      0x41 },
      { "A", "LATIN CAPITAL LETTER A" } },
  { "B",  {0,0}, 1, NULL,
      {          0x42,     0x42,   0x42,    0x42,    0x42,
		 0x42,     0x42,   0x42,    0x42,    0x42,
                 0x42,     0x42,   0x42,    0x42,    0x42,
                 0x42,     0x42,     -1,    0x42,    0x42,
	         0x42,   0x0042,   0x42,        0x42,        0x42,
		 0x42,        0x42,      0x42,      0x42,     0x42,
                     0x42,       0x42,      0x42,      0x42,      0x42,
                     0x42,      0x42,      0x42,      0x42 },
      { "B", "LATIN CAPITAL LETTER B" } },
  { "C",  {0,0}, 1, NULL,
      {          0x43,     0x43,   0x43,    0x43,    0x43,
		 0x43,     0x43,   0x43,    0x43,    0x43,
                 0x43,     0x43,   0x43,    0x43,    0x43,
                 0x43,     0x43,     -1,    0x43,    0x43,
	         0x43,   0x0043,   0x43,        0x43,        0x43,
		 0x43,        0x43,      0x43,      0x43,     0x43,
                     0x43,       0x43,      0x43,      0x43,      0x43,
                     0x43,      0x43,      0x43,      0x43 },
      { "C", "LATIN CAPITAL LETTER C" } },
  { "D",  {0,0}, 1, NULL,
      {          0x44,     0x44,   0x44,    0x44,    0x44,
		 0x44,     0x44,   0x44,    0x44,    0x44,
                 0x44,     0x44,   0x44,    0x44,    0x44,
                 0x44,     0x44,     -1,    0x44,    0x44,
	         0x44,   0x0044,   0x44,        0x44,        0x44,
		 0x44,        0x44,      0x44,      0x44,     0x44,
                     0x44,       0x44,      0x44,      0x44,      0x44,
                     0x44,      0x44,      0x44,      0x44 },
      { "D", "LATIN CAPITAL LETTER D" } },
  { "E",  {0,0}, 1, NULL,
      {          0x45,     0x45,   0x45,    0x45,    0x45,
		 0x45,     0x45,   0x45,    0x45,    0x45,
                 0x45,     0x45,   0x45,    0x45,    0x45,
                 0x45,     0x45,     -1,    0x45,    0x45,
	         0x45,   0x0045,   0x45,        0x45,        0x45,
		 0x45,        0x45,      0x45,      0x45,     0x45,
                     0x45,       0x45,      0x45,      0x45,      0x45,
                     0x45,      0x45,      0x45,      0x45 },
      { "E", "LATIN CAPITAL LETTER E" } },
  { "F",  {0,0}, 1, NULL,
      {          0x46,     0x46,   0x46,    0x46,    0x46,
		 0x46,     0x46,   0x46,    0x46,    0x46,
                 0x46,     0x46,   0x46,    0x46,    0x46,
                 0x46,     0x46,     -1,    0x46,    0x46,
	         0x46,   0x0046,   0x46,        0x46,        0x46,
		 0x46,        0x46,      0x46,      0x46,     0x46,
                     0x46,       0x46,      0x46,      0x46,      0x46,
                     0x46,      0x46,      0x46,      0x46 },
      { "F", "LATIN CAPITAL LETTER F" } },
  { "G",  {0,0}, 1, NULL,
      {          0x47,     0x47,   0x47,    0x47,    0x47,
		 0x47,     0x47,   0x47,    0x47,    0x47,
                 0x47,     0x47,   0x47,    0x47,    0x47,
                 0x47,     0x47,     -1,    0x47,    0x47,
	         0x47,   0x0047,   0x47,        0x47,        0x47,
		 0x47,        0x47,      0x47,      0x47,     0x47,
                     0x47,       0x47,      0x47,      0x47,      0x47,
                     0x47,      0x47,      0x47,      0x47 },
      { "G", "LATIN CAPITAL LETTER G" } },
  { "H",  {0,0}, 1, NULL,
      {          0x48,     0x48,   0x48,    0x48,    0x48,
		 0x48,     0x48,   0x48,    0x48,    0x48,
                 0x48,     0x48,   0x48,    0x48,    0x48,
                 0x48,     0x48,     -1,    0x48,   0x48,
	         0x48,   0x0048,   0x48,        0x48,        0x48,
		 0x48,        0x48,      0x48,      0x48,     0x48,
                     0x48,       0x48,      0x48,      0x48,      0x48,
                     0x48,      0x48,      0x48,      0x48 },
      { "H", "LATIN CAPITAL LETTER H" } },
  { "I",  {0,0}, 1, NULL,
      {          0x49,     0x49,   0x49,    0x49,    0x49,
		 0x49,     0x49,   0x49,    0x49,    0x49,
                 0x49,     0x49,   0x49,    0x49,    0x49,
                 0x49,     0x49,     -1,    0x49,   0x49,
	         0x49,   0x0049,   0x49,        0x49,        0x49,
		 0x49,        0x49,      0x49,      0x49,     0x49,
                     0x49,       0x49,      0x49,      0x49,      0x49,
                     0x49,      0x49,      0x49,      0x49 },
      { "I", "LATIN CAPITAL LETTER I" } },
  { "J",  {0,0}, 1, NULL,
      {          0x4A,     0x4A,   0x4A,    0x4A,    0x4A,
		 0x4A,     0x4A,   0x4A,    0x4A,    0x4A,
                 0x4A,     0x4A,   0x4A,    0x4A,    0x4A,
                 0x4A,     0x4A,     -1,    0x4A,    0x4A,
	         0x4A,   0x004a,   0x4A,        0x4A,        0x4A,
		 0x4A,        0x4A,      0x4A,      0x4A,     0x4A,
                     0x4A,       0x4A,      0x4A,      0x4A,      0x4A,
                     0x4A,      0x4A,      0x4A,      0x4A },
      { "J", "LATIN CAPITAL LETTER J" } },
  { "K",  {0,0}, 1, NULL,
      {          0x4B,     0x4B,   0x4B,    0x4B,    0x4B,
		 0x4B,     0x4B,   0x4B,    0x4B,    0x4B,
                 0x4B,     0x4B,   0x4B,    0x4B,    0x4B,
                 0x4B,     0x4B,     -1,    0x4B,   0x4B,
	         0x4B,   0x004b,   0x4B,        0x4B,        0x4B,
		 0x4B,        0x4B,      0x4B,      0x4B,     0x4B,
                     0x4B,       0x4B,      0x4B,      0x4B,      0x4B,
                     0x4B,      0x4B,      0x4B,      0x4B },
      { "K", "LATIN CAPITAL LETTER K" } },
  { "L",  {0,0}, 1, NULL,
      {          0x4C,     0x4C,   0x4C,    0x4C,    0x4C,
		 0x4C,     0x4C,   0x4C,    0x4C,    0x4C,
                 0x4C,     0x4C,   0x4C,    0x4C,    0x4C,
                 0x4C,     0x4C,     -1,    0x4C,    0x4C,
	         0x4C,   0x004c,   0x4C,        0x4C,        0x4C,
		 0x4C,        0x4C,      0x4C,      0x4C,     0x4C,
                     0x4C,       0x4C,      0x4C,      0x4C,      0x4C,
                     0x4C,      0x4C,      0x4C,      0x4C },
      { "L", "LATIN CAPITAL LETTER L" } },
  { "M",  {0,0}, 1, NULL,
      {          0x4D,     0x4D,   0x4D,    0x4D,    0x4D,
		 0x4D,     0x4D,   0x4D,    0x4D,    0x4D,
                 0x4D,     0x4D,   0x4D,    0x4D,    0x4D,
                 0x4D,     0x4D,     -1,    0x4D,    0x4D,
	         0x4D,   0x004d,   0x4D,        0x4D,        0x4D,
		 0x4D,        0x4D,      0x4D,      0x4D,     0x4D,
                     0x4D,       0x4D,      0x4D,      0x4D,      0x4D,
                     0x4D,      0x4D,      0x4D,      0x4D }, 
      { "M", "LATIN CAPITAL LETTER M" } },
  { "N",  {0,0}, 1, NULL,
      {          0x4E,     0x4E,   0x4E,    0x4E,    0x4E,
		 0x4E,     0x4E,   0x4E,    0x4E,    0x4E,
                 0x4E,     0x4E,   0x4E,    0x4E,    0x4E,
                 0x4E,     0x4E,     -1,    0x4E,    0x4E,
	         0x4E,   0x004e,   0x4E,        0x4E,        0x4E,
		 0x4E,        0x4E,      0x4E,      0x4E,     0x4E,
                     0x4E,       0x4E,      0x4E,      0x4E,      0x4E,
                     0x4E,      0x4E,      0x4E,      0x4E },
      { "N", "LATIN CAPITAL LETTER N" } },
  { "O",  {0,0}, 1, NULL,
      {          0x4F,     0x4F,   0x4F,    0x4F,    0x4F,
		 0x4F,     0x4F,   0x4F,    0x4F,    0x4F,
                 0x4F,     0x4F,   0x4F,    0x4F,    0x4F,
                 0x4F,     0x4F,     -1,    0x4F,   0x4F,
		 0x4F,   0x004f,   0x4F,        0x4F,        0x4F,
		 0x4F,        0x4F,      0x4F,      0x4F,     0x4F,
                     0x4F,       0x4F,      0x4F,      0x4F,      0x4F,
                     0x4F,      0x4F,      0x4F,      0x4F },
      { "O", "LATIN CAPITAL LETTER O" } },
  { "P",  {0,0}, 1, NULL,
      {          0x50,     0x50,   0x50,    0x50,    0x50,
		 0x50,     0x50,   0x50,    0x50,    0x50,
		 0x50,     0x50,   0x50,    0x50,    0x50,
		 0x50,     0x50,     -1,    0x50,   0x50,
		 0x50,   0x0050,   0x50,        0x50,        0x50,
		 0x50,        0x50,      0x50,      0x50,     0x50,
                     0x50,       0x50,      0x50,      0x50,      0x50,
                     0x50,      0x50,      0x50,      0x50 },
      { "P", "LATIN CAPITAL LETTER P" } },
  { "Q",  {0,0}, 1, NULL,
      {          0x51,     0x51,   0x51,    0x51,    0x51,
		 0x51,     0x51,   0x51,    0x51,    0x51,
                 0x51,     0x51,   0x51,    0x51,    0x51,
                 0x51,     0x51,     -1,    0x51,   0x51,
	         0x51,   0x0051,   0x51,        0x51,        0x51,
		 0x51,        0x51,      0x51,      0x51,     0x51,
                     0x51,       0x51,      0x51,      0x51,      0x51,
                     0x51,      0x51,      0x51,      0x51 },
      { "Q", "LATIN CAPITAL LETTER Q" } },
  { "R",  {0,0}, 1, NULL,
      {          0x52,     0x52,   0x52,    0x52,    0x52,
		 0x52,     0x52,   0x52,    0x52,    0x52,
                 0x52,     0x52,   0x52,    0x52,    0x52,
                 0x52,     0x52,     -1,    0x52,   0x52,
	         0x52,   0x0052,   0x52,        0x52,        0x52,
		 0x52,        0x52,      0x52,      0x52,     0x52,
                     0x52,       0x52,      0x52,      0x52,      0x52,
                     0x52,      0x52,      0x52,      0x52 },
    { "R", "LATIN CAPITAL LETTER R" } },
  { "S",  {0,0}, 1, NULL,
      {          0x53,     0x53,   0x53,    0x53,    0x53,
		 0x53,     0x53,   0x53,    0x53,    0x53,
                 0x53,     0x53,   0x53,    0x53,    0x53,
                 0x53,     0x53,     -1,    0x53,   0x53,
		 0x53,   0x0053,   0x53,        0x53,        0x53,
		 0x53,        0x53,      0x53,      0x53,     0x53,
                     0x53,       0x53,      0x53,      0x53,      0x53,
                     0x53,      0x53,      0x53,      0x53 },
      { "S", "LATIN CAPITAL LETTER S" } },
  { "T",  {0,0}, 1, NULL,
      {          0x54,     0x54,   0x54,    0x54,    0x54,
		 0x54,     0x54,   0x54,    0x54,    0x54,
                 0x54,     0x54,   0x54,    0x54,    0x54,
                 0x54,     0x54,     -1,    0x54,   0x54,
		 0x54,   0x0054,   0x54,        0x54,        0x54,
		 0x54,        0x54,      0x54,      0x54,     0x54,
                     0x54,       0x54,      0x54,      0x54,      0x54,
                     0x54,      0x54,      0x54,      0x54 },
      { "T", "LATIN CAPITAL LETTER T" } },
  { "U",  {0,0}, 1, NULL,
      {          0x55,     0x55,   0x55,    0x55,    0x55,
		 0x55,     0x55,   0x55,    0x55,    0x55,
                 0x55,     0x55,   0x55,    0x55,    0x55,
                 0x55,     0x55,     -1,    0x55,   0x55,
	         0x55,   0x0055,   0x55,        0x55,        0x55,
		 0x55,        0x55,      0x55,      0x55,     0x55,
                     0x55,       0x55,      0x55,      0x55,      0x55,
                     0x55,      0x55,      0x55,      0x55 },
      { "U", "LATIN CAPITAL LETTER U" } },
  { "V",  {0,0}, 1, NULL,
      {          0x56,     0x56,   0x56,    0x56,    0x56,
		 0x56,     0x56,   0x56,    0x56,    0x56,
                 0x56,     0x56,   0x56,    0x56,    0x56,
                 0x56,     0x56,     -1,    0x56,   0x56,
		 0x56,   0x0056,   0x56,        0x56,        0x56,
		 0x56,        0x56,      0x56,      0x56,     0x56,
                     0x56,       0x56,      0x56,      0x56,      0x56,
                     0x56,      0x56,      0x56,      0x56 },
      { "V", "LATIN CAPITAL LETTER V" } },
  { "W",  {0,0}, 1, NULL,
      {          0x57,     0x57,   0x57,    0x57,    0x57,
		 0x57,     0x57,   0x57,    0x57,    0x57,
                 0x57,     0x57,   0x57,    0x57,    0x57,
                 0x57,     0x57,     -1,    0x57,   0x57,
	         0x57,   0x0057,   0x57,        0x57,        0x57,
		 0x57,        0x57,      0x57,      0x57,     0x57,
                     0x57,       0x57,      0x57,      0x57,      0x57,
                     0x57,      0x57,      0x57,      0x57 },
      { "W", "LATIN CAPITAL LETTER W" } },
  { "X",  {0,0}, 1, NULL,
      {          0x58,     0x58,   0x58,    0x58,    0x58,
		 0x58,     0x58,   0x58,    0x58,    0x58,
                 0x58,     0x58,   0x58,    0x58,    0x58,
                 0x58,     0x58,     -1,    0x58,   0x58,
	         0x58,   0x0058,   0x58,        0x58,        0x58,
		 0x58,        0x58,      0x58,      0x58,     0x58,
                     0x58,       0x58,      0x58,      0x58,      0x58,
                     0x58,      0x58,      0x58,      0x58 },
      { "X", "LATIN CAPITAL LETTER X" } },
  { "Y",  {0,0}, 1, NULL,
      {          0x59,     0x59,   0x59,    0x59,    0x59,
		 0x59,     0x59,   0x59,    0x59,    0x59,
                 0x59,     0x59,   0x59,    0x59,    0x59,
                 0x59,     0x59,     -1,    0x59,   0x59,
	         0x59,   0x0059,   0x59,        0x59,        0x59,
		 0x59,        0x59,      0x59,      0x59,     0x59,
                     0x59,       0x59,      0x59,      0x59,      0x59,
                     0x59,      0x59,      0x59,      0x59 },
      { "Y", "LATIN CAPITAL LETTER Y" } },
  { "Z",  {0,0}, 1, NULL,
      {          0x5A,     0x5A,   0x5A,    0x5A,    0x5A,
		 0x5A,     0x5A,   0x5A,    0x5A,    0x5A,
                 0x5A,     0x5A,   0x5A,    0x5A,    0x5A,
                 0x5A,     0x5A,     -1,    0x5A,    0x5A,
	         0x5A,   0x005a,   0x5A,    0x5A,    0x5A,
		 0x5A,     0x5A,   0x5A,    0x5A,    0x5A,
                 0x5A,     0x5A,   0x5A,    0x5A,    0x5A,
                 0x5A,     0x5A,   0x5A,    0x5A },
      { "Z", "LATIN CAPITAL LETTER Z" } },

  /*          ASCII,   LATIN1,   MULT, SPECIAL, FINNISH 
                 UK,    NORW,   SWEDISH,   LATIN4,   LATIN5,
              ISO-8859-*, LATIN2, BELGIAN, GERMAN, French Canadian,
                         CP437, TECHNICAL,          MAC,
		ITAL, RFC1345 */   
  /* LEFT SQUARE BRACKET
     OPENING SQUARE BRACKET */
  { "[",  {'(','('},1, NULL,
      {          0x5B,     0x5B,   0x5B,    0x5B,      -1,
		 0x5B,       -1,     -1,    0x5B,    0x5B,
                 0x5B,     0x5B,     -1,      -1,      -1,
                 0x5B,     0x5B,     -1,      -1,    0x5B,
	           -1,   0x005b,     -1,      -1,      -1,
		   -1,     0x5B,     -1,      -1,      -1,
                 0x5B,       -1,     -1,      -1,      -1,
                   -1,       -1,   0x7D,    0x5B },
      { "<(", "LEFT SQUARE BRACKET" } },   /* NAT 4 */
  /* REVERSE SOLIDUS
     BACKSLASH */
  { "\\",  {'/','/'},1, NULL,
      {          0x5C,     0x5C,   0x5C,    0x5C,      -1,
		 0x5C,       -1,     -1,    0x5C,    0x5C,
                 0x5C,     0x5C,     -1,      -1,      -1,
                 0x5C,     0x5C,     -1,      -1,    0x5C,
	           -1,   0x005c,     -1,      -1,      -1,
		   -1,     0x5C,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1 },
      { "//", "REVERSE SOLIDUS" } },   /* NAT 5 */
  /* RIGHT SQUARE BRACKET
     CLOSING SQUARE BRACKET */
  { "]",  {')',')'},1, NULL,
      {          0x5D,     0x5D,   0x5D,    0x5D,      -1,
		 0x5D,       -1,     -1,    0x5D,    0x5D,
                 0x5D,     0x5D,     -1,      -1,      -1,
                 0x5D,     0x5D,     -1,      -1,    0x5D,
	           -1,   0x005d,     -1,      -1,      -1,
		   -1,     0x5D,     -1,      -1,      -1,
                 0x5D,       -1,     -1,      -1,      -1,
                   -1,       -1,   0x5D,    0x5D },
      { ")>", "RIGHT SQUARE BRACKET" } },   /* NAT 6 */
  /* CIRCUMFLEX ACCENT
     SPACING CIRCUMFLEX */
  { "^",  {'*','*'},1, NULL,
      {          0x5E,     0x5E,   0x5E,    0x5E,      -1,
		 0x5E,     0x5E,   0x5E,    0x5E,    0x5E,
                 0x5E,     0x5E,   0x5E,    0x5E,      -1,
                 0x5E,     0x5E,     -1,    0x5E,    0x5E,
	         0x5E,   0x005e,   0x5E,      -1,    0x5E,
		 0x5E,     0x5E,     -1,    0x5E,      -1,
                 0x5E,     0x5E,   0x5E,    0x5E,      -1,
                 0x5E,       -1,     -1,    0x5E },
      /* UNICODE Decomposition: [0020] & [0302]  */
      { "'>", "CIRCUMFLEX ACCENT" } },   /* NAT 7 */
  /* LOW LINE
     SPACING UNDERSCORE */
  { "_",  {' ','-'}, 1, &CH_UL,
      {          0x5F,     0x5F,   0x5F,      -1,    0x5F,
		 0x5F,     0x5F,   0x5F,    0x5F,    0x5F,
                 0x5F,     0x5F,   0x5F,    0x5F,    0x5F,
                 0x5F,     0x5F,     -1,    0x5F,    0x5F,
	         0x5F,   0x005f,   0x5F,    0x5F,    0x5F,
		 0x5F,     0x5F,   0x5F,    0x5F,      -1,
                 0x5F,     0x5F,   0x5F,    0x5F,    0x5F,
                 0x5F,     0x5F,   0x5F,    0x5F },
      /* UNICODE Decompositation: [0020] & [0332] */
      { "_", "LOW LINE" } },   /* NAT 8 */
  /* GRAVE ACCENT
     SPACING GRAVE */
  { "`",  {'\'','\''}, 1, NULL,
      {          0x60,     0x60,   0x60,      -1,      -1,
		 0x60,     0x60,   0x60,    0x60,    0x60,
                 0x60,     0x60,   0x60,    0x60,      -1,
                 0x60,     0x60,     -1,    0x60,    0x60,
	           -1,   0x0060,   0x60,      -1,    0x60,
		 0x60,     0x60,     -1,      -1,      -1,
                 0x60,     0x60,   0x60,    0x60,    0x60,
                   -1,       -1,   0x60,    0x60 },
      /* UNICODE Decompositation: [0020] & [0300] */   
      { "'!", "GRAVE ACCENT" } },   /* NAT 9 */

  { "a",  {0,0}, 1, NULL,
      {          0x61,     0x61,   0x61,      -1,    0x61,
		 0x61,     0x61,   0x61,    0x61,    0x61,
                 0x61,     0x61,   0x61,    0x61,    0x61,
                 0x61,     0x61,     -1,    0x61,    0x61,
	         0x61,   0x0061,   0x61,        0x61,        0x61,
		 0x61,        0x61,      0x61,      0x61,     0x61,
                     0x61,       0x61,      0x61,      0x61,      0x61,
                     0x61,      0x61,      0x61,      0x61 },
      { "a", "LATIN SMALL LETTER A" } },
  { "b",  {0,0}, 1, NULL,
      {          0x62,     0x62,   0x62,      -1,    0x62,
		 0x62,     0x62,   0x62,    0x62,    0x62,
                 0x62,     0x62,   0x62,    0x62,    0x62,
                 0x62,     0x62,     -1,    0x62,    0x62,
		 0x62,   0x0062,   0x62,        0x62,        0x62,
		 0x62,        0x62,      0x62,      0x62,     0x62,
                     0x62,       0x62,      0x62,      0x62,      0x62,
                     0x62,      0x62,      0x62,      0x62 },
      { "b", "LATIN SMALL LETTER B" } },
  { "c",  {0,0}, 1, NULL,
      {          0x63,     0x63,   0x63,      -1,    0x63,
		 0x63,     0x63,   0x63,    0x63,    0x63,
                 0x63,     0x63,   0x63,    0x63,    0x63,
                 0x63,     0x63,     -1,    0x63,    0x63,
	         0x63,   0x0063,   0x63,        0x63,        0x63,
		 0x63,        0x63,      0x63,      0x63,     0x63,
                     0x63,       0x63,      0x63,      0x63,      0x63,
                     0x63,      0x63,      0x63,      0x63 },
      { "c", "LATIN SMALL LETTER C" } },
  { "d",  {0,0}, 1, NULL,
      {          0x64,     0x64,   0x64,      -1,    0x64,
		 0x64,     0x64,   0x64,    0x64,    0x64,
                 0x64,     0x64,   0x64,    0x64,    0x64,
                 0x64,     0x64,     -1,    0x64,    0x64,
	         0x64,   0x0064,   0x64,        0x64,        0x64,
		 0x64,        0x64,      0x64,      0x64,     0x64,
                     0x64,       0x64,      0x64,      0x64,      0x64,
                     0x64,      0x64,      0x64,      0x64 },
      { "d", "LATIN SMALL LETTER D" } },
  { "e",  {0,0}, 1, NULL,
      {          0x65,     0x65,   0x65,      -1,    0x65,
		 0x65,     0x65,   0x65,    0x65,    0x65,
                 0x65,     0x65,   0x65,    0x65,    0x65,
                 0x65,     0x65,     -1,    0x65,    0x65,
	         0x65,   0x0065,   0x65,        0x65,        0x65,
		 0x65,        0x65,      0x65,      0x65,     0x65,
                     0x65,       0x65,      0x65,      0x65,      0x65,
                     0x65,      0x65,      0x65,      0x65 },
      { "e", "LATIN SMALL LETTER E" } },
  { "f",  {0,0}, 1, NULL,
      {          0x66,     0x66,   0x66,      -1,    0x66,
		 0x66,     0x66,   0x66,    0x66,    0x66,
                 0x66,     0x66,   0x66,    0x66,    0x66,
                 0x66,     0x66,     -1,    0x66,    0x66,
	         0x66,   0x0066,   0x66,        0x66,        0x66,
		 0x66,        0x66,      0x66,      0x66,     0x66,
                     0x66,       0x66,      0x66,      0x66,      0x66,
                     0x66,      0x66,      0x66,      0x66 },
      { "f", "LATIN SMALL LETTER F" } },
  { "g",  {0,0}, 1, NULL,
      {          0x67,     0x67,   0x67,      -1,    0x67,
		 0x67,     0x67,   0x67,    0x67,    0x67,
                 0x67,     0x67,   0x67,    0x67,    0x67,
                 0x67,     0x67,     -1,    0x67,   0x67,
	         0x67,   0x0067,   0x67,        0x67,        0x67,
		 0x67,        0x67,      0x67,      0x67,     0x67,
                     0x67,       0x67,      0x67,      0x67,      0x67,
                     0x67,      0x67,      0x67,      0x67 },
      { "g", "LATIN SMALL LETTER G" } },
  { "h",  {0,0}, 1, NULL,
      {          0x68,     0x68,   0x68,      -1,    0x68,
		 0x68,     0x68,   0x68,    0x68,    0x68,
                 0x68,     0x68,   0x68,    0x68,    0x68,
		 0x68,     0x68,     -1,    0x68,   0x68,
	         0x68,   0x0068,   0x68,        0x68,        0x68,
		 0x68,        0x68,      0x68,      0x68,     0x68,
                     0x68,       0x68,      0x68,      0x68,      0x68,
                     0x68,      0x68,      0x68,      0x68 },
      { "h", "LATIN SMALL LETTER H" } },
  { "i",  {0,0}, 1, NULL,
      {          0x69,     0x69,   0x69,      -1,    0x69,
		 0x69,     0x69,   0x69,    0x69,    0x69,
                 0x69,     0x69,   0x69,    0x69,    0x69,
                 0x69,     0x69,     -1,    0x69,   0x69,
	         0x69,   0x0069,   0x69,        0x69,        0x69,
		 0x69,        0x69,      0x69,      0x69,     0x69,
                     0x69,       0x69,      0x69,      0x69,      0x69,
                     0x69,      0x69,      0x69,      0x69 },
      { "i", "LATIN SMALL LETTER I" } },
  { "j",  {0,0}, 1, NULL,
      {          0x6A,     0x6A,   0x6A,      -1,    0x6A,
		 0x6A,     0x6A,   0x6A,    0x6A,    0x6A,
                 0x6A,     0x6A,   0x6A,    0x6A,    0x6A,
                 0x6A,     0x6A,     -1,    0x6A,   0x6A,
		 0x6A,   0x006a,   0x6A,        0x6A,        0x6A,
		 0x6A,        0x6A,      0x6A,      0x6A,     0x6A,
                     0x6A,       0x6A,      0x6A,      0x6A,      0x6A,
                     0x6A,      0x6A,      0x6A,      0x6A },
      { "j", "LATIN SMALL LETTER J" } },
  { "k",  {0,0}, 1, NULL,
      {          0x6B,     0x6B,   0x6B,      -1,    0x6B,
		 0x6B,     0x6B,   0x6B,    0x6B,    0x6B,
                 0x6B,     0x6B,   0x6B,    0x6B,    0x6B,
                 0x6B,     0x6B,     -1,    0x6B,   0x6B,
		 0x6B,   0x006b,   0x6B,        0x6B,        0x6B,
		 0x6B,        0x6B,      0x6B,      0x6B,     0x6B,
                     0x6B,       0x6B,      0x6B,      0x6B,      0x6B,
                     0x6B,      0x6B,      0x6B,      0x6B },
      { "k", "LATIN SMALL LETTER K" } },
  { "l",  {0,0}, 1, NULL,
      {          0x6C,     0x6C,   0x6C,      -1,    0x6C,
		 0x6C,     0x6C,   0x6C,    0x6C,    0x6C,
                 0x6C,     0x6C,   0x6C,    0x6C,    0x6C,
                 0x6C,     0x6C,     -1,    0x6C,   0x6C,
	         0x6C,   0x006c,   0x6C,        0x6C,        0x6C,
		 0x6C,        0x6C,      0x6C,      0x6C,     0x6C,
                     0x6C,       0x6C,      0x6C,      0x6C,      0x6C,
                     0x6C,      0x6C,      0x6C,      0x6C },
      { "l", "LATIN SMALL LETTER L" } },
  { "m",  {0,0}, 1, NULL,
      {          0x6D,     0x6D,   0x6D,      -1,    0x6D,
		 0x6D,     0x6D,   0x6D,    0x6D,    0x6D,
                 0x6D,     0x6D,   0x6D,    0x6D,    0x6D,
                 0x6D,     0x6D,     -1,    0x6D,   0x6D,
		 0x6D,   0x006d,   0x6D,        0x6D,        0x6D,
		 0x6D,        0x6D,      0x6D,      0x6D,     0x6D,
                     0x6D,       0x6D,      0x6D,      0x6D,      0x6D,
                     0x6D,      0x6D,      0x6D,      0x6D },
      { "m", "LATIN SMALL LETTER M" } },
  { "n",  {0,0}, 1, NULL,
      {          0x6E,     0x6E,   0x6E,      -1,    0x6E,
		 0x6E,     0x6E,   0x6E,    0x6E,    0x6E,
                 0x6E,     0x6E,   0x6E,    0x6E,    0x6E,
                 0x6E,     0x6E,     -1,    0x6E,   0x6E,
	         0x6E,   0x006e,   0x6E,        0x6E,        0x6E,
		 0x6E,        0x6E,      0x6E,      0x6E,     0x6E,
                     0x6E,       0x6E,      0x6E,      0x6E,      0x6E,
                     0x6E,      0x6E,      0x6E,      0x6E },
      { "n", "LATIN SMALL LETTER N" } },
  { "o",  {0,0}, 1, NULL,
      {          0x6F,     0x6F,   0x6F,      -1,    0x6F,
		 0x6F,     0x6F,   0x6F,    0x6F,    0x6F,
                 0x6F,     0x6F,   0x6F,    0x6F,    0x6F,
                 0x6F,     0x6F,     -1,    0x6F,   0x6F,
	         0x6F,   0x006f,   0x6F,        0x6F,        0x6F,
		 0x6F,        0x6F,      0x6F,      0x6F,     0x6F,
                     0x6F,       0x6F,      0x6F,      0x6F,      0x6F,
                     0x6F,      0x6F,      0x6F,      0x6F },
      { "o", "LATIN SMALL LETTER O" } },
  { "p",  {0,0}, 1, NULL,
      {          0x70,     0x70,   0x70,      -1,    0x70,
		 0x70,     0x70,   0x70,    0x70,    0x70,
                 0x70,     0x70,   0x70,    0x70,    0x70,
                 0x70,     0x70,     -1,    0x70,   0x70,
	         0x70,   0x0070,   0x70,        0x70,        0x70,
		 0x70,        0x70,      0x70,      0x70,     0x70,
                     0x70,       0x70,      0x70,      0x70,      0x70,
                     0x70,      0x70,      0x70,      0x70 },
      { "p", "LATIN SMALL LETTER P" } },
  { "q",  {0,0}, 1, NULL,
      {          0x71,     0x71,   0x71,      -1,    0x71,
		 0x71,     0x71,   0x71,    0x71,    0x71,
                 0x71,     0x71,   0x71,    0x71,    0x71,
                 0x71,     0x71,     -1,    0x71,   0x71,
	         0x71,   0x0071,   0x71,        0x71,        0x71,
		 0x71,        0x71,      0x71,      0x71,     0x71,
                     0x71,       0x71,      0x71,      0x71,      0x71,
                     0x71,      0x71,      0x71,      0x71 },
     { "q", "LATIN SMALL LETTER Q" } },
  { "r",  {0,0}, 1, NULL,
      {          0x72,     0x72,   0x72,      -1,    0x72,
		 0x72,     0x72,   0x72,    0x72,    0x72,
                 0x72,     0x72,   0x72,    0x72,    0x72,
                 0x72,     0x72,     -1,    0x72,   0x72,
	         0x72,   0x0072,   0x72,        0x72,        0x72,
		 0x72,        0x72,      0x72,      0x72,     0x72,
                     0x72,       0x72,      0x72,      0x72,      0x72,
                     0x72,      0x72,      0x72,      0x72 },
      { "r", "LATIN SMALL LETTER R" } },
  { "s",  {0,0}, 1, NULL,
      {          0x73,     0x73,   0x73,      -1,    0x73,
		 0x73,     0x73,   0x73,    0x73,    0x73,
                 0x73,     0x73,   0x73,    0x73,    0x73,
                 0x73,     0x73,     -1,    0x73,   0x73,
	         0x73,   0x0073,   0x73,        0x73,        0x73,
		 0x73,        0x73,      0x73,      0x73,     0x73,
                     0x73,       0x73,      0x73,      0x73,      0x73,
                     0x73,      0x73,      0x73,      0x73 },
      { "s", "LATIN SMALL LETTER S" } },
  { "t",  {0,0}, 1, NULL,
      {          0x74,     0x74,   0x74,      -1,    0x74,
		 0x74,     0x74,   0x74,    0x74,    0x74,
                 0x74,     0x74,   0x74,    0x74,    0x74,
                 0x74,     0x74,     -1,    0x74,   0x74,
	         0x74,   0x0074,   0x74,        0x74,        0x74,
		 0x74,        0x74,      0x74,      0x74,     0x74,
                     0x74,       0x74,      0x74,      0x74,      0x74,
                     0x74,      0x74,      0x74,      0x74 },
      { "t", "LATIN SMALL LETTER T" } },
  { "u",  {0,0}, 1, NULL,
      {          0x75,     0x75,   0x75,      -1,    0x75,
		 0x75,     0x75,   0x75,    0x75,    0x75,
                 0x75,     0x75,   0x75,    0x75,    0x75,
                 0x75,     0x75,     -1,    0x75,   0x75,
	         0x75,   0x0075,   0x75,        0x75,        0x75,
		 0x75,        0x75,      0x75,      0x75,     0x75,
                     0x75,       0x75,      0x75,      0x75,      0x75,
                     0x75,      0x75,      0x75,      0x75 },
      { "u", "LATIN SMALL LETTER U" } },
  { "v",  {0,0}, 1, NULL,
      {          0x76,     0x76,   0x76,      -1,    0x76,
		 0x76,     0x76,   0x76,    0x76,    0x76,
                 0x76,     0x76,   0x76,    0x76,    0x76,
                 0x76,     0x76,     -1,    0x76,   0x76,
	         0x76,   0x0076,   0x76,        0x76,        0x76,
		 0x76,        0x76,      0x76,      0x76,     0x76,
                     0x76,       0x76,      0x76,      0x76,      0x76,
                     0x76,      0x76,      0x76,      0x76 },
      { "v", "LATIN SMALL LETTER V" } },
  { "w",  {0,0}, 1, NULL,
      {          0x77,     0x77,   0x77,      -1,    0x77,
		 0x77,     0x77,   0x77,    0x77,    0x77,
                 0x77,     0x77,   0x77,    0x77,    0x77,
                 0x77,     0x77,     -1,    0x77,   0x77,
	         0x77,   0x0077,   0x77,        0x77,        0x77,
		 0x77,        0x77,      0x77,      0x77,     0x77,
                     0x77,       0x77,      0x77,      0x77,      0x77,
                     0x77,      0x77,      0x77,      0x77 },
      { "w", "LATIN SMALL LETTER W" } },
  { "x",  {0,0}, 1, NULL,
      {          0x78,     0x78,   0x78,      -1,    0x78,
		 0x78,     0x78,   0x78,    0x78,    0x78,
                 0x78,     0x78,   0x78,    0x78,    0x78,
                 0x78,     0x78,     -1,    0x78,   0x78,
		 0x78,   0x0078,   0x78,        0x78,        0x78,
		 0x78,        0x78,      0x78,      0x78,     0x78,
                     0x78,       0x78,      0x78,      0x78,      0x78,
                     0x78,      0x78,      0x78,      0x78 },
      { "x", "LATIN SMALL LETTER X" } },
  { "y",  {0,0}, 1, NULL,
      {          0x79,     0x79,   0x79,      -1,    0x79,
		 0x79,     0x79,   0x79,    0x79,    0x79,
                 0x79,     0x79,   0x79,    0x79,    0x79,
                 0x79,     0x79,     -1,    0x79,   0x79,
	         0x79,   0x0079,   0x79,        0x79,        0x79,
		 0x79,        0x79,      0x79,      0x79,     0x79,
                     0x79,       0x79,      0x79,      0x79,      0x79,
                     0x79,      0x79,      0x79,      0x79 },
      { "y", "LATIN SMALL LETTER Y" } },
  { "z",  {0,0}, 1, NULL,
      {          0x7A,     0x7A,   0x7A,      -1,    0x7A,
		 0x7A,     0x7A,   0x7A,    0x7A,    0x7A,
                 0x7A,     0x7A,   0x7A,    0x7A,    0x7A,
                 0x7A,     0x7A,     -1,    0x7A,   0x7A,
	         0x7A,   0x007a,   0x7A,        0x7A,        0x7A,
		 0x7A,        0x7A,      0x7A,      0x7A,     0x7A,
                     0x7A,       0x7A,      0x7A,      0x7A,      0x7A,
                     0x7A,      0x7A,      0x7A,      0x7A },
      { "z", "LATIN SMALL LETTER Z" } },

  /*          ASCII,   LATIN1,   MULT, SPECIAL, FINNISH,
                 UK,      NORW,   SWEDISH,  LATIN4,   LATIN5,
	      ISO-8859-*,  LATIN2,
               LATIN3,     CP437, TECHNICAL, SPANISH, MAC,
	        ITAL,    Unicode 1.1 */
  /* LEFT CURLY BRACKET
     OPENING CURLY BRACKET */
  { "{",  {'(','-'},1, NULL,
      {          0x7B,     0x7B,   0x7B,      -1,      -1,
		 0x7B,       -1,     -1,    0x7B,    0x7B,
                 0x7B,     0x7B,     -1,      -1,      -1,
		   /* What character is in position 0x7B in spanish charset ?
		    */
                 0x7B,     0x7B,     -1,    0x7B | FC_uncertain,
                                                     0x7B,
	           -1,   0x007b,     -1,      -1,      -1,
		   -1,     0x7B,     -1,      -1,      -1,
                 0x7B,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,    0x7B },
      { "(!", "LEFT CURLY BRACKET" } },  /* NAT 10 */
  /* VERTICAL LINE
     VERTICAL BAR */
  { "|",  {'^','/'}, 1, NULL,
      {          0x7C,     0x7C,   0x7C,      -1,      -1,
		 0x7C,       -1,     -1,    0x7C,    0x7C,
                 0x7C,     0x7C,     -1,      -1,      -1,
                 0x7C,     0x7C,     -1,      -1,    0x7C,
	           -1,   0x007c,     -1,      -1,      -1,
		 0x7E,     0x7C,     -1,      -1,      -1,
                 0x7C,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,    0x7C },
      { "!!", "VERTICAL LINE" } },  /* NAT 11 */
  /* RIGHT CURLY BRACKET
     CLOSING CURLY BRACKET */
  { "}",  {')','-'},1, NULL,
      {          0x7D,     0x7D,   0x7D,      -1,      -1,
		 0x7D,       -1,     -1,    0x7D,    0x7D,
                 0x7D,     0x7D,     -1,      -1,      -1,
                 0x7D,     0x7D,     -1,      -1,    0x7D,
	           -1,   0x007d,     -1,      -1,      -1,
		   -1,     0x7D,     -1,      -1,      -1,
                 0x7D,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,    0x7D },
      { "!)", "RIGHT CURLY BRACKET" } },  /* NAT 12 */
  { "~",  {'^','^'},1, NULL,
      {          0x7E,     0x7E,   0x7E,      -1,      -1,
		 0x7E,     0x7E,   0x7E,    0x7E,    0x7E,
                 0x7E,     0x7E,     -1,    -1,        -1,
                 0x7E,     0x7E,     -1,    -1,      0x7E,
	           -1,   0x007e,     -1,    -1,        -1,
                   -1,     0x7E,     -1,    -1,        -1,
                   -1,       -1,     -1,  0x7E,        -1,
                   -1,       -1,     -1,  0x7E },
      { "'?", "TILDE" } },  /* NAT 13 */

  /* Forms characters */
  /*          ASCII,   LATIN1,   MULT, SPECIAL,  FINNISH,
                 UK,   NORW,     SWEDISH,   LATIN4,    LATIN5,
	       ISO-8859-*, LATIN2,
               LATIN3,     CP437, TECHNICAL, SPANISH, MAC,
	       ITAL,  Unicode 1.1 */
  /* FORMS LIGHT HORIZONTAL / BOX DRAWINGS LIGHT HORIZONTAL */
  { "-",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x71,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      196,     -1,      -1,      -1,
		   -1,   0x2500,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "hh", "BOX DRAWINGS LIGHT HORIZONTAL" } },  
  /* FORMS HEAVY HORIZONTAL / BOX DRAWINGS HEAVY HORIZONTAL */
  { "-",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x71 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      205,     -1,      -1,      -1,
		   -1,   0x2501,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "HH", "BOX DRAWINGS HEAVY HORIZONTAL" } },  
  /* FORMS LIGHT VERTICAL  / BOX DRAWINGS LIGHT VERTICAL */
  { "|",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x78,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      179,     -1,      -1,      -1,
		   -1,   0x2502,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "vv", "BOX DRAWINGS LIGHT VERTICAL" } }, 
  /* FORMS HEAVY VERTICAL  / BOX DRAWINGS HEAVY VERTICAL */
  { "|",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x78 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      186,     -1,      -1,      -1,
		   -1,   0x2503,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "VV", "BOX DRAWINGS HEAVY VERTICAL" } }, 
  /* Missing: x
              BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL,
	         FORMS LIGHT TRIPLE DASH HORIZONTAL, UNICODE 0x2504
		 rfc1345 encoding: 3-
              BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL,
	         FORMS HEAVY TRIPLE DASH HORIZONTAL, UNICODE 0x2505
		 rfc1345 encoding: 3_
              BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL,
	         FORMS LIGHT TRIPLE DASH VERTICAL, UNICODE 0x2506
		 rfc1345 encoding: 3!
              BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL,
	         FORMS HEAVY TRIPLE DASH VERTICAL, UNICODE 0x2507
		 rfc1345 encoding: 3/
              BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL,
	         FORMS LIGHT QUADRUPLE DASH HORIZONTAL, UNICODE 0x2508
		 rfc1345 encoding: 4-
              BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL,
	         FORMS HEAVY QUADRUPLE DASH HORIZONTAL, UNICODE 0x2509
		 rfc1345 encoding: 4_
              BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL,
	         FORMS LIGHT QUADRUPLE DASH VERTICAL, UNICODE 0x250A
		 rfc1345 encoding: 4!
              BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL,
	         FORMS HEAVY QUADRUPLE DASH VERTICAL, UNICODE 0x250B
		 rfc1345 encoding: 4/  */ 
  /* FORMS LIGHT DOWN AND RIGHT / BOX DRAWINGS LIGHT DOWN AND RIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6C,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      218,   -1,        -1,        -1,
		   -1,   0x250c,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "dr", "BOX DRAWINGS LIGHT DOWN AND RIGHT" } },
  /* FORMS DOWN LIGHT AND RIGHT HEAVY 
     BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6C | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      213,   -1,        -1,      -1,
		   -1,   0x250d,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "dR", "BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY" } },
  /* FORMS DOWN HEAVY AND RIGHT LIGHT 
     BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6C | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      214,   -1,        -1,      -1,
		   -1,   0x250e,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Dr", "BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT" } }, 
  /* FORMS HEAVY DOWN AND RIGHT / BOX DRAWINGS HEAVY DOWN AND RIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6C | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      201,   -1,        -1,      -1,
		   -1,   0x250f,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "DR", "BOX DRAWINGS HEAVY DOWN AND RIGHT" } }, 
  /* FORMS LIGHT DOWN AND LEFT / BOX DRAWINGS LIGHT DOWN AND LEFT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6B,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      191,     -1,      -1,      -1,
		   -1,   0x2510,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "dl", "BOX DRAWINGS LIGHT DOWN AND LEFT" } }, 
  /* FORMS DOWN LIGHT AND LEFT HEAVY 
     BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6B | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      184,     -1,      -1,      -1,
		   -1,   0x2511,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "dL", "BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY" } },  
  /* FORMS DOWN HEAVY AND LEFT LIGHT
     BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6B | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      183,     -1,      -1,      -1,
		   -1,   0x2512,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Dl", "BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT" } },  
  /* FORMS HEAVY DOWN AND LEFT / BOX DRAWINGS HEAVY DOWN AND LEFT  */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6B | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      187,     -1,      -1,      -1,
		   -1,   0x2513,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "LD", "BOX DRAWINGS HEAVY DOWN AND LEFT" } },  
  /* FORMS LIGHT UP AND RIGHT / BOX DRAWINGS LIGHT UP AND RIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6D,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      192,     -1,      -1,      -1,
		   -1,   0x2514,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "ur", "BOX DRAWINGS LIGHT UP AND RIGHT" } },
  /* FORMS UP LIGHT AND RIGHT HEAVY 
     BOX DRAWINGS UP LIGHT AND RIGHT HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6D | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      212,     -1,      -1,      -1,
		   -1,   0x2515,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "uR", "BOX DRAWINGS UP LIGHT AND RIGHT HEAVY" } },
  /* FORMS UP HEAVY AND RIGHT LIGHT 
     BOX DRAWINGS UP HEAVY AND RIGHT LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6D | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      211,     -1,      -1,      -1,
		   -1,   0x2516,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Ur", "BOX DRAWINGS UP HEAVY AND RIGHT LIGHT" } },
  /* FORMS HEAVY UP AND RIGHT / BOX DRAWINGS HEAVY UP AND RIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6D | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      200,     -1,      -1,      -1,
		   -1,   0x2517,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "UR", "BOX DRAWINGS HEAVY UP AND RIGHT" } }, 
  /* FORMS LIGHT UP AND LEFT / BOX DRAWINGS LIGHT UP AND LEFT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6A,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      217,     -1,      -1,      -1,
		   -1,   0x2518,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "ul", "BOX DRAWINGS LIGHT UP AND LEFT" } },
  /* FORMS UP LIGHT AND LEFT HEAVY
     BOX DRAWINGS UP LIGHT AND LEFT HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6A | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      190,     -1,      -1,      -1,
		   -1,   0x2519,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "uL", "BOX DRAWINGS UP LIGHT AND LEFT HEAVY" } },
  /* FORMS UP HEAVY AND LEFT LIGHT
     BOX DRAWINGS UP HEAVY AND LEFT LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6A | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      189,     -1,      -1,      -1,
		   -1,   0x251a,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Ul", "BOX DRAWINGS UP HEAVY AND LEFT LIGHT" } },
  /* FORMS HEAVY UP AND LEFT / BOX DRAWINGS HEAVY UP AND LEFT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6A | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      188,     -1,      -1,      -1,
		   -1,   0x251b,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "UL", "BOX DRAWINGS HEAVY UP AND LEFT" } }, 
  /* FORMS LIGHT VERTICAL AND RIGHT / BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x74,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      195,   -1,        -1,      -1,
		   -1,   0x251c,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "vr", "BOX DRAWINGS LIGHT VERTICAL AND RIGHT" } },
  /* FORMS VERTICAL LIGHT AND RIGHT HEAVY
     BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x74 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      198,   -1,        -1,      -1,
		   -1,   0x251d,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "vR", "BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY" } },
  /* Missing: BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT, 
                 FORMS UP HEAVY AND RIGHT DOWN LIGHT, UNICODE 0x251E
		 rfc1345 encoding: Udr
              BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT,
	         FORMS DOWN HEAVY AND RIGHT UP LIGHT, UNICODE 0x251F
		 rfc1345 encoding: uDr
	      */  
  /* FORMS VERTICAL HEAVY AND RIGHT LIGHT
     BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x74 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      199,   -1,        -1,      -1,
		   -1,   0x2520,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Vr", "BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT" } },
   /* Missing: BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY,
                  FORMS DOWN LIGHT AND RIGHT UP HEAVY, UNICODE 0x2521
		  rfc1345 encoding: UdR
               BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY,
	          FORMS UP LIGHT AND RIGHT DOWN HEAVY, UNICODE 0x2522
		  rfc1345 encoding: uDR
	       */ 
  /* FORMS HEAVY VERTICAL AND RIGHT / BOX DRAWINGS HEAVY VERTICAL AND RIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x74 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      204,   -1,        -1,      -1,
		   -1,   0x2523,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "VR", "BOX DRAWINGS HEAVY VERTICAL AND RIGHT" } }, 
  /* FORMS LIGHT VERTICAL AND LEFT / BOX DRAWINGS LIGHT VERTICAL AND LEFT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x75,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      180,     -1,      -1,      -1,
		   -1,   0x2524,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "vl", "BOX DRAWINGS LIGHT VERTICAL AND LEFT" } },
  /* FORMS VERTICAL LIGHT AND LEFT HEAVY
     BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x75 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      181,     -1,      -1,      -1,
		   -1,   0x2525,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "vL", "BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY" } },
  /* Missing: BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT,
                 FORMS UP HEAVY AND LEFT DOWN LIGHT, UNICODE 0x2526
		 rfc1345 encoding: Udl
              BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT,
	         FORMS DOWN HEAVY AND LEFT UP LIGHT, UNICODE 0x2527
		 rfc1345 encoding: uDl
	      */ 
  /* FORMS VERTICAL HEAVY AND LEFT LIGHT
     BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x75 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      182,     -1,      -1,      -1,
		   -1,   0x2528,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Vl", "BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT" } },
  /* Missing: BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY,
                 FORMS DOWN LIGHT AND LEFT UP HEAVY, UNICODE 0x2529
		 rfc1345 encoding: UdL
              BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY,
	         FORMS UP LIGHT AND LEFT DOWN HEAVY, UNICODE 0x252A
		 rfc1345 encoding: uDL
	      */
  /* FORMS HEAVY VERTICAL AND LEFT / BOX DRAWINGS HEAVY VERTICAL AND LEFT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x75 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      185,     -1,      -1,      -1,
		   -1,   0x252b,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "VL", "BOX DRAWINGS HEAVY VERTICAL AND LEFT" } }, 
  /* FORMS LIGHT DOWN AND HORIZONTAL
     BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x77,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      194,     -1,      -1,      -1,
		   -1,   0x252c,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "dh", "BOX DRAWINGS LIGHT DOWN AND HORIZONTAL" } },
  /* Missing: BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT,
                 FORMS LEFT HEAVY AND RIGHT DOWN LIGHT, UNICODE 0x252D
		 rfc1345 encoding: dLr
              BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT,
	         FORMS RIGHT HEAVY AND LEFT DOWN LIGHT, UNICODE 0x252E
		 rfc1345 encoding: dlR
              */
  /* FORMS DOWN LIGHT AND HORIZONTAL HEAVY
     BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x77 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      209,     -1,      -1,      -1,
		   -1,   0x252f,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "dH", "BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY" } },
  /* FORMS DOWN HEAVY AND HORIZONTAL LIGHT
     BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x77 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      210,     -1,      -1,      -1,
		   -1,   0x2530,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Dh", "BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT" } },
  /* Missing: BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY,
                 FORMS RIGHT LIGHT AND LEFT DOWN HEAVY, UNICODE 0x2531
		 rfc1345 encoding: DLr
              BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY,
	         FORMS LEFT LIGHT AND RIGHT DOWN HEAVY, UNICODE 0x2532
		 rfc1345 encoding: DlR */
  /* FORMS HEAVY DOWN AND HORIZONTAL 
     BOX DRAWINGS HEAVY DOWN AND HORIZONTAL */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x77 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      203,     -1,      -1,      -1,
		   -1,   0x2533,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "DH", "BOX DRAWINGS HEAVY DOWN AND HORIZONTAL" } },   
  /* FORMS LIGHT UP AND HORIZONTAL / BOX DRAWINGS LIGHT UP AND HORIZONTAL */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x76,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      193,     -1,      -1,      -1,
		   -1,    0x2534,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "uh", "BOX DRAWINGS LIGHT UP AND HORIZONTAL" } },
   /* Missing: BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT,
                  FORMS LEFT HEAVY AND RIGHT UP LIGHT, UNICODE 0x2535
		  rfc1345 encoding: uLr
               BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT,
	          FORMS RIGHT HEAVY AND LEFT UP LIGHT, UNICODE 0x2536
		  rfc1345 encoding: ulR
	       */  
  /* FORMS UP LIGHT AND HORIZONTAL HEAVY
     BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x76 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      207,     -1,      -1,      -1,
		   -1,    0x2537,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "uH", "BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY" } },
  /* FORMS UP HEAVY AND HORIZONTAL LIGHT
     BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x76 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      208,     -1,      -1,      -1,
		   -1,    0x2538,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Uh", "BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT" } },
  /* Missing: BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY,
                 FORMS RIGHT LIGHT AND LEFT UP HEAVY, UNICODE 0x2539
		 rfc1345 encoding: ULr
              BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY,
	         FORMS LEFT LIGHT AND RIGHT UP HEAVY, UNICODE 0x253A
		 rfc1345 encoding: UlR
	      */
  /* FORMS HEAVY UP AND HORIZONTAL / BOX DRAWINGS HEAVY UP AND HORIZONTAL */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x76 | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      202,     -1,      -1,      -1,
		   -1,    0x253b,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "UH", "BOX DRAWINGS HEAVY UP AND HORIZONTAL" } },  
  /* FORMS LIGHT VERTICAL AND HORIZONTAL
     BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6E,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      197,     -1,      -1,      -1,
		   -1,   0x253c,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "vh", "BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL" } },
  /* Missing: BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT,
                 FORMS LEFT HEAVY AND RIGHT VERTICAL LIGHT, UNICODE 0x253D
		 rfc1345 encoding: vLr
              BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT,
	         FORMS RIGHT HEAVY AND LEFT VERTICAL LIGHT, UNICODE 0x253E
		 rfc1345 encoding: vlR */
  /* FORMS VERTICAL LIGHT AND HORIZONTAL HEAVY
     BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6E | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      215,     -1,      -1,      -1,
		   -1,   0x253f,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "vH", "BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY" } },
  /* Missing: BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT,
                 FORMS UP HEAVY AND DOWN HORIZONTAL LIGHT, UNICODE 0x2540
		 rfc1345 encoding: Udh
              BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT,
	         FORMS DOWN HEAVY AND UP HORIZONTAL LIGHT, UNICODE 0x2541 
		 rfc1345 encoding: uDh */
  /* FORMS VERTICAL HEAVY AND HORIZONTAL LIGHT
     BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6E | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      216,     -1,      -1,      -1,
		   -1,   0x2542,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Vh", "BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT" } },
  /* Missing: BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT,
                 FORMS LEFT UP HEAVY AND RIGHT DOWN LIGHT, UNICODE 0x2543
		 rfc1345 encoding: UdLr
              BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT,
	         FORMS RIGHT UP HEAVY AND LEFT DOWN LIGHT, UNICODE 0x2544
		 rfc1345 encoding: UdlR
	      BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT,
	         FORMS LEFT DOWN HEAVY AND RIGHT UP LIGHT, UNICODE 0x2545
		 rfc1345 encoding: uDLr
	      BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT,
	         FORMS RIGHT DOWN HEAVY AND LEFT UP LIGHT, UNICODE 0x2546
		 rfc1345 encoding: uDlR
	      BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY,
	         FORMS DOWN LIGHT AND UP HORIZONTAL HEAVY, UNICODE 0x2547
		 rfc1345 encoding: UdH
	      BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY,
	         FORMS UP LIGHT AND DOWN HORIZONTAL HEAVY, UNICODE 0x2548
		 rfc1345 encoding: uDH
	      BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY,
	         FORMS RIGHT LIGHT AND LEFT VERTICAL HEAVY, UNICODE 0x2549
		 rfc1345 encoding: VLr
	      BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY,
	         FORMS LEFT LIGHT AND RIGHT VERTICAL HEAVY, UNICODE 0x254A
		 rfc1345 encoding: VlR
	      */
  /* FORMS HEAVY VERTICAL AND HORIZONTAL 
     BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL */
  { "+",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x6E | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      206,     -1,      -1,      -1,
		   -1,   0x254b,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "VH", "BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL" } }, 
   /* Missing: BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL,
	          FORMS LIGHT DOUBLE DASH HORIZONTAL, UNICODE 0x254C
               BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL,
	          FORMS HEAVY DOUBLE DASH HORIZONTAL, UNICODE 0x254D
               BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL,
	          FORMS LIGHT DOUBLE DASH VERTICAL, UNICODE 0x254E
               BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL,
	          FORMS HEAVY DOUBLE DASH VERTICAL, UNICODE 0x254F
               BOX DRAWINGS DOUBLE HORIZONTAL,
	          FORMS DOUBLE HORIZONTAL, UNICODE 0x2550
               BOX DRAWINGS DOUBLE VERTICAL,
	          FORMS DOUBLE VERTICAL, UNICODE 0x2551
               BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE,
	          FORMS DOWN SINGLE AND RIGHT DOUBLE, UNICODE 0x2552
               BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE,
	          FORMS DOWN DOUBLE AND RIGHT SINGLE, UNICODE 0x2553
               BOX DRAWINGS DOUBLE DOWN AND RIGHT,
	          FORMS DOUBLE DOWN AND RIGHT, UNICODE 0x2554
               BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE,
	          FORMS DOWN SINGLE AND LEFT DOUBLE, UNICODE 0x2555
               BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE,
	          FORMS DOWN DOUBLE AND LEFT SINGLE, UNICODE 0x2556
               BOX DRAWINGS DOUBLE DOWN AND LEFT,
	          FORMS DOUBLE DOWN AND LEFT, UNICODE 0x2557
               BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE,
	          FORMS UP SINGLE AND RIGHT DOUBLE, UNICODE 0x2558
               BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE,
	          FORMS UP DOUBLE AND RIGHT SINGLE, UNICODE 0x2559
               BOX DRAWINGS DOUBLE UP AND RIGHT,
	          FORMS DOUBLE UP AND RIGHT, UNICODE 0x255A
               BOX DRAWINGS UP SINGLE AND LEFT DOUBLE,
	          FORMS UP SINGLE AND LEFT DOUBLE, UNICODE 0x255B
               BOX DRAWINGS UP DOUBLE AND LEFT SINGLE,
	          FORMS UP DOUBLE AND LEFT SINGLE, UNICODE 0x255C
               BOX DRAWINGS DOUBLE UP AND LEFT,
	          FORMS DOUBLE UP AND LEFT, UNICODE 0x255D
               BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE,
	          FORMS VERTICAL SINGLE AND RIGHT DOUBLE, UNICODE 0x255E
               BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE,
	          FORMS VERTICAL DOUBLE AND RIGHT SINGLE, UNICODE 0x255F
               BOX DRAWINGS DOUBLE VERTICAL AND RIGHT,
	          FORMS DOUBLE VERTICAL AND RIGHT, UNICODE 0x2560
               BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE,
	          FORMS VERTICAL SINGLE AND LEFT DOUBLE, UNICODE 0x2561
               BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE,
	          FORMS VERTICAL DOUBLE AND LEFT SINGLE, UNICODE 0x2562
               BOX DRAWINGS DOUBLE VERTICAL AND LEFT,
	          FORMS DOUBLE VERTICAL AND LEFT, UNICODE 0x2563
               BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE,
	          FORMS DOWN SINGLE AND HORIZONTAL DOUBLE, UNICODE 0x2564
               BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE,
	          FORMS DOWN DOUBLE AND HORIZONTAL SINGLE, UNICODE 0x2565
               BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL,
	          FORMS DOUBLE DOWN AND HORIZONTAL, UNICODE 0x2566
               BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE,
	          FORMS UP SINGLE AND HORIZONTAL DOUBLE, UNICODE 0x2567
               BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE,
	          FORMS UP DOUBLE AND HORIZONTAL SINGLE, UNICODE 0x2568
               BOX DRAWINGS DOUBLE UP AND HORIZONTAL,
	          FORMS DOUBLE UP AND HORIZONTAL, UNICODE 0x2569
               BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE,
	          FORMS VERTICAL SINGLE AND HORIZONTAL DOUBLE, UNICODE 0x256A
               BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE,
	          FORMS VERTICAL DOUBLE AND HORIZONTAL SINGLE, UNICODE 0x256B
               BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL,
	          FORMS DOUBLE VERTICAL AND HORIZONTAL, UNICODE 0x256C
               BOX DRAWINGS LIGHT ARC DOWN AND RIGHT,
	          FORMS LIGHT ARC DOWN AND RIGHT, UNICODE 0x256D
               BOX DRAWINGS LIGHT ARC DOWN AND LEFT,
	          FORMS LIGHT ARC DOWN AND LEFT, UNICODE 0x256E
               BOX DRAWINGS LIGHT ARC UP AND LEFT,
	          FORMS LIGHT ARC UP AND LEFT, UNICODE 0x256F
               BOX DRAWINGS LIGHT ARC UP AND RIGHT,
	          FORMS LIGHT ARC UP AND RIGHT, UNICODE 0x2570
               BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT,
	          FORMS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT, 
		  UNICODE 0x2571
		  rfc1345 encoding: FD
               BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT,
	          FORMS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT, 
		  UNICODE 0x2572
		  rfc1345 encoding: BD
               BOX DRAWINGS LIGHT DIAGONAL CROSS,
	          FORMS LIGHT DIAGONAL CROSS, UNICODE 0x2573
               BOX DRAWINGS LIGHT LEFT,
	          FORMS LIGHT LEFT, UNICODE 0x2574
               BOX DRAWINGS LIGHT UP,
	          FORMS LIGHT UP, UNICODE 0x2575
               BOX DRAWINGS LIGHT RIGHT,
	          FORMS LIGHT RIGHT, UNICODE 0x2576
               BOX DRAWINGS LIGHT DOWN,
	          FORMS LIGHT DOWN, UNICODE 0x2577
               BOX DRAWINGS HEAVY LEFT,
	          FORMS HEAVY LEFT, UNICODE 0x2578
               BOX DRAWINGS HEAVY UP,
	          FORMS HEAVY UP, UNICODE 0x2579
               BOX DRAWINGS HEAVY RIGHT,
	          FORMS HEAVY RIGHT, UNICODE 0x257A
               BOX DRAWINGS HEAVY DOWN,
	          FORMS HEAVY DOWN, UNICODE 0x257B
               BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT,
	          FORMS LIGHT LEFT AND HEAVY RIGHT, UNICODE 0x257C
               BOX DRAWINGS LIGHT UP AND HEAVY DOWN,
	          FORMS LIGHT UP AND HEAVY DOWN, UNICODE 0x257D
               BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT,
	          FORMS HEAVY LEFT AND LIGHT RIGHT, UNICODE 0x257E
               BOX DRAWINGS HEAVY UP AND LIGHT DOWN,
	          FORMS HEAVY UP AND LIGHT DOWN, UNICODE 0x257F
	       */
  /* UPPER HALF BLOCK */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      223,     -1,      -1,      -1,
		   -1,   0x2580,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "TB", "UPPER HALF BLOCK" } }, 
  /* Missing:  LOWER ONE EIGHTH BLOCK, UNICODE 0x2581
               LOWER ONE QUARTER BLOCK, UNICODE 0x2582
               LOWER THREE EIGHTHS BLOCK, UNICODE 0x2583 */
  /* LOWER HALF BLOCK */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      220,     -1,      -1,      -1,
		   -1,   0x2584,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "LB", "LOWER HALF BLOCK" } },
  /* Missing:  LOWER FIVE EIGHTHS BLOCK, UNICODE 0x2585
               LOWER THREE QUARTERS BLOCK,
	          LOWER THREE QUARTER BLOCK, UNICODE 0x2586
               LOWER SEVEN EIGHTHS BLOCK, UNICODE 0x2587 */
  /* FULL BLOCK */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      219,     -1,      -1,      -1,
		   -1,   0x2588,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "FB", "FULL BLOCK" } },
/* Missing:    LEFT SEVEN EIGHTHS BLOCK, UNICODE 0x2589
               LEFT THREE QUARTERS BLOCK,
	          LEFT THREE QUARTER BLOCK, UNICODE 0x258A
               LEFT FIVE EIGHTHS BLOCK, UNICODE 0x258B */
  /* LEFT HALF BLOCK */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      221,     -1,      -1,      -1,
		   -1,   0x258c,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "lB", "LEFT HALF BLOCK" } }, 
  /* Missing:  LEFT THREE EIGHTHS BLOCK, UNICODE 0x258D
               LEFT ONE QUARTER BLOCK, UNICODE 0x258E
               LEFT ONE EIGHTH BLOCK, UNICODE 0x258F */
  /* RIGHT HALF BLOCK */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      222,     -1,      -1,      -1,
		   -1,   0x2590,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "RB", "RIGHT HALF BLOCK" } }, 
  /* LIGHT SHADE */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      176,     -1,      -1,      -1,
		   -1,   0x2591,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { ".S", "LIGHT SHADE" } }, 
  /* MEDIUM SHADE */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      177,     -1,      -1,      -1,
		   -1,   0x2592,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { ":S", "MEDIUM SHADE" } }, 
  /* DARK SHADE */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      178,     -1,      -1,      -1,
		   -1,   0x2593,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "?S", "DARK SHADE" } },  
  /* Missing:  UPPER ONE EIGHTH BLOCK, UNICODE 0x2594
               RIGHT ONE EIGHTH BLOCK, UNICODE 0x2595
               BLACK SQUARE, UNICODE 0x25A0
	          rfc1345 encoding: fS
               WHITE SQUARE, UNICODE 0x25A1
	          rfc1345 encoding: OS
               WHITE SQUARE WITH ROUNDED CORNERS, UNICODE 0x25A2
	          rfc1345 encoding: RO
               WHITE SQUARE CONTAINING BLACK SMALL SQUARE, UNICODE 0x25A3
	          rfc1345 encoding: Rr
               SQUARE WITH HORIZONTAL FILL, UNICODE 0x25A4
	          rfc1345 encoding: RF
               SQUARE WITH VERTICAL FILL, UNICODE 0x25A5
	          rfc1345 encoding: RY
               SQUARE WITH ORTHOGONAL CROSSHATCH FILL, UNICODE 0x25A6
	          rfc1345 encoding: RH
               SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL, UNICODE 0x25A7
	          rfc1345 encoding: RK
               SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL, UNICODE 0x25A8
	          rfc1345 encoding: RK
               SQUARE WITH DIAGONAL CROSSHATCH FILL, UNICODE 0x25A9
	          rfc1345 encoding: RX
*/
  /* BLACK SMALL SQUARE */
  { " ",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      254,     -1,      -1,      -1,
		   -1,   0x25aa,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "sB", "BLACK SMALL SQUARE" } },  
/* Missing:
               WHITE SMALL SQUARE, UNICODE 0x25AB
               BLACK RECTANGLE, UNICODE 0x25AC
	          rfc1345 encoding: SR
               WHITE RECTANGLE, UNICODE 0x25AD
	          rfc1345 encoding: Or
               BLACK VERTICAL RECTANGLE, UNICODE 0x25AE
               WHITE VERTICAL RECTANGLE, UNICODE 0x25AF
               BLACK PARALLELOGRAM, UNICODE 0x25B0
               WHITE PARALLELOGRAM, UNICODE 0x25B1
               BLACK UP-POINTING TRIANGLE,
	          BLACK UP POINTING TRIANGLE, UNICODE 0x25B2
		  rfc1345 encoding: UT
               WHITE UP-POINTING TRIANGLE,
	          WHITE UP POINTING TRIANGLE, UNICODE 0x25B3
		  rfc1345 encoding: uT
               BLACK UP-POINTING SMALL TRIANGLE,
	          BLACK UP POINTING SMALL TRIANGLE, UNICODE 0x25B4
               WHITE UP-POINTING SMALL TRIANGLE,
	          WHITE UP POINTING SMALL TRIANGLE, UNICODE 0x25B5
               BLACK RIGHT-POINTING TRIANGLE,
	          BLACK RIGHT POINTING TRIANGLE, UNICODE 0x25B6
		  rfc1345 encoding: PR     
               WHITE RIGHT-POINTING TRIANGLE,
	          WHITE RIGHT POINTING TRIANGLE, UNICODE 0x25B7
		  rfc1345 encoding: Tr
               BLACK RIGHT-POINTING SMALL TRIANGLE,
	          BLACK RIGHT POINTING SMALL TRIANGLE, UNICODE 0x25B8
               WHITE RIGHT-POINTING SMALL TRIANGLE,
	          WHITE RIGHT POINTING SMALL TRIANGLE, UNICODE 0x25B9
               BLACK RIGHT-POINTING POINTER,
	          BLACK RIGHT POINTING POINTER, UNICODE 0x25BA
               WHITE RIGHT-POINTING POINTER,
	          WHITE RIGHT POINTING POINTER, UNICODE 0x25BB
               BLACK DOWN-POINTING TRIANGLE,
	          BLACK DOWN POINTING TRIANGLE, UNICODE 0x25BC
		  rfc1345 encoding: Dt
               WHITE DOWN-POINTING TRIANGLE,
	          WHITE DOWN POINTING TRIANGLE, UNICODE 0x25BD
		  rfc1345 encoding: dT
               BLACK DOWN-POINTING SMALL TRIANGLE,
	          BLACK DOWN POINTING SMALL TRIANGLE, UNICODE 0x25BE
               WHITE DOWN-POINTING SMALL TRIANGLE,
	          WHITE DOWN POINTING SMALL TRIANGLE, UNICODE 0x25BF
               BLACK LEFT-POINTING TRIANGLE,
	          BLACK LEFT POINTING TRIANGLE, UNICODE 0x25C0
		  rfc1345 encoding: PL
               WHITE LEFT-POINTING TRIANGLE,
	          WHITE LEFT POINTING TRIANGLE, UNICODE 0x25C1
		  rfc1345 encoding: Tl
               BLACK LEFT-POINTING SMALL TRIANGLE,
	          BLACK LEFT POINTING SMALL TRIANGLE, UNICODE 0x25C2
               WHITE LEFT-POINTING SMALL TRIANGLE,
	          WHITE LEFT POINTING SMALL TRIANGLE, UNICODE 0x25C3
               BLACK LEFT-POINTING POINTER,
	          BLACK LEFT POINTING POINTER, UNICODE 0x25C4
               WHITE LEFT-POINTING POINTER,
	          WHITE LEFT POINTING POINTER, UNICODE 0x25C5  */
  /*  (diamond) BLACK DIAMOND */
  { "<>", {0,0}, 1,NULL,
      {            -1,       -1,     -1,    0x60,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xD7,
		   -1,   0x25c6,     -1,        -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                     -1,       -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Db", "BLACK DIAMOND" } },
  /* Missing:  WHITE DIAMOND, UNICODE 0x25C7
	          rfc1345 encoding: Db
               WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND, UNICODE 0x25C8
	          rfc1345 encoding: Dw   */

  /* Mathematical characters */
  /* Missing: FOR ALL, UNICODE 0x2200
                  rfc1345 encoding: FA
              COMPLEMENT, UNICODE 0x2201
	      PARTIAL DIFFERENTIAL, UNICODE 2202
	          rfc1345 encoding: dP
	      THERE EXISTS, UNICODE 2203
	          rfc1345 encoding: TE
	      THERE DOES NOT EXIST, UNICODE 2204 */

  /* EMPTY SET */
  { "/0", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      237,   0x4A|FC_fallback,      
		                              -1,      -1,
		   -1,   0x2205,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "/0", "EMPTY SET" } },
  /* INCREMENT */
  { "DE", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x44|FC_alias, 
                                              -1,    0xC6|FC_fallback,
		   -1,   0x2206,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0394] */
      { "DE", "INCREMENT" } },   
  /* NABLA */
  { "NB", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x45,      -1,      -1,
		   -1,   0x2207,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "NB", "NABLA" } },   
  /*  (membership) ELEMENT OF */
  { "(-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      238,     -1,      -1,      -1,
		   -1,   0x2208,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "(-", "ELEMENT OF" } },
  /* Missing: NOT AN ELEMENT OF, UNICODE 0x2209 
              SMALL ELEMENT OF, UNICODE 0x220A,
	          UNICODE Decomposition: [03B5] 
	      CONTAINS AS MEMBER, UNICODE 0x220B
	          rfc1345 encoding: -)
	      DOES NOT CONTAIN AS MEMBER, UNICODE 0x220C
	      SMALL CONTAINS AS MEMBER, UNICODE 2203 */ 
  /* END OF PROOF */
  { ":.", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x40|FC_fallback,      
		                              -1,      -1,
		   -1,   0x220E,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "END OF PROOF" } },  /* Not in rfc1345 */ 
  /* N-ARY PRODUCT */
  { "[mul]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      0x7B | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x50|FC_alias,      -1, 0xB8|FC_fallback,
		   -1,   0x220F,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* Unicode Decomposition: [03A0] */
      { "*P", "N-ARY PRODUCT" } },
  /* Missing: N-ARY COPRODUCT, UNICODE 0x2210 */
  /* N-ARY SUMMATION */
  { "[sum]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      228|FC_alias,  
		                   0x53|FC_alias,   -1, 0xB7|FC_fallback,
		   -1,   0x2211,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [03A3] */
      { "+Z", "N-ARY SUMMATION" } },  
  /* MINUS SIGN */
  { "-", {0,0}, 1,NULL,
      { 0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,
	0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,
	0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,0x2D|FC_alias,
	0x2D|FC_alias,0x2D|FC_alias,  -1,         0x2D|FC_alias,0x2D|FC_alias,
	0x2D|FC_alias,   0x2212,   0x2D|FC_alias,        0x2D|FC_alias,       0x2D|FC_alias,
	0x2D|FC_alias,        0x2D|FC_alias,      0x2D|FC_alias,      0x2D|FC_alias,       0x2D|FC_alias,
                     0x2D|FC_alias,     0x2D|FC_alias,      0x2D|FC_alias,      0x2D|FC_alias,      0x2D|FC_alias,
                   0x2D|FC_alias,      0x2D|FC_alias,      0x2D|FC_alias,      0x2D|FC_alias },
      { "-2", "MINUS SIGN" } },  
  /* MINUS-OR-PLUS SIGN */
  { "-+", {'-','+'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2213,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "-+", "MINUS-OR-PLUS SIGN" } }, 
   /* Missing: DOT PLUS, UNICODE 0x2214 */ 
  /* DIVISION SLASH */
  { "/",  {0,0}, 1, NULL,
      { 0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,
	0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,
        0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,0x2F|FC_alias,
        0x2F|FC_alias,0x2F|FC_alias,  -1,         0x2F|FC_alias,0x2F|FC_alias,
	0x2F|FC_alias,   0x2215,   0x2F|FC_alias,        0x2F|FC_alias,       0x2F|FC_alias,
	0x2F|FC_alias,        0x2F|FC_alias,      0x2F|FC_alias,      0x2F|FC_alias,       0x2F|FC_alias,
                     0x2F|FC_alias,     0x2F|FC_alias,      0x2F|FC_alias,      0x2F|FC_alias,      0x2F|FC_alias,
                   0x2F|FC_alias,      0x2F|FC_alias,      0x2F|FC_alias,      0x2F|FC_alias },
      { NULL, "DIVISION SLASH" } },  /* Not in rfc1345 */
   /* Missing: SET MINUS, UNICODE 0x2216 
               ASTERISK OPERATOR, UNICODE 0x2217
	           rfc1345 encoding: *-
               RING OPERATOR, UNICODE 0x2218
	           rfc1345 encoding: Ob */
  /*  (bullet) BULLET OPERATOR */
  { ".", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xA5,
		   -1,   0x2219,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,    0x40,
                   -1,      -1,      -1,      -1 },
      { "Sb", "BULLET OPERATOR" } },  
  /*  (radical) SQUARE ROOT */
  { "V~", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      251,   0x56,      -1,    0xC3,
		   -1,   0x221a,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "RT", "SQUARE ROOT" } }, 
  /* Missing: CUBE ROOT, UNICODE 0x221B
              FOURTH ROOT, UNICODE 0x221C
              PROPORTIONAL TO, UNICODE 0x221D
	          rfc1345 encoding: 0(  */  
  /*  (infinity) INFINITY */
  { "oo", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      236,   0x42,      -1,    0xB0,
		   -1,  0x221e,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "00", "INFINITY" } },  
  /* Missing: RIGHT ANGLE, UNICODE 0x221F
                  rfc1345 encoding: -L
              ANGLE, UNICODE 0x2220
	          rfc1345 encoding: -V
              MEASURED ANGLE, UNICODE 0x2221
              SPHERICAL ANGLE, UNICODE 0x2222 
              DIVIDES, UNICODE 0x2223       
              DOES NOT DIVIDE, UNICODE 0x2224
	      PARALLEL TO, UNICODE 0x2225
	          rfc1345 encoding: PP
	      NOT PARALLEL TO, UNICODE 0x2226
	      LOGICAL AND, UNICODE 0x2227
                  rfc1345 encoding: AN
	      LOGICAL OR, UNICODE 0x2228 
	          rfc1345 encoding: OR */
  /*  (intersection) INTERSECTION */
  { "[intersection]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      239,   0x5C ,     -1,      -1,
		   -1,   0x2229,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "(U", "INTERSECTION" } },   
  /* UNION */
  { "U", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x222a,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ">U", "UNION" } },   
  /* (integral sign) INTEGRAL */
  { "_/-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x3F,      -1,    0xBA,
		   -1,   0x222b,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [2320] & [2321] */
      { "In", "INTEGRAL" } }, 
  /* Missing: DOUBLE INTEGRAL, UNICODE 0x222C
                  rfc1345 encoding: DI
              TRIPLE INTEGRAL, UNICODE 0x222D */
  /*  (integral sign with dash?) CONTOUR INTEGRAL */
  { "_/-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xC4,
		   -1,   0x222e,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Io", "CONTOUR INTEGRAL" } }, 
  /* Missing: SURFACE INTEGRAL, UNICODE 0x222F
              VOLUME INTEGRAL, UNICODE 0x2230
              CLOCKWISE INTEGRAL, UNICODE 0x2231
              CLOCKWISE CONTOUR INTEGRAL, UNICODE 0x2232
              ANTICLOCKWISE CONTOUR INTEGRAL, UNICODE 0x2233 */
  /* THEREFORE */
  { ".:", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x40,      -1,      -1,
		   -1,   0x2234,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ".:", "THEREFORE" } }, 

  /* (Because) BECAUSE */
  { "[Because]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x40|FC_fallback,
                                              -1,      -1,
		   -1,   0x2235,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ":.", "BECAUSE" } },
  /* Missing: RATIO, UNICODE 0x2236
                 rfc1345 encoding: :R
              PROPORTION, UNICODE 0x2237
	         rfc1345 encoding: ::     
	      DOT MINUS, UNICODE 0x2238
	      EXCESS, UNICODE 0x2239
	      GEOMETRIC PROPORTION, UNICODE 0x223A
	      HOMOTHETIC, UNICODE 0x223B */   
  /* TILDE OPERATOR */
  { "~", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x223C,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "?1", "TILDE OPERATOR" } },
  /* Missing: INVERTED LAZY S, UNICODE 0x223E
                   rfc1345 encoding: CG
              SINE WAVE, UNICODE 0x223F
	      WREATH PRODUCT, UNICODE 0x2240
	      NOT TILDE, UNICODE 0x2241
	      MINUS TILDE, UNICODE 0x2242  */
  /* ASYMPTOTICALLY EQUAL TO */
  { "~", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x48|FC_fallback ,-1,      -1,
		   -1,   0x2243,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "?-", "ASYMPTOTICALLY EQUAL TO" } },   
  /* Missing: NOT ASYMPTOTICALLY EQUAL TO, UNICODE 0x2244 */ 
  /*  (approximately equal) APPROXIMATELY EQUAL TO */
  { "~=", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      247,   0x49,      -1,    0xC5,
		   -1,   0x2245,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "?=", "APPROXIMATELY EQUAL TO" } }, 
  /* Missing: APPROXIMATELY BUT NOT ACTUALLY EQUAL TO, UNICODE 0x2246
              NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO, UNICODE 0x2247
	      ALMOST EQUAL TO, UNICODE 0x2248
	          rfc1345 encoding: ?2
	      NOT ALMOST EQUAL TO, UNICODE 0x2249
	      ALMOST EQUAL OR EQUAL TO, UNICODE 0x224A
	      TRIPLE TILDE, UNICODE 0x224B */
   /* ALL EQUAL TO */    /* Is all equal to this: =>  ?? */
  { "=>", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x4E,      -1,      -1,
		   -1,   0x224C,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "=?", "ALL EQUAL TO" } }, 
  /* EQUIVALENT TO */     /* Is equivalent this: <=> ?? */
  { "<=>", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x4D,      -1,      -1,
		   -1,   0x224D,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "EQUIVALENT TO" } }, /* Not in RFC1345 !! */
  /* Missing: GEOMETRICALLY EQUIVALENT TO, UNICODE 0x224E
              DIFFERENCE BETWEEN, UNICODE 0x224F
	      APPROACHES THE LIMIT, UNICODE 0x2250
	      GEOMETRICALLY EQUAL TO, UNICODE 0x2251
	      APPROXIMATELY EQUAL TO OR THE IMAGE OF, UNICODE 0x2252
	      IMAGE OF OR APPROXIMATELY EQUAL TO, UNICODE 0x2253
	          rfc1345 encoding: HI  
	      COLON EQUALS, COLON EQUAL, UNICODE 0x2254
	      EQUALS COLON, EQUAL COLON, UNICODE 0x2255
	      RING IN EQUAL TO, UNICODE 0x2256
	      RING EQUAL TO, UNICODE 0x2257 */
  /* CORRESPONDS TO */          /* Is that good for corresponds to ? */
  { "~", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x48,      -1,      -1,
		   -1,   0x2258,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "CORRESPONDS TO" } },
  /* Missing: ESTIMATES, UNICODE 0x2259
              EQUIANGULAR TO, UNICODE 0x225A
	      STAR EQUALS, UNICODE 0x225B
	      DELTA EQUAL TO, UNICODE 0x225C
	      EQUAL TO BY DEFINITION, UNICODE 0x225D
	      MEASURED BY, UNICODE 0x225E
	      QUESTIONED EQUAL TO, UNICODE 0x225F */
  /* (not equal) NOT EQUAL TO */
  { "<>", {'<','>'}, 1,NULL,
      {            -1,       -1,     -1,    0x7C,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xAD,
		   -1,   0x2260,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "!=", "NOT EQUAL TO" } }, 
  /* (congruent) IDENTICAL TO */
  { "==", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      240,   0x4F,      -1,      -1,
		   -1,   0x2261,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "=3", "IDENTICAL TO" } },   
  /* Missing: NOT IDENTICAL TO, UNICODE 0x2262
              STRICTLY EQUIVALENT TO, UNICODE 0x2263  */   
  /* LESS OR EQUAL SIGN 
     LESS-THAN OR EQUAL TO */
  { "<=",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x79,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      243,    0x3C,     -1,    0xB2,
		   -1,   0x2264,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "=<", "LESS-THAN OR EQUAL TO" } },
  /* GREATER OR EQUAL SIGN / GREATER-THAN OR EQUAL TO */
  { ">=",  {0,0}, 1, NULL,
      {            -1,       -1,     -1,    0x7A,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
		   -1,      242,   0x3E,      -1,    0xB3,
		   -1,   0x2265,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ">=", "GREATER-THAN OR EQUAL TO" } },   
  /* Missing: LESS-THAN OVER EQUAL TO, LESS THAN OVER EQUAL TO, UNICODE 0x2266
              GREATER-THAN OVER EQUAL TO, 
                  GREATER THAN OVER EQUAL TO, UNICODE 0x2267
	      LESS-THAN BUT NOT EQUAL TO, 
                  LESS THAN BUT NOT EQUAL TO, UNICODE 0x2268
	      GREATER-THAN BUT NOT EQUAL TO,
                  GREATER THAN BUT NOT EQUAL TO, UNICODE 0x2269 */
  /* MUCH LESS-THAN
     MUCH LESS THAN */
  { "<<",  {0,0},1, NULL,
      {            -1,0xAB|FC_fallback,0xAB|FC_fallback, -1,       -1,
		   -1,       -1,     -1,      -1,      171|FC_fallback,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      174,     -1,      -1,     0xC7|FC_fallback,
		   -1,   0x226A,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* See also: 0x00AB LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */
      { "<*" , "MUCH LESS-THAN" } }, 
  /* MUCH GREATER-THAN
     MUCH GREATER THAN */
  { ">>",  {0,0},1, NULL,
      {            -1, 0xBB|FC_fallback, 0xBB|FC_fallback,  -1,       -1,
		   -1,       -1,      -1,     -1,      187|FC_fallback,
                   -1,       -1,      -1,     -1,       -1,
                   -1,      175,      -1,     -1,     0xC8|FC_fallback,
		   -1,   0x226B,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* See also: 0x00BB RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK*/
      { "*>", "MUCH GREATER-THAN" } }, 
  /* Missing: BETWEEN, UNICODE 0x226C
              NOT EQUIVALENT TO, UNICODE 0x226D
	      NOT LESS-THAN, NOT LESS THAN, UNICODE 0x226E
	          rfc1345 encoding: !<
              NOT GREATER-THAN, NOT GREATER THAN, UNICODE 0x226F
	          rfc1345 encoding: !>
	      NEITHER LESS-THAN NOR EQUAL TO, 
	          NEITHER LESS THAN NOR EQUAL TO, UNICODE 0x2270
	      NEITHER GREATER-THAN NOR EQUAL TO,
                  NEITHER GREATER THAN NOR EQUAL TO, UNICODE 0x2271
              LESS-THAN OR EQUIVALENT TO, 
	          LESS THAN OR EQUIVALENT TO, UNICODE 0x2272
	      GREATER-THAN OR EQUIVALENT TO, 
                  GREATER THAN OR EQUIVALENT TO, UNICODE 0x2273
	      NEITHER LESS-THAN NOR EQUIVALENT TO,
                  NEITHER LESS THAN NOR EQUIVALENT TO, UNICODE 0x2274
	      NEITHER GREATER-THAN NOR EQUIVALENT TO,
                  NEITHER GREATER THAN NOR EQUIVALENT TO, UNICODE 0x2275
              LESS-THAN OR GREATER-THAN, 
                  LESS THAN OR GREATER THAN, UNICODE 0x2276
              GREATER-THAN OR LESS-THAN, 
                  GREATER THAN OR LESS THAN, UNICODE 0x2277
              NEITHER LESS-THAN NOR GREATER-THAN,
                  NEITHER LESS THAN NOR GREATER THAN, UNICODE 0x2278
              NEITHER GREATER-THAN NOR LESS-THAN,
                  NEITHER GREATER THAN NOR LESS THAN, UNICODE 0x2279
	      PRECEDES, UNICODE 0x227A
	      SUCCEEDS, UNICODE 0x227B
	      PRECEDES OR EQUAL TO, UNICODE 0x227C
	      SUCCEEDS OR EQUAL TO, UNICODE 0x227D
	      PRECEDES OR EQUIVALENT TO, UNICODE 0x227E
	      SUCCEEDS OR EQUIVALENT TO, UNICODE 0x227F
	      DOES NOT PRECEDE, UNICODE 0x2280
	      DOES NOT SUCCEED, UNICODE 0x2281
*/ 
  /* SUBSET OF */
  { "(=", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x5A,      -1,      -1,
		   -1,   0x2282,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "(C", "SUBSET OF" } }, 
  /* SUPERSET OF */
  { "=)", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x5B,      -1,      -1,
		   -1,   0x2283,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ")C", "SUPERSET OF" } }, 
  /* Missing: NOT A SUBSET OF, UNICODE 0x2284
              NOT A SUPERSET OF, UNICODE 0x2285
	      SUBSET OF OR EQUAL TO, UNICODE 0x2286
                 rfc1345 encoding: (_
	      SUPERSET OF OR EQUAL TO, UNICODE 0x2287
	         rfc1345 encoding: )_
	      NEITHER A SUBSET OF NOR EQUAL TO, UNICODE 0x2288
	      NEITHER A SUPERSET OF NOR EQUAL TO, UNICODE 0x2289
	      SUBSET OF WITH NOT EQUAL TO, 
                 SUBSET OF OR NOT EQUAL TO, UNICODE 0x228A
	      SUPERSET OF WITH NOT EQUAL TO,
                 SUPERSET OF OR NOT EQUAL TO, UNICODE 0x228B
	      MULTISET, UNICODE 0x228C
	      MULTISET MULTIPLICATION, UNICODE 0x228D
	      MULTISET UNION, UNICODE 0x228E
	      SQUARE IMAGE OF, UNICODE 0x228F
	      SQUARE ORIGINAL OF, UNICODE 0x2290
	      SQUARE IMAGE OF OR EQUAL TO, UNICODE 0x2291
	      SQUARE ORIGINAL OF OR EQUAL TO, UNICODE 0x2292
	      SQUARE CAP, UNICODE 0x2293
	      SQUARE CUP, UNICODE 0x2294
	      CIRCLED PLUS, UNICODE 0x2295
	      CIRCLED MINUS, UNICODE 0x2296
	      CIRCLED TIMES, UNICODE 0x2297
	      CIRCLED DIVISION SLASH, UNICODE 0x2298
	      CIRCLED DOT OPERATOR, UNICODE 0x2299
	          rfc1345 encoding: 0.
	      CIRCLED RING OPERATOR, UNICODE 0x229A
	          rfc1345 encoding: 02
	      CIRCLED ASTERISK OPERATOR, UNICODE 0x229B
	      CIRCLED EQUALS, UNICODE 0x229C
	      CIRCLED DASH, UNICODE 0x229D
	      SQUARED PLUS, UNICODE 0x229E
	      SQUARED MINUS, UNICODE 0x229F
	      SQUARED TIMES, UNICODE 0x22A0
	      SQUARED DOT OPERATOR, UNICODE 0x22A1
	      RIGHT TACK, UNICODE 0x22A2
	      LEFT TACK, UNICODE 0x22A3
	      DOWN TACK, UNICODE 0x22A4
	      UP TACK, UNICODE 0x22A5
	         rfc1345 encoding: -T
	      ASSERTION, UNICODE 0x22A6
	      MODELS, UNICODE 0x22A7
	      TRUE, UNICODE 0x22A8
	      FORCES, UNICODE 0x22A9
              TRIPLE VERTICAL BAR RIGHT TURNSTILE, UNICODE 0x22AA
	      DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE, UNICODE 0x22AB
	      DOES NOT PROVE, UNICODE 0x22AC
	      NOT TRUE, UNICODE 0x22AD
	      DOES NOT FORCE, UNICODE 0x22AE
	      NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE, UNICODE 0x22AF
	      PRECEDES UNDER RELATION, UNICODE 0x22B0
	      SUCCEEDS UNDER RELATION, UNICODE 0x22B1
	      NORMAL SUBGROUP OF, UNICODE 0x22B2
	      CONTAINS AS NORMAL SUBGROUP, UNICODE 0x22B3
	      NORMAL SUBGROUP OF OR EQUAL TO, UNICODE 0x22B4
	      CONTAINS AS NORMAL SUBGROUP OR EQUAL TO, UNICODE 0x22B5
	      ORIGINAL OF, UNICODE 0x22B6
	      IMAGE OF, UNICODE 0x22B7
	      MULTIMAP, UNICODE 0x22B8
	      HERMITIAN CONJUGATE MATRIX, UNICODE 0x22B9
	      INTERCALATE, UNICODE 0x22BA
	      XOR, UNICODE 0x22BB
	      NAND, UNICODE 0x22BC
	      NOR, UNICODE 0x22BD
	      RIGHT ANGLE WITH ARC, UNICODE 0x22BE
	      RIGHT TRIANGLE, UNICODE 0x22BF
	      N-ARY LOGICAL AND, UNICODE 0x22C0
	      N-ARY LOGICAL OR, UNICODE 0x22C1
	      N-ARY INTERSECTION, UNICODE 0x22C2
	      N-ARY UNION, UNICODE 0x22C3
	      DIAMOND OPERATOR, UNICODE 0x22C4
	      DOT OPERATOR, UNICODE 0x22C5
	         rfc1345 encoding: .P
	      STAR OPERATOR, UNICODE 0x22C6
	      DIVISION TIMES, UNICODE 0x22C7
	      BOWTIE, UNICODE 0x22C8
	      LEFT NORMAL FACTOR SEMIDIRECT PRODUCT, UNICODE 0x22C9
	      RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT, UNICODE 0x22CA
	      LEFT SEMIDIRECT PRODUCT, UNICODE 0x22CB
	      RIGHT SEMIDIRECT PRODUCT, UNICODE 0x22CC
	      REVERSED TILDE EQUALS, UNICODE 0x22CD
	      CURLY LOGICAL OR, UNICODE 0x22CE
	      CURLY LOGICAL AND, UNICODE 0x22CF
	      DOUBLE SUBSET, UNICODE 0x22D0
	      DOUBLE SUPERSET, UNICODE 0x22D1
	      DOUBLE INTERSECTION, UNICODE 0x22D2
	      DOUBLE UNION, UNICODE 0x22D3
	      PITCHFORK, UNICODE 0x22D4
	      EQUAL AND PARALLEL TO, UNICODE 0x22D5
	      LESS-THAN WITH DOT, LESS THAN WITH DOT, UNICODE 0x22D6
	      GREATER-THAN WITH DOT, GREATER THAN WITH DOT, UNICODE 0x22D7
	      VERY MUCH LESS-THAN, VERY MUCH LESS THAN, UNICODE 0x22D8
	      VERY MUCH GREATER-THAN, VERY MUCH GREATER THAN, UNICODE 0x22D9
	      LESS-THAN EQUAL TO OR GREATER-THAN, 
	         LESS THAN EQUAL TO OR GREATER THAN, UNICODE 0x22DA
	      GREATER-THAN EQUAL TO OR LESS-THAN, 
	         GREATER THAN EQUAL TO OR LESS THAN, UNICODE 0x22DB
	      EQUAL TO OR LESS-THAN, EQUAL TO OR LESS THAN, UNICODE 0x22DC
	      EQUAL TO OR GREATER-THAN, 
	      EQUAL TO OR GREATER THAN, UNICODE 0x22DD
	      EQUAL TO OR PRECEDES,  UNICODE 0x22DE
	      EQUAL TO OR SUCCEEDS, UNICODE 0x22DF
	      DOES NOT PRECEDE OR EQUAL, UNICODE 0x22E0
	      DOES NOT SUCCEED OR EQUAL, UNICODE 0x22E1
	      NOT SQUARE IMAGE OF OR EQUAL TO, UNICODE 0x22E2
	      NOT SQUARE ORIGINAL OF OR EQUAL TO, UNICODE 0x22E3
	      SQUARE IMAGE OF OR NOT EQUAL TO, UNICODE 0x22E4
	      SQUARE ORIGINAL OF OR NOT EQUAL TO, UNICODE 0x22E5
	      LESS-THAN BUT NOT EQUIVALENT TO, 
	         LESS THAN BUT NOT EQUIVALENT TO, UNICODE 0x22E6
	      GREATER-THAN BUT NOT EQUIVALENT TO, 
	         GREATER THAN BUT NOT EQUIVALENT TO, UNICODE 0x22E7
      	      PRECEDES BUT NOT EQUIVALENT TO, UNICODE 0x22E8
	      SUCCEEDS BUT NOT EQUIVALENT TO, UNICODE 0x22E9
	      NOT NORMAL SUBGROUP OF, UNICODE 0x22EA
	      DOES NOT CONTAIN AS NORMAL SUBGROUP, UNICODE 0x22EB
	      NOT NORMAL SUBGROUP OF OR EQUAL TO, UNICODE 0x22EC
	      DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL, UNICODE 0x22ED
	      VERTICAL ELLIPSIS, UNICODE 0x22EE
	         rfc1345 encoding: :3  */
  /*  (ellipsis) MIDLINE HORIZONTAL ELLIPSIS */
  { "...", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xC9,
		   -1,  0x22ef,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ".3", "MIDLINE HORIZONTAL ELLIPSIS" } },  
  /* Missing: UP RIGHT DIAGONAL ELLIPSIS, UNICODE 0x22F0
	      DOWN RIGHT DIAGONAL ELLIPSIS, UNICODE 0x22F1
	      DIAMETER SIGN, UNICODE 0x2300
	      HOUSE, UNICODE 0x2302
	         rfc1345 encoding: Eh
	      UP ARROWHEAD, UNICODE 0x2303
	      DOWN ARROWHEAD, UNICODE 0x2304
	      PROJECTIVE, UNICODE 0x2305
	      PERSPECTIVE, UNICODE 0x2306
	      WAVY LINE, UNICODE 0x2307
	      LEFT CEILING, UNICODE 0x2308
	         rfc1345 encoding: <7
	      RIGHT CEILING, UNICODE 0x2309
	         rfc1345 encoding: >7
	      LEFT FLOOR, UNICODE 0x230A
	         rfc1345 encoding: 7<
	      RIGHT FLOOR, UNICODE 0x230B
	         rfc1345 encoding: 7>
	      BOTTOM RIGHT CROP, UNICODE 0x230C
	      BOTTOM LEFT CROP, UNICODE 0x230D
	      TOP RIGHT CROP, UNICODE 0x230E
	      TOP LEFT CROP, UNICODE 0x230F
	      REVERSED NOT SIGN, UNICODE 0x2310
	         rfc1345 encoding: NI
	      SQUARE LOZENGE, UNICODE 0x2311
	      ARC, UNICODE 0x2312
	         rfc1345 encoding: (A
	      SEGMENT, UNICODE 0x2313
	      SECTOR, UNICODE 0x2314
	      TELEPHONE RECORDER, UNICODE 0x2315
	         rfc1345 encoding: TR
	      POSITION INDICATOR, UNICODE 0x2316
	      VIEWDATA SQUARE, UNICODE 0x2317
	      PLACE OF INTEREST SIGN, COMMAND KEY, UNICODE 0x2318
	      TURNED NOT SIGN, UNICODE 0x2319
	      WATCH, UNICODE 0x231A
	      HOURGLASS, UNICODE 0x231B */
  /* TOP LEFT CORNER */
  { "+", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x27,      -1,      -1,
		   -1,   0x231C,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "TOP LEFT CORNER" } },  /* Not in rfc1345! */
  /* TOP RIGHT CORNER */
  { "+", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x29,      -1,      -1,
		   -1,   0x231D,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "TOP RIGHT CORNER" } },  /* Not in rfc1345! */
  /* BOTTOM LEFT CORNER */
  { "+", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x28,      -1,      -1,
		   -1,   0x231E,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "BOTTOM LEFT CORNER" } },  /* Not in rfc1345! */
  /* BOTTOM RIGHT CORNER */
  { "+", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x2A,      -1,      -1,
		   -1,   0x231F,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "BOTTOM RIGHT CORNER" } },  /* Not in rfc1345! */
  /* (top of integral) TOP HALF INTEGRAL */
  { "/-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      244,   0x24 ,      -1,        -1,
		   -1,   0x2320,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Iu", "TOP HALF INTEGRAL" } },
  /* (bottom of integral) BOTTOM HALF INTEGRAL */
  { "-/", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      245,   0x25 ,      -1,        -1,
		   -1,   0x2321,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Il", "BOTTOM HALF INTEGRAL" } }, 
  /*  FROWN */
  { ":-(", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2322,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "FROWN" } }, 
  /* SMILE */   /* See also: 263A: WHITE SMILING FACE */
  { ":-)", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2323,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "SMILE" } }, /* Not in rfc1345! */   
  /* UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS
     ENTER KEY */
  { "ENTER", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2324,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS" } }, /* Not in rfc1345! */    
 
 /* Missing: OPTION KEY, UNICODE 0x2325
             ERASE TO THE RIGHT, DELETE TO THE RIGHT KEY, UNICODE 0x2326
	     X IN A RECTANGLE BOX, CLEAR KEY, UNICODE 0x2327
	     KEYBOARD, UNICODE 0x2328 */ 
	     
 /* UNICODE RANGE 0x2329 - 0x24FF skipped !! */  


  /* GREEK LETTERS */
  /* Missing: GREEK NUMERAL SIGN, Dexia keraia,
                    GREEK UPPER NUMERAL SIGN, UNICODE 0x0374
                    UNICODE Decomposition: [02B9] 
              GREEK LOWER NUMERAL SIGN, Aristeri keraia, UNICODE 0x0375
              GREEK YPOGEGRAMMENI,
                    GREEK SPACING IOTA BELOW, UNICODE 0x037A 
              GREEK QUESTION MARK, Erotimatiko, UNICODE 0x037E,
                    UNICODE Decomposition: [003B] 
              GREEK TONOS,
                    GREEK SPACING TONOS, UNICODE 0x0384
              GREEK DIALYTIKA TONOS,
                    GREEK SPACING DIAERESIS TONOS, UNICODE 0x0385
              GREEK CAPITAL LETTER ALPHA WITH TONOS,
                    GREEK CAPITAL LETTER ALPHA TONOS, UNICODE 0x0386,
                    UNICODE Decomposition: [0391] & [0384] 
                    rfc1345: GREEK CAPITAL LETTER ALPHA WITH ACUTE,
                             coding: A% 
              GREEK SMALL LETTER ALPHA WITH TONOS,
	            GREEK SMALL LETTER ALPHA TONOS, UNICODE 0x03AC,
		    UNICODE Decomposition: [03B1] & [0384] 
                    rfc1345: GREEK SMALL LETTER ALPHA WITH ACUTE
                             coding: a%
              GREEK ANO TELEIA, UNICODE 0x0387,
                    UNICODE Decomposition: [00B7] 
              GREEK CAPITAL LETTER EPSILON WITH TONOS, UNICODE 0x0388,
                    UNICODE Decomposition: [0395] & [0384] 
                    rfc1345: GREEK CAPITAL LETTER EPSILON WITH ACUTE
                             coding: E%
              GREEK SMALL LETTER EPSILON WITH TONOS,
	            GREEK SMALL LETTER EPSILON TONOS, UNICODE 0x03AD,
                    UNICODE Decomposition: [03B5] & [0384] 
                    rfc1345: GREEK SMALL LETTER EPSILON WITH ACUTE
                             coding: e%
              GREEK CAPITAL LETTER ETA WITH TONOS,
                    GREEK CAPITAL LETTER ETA TONOS, UNICODE 0x0389,
                    UNICODE Decomposition: [0397] & [0384] 
                    rfc1345: GREEK CAPITAL LETTER ETA WITH ACUTE
                             coding: Y%
              GREEK SMALL LETTER ETA WITH TONOS,
                    GREEK SMALL LETTER ETA TONOS, UNICODE 0x03AE,
		    UNICODE Decomposition: [03B7] & [0384] 
                    rfc1345: GREEK SMALL LETTER ETA WITH ACUTE
                             coding: y%
              GREEK CAPITAL LETTER IOTA WITH TONOS,
                    GREEK CAPITAL LETTER IOTA TONOS, UNICODE 0x038A,
                    UNICODE Decomposition: [0399] & [0384]
                    rfc1345: GREEK CAPITAL LETTER IOTA WITH ACUTE
                             coding: I%
              GREEK SMALL LETTER IOTA WITH TONOS,
                    GREEK SMALL LETTER IOTA TONOS, UNICODE 0x03AF,
                    UNICODE Decomposition: [03B9] & [0384] 
		    rfc1345: GREEK SMALL LETTER IOTA WITH ACUTE,
		             coding: i%
              GREEK CAPITAL LETTER OMICRON WITH TONOS,
                    GREEK CAPITAL LETTER OMICRON TONOS, UNICODE 0x038C,
                    UNICODE Decomposition: [039F] & [0384] 
                    rfc1345: GREEK CAPITAL LETTER OMICRON WITH ACUTE
		             coding: O%              
	      GREEK SMALL LETTER OMICRON WITH TONOS,
	            GREEK SMALL LETTER OMICRON TONOS, UNICODE 0x03CC,
		    UNICODE Decomposition: [03BF] & [0384] 
		    rfc1345: GREEK SMALL LETTER OMICRON WITH ACUTE
		             coding: o%
              GREEK CAPITAL LETTER UPSILON WITH TONOS,
                    GREEK CAPITAL LETTER UPSILON TONOS, UNICODE 0x038E,
                    UNICODE Decomposition: [03A5] & [0384] 
                    rfc1345: GREEK CAPITAL LETTER UPSILON WITH ACUTE
                             coding: U%
              GREEK SMALL LETTER UPSILON WITH TONOS,
	            GREEK SMALL LETTER UPSILON TONOS, UNICODE 0x03CD,
		    UNICODE Decomposition: [03C5] & [0384] 
		    rfc1345: GREEK SMALL LETTER UPSILON WITH ACUTE
		             coding: u%
              GREEK CAPITAL LETTER OMEGA WITH TONOS,
	            GREEK CAPITAL LETTER OMEGA TONOS, UNICODE 0x038F,
                    UNICODE Decomposition: [03A9] & [0384] 
                    rfc1345: GREEK CAPITAL LETTER OMEGA WITH ACUTE
                             coding: W%
              GREEK SMALL LETTER OMEGA WITH TONOS,
	            GREEK SMALL LETTER OMEGA TONOS, UNICODE 0x03CE,
		    UNICODE Decomposition: [03C9] & [0384] 
		    rfc1345: GREEK SMALL LETTER OMEGA WITH ACUTE
		             coding: w%
              GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS,
                    GREEK SMALL LETTER IOTA DIAERESIS TONOS, UNICODE 0x0390,
                    UNICODE Decomposition: [03B9] & [0385] 
                    rfc1345: GREEK SMALL LETTER IOTA WITH ACUTE AND DIAERESIS
                             coding: i3     
              GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS,
	            GREEK SMALL LETTER UPSILON DIAERESIS TONOS, UNICODE 0x03B0,
		    UNICODE Decomposition: [03C5] & [0385] 
		    rfc1345: GREEK SMALL LETTER UPSILON WITH ACUTE AND DIAERESIS
		             coding: u3           */
              
  /*  (Alpha) GREEK CAPITAL LETTER ALPHA */
  { "A", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x41,      -1,      -1,
		   -1,   0x0391,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "A*", "GREEK CAPITAL LETTER ALPHA" } },
  /*  (alpha) GREEK SMALL LETTER ALPHA */
  { "a", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      224,   0x61,      -1,      -1,
		   -1,   0x03b1,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "a*", "GREEK SMALL LETTER ALPHA" } },  
  /*  (Beta) GREEK CAPITAL LETTER BETA */
  { "B", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x62|FC_fallback,      
		                              -1,      -1,
		   -1,   0x0392,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "B*", "GREEK CAPITAL LETTER BETA" } },
  /*  (beta) GREEK SMALL LETTER BETA */
  { "b", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      225,   0x62,      -1,      -1,
		   -1,   0x03b2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "b*", "GREEK SMALL LETTER BETA" } },   
  /*  (Gamma) GREEK CAPITAL LETTER GAMMA */
  { "[Gamma]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      226,   0x47,      -1,      -1,
		   -1,   0x0393,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "G*", "GREEK CAPITAL LETTER GAMMA" } },
  /*  (gamma) GREEK SMALL LETTER GAMMA */
  { "[gamma]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x67,      -1,        -1,
		   -1,   0x03b3,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "g*", "GREEK SMALL LETTER GAMMA" } },
  /*  (Delta) GREEK CAPITAL LETTER DELTA */
  { "[Delta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x44,      -1,    0xC6,
		   -1,   0x0394,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "D*", "GREEK CAPITAL LETTER DELTA" } },   
  /*  (delta) GREEK SMALL LETTER DELTA */
  { "[delta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      235,   0x64,      -1,      -1,
		   -1,   0x03b4,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "d*", "GREEK SMALL LETTER DELTA" } },   
  /*  (Epsilon) GREEK CAPITAL LETTER EPSILON */
  { "E", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x65|FC_fallback,      
                                              -1,      -1,
		   -1,   0x0395,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "E*", "GREEK CAPITAL LETTER EPSILON" } },
  /*  (epsilon) GREEK SMALL LETTER EPSILON */
  { "e", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x65,      -1,      -1,
		   -1,   0x03b5,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "e*", "GREEK SMALL LETTER EPSILON" } },   
  /*  (Zeta) GREEK CAPITAL LETTER ZETA */
  { "[Zeta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x7A|FC_fallback,      
                                              -1,      -1,
		   -1,   0x0396,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Z*", "GREEK CAPITAL LETTER ZETA" } },   
  /*  (zeta) GREEK SMALL LETTER ZETA */
  { "[zeta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x7A,      -1,      -1,
		   -1,   0x03b6,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "z*", "GREEK SMALL LETTER ZETA" } },   
  /*  (Eta) GREEK CAPITAL LETTER ETA */
  { "[Eta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x68|FC_fallback,      
                                              -1,      -1,
		   -1,   0x0397,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Y*", "GREEK CAPITAL LETTER ETA" } },   
  /*  (eta) GREEK SMALL LETTER ETA */
  { "[eta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x68,      -1,      -1,
		   -1,   0x03b7,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "y*", "GREEK SMALL LETTER ETA" } },   
  /*  (Theta) GREEK CAPITAL LETTER THETA */
  { "[Theta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      237|FC_fallback,   
		                   0x4A,      -1,      -1,
		   -1,   0x0398,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "H*", "GREEK CAPITAL LETTER THETA" } }, 
  /*  (theta) GREEK SMALL LETTER THETA */
  { "[theta]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      233,   0x6A,      -1,      -1,
		   -1,   0x03b8,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "h*", "GREEK SMALL LETTER THETA" } }, 
  /*  (Iota) GREEK CAPITAL LETTER IOTA */
  { "I", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x69|FC_fallback,      
                                              -1,      -1,
		   -1,   0x0399,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "I*", "GREEK CAPITAL LETTER IOTA" } },   
  /*  (iota) GREEK SMALL LETTER IOTA */
  { "i", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x69,      -1,      -1,
		   -1,   0x03b9,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "i*", "GREEK SMALL LETTER IOTA" } },   
  /*  (Kappa) GREEK CAPITAL LETTER KAPPA */
  { "K", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x6B|FC_fallback,      
                                              -1,      -1,
		   -1,   0x039a,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "K*", "GREEK CAPITAL LETTER KAPPA" } },   
  /*  (kappa) GREEK SMALL LETTER KAPPA */
  { "k", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x6B,      -1,      -1,
		   -1,   0x03ba,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "k*", "GREEK SMALL LETTER KAPPA" } },   
  /*  (Lamda) 
      GREEK CAPITAL LETTER LAMDA 
      GREEK CAPITAL LETTER LAMBDA */
  { "[Lamda]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x4C,      -1,      -1,
		   -1,   0x039b,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "L*", "GREEK CAPITAL LETTER LAMDA" } },   
  /*  (lamda) 
      GREEK SMALL LETTER LAMDA 
      GREEK SMALL LETTER LAMBDA */
  { "[lamda]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x6C,      -1,      -1,
		   -1,   0x03bb,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "l*", "GREEK SMALL LETTER LAMDA" } },  
  /*  (Mu) GREEK CAPITAL LETTER MU */
  { "[Mu]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x039c,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "M*", "GREEK CAPITAL LETTER MU" } },   
  /* (mu) GREEK SMALL LETTER MU */
  { "[mu]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      230,     -1,      -1,        -1,
		     /* There isn't mu in Techinical font ?????? */
		   -1,   0x03bc,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "m*", "GREEK SMALL LETTER MU" } },
  /*  (Nu) GREEK CAPITAL LETTER NU */
  { "[Nu]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x6E|FC_fallback,      
                                              -1,      -1,
		   -1,   0x039d,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "N*", "GREEK CAPITAL LETTER NU" } },   
  /*  (nu) GREEK SMALL LETTER NU */
  { "[nu]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x6E,      -1,      -1,
		   -1,   0x03bd,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "n*", "GREEK SMALL LETTER NU" } },  
  /*  (Xi) GREEK CAPITAL LETTER XI */
  { "[Xi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x58,      -1,      -1,
		   -1,   0x039e,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "C*", "GREEK CAPITAL LETTER XI" } },   
  /*  (xi) GREEK SMALL LETTER XI */
  { "[xi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x78,      -1,      -1,
		   -1,   0x03be,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "c*", "GREEK SMALL LETTER XI" } },   
  /*  (Omicron) GREEK CAPITAL LETTER OMICRON */
  { "O", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x039f,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "O*", "GREEK CAPITAL LETTER OMICRON" } },   
  /*  (omicron) GREEK SMALL LETTER OMICRON */
  { "o", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x03bf,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "o*", "GREEK SMALL LETTER OMICRON" } },   
  /* (mul/Pi) GREEK CAPITAL LETTER PI */
  { "[Pi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      0x7B | FC_fallback,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      227|FC_fallback,   0x50,      -1,    0xB8,
		   -1,   0x03a0,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "P*", "GREEK CAPITAL LETTER PI" } },
  /* (pi) GREEK SMALL LETTER PI */
  { "[pi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,    0x7B | FC_uncertain,      
		                                       -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      227,   0x70,      -1,    0xB9,
		   -1,   0x03c0,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "p*", "GREEK SMALL LETTER PI" } },   
  /*  (Rho) GREEK CAPITAL LETTER RHO */
  { "P", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x72|FC_fallback,      
                                              -1,      -1,
		   -1,   0x03a1,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "R*", "GREEK CAPITAL LETTER RHO" } },   
  /* (rho) GREEK SMALL LETTER RHO */
  { "p", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x72,      -1,    0xB6,
		   -1,   0x03c1,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "r*", "GREEK SMALL LETTER RHO" } }, 
   /* Which character this is ?????????????????? */
  /* GREEK SMALL LETTER FINAL SIGMA */
  { "[final sigma]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x03c2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "*s", "GREEK SMALL LETTER FINAL SIGMA" } },
  /* (sum/Sigma) GREEK CAPITAL LETTER SIGMA */
  { "[Sigma]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      228,    0x53,     -1,    0xB7,
		   -1,   0x03a3,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "S*", "GREEK CAPITAL LETTER SIGMA" } },  
  /* (sigma) GREEK SMALL LETTER SIGMA */
  { "[sigma]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      229,    0x73,      -1,     -1,
		   -1,   0x03c3,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "s*", "GREEK SMALL LETTER SIGMA" } }, 
  /*  (Tau) GREEK CAPITAL LETTER TAU */
  { "T", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x74|FC_fallback,      
                                              -1,      -1,
		   -1,   0x03a4,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "T*", "GREEK CAPITAL LETTER TAU" } },   
  /*  (tau) GREEK SMALL LETTER TAU */
  { "t", {0,0},1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      231,   0x74,      -1,        -1,
		   -1,   0x03c4,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "t*", "GREEK SMALL LETTER TAU" } },
  /*  (Upsilon) GREEK CAPITAL LETTER UPSILON */
  { "[Upsilon]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x59,      -1,      -1,
		   -1,   0x03a5,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "U*", "GREEK CAPITAL LETTER UPSILON" } },   
  /*  (upsilon) GREEK SMALL LETTER UPSILON */
  { "[upsilon]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x79,      -1,      -1,
		   -1,   0x03c5,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "u*", "GREEK SMALL LETTER UPSILON" } },
  /*  (Phi) GREEK CAPITAL LETTER PHI */
  { "[Phi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      232,    0x46,     -1,      -1,
		   -1,   0x03a6,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "F*", "GREEK CAPITAL LETTER PHI" } }, 
  /*  (phi) GREEK SMALL LETTER PHI */
  { "[phi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,    0x66,     -1,      -1,
		   -1,   0x03c6,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "f*", "GREEK SMALL LETTER PHI" } },  
  /*  (Chi) GREEK CAPITAL LETTER CHI */
  { "X", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x63|FC_fallback,     
                                              -1,      -1,
		   -1,   0x03a7,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "X*", "GREEK CAPITAL LETTER CHI" } },  
  /*  (chi) GREEK SMALL LETTER CHI */
  { "x", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x63,      -1,      -1,
		   -1,   0x03c7,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "x*", "GREEK SMALL LETTER CHI" } },   
  /*  (Psi) GREEK CAPITAL LETTER PSI */
  { "[Psi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x51,     -1,      -1,
		   -1,   0x03a8,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Q*", "GREEK CAPITAL LETTER PSI" } },  
  /*  (psi) GREEK SMALL LETTER PSI */
  { "[psi]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x71,     -1,      -1,
		   -1,   0x03c8,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "q*", "GREEK SMALL LETTER PSI" } },  
  /*  (Omega) GREEK CAPITAL LETTER OMEGA */
  { "[Omega]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      234,   0x57,      -1,        -1,
		   -1,   0x03a9,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "W*", "GREEK CAPITAL LETTER OMEGA" } },
  /*  (omega) GREEK SMALL LETTER OMEGA */
  { "[omega]", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x77,      -1,    0xBD,
		   -1,   0x03c9,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "w*", "GREEK SMALL LETTER OMEGA" } },  
  /* Missing: GREEK CAPITAL LETTER IOTA WITH DIALYTIKA,
                    GREEK CAPITAL LETTER IOTA DIAERESIS, UNICODE 0x03AA,
                    UNICODE Decomposition: [0399] & [0308] 
                    rfc1345: GREEK CAPITAL LETTER IOTA WITH DIAERESIS
                             coding: J*
              GREEK SMALL LETTER IOTA WITH DIALYTIKA,
	            GREEK SMALL LETTER IOTA DIAERESIS, UNICODE 0x03CA,
		    UNICODE Decomposition: [03B9] & [0308] 
                    rfc1345: GREEK SMALL LETTER IOTA WITH DIAERESIS
                             coding: j*
              GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA,
	            GREEK CAPITAL LETTER UPSILON DIAERESIS, UNICODE 0x03AB
                    UNICODE Decomposition: [03A5] & [0308] 
                    rfc1345: GREEK CAPITAL LETTER UPSILON WITH DIAERESIS
                             coding: V*                 
              GREEK SMALL LETTER UPSILON WITH DIALYTIKA,
	            GREEK SMALL LETTER UPSILON DIAERESIS, UNICODE 0x03CB,
		    UNICODE Decomposition: [03C5] & [0308] 
                    rfc1345: GREEK SMALL LETTER UPSILON WITH DIAERESIS
		             coding: v*
              GREEK BETA SYMBOL,
	            GREEK SMALL LETTER CURLED BETA, UNICODE 0x03D0
              GREEK THETA SYMBOL,
	            GREEK SMALL LETTER SCRIPT THETA, UNICODE 0x03D1
              GREEK UPSILON WITH HOOK SYMBOL,
	            GREEK CAPITAL LETTER UPSILON HOOK, UNICODE 0x03D2
              GREEK UPSILON WITH ACUTE AND HOOK SYMBOL,
	            GREEK CAPITAL LETTER UPSILON HOOK TONOS, UNICODE 0x03D3,
		    UNICODE Decomposition: [03D2] & [0384] 
              GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL,
	            GREEK CAPITAL LETTER UPSILON HOOK DIAERESIS, UNICODE 0x03D4,
		    UNICODE Decomposition: [03D2] & [0308] 
              GREEK PHI SYMBOL,
                    GREEK SMALL LETTER SCRIPT PHI, UNICODE 0x03D5
              GREEK PI SYMBOL,
	            GREEK SMALL LETTER OMEGA PI, UNICODE 0x03D6
              Only in rfc1345 (not in UNICODE):
	            'G     03d8    GREEK NUMERAL SIGN
		    ,G     03d9    GREEK LOWER NUMERAL SIGN
	      GREEK LETTER STIGMA,
	            GREEK CAPITAL LETTER STIGMA, UNICODE 0x03DA
		    rfc1345 coding: T3
              Only in rfc1345 (not in UNICODE):
	            t3     03db    GREEK SMALL LETTER STIGMA
              GREEK LETTER DIGAMMA,
	            GREEK CAPITAL LETTER DIGAMMA, UNICODE 0x03DC
		    rfc1345 coding: M3
              Only in rfc1345 (not in UNICODE):
	            m3     03dd    GREEK SMALL LETTER DIGAMMA
              GREEK LETTER KOPPA,
	            GREEK CAPITAL LETTER KOPPA, UNICODE 0x03DE
		    rfc1345 coding: K3
	      Only in rfc1345 (not in UNICODE):
	            k3     03df    GREEK SMALL LETTER KOPPA
              GREEK LETTER SAMPI,
	            GREEK CAPITAL LETTER SAMPI, UNICODE 0x03E0
		    rfc1345 coding: P3
              Only in rfc1345 (not in UNICODE):
	            p3     03e1    GREEK SMALL LETTER SAMPI
              COPTIC CAPITAL LETTER SHEI,
	             GREEK CAPITAL LETTER SHEI, UNICODE 0x03E2
              COPTIC SMALL LETTER SHEI,
	             GREEK SMALL LETTER SHEI, UNICODE 0x03E3
	      COPTIC CAPITAL LETTER FEI,
	             GREEK CAPITAL LETTER FEI, UNICODE 0x03E4
              COPTIC SMALL LETTER FEI,
	             GREEK SMALL LETTER FEI, UNICODE 0x03E5
              COPTIC CAPITAL LETTER KHEI,
	             GREEK CAPITAL LETTER KHEI, UNICODE 0x03E6
              COPTIC SMALL LETTER KHEI,
	             GREEK SMALL LETTER KHEI, UNICODE 0x03E7
              COPTIC CAPITAL LETTER HORI,
	             GREEK CAPITAL LETTER HORI, UNICODE 0x03E8
              COPTIC SMALL LETTER HORI,
	             GREEK SMALL LETTER HORI, UNICODE 0x03E9
              COPTIC CAPITAL LETTER GANGIA,
	             GREEK CAPITAL LETTER GANGIA, UNICODE 0x03EA
              COPTIC SMALL LETTER GANGIA,
	             GREEK SMALL LETTER GANGIA, UNICODE 0x03EB
              COPTIC CAPITAL LETTER SHIMA,
	             GREEK CAPITAL LETTER SHIMA, UNICODE 0x03EC
              COPTIC SMALL LETTER SHIMA,
	             GREEK SMALL LETTER SHIMA, UNICODE 0x03ED
              COPTIC CAPITAL LETTER DEI,
	             GREEK CAPITAL LETTER DEI, UNICODE 0x03EE
              COPTIC SMALL LETTER DEI,
	             GREEK SMALL LETTER DEI, UNICODE 0x03EF
              GREEK KAPPA SYMBOL,
	            GREEK SMALL LETTER SCRIPT KAPPA, UNICODE 0x03F0
              GREEK RHO SYMBOL,
	            GREEK SMALL LETTER TAILED RHO, UNICODE 0x03F1
              GREEK LUNATE SIGMA SYMBOL,
                    GREEK SMALL LETTER LUNATE SIGMA, UNICODE 0x03F2
              GREEK LETTER YOT, UNICODE 0x03F3
	      Only in rfc1345 (not in INICODE):
                    '%     03f4    ACUTE ACCENT AND DIAERESIS (Tonos and Dialytika)
		    j3     03f5    GREEK IOTA BELOW
*/


  /* Some graphics and special characters */
  /* Missing: EN QUAD, UNICODE 0x2000,
                 UNICODE Decomposition: <font variant> [0020] 
              EM QUAD, UNICODE 0x2001,
                 UNICODE Decomposition: <font variant> [0020] 
              EN SPACE, UNICODE 0x2002,
	         UNICODE Decomposition: <font variant> [0020] 
              EM SPACE, UNICODE 0x2003,
                 UNICODE Decomposition: <font variant> [0020] 
              THREE-PER-EM SPACE, UNICODE 0x2004,
                           UNICODE Decomposition: <font variant> [0020] 
              FOUR-PER-EM SPACE, UNICODE 0x2005,
                          UNICODE Decomposition: <font variant> [0020] 
              SIX-PER-EM SPACE, UNICODE 0x2006,
	                 UNICODE Decomposition: <font variant> [0020] 
              FIGURE SPACE, UNICODE 0x2007,
	             UNICODE Decomposition: <font variant> [0020] 
              PUNCTUATION SPACE, UNICODE 0x2008,
	                  UNICODE Decomposition: <font variant> [0020] 
              THIN SPACE, UNICODE 0x2009,
	           UNICODE Decomposition: <font variant> [0020] 
	      HAIR SPACE, UNICODE 0x200A,
	           UNICODE Decomposition: <font variant> [0020] 
              ZERO WIDTH SPACE, UNICODE 0x200B
              ZERO WIDTH NON-JOINER, UNICODE 0x200C
              ZERO WIDTH JOINER, UNICODE 0x200D
              LEFT-TO-RIGHT MARK, UNICODE 0x200E
              RIGHT-TO-LEFT MARK, UNICODE 0x200F */
  /* HYPHEN */   
  { "-", {0,0}, 1, &CH_HY2,
      { 0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,0x2D|FC_fallback,-1,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,   0x2010,   0x2D|FC_fallback,        0x2D|FC_fallback,       0x2D|FC_fallback,
	0x2D|FC_fallback,        0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,       0x2D|FC_fallback,
                     0x2D|FC_fallback,     0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,
                   0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback },
      { "-1", "HYPHEN" } }, 
  /* NON-BREAKING HYPHEN */   
  { "-", {0,0}, 0,&CH_NBHY,
      { 0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,0x2D|FC_fallback,-1,0x2D|FC_fallback,0x2D|FC_fallback,
	0x2D|FC_fallback,   0x2011,   0x2D|FC_fallback,        0x2D|FC_fallback,       0x2D|FC_fallback,
	0x2D|FC_fallback,        0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,       0x2D|FC_fallback,
                     0x2D|FC_fallback,     0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,
                   0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback,      0x2D|FC_fallback },
        /* UNICODE Composition: <no-break> [2010] <no-break> */
      { NULL, "NON-BREAKING HYPHEN" } }, /* Not in RFC1345! */
  /* FIGURE DASH */
  { "-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2012,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "FIGURE DASH" } },  /* Not in RFC1345! */
  /*  EN DASH  (macron) */
  { "-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xD0,
		   -1,   0x2013,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "-N", "EN DASH" } },  
  /*  EM DASH */
  { "-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2014,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "-M", "EM DASH" } },  
  /* HORIZONTAL BAR
     QUOTATION DASH */
  { "--", {0,0}, 1,NULL,
      {            -1,       -1,     -1,0x72|FC_fallback,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1, 196|FC_fallback,     -1,      -1,      -1,
		   -1,   0x2015,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "-3", "HORIZONTAL BAR" } },
  /* DOUBLE VERTICAL LINE
     DOUBLE VERTICAL BAR */
  { "!!", {0,0}, 1,NULL,
      {            -1,       -1,     -1,0x78|FC_fallback,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1, 186|FC_fallback,     -1,      -1,      -1,
		   -1,   0x2016,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "!2", "DOUBLE VERTICAL LINE" } }, 
  /* DOUBLE LOW LINE
     SPACING DOUBLE UNDERSCORE */
  { "_", {0,0}, 1,NULL,
      {            -1,       -1,     -1,0x73|FC_fallback,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1, 205|FC_fallback,     -1,      -1,      -1,
		   -1,   0x2017,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Composition: [0020] & [0333] */
      { "=2", "DOUBLE LOW LINE" } },
  /* OPEN SINGLE QUOTE
     LEFT SINGLE QUOTATION MARK 
     SINGLE TURNED COMMA QUOTATION MARK
     */
  { "`", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xD4,
		   -1,   0x2018,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "'6", "LEFT SINGLE QUOTATION MARK" } },
  /*  CLOSE SINGLE QUOTE
      RIGHT SINGLE QUOTATION MARK
      SINGLE COMMA QUOTATION MARK */
  { "'", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xD5,
		   -1,   0x2019,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "'9", "RIGHT SINGLE QUOTATION MARK" } },
  /* Missing: SINGLE LOW-9 QUOTATION MARK,
                     LOW SINGLE COMMA QUOTATION MARK, UNICODE 0x201A
		     rfc1345 encoding: .9
              SINGLE HIGH-REVERSED-9 QUOTATION MARK,
	             SINGLE REVERSED COMMA QUOTATION MARK, UNICODE 0x201B
                     rfc1345 encoding: 9'
		     */
  /*  OPEN DOUBLE QUOTE
      LEFT DOUBLE QUOTATION MARK 
      DOUBLE TURNED COMMA QUOTATION MARK */
  { "``", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xD2,
		   -1,   0x201c,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "\"6", "LEFT DOUBLE QUOTATION MARK" } },
  /*  CLOSE DOUBLE QUOTE
      RIGHT DOUBLE QUOTATION MARK 
      DOUBLE COMMA QUOTATION MARK */
  { "''", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xD3,
		   -1,   0x201d,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1 },
      { "\"9", "RIGHT DOUBLE QUOTATION MARK" } },
  /* Missing: DOUBLE LOW-9 QUOTATION MARK,
                     LOW DOUBLE COMMA QUOTATION MARK, UNICODE 0x201E
                     rfc1345 encoding: :9
              DOUBLE HIGH-REVERSED-9 QUOTATION MARK,
	             DOUBLE REVERSED COMMA QUOTATION MARK, UNICODE 0x201F
                     rfc1345 encoding: 9"
		     */ 
  /* DAGGER */
  { "+", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xA0,
		   -1,   0x2020,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "/-", "DAGGER" } }, 
  /* DOUBLE DAGGER */
  { "+", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2021,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "/=", "DOUBLE DAGGER" } }, 
  /* BULLET */
  { ".", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2022,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "BULLET" } }, /* Not in RFC1345! */
  /* TRIANGULAR BULLET */
  { ".:", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x40 | FC_fallback
		     /* Is this correct ? */,      
                                              -1,      -1,
		   -1,   0x2023,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "TRIANGULAR BULLET" } }, /* Not in RFC1345! */
  /* ONE DOT LEADER */
  { ".", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2024,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      /* UNICODE Decomposition: [002E] */
      { NULL, "ONE DOT LEADER" } }, /* Not in RFC1345! */
  /* TWO DOT LEADER */
  { "..", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2025,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      /* UNICODE Decomposition: [002E] & [002E]  */
      { "..", "TWO DOT LEADER" } }, 
  /* HORIZONTAL ELLIPSIS */
  { "...", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2026,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      /* UNICODE Decomposition: [002E] & [002E] & [002E] */
      { NULL, "HORIZONTAL ELLIPSIS" } }, /* Not in RFC1345! */
  /* HYPHENATION POINT */   
  { "-", {0,0}, 0, &CH_SHY2,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2027,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "HYPHENATION POINT" } }, /* Not in RFC1345! */
  { "[LSEP]", {0,0}, 0, &CH_LSEP,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2028,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LINE SEPARATOR" } }, /* Not in RFC1345! */
  { "[PSEP]", {0,0}, 0, &CH_PSEP,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2029,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "PARAGRAPH SEPARATOR" } }, /* Not in RFC1345! */
  /* Missing: LEFT-TO-RIGHT EMBEDDING, UNICODE 0x202A
	      RIGHT-TO-LEFT EMBEDDING, UNICODE 0x202B
	      POP DIRECTIONAL FORMATTING, UNICODE 0x202C
	      LEFT-TO-RIGHT OVERRIDE, UNICODE 0x202D
	      RIGHT-TO-LEFT OVERRIDE, UNICODE 0x202E
	      PER MILLE SIGN, UNICODE 0x2030
	          rfc1345 encoding: %0
	      PER TEN THOUSAND SIGN, UNICODE 0x2031
	      PRIME, UNICODE 0x2032
	           rfc1345 encoding: 1'
              DOUBLE PRIME, UNICODE 0x2033,
	             UNICODE Decomposition: [2032] & [2032] 
		     rfc1345 encoding: 2'
              TRIPLE PRIME, UNICODE 0x2034,
	             UNICODE Decomposition: [2032] & [2032] & [2032] 
		     rfc1345 encoding: 3'
	      REVERSED PRIME, UNICODE 0x2035
	               rfc1345 encoding: 1"
              REVERSED DOUBLE PRIME, UNICODE 0x2036,
	               UNICODE Decomposition: [2035] & [2035]
		       rfc1345 encoding: 2"
	      REVERSED TRIPLE PRIME, UNICODE 0x2037,
	               UNICODE Decomposition: [2035] & [2035] & [2035]
		       rfc1345 encoding: 3" */
  /* CARET */
  { "^", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x4C|FC_fallback,-1,      -1,
		   -1,   0x2038,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Ca", "CARET" } }, 
  /* SINGLE LEFT-POINTING ANGLE QUOTATION MARK
     LEFT POINTING SINGLE GUILLEMET */
  { "<", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2039,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "<1", "SINGLE LEFT-POINTING ANGLE QUOTATION MARK" } }, 
  /* SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
     RIGHT POINTING SINGLE GUILLEMET */
  { ">", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x203A,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ">1", "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK" } }, 
  /* REFERENCE MARK */
  { ":", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x203B,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ":X", "REFERENCE MARK" } },
  /* DOUBLE EXCLAMATION MARK */
  { "!!", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x203C,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Composition: [0021] & [0021]  */
      { "!*2", "DOUBLE EXCLAMATION MARK" } }, 
  /* Missing: INTERROBANG, UNICODE 0x203D */
  /* OVERLINE, SPACING OVERSCORE */
  { "-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x203E,   0x7E,        -1,   0x7E,
		   -1,       -1,      -1,      -1,    -1,
		 0x7E,       -1,   0x7E,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Composition: [0020] & [0305]  */
      { "'-", "OVERLINE" } }, 
  /* Missing: UNDERTIE, Enotikon, UNICODE 0x203F
              CHARACTER TIE, UNICODE 0x2041
	      ASTERISM, UNICODE 0x2042
	      HYPHEN BULLET, UNICODE 0x2043
	      FRACTION SLASH, UNICODE 0x2044
                       rfc1345 encoding: /f
	      LEFT SQUARE BRACKET WITH QUILL, UNICODE 0x2045
	      RIGHT SQUARE BRACKET WITH QUILL, UNICODE 0x2046
	      INHIBIT SYMMETRIC SWAPPING, UNICODE 0x206A
	      ACTIVATE SYMMETRIC SWAPPING, UNICODE 0x206B
	      INHIBIT ARABIC FORM SHAPING, UNICODE 0x206C
	      ACTIVATE ARABIC FORM SHAPING, UNICODE 0x206D
	      NATIONAL DIGIT SHAPES, UNICODE 0x206E
	      NOMINAL DIGIT SHAPES, UNICODE 0x206F */
  /* SUPERSCRIPT ZERO
     SUPERSCRIPT DIGIT ZERO */
  { "^0", {'^','0'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2070,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0030] <-sup> */
      { "0S", "SUPERSCRIPT ZERO" } }, 
  /* SUPERSCRIPT FOUR
     SUPERSCRIPT DIGIT FOUR */
  { "^4", {'^','4'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2074,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0034] <-sup> */
      { "4S", "SUPERSCRIPT FOUR" } }, 
  /* SUPERSCRIPT FIVE
     SUPERSCRIPT DIGIT FIVE */
  { "^5", {'^','5'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2075,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0035] <-sup> */
      { "5S", "SUPERSCRIPT FIVE" } }, 
  /* SUPERSCRIPT SIX
     SUPERSCRIPT DIGIT SIX */
  { "^6", {'^','6'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2076,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0036] <-sup> */
      { "6S", "SUPERSCRIPT SIX" } }, 
  /* SUPERSCRIPT SEVEN
     SUPERSCRIPT DIGIT SEVEN */
  { "^7", {'^','7'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2077,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0037] <-sup> */
      { "7S", "SUPERSCRIPT SEVEN" } }, 
  /* SUPERSCRIPT EIGHT
     SUPERSCRIPT DIGIT EIGHT */
  { "^8", {'^','8'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2078,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0038] <-sup> */
      { "8S", "SUPERSCRIPT EIGHT" } }, 
  /* SUPERSCRIPT NINE
     SUPERSCRIPT DIGIT NINE */
  { "^9", {'^','9'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2079,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0039] <-sup> */
      { "9S", "SUPERSCRIPT NINE" } }, 
  /* SUPERSCRIPT PLUS SIGN */
  { "^+", {'^','+'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x207A,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [002B] <-sup> */
      { "+S", "SUPERSCRIPT PLUS SIGN" } }, 
  /* SUPERSCRIPT MINUS
     SUPERSCRIPT HYPHEN-MINUS */
  { "^-", {'^','-'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x207B,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [2212] <-sup> */
      { "-S", "SUPERSCRIPT MINUS" } }, 
  /* SUPERSCRIPT EQUALS SIGN */
  { "^=", {'^','='}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x207C,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [003D] <-sup> */
      { "=S", "SUPERSCRIPT EQUALS SIGN" } }, 
  /* SUPERSCRIPT LEFT PARENTHESIS
     SUPERSCRIPT OPENING PARENTHESIS */
  { "^(", {'^','('}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x207D,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0028] <-sup> */
      { "(S", "SUPERSCRIPT LEFT PARENTHESIS" } }, 
  /* SUPERSCRIPT RIGHT PARENTHESIS
     SUPERSCRIPT CLOSING PARENTHESIS */
  { "^)", {'^',')'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x207E,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0029] <-sup> */
      { ")S", "SUPERSCRIPT RIGHT PARENTHESIS" } },
  /* SUPERSCRIPT LATIN SMALL LETTER N */
  { "^n", {'^','n'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      252,     -1,      -1,      -1,
		   -1,   0x207F,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [006E] <-sup> */
      { "nS", "SUPERSCRIPT LATIN SMALL LETTER N" } },
  /* SUBSCRIPT ZERO
     SUBSCRIPT DIGIT ZERO */
  { "_0", {'_','0'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2080,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0030] <-sub>  */
      { "0s", "SUBSCRIPT ZERO" } },
  /* SUBSCRIPT ONE
     SUBSCRIPT DIGIT ONE */
  { "_1", {'_','1'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2081,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0031] <-sub>  */
      { "1s", "SUBSCRIPT ONE" } },
  /* SUBSCRIPT TWO
     SUBSCRIPT DIGIT TWO */
  { "_2", {'_','2'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2082,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0032] <-sub>  */
      { "2s", "SUBSCRIPT TWO" } },
  /* SUBSCRIPT THREE
     SUBSCRIPT DIGIT THREE */
  { "_3", {'_','3'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2083,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0033] <-sub>  */
      { "3s", "SUBSCRIPT THREE" } },
  /* SUBSCRIPT FOUR
     SUBSCRIPT DIGIT FOUR */
  { "_4", {'_','4'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2084,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0034] <-sub>  */
      { "4s", "SUBSCRIPT FOUR" } },
  /* SUBSCRIPT FIVE
     SUBSCRIPT DIGIT FIVE */
  { "_5", {'_','5'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2085,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0035] <-sub>  */
      { "5s", "SUBSCRIPT FIVE" } },
  /* SUBSCRIPT SIX
     SUBSCRIPT DIGIT SIX */
  { "_6", {'_','6'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2086,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0036] <-sub>  */
      { "6s", "SUBSCRIPT SIX" } },
  /* SUBSCRIPT SEVEN
     SUBSCRIPT DIGIT SEVEN */
  { "_7", {'_','7'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2087,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0037] <-sub>  */
      { "7s", "SUBSCRIPT SEVEN" } },
  /* SUBSCRIPT EIGHT
     SUBSCRIPT DIGIT EIGHT */
  { "_8", {'_','8'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2088,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0038] <-sub>  */
      { "8s", "SUBSCRIPT EIGHT" } },
  /* SUBSCRIPT NINE
     SUBSCRIPT DIGIT NINE */
  { "_9", {'_','9'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2089,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0039] <-sub>  */
      { "9s", "SUBSCRIPT NINE" } }, 
  /* SUBSCRIPT PLUS SIGN */
  { "_+", {'_','+'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x208A,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [002B] <-sub>  */
      { "+s", "SUBSCRIPT PLUS SIGN" } },
  /* SUBSCRIPT MINUS
     SUBSCRIPT HYPHEN-MINUS */
  { "_-", {'_','-'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x208B,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [2212] <-sub>  */
      { "-s", "SUBSCRIPT MINUS" } },
  /* SUBSCRIPT EQUALS SIGN */
  { "_=", {'_','='}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x208C,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [003D] <-sub>  */
      { "=s", "SUBSCRIPT EQUALS SIGN" } },
  /* SUBSCRIPT LEFT PARENTHESIS
     SUBSCRIPT OPENING PARENTHESIS */
  { "_(", {'_','('}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x208D,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0028] <-sub>  */
      { "(s", "SUBSCRIPT LEFT PARENTHESIS" } },
  /* SUBSCRIPT RIGHT PARENTHESIS
     SUBSCRIPT CLOSING PARENTHESIS */
  { "_)", {'_',')'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x208E,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sub> [0029] <-sub>  */
      { ")s", "SUBSCRIPT RIGHT PARENTHESIS" } },
  /* Missing: EURO-CURRENCY SIGN, UNICODE 0x20A0 
              COLON SIGN, UNICODE 0x20A1
	      CRUZEIRO SIGN, UNICODE 0x20A2
	      FRENCH FRANC SIGN, UNICODE 0x20A3
	      LIRA SIGN, UNICODE 0x20A4
	           rfc1345 encoding: Li
              MILL SIGN, UNICODE 20A5 
	      NAIRA SIGN, UNICODE 0x20A6 */
  /* PESETA SIGN */
  { "Pt", {'P','t'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,      158,     -1,      -1,      -1,
		   -1,   0x20A7,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Pt", "PESETA SIGN" } },
/* Missing:   RUPEE SIGN, UNICODE 0x20A8,
	            UNICODE Decomposition: [0052] & [0073] */
  /* WON SIGN */
  { "W=", {'W','='}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x20A9,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,    0x5C },
      { "W=", "WON SIGN" } },

/* Missing:   NEW SHEQEL SIGN, UNICODE 0x20AA */

  /* Missing: ACCOUNT OF, UNICODE 0x2100 
              ADDRESSED TO THE SUBJECT, UNICODE 0x2101
	      DOUBLE-STRUCK CAPITAL, 
	                    DOUBLE-STRUCK C, UNICODE 0x2102,
			    UNICODE Decomposition: <font variant> [0043] */
  /* DEGREE CELSIUS
     DEGREES CENTIGRADE */
  { "C", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2103,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [00B0] & [0043] */
      { "oC", "DEGREE CELSIUS" } },
  /* Missing: CENTRE LINE SYMBOL, C L SYMBOL, UNICODE 0x2104
              CARE OF, UNICODE 0x2105
	           rfc1345 encoding: co  
	      CADA UNA, UNICODE 0x2106
	      EULER CONSTANT, EULERS, UNICODE 0x2107,
	            UNICODE Decomposition: [0190] 
	      SCRUPLE, UNICODE 0x2108  */
  /* DEGREE FAHRENHEIT
     DEGREES FAHRENHEIT */
  { "F", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2109,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [00B0] & [0046] */
      { "oF", "DEGREE FAHRENHEIT" } },
  /* Missing: SCRIPT SMALL G, UNICODE 0x210A,
                     UNICODE Decomposition: <font variant> [0067] 
              SCRIPT CAPITAL H, SCRIPT H, UNICODE 0x210B,
	             UNICODE Decomposition: <font variant> [0048] 
	      BLACK-LETTER CAPITAL H, BLACK-LETTER H, UNICODE 0x210C,
	                   UNICODE Decomposition: <font variant> [0048] 
	      DOUBLE-STRUCK CAPITAL H, DOUBLE-STRUCK H, UNICODE 0x210D,
	                    UNICODE Decomposition: <font variant> [0048] 
	      PLANCK CONSTANT, UNICODE 0x210E,
	             UNICODE Decomposition: [0068] 
              PLANCK CONSTANT OVER TWO PI,
	             PLANCK CONSTANT OVER 2 PI, UNICODE 0x210F,
		     UNICODE Decomposition: <font variant> [0127] 
	      SCRIPT CAPITAL I, SCRIPT I, UNICODE 0x2110,
	             UNICODE Decomposition: <font variant> [0049] 
              BLACK-LETTER CAPITAL I, BLACK-LETTER I, UNICODE 0x2111,
	                   UNICODE Decomposition: <font variant> [0049] 
              SCRIPT CAPITAL L, SCRIPT L, UNICODE 0x2112,
	             UNICODE Decomposition: <font variant> [004C] 
	      SCRIPT SMALL L, UNICODE 0x2113,
	             UNICODE Decomposition: <font variant> [006C] 
	      L B BAR SYMBOL, UNICODE 0x2114
	      DOUBLE-STRUCK CAPITAL N, DOUBLE-STRUCK N, UNICODE 0x2115,
	                    UNICODE Decomposition: <font variant> [004E] */
  /* NUMERO SIGN
     NUMERO */
  { "No", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2116,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <font variant> [004E] & <+sup> [006F] & <-sup> */
      { "N0", "NUMERO SIGN" } }, 
  /* SOUND RECORDING COPYRIGHT */
  { "(P)", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2117,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "PO", "SOUND RECORDING COPYRIGHT" } },
  /* Missing: DOUBLE-STRUCK CAPITAL P, DOUBLE-STRUCK P, UNICODE 0x2119,
                            UNICODE Decomposition: <font variant> [0050] 
              DOUBLE-STRUCK CAPITAL P, DOUBLE-STRUCK P, UNICODE 0x2119,
	                    UNICODE Decomposition: <font variant> [0050] 
              DOUBLE-STRUCK CAPITAL Q, DOUBLE-STRUCK Q, UNICODE 0x211A,
	                    UNICODE Decomposition: <font variant> [0051] 
              SCRIPT CAPITAL R, SCRIPT R, UNICODE 0x211B,
	                    UNICODE Decomposition: <font variant> [0052] 
              BLACK-LETTER CAPITAL R, BLACK-LETTER R, UNICODE 0x211C,
	                    UNICODE Decomposition: <font variant> [0052] 
              DOUBLE-STRUCK CAPITAL R, DOUBLE-STRUCK R, UNICODE 0x211D,
	                    UNICODE Decomposition: <font variant> [0052] 
              PRESCRIPTION TAKE, UNICODE 0x211E
	                   rfc1345 encoding: Rx
	      RESPONSE, UNICODE 0x211F */
  /* SERVICE MARK */
  { "(SM)", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2120,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0053] & [004D] <-sup> */
      { "SM", "SERVICE MARK" } },
  /* TELEPHONE SIGN
     T E L SYMBOL */
  { "(TEL)", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2121,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0054] & [0045] & [004C] <-sup>  */
      { NULL, "TELEPHONE SIGN" } }, /* Not in RFC1345! */
  /*  TRADEMARK SIGN
      TRADE MARK SIGN 
      TRADEMARK */
  { "(TM)", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,    0xAA,
		   -1,   0x2122,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0054] & [004D] <-sup> */
      { "TM", "TRADE MARK SIGN" } }, 
  /* Missing: VERSICLE, UNICODE 0x2123
              DOUBLE-STRUCK CAPITAL Z, DOUBLE-STRUCK Z, UNICODE 0x2124,
	             UNICODE Decomposition: <font variant> [005A] 
	      OUNCE SIGN, OUNCE, UNICODE 0x2125
	      OHM SIGN, OHM, UNICODE 0x2126,
	          UNICODE Decomposition: [03A9] [03A9] 
		  rfc1345 encoding: Om
	      INVERTED OHM SIGN, MHO, UNICODE 0x2127
	      BLACK-LETTER CAPITAL Z, BLACK-LETTER Z, UNICODE 0x2128,
	            UNICODE Decomposition: <font variant> [005A] 
	      TURNED GREEK SMALL LETTER IOTA, UNICODE 0x2129 */
  /* KELVIN SIGN
     DEGREES KELVIN */
  { "K", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x212A,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004B] */
      { NULL, "KELVIN SIGN" } },
  /* Missing: ANGSTROM SIGN, ANGSTROM UNIT, UNICODE 0x212B,
                       UNICODE Decomposition: [00C5] 
		       rfc1345 encoding: AO
              SCRIPT CAPITAL B, SCRIPT B, UNICODE 0x212C,
	             UNICODE Decomposition:  <font variant> [0042] 
	      BLACK-LETTER CAPITAL C, BLACK-LETTER C, UNICODE 0x212D,
	            UNICODE Decomposition: <font variant> [0043] 
              ESTIMATED SYMBOL, UNICODE 0x212E,
	                UNICODE Decomposition: <font variant> [0065] 
              SCRIPT SMALL E, UNICODE 0x212F,
	             UNICODE Decomposition: <font variant> [0065] 
	      SCRIPT CAPITAL E, SCRIPT E, UNICODE 0x2130,
	             UNICODE Decomposition: <font variant> [0045] 
	      SCRIPT CAPITAL F, SCRIPT F, UNICODE 0x2131,
	             UNICODE Decomposition: <font variant> [0046] 
              TURNED CAPITAL F, TURNED F, UNICODE 0x2132
	      SCRIPT CAPITAL M, SCRIPT M, UNICODE 0x2133,
	             UNICODE Decomposition: <font variant> [004D] 
              SCRIPT SMALL O, UNICODE 0x2134,
	             UNICODE Decomposition: <font variant> [006F] 
              ALEF SYMBOL, FIRST TRANSFINITE CARDINAL, UNICODE 0x2135,
	           UNICODE Decomposition: [05D0] 
	      BET SYMBOL, SECOND TRANSFINITE CARDINAL, UNICODE 0x2136,
	          UNICODE Decomposition: [05D1] 
	      GIMEL SYMBOL, THIRD TRANSFINITE CARDINAL, UNICODE 0x2137,
	            UNICODE Decomposition: [05D2] 
	      DALET SYMBOL,FOURTH TRANSFINITE CARDINAL, UNICODE 0x2138,
	            UNICODE Decomposition: [05D3] */
  /* VULGAR FRACTION ONE THIRD
     FRACTION ONE THIRD */
  { "1/3", {'1','3'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2153,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0031] & [2044] & [0033] <break> */
      { "13", "VULGAR FRACTION ONE THIRD" } },  
  /* VULGAR FRACTION TWO THIRDS
     FRACTION TWO THIRDS */
  { "2/3", {'2','3'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2154,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0032] & [2044] & [0033] <break>  */
      { "23", "VULGAR FRACTION TWO THIRDS" } },  
  /* VULGAR FRACTION ONE FIFTH
     FRACTION ONE FIFTH */
  { "1/5", {'1','5'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2155,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0031] & [2044] & [0035] <break> */
      { "15", "VULGAR FRACTION ONE FIFTH" } },  
  /* VULGAR FRACTION TWO FIFTHS
     FRACTION TWO FIFTHS */
  { "2/5", {'2','5'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2156,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0032] & [2044] & [0035] <break>  */
      { "25", "VULGAR FRACTION TWO FIFTHS" } },  
  /* VULGAR FRACTION THREE FIFTHS
     FRACTION THREE FIFTHS */
  { "3/5", {'3','5'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2157,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0033] & [2044] & [0035] <break> */
      { "35", "VULGAR FRACTION THREE FIFTHS" } },  
  /* VULGAR FRACTION FOUR FIFTHS
     FRACTION FOUR FIFTHS */
  { "4/5", {'4','5'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2158,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0034] & [2044] & [0035] <break> */
      { "45", "VULGAR FRACTION FOUR FIFTHS" } },  
  /* VULGAR FRACTION ONE SIXTH
     FRACTION ONE SIXTH */
  { "1/6", {'1','6'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2159,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0031] & [2044] & [0036] <break>  */
      { "16", "VULGAR FRACTION ONE SIXTH" } },
  /* VULGAR FRACTION FIVE SIXTHS
     FRACTION FIVE SIXTHS */
  { "5/6", {'5','6'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x215A,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0035] & [2044] & [0036] <break> */
      { "56", "VULGAR FRACTION FIVE SIXTHS" } },
  /* VULGAR FRACTION ONE EIGHTH
     FRACTION ONE EIGHTH */
  { "1/8", {'1','8'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x215B,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0031] & [2044] & [0038] <break> */
      { "18", "VULGAR FRACTION ONE EIGHTH" } },
  /* VULGAR FRACTION THREE EIGHTHS
     FRACTION THREE EIGHTHS */
  { "3/8", {'3','8'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x215C,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0033] & [2044] & [0038] <break> */
      { "38", "VULGAR FRACTION THREE EIGHTHS" } },
  /* VULGAR FRACTION FIVE EIGHTHS
     FRACTION FIVE EIGHTHS */
  { "5/8", {'5','8'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x215D,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0035] & [2044] & [0038] <break> */
      { "58", "VULGAR FRACTION FIVE EIGHTHS" } },
  /* VULGAR FRACTION SEVEN EIGHTHS
     FRACTION SEVEN EIGHTHS */
  { "7/8", {'7','8'}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x215E,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0037] & [2044] & [0038] <break> */
      { "78", "VULGAR FRACTION SEVEN EIGHTHS" } },  
  /* Missing: FRACTION NUMERATOR ONE, UNICODE 0x215F,
	               UNICODE Decomposition: <break> [0031] & [2044] 
              ROMAN NUMERAL ONE, UNICODE 0x2160,
	               UNICODE Decomposition: [0049] 
		       rfc1345 encoding: 1R
              ROMAN NUMERAL TWO, UNICODE 0x2161,
	               UNICODE Decomposition: [0049] & [0049] 
		       rfc1345 encoding: 2R
              ROMAN NUMERAL THREE, UNICODE 0x2162,
	               UNICODE Decomposition: [0049] & [0049] 
		       rfc1345 encoding: 3R
              ROMAN NUMERAL FOUR, UNICODE 0x2163,
	               UNICODE Decomposition: [0049] & [0056] 
		       rfc1345 encoding: 4R
              ROMAN NUMERAL FIVE, UNICODE 0x2164,
	               UNICODE Decomposition: [0056] 
		       rfc1345 encoding: 5R
              ROMAN NUMERAL SIX, UNICODE 0x2165,
	               UNICODE Decomposition: [0056] & [0049] 
		       rfc1345 encoding: 6R
              ROMAN NUMERAL SEVEN, UNICODE 0x2166,
	               UNICODE Decomposition: [0056] & [0049] & [0049] 
		       rfc1345 encoding: 7R
              ROMAN NUMERAL EIGHT, UNICODE 0x2167,
	               UNICODE Decomposition: [0056] & [0049] & [0049] & [0049]
		       rfc1345 encoding: 8R
              ROMAN NUMERAL NINE, UNICODE 0x2168,
	               UNICODE Decomposition: [0049] & [0058] 
		       rfc1345 encoding: 9R
              ROMAN NUMERAL TEN, UNICODE 0x2169,
	               UNICODE Decomposition: [0058] 
		       rfc1345 encoding: aR
              ROMAN NUMERAL ELEVEN, UNICODE 0x216A,
	               UNICODE Decomposition: [0058] & [0049] 
		       rfc1345 encoding: bR
              ROMAN NUMERAL TWELVE, UNICODE 0x216B,
	               UNICODE Decomposition: [0058] & [0049] & [0049] 
		       rfc1345 encoding: cR
              ROMAN NUMERAL FIFTY, UNICODE 0x216C,
	               UNICODE Decomposition: [004C] 
		       rfc1345 encoding: 50R
              ROMAN NUMERAL ONE HUNDRED, UNICODE 0x216D,
	               UNICODE Decomposition: [0043] 
		       rfc1345 encoding: 100R
              ROMAN NUMERAL FIVE HUNDRED, UNICODE 0x216E,
	               UNICODE Decomposition: [0044] 
		       rfc1345 encoding: 500R
              ROMAN NUMERAL ONE THOUSAND, UNICODE 0x216F,
	               UNICODE Decomposition: [004D] 
		       rfc1345 encoding: 1000R
              SMALL ROMAN NUMERAL ONE, UNICODE 0x2170,
	               UNICODE Decomposition: [0069] 
		       rfc1345 encoding: 1r
              SMALL ROMAN NUMERAL TWO, UNICODE 0x2171,
	               UNICODE Decomposition: [0069] & [0069] 
		       rfc1345 encoding: 2r
              SMALL ROMAN NUMERAL THREE, UNICODE 0x2172,
	               UNICODE Decomposition: [0069] & [0069] 
		       rfc1345 encoding: 3r
              SMALL ROMAN NUMERAL FOUR, UNICODE 0x2173,
	               UNICODE Decomposition: [0069] & [0076] 
		       rfc1345 encoding: 4r
              SMALL ROMAN NUMERAL FIVE, UNICODE 0x2174,
	               UNICODE Decomposition: [0076] 
		       rfc1345 encoding: 5r
              SMALL ROMAN NUMERAL SIX, UNICODE 0x2175,
	               UNICODE Decomposition: [0076] & [0069] 
		       rfc1345 encoding: 6r
              SMALL ROMAN NUMERAL SEVEN, UNICODE 0x2176,
	               UNICODE Decomposition: [0076] & [0069] & [0069] 
		       rfc1345 encoding: 7r
              SMALL ROMAN NUMERAL EIGHT, UNICODE 0x2177,
	               UNICODE Decomposition: [0076] & [0069] & [0069] & [0069]
		       rfc1345 encoding: 8r
              SMALL ROMAN NUMERAL NINE, UNICODE 0x2178,
	               UNICODE Decomposition: [0069] & [0078] 
		       rfc1345 encoding: 9r
              SMALL ROMAN NUMERAL TEN, UNICODE 0x2179,
	               UNICODE Decomposition: [0078] 
		       rfc1345 encoding: ar
              SMALL ROMAN NUMERAL ELEVEN, UNICODE 0x217A,
	               UNICODE Decomposition: [0078] & [0069] 
		       rfc1345 encoding: br
              SMALL ROMAN NUMERAL TWELVE, UNICODE 0x217B,
	               UNICODE Decomposition: [0078] & [0069] & [0069] 
		       rfc1345 encoding: cr
              SMALL ROMAN NUMERAL FIFTY, UNICODE 0x217C,
	               UNICODE Decomposition: [006C] 
		       rfc1345 encoding: 50r
              SMALL ROMAN NUMERAL ONE HUNDRED, UNICODE 0x217D,
	               UNICODE Decomposition: [0063] 
		       rfc1345 encoding: 100r
              SMALL ROMAN NUMERAL FIVE HUNDRED, UNICODE 0x217E,
	               UNICODE Decomposition: [0064] 
		       rfc1345 encoding: 500r
              SMALL ROMAN NUMERAL ONE THOUSAND, UNICODE 0x217F,
	               UNICODE Decomposition: [006D] 
		       rfc1345 encoding:1000r
              ROMAN NUMERAL ONE THOUSAND C D, UNICODE 0x2180
	            rfc1345 encoding: 1000RCD
              ROMAN NUMERAL FIVE THOUSAND, UNICODE 0x2181
	            rfc1345 encoding: 5000R
              ROMAN NUMERAL TEN THOUSAND, UNICODE 0x2182 
	            rfc1345 encoding: 10000R
*/

  /* Arrows: */
  /* LEFTWARDS ARROW
     LEFT ARROW */
  { "<-", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x7B,      -1,      -1,
		   -1,   0x2190,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "<-", "LEFTWARDS ARROW" } },
  /* UPWARDS ARROW
     UP ARROW */
  { "^", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x7D,      -1,      -1,
		   -1,   0x2191,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "-!", "UPWARDS ARROW" } },
  /* RIGHTWARDS ARROW
     RIGHT ARROW */
  { "->", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x7C,      -1,      -1,
		   -1,   0x2192,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "->", "RIGHTWARDS ARROW" } },
  /* DOWNWARDS ARROW
     DOWN ARROW */
  { "v", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x7E,      -1,      -1,
		   -1,   0x2193,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "-v", "DOWNWARDS ARROW" } },
  /* LEFT RIGHT ARROW */
  { "<>", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x4D|FC_fallback,  -1,      -1,
		   -1,   0x2194,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "<>", "LEFT RIGHT ARROW" } }, 
  /* UP DOWN ARROW */
  { "^v", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x2195,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "UD", "UP DOWN ARROW" } },
  /* Missing: NORTH WEST ARROW, UPPER LEFT ARROW, UNICODE 0x2196
                    rfc1345 encoding: <!!
              NORTH EAST ARROW, UPPER RIGHT ARROW, UNICODE 0x2197
	            rfc1345 encoding: //>
              SOUTH EAST ARROW, LOWER RIGHT ARROW, UNICODE 0x2198
	            rfc1345 encoding: !!>
              SOUTH WEST ARROW, LOWER LEFT ARROW, UNICODE 0x2199
	            rfc1345 encoding
              LEFTWARDS ARROW WITH STROKE, 
	            LEFT ARROW WITH STROKE, UNICODE 0x219A
              RIGHTWARDS ARROW WITH STROKE, 
                    RIGHT ARROW WITH STROKE, UNICODE 0x219B
              LEFTWARDS WAVE ARROW, LEFT WAVE ARROW, UNICODE 0x219C
              RIGHTWARDS WAVE ARROW, RIGHT WAVE ARROW, UNICODE 0x219D
              LEFTWARDS TWO HEADED ARROW, LEFT TWO HEADED ARROW, UNICODE 0x219E
              UPWARDS TWO HEADED ARROW, UP TWO HEADED ARROW, UNICODE 0x219F
              RIGHTWARDS TWO HEADED ARROW, 
                    RIGHT TWO HEADED ARROW, UNICODE 0x21A0
              DOWNWARDS TWO HEADED ARROW, DOWN TWO HEADED ARROW, UNICODE 0x21A1
              LEFTWARDS ARROW WITH TAIL, LEFT ARROW WITH TAIL, UNICODE 0x21A2
              RIGHTWARDS ARROW WITH TAIL, RIGHT ARROW WITH TAIL, UNICODE 0x21A3
              LEFTWARDS ARROW FROM BAR, LEFT ARROW FROM BAR, UNICODE 0x21A4
              UPWARDS ARROW FROM BAR, UP ARROW FROM BAR, UNICODE 0x21A5
              RIGHTWARDS ARROW FROM BAR, RIGHT ARROW FROM BAR, UNICODE 0x21A6
              DOWNWARDS ARROW FROM BAR, DOWN ARROW FROM BAR, UNICODE 0x21A7
              UP DOWN ARROW WITH BASE, UNICODE 0x21A8
              LEFTWARDS ARROW WITH HOOK, LEFT ARROW WITH HOOK, UNICODE 0x21A9
              RIGHTWARDS ARROW WITH HOOK, RIGHT ARROW WITH HOOK, UNICODE 0x21AA
              LEFTWARDS ARROW WITH LOOP, LEFT ARROW WITH LOOP, UNICODE 0x21AB
              RIGHTWARDS ARROW WITH LOOP, RIGHT ARROW WITH LOOP, UNICODE 0x21AC
              LEFT RIGHT WAVE ARROW, UNICODE 0x21AD
              LEFT RIGHT ARROW WITH STROKE, UNICODE 0x21AE
              DOWNWARDS ZIGZAG ARROW, DOWN ZIGZAG ARROW, UNICODE 0x21AF
              UPWARDS ARROW WITH TIP LEFTWARDS, 
                   UP ARROW WITH TIP LEFT, UNICODE 0x21B0
              UPWARDS ARROW WITH TIP RIGHTWARDS, 
                   UP ARROW WITH TIP RIGHT, UNICODE 0x21B1
              DOWNWARDS ARROW WITH TIP LEFTWARDS, 
                   DOWN ARROW WITH TIP LEFT, UNICODE 0x21B2
              DOWNWARDS ARROW WITH TIP RIGHTWARDS, 
                   DOWN ARROW WITH TIP RIGHT, UNICODE 0x21B3
              RIGHTWARDS ARROW WITH CORNER DOWNWARDS, 
                   RIGHT ARROW WITH CORNER DOWN, UNICODE 0x21B4
              DOWNWARDS ARROW WITH CORNER LEFTWARDS, 
                   DOWN ARROW WITH CORNER LEFT, UNICODE 0x21B5
              ANTICLOCKWISE TOP SEMICIRCLE ARROW, UNICODE 0x21B6
              CLOCKWISE TOP SEMICIRCLE ARROW, UNICODE 0x21B7
              NORTH WEST ARROW TO LONG BAR, 
                   UPPER LEFT ARROW TO LONG BAR, UNICODE 0x21B8
              LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR, 
                   LEFT ARROW TO BAR OVER RIGHT ARROW TO BAR, UNICODE 0x21B9
              ANTICLOCKWISE OPEN CIRCLE ARROW, UNICODE 0x21BA
              CLOCKWISE OPEN CIRCLE ARROW, UNICODE 0x21BB
              LEFTWARDS HARPOON WITH BARB UPWARDS, LEFT 
                   HARPOON WITH BARB UP, UNICODE 0x21BC
              LEFTWARDS HARPOON WITH BARB DOWNWARDS, 
                   LEFT HARPOON WITH BARB DOWN, UNICODE 0x21BD
              UPWARDS HARPOON WITH BARB RIGHTWARDS, 
                   UP HARPOON WITH BARB RIGHT, UNICODE 0x21BE
              UPWARDS HARPOON WITH BARB LEFTWARDS, 
                   UP HARPOON WITH BARB LEFT, UNICODE 0x21BF
              RIGHTWARDS HARPOON WITH BARB UPWARDS, 
	           RIGHT HARPOON WITH BARB UP, UNICODE 0x21C0
              RIGHTWARDS HARPOON WITH BARB DOWNWARDS, 
	           RIGHT HARPOON WITH BARB DOWN, UNICODE 0x21C1
              DOWNWARDS HARPOON WITH BARB RIGHTWARDS, 
	           DOWN HARPOON WITH BARB RIGHT, UNICODE 0x21C2
              DOWNWARDS HARPOON WITH BARB LEFTWARDS, 
	           DOWN HARPOON WITH BARB LEFT, UNICODE 0x21C3
              RIGHTWARDS ARROW OVER LEFTWARDS ARROW, 
	           RIGHT ARROW OVER LEFT ARROW, UNICODE 0x21C4
              UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW, 
	           UP ARROW LEFT OF DOWN ARROW, UNICODE 0x21C5
              LEFTWARDS ARROW OVER RIGHTWARDS ARROW, 
	           LEFT ARROW OVER RIGHT ARROW, UNICODE 0x21C6
              LEFTWARDS PAIRED ARROWS, LEFT PAIRED ARROWS, UNICODE 0x21C7
              UPWARDS PAIRED ARROWS, UP PAIRED ARROWS, UNICODE 0x21C8
              RIGHTWARDS PAIRED ARROWS, RIGHT PAIRED ARROWS, UNICODE 0x21C9
              DOWNWARDS PAIRED ARROWS, DOWN PAIRED ARROWS, UNICODE 0x21CA
              LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON, 
	           LEFT HARPOON OVER RIGHT HARPOON, UNICODE 0x21CB
              RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON, 
	           RIGHT HARPOON OVER LEFT HARPOON, UNICODE 0x21CC
              LEFTWARDS DOUBLE ARROW WITH STROKE, 
	           LEFT DOUBLE ARROW WITH STROKE, UNICODE 0x21CD
              LEFT RIGHT DOUBLE ARROW WITH STROKE, UNICODE 0x21CE
              RIGHTWARDS DOUBLE ARROW WITH STROKE, 
	           RIGHT DOUBLE ARROW WITH STROKE, UNICODE 0x21CF */
  /* LEFTWARDS DOUBLE ARROW, 
     LEFT DOUBLE ARROW */
  { "<=", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x21D0,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "<=", "LEFTWARDS DOUBLE ARROW" } },
  /* Missing: UPWARDS DOUBLE ARROW, UP DOUBLE ARROW, UNICODE 0x21D1 */
  /* RIGHTWARDS DOUBLE ARROW
     RIGHT DOUBLE ARROW */
  { "=>", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x4E|FC_fallback,      
		                              -1,      -1,
		   -1,   0x21D2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "=>", "RIGHTWARDS DOUBLE ARROW" } },
  /* Missing: DOWNWARDS DOUBLE ARROW, DOWN DOUBLE ARROW, UNICODE 0x21D3 */
  /* LEFT RIGHT DOUBLE ARROW */
  { "<>", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,   0x4D|FC_fallback,     
		                              -1,      -1,
		   -1,   0x21D4,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "==", "LEFT RIGHT DOUBLE ARROW" } }, 	      
  /* Missing: UP DOWN DOUBLE ARROW, UNICODE 0x21D5
              NORTH WEST DOUBLE ARROW, UPPER LEFT DOUBLE ARROW, UNICODE 0x21D6
              NORTH EAST DOUBLE ARROW, UPPER RIGHT DOUBLE ARROW, UNICODE 0x21D7
              SOUTH EAST DOUBLE ARROW, LOWER RIGHT DOUBLE ARROW, UNICODE 0x21D8
              SOUTH WEST DOUBLE ARROW, LOWER LEFT DOUBLE ARROW, UNICODE 0x21D9
              LEFTWARDS TRIPLE ARROW, LEFT TRIPLE ARROW, UNICODE 0x21DA
              RIGHTWARDS TRIPLE ARROW, RIGHT TRIPLE ARROW, UNICODE 0x21DB
              LEFTWARDS SQUIGGLE ARROW, LEFT SQUIGGLE ARROW, UNICODE 0x21DC
              RIGHTWARDS SQUIGGLE ARROW, RIGHT SQUIGGLE ARROW, UNICODE 0x21DD
              UPWARDS ARROW WITH DOUBLE STROKE, 
                   UP ARROW WITH DOUBLE STROKE, UNICODE 0x21DE
              DOWNWARDS ARROW WITH DOUBLE STROKE, 
	           DOWN ARROW WITH DOUBLE STROKE, UNICODE 0x21DF
              LEFTWARDS DASHED ARROW, LEFT DASHED ARROW, UNICODE 0x21E0
              UPWARDS DASHED ARROW, UP DASHED ARROW, UNICODE 0x21E1
              RIGHTWARDS DASHED ARROW, RIGHT DASHED ARROW, UNICODE 0x21E2
              DOWNWARDS DASHED ARROW, DOWN DASHED ARROW, UNICODE 0x21E3
              LEFTWARDS ARROW TO BAR, LEFT ARROW TO BAR, UNICODE 0x21E4
              RIGHTWARDS ARROW TO BAR, RIGHT ARROW TO BAR, UNICODE 0x21E5
              LEFTWARDS WHITE ARROW, WHITE LEFT ARROW, UNICODE 0x21E6
              UPWARDS WHITE ARROW, WHITE UP ARROW, UNICODE 0x21E7
              RIGHTWARDS WHITE ARROW, WHITE RIGHT ARROW, UNICODE 0x21E8
              DOWNWARDS WHITE ARROW, WHITE DOWN ARROW, UNICODE 0x21E9
              UPWARDS WHITE ARROW FROM BAR, WHITE UP ARROW FROM BAR, 
	          UNICODE 0x21EA */

  /*          ASCII,   LATIN1,   MULT, SPECIAL,  FINNISH,
                 UK,   NORW,     SWEDISH,   LATIN4,    LATIN5,
	       ISO-8859-*, LATIN2,
               LATIN3,     CP437,
	       ITAL,  Unicode 1.1 */
  /* NO-BREAK SPACE
     NON-BREAKING SPACE */
  { " ",  {' ',' '}, 0, &CH_NBSP,
      {            -1,     0xA0,     -1,      -1,       -1,
		   -1,       -1,     -1,    0xA0,     0xA0,
                 0xA0,     0xA0,     -1,      -1,       -1,
                 0xA0,       -1,     -1,      -1,     0xCA,
		   -1,   0x00a0,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <no-break> [0020] <no-break> */
      { "NS", "NO-BREAK SPACE" } },   
  /* INVERTED EXCLAMATION MARK */
  { "!!",  {'!','!'},1, NULL,
      {            -1,     0xA1,   0xA1,      -1,       -1,
		   -1,       -1,     -1,      -1,      161,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      173,     -1,    0x5B,     0xC1,
		   -1,   0x00a1,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,     0x5B,    0x5B,
                   -1,       -1,   0x5B,      -1 },
      { "!I", "INVERTED EXCLAMATION MARK" } },
  /* CENT SIGN */
  { "c",  {0,0}, 1, NULL,
      {            -1,     0xA2,   0xA2,      -1,       -1,
		   -1,       -1,     -1,      -1,      162,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      155,     -1,      -1,     0xA2,
		   -1,   0x00a2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Ct", "CENT SIGN" } },
  /* POUND SIGN */
  { "p",  {0,0}, 1, NULL,
      {            -1,     0xA3,   0xA3,    0x7D,       -1,
		 0x23,       -1,     -1,      -1,      163,
                   -1,       -1,   0x23,      -1,       -1,
                  163,      156,     -1,    0x23,     0xA3,
		 0x23,   0x00a3,     -1,      -1,       -1,
		   -1,       -1,     -1,    0x23,       -1,
                   -1,       -1,     -1,    0x23,      -1,
                   -1,      -1,      -1,      -1 },
      { "Pd", "POUND SIGN" } },
  /* CURRENCY SIGN */
  { "$$",  {0,0},1, NULL,
      {            -1,     0xA4,   0xA8,      -1,       -1,
		   -1,       -1,     -1,     164,      164,
                   -1,     0xA4,     -1,      -1,       -1,
                  164,       -1,     -1,      -1,       -1,
		   -1,   0x00a4,   0x24,    0x24,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                 0x24,       -1,   0x24,      -1 },
      { "Cu", "CURRENCY SIGN" } },
  /* YEN SIGN */
  { "Y",  {0,0}, 1, NULL,
      {            -1,     0xA5,   0xA5,      -1,       -1,
		   -1,       -1,     -1,      -1,      165,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      157,     -1,      -1,     0xB4,
		   -1,     0x00a5,   -1,        -1,       -1,
		   -1,     0x24,      -1,      -1,       -1,
		 0x5C,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Ye", "YEN SIGN" } },
  /* BROKEN BAR 
     BROKEN VERTICAL BAR */
  { "::",  {'|','|'},1, NULL,
      {            -1,     0xA6,     -1,      -1,       -1, 
		   -1,       -1,     -1,      -1,      166,
                   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,   -1,      -1,        -1,
		   -1,   0x00a6,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "BB", "BROKEN BAR" } },
  /* PARAGRAPH SIGN  / US SECTION SIGN 
     SECTION SIGN */
  { "$",  {0,0}, 1, NULL,
      {            -1,     0xA7,   0xA7,      -1,       -1,
		   -1,       -1,     -1,     167,      167,
                   -1,     0xA7,   0x5D,    0x40,       -1,
                  167,       -1,     -1,    0x40,     0xA4,
		 0x40,   0x00a7,     -1,      -1,       -1,
		   -1,       -1,     -1,    0x5D,       -1,
                   -1,     0x40,     -1,    0x40,      -1,
                   -1,      -1,      -1,      -1 },
      { "SE", "SECTION SIGN" } },
  /* DIAERESIS
     SPACING DIAERESIS */
  { "\"",  {' ','"'},1, NULL,
      {            -1,     0xA8,     -1,      -1,       -1,
		   -1,       -1,     -1,     168,      168,
                   -1,     0xA8,    0x7E,     -1,       -1,
                  168,       -1,     -1,      -1,     0xAC,
		   -1,   0x00a8,     -1,      -1,       -1,
		   -1,       -1,     -1,    0x7E,       -1,
                   -1,       -1,     -1,      -1,     0x7E,
                   -1,       -1,   0x7E,      -1 },
      /* UNICODE Decomposition: [0020] & [0308] */
      { "':", "DIAERESIS" } },
  /* COPYRIGHT SIGN */
  { "(c)", {0,0}, 1, NULL,
      {            -1,     0xA9,   0xA9,      -1,       -1,
		   -1,       -1,     -1,      -1,      169,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xA9,
		   -1,   0x00a9,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+circled> [0043] <-circled> */
      { "Co", "COPYRIGHT SIGN" } },
  /* FEMININE ORDINAL INDICATOR */
  { "a_",  {0,0},1, NULL,
      {            -1,     0xAA,   0xAA,      -1,       -1,
		   -1,       -1,     -1,      -1,      170,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      166,     -1,      -1,     0xBB,
		   -1,   0x00aa,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0061] {& [0331]} <-sup> */
      { "-a", "FEMININE ORDINAL INDICATOR" } },
  /* LEFT ANGLE QUOTATION MARK 
     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
     LEFT POINTING GUILLEMET */
  { "<<",  {'<','<'},1, NULL,
      {            -1,     0xAB,   0xAB,      -1,       -1,
		   -1,       -1,     -1,      -1,      171,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      174|FC_fallback,
		                     -1,      -1,     0xC7,
		   -1,   0x00ab,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* See also: 0x226A MUCH LESS-THAN */
      { "<<" , "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK" } },
  /* NOT SIGN */
  { "!=",  {'!','='},1, NULL,
      {            -1,     0xAC,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,      172,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xC2,
		   -1,   0x00ac,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "NO", "NOT SIGN" } },
  /* SOFT HYPHEN */
  { "-",  {'-','-'}, 0, &CH_SHY,
      {            -1,     0xAD,     -1,      -1,       -1,
		   -1,       -1,     -1,     173,      173,
                  173,     0xAD,     -1,      -1,       -1,
                  173,       -1,    -1,      -1,        -1,
		   -1,   0x00ad,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "--", "SOFT HYPHEN" } },   
  /* REGISTERED TRADE MARK SIGN, REGISTERED TRADEMARK SIGN 
     REGISTERED SIGN
     REGISTERED TRADE MARK SIGN */
  { "(r)",  {0,0},1, NULL,
      {            -1,     0xAE,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,      174,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xA8,
		   -1,   0x00ae,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+circled> [0052] <-circled> */
      { "Rg", "REGISTERED SIGN" } },
  /* MACRON, EM DASH 
     SPACING MACRON */
  { "-",  {' ','-'}, 1, NULL,
      {            -1,     0xAF,     -1,      -1,       -1,
		   -1,       -1,     -1,     175,      175,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xD1,
		   -1,   0x00af,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0020] & [0304] */
      { "'m", "MACRON" } },  

  /*          ASCII,   LATIN1,   MULT, SPECIAL, FINNISH,
                  UK,     NORW,    SWEDISH, LATIN4,   LATIN5,
		ISO-8859-*, LATIN2, BELGIAN, GERMAN, French Canadian,
		Italian, RFC1345 */
  /* DEGREE SIGN, RING ABOVE */
  { "^0",  {'^','0'},1, NULL,
      {            -1,     0xB0,    0xB0,   0x66,       -1,
		   -1,       -1,     -1,     176,      176,
                   -1,     0xB0,    0x5B,     -1,       -1,
                  176,      248,     -1,    0x7C,     0xA1,
		 0x5B,   0x00b0,     -1,      -1,       -1,
		   -1,       -1,     -1,    0x5B,       -1,
                   -1,     0x7E,     -1,    0x7B,      -1,
                   -1,      -1,      -1,      -1 },
      { "DG", "DEGREE SIGN" } },
  /* PLUS-MINUS SIGN 
     PLUS-OR-MINUS SIGN */
  { "+-",  {'+','-'},1, NULL,
      {            -1,     0xB1,    0xB1,   0x67,       -1,
		   -1,       -1,     -1,      -1,      177,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      241,     -1,      -1,     0xB1,
		   -1,   0x00b1,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "+-", "PLUS-MINUS SIGN" } },
  /* SUPERSCRIPT TWO 
     SUPERSCRIPT DIGIT TWO */
  { "^2",  {'^','2'},1, NULL,
      {            -1,     0xB2,    0xB2,     -1,       -1,
		   -1,       -1,     -1,      -1,      178,
                   -1,       -1,     -1,      -1,       -1,
                  178,      253,   -1,      -1,        -1,
		   -1,   0x00b2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0032] <-sup> */
      { "2S", "SUPERSCRIPT TWO" } },
  /* SUPERSCRIPT THREE 
     SUPERSCRIPT DIGIT THREE */
  { "^3",  {'^','3'},1, NULL,
      {            -1,     0xB3,    0xB3,     -1,       -1,
		   -1,       -1,     -1,      -1,      179,
                   -1,       -1,     -1,      -1,       -1,
                  179,       -1,   -1,      -1,        -1,
		   -1,   0x00b3,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0033] <-sup> */
      { "3S", "SUPERSCRIPT THREE" } },
  /* ACUTE ACCENT 
     SPACING ACUTE */
  { "'",  {' ','\''}, 1, NULL,
      {            -1,     0xB4,     -1,     -1,       -1,
		   -1,       -1,     -1,    180,      180,
                   -1,     0xB4,     -1,     -1,       -1,
                  180,       -1,     -1,     -1,     0xAB,
		   -1,   0x00b4,     -1,     -1,       -1,
		   -1,       -1,     -1,     -1,       -1,
                   -1,       -1,   0x40,      -1,    0x7B,
                   -1,       -1,   0x7B,      -1 },
      /* UNICODE Decomposition: [0020] & [0301] */
      { "''", "ACUTE ACCENT" } },
  /* MICRO SIGN */
  { "u",  {0,0}, 1, NULL,
      {            -1,     0xB5,    0xB5,     -1,       -1,
		   -1,       -1,      -1,     -1,      181,
                   -1,       -1,      -1,     -1,       -1,
                  181,       -1,      -1,     -1,     0xB5,
		   -1,   0x00b5,      -1,     -1,       -1,
		   -1,       -1,      -1,   0x60,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [03BC] */
  { "My", "MICRO SIGN" } },
  /* PILCROW SIGN, US PARAGRAPH SIGN 
     PARAGRAPH SIGN */
  { "P",  {0,0}, 1, NULL,
      {            -1,     0xB6,    0xB6,     -1,       -1,
		   -1,       -1,      -1,     -1,      182,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xA6,
		   -1,   0x00b6,   -1,        -1,       -1,
		   0x23,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "PI", "PILCROW SIGN" } },
  /* MIDDLE DOT */
  { ".",  {0,0}, 1, NULL,
      {            -1,     0xB7,    0xB7,   0x7E,       -1,
		   -1,       -1,      -1,     -1,      183,
                   -1,       -1,     -1,      -1,       -1,
                  183,      249 /* ? */,   
                                      -1,     -1,       -1,
		   -1,    0x00b7,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ".M", "MIDDLE DOT" } },

  /* CEDILLA 
     SPACING CEDILLA */
  { ",",  {' ',','}, 1, NULL,
      {            -1,     0xB8,      -1,     -1,       -1,
		   -1,       -1,      -1,    184,      184,
                   -1,     0xB8,     -1,      -1,       -1,
                  184,       -1,   -1,      -1,        -1,
		   -1,   0x00b8,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0020] & [0327] */
      { "',", "CEDILLA" } },
  /* SUPERSCRIPT ONE 
     SUPERSCRIPT DIGIT ONE */
  { "^1",  {'^','1'},1, NULL,
      {            -1,     0xB9,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,      185,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,   -1,      -1,        -1,
		   -1,   0x00b9,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0031] <-sup> */
      { "1S", "SUPERSCRIPT ONE" } },
  /* MASCULINE ORDINAL INDICATOR */
  { "o_",  {0,0},1, NULL,
      {            -1,     0xBA,    0xBA,     -1,       -1,
		   -1,       -1,      -1,     -1,      186,
                   -1,       -1,      -1,     -1,       -1,
                   -1,      167,      -1,     -1,     0xBC,
		   -1,   0x00ba,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <+sup> [0062] & [0331] <-sup> */
      { "-o", "MASCULINE ORDINAL INDICATOR" } },
  /* RIGHT ANGLE QUOTATION MARK 
     RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
     RIGHT POINTING GUILLEMET */
  { ">>",  {'>','>'},1, NULL,
      {            -1,     0xBB,    0xBB,     -1,       -1,
		   -1,       -1,      -1,     -1,      187,
                   -1,       -1,      -1,     -1,       -1,
                   -1,      175|FC_fallback, -1,     -1,     0xC8,
		   -1,   0x00bb,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* See also: 0x226B MUCH GREATER-THAN */
      { ">>", "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK" } },
  /* VULGAR FRACTION ONE QUARTER 
     FRACTION ONE QUARTER */
  { "1/4",  {'1','4'},1, NULL,
      {            -1,     0xBC,    0xBC,     -1,       -1,
		   -1,       -1,      -1,     -1,      188,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      172,   -1,      -1,        -1,
		   -1,   0x00bc,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0031] & [2044] & [0034] <break> */
      { "14", "VULGAR FRACTION ONE QUARTER" } },   
  /* VULGAR FRACTION ONE HALF 
     FRACTION ONE HALF */
  { "1/2",  {'1','2'},1, NULL,
      {            -1,     0xBD,    0xBD,     -1,       -1,
		   -1,       -1,      -1,     -1,      189,
                   -1,       -1,      -1,     -1,       -1,
                  189,      171,   -1,      -1,        -1,
		   -1,   0x00bd,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0031] & [2044] & [0032] <break> */
      { "12", "VULGAR FRACTION ONE HALF" } },
  /* VULGAR FRACTION THREE QUARTERS 
     FRACTION THREE QUARTERS */
  { "3/4",  {'3','4'},1, NULL,
      {            -1,     0xBE,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,      190,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,   -1,      -1,        -1,
		   -1,   0x00be,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: <break> [0033] & [2044] & [0034] <break> */
      { "34", "VULGAR FRACTION THREE QUARTERS" } },
  /* INVERTED QUESTION MARK */
  { "??",  {'?','?'},1, NULL,
      {            -1,     0xBF,    0xBF,     -1,       -1,
		   -1,       -1,      -1,     -1,      191,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      168,   0x76,    0x5D,     0xC0,
		   -1,   0x00bf,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,    0x5D,     0x5E,
                   -1,       -1,   0x5E,      -1 },
      { "?I", "INVERTED QUESTION MARK" } },

  /*          ASCII,   LATIN1,   MULT, SPECIAL, FINNISH,
                  UK,      NOR,    SWEDISH, LATIN4,  LATIN5,
                  ...,
                                    TECHNICAL, SPANISH, MAC,
		  ITAL, Unicode 1.1  */
  /* CAPITAL LETTER A WITH GRAVE ACCENT 
     LATIN CAPITAL LETTER A WITH GRAVE
     LATIN CAPITAL LETTER A GRAVE */
  { "A`",  {'A','`'},1, NULL,
      {            -1,     0xC0,    0xC0,     -1,       -1,
		   -1,       -1,      -1,     -1,      192,
                   -1,       -1,     -1,      -1,       -1,
                  192,       -1,     -1,      -1,       -1,
		   -1,   0x00c0,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0300] */
      { "A!", "LATIN CAPITAL LETTER A WITH GRAVE" } },
  /* CAPITAL LETTER A WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER A WITH ACUTE
     LATIN CAPITAL LETTER A ACUTE */
  { "A'",  {'A','\''},1, NULL,
      {            -1,     0xC1,    0xC1,     -1,       -1,
		   -1,       -1,      -1,    193,      193,
                   -1,     0xC1,     -1,      -1,       -1,
                  193,       -1,     -1,      -1,     0xCB,
		   -1,   0x00c1,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                   -1,        -1,      -1,      -1,       -1,
                 0x40,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0301] */
      { "A'", "LATIN CAPITAL LETTER A WITH ACUTE" } },
  /* CAPITAL LETTER A WITH CIRCUMFLEX ACCENT 
     LATIN CAPITAL LETTER A WITH CIRCUMFLEX
     LATIN CAPITAL LETTER A CIRCUMFLEX */
  { "A^",  {'A','^'},1, NULL,
      {            -1,     0xC2,    0xC2,     -1,       -1,
		   -1,       -1,      -1,    194,      194,
                   -1,     0xC2,     -1,      -1,       -1,
                  194,       -1,   -1,      -1,        -1,
		   -1,   0x00c2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0302] */
      { "A>" , "LATIN CAPITAL LETTER A WITH CIRCUMFLEX" } },   
  /* CAPITAL LETTER A WITH TILDE 
     LATIN CAPITAL LETTER A WITH TILDE
     LATIN CAPITAL LETTER A TILDE */
  { "A~",  {'A','~'},1, NULL,
      {            -1,     0xC3,    0xC3,     -1,       -1,
		   -1,       -1,      -1,    195,      195,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xCC,
		   -1,   0x00c3,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,     0x5B,   0x5B,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0303] */
      { "A?", "LATIN CAPITAL LETTER A WITH TILDE" } },   
  /* CAPITAL LETTER A WITH DIAERESIS 
     LATIN CAPITAL LETTER A WITH DIAERESIS
     LATIN CAPITAL LETTER A DIAERESIS */
  { "A\"",  {'A','"'},1, NULL,
      {            -1,     0xC4,    0xC4,     -1,     0x5B,
		   -1,       -1,    0x5B,    196,      196,
                   -1,     0xC4,     -1,    0x5B,       -1,
                  196,      142,     -1,      -1,     0x80,
		   -1,   0x00c4,   0x5B,    0x5B,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0308] */
      { "A:", "LATIN CAPITAL LETTER A WITH DIAERESIS" } },
  /* CAPITAL LETTER A WITH RING ABOVE 
     LATIN CAPITAL LETTER A WITH RING ABOVE
     LATIN CAPITAL LETTER A RING */
  { "AA",  {'A','o'},1, NULL,
      {            -1,     0xC5,    0xC5,     -1,     0x5D,
		   -1,     0x5D,    0x5D,    197,      197,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      143,     -1,      -1,     0x81,
		   -1,   0x00c5,   0x5D,    0x5D,     0x5D,
		   0x5D,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [030A] */
      { "AA", "LATIN CAPITAL LETTER A WITH RING ABOVE" } },
  /* CAPITAL DIPHTHONG A WITH E, CAPITAL DIPHTHONG AE 
     LATIN CAPITAL LIGATURE AE
     LATIN CAPITAL LETTER A E */
  { "AE",  {'A','E'},1, NULL,
      {            -1,     0xC6,    0xC6,     -1,       -1,
		   -1,     0x5B,      -1,    198,      198,
                   -1,       -1,      -1,     -1,       -1,
                   -1,      146,      -1,     -1,     0xAE,
		   -1,   0x00c6,   -1,        -1,     0x5B,
		   0x5B,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "AE", "LATIN CAPITAL LIGATURE AE" } },
  /* CAPITAL LETTER C WITH CEDILLA 
     LATIN CAPITAL LETTER C WITH CEDILLA
     LATIN CAPITAL LETTER C CEDILLA */
  { "C,",  {'C',','},1, NULL,
      {            -1,     0xC7,    0xC7,     -1,       -1,
		   -1,       -1,      -1,     -1,      199,
                   -1,     0xC7,      -1,     -1,       -1,
                  199,      128,      -1,     -1,     0x82,
		   -1,   0x00c7,      -1,     -1,       -1,
		   -1,       -1,      -1,   0x5C,       -1,
                   -1,     0x5C,    0x5C,      -1,    0x5D,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0043] & [0327] */
      { "C,", "LATIN CAPITAL LETTER C WITH CEDILLA" } },
  /* CAPITAL LETTER E WITH GRAVE ACCENT 
     LATIN CAPITAL LETTER E WITH GRAVE
     LATIN CAPITAL LETTER E GRAVE */
  { "E`",  {'E','`'},1, NULL,
      {            -1,     0xC8,    0xC8,     -1,       -1,
		   -1,       -1,      -1,     -1,      200,
                   -1,       -1,     -1,      -1,       -1,
                  200,       -1,   -1,      -1,        -1,
		   -1,   0x00c8,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0300] */
      { "E!", "LATIN CAPITAL LETTER E WITH GRAVE" } },  
  /* CAPITAL LETTER E WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER E WITH ACUTE
     LATIN CAPITAL LETTER E ACUTE */
  { "E'",  {'E','\''},1, NULL,
      {            -1,     0xC9,    0xC9,     -1,       -1,
		   -1,       -1,      -1,    201,      201,
                   -1,     0xC9,      -1,     -1,       -1,
                  201,      144,      -1,     -1,     0x83,
		   -1,   0x00c9,      -1,   0x40,       -1,
		   -1,       -1,    0x5E,      -1,      -1,
                   -1,       -1,      -1,      -1,      -1,
		 0x5B,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0301] */
      { "E'", "LATIN CAPITAL LETTER E WITH ACUTE" } },
  /* CAPITAL LETTER E WITH CIRCUMFLEX ACCENT 
     LATIN CAPITAL LETTER E WITH CIRCUMFLEX
     LATIN CAPITAL LETTER E CIRCUMFLEX */
  { "E^",  {'E','^'},1, NULL,
      {            -1,     0xCA,    0xCA,     -1,       -1,
		   -1,       -1,      -1,     -1,      202,
                   -1,       -1,     -1,      -1,       -1,
                  202,       -1,   -1,      -1,        -1,
		   -1,   0x00ca,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0302] */
      { "E>", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX" } },
  /* CAPITAL LETTER E WITH DIAERESIS 
      LATIN CAPITAL LETTER E WITH DIAERESIS
      LATIN CAPITAL LETTER E DIAERESIS */
  { "E\"",  {'E','"'},1, NULL,
      {            -1,     0xCB,    0xCB,     -1,       -1,
		   -1,       -1,      -1,    203,      203,
                   -1,     0xCB,     -1,      -1,       -1,
                  203,       -1,   -1,      -1,        -1,
		   -1,   0x00cb,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0308] */
      { "E:", "LATIN CAPITAL LETTER E WITH DIAERESIS" } },  
  /* CAPITAL LETTER I WITH GRAVE ACCENT 
     LATIN CAPITAL LETTER I WITH GRAVE
     LATIN CAPITAL LETTER I GRAVE */
  { "I`",  {'I','`'},1, NULL,
      {            -1,     0xCC,    0xCC,     -1,       -1,
		   -1,       -1,      -1,     -1,      204,
                   -1,       -1,     -1,      -1,       -1,
                  204,       -1,   -1,      -1,        -1,
		   -1,   0x00cc,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0300] */
      { "I!", "LATIN CAPITAL LETTER I WITH GRAVE" } },
  /* CAPITAL LETTER I WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER I WITH ACUTE
     LATIN CAPITAL LETTER I ACUTE */
  { "I'",  {'I','\''},1, NULL,
      {            -1,     0xCD,    0xCD,     -1,       -1,
		   -1,       -1,      -1,    205,      205,
                   -1,     0xCD,     -1,      -1,       -1,
                  205,       -1,   -1,      -1,        -1,
		   -1,   0x00cd,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0301] */
      { "I'" , "LATIN CAPITAL LETTER I WITH ACUTE" } },
  /* CAPITAL LETTER I WITH CIRCUMFLEX ACCENT 
     LATIN CAPITAL LETTER I WITH CIRCUMFLEX
     LATIN CAPITAL LETTER I CIRCUMFLEX */
  { "I^",  {'I','^'},1, NULL,
      {            -1,     0xCE,    0xCE,     -1,       -1,
		   -1,       -1,      -1,    206,      206,
                   -1,     0xCE,     -1,      -1,       -1,
                  206,       -1,   -1,      -1,        -1,
		   -1,   0x00ce,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0302] */
      { "I>", "LATIN CAPITAL LETTER I WITH CIRCUMFLEX" } },  
  /* CAPITAL LETTER I WITH DIAERESIS 
     LATIN CAPITAL LETTER I WITH DIAERESIS
     LATIN CAPITAL LETTER I DIAERESIS */
  { "I\"",  {'I','"'},1, NULL,
      {            -1,     0xCF,    0xCF,     -1,       -1,
		   -1,       -1,      -1,     -1,      207,
                   -1,       -1,     -1,      -1,       -1,
                  207,       -1,   -1,      -1,        -1,
		   -1,   0x00cf,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0308] */
      { "I:", "LATIN CAPITAL LETTER I WITH DIAERESIS" } }, 

  /*          ASCII,   LATIN1,   MULT, SPECIAL, FINNISH,
                  UK,     NORW,   SWEDISH,  LATIN4,  LATIN5,
		  ....,
	      Ital, Unicode 1.1 */
  /* CAPITAL ICELANDIC LETTER ETH 
     LATIN CAPITAL LETTER ETH
     Icelandic */
  { "-D",  {0,0},1, NULL,
      {            -1,     0xD0,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x00d0,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "D-", "LATIN CAPITAL LETTER ETH" /* (Icelandic) */ } },
  /* CAPITAL LETTER N WITH TILDE 
     LATIN CAPITAL LETTER N WITH TILDE
     LATIN CAPITAL LETTER N TILDE */
  { "N~",  {'N','~'},1, NULL,
      {            -1,     0xD1,    0xD1,     -1,       -1,
		   -1,       -1,      -1,     -1,      209,
                   -1,       -1,     -1,      -1,       -1,
                  209,      165,      -1,   0x5C,     0x84,
		   -1,   0x00d1,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,      -1,   0x5C,     0x5C,
                   -1,       -1,    0x5C,      -1 },
      /* UNICODE Decomposition: [004E] & [0303] */
      { "N?", "LATIN CAPITAL LETTER N WITH TILDE" } },   
  /* CAPITAL LETTER O WITH GRAVE ACCENT 
     LATIN CAPITAL LETTER O WITH GRAVE
     LATIN CAPITAL LETTER O GRAVE */
  { "O`",  {'O','`'},1, NULL,
      {            -1,     0xD2,    0xD2,     -1,       -1,
		   -1,       -1,      -1,     -1,      210,
                   -1,       -1,     -1,      -1,       -1,
                  210,       -1,     -1,      -1,        -1,
		   -1,   0x00d2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0300] */
      { "O!", "LATIN CAPITAL LETTER O WITH GRAVE" } },   
  /* CAPITAL LETTER O WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER O WITH ACUTE
     LATIN CAPITAL LETTER O ACUTE */
  { "O'",  {'O','\''},1, NULL,
      {            -1,     0xD3,    0xD3,     -1,       -1,
		   -1,       -1,      -1,     -1,      211,
                   -1,     0xD3,     -1,      -1,       -1,
                  211,       -1,     -1,      -1,        -1,
		   -1,   0x00d3,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0301] */
  { "O'", "LATIN CAPITAL LETTER O WITH ACUTE" } },
  /* CAPITAL LETTER O WITH CIRCUMFLEX ACCENT 
     LATIN CAPITAL LETTER O WITH CIRCUMFLEX
     LATIN CAPITAL LETTER O CIRCUMFLEX */
  { "O^",  {'O','^'},1, NULL,
      {            -1,     0xD4,    0xD4,     -1,       -1,
		   -1,       -1,      -1,    212,      212,
                   -1,     0xD4,     -1,      -1,       -1,
                  212,       -1,     -1,      -1,        -1,
		   -1,   0x00d4,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0302] */
      { "O>", "LATIN CAPITAL LETTER O WITH CIRCUMFLEX" } },
  /* CAPITAL LETTER O WITH TILDE 
     LATIN CAPITAL LETTER O WITH TILDE
     LATIN CAPITAL LETTER O TILDE */
  { "O~",  {'O','~'},1, NULL,
      {            -1,     0xD5,    0xD5,     -1,       -1,
		   -1,       -1,      -1,    213,      213,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xCD,
		   -1,   0x00d5,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,     0x5D,   0x5D,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0303] */
      { "O?", "LATIN CAPITAL LETTER O WITH TILDE" } },    
  /* LATIN CAPITAL LETTER O WITH MIDDLE TILDE
     LATIN CAPITAL LETTER BARRED O */
  { "O~",  {0,0},1, NULL,
      {            -1,     0xD5 | FC_fallback,    
                                   0xD5 | FC_fallback,  -1,       -1,
		   -1,       -1,    -1,    213 | FC_fallback,  
                                                      213 | FC_fallback,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xCD | FC_fallback,
		   -1,   0x019F,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER O WITH MIDDLE TILDE" } },
/* Not in RFC1345! */

  /* CAPITAL LETTER O WITH DIAERESIS 
     LATIN CAPITAL LETTER O WITH DIAERESIS
     LATIN CAPITAL LETTER O DIAERESIS */
  { "O\"", {'O','"'},1, NULL,
      {            -1,     0xD6,    0xD6,     -1,     0x5C,
		   -1,       -1,    0x5C,    214,      214,
                   -1,     0xD6,     -1,    0x5C,       -1,
                  214,      153,     -1,      -1,     0x85,
		   -1,   0x00d6,   0x5C,    0x5C,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                 0x5C,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0308] */
      { "O:", "LATIN CAPITAL LETTER O WITH DIAERESIS" } },
  /* MULTIPLICATION SIGN */
  { "x",  {0,0}, 1, NULL,
      {            -1,     0xD7,      -1,     -1,       -1,
		   -1,       -1,      -1,    215,      215,
                   -1,     0xD7,     -1,      -1,       -1,
                  215,       -1,     0x4B,    -1,        -1,
		   -1,   0x00d7,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "*X", "MULTIPLICATION SIGN" } },
  /* CAPITAL LETTER O WITH OBLIQUE STROKE 
     LATIN CAPITAL LETTER O WITH STROKE
     LATIN CAPITAL LETTER O SLASH */
  { "0",  {'O','/'}, 1, NULL,
      {            -1,     0xD8,    0xD8,     -1,       -1,
		   -1,     0x5C,      -1,    216,      216,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xAF,
		   -1,   0x00d8,   -1,        -1,     0x5C,
		   0x5C,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0338] */
      { "O/", "LATIN CAPITAL LETTER O WITH STROKE" } },   
  /* CAPITAL LETTER U WITH GRAVE ACCENT 
     LATIN CAPITAL LETTER U WITH GRAVE
     LATIN CAPITAL LETTER U GRAVE */
  { "U`",  {'U','`'},1, NULL,
      {            -1,     0xD9,    0xD9,     -1,       -1,
		   -1,       -1,      -1,     -1,      217,
                   -1,       -1,     -1,      -1,       -1,
                  217,       -1,     -1,      -1,        -1,
		   -1,   0x00d9,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0300] */
      { "U!", "LATIN CAPITAL LETTER U WITH GRAVE" } },
  /* CAPITAL LETTER U WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER U WITH ACUTE
     LATIN CAPITAL LETTER U ACUTE */
  { "U'",  {'U','\''},1, NULL,
      {            -1,     0xDA,    0xDA,     -1,       -1,
		   -1,       -1,      -1,    218,      218,
                   -1,     0xDA,     -1,      -1,       -1,
                  218,       -1,     -1,      -1,        -1,
		   -1,   0x00da,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0301] */
      { "U'", "LATIN CAPITAL LETTER U WITH ACUTE" } },
  /* CAPITAL LETTER U WITH CIRCUMFLEX ACCENT 
     LATIN CAPITAL LETTER U WITH CIRCUMFLEX
     LATIN CAPITAL LETTER U CIRCUMFLEX */
  { "U^",  {'U','^'},1, NULL,
      {            -1,     0xDB,    0xDB,     -1,       -1,
		   -1,       -1,      -1,    219,      219,
                   -1,       -1,     -1,      -1,       -1,
                  219,       -1,     -1,      -1,        -1,
		   -1,   0x00db,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0302] */
      { "U>", "LATIN CAPITAL LETTER U WITH CIRCUMFLEX" } },
  /* CAPITAL LETTER U WITH DIAERESIS 
     LATIN CAPITAL LETTER U WITH DIAERESIS
     LATIN CAPITAL LETTER U DIAERESIS */
  { "U\"",  {'U','"'},1, NULL,
      {            -1,     0xDC,    0xDC,     -1,     0x5E,
		   -1,       -1,      -1,    220,      220,
                   -1,     0xDC,     -1,    0x5D,       -1,
                  220,      154,     -1,      -1,     0x86,
		   -1,   0x00dc,     -1,    0x5E,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                 0x5D,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0308] */
      { "U:", "LATIN CAPITAL LETTER U WITH DIAERESIS" } },
  /* CAPITAL LETTER Y WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER Y WITH ACUTE
     LATIN CAPITAL LETTER Y ACUTE */
  { "Y'",  {'Y','\''},1, NULL,
      {            -1,     0xDD,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,     0xDD,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x00dd,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0059] & [0301] */
      { "Y'", "LATIN CAPITAL LETTER Y WITH ACUTE" } },
  /* CAPITAL ICELANDIC LETTER THORN 
     LATIN CAPITAL LETTER THORN
     Icelandic */
  { "P",  {0,0}, 1, NULL,
      {            -1,     0xDE,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x00de,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "TH", "LATIN CAPITAL LETTER THORN" /* (Icelandic)*/ } },
  /* SMALL GERMAN LETTER SHARP s / SMALL LETTER SHARP s 
     LATIN SMALL LETTER SHARP S
     German */
  { "ss",  {'s','s'}, 1, NULL,
      {            -1,     0xDF,    0xDF,     -1,       -1,
		   -1,       -1,      -1,    223,      223,
                   -1,     0xDF,     -1,    0x7E,       -1,
                  223,       -1,     -1,      -1,     0xA7,
		   -1,   0x00df,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "ss", "LATIN SMALL LETTER SHARP S" /* (German) */ } }, 

  /*          ASCII,   LATIN1,   MULT, SPECIAL, FINNISH,
                UK,   NORWEGIAN, SWEDISH, LATIN4, LATIN5,
                ISO-8859-*, LATIN2, BELGIAN,
                LATIN3,   CP437,  TECHNICAL, SPANISH, MAC,
		ITAL, Unicode 1.1  */
  /* SMALL LETTER a WITH GRAVE ACCENT 
     LATIN SMALL LETTER A WITH GRAVE
     LATIN SMALL LETTER A GRAVE */
  { "a`",  {'a','`'},1, NULL,
      {            -1,     0xE0,    0xE0,     -1,       -1,
		   -1,       -1,      -1,     -1,      224,
                   -1,       -1,    0x40,     -1,     0x40,
                  224,      133,      -1,     -1,     0x88,
		 0x7B,   0x00e0,      -1,     -1,       -1,
		   -1,       -1,    0x40,   0x40,     0x40,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0300] */
      { "a!", "LATIN SMALL LETTER A WITH GRAVE" } },
  /* SMALL LETTER a WITH ACUTE ACCENT 
     LATIN SMALL LETTER A WITH ACUTE
     LATIN SMALL LETTER A ACUTE */
  { "a'",  {'a','\''},1, NULL,
      {            -1,     0xE1,    0xE1,     -1,       -1,
		   -1,       -1,      -1,    225,      225,
                   -1,     0xE1,     -1,      -1,       -1,
                  225,      160,     -1,      -1,     0x87,
		   -1,   0x00e1,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
		 0x60,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0301] */
      { "a'", "LATIN SMALL LETTER A WITH ACUTE" } },
  /* SMALL LETTER a WITH CIRCUMFLEX ACCENT 
     LATIN SMALL LETTER A WITH CIRCUMFLEX
     LATIN SMALL LETTER A CIRCUMFLEX */
  { "a^",  {'a','^'},1, NULL,
      {            -1,     0xE2,    0xE2,     -1,       -1,
		   -1,       -1,      -1,    226,      226,
                   -1,     0xE2,     -1,      -1,     0x5B,
                  226,      131,     -1,      -1,     0x89,
		   -1,   0x00e2,   -1,        -1,       -1,
		   -1,       -1,   0x5B,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0302] */
      { "a>", "LATIN SMALL LETTER A WITH CIRCUMFLEX" } },
  /* SMALL LETTER a WITH TILDE 
     LATIN SMALL LETTER A WITH TILDE
     LATIN SMALL LETTER A TILDE */
  { "a~",  {'a','~'},1, NULL,
      {            -1,     0xE3,    0xE3,     -1,       -1,
		   -1,       -1,      -1,    227,      227,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0x8B,
		   -1,   0x00e3,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,     0x7B,   0x7B,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0303] */
      { "a?", "LATIN SMALL LETTER A WITH TILDE" } },
  /* SMALL LETTER a WITH DIAERESIS 
     LATIN SMALL LETTER A WITH DIAERESIS
     LATIN SMALL LETTER A DIAERESIS */
  { "a\"", {'a','"'},1, NULL,
      {            -1,     0xE4,    0xE4,     -1,     0x7B,
		   -1,       -1,    0x7B,    228,      228,
                   -1,     0xE4,     -1,    0x7B,       -1,
                  228,      132,     -1,      -1,     0x8A,
		   -1,   0x00e4,   0x7B,    0x7B,       -1,
		   -1,        -1,    -1,      -1,     0x7B,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0308] */
      { "a:", "LATIN SMALL LETTER A WITH DIAERESIS" } },   
  /* SMALL LETTER a WITH RING ABOVE 
     LATIN SMALL LETTER A WITH RING ABOVE
     LATIN SMALL LETTER A RING */
  { "aa",  {'a','o'},1, NULL,
      {            -1,     0xE5,    0xE5,     -1,     0x7D,
		   -1,     0x7D,    0x7D,    229,      229,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      134,     -1,      -1,     0x8C,
		   -1,   0x00e5,   0x7D,    0x7D,     0x7D,
		   0x7D,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [030A] */
      { "aa", "LATIN SMALL LETTER A WITH RING ABOVE" } },
  /* SMALL DIPHTHONG a WITH e, SMALL DIPHTHONG ae 
     LATIN SMALL LIGATURE AE
     LATIN SMALL LETTER A E */
  { "ae",  {'a','e'},1, NULL,
      {            -1,     0xE6,    0xE6,     -1,       -1,
		   -1,     0x7B,      -1,    230,      230,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      145,     -1,      -1,     0xBE,
		   -1,   0x00e6,   -1,        -1,     0x7B,
		   0x7B,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
  { "ae", "LATIN SMALL LIGATURE AE" } },  
  /* SMALL LETTER c WITH CEDILLA 
     LATIN SMALL LETTER C WITH CEDILLA
     LATIN SMALL LETTER C CEDILLA */
  { "c,",  {'c',','},1, NULL,
      {            -1,     0xE7,    0xE7,     -1,       -1,
		   -1,       -1,      -1,     -1,      231,
                   -1,     0xE7,    0x5C,     -1,     0x5C,
                  231,      135,      -1,   0x7E,     0x8D,
		 0x5C,   0x00e7,      -1,     -1,       -1,
		   -1,       -1,    0x5C,     -1,     0x5C,
                   -1,     0x7C,    0x7C,   0x7D,     0x7D,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0063] & [0327] */
      { "c,", "LATIN SMALL LETTER C WITH CEDILLA" } },
  /* SMALL LETTER e WITH GRAVE ACCENT 
     LATIN SMALL LETTER E WITH GRAVE
     LATIN SMALL LETTER E GRAVE */
  { "e`",  {'e','`'},1, NULL,
      {            -1,     0xE8,    0xE8,     -1,       -1,
		   -1,       -1,      -1,     -1,      232,
                   -1,       -1,    0x7D,     -1,     0x7D,
                  232,      138,      -1,     -1,     0x8F,
		 0x7D,   0x00e8,      -1,     -1,       -1,
		   -1,       -1,    0x7D,   0x7D,     0x5F,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0065] & [0300] */
      { "e!", "LATIN SMALL LETTER E WITH GRAVE" } },
  /* SMALL LETTER e WITH ACUTE ACCENT 
     LATIN SMALL LETTER E WITH ACUTE
     LATIN SMALL LETTER E ACUTE */
  { "e'",  {'e','\''},1, NULL,
      {            -1,     0xE9,    0xE9,     -1,     0x60,
		   -1,       -1,      -1,    233,      233,
                   -1,     0xE9,    0x7B,     -1,     0x7B,
                  233,      130,     -1,      -1,     0x8E,
		 0x5D,   0x00e9,     -1,    0x60,       -1,
		   -1,       -1,   0x7B,    0x7B,     0x5B,
                   -1,       -1,      -1,      -1,      -1,
                 0x7B,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0065] & [0301] */
      { "e'", "LATIN SMALL LETTER E WITH ACUTE" } },
  /* SMALL LETTER e WITH CIRCUMFLEX ACCENT 
     LATIN SMALL LETTER E WITH CIRCUMFLEX
     LATIN SMALL LETTER E CIRCUMFLEX */
  { "e^",  {'e','^'},1, NULL,
      {            -1,     0xEA,    0xEA,     -1,       -1,
		   -1,       -1,      -1,     -1,      234,
                   -1,       -1,     -1,      -1,     0x5D,
                  234,      136,     -1,      -1,     0x90,
		   -1,   0x00ea,     -1,      -1,       -1,
		   -1,       -1,   0x5D,      -1,     0x5D,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0065] & [0302] */
  { "e>", "LATIN SMALL LETTER E WITH CIRCUMFLEX" } }, 
  /* SMALL LETTER e WITH DIAERESIS 
     LATIN SMALL LETTER E WITH DIAERESIS
     LATIN SMALL LETTER E DIAERESIS */
  { "e\"",  {'e','"'},1, NULL,
      {            -1,     0xEB,    0xEB,     -1,       -1,
		   -1,       -1,      -1,    235,      235,
                   -1,     0xEB,     -1,      -1,       -1,
                  235,      137,     -1,      -1,     0x91,
		   -1,   0x00eb,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0065] & [0308] */
      { "e:", "LATIN SMALL LETTER E WITH DIAERESIS" } },
  /* SMALL LETTER i WITH GRAVE ACCENT 
     LATIN SMALL LETTER I WITH GRAVE
     LATIN SMALL LETTER I GRAVE */
  { "i`",  {'i','`'},1, NULL,
      {            -1,     0xEC,    0xEC,     -1,       -1,
		   -1,       -1,      -1,     -1,      236,
                   -1,       -1,     -1,      -1,       -1,
                  236,      141,     -1,      -1,     0x93,
		  0x7E,  0x00ec,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0300] */
      { "i!", "LATIN SMALL LETTER I WITH GRAVE" } },
  /* SMALL LETTER i WITH ACUTE ACCENT 
     LATIN SMALL LETTER I WITH ACUTE
     LATIN SMALL LETTER I ACUTE */
  { "i'",  {'i','\''},1, NULL,
      {            -1,     0xED,    0xED,     -1,       -1,
		   -1,       -1,      -1,    237,      237,
                   -1,     0xED,     -1,      -1,       -1,
                  237,      161,     -1,      -1,     0x92,
		   -1,   0x00ed,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0301] */
      { "i'", "LATIN SMALL LETTER I WITH ACUTE" } },
  /* SMALL LETTER i WITH CIRCUMFLEX ACCENT 
     LATIN SMALL LETTER I WITH CIRCUMFLEX
     LATIN SMALL LETTER I CIRCUMFLEX */
  { "i^",  {'i','^'},1, NULL,
      {            -1,     0xEE,   0xEE,      -1,       -1,
		   -1,       -1,     -1,     238,      238,
                   -1,     0xEE,     -1,      -1,     0x5E,
                  238,      140,     -1,      -1,     0x94,
		   -1,   0x00ee,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,     0x5E,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0302] */
      { "i>", "LATIN SMALL LETTER I WITH CIRCUMFLEX" } },  

  /* SMALL LETTER i WITH DIAERESIS 
     LATIN SMALL LETTER I WITH DIAERESIS
     LATIN SMALL LETTER I DIAERESIS */
  { "i\"",  {'i','"'},1, NULL,
      {            -1,     0xEF,    0xEF,     -1,       -1,
		   -1,       -1,      -1,     -1,      239,
                   -1,       -1,     -1,      -1,       -1,
                  239,      139,     -1,      -1,     0x95,
		   -1,   0x00ef,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0308] */
      { "i:", "LATIN SMALL LETTER I WITH DIAERESIS" } },  

  /*          ASCII,   LATIN1,   MULT, SPECIAL, FINNISH,
                  UK,     NORWEGIAN, SWEDISH, LATIN4,
		....,
		ITAL, Unicode 1.1 */

  /* SMALL ICELANDIC LETTER ETH 
     LATIN SMALL LETTER ETH
     Icelandic */
  { "6",  {0,0}, 1, NULL,
      {            -1,     0xF0,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x00f0,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "d-", "LATIN SMALL LETTER ETH" /*  (Icelandic) */ } },
  /* SMALL LETTER n WITH TILDE 
     LATIN SMALL LETTER N WITH TILDE
     LATIN SMALL LETTER N TILDE */
  { "n~",  {'n','~'},1, NULL,
      {            -1,     0xF1,    0xF1,     -1,       -1,
		   -1,       -1,      -1,     -1,      241,
                   -1,       -1,      -1,     -1,       -1,
                  241,      164,      -1,   0x7D,     0x96,
		   -1,   0x00f1,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,      -1,   0x7C,     0x7C,
                   -1,       -1,    0x7C,      -1 },
      /* UNICODE Decomposition: [006E] & [0303] */
      { "n?", "LATIN SMALL LETTER N WITH TILDE" } },
  /* SMALL LETTER o WITH GRAVE ACCENT 
     LATIN SMALL LETTER O WITH GRAVE
     LATIN SMALL LETTER O GRAVE */
  { "o`",  {'o','`'},1, NULL,
      {            -1,     0xF2,    0xF2,     -1,       -1,
		   -1,       -1,      -1,     -1,      242,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      149,     -1,      -1,     0x98,
		 0x7C,   0x00f2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0300] */
      { "o!", "LATIN SMALL LETTER O WITH GRAVE" } },
  /* SMALL LETTER o WITH ACUTE ACCENT 
     LATIN SMALL LETTER O WITH ACUTE
     LATIN SMALL LETTER O ACUTE */
  { "o'",  {'o','\''},1, NULL,
      {            -1,     0xF3,    0xF3,     -1,       -1,
		   -1,       -1,      -1,     -1,      243,
                   -1,     0xF3,     -1,      -1,       -1,
                  243,      162,     -1,      -1,     0x97,
		   -1,   0x00f3,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0301] */
      { "o'", "LATIN SMALL LETTER O WITH ACUTE" } },
  /* SMALL LETTER o WITH CIRCUMFLEX ACCENT 
     LATIN SMALL LETTER O WITH CIRCUMFLEX
     LATIN SMALL LETTER O CIRCUMFLEX */
  { "o^",  {'o','^'},1, NULL,
      {            -1,     0xF4,    0xF4,     -1,       -1,
		   -1,       -1,      -1,    244,      244,
                   -1,     0xF4,     -1,      -1,     0x60,
                  244,      147,     -1,      -1,     0x99,
		   -1,   0x00f4,     -1,      -1,       -1,
		   -1,       -1,   0x60,      -1,     0x60,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0302]  */
      { "o>", "LATIN SMALL LETTER O WITH CIRCUMFLEX" } },
  /* SMALL LETTER o WITH TILDE 
     LATIN SMALL LETTER O WITH TILDE
     LATIN SMALL LETTER O TILDE */
  { "o~",  {'o','~'},1, NULL,
      {            -1,     0xF5,    0xF5,     -1,       -1,
		   -1,       -1,      -1,    245,      245,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0x9B,
		   -1,   0x00f5,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                   -1,     0x7D,   0x7D,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0303] */
      { "o?", "LATIN SMALL LETTER O WITH TILDE" } },

  /* SMALL LETTER o WITH DIAERESIS 
     LATIN SMALL LETTER O WITH DIAERESIS
     LATIN SMALL LETTER O DIAERESIS */
  { "o\"",  {'o','"'},1, NULL,
      {            -1,     0xF6,    0xF6,     -1,     0x7C,
		   -1,       -1,    0x7C,    246,      246,
                   -1,     0xF6,     -1,    0x7C,       -1,
		  246,      148,     -1,      -1,     0x9A,
		   -1,   0x00f6,   0x7C,    0x7C,       -1,
		   -1,       -1,     -1,      -1,     0x7C,
                   -1,       -1,     -1,      -1,       -1,
                 0x7C,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0308] */
      { "o:", "LATIN SMALL LETTER O WITH DIAERESIS" } },
  /* DIVISION SIGN */
  { "/",  {0,0}, 1, NULL,
      {            -1,     0xF7,      -1,     -1,       -1,
		   -1,       -1,      -1,    247,      247,
                   -1,     0xF7,     -1,      -1,       -1,
                  247,      246,    0x43,     -1,     0xD6,
		   -1,   0x00f7,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "-:", "DIVISION SIGN" } },  
  /* SMALL LETTER o WITH OBLIQUE STROKE 
     LATIN SMALL LETTER O WITH STROKE
     LATIN SMALL LETTER O SLASH */
  { "0",  {'o','/'}, 1, NULL,
      {            -1,     0xF8,    0xF8,     -1,       -1,
		   -1,     0x7C,      -1,    248,      248,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xBF,
		   -1,   0x00f8,   -1,        -1,     0x7C,
		   0x7C,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0338] */
      { "o/", "LATIN SMALL LETTER O WITH STROKE" } },
  /* LATIN SMALL LETTER BARRED O */
  { "0",  {0,0}, 1, NULL,
      {            -1,     0xF8|FC_fallback, 0xF8|FC_fallback,  -1,       -1,
		   -1,     0x7C|FC_fallback, -1, 248|FC_fallback, 248|FC_fallback,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xBF|FC_fallback,
		   -1,   0x0275,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER BARRED O" } }, /* Not in RFC1345 */

  /* SMALL LETTER u WITH GRAVE ACCENT 
     LATIN SMALL LETTER U WITH GRAVE
     LATIN SMALL LETTER U GRAVE */
  { "u`",  {'u','`'},1, NULL,
      {            -1,     0xF9,    0xF9,     -1,       -1,
		   -1,       -1,      -1,     -1,      249,
                   -1,       -1,    0x7C,     -1,      0x7C,
                  249,      151,      -1,     -1,      0x9D,
		  0x60,  0x00f9,      -1,     -1,        -1,
		    -1,      -1,    0x7C,   0x7C,      0x23,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0300] */
      { "u!", "LATIN SMALL LETTER U WITH GRAVE" } },
  /* SMALL LETTER u WITH ACUTE ACCENT 
     LATIN SMALL LETTER U WITH ACUTE
     LATIN SMALL LETTER U ACUTE */
  { "u'",  {'u','\''},1, NULL,
      {            -1,     0xFA,    0xFA,     -1,       -1,
		   -1,       -1,      -1,    250,      250,
                   -1,     0xFA,     -1,      -1,       -1,
                  250,      163,     -1,      -1,     0x9C,
		   -1,   0x00fa,     -1,      -1,       -1,
		   -1,       -1,     -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0301] */
      { "u'", "LATIN SMALL LETTER U WITH ACUTE" } },   
  /* SMALL LETTER u WITH CIRCUMFLEX ACCENT 
     LATIN SMALL LETTER U WITH CIRCUMFLEX
     LATIN SMALL LETTER U CIRCUMFLEX */
  { "u^",  {'u','^'},1, NULL,
      {            -1,     0xFB,    0xFB,     -1,       -1,
		   -1,       -1,      -1,    251,      251,
                   -1,       -1,     -1,      -1,     0x7E,
                  251,      150,     -1,      -1,     0x9E,
		   -1,   0x00fb,     -1,      -1,       -1,
		   -1,       -1,   0x7E,      -1,     0x7E,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0302] */
      { "u>", "LATIN SMALL LETTER U WITH CIRCUMFLEX" } },
  /* SMALL LETTER u WITH DIAERESIS 
     LATIN SMALL LETTER U WITH DIAERESIS
     LATIN SMALL LETTER U DIAERESIS */
  { "u\"", {'u','"'}, 1, NULL,
      {            -1,     0xFC,    0xFC,     -1,     0x7E,
		   -1,       -1,      -1,    252,      252,
                   -1,     0xFC,     -1,    0x7D,       -1,
                  252,      129,     -1,      -1,     0x9F,
		   -1,   0x00fc,     -1,    0x7E,       -1,
		   -1,       -1,     -1,      -1,     0x7D,
                   -1,       -1,      -1,      -1,      -1,
                 0x7D,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0308] */
      { "u:", "LATIN SMALL LETTER U WITH DIAERESIS" } },
  /* SMALL LETTER y WITH ACUTE ACCENT 
     LATIN SMALL LETTER Y WITH ACUTE
     LATIN SMALL LETTER Y ACUTE */
  { "y'",  {'y','\''},1, NULL,
      {            -1,     0xFD,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,     0xFD,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
                   -1,   0x00fd,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0079] & [0301] */
      { "y'", "LATIN SMALL LETTER Y WITH ACUTE" } }, 
  /* SMALL ICELANDIC LETTER THORN 
     LATIN SMALL LETTER THORN
     Icelandic */
  { "p",  {0,0}, 1, NULL,
      {            -1,     0xFE,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x00fe,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "th", "LATIN SMALL LETTER THORN" /* (Icelandic) */ } },
  /* SMALL LETTER y WITH DIAERESIS 
     LATIN SMALL LETTER Y WITH DIAERESIS
     LATIN SMALL LETTER Y DIAERESIS */
  { "y\"",  {'y','"'},1, NULL,
      {            -1,     0xFF,    0xFD,     -1,       -1,
		   -1,       -1,      -1,     -1,      255,
                   -1,       -1,     -1,      -1,       -1,
                   -1,      152,     -1,      -1,     0xD8,
                   -1,   0x00ff,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0079] & [0308] */
      { "y:", "LATIN SMALL LETTER Y WITH DIAERESIS" }},   

  /*          ASCII,   LATIN1,   MULT,  SPECIAL, FINNISH,
                  UK,      NORW,  SWEDISH,   LATIN4,   LATIN5 
		  ....,
		  ....,
		  ITAL */
  /* CAPITAL DIPHTHONG O WITH E, CAPITAL DIPHTHONG OE 
     LATIN CAPITAL LIGATURE OE
     LATIN CAPITAL LETTER O E */
  { "OE",  {'O','E'},1, NULL,
      {            -1,       -1,    0xD7,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xCE,
		   -1,   0x0152,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "OE", "LATIN CAPITAL LIGATURE OE" } },
  /* SMALL DIPHTHONG o WITH e, SMALL DIPHTHONG oe 
     LATIN SMALL LIGATURE OE
     LATIN SMALL LETTER O E */
  { "oe",  {'o','e'},1, NULL,
      {            -1,       -1,    0xF7,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,     0xCF,
		   -1,   0x0153,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "oe", "LATIN SMALL LIGATURE OE" } },
  /* CAPITAL LETTER Y WITH DIAERESIS 
     LATIN CAPITAL LETTER Y WITH DIAERESIS
     LATIN CAPITAL LETTER Y DIAERESIS */
  { "Y\"", {'Y','"'},1,NULL,
      {            -1,       -1,    0xDD,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,      -1,     -1,        -1,
		   -1,   0x0178,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0059] & [0308] */
      { "Y:", "LATIN CAPITAL LETTER Y WITH DIAERESIS" } },


  /*          ASCII,   LATIN1,   MULT,  SPECIAL, FINNISH,
                  UK,      NORW,  SWEDISH, LATIN4,  LATIN5,
	        ISO-8859-*, LATIN2,  BELGIAN,
                LATIN3,    CP437,  TECHNICAL,         MAC,
		ITAL, Unicode 1.1 */
  /* CAPITAL LETTER A WITH OGONEK
     LATIN CAPITAL LETTER A WITH OGONEK
     LATIN CAPITAL LETTER A OGONEK */
  { "A;",  {'A',';'}, 1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,    161,       -1,
                   -1,     0xA1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x0104,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0328] */
      { "A;", "LATIN CAPITAL LETTER A WITH OGONEK" } },  
  /* SMALL GREENLANDIC LETTER K / SMALL LETTER kra (Greenlandic) 
     LATIN SMALL LETTER KRA
     Greenlandic */
  { "k",  {0,0}, 1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,    162,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x0138,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "kk", "LATIN SMALL LETTER KRA" /* (Greenlandic) */ } },
  /* CAPITAL LETTER R WITH CEDILLA 
     LATIN CAPITAL LETTER R WITH CEDILLA
     LATIN CAPITAL LETTER R CEDILLA */
  { "R,",  {'R',','},1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,    163,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x0156,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0052] & [0327] */
      { "R,", "LATIN CAPITAL LETTER R WITH CEDILLA" } },
  /* CAPITAL LETTER I WITH TILDE 
     LATIN CAPITAL LETTER I WITH TILDE
     LATIN CAPITAL LETTER I TILDE */
  { "I~",  {'I','~'},1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,    165,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x0128,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0303]  */
      { "I?", "LATIN CAPITAL LETTER I WITH TILDE" } },  
  /* CAPITAL LETTER L WITH CEDILLA 
     LATIN CAPITAL LETTER L WITH CEDILLA
     LATIN CAPITAL LETTER L CEDILLA */
  { "L,",  {'L',','},1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,    166,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x013b,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004C] & [0327] */
      { "L,", "LATIN CAPITAL LETTER L WITH CEDILLA" } },
  /* CAPITAL LETTER S WITH CARON 
     LATIN CAPITAL LETTER S WITH CARON
     LATIN CAPITAL LETTER S HACEK */
  { "S<",  {'S','<'}, 1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,    169,       -1,
                   -1,     0xA9,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x0160,   -1,        -1,       -1,
		   -1,       -1,   -1,        -1,       -1,
                   -1,       -1,   -1,        -1,       -1,
                   -1,     0x5B,      -1,      -1 },
      /* UNICODE Decomposition: [0053] & [030C] */
      { "S<", "LATIN CAPITAL LETTER S WITH CARON" } },
  /* CAPITAL LETTER E WITH MACRON 
     LATIN CAPITAL LETTER E WITH MACRON
     LATIN CAPITAL LETTER E MACRON */
  { "E-",  {'E','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    170,       -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0112,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0304] */
      { "E-", "LATIN CAPITAL LETTER E WITH MACRON" } },

  /* CAPITAL LETTER G WITH CEDILLA 
     LATIN CAPITAL LETTER G WITH CEDILLA
     LATIN CAPITAL LETTER G CEDILLA */
  { "G,",  {'G',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    171,       -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0122,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0047] & [0327] */
      { "G,", "LATIN CAPITAL LETTER G WITH CEDILLA" } },
  /* CAPITAL LETTER T WITH OBLIQUE STROKE 
     LATIN CAPITAL LETTER T WITH STROKE
     LATIN CAPITAL LETTER T BAR */
  { "T/",  {'T','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    172,       -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0166,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0054] & [0335] */
      { "T/", "LATIN CAPITAL LETTER T WITH STROKE" } },
  /* CAPITAL LETTER Z WITH CARON 
     LATIN CAPITAL LETTER Z WITH CARON
     LATIN CAPITAL LETTER Z HACEK */
  { "Z<",  {'Z','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    174,       -1,
                  -1,     0xAE,      -1,     -1,       -1,
                  -1,       -1,      -1,     -1,       -1,
		  -1,   0x017d,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                   -1,      -1,      -1,     -1,       -1,
                   -1,    0x40,      -1,      -1 },
      /* UNICODE Decomposition: [005A] & [030C] */
      { "Z<", "LATIN CAPITAL LETTER Z WITH CARON" } },

  /* SMALL LETTER a WITH OGONEK 
     LATIN SMALL LETTER A WITH OGONEK
     LATIN SMALL LETTER A OGONEK */
  { "a;",  {'a',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    177,      -1,
                  -1,     0xB1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0105,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0328] */
      { "a;", "LATIN SMALL LETTER A WITH OGONEK" } },   

  /* OGONEK 
     SPACING OGONEK*/   
  { ";",  {' ',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    178,      -1,
                  -1,     0xB2,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x02DB,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompomposition: [0020] & [0328] */
      { "';", "OGONEK" } },
  /* SMALL LETTER r WITH CEDILLA 
     LATIN SMALL LETTER R WITH CEDILLA
     LATIN SMALL LETTER R CEDILLA */
  { "r,",  {'r',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    179,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,    0x0157,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0072] & [0327] */
      { "r,", "LATIN SMALL LETTER R WITH CEDILLA" } },
  /* SMALL LETTER i WITH TILDE 
     LATIN SMALL LETTER I WITH TILDE
     LATIN SMALL LETTER I TILDE */
  { "i~",  {'i','~'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    181,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0129,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0303] */
      { "i?", "LATIN SMALL LETTER I WITH TILDE" } },
  /* SMALL LETTER l WITH CEDILLA 
     LATIN SMALL LETTER L WITH CEDILLA
     LATIN SMALL LETTER L CEDILLA */
  { "l,",  {'l',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    182,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x013c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006C] & [0327] */
      { "l,", "LATIN SMALL LETTER L WITH CEDILLA" } },
  /* CARON 
     Mandarin Chinese third tone
     MODIFIER LETTER HACEK */
  { "<",  {' ','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    183,      -1,
                  -1,     0xB7,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x02c7,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "'<", "CARON" } }, 
  /* SMALL LETTER s WITH CARON 
     LATIN SMALL LETTER S WITH CARON
     LATIN SMALL LETTER S HACEK */
  { "s<",  {'s','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    185,      -1,
                  -1,     0xB9,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0161,   -1,        -1,       -1,
		  -1,       -1,   -1,        -1,       -1,
                  -1,       -1,   -1,        -1,       -1,
                  -1,     0x7B,      -1,      -1 },
      /* UNICODE Decomposition: [0073] & [030C] */
      { "s<", "LATIN SMALL LETTER S WITH CARON" } },
  /* SMALL LETTER e WITH MACRON 
     LATIN SMALL LETTER E WITH MACRON
     LATIN SMALL LETTER E MACRON */
  { "e-",  {'e','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    186,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0113,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0065] & [0304] */
      { "e-", "LATIN SMALL LETTER E WITH MACRON" } },  
  /* SMALL LETTER g WITH CEDILLA ABOVE 
     LATIN SMALL LETTER G WITH CEDILLA
     LATIN SMALL LETTER G CEDILLA */
  { "g,",  {'g',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    187,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0123,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0067] & [0327] */
      { "g,", "LATIN SMALL LETTER G WITH CEDILLA" } },
  /* SMALL LETTER t WITH STROKE 
     LATIN SMALL LETTER T WITH STROKE
     LATIN SMALL LETTER T BAR */
  { "t/",  {'t','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    188,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0167,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0074] & [0335] */
      { "t/", "LATIN SMALL LETTER T WITH STROKE" } },
  /* CAPITAL LAPPISH LETTER ENG 
     LATIN CAPITAL LETTER ENG
     Sami */
  { "NG",  {'N','G'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    189,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x014a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "NG", "LATIN CAPITAL LETTER ENG" /* (Lappish) */ } },
  /* SMALL LETTER z WITH CARON 
   LATIN SMALL LETTER Z WITH CARON
   LATIN SMALL LETTER Z HACEK */
  { "z<",  {'z','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    190,      -1,
                  -1,     0xBE,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x017e,   -1,        -1,       -1,
		  -1,       -1,   -1,        -1,       -1,
                  -1,       -1,   -1,        -1,       -1,
                  -1,     0x60,      -1,      -1 },
      /* UNICODE Decomposition: [007A] & [030C] */
      { "z<", "LATIN SMALL LETTER Z WITH CARON" } },
  /* SMALL LAPPISH LETTER eng 
     LATIN SMALL LETTER ENG
     Sami */
  { "ng",  {'n','g'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    191,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,   -1,       -1,        -1,
		  -1,   0x014b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "ng", "LATIN SMALL LETTER ENG" /* (Lappish) */ } },

  /* CAPITAL LETTER A WITH MACRON 
     LATIN CAPITAL LETTER A WITH MACRON
     LATIN CAPITAL LETTER A MACRON */
  { "A-",  {'A','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    192,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,   -1,       -1,        -1,
		  -1,   0x0100,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0304] */
      { "A-", "LATIN CAPITAL LETTER A WITH MACRON" } },
  /* CAPITAL LETTER I WITH OGONEK 
     LATIN CAPITAL LETTER I WITH OGONEK
     LATIN CAPITAL LETTER I OGONEK */
  { "I;",  {'I',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    199,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,    0x012e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0328] */
      { "I;", "LATIN CAPITAL LETTER I WITH OGONEK" } },
  /* CAPITAL LETTER C WITH CARON 
     LATIN CAPITAL LETTER C WITH CARON
     LATIN CAPITAL LETTER C HACEK */
  { "C<",  {'C','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    200,      -1,
                  -1,     0xC8,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x010c,   -1,        -1,       -1,
		  -1,       -1,   -1,        -1,       -1,
                  -1,       -1,   -1,        -1,       -1,
                  -1,     0x5E,      -1,      -1 },
      /* UNICODE Decompensation: [0043] & [030C] */
      { "C<", "LATIN CAPITAL LETTER C WITH CARON" } },
  /* CAPITAL LETTER E WITH OGONEK 
     LATIN CAPITAL LETTER E WITH OGONEK
     LATIN CAPITAL LETTER E OGONEK */
  { "E;",  {'E',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    202,      -1,
                  -1,     0xCA,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0118,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0328] */
      { "E;", "LATIN CAPITAL LETTER E WITH OGONEK" } },
  /* CAPITAL LETTER E WITH DOT ABOVE 
     LATIN CAPITAL LETTER E WITH DOT ABOVE
     LATIN CAPITAL LETTER E DOT */
  { "E.",  {'E','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    204,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0116,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0307] */
      { "E.", "LATIN CAPITAL LETTER E WITH DOT ABOVE" } },
  /* CAPITAL LETTER I WITH MACRON 
     LATIN CAPITAL LETTER I WITH MACRON
     LATIN CAPITAL LETTER I MACRON */
  { "I-",  {'I','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    207,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x012a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0304] */
      { "I-", "LATIN CAPITAL LETTER I WITH MACRON" } },
  /* CAPITAL LETTER D WITH STROKE 
     LATIN CAPITAL LETTER D WITH STROKE
     LATIN CAPITAL LETTER D BAR */
  { "D/",  {'D','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    208,       -1,
                  -1,     0xD0,      -1,     -1,       -1,
                  -1,       -1,      -1,     -1,       -1,
		  -1,   0x0110,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,      -1,     -1,       -1,
                  -1,     0x5C,      -1,     -1 },
      /* UNICODE Decompensation: [0044] & [0335] */
      { "D/", "LATIN CAPITAL LETTER D WITH STROKE" } },
  /* CAPITAL LETTER N WITH WITH CEDILLA 
     LATIN CAPITAL LETTER N WITH CEDILLA
     LATIN CAPITAL LETTER N CEDILLA */
  { "N,",  {'N',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    209,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0145,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004E] & [0327] */
      { "N,", "LATIN CAPITAL LETTER N WITH CEDILLA" } },

  /* CAPITAL LETTER O WITH MACRON 
     LATIN CAPITAL LETTER O WITH MACRON
     LATIN CAPITAL LETTER O MACRON */
  { "O-",  {'O','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    210,       -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,    0x014c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0304] */
      { "O-", "LATIN CAPITAL LETTER O WITH MACRON" } },
  /* CAPITAL LETTER K WITH CEDILLA 
     LATIN CAPITAL LETTER K WITH CEDILLA
     LATIN CAPITAL LETTER K CEDILLA */
  { "K,",  {'K',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    211,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0136,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004B] & [0327] */
      { "K,", "LATIN CAPITAL LETTER K WITH CEDILLA" } },
  /* CAPITAL LETTER U WITH OGONEK 
     LATIN CAPITAL LETTER U WITH OGONEK
     LATIN CAPITAL LETTER U OGONEK */
  { "U;",  {'U',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    217,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0172,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0328] */
      { "U;", "LATIN CAPITAL LETTER U WITH OGONEK" } },
  /* CAPITAL LETTER U WITH TILDE 
     LATIN CAPITAL LETTER U WITH TILDE
     LATIN CAPITAL LETTER U TILDE */
  { "U~",  {'U','~'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    221,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0168,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0303] */
      { "U?", "LATIN CAPITAL LETTER U WITH TILDE" } },
  /* CAPITAL LETTER U WITH MACRON 
     LATIN CAPITAL LETTER U WITH MACRON
     LATIN CAPITAL LETTER U MACRON */
  { "U-",  {'U','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    222,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x016a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0304] */
      { "U-", "LATIN CAPITAL LETTER U WITH MACRON" } },
  /* SMALL LETTER a WITH MACRON  
     LATIN SMALL LETTER A WITH MACRON
     LATIN SMALL LETTER A MACRON */
  { "a-",  {'a','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    224,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0101,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0304] */
      { "a-", "LATIN SMALL LETTER A WITH MACRON" } },  
  /* SMALL LETTER i WITH OGONEK 
     LATIN SMALL LETTER I WITH OGONEK
     LATIN SMALL LETTER I OGONEK */
  { "i;",  {'i',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    231,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,    0x012f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0328] */
      { "i;", "LATIN SMALL LETTER I WITH OGONEK" } },
  /* SMALL LETTER c WITH CARON 
     LATIN SMALL LETTER C WITH CARON
     LATIN SMALL LETTER C HACEK */
  { "c<",  {'c','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    232,      -1,
                  -1,     0xE8,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x010d,   -1,        -1,       -1,
		  -1,       -1,   -1,        -1,       -1,
                  -1,       -1,   -1,        -1,       -1,
                  -1,     0x7E,      -1,      -1 },
      /* UNICODE Decompensation: [0063] & [030C] */
      { "c<", "LATIN SMALL LETTER C WITH CARON" } },   
  /* SMALL LETTER e WITH OGONEK 
     LATIN SMALL LETTER E WITH OGONEK
     LATIN SMALL LETTER E OGONEK */
  { "e;",  {'e',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    234,      -1,
                  -1,     0xEA,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0119,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0065] & [0328] */
      { "e;", "LATIN SMALL LETTER E WITH OGONEK" } },   
  /* SMALL LETTER e WITH DOT ABOVE 
     LATIN SMALL LETTER E WITH DOT ABOVE
     LATIN SMALL LETTER E DOT */
  { "e.",  {'e','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    236,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0117,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0065] & [0307] */
      { "e.", "LATIN SMALL LETTER E WITH DOT ABOVE" } },  
  /* SMALL LETTER i WITH CARON/MACRON 
     LATIN SMALL LETTER I WITH MACRON
     LATIN SMALL LETTER I MACRON */
  { "i-",  {'i','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    239,      -1,
                  -1,       -1,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x012b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0304] */
      { "i-", "LATIN SMALL LETTER I WITH MACRON" } },
  /* SMALL LETTER d WITH STROKE 
     LATIN SMALL LETTER D WITH STROKE
     LATIN SMALL LETTER D BAR */
  { "d/",  {'d','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    240,      -1,
                  -1,     0xF0,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0111,   -1,        -1,       -1,
		  -1,       -1,   -1,        -1,       -1,
                  -1,       -1,   -1,        -1,       -1,
                  -1,     0x7C,      -1,      -1 },
      /* UNICODE Decompensation: [0064] & [0335] */
      { "d/", "LATIN SMALL LETTER D WITH STROKE" } },
  /* SMALL LETTER n WITH WITH CEDILLA 
     LATIN SMALL LETTER N WITH CEDILLA
     LATIN SMALL LETTER N CEDILLA */
  { "n,",  {'n',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    241,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0146,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006E] & [0327] */
      { "n,", "LATIN SMALL LETTER n WITH CEDILLA" } },

  /* SMALL LETTER o WITH MACRON 
     LATIN SMALL LETTER O WITH MACRON
     LATIN SMALL LETTER O MACRON */
  { "o-",  {'o','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    242,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x014d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0304] */
      { "o-", "LATIN SMALL LETTER O WITH MACRON" } },
  /* SMALL LETTER k WITH CEDILLA 
     LATIN SMALL LETTER K WITH CEDILLA
     LATIN SMALL LETTER K CEDILLA */
  { "k,",  {'k',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    243,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0137,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006B] & [0327] */
      { "k,", "LATIN SMALL LETTER K WITH CEDILLA" } },
  /* SMALL LETTER u WITH OGONEK 
     LATIN SMALL LETTER U WITH OGONEK
     LATIN SMALL LETTER U OGONEK */
  { "u;",  {'u',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    249,       -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0173,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0328] */
      { "u;", "LATIN SMALL LETTER U WITH OGONEK" } },
  /* SMALL LETTER u WITH TILDE 
     LATIN SMALL LETTER U WITH TILDE
     LATIN SMALL LETTER U TILDE */
  { "u~",  {'u','~'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    253,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0169,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0303] */
      { "u?", "LATIN SMALL LETTER U WITH TILDE" } },
  /* SMALL LETTER u WITH MACRON 
     LATIN SMALL LETTER U WITH MACRON
     LATIN SMALL LETTER U MACRON */
  { "u-",  {'u','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    254,       -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x016b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0304] */
      { "u-", "LATIN SMALL LETTER U WITH MACRON" } },
  /* DOT ABOVE 
     Mandarin Chinese light tone
     SPACING DOT ABOVE */
  { ".",  {' ','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,    255,       -1,
                  -1,     0xFF,      -1,     -1,       -1,
                 255,       -1,     -1,      -1,        -1,
		  -1,   0x02d9,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0020] & [0307]  */
      { "'.", "DOT ABOVE" } },
  

  /* CAPITAL LETTER G WITH BREVE 
     LATIN CAPITAL LETTER G WITH BREVE
     LATIN CAPITAL LETTER G BREVE */
  { "G(",  {'G','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      208,
                  -1,       -1,     -1,      -1,       -1,
                 171,       -1,     -1,      -1,        -1,
		  -1,   0x011e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0047] & [0306] */
      { "G(", "LATIN CAPITAL LETTER G WITH BREVE" } },
  /* CAPITAL LETTER I WITH DOT ABOVE 
     LATIN CAPITAL LETTER I WITH DOT ABOVE
     LATIN CAPITAL LETTER I DOT */
  { "I.",  {'I','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      221,
                  -1,       -1,     -1,      -1,       -1,
                 169,       -1,     -1,      -1,        -1,
		  -1,   0x0130,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0307] */
      { "I.", "LATIN CAPITAL LETTER I WITH DOT ABOVE" } },
  /* CAPITAL LETTER S WITH CEDILLA 
     LATIN CAPITAL LETTER S WITH CEDILLA
     LATIN CAPITAL LETTER S CEDILLA */
  { "S,",  {'S',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      222,
                  -1,     0xAA,     -1,      -1,       -1,
                 170,       -1,     -1,      -1,        -1,
		  -1,   0x015e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNIOCODE Decomposition: [0053] & [0327] */
      { "S,", "LATIN CAPITAL LETTER S WITH CEDILLA" } },

  /* SMALL LETTER g WITH BREVE 
     LATIN SMALL LETTER G WITH BREVE
     LATIN SMALL LETTER G BREVE */
  { "g(",  {'g','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      240,
                  -1,       -1,     -1,      -1,       -1,
                 187,       -1,     -1,      -1,        -1,
		  -1,   0x011f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0067] & [0306] */
      { "g(", "LATIN SMALL LETTER G WITH BREVE" } },
  /* SMALL LETTER i WITHOUT DOT 
     LATIN SMALL LETTER I DOTLESS
     LATIN SMALL LETTER DOTLESS I */
  { "i",  {'i','i'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      253,
                  -1,       -1,     -1,      -1,       -1,
                 185,       -1,     -1,      -1,        -1,
		  -1,   0x0131,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "i.", "LATIN SMALL LETTER DOTLESS I" } },

  /* SMALL LETTER s WITH CEDILLA 
     LATIN SMALL LETTER S WITH CEDILLA
     LATIN SMALL LETTER S CEDILLA */
  { "s,",  {'s',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      254,
                  -1,     0xBA,     -1,      -1,       -1,
                 186,       -1,     -1,      -1,        -1,
		  -1,   0x015f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0073] & [0327] */
      { "s,", "LATIN SMALL LETTER S WITH CEDILLA" } },

  /* BREVE 
     SPACING BREVE */
  { "(",  {' ','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,     0xA2,     -1,      -1,       -1,
                 162,       -1,     -1,      -1,        -1,
		  -1,   0x02d8,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0020] & [0306] */
      { "'(", "BREVE" } },
  /* CAPITAL LETTER L WITH STROKE 
     LATIN CAPITAL LETTER L WITH STROKE
     LATIN CAPITAL LETTER L SLASH */
  { "L/",  {'L','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xA3,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0141,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004C] & [0337] */
      { "L/", "LATIN CAPITAL LETTER L WITH STROKE" } },

  /* CAPITAL LETTER L WITH CARON 
     LATIN CAPITAL LETTER L WITH CARON
     LATIN CAPITAL LETTER L HACEK */
  { "L<",  {'L','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xA5,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x013d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004C] & [030C] */
      { "L<", "LATIN CAPITAL LETTER L WITH CARON" } },
  /* CAPITAL LETTER S WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER S WITH ACUTE
     LATIN CAPITAL LETTER S ACUTE */
  { "S'",  {'S','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xA6,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x015a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0053] & [0301] */
      { "S'", "LATIN CAPITAL LETTER S WITH ACUTE" } },
  /* CAPITAL LETTER T WITH CARON 
     LATIN CAPITAL LETTER T WITH CARON
     LATIN CAPITAL LETTER T HACEK */
  { "T<",  {'T','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xAB,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0164,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0054] & [030C] */
      { "T<", "LATIN CAPITAL LETTER T WITH CARON" } },
  /* CAPITAL LETTER Z WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER Z WITH ACUTE
     LATIN CAPITAL LETTER Z ACUTE */
  { "Z'",  {'Z','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xAC,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0179,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [005A] & [0301] */
      { "Z'", "LATIN CAPITAL LETTER Z WITH ACUTE" } },
  /* CAPITAL LETTER Z WITH DOT ABOVE 
     LATIN CAPITAL LETTER Z WITH DOT ABOVE
     LATIN CAPITAL LETTER Z DOT */
  { "Z.",  {'Z','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xAF,     -1,      -1,       -1,
                  175,       -1,    -1,      -1,        -1,
		  -1,   0x017b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [005A] & [0307] */
      { "Z.", "LATIN CAPITAL LETTER Z WITH DOT ABOVE" } },
  /* SMALL LETTER l WITH STROKE 
     LATIN SMALL LETTER L WITH STROKE
     LATIN SMALL LETTER L SLASH */
  { "l/",  {'l','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xB3,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0142,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006C] & [0337] */
      { "l/", "LATIN SMALL LETTER L WITH STROKE" } },
  /* LATIN SMALL LETTER L WITH BAR
     LATIN SMALL LETTER BARRED L */
  { "l|",  {'l','|'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x019A,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006C] & [0335] */
      { NULL, "LATIN SMALL LETTER L WITH BAR" } },  /* Not in RFC1345! */

  /* SMALL LETTER l WITH CARON 
     LATIN SMALL LETTER L WITH CARON
     LATIN SMALL LETTER L HACEK */
  { "l<",  {'l','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xB5,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x013e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006C] & [030C] */
      { "l<", "LATIN SMALL LETTER L WITH CARON" } },
  /* SMALL LETTER s WITH ACUTE ACCENT 
     LATIN SMALL LETTER S WITH ACUTE
     LATIN SMALL LETTER S ACUTE */
  { "s'",  {'s','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xB6,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x015b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0073] & [0301] */
      { "s'", "LATIN SMALL LETTER S WITH ACUTE" } },
  /* SMALL LETTER t WITH CARON 
     LATIN SMALL LETTER T WITH CARON
     LATIN SMALL LETTER T HACEK */
  { "t<",  {'t','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xBB,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0165,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0074] & [030C] */
      { "t<", "LATIN SMALL LETTER T WITH CARON" } },   
  /* SMALL LETTER z WITH ACUTE ACCENT 
     LATIN SMALL LETTER Z WITH ACUTE
     LATIN SMALL LETTER Z ACUTE */
  { "z'",  {'z','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xBC,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x017a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [007A] & [0301] */
      { "z'", "LATIN SMALL LETTER Z WITH ACUTE" } },
  /* DOUBLE ACUTE ACCENT
     SPACING DOUBLE ACUTE */
  { "\"",  {'"',' '}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xBD,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		   -1,   0x02DD,    -1,        -1,       -1,
		   -1,       -1,    -1,      -1,       -1,
                   -1,       -1,    -1,      -1,      -1,
                 0x7E,      -1,      -1,      -1 },
      /* UNICODE Decompomposition: [0020] & [030B] */
      { "'\"", "DOUBLE ACUTE ACCENT" } }, 
  /* SMALL LETTER z WITH DOT ABOVE 
     LATIN SMALL LETTER Z WITH DOT ABOVE
     LATIN SMALL LETTER Z DOT */
  { "z.",  {'z','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xBF,      -1,     -1,       -1,
                  191,       -1,    -1,      -1,        -1,
		  -1,   0x017c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [007A] & [0307] */
      { "z.", "LATIN SMALL LETTER Z WITH DOT ABOVE" } },
  /* CAPITAL LETTER R WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER R WITH ACUTE
     LATIN CAPITAL LETTER R ACUTE */
  { "R'",  {'R','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xC0,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0154,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0052] & [0301] */
      { "R'", "LATIN CAPITAL LETTER R WITH ACUTE" } },
  /* CAPITAL LETTER A WITH BREVE 
     LATIN CAPITAL LETTER A WITH BREVE
     LATIN CAPITAL LETTER A BREVE */
  { "A(",  {'A','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,     0xC3,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0102,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0306] */
      { "A(", "LATIN CAPITAL LETTER A WITH BREVE" } }, 
  /* CAPITAL LETTER L WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER L WITH ACUTE
     LATIN CAPITAL LETTER L ACUTE */
  { "L'",  {'L','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xC5,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0139,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004C] & [0301] */
      { "L'", "LATIN CAPITAL LETTER L WITH ACUTE" } },
  /* CAPITAL LETTER C WITH ACUTE ACCENT 
     LATIN CAPITAL LETTER C WITH ACUTE
     LATIN CAPITAL LETTER C ACUTE */
  { "C'",  {'C','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,      -1,      -1,     -1,       -1,
                  -1,    0xC6,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0106,   -1,        -1,       -1,
		  -1,       -1,   -1,        -1,       -1,
                  -1,       -1,   -1,        -1,       -1,
                  -1,     0x5D,      -1,      -1 },
      /* UNICODE Decomposition: [0043] & [0301] */
      { "C'", "LATIN CAPITAL LETTER C WITH ACUTE" } },
  /* CAPITAL LETTER E WITH CARON 
     LATIN CAPITAL LETTER E WITH CARON
     LATIN CAPITAL LETTER E HACEK */
  { "E<",  {'E','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,     0xCC,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x011a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0045] & [030C] */
      { "E<", "LATIN CAPITAL LETTER E WITH CARON" } },
  /* CAPITAL LETTER D WITH CARON 
     LATIN CAPITAL LETTER D WITH CARON
     LATIN CAPITAL LETTER D HACEK */
  { "D<",  {'D','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xCF,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x010e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0044] & [030C] */
      { "D<", "LATIN CAPITAL LETTER D WITH CARON" } },
  /* CAPITAL LETTER N WITH ACUTE 
     LATIN CAPITAL LETTER N WITH ACUTE
     LATIN CAPITAL LETTER N ACUTE */
  { "N'",  {'N','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xD1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0143,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004E] & [0301] */
      { "N'", "LATIN CAPITAL LETTER N WITH ACUTE" } },
  /* CAPITAL LETTER N WITH CARON 
     LATIN CAPITAL LETTER N WITH CARON
     LATIN CAPITAL LETTER N HACEK */
  { "N<",  {'N','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xD2,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0147,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004E] & [030C] */
      { "N<", "LATIN CAPITAL LETTER N WITH CARON" } },
  /* CAPITAL LETTER O WITH DOUBLE ACUTE 
     LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
     LATIN CAPITAL LETTER O DOUBLE ACUTE */
  { "O\"",  {'"','O'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xD5,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0150,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [030B] */
      { "O\"", "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE" } },
  /* CAPITAL LETTER R WITH CARON 
     LATIN CAPITAL LETTER R WITH CARON
     LATIN CAPITAL LETTER R HACEK */
  { "O<",  {'R','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xD8,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0158,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0052] & [030C] */
      { "R<", "LATIN CAPITAL LETTER R WITH CARON" } },
  /* CAPITAL LETTER U WITH RING ABOVE 
     LATIN CAPITAL LETTER U WITH RING ABOVE
     LATIN CAPITAL LETTER U RING */
  { "Uo",  {'U','o'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xD9,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x016e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [030A] */
      { "U0", "LATIN CAPITAL LETTER U WITH RING ABOVE" } },
  /* CAPITAL LETTER U WITH DOUBLE ACUTE ACCENT 
     LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
     LATIN CAPITAL LETTER U DOUBLE ACUTE */
  { "U\"",  {'"','U'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xDB,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0170,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [030B] */
      { "U\"", "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE" } },
  /* CAPITAL LETTER T WITH CEDILLA 
     LATIN CAPITAL LETTER T WITH CEDILLA
     LATIN CAPITAL LETTER T CEDILLA */
  { "T,",  {'T',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xDE,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0162,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0054] & [0327] */
      { "T,", "LATIN CAPITAL LETTER T WITH CEDILLA" } },
  /* SMALL LETTER r WITH ACUTE 
     LATIN SMALL LETTER R WITH ACUTE
     LATIN SMALL LETTER R ACUTE */
  { "r'",  {'r','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xE0,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0155,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0072] & [0301] */
      { "r'", "LATIN SMALL LETTER R WITH ACUTE" } },
  /* SMALL LETTER a WITH BREVE 
     LATIN SMALL LETTER A WITH BREVE
     LATIN SMALL LETTER A BREVE */
  { "a(",  {'a','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,     0xE3,     -1,      -1,       -1,
                  -1,       -1,    -1,      -1,        -1,
		  -1,   0x0103,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,     -1,
                   -1,      -1,      -1,      -1 },  
      /* UNICODE Decomposition: [0061] & [0306] */
      { "a(", "LATIN SMALL LETTER A WITH BREVE" } }, 
  /* SMALL LETTER l WITH ACUTE ACCENT 
     LATIN SMALL LETTER L WITH ACUTE
     LATIN SMALL LETTER L ACUTE */
  { "l'",  {'l','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xE5,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x013a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006C] & [0301] */
      { "l'", "LATIN SMALL LETTER L WITH ACUTE" } },
  /* SMALL LETTER c WITH ACUTE ACCENT 
     LATIN SMALL LETTER C WITH ACUTE
     LATIN SMALL LETTER C ACUTE */
  { "c'",  {'c','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xE6,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,    0x0107,   -1,        -1,       -1,
		  -1,        -1,   -1,        -1,       -1,
                  -1,        -1,   -1,        -1,       -1,
                  -1,      0x7D,      -1,      -1 },
      /* UNICODE Decompensation: [0063] & [0301] */
      { "c'", "LATIN SMALL LETTER C WITH ACUTE" } },  
  /* SMALL LETTER e WITH CARON 
     LATIN SMALL LETTER E WITH CARON
     LATIN SMALL LETTER E HACEK */
  { "e<",  {'e','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xEC,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x011b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0065] & [030C] */
      { "e<", "LATIN SMALL LETTER E WITH CARON" } },
  /* SMALL LETTER d WITH CARON 
     LATIN SMALL LETTER D WITH CARON
     LATIN SMALL LETTER D HACEK */
  { "d<",  {'d','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xEF,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x010f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0064] & [030C] */
      { "d<", "LATIN SMALL LETTER D WITH CARON" } },
  /* SMALL LETTER n WITH ACUTE ACCENT 
     LATIN SMALL LETTER N WITH ACUTE
     LATIN SMALL LETTER N ACUTE */
  { "n'",  {'n','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xF1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0144,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006E] & [0301] */
      { "n'", "LATIN SMALL LETTER N WITH ACUTE" } },
  /* SMALL LETTER n WITH CARON 
     LATIN SMALL LETTER N WITH CARON
     LATIN SMALL LETTER N HACEK */
  { "n<",  {'n','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xF2,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0148,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006E] & [030C] */
      { "n<", "LATIN SMALL LETTER N WITH CARON" } },
  /* SMALL LETTER o WITH DOUBLE ACUTE 
     LATIN SMALL LETTER O WITH DOUBLE ACUTE
     LATIN SMALL LETTER O DOUBLE ACUTE */
  { "o\"",  {'"','o'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xF5,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0151,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [030B] */
      { "o\"", "LATIN SMALL LETTER O WITH DOUBLE ACUTE" } },
  /* SMALL LETTER r WITH CARON 
     LATIN SMALL LETTER R WITH CARON
     LATIN SMALL LETTER R HACEK */
  { "r<",  {'r','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xF8,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0159,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0072] & [030C] */
      { "r<", "LATIN SMALL LETTER R WITH CARON" } },
  /* SMALL LETTER u WITH RING ABOVE 
     LATIN SMALL LETTER U WITH RING ABOVE
     LATIN SMALL LETTER U RING */
  { "uo",  {'u','o'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xF9,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x016f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [030A] */
      { "u0", "LATIN SMALL LETTER U WITH RING ABOVE" } },
  /* SMALL LETTER u WITH DOUBLE ACUTE 
     LATIN SMALL LETTER U WITH DOUBLE ACUTE
     LATIN SMALL LETTER U DOUBLE ACUTE */
  { "u\"",  {'"','u'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,    0xFB,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0171,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [030B] */
      { "u\"", "LATIN SMALL LETTER U WITH DOUBLE ACUTE" } },
  /* SMALL LETTER t WITH CEDILLA 
     LATIN SMALL LETTER T WITH CEDILLA
     LATIN SMALL LETTER T CEDILLA */
  { "t,",  {'t',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,     0xFE,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0163,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0074] & [0327]  */
      { "t,", "LATIN SMALL LETTER T WITH CEDILLA" } },
  /* CAPITAL LETTER H WITH STROKE 
     LATIN CAPITAL LETTER H WITH STROKE
     LATIN CAPITAL LETTER H BAR */
  { "H/",  {'H','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 161,       -1,     -1,      -1,        -1,
		  -1,   0x0126,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0048] & [0335] */
      { "H/", "LATIN CAPITAL LETTER H WITH STROKE" } },
 /* CAPITAL LETTER H WITH CIRCUMFLEX ACCENT 
    LATIN CAPITAL LETTER H WITH CIRCUMFLEX
    LATIN CAPITAL LETTER H CIRCUMFLEX */
  { "H^",  {'H','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 166,       -1,     -1,      -1,        -1,
		  -1,   0x0124,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0048] & [0302] */
      { "H>", "LATIN CAPITAL LETTER H WITH CIRCUMFLEX" } },
 /* CAPITAL LETTER J WITH CIRCUMFLEX ACCENT 
    LATIN CAPITAL LETTER J WITH CIRCUMFLEX
    LATIN CAPITAL LETTER J CIRCUMFLEX */
  { "J^",  {'J','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 172,       -1,     -1,      -1,        -1,
		  -1,   0x0134,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004A] & [0302] */
      { "J>", "LATIN CAPITAL LETTER J WITH CIRCUMFLEX" } },
  /* SMALL LETTER h WITH STROKE 
     LATIN SMALL LETTER H WITH STROKE
     LATIN SMALL LETTER H BAR */
  { "h/",  {'h','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 177,       -1,     -1,      -1,        -1,
		  -1,   0x0127,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0068] & [0335] */
      { "h/", "LATIN SMALL LETTER H WITH STROKE" } },  
  /* SMALL LETTER h WITH CIRCUMFLEX ACCENT 
     LATIN SMALL LETTER H WITH CIRCUMFLEX
     LATIN SMALL LETTER H CIRCUMFLEX */
  { "h^",  {'h','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 182,       -1,     -1,      -1,        -1,
		  -1,   0x0125,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0068] & [0302] */
      { "h>", "LATIN SMALL LETTER H WITH CIRCUMFLEX" } },
  /* SMALL LETTER j WITH CIRCUMFLEX ACCENT 
   LATIN SMALL LETTER J WITH CIRCUMFLEX
   LATIN SMALL LETTER J CIRCUMFLEX */
  { "j^",  {'j','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 188,       -1,     -1,      -1,        -1,
		  -1,   0x0135,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006A] & [0302] */
      { "j>", "LATIN SMALL LETTER J WITH CIRCUMFLEX" } },
 /* CAPITAL LETTER C WITH DOT ABOVE 
    LATIN CAPITAL LETTER C WITH DOT ABOVE
    LATIN CAPITAL LETTER C DOT */
  { "C.",  {'C','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 197,       -1,     -1,      -1,        -1,
		  -1,   0x010a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0043] & [0307] */
      { "C.", "LATIN CAPITAL LETTER C WITH DOT ABOVE" } }, 
 /* CAPITAL LETTER C WITH CIRCUMFLEX ACCENT 
    LATIN CAPITAL LETTER C WITH CIRCUMFLEX
    LATIN CAPITAL LETTER C CIRCUMFLEX */
  { "C^",  {'C','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 198,       -1,     -1,      -1,        -1,
		  -1,   0x0108,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0043] & [0302] */
      { "C>", "LATIN CAPITAL LETTER C WITH CIRCUMFLEX" } },
  /* CAPITAL LETTER G WITH DOT ABOVE 
     LATIN CAPITAL LETTER G WITH DOT ABOVE
     LATIN CAPITAL LETTER G DOT */
  { "G.",  {'G','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		 213,       -1,      -1,     -1,        -1,
		  -1,   0x0120,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0047] & [0307] */
      { "G.", "LATIN CAPITAL LETTER G WITH DOT ABOVE" } },


 /* CAPITAL LETTER G WITH CIRCUMFLEX ACCENT 
    LATIN CAPITAL LETTER G WITH CIRCUMFLEX
    LATIN CAPITAL LETTER G CIRCUMFLEX */
  { "G^",  {'G','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 216,       -1,     -1,      -1,        -1,
		  -1,    0x011c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0047] & [0302] */
      { "G>", "LATIN CAPITAL LETTER G WITH CIRCUMFLEX" } },
 /* CAPITAL LETTER U WITH BREVE
    LATIN CAPITAL LETTER U WITH BREVE
    LATIN CAPITAL LETTER U BREVE */
  { "U(",  {'U','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 221,       -1,     -1,      -1,        -1,
		  -1,   0x016c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0306] */
      { "U(", "LATIN CAPITAL LETTER U WITH BREVE" } },
 /* CAPITAL LETTER S WITH CIRCUMFLEX ACCENT 
    LATIN CAPITAL LETTER S WITH CIRCUMFLEX
    LATIN CAPITAL LETTER S CIRCUMFLEX */
  { "S^",  {'S','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 222,       -1,     -1,      -1,        -1,
		  -1,   0x015c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0053] & [0302] */
      { "S>", "LATIN CAPITAL LETTER S WITH CIRCUMFLEX" } },
 /* SMALL LETTER c WITH DOT ABOVE 
    LATIN SMALL LETTER C WITH DOT ABOVE
    LATIN SMALL LETTER C DOT */
  { "c.",  {'c','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 229,       -1,     -1,      -1,        -1,
		  -1,    0x010b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0063] & [0307] */
      { "c.", "LATIN SMALL LETTER C WITH DOT ABOVE" } },  

 /* SMALL LETTER c WITH CIRCUMFLEX ACCENT 
    LATIN SMALL LETTER C WITH CIRCUMFLEX
    LATIN SMALL LETTER C CIRCUMFLEX */
  { "c^",  {'c','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,      -1,     -1,       -1,
                 230,       -1,     -1,      -1,        -1,
		  -1,   0x0109,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0063] & [0302] */
      { "c>", "LATIN SMALL LETTER C WITH CIRCUMFLEX" } },
  /* SMALL LETTER n WITH GRAVE ACCENT */
  { "n`",  {'n','`'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 242,       -1,     -1,      -1,        -1,
		  -1,       -1,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, NULL } }, /* Not in rfc1345 !! */
  /* SMALL LETTER g WITH DOT ABOVE 
     LATIN SMALL LETTER G WITH DOT ABOVE
     LATIN SMALL LETTER G DOT */
  { "g.",  {'g','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 245,       -1,     -1,      -1,        -1,
		  -1,   0x0121,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0067] & [0307] */
      { "g.", "LATIN SMALL LETTER G WITH DOT ABOVE" } },
  /* SMALL LETTER g WITH CIRCUMFLEX ACCENT 
     LATIN SMALL LETTER G WITH CIRCUMFLEX
     LATIN SMALL LETTER G CIRCUMFLEX */
  { "g^",  {'g','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 248,       -1,     -1,      -1,        -1,
		  -1,   0x011d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decompensation: [0067] & [0302] */
      { "g>", "LATIN SMALL LETTER G WITH CIRCUMFLEX" } },  
 /* SMALL LETTER u WITH BREVE 
    LATIN SMALL LETTER U WITH BREVE
    LATIN SMALL LETTER U BREVE */
  { "u(",  {'u','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
                  -1,       -1,     -1,      -1,       -1,
                 253,       -1,     -1,      -1,        -1,
		  -1,   0x016d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0306] */
      { "u(", "LATIN SMALL LETTER U WITH BREVE" } },
 /* SMALL LETTER s WITH CIRCUMFLEX ACCENT 
    LATIN SMALL LETTER S WITH CIRCUMFLEX
    LATIN SMALL LETTER S CIRCUMFLEX */
  { "s^",  {'s','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		    -1,       -1,      -1,     -1,       -1,
		    -1,       -1,     -1,      -1,       -1,
		    254,       -1,   -1,      -1,        -1,
		  -1,     0x015d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0073] & [0302] */
      { "s>", "LATIN SMALL LETTER S WITH CIRCUMFLEX" } },

  /* CAPITAL LETTER E WITH BREVE 
     LATIN CAPITAL LETTER E WITH BREVE
     LATIN CAPITAL LETTER E BREVE */
  { "E(",  {'E','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0114,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0045] & [0306] */
      { "E(", "LATIN CAPITAL LETTER E WITH BREVE" } },

  /* SMALL LETTER e WITH BREVE 
     LATIN SMALL LETTER E WITH BREVE
     LATIN SMALL LETTER E BREVE */
  { "e(",  {'e','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0115,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0065] & [0306] */
      { "e(", "LATIN SMALL LETTER E WITH BREVE" } },  
  /* CAPITAL LETTER I WITH BREVE 
     LATIN CAPITAL LETTER I WITH BREVE
     LATIN CAPITAL LETTER I BREVE */
  { "I(",  {'I','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x012c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0306] */
      { "I(", "LATIN CAPITAL LETTER I WITH BREVE" } },
  /* SMALL LETTER i WITH BREVE 
     LATIN SMALL LETTER I WITH BREVE
     LATIN SMALL LETTER I BREVE */
  { "i(",  {'i','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x012d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [0306] */
      { "i(", "LATIN SMALL LETTER i WITH BREVE" } },

  /* CAPITAL DIPHTHONG I WITH J, CAPITAL DIPHTHONG IJ 
     LATIN CAPITAL LIGATURE IJ
     LATIN CAPITAL LETTER I J */
  { "IJ",  {'I','J'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0132,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [004A] */
      { "IJ", "LATIN CAPITAL LIGATURE IJ" } },
  /* SMALL DIPHTHONG i WITH j, SMALL DIPHTHONG ij 
   LATIN SMALL LIGATURE IJ
   LATIN SMALL LETTER I J */
  { "ij",  {'i','j'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0133,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [006A] */
      { "ij", "LATIN SMALL LIGATURE IJ" } },
  /* CAPITAL LETTER L WITH WITH MIDDLE DOT 
     LATIN CAPITAL LETTER L WITH MIDDLE DOT */
  { "L.",  {'L','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x013f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004C] & [00B7] */
      { "L.", "LATIN CAPITAL LETTER L WITH MIDDLE DOT" } },
  /* SMALL LETTER l WITH WITH MIDDLE DOT 
     LATIN SMALL LETTER L WITH MIDDLE DOT */
  { "l.",  {'l','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0140,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006C] & [00B7] */
      { "l.", "LATIN SMALL LETTER L WITH MIDDLE DOT" } },
  /* SMALL LETTER n PRECEDED BY APOSTROPHE 
   LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
   LATIN SMALL LETTER APOSTROPHE N */
  { "'n",  {'\'','n'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0149,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0027] & [006E] */
      { "'n", "LATIN SMALL LETTER N PRECEDED BY APOSTROPHE" } },
  /* CAPITAL LETTER O WITH WITH BREVE 
     LATIN CAPITAL LETTER O WITH BREVE
     LATIN CAPITAL LETTER O BREVE */
  { "O(",  {'O','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x014e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0306] */
      { "O(", "LATIN CAPITAL LETTER O WITH BREVE" } },
  /* SMALL LETTER o WITH WITH BREVE 
     LATIN SMALL LETTER O WITH BREVE
     LATIN SMALL LETTER O BREVE */
  { "o(",  {'o','('}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x014f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0306] */
      { "o(", "LATIN SMALL LETTER O WITH BREVE" } },
  /* CAPITAL LETTER W WITH WITH CIRCUMFLEX 
     LATIN CAPITAL LETTER W WITH CIRCUMFLEX
     LATIN CAPITAL LETTER W CIRCUMFLEX */
  { "W^",  {'W','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0174,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0057] & [0302] */
      { "W>", "LATIN CAPITAL LETTER W WITH CIRCUMFLEX" } },
  /* SMALL LETTER w WITH WITH CIRCUMFLEX 
     LATIN SMALL LETTER W WITH CIRCUMFLEX
     LATIN SMALL LETTER W CIRCUMFLEX */
  { "w^",  {'w','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0175,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0077] & [0302] */
      { "w>", "LATIN SMALL LETTER W WITH CIRCUMFLEX" } },
  /* CAPITAL LETTER Y WITH WITH CIRCUMFLEX 
     LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
     LATIN CAPITAL LETTER Y CIRCUMFLEX */
  { "Y^",  {'Y','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0176,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0059] & [0302] */
      { "Y>", "LATIN CAPITAL LETTER Y WITH CIRCUMFLEX" } },
  /* SMALL LETTER y WITH WITH CIRCUMFLEX 
     LATIN SMALL LETTER Y WITH CIRCUMFLEX
     LATIN SMALL LETTER Y CIRCUMFLEX */
  { "y^",  {'y','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x0177,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0079] & [0302] */
      { "y>", "LATIN SMALL LETTER Y WITH CIRCUMFLEX" } },  
  /* CAPITAL LETTER O WITH WITH HORN 
     LATIN CAPITAL LETTER O WITH HORN
     LATIN CAPITAL LETTER O HORN */
  { "O9",  {'O','9'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a0,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [031B] */
      { "O9", "LATIN CAPITAL LETTER O WITH HORN" } },
  /* SMALL LETTER o WITH WITH HORN 
     LATIN SMALL LETTER O WITH HORN
     LATIN SMALL LETTER O HORN */
  { "o9",  {'o','9'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a1,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [031B] */
      { "o9", "LATIN SMALL LETTER O WITH HORN" } },
  /* CAPITAL LETTER OI 
     LATIN CAPITAL LETTER OI
     LATIN CAPITAL LETTER O I */
  { "OI",  {'O','I'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a2,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "OI", "LATIN CAPITAL LETTER OI" } },
  /* LATIN SMALL LETTER OI
     LATIN SMALL LETTER O I */
  { "oi",  {'o','i'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a3,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER OI" } },  /* Not if RFC1345! */
   /* LATIN CAPITAL LETTER P WITH HOOK
      LATIN CAPITAL LETTER P HOOK */
  { "P",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a4,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER P WITH HOOK" } },  /* Not if RFC1345! */
   /* LATIN SMALL LETTER P WITH HOOK
      LATIN SMALL LETTER P HOOK */
  { "p",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER P WITH HOOK" } },  /* Not if RFC1345! */
  /* LETTER yr, LETTER YR 
     LATIN LETTER YR
     LATIN LETTER Y R */
  { "yr",  {'y','r'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a6,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "yr", "LATIN LETTER YR" } },
  /* Missing: LATIN CAPITAL LETTER TONE TWO,      UNICODE 0x01A7
              LATIN SMALL LETTER TONE TWO,        UNICODE 0x01A8  */
  /* LATIN CAPITAL LETTER ESH */
  { "ESH",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01a9,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER ESH" } },  /* Not in RFC1345! */
  /* Missing: LATIN LETTER REVERSED ESH LOOP,      UNICODE 0x01AA 
              LATIN SMALL LETTER T WITH PALATAL HOOK,
                   LATIN SMALL LETTER T PALATAL HOOK, UNICODE 0x01AB,
		   UNICODE Decomposition: [0074] & [0321] */
  /* LATIN CAPITAL LETTER T WITH HOOK
     LATIN CAPITAL LETTER T HOOK */
  { "T",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01AC,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER T WITH HOOK" } },  /* Not in RFC1345! */
  /* LATIN SMALL LETTER T WITH HOOK
     LATIN SMALL LETTER T HOOK */
  { "t",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01AD,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER T WITH HOOK" } },  /* Not in RFC1345! */
   /* Missing: LATIN CAPITAL LETTER T WITH RETROFLEX HOOK,
                       LATIN CAPITAL LETTER T RETROFLEX HOOK, UNICODE 0x01AE,
		       UNICODE Decomposition: [0054] & [0322] */
  /* CAPITAL LETTER U WITH WITH HORN 
     LATIN CAPITAL LETTER U WITH HORN
     LATIN CAPITAL LETTER U HORN */
  { "U9",  {'U','9'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01af,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [031B] */
      { "U9", "LATIN CAPITAL LETTER U WITH HORN" } },
  /* SMALL LETTER u WITH WITH HORN 
     LATIN SMALL LETTER U WITH HORN
     LATIN SMALL LETTER U HORN */
  { "u9",  {'u','9'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01b0,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [031B] */
      { "u9", "LATIN SMALL LETTER U WITH HORN" } },
  /* LATIN CAPITAL LETTER UPSILON */
  { "u",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,   0x59|FC_fallback,     
                                             -1,        -1,
		  -1,   0x01B1,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER UPSILON" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER V WITH HOOK
     LATIN CAPITAL LETTER SCRIPT V */
  { "V",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01B2,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER V WITH HOOK" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER Y WITH HOOK
     LATIN CAPITAL LETTER Y HOOK */
  { "Y",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01B3,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER Y WITH HOOK" } },  /* Not in RFC1345! */
  /* CAPITAL LETTER Z WITH WITH STROKE 
     LATIN CAPITAL LETTER Z WITH STROKE
     LATIN CAPITAL LETTER Z BAR */
  { "Z/",  {'Z','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01b5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Z/", "LATIN CAPITAL LETTER Z WITH STROKE" } },
  /* SMALL LETTER z WITH WITH STROKE 
     LATIN SMALL LETTER Z WITH STROKE
     LATIN SMALL LETTER Z BAR */
  { "z/",  {'z','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01b6,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "z/", "LATIN SMALL LETTER Z WITH STROKE" } },
  /* CAPITAL LETTER EZH 
     LATIN CAPITAL LETTER EZH
     LATIN CAPITAL LETTER YOGH */
  { "EZH",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01b7,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "ED", "LATIN CAPITAL LETTER EZH" } }, 
  /* Missing: LATIN CAPITAL LETTER EZH REVERSED,
                    LATIN CAPITAL LETTER REVERSED YOGH, UNICODE 0x01B8
	      LATIN SMALL LETTER EZH REVERSED,
                    LATIN SMALL LETTER REVERSED YOGH, UNICODE 0x01B9
	      LATIN SMALL LETTER EZH WITH TAIL,
	            LATIN SMALL LETTER YOGH WITH TAIL, UNICODE 0x01BA */
  /* LATIN LETTER TWO WITH STROKE
     LATIN LETTER TWO BAR */
  { "2/",  {'2','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01bb,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN LETTER TWO WITH STROKE" } },   /* Not in RFC1345! */
  /* Missing: LATIN CAPITAL LETTER TONE FIVE,  UNICODE 0x01BC
              LATIN SMALL LETTER TONE FIVE,    UNICODE 0x01BD
	      LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE,
                    LATIN LETTER INVERTED GLOTTAL STOP BAR, UNICODE 0x01BE */
  /* LATIN LETTER WYNN */
  { "wynn",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01bf,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN LETTER WYNN" } },   /* Not in RFC1345! */
  /* Missing: LATIN LETTER DENTAL CLICK, 
                    LATIN LETTER PIPE, UNICODE 0x01C0
              LATIN LETTER LATERAL CLICK, 
                    LATIN LETTER DOUBLE PIPE, UNICODE 0x01C1
	      LATIN LETTER ALVEOLAR CLICK,
                    LATIN LETTER PIPE DOUBLE BAR, UNICODE 0x01C2
	      LATIN LETTER RETROFLEX CLICK,
                    LATIN LETTER EXCLAMATION MARK, UNICODE 0x01C3 */
  /* LATIN CAPITAL LETTER DZ WITH CARON
     LATIN CAPITAL LETTER D Z HACEK */
  { "DZ<",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01c4,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0044] & [005A] & [030C] */
      { NULL, "LATIN CAPITAL LETTER DZ WITH CARON" } }, /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
     LATIN LETTER CAPITAL D SMALL Z HACEK */
  { "Dz<",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01c5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0044] & [007A] & [030C] */
      { NULL, "LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON" } }, 
       /* Not in RFC1345! */
  /* LATIN SMALL LETTER DZ WITH CARON
     LATIN SMALL LETTER D Z HACEK */
  { "dz<",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01c6,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0064] & [007A] & [030C]  */
      { NULL, "LATIN SMALL LETTER DZ WITH CARON" } }, /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER LJ
     LATIN CAPITAL LETTER L J */
  { "LJ",  {'L','J'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01c7,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004C] & [004A]   */
      { NULL, "LATIN CAPITAL LETTER LJ" } }, /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER L WITH SMALL LETTER J
     LATIN LETTER CAPITAL L SMALL J */
  { "Lj",  {'L','j'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01C8,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004C] & [006A] */
      { NULL, "LATIN CAPITAL LETTER L WITH SMALL LETTER J" } }, 
	/* Not in RFC1345! */
  /* LATIN SMALL LETTER LJ
     LATIN SMALL LETTER L J */
  { "lj",  {'l','j'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01C9,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition:  [006C] & [006A] */
      { NULL, "LATIN SMALL LETTER LJ" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER NJ
     LATIN CAPITAL LETTER N J */
  { "NJ",  {'N','J'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01CA,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition:  [004E] & [004A]  */
      { NULL, "LATIN CAPITAL LETTER NJ" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER N WITH SMALL LETTER J
     LATIN LETTER CAPITAL N SMALL J */
  { "Nj",  {'N','j'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01CB,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition:  [004E] & [006A]  */
      { NULL, "LATIN CAPITAL LETTER N WITH SMALL LETTER J" } },  
	/* Not in RFC1345! */
  /* LATIN SMALL LETTER NJ
     LATIN SMALL LETTER N J */
  { "nj",  {'n','j'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01CC,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition:  [006E] & [006A]   */
      { NULL, "LATIN SMALL LETTER NJ" } }, /* Not in RFC1345! */
  /* CAPITAL LETTER A WITH CARON 
     LATIN CAPITAL LETTER A WITH CARON
     LATIN CAPITAL LETTER A HACEK */
  { "A<",  {'A','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01cd,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [030C] */
      { "A<", "LATIN CAPITAL LETTER A WITH CARON" } }, 
  /* SMALL LETTER a WITH CARON 
     LATIN SMALL LETTER A WITH CARON
     LATIN SMALL LETTER A HACEK */
  { "a<",  {'a','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01ce,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [030C] */
      { "a<", "LATIN SMALL LETTER A WITH CARON" } },
  /* CAPITAL LETTER I WITH CARON 
     LATIN CAPITAL LETTER I WITH CARON
     LATIN CAPITAL LETTER I HACEK */
  { "I<",  {'I','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01cf,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [030C] */
      { "I<", "LATIN CAPITAL LETTER I WITH CARON" } }, 
  /* SMALL LETTER i WITH CARON 
     LATIN SMALL LETTER I WITH CARON
     LATIN SMALL LETTER I HACEK */
  { "i<",  {'i','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d0,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0069] & [030C] */
      { "i<", "LATIN SMALL LETTER I WITH CARON" } }, 
  /* CAPITAL LETTER O WITH CARON 
     LATIN CAPITAL LETTER O WITH CARON
     LATIN CAPITAL LETTER O HACEK */
  { "O<",  {'O','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d1,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [030C] */
      { "O<", "LATIN CAPITAL LETTER O WITH CARON" } }, 
  /* SMALL LETTER o WITH CARON 
     LATIN SMALL LETTER O WITH CARON
     LATIN SMALL LETTER O HACEK */
  { "o<",  {'o','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d2,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [030C] */
      { "o<", "LATIN SMALL LETTER O WITH CARON" } },
  /* CAPITAL LETTER U WITH CARON 
     LATIN CAPITAL LETTER U WITH CARON
     LATIN CAPITAL LETTER U HACEK */
  { "U<",  {'U','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d3,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [030C] */
      { "U<", "LATIN CAPITAL LETTER U WITH CARON" } }, 
  /* SMALL LETTER u WITH CARON 
     LATIN SMALL LETTER U WITH CARON
     LATIN SMALL LETTER U HACEK */
  { "u<",  {'u','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d4,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [030C] */
      { "u<", "LATIN SMALL LETTER U WITH CARON" } }, 
  /* CAPITAL LETTER U WITH DIAERESIS AND MACRON 
     LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
     LATIN CAPITAL LETTER U DIAERESIS MACRON */
  { "U\"-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0308] & [0304] */
      { "U:-", "LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON" } }, 
  /* SMALL LETTER u WITH DIAERESIS AND MACRON 
     LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
     LATIN SMALL LETTER U DIAERESIS MACRON */
  { "u\"-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d6,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0308] & [0304]  */
      { "u:-", "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON" } }, 
  /* CAPITAL LETTER U WITH DIAERESIS AND ACUTE 
     LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
     LATIN CAPITAL LETTER U DIAERESIS ACUTE */
  { "U\"'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d7,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0308] & [0301] */
      { "U:'", "LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE" } },
  /* SMALL LETTER u WITH DIAERESIS AND ACUTE 
     LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
     LATIN SMALL LETTER U DIAERESIS ACUTE */
  { "u\"'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d8,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },  
      /* UNICODE Decomposition: [0075] & [0308] & [0301] */
      { "u:'", "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE" } }, 
  /* CAPITAL LETTER U WITH DIAERESIS AND CARON 
   LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
   LATIN CAPITAL LETTER U DIAERESIS HACEK */
  { "U\"<",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01d9,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0308] & [030C] */
      { "U:<", "LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON" } }, 
  /* SMALL LETTER u WITH DIAERESIS AND CARON 
     LATIN SMALL LETTER U WITH DIAERESIS AND CARON
     LATIN SMALL LETTER U DIAERESIS HACEK*/
  { "u\"<",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01da,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0308] & [030C] */
      { "u:<", "LATIN SMALL LETTER U WITH DIAERESIS AND CARON" } }, 
  /* CAPITAL LETTER U WITH DIAERESIS AND GRAVE 
     LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
     LATIN CAPITAL LETTER U DIAERESIS GRAVE */
  { "U\"`",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01db,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0055] & [0308] & [0300] */
      { "U:!", "LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE" } }, 
  /* SMALL LETTER u WITH DIAERESIS AND GRAVE 
     LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
     LATIN SMALL LETTER U DIAERESIS GRAVE */
  { "u\"`",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01dc,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0075] & [0308] & [0300] */
      { "u:!", "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE" } }, 
  /* LATIN SMALL LETTER TURNED E */
  { "e",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01DD,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER TURNED E" } }, /* Not in RFC1345! */
  /* CAPITAL LETTER A WITH DIAERESIS AND MACRON 
     LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
     LATIN CAPITAL LETTER A DIAERESIS MACRON */
  { "A\"-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01de,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0308] & [0304] */
      { "A1", "LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON" } }, 
  /* SMALL LETTER a WITH DIAERESIS AND MACRON 
     LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
     LATIN SMALL LETTER A DIAERESIS MACRON */
  { "a\"-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01df,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0308] & [0304] */
      { "a1", "LATIN SMALL LETTER A WITH DIAERESIS AND MACRON" } }, 
  /* CAPITAL LETTER A WITH DOT ABOVE AND MACRON 
     LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
     LATIN CAPITAL LETTER A DOT MACRON */
  { "A.-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e0,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [0307] & [0304] */
      { "A7", "LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON" } }, 
  /* SMALL LETTER a WITH DOT ABOVE AND MACRON 
     LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
     LATIN SMALL LETTER A DOT MACRON */
  { "a.-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e1,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [0307] & [0304] */
      { "a7", "LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON" } }, 
  /* CAPITAL DIPHTHONG A WITH E AND MACRON, 
     CAPITAL DIPHTHONG AE WITH MACRON 
     LATIN CAPITAL LIGATURE AE WITH MACRON
     LATIN CAPITAL LETTER A E MACRON */
  { "AE-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e2,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [00C6] & [0304] */
      { "A3", "LATIN CAPITAL LIGATURE AE WITH MACRON" } }, 
  /* SMALL DIPHTHONG e WITH e AND MACRON, 
     SMALL DIPHTHONG ae WITH MACRON 
     LATIN SMALL LIGATURE AE WITH MACRON
     LATIN SMALL LETTER A E MACRON */
  { "ae-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e3,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [00E6] & [0304] */
      { "a3", "LATIN SMALL LIGATURE AE WITH MACRON" } }, 
  /* CAPITAL LETTER G WITH STROKE 
     LATIN CAPITAL LETTER G WITH STROKE
     LATIN CAPITAL LETTER G BAR */
  { "G/",  {'G','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e4,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0047] & [0335] */
      { "G/", "LATIN CAPITAL LETTER G WITH STROKE" } }, 
  /* SMALL LETTER g WITH STROKE 
     LATIN SMALL LETTER G WITH STROKE
     LATIN SMALL LETTER G BAR */
  { "g/",  {'g','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0067] & [0335] */
      { "g/", "LATIN SMALL LETTER G WITH STROKE" } },
  /* CAPITAL LETTER G WITH CARON 
     LATIN CAPITAL LETTER G WITH CARON
     LATIN CAPITAL LETTER G HACEK */
  { "G<",  {'G','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e6,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0047] & [030C] */
      { "G<", "LATIN CAPITAL LETTER G WITH CARON" } }, 
  /* SMALL LETTER g WITH CARON 
     LATIN SMALL LETTER G WITH CARON
     LATIN SMALL LETTER G HACEK */
  { "g<",  {'g','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e7,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0067] & [030C] */
      { "g<", "LATIN SMALL LETTER G WITH CARON" } }, 
  /* CAPITAL LETTER K WITH CARON 
     LATIN CAPITAL LETTER K WITH CARON
     LATIN CAPITAL LETTER K HACEK */
  { "K<",  {'K','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e8,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004B] & [030C] */
      { "K<", "LATIN CAPITAL LETTER K WITH CARON" } }, 
  /* SMALL LETTER k WITH CARON 
     LATIN SMALL LETTER K WITH CARON
     LATIN SMALL LETTER K HACEK */
  { "k<",  {'k','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01e9,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006B] & [030C] */
      { "k<", "LATIN SMALL LETTER K WITH CARON" } },
  /* CAPITAL LETTER O WITH OGONEK 
     LATIN CAPITAL LETTER O WITH OGONEK
     LATIN CAPITAL LETTER O OGONEK */
  { "O;",  {'O',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01ea,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0328] */
      { "O;", "LATIN CAPITAL LETTER O WITH OGONEK" } }, 
  /* SMALL LETTER o WITH OGONEK 
     LATIN SMALL LETTER O WITH OGONEK
     LATIN SMALL LETTER O OGONEK */
  { "o;",  {'o',';'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01eb,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0328] */
      { "o;", "LATIN SMALL LETTER O WITH OGONEK" } },
  /* CAPITAL LETTER O WITH OGONEK AND MACRON 
     LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
     LATIN CAPITAL LETTER O OGONEK MACRON */
  { "O;-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01ec,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0328] & [0304] */
      { "O1", "LATIN CAPITAL LETTER O WITH OGONEK AND MACRON" } }, 
  /* SMALL LETTER o WITH OGONEK AND MACRON 
     LATIN SMALL LETTER O WITH OGONEK AND MACRON
     LATIN SMALL LETTER O OGONEK MACRON */
  { "o;-",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01ed,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0328] & [0304] */
      { "o1", "LATIN SMALL LETTER O WITH OGONEK AND MACRON" } }, 
   /* CAPITAL LETTER EZH WITH CARON 
      LATIN CAPITAL LETTER EZH WITH CARON
      LATIN CAPITAL LETTER YOGH HACEK */
  { "EZH<",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01ee,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [01B7] & [030C] */
      { "EZ", "LATIN CAPITAL LETTER EZH WITH CARON" } }, 
   /* SMALL LETTER ezh WITH CARON 
      LATIN SMALL LETTER EZH WITH CARON
      LATIN SMALL LETTER YOGH HACEK */
  { "ezh<",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01ef,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0292] & [030C] */
      { "ez", "LATIN SMALL LETTER EZH WITH CARON" } }, 
  /* SMALL LETTER j WITH CARON 
     LATIN SMALL LETTER J WITH CARON
     LATIN SMALL LETTER J HACEK */
  { "j<",  {'j','<'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01f0,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006A] & [030C] */
      { "j<", "LATIN SMALL LETTER J WITH CARON" } },
  /* LATIN CAPITAL LETTER DZ */
  { "DZ",  {'D','Z'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01f1,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0044] & [005A]  */
      { NULL, "LATIN CAPITAL LETTER DZ" } }, /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER D WITH SMALL LETTER Z */
  { "Dz",  {'D','z'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01f2,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0044] & [007A] */
      { NULL, "LATIN CAPITAL LETTER D WITH SMALL LETTER Z" } }, 
	/* Not in RFC1345! */
  /* LATIN SMALL LETTER DZ */
  { "dz",  {'d','z'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x01f3,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0064] & [007A] */
      { NULL, "LATIN SMALL LETTER DZ" } }, /* Not in RFC1345! */
  /* CAPITAL LETTER G WITH ACUTE 
     LATIN CAPITAL LETTER G WITH ACUTE */
  { "G'",  {'G','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01f4,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0047] & [0301] */
      { "G'", "LATIN CAPITAL LETTER G WITH ACUTE" } },
  /* SMALL LETTER g WITH ACUTE 
     LATIN SMALL LETTER G WITH ACUTE */
  { "g'",  {'g','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01f5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0067] & [0301] */
      { "g'", "LATIN SMALL LETTER G WITH ACUTE" } },
  /* CAPITAL LETTER A WITH RING ABOVE AND ACUTE 
     LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE */
  { "AA'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01fa,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0041] & [030A] & [0301] */
      { "AA'", "LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE" } },
  /* SMALL LETTER a WITH RING ABOVE AND ACUTE 
     LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE */
  { "aa'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01fb,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0061] & [030A] & [0301] */
      { "aa'", "LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE" } },
  /* CAPITAL LETTER AE WITH ACUTE,
     CAPITAL DIPHTHONG A WITH E AND ACUTE,
     CAPITAL DIPHTHONG AE WITH ACUTE 
     LATIN CAPITAL LIGATURE AE WITH ACUTE */
  { "AE'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01fc,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [00C6] & [0301] */
      { "AE'", "LATIN CAPITAL LIGATURE AE WITH ACUTE" } },
  /* SMALL LETTER ae WITH ACUTE,
     SMALL DIPHTHONG a WITH e AND ACUTE,
     SMALL DIPHTHONG ae WITH ACUTE 
     LATIN SMALL LIGATURE AE WITH ACUTE */
  { "ae'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01fd,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [00E6] & [0301] */
      { "ae'", "LATIN SMALL LIGATURE AE WITH ACUTE" } },
  /* CAPITAL LETTER O WITH STROKE AND ACUTE 
     LATIN CAPITAL LETTER O WITH STROKE AND ACUTE */
  { "O/'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01fe,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [004F] & [0338] & [0301] */
      { "O/'", "LATIN CAPITAL LETTER O WITH STROKE AND ACUTE" } },
  /* SMALL LETTER o WITH STROKE AND ACUTE 
     LATIN SMALL LETTER O WITH STROKE AND ACUTE */
  { "o/'",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x01ff,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [006F] & [0338] & [0301] */
      { "o/'", "LATIN SMALL LETTER O WITH STROKE AND ACUTE" } },
  /* Missing: LATIN CAPITAL LETTER A WITH DOUBLE GRAVE, UNICODE 0x0200,
                    UNICODE Decomposition: [0041] & [030F] 
	      LATIN SMALL LETTER A WITH DOUBLE GRAVE,   UNICODE 0x0201,
	            UNICODE Decomposition: [0061] & [030F] 
	      LATIN CAPITAL LETTER A WITH INVERTED BREVE, UNICODE 0x0202,
	            UNICODE Decomposition: [0041] & [0311] 
              LATIN SMALL LETTER A WITH INVERTED BREVE,   UNICODE 0x0203,
	            UNICODE Decomposition: [0061] & [0311] 
              LATIN CAPITAL LETTER E WITH DOUBLE GRAVE,   UNICODE 0x0204,
	            UNICODE Decomposition: [0045] & [030F] 
	      LATIN SMALL LETTER E WITH DOUBLE GRAVE,     UNICODE 0x0205,
	            UNICODE Decomposition: [0065] & [030F] 
              LATIN CAPITAL LETTER E WITH INVERTED BREVE, UNICODE 0x0206,
	            UNICODE Decomposition: [0045] & [0311] 
              LATIN SMALL LETTER E WITH INVERTED BREVE,   UNICODE 0x0207,
                    UNICODE Decomposition: [0065] & [0311] 
              LATIN CAPITAL LETTER I WITH DOUBLE GRAVE,   UNICODE 0x0208,
                    UNICODE Decomposition: [0049] & [030F] 
              LATIN SMALL LETTER I WITH DOUBLE GRAVE,   UNICODE 0x0209,
                    UNICODE Decomposition: [0069] & [030F] 
              LATIN CAPITAL LETTER I WITH INVERTED BREVE,   UNICODE 0x020A,
                    UNICODE Decomposition: [0049] & [0311] 
              LATIN SMALL LETTER I WITH INVERTED BREVE,   UNICODE 0x020B,
                    UNICODE Decomposition: [0069] & [0311] 
              LATIN CAPITAL LETTER O WITH DOUBLE GRAVE,   UNICODE 0x020C,
                    UNICODE Decomposition: [004F] & [030F] 
              LATIN SMALL LETTER O WITH DOUBLE GRAVE,   UNICODE 0x020D,
                    UNICODE Decomposition: [006F] & [030F] 
              LATIN CAPITAL LETTER O WITH INVERTED BREVE,   UNICODE 0x020E,
                    UNICODE Decomposition: [004F] & [0311] 
              LATIN SMALL LETTER O WITH INVERTED BREVE,   UNICODE 0x020F,
                    UNICODE Decomposition: [006F] & [0311] 
              LATIN CAPITAL LETTER R WITH DOUBLE GRAVE,   UNICODE 0x0210,
                    UNICODE Decomposition: [0052] & [030F] 
              LATIN SMALL LETTER R WITH DOUBLE GRAVE,   UNICODE 0x0211,
                    UNICODE Decomposition: [0072] & [030F] 
              LATIN CAPITAL LETTER R WITH INVERTED BREVE,   UNICODE 0x0212,
                    UNICODE Decomposition: [0052] & [0311] 
              LATIN SMALL LETTER R WITH INVERTED BREVE,   UNICODE 0x0213,
                    UNICODE Decomposition: [0072] & [0311] 
              LATIN CAPITAL LETTER U WITH DOUBLE GRAVE,   UNICODE 0x0214,
                    UNICODE Decomposition: [0055] & [030F] 
              LATIN SMALL LETTER U WITH DOUBLE GRAVE,   UNICODE 0x0215,
                    UNICODE Decomposition: [0075] & [030F] 
              LATIN CAPITAL LETTER U WITH INVERTED BREVE,   UNICODE 0x0216,
                    UNICODE Decomposition: [0055] & [0311] 
              LATIN SMALL LETTER U WITH INVERTED BREVE,   UNICODE 0x0217,
                    UNICODE Decomposition: [0075] & [0311] */ 
  /* LATIN SMALL LETTER TURNED A */
  { "a",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0250,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER TURNED A" } }, /* Not in RFC1345 */
   /* LATIN SMALL LETTER ALPHA
      LATIN SMALL LETTER SCRIPT A */
  { "a",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,      224 | FC_fallback,    
		                    0x61 | FC_fallback,      -1,        -1,
		  -1,   0x0251,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER ALPHA" } }, /* Not in RFC1345 */
      /* Missing: LATIN SMALL LETTER TURNED ALPHA,
                        LATIN SMALL LETTER TURNED SCRIPT A, UNICODE 0x0252 */
  /* LATIN SMALL LETTER B WITH HOOK
     LATIN SMALL LETTER B HOOK */
  { "b",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0253,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER B WITH HOOK" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER OPEN O,   UNICODE 0x0254
              LATIN SMALL LETTER C WITH CURL,
	            LATIN SMALL LETTER C CURL, UNICODE 0x0255
	      LATIN SMALL LETTER D WITH TAIL,
	            LATIN SMALL LETTER D RETROFLEX HOOK, UNICODE 0x0256 */
  /* LATIN SMALL LETTER D WITH HOOK
     LATIN SMALL LETTER D HOOK */
  { "d",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0257,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER D WITH HOOK" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER REVERSED E */
  { "e",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0258,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER REVERSED E" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER SCHWA,  UNICODE 0x0259
              LATIN SMALL LETTER SCHWA WITH HOOK,
                    LATIN SMALL LETTER SCHWA HOOK, UNICODE 0x025A */
  /* LATIN SMALL LETTER OPEN E
     LATIN SMALL LETTER EPSILON */
  { "e",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,  0x65 | FC_fallback,      -1,        -1,
		  -1,   0x025B,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER OPEN E" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER REVERSED OPEN E,
                    LATIN SMALL LETTER REVERSED EPSILON, UNICODE 0x025C
              LATIN SMALL LETTER REVERSED OPEN E WITH HOOK,
	            LATIN SMALL LETTER REVERSED EPSILON HOOK, UNICODE 0x025D
              LATIN SMALL LETTER CLOSED REVERSED OPEN E,
	            LATIN SMALL LETTER CLOSED REVERSED EPSILON, UNICODE 0x025E
              */
  /* LATIN SMALL LETTER DOTLESS J WITH STROKE
     LATIN SMALL LETTER DOTLESS J BAR */
  { "j/",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x025F,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER DOTLESS J WITH STROKE" } }, 
	/* Not in RF1345! */
  /* LATIN SMALL LETTER G WITH HOOK
     LATIN SMALL LETTER G HOOK */
  { "g",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0260,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER G WITH HOOK" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER SCRIPT G,   UNICODE 0x0261
              LATIN LETTER SMALL CAPITAL G,  UNICODE 0x0262 */
  /* LATIN SMALL LETTER GAMMA */
  { "g",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,   0x67|FC_fallback,      
                                             -1,        -1,
		  -1,   0x0263,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER GAMMA" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER RAMS HORN,
                    LATIN SMALL LETTER BABY GAMMA, UNICODE 0x0264 */
  /* LATIN SMALL LETTER TURNED H */
  { "h",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0265,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED H" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER H WITH HOOK
     LATIN SMALL LETTER H HOOK */
  { "h",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0266,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER H WITH HOOK" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER HENG WITH HOOK,
                    LATIN SMALL LETTER HENG HOOK, UNICODE 0x0267 */
  /* LATIN SMALL LETTER I WITH STROKE
     LATIN SMALL LETTER BARRED I */
  { "i/",  {'i','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0268,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER I WITH STROKE" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER IOTA */
  { "i",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,  0x69|FC_fallback,      
		                             -1,        -1,
		  -1,   0x0269,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER IOTA" } }, /* Not in RFC1345 */
  /* Missing: LATIN LETTER SMALL CAPITAL I,  UNICODE 0x026A */ 
  /* LATIN SMALL LETTER L WITH MIDDLE TILDE */
  { "l~",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x026B,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER L WITH MIDDLE TILDE" } }, 
	/* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER L WITH BELT,
                    LATIN SMALL LETTER L BELT, UNICODE 0x026C
	      LATIN SMALL LETTER L WITH RETROFLEX HOOK,
	            LATIN SMALL LETTER L RETROFLEX HOOK, UNICODE 0x026D
	      LATIN SMALL LETTER LEZH,
	            LATIN SMALL LETTER L YOGH, UNICODE 0x026E */
  /* LATIN SMALL LETTER TURNED M */
  { "m",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x026F,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED M" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER TURNED M WITH LONG LEG, UNICODE 0x0270 */
  /* LATIN SMALL LETTER M WITH HOOK,
     LATIN SMALL LETTER M HOOK */
  { "m",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0271,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER M WITH HOOK" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER N WITH LEFT HOOK,
                    LATIN SMALL LETTER N HOOK, UNICODE 0x0272 
              LATIN SMALL LETTER N WITH RETROFLEX HOOK,
	            LATIN SMALL LETTER N RETROFLEX HOOK, UNICODE 0x0273
              LATIN LETTER SMALL CAPITAL N,   UNICODE 0x0274 
	      LATIN LETTER SMALL CAPITAL OE,
	            LATIN LETTER SMALL CAPITAL O E, UNICODE 0x0276
	      LATIN SMALL LETTER CLOSED OMEGA, UNICODE 0x0277 */
  /* LATIN SMALL LETTER PHI */
  { "p",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,   0x66|FC_fallback,      
		                             -1,        -1,
		  -1,   0x0278,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER PHI" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER TURNED R */
  { "r",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0279,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED R" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER TURNED R WITH LONG LEG, UNICODE 0x027A
              LATIN SMALL LETTER TURNED R WITH HOOK,
	            LATIN SMALL LETTER TURNED R HOOK, UNICODE 0x027B 
	      LATIN SMALL LETTER R WITH LONG LEG, UNICODE 0x027C 
	      LATIN SMALL LETTER R WITH TAIL,
	            LATIN SMALL LETTER R HOOK, UNICODE 0x027D 
	      LATIN SMALL LETTER R WITH FISHHOOK,
	            LATIN SMALL LETTER FISHHOOK R, UNICODE 0x027E
              LATIN SMALL LETTER REVERSED R WITH FISHHOOK,
	            LATIN SMALL LETTER REVERSED FISHHOOK R, UNICODE 0x027F
              LATIN LETTER SMALL CAPITAL R, UNICODE 0x0280 
	      LATIN LETTER SMALL CAPITAL INVERTED R, UNICODE 0x0281 */
  /* LATIN SMALL LETTER S WITH HOOK
     LATIN SMALL LETTER S HOOK */
  { "s",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0282,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER S WITH HOOK" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER ESH */
  { "esh",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0283,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER ESH" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK,
                    LATIN SMALL LETTER DOTLESS J BAR HOOK, UNICODE 0x0284 
	      LATIN SMALL LETTER SQUAT REVERSED ESH,  UNICODE 0x0285
	      LATIN SMALL LETTER ESH WITH CURL,
	            LATIN SMALL LETTER ESH CURL,  UNICODE 0x0286 */
  /* LATIN SMALL LETTER TURNED T */
  { "t",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0287,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED T" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER T WITH RETROFLEX HOOK,
                    LATIN SMALL LETTER T RETROFLEX HOOK, UNICODE 0x0288 */
  /* LATIN SMALL LETTER U BAR */
  { "u|",  {'u','|'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0289,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER U BAR" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER UPSILON */
  { "u",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,  0x79|FC_fallback,      
		                             -1,        -1,
		  -1,   0x028A,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER UPSILON" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER V WITH HOOK
     LATIN SMALL LETTER SCRIPT V */
  { "v",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x028B,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER V WITH HOOK" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER TURNED V */
  { "v",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x028C,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED V" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER TURNED W */
  { "w",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x028D,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED W" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER TURNED Y */
  { "y",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x028E,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED Y" } }, /* Not in RFC1345 */
  /* Missing: LATIN LETTER SMALL CAPITAL Y,  UNICODE 0x028F
              LATIN SMALL LETTER Z WITH RETROFLEX HOOK,
	            LATIN SMALL LETTER Z RETROFLEX HOOK,  UNICODE 0x0290
	      LATIN SMALL LETTER Z WITH CURL,
	            LATIN SMALL LETTER Z CURL,   UNICODE 0x0291  */
  /* LATIN SMALL LETTER EZH,
     LATIN SMALL LETTER YOGH */
  { "ezh",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0292,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "ed", "LATIN SMALL LETTER EZH" } }, /* Position 0xe01e in RFC1345 */
  /* Missing: LATIN SMALL LETTER EZH WITH CURL,
                    LATIN SMALL LETTER YOGH CURL,   UNICODE 0x0293
              LATIN LETTER GLOTTAL STOP,            UNICODE 0x0294
              LATIN LETTER PHARYNGEAL VOICED FRICATIVE,
                    LATIN LETTER REVERSED GLOTTAL STOP,  UNICODE 0x0295
              LATIN LETTER INVERTED GLOTTAL STOP,   UNICODE 0x0296
              LATIN LETTER STRETCHED C,             UNICODE 0x0297
	      LATIN LETTER BILABIAL CLICK,
                    LATIN LETTER BULLSEYE,          UNICODE 0x0298
              LATIN LETTER SMALL CAPITAL B,         UNICODE 0x0299
              LATIN SMALL LETTER CLOSED OPEN E,
	            LATIN SMALL LETTER CLOSED EPSILON,   UNICODE 0x029A
	      LATIN LETTER SMALL CAPITAL G WITH HOOK,
                    LATIN LETTER SMALL CAPITAL G HOOK,   UNICODE 0x029B
              LATIN LETTER SMALL CAPITAL H,         UNICODE 0x029C
              LATIN SMALL LETTER J WITH CROSSED-TAIL,
                    LATIN SMALL LETTER CROSSED-TAIL J,   UNICODE 0x029D */
  /* LATIN SMALL LETTER TURNED K */
  { "k",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x029E,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TURNED K" } }, /* Not in RFC1345 */
  /* Missing: LATIN LETTER SMALL CAPITAL L,    UNICODE 0x029F */
  /* LATIN SMALL LETTER Q WITH HOOK
     LATIN SMALL LETTER Q HOOK */
  { "q",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x02A0,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER Q WITH HOOK" } }, /* Not in RFC1345 */
  /* Missing: LATIN LETTER GLOTTAL STOP WITH STROKE,
                    LATIN LETTER GLOTTAL STOP BAR,    UNICODE 0x02A1
              LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE
                    LATIN LETTER REVERSED GLOTTAL STOP BAR,   UNCODE 0x02A2 */
  /* LATIN SMALL LETTER DZ DIGRAPH
     LATIN SMALL LETTER D Z */
  { "dz",  {'d','z'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x02A3,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER DZ DIGRAPH" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER DEZH DIGRAPH,
                    LATIN SMALL LETTER D YOGH,   UNICODE 0x02A4
	      LATIN SMALL LETTER DZ DIGRAPH WITH CURL,
	            LATIN SMALL LETTER D Z CURL, UNICODE 0x02A5 */
  /* LATIN SMALL LETTER TS DIGRAPH
     LATIN SMALL LETTER T S */
  { "ts",  {'t','s'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x02A6,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TS DIGRAPH" } }, /* Not in RFC1345 */
  /* LATIN SMALL LETTER TESH DIGRAPH
     LATIN SMALL LETTER T ESH */
  { "tesh",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x02A7,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { NULL, "LATIN SMALL LETTER TESH DIGRAPH" } }, /* Not in RFC1345 */
  /* Missing: LATIN SMALL LETTER TC DIGRAPH WITH CURL,
                    LATIN SMALL LETTER T C CURL, UNICODE 0x02A8 */

  /* LATIN CAPITAL LETTER A WITH RING BELOW */
  { "A_0",  {'A','0'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e00,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "A-0", "LATIN CAPITAL LETTER A WITH RING BELOW" } },  
  /* LATIN SMALL LETTER a WITH RING BELOW */
  { "a_0",  {'A','0'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e01,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "a-0", "LATIN SMALL LETTER A WITH RING BELOW" } },  
  /* LATIN CAPITAL LETTER B WITH DOT ABOVE */
  { "B.",  {'B','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e02,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "B.", "LATIN CAPITAL LETTER B WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER b WITH DOT ABOVE */
  { "b.",  {'b','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e03,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "b.", "LATIN SMALL LETTER B WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER B WITH DOT BELOW */
  { "B_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e04,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "B-.", "LATIN CAPITAL LETTER B WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER b WITH DOT BELOW */
  { "b_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e05,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "b-.", "LATIN SMALL LETTER B WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER B WITH LINE BELOW */
  { "B_",  {'B','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e06,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "B_", "LATIN CAPITAL LETTER B WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER b WITH LINE BELOW */
  { "b_",  {'b','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e07,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "b_", "LATIN SMALL LETTER B WITH LINE BELOW" } },  
  /* LATIN CAPITAL LETTER D WITH DOT ABOVE */
  { "D.",  {'D','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e0a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "D.", "LATIN CAPITAL LETTER D WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER d WITH DOT ABOVE */
  { "d.",  {'d','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e0b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "d.", "LATIN SMALL LETTER D WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER D WITH DOT BELOW */
  { "D_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e0c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "D-.", "LATIN CAPITAL LETTER D WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER d WITH DOT BELOW */
  { "d_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e0d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "d-.", "LATIN SMALL LETTER D WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER D WITH LINE BELOW */
  { "D_",  {'D','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e0e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "D_", "LATIN CAPITAL LETTER D WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER d WITH LINE BELOW */
  { "d_",  {'d','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e0f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "d_", "LATIN SMALL LETTER D WITH LINE BELOW" } }, 
  /* LATIN CAPITAL LETTER D WITH CEDILLA */
  { "D,",  {'D',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e10,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "D,", "LATIN CAPITAL LETTER D WITH CEDILLA" } },  
  /* LATIN SMALL LETTER d WITH CEDILLA */
  { "d,",  {'d',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e11,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "d,", "LATIN SMALL LETTER D WITH CEDILLA" } },  
  /* LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW */ 
  { "D>",  {'D','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e12,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "D->", "LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW" } },  
  /* LATIN SMALL LETTER d WITH CIRCUMFLEX BELOW */ 
  { "d>",  {'d','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e13,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "d->", "LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW" } },  
  /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW */ 
  { "E>",  {'E','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e18,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "E->", "LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW" } },  
  /* LATIN SMALL LETTER e WITH CIRCUMFLEX BELOW */ 
  { "e>",  {'e','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e19,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "e->", "LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW" } },  
  /* LATIN CAPITAL LETTER E WITH TILDE BELOW */ 
  { "E_~",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e1a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "E-?", "LATIN CAPITAL LETTER E WITH TILDE BELOW" } },  
  /* LATIN SMALL LETTER e WITH TILDE BELOW */ 
  { "e_~",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e1b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "e-?", "LATIN SMALL LETTER E WITH TILDE BELOW" } },  
  /* LATIN CAPITAL LETTER F WITH DOT ABOVE */ 
  { "F.",  {'F','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e1e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "F.", "LATIN CAPITAL LETTER F WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER f WITH DOT ABOVE */ 
  { "f.",  {'f','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e1f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "f.", "LATIN SMALL LETTER F WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER G WITH MACRON */ 
  { "G-",  {'G','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e20,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "G-", "LATIN CAPITAL LETTER G WITH MACRON" } },  
  /* LATIN SMALL LETTER g WITH MACRON */ 
  { "g-",  {'g','-'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e21,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "g-", "LATIN SMALL LETTER G WITH MACRON" } }, 
  /* LATIN CAPITAL LETTER H WITH DOT ABOVE */ 
  { "H.",  {'H','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e22,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "H.", "LATIN CAPITAL LETTER H WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER h WITH DOT ABOVE */ 
  { "h.",  {'h','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e23,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "h.", "LATIN SMALL LETTER H WITH DOT ABOVE" } }, 
  /* LATIN CAPITAL LETTER H WITH DOT BELOW */
  { "H_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e24,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "H-.", "LATIN CAPITAL LETTER H WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER h WITH DOT BELOW */
  { "h_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e25,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "h-.", "LATIN SMALL LETTER H WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER H WITH DIAERESIS */
  { "H\"",  {'H','"'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e26,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "H:", "LATIN CAPITAL LETTER H WITH DIAERESIS" } },  
  /* LATIN SMALL LETTER h WITH DIAERESIS */
  { "h\"",  {'h','"'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e27,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "h:", "LATIN SMALL LETTER H WITH DIAERESIS" } },  
  /* LATIN CAPITAL LETTER H WITH CEDILLA */
  { "H,",  {'H',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e28,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "H,", "LATIN CAPITAL LETTER H WITH CEDILLA" } },  
  /* LATIN SMALL LETTER H WITH CEDILLA */
  { "h,",  {'h',','}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e29,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "h,", "LATIN SMALL LETTER H WITH CEDILLA" } },  

/* Left out: xxx WITH BREVE BELOW
 */

  /* LATIN CAPITAL LETTER I WITH TILDE BELOW */
  { "I_~",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e2c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "I-?", "LATIN CAPITAL LETTER I WITH TILDE BELOW" } },  
  /* LATIN SMALL LETTER i WITH TILDE BELOW */
  { "i_~",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e2d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "i-?", "LATIN SMALL LETTER I WITH TILDE BELOW" } },  
  /* LATIN CAPITAL LETTER K WITH ACUTE */
  { "K'",  {'K','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e30,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "K'", "LATIN CAPITAL LETTER K WITH ACUTE" } },  
  /* LATIN SMALL LETTER k WITH ACUTE */
  { "k'",  {'k','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e31,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "k'", "LATIN SMALL LETTER K WITH ACUTE" } },  
  /* LATIN CAPITAL LETTER K WITH DOT BELOW */
  { "K_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e32,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "K-.", "LATIN CAPITAL LETTER K WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER k WITH DOT BELOW */
  { "k_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e33,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "k-.", "LATIN SMALL LETTER K WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER K WITH LINE BELOW */
  { "K_",  {'K','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e34,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "K_", "LATIN CAPITAL LETTER K WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER k WITH LINE BELOW */
  { "k_",  {'k','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e35,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "k_", "LATIN SMALL LETTER K WITH LINE BELOW" } },
  /* LATIN CAPITAL LETTER L WITH DOT BELOW */
  { "L_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e36,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "L-.", "LATIN CAPITAL LETTER L WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER l WITH DOT BELOW */
  { "l_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e37,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "l-.", "LATIN SMALL LETTER L WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER L WITH LINE BELOW */
  { "L_",  {'L','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e3a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "L_", "LATIN CAPITAL LETTER L WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER l WITH LINE BELOW */
  { "l_",  {'l','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e3b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "l_", "LATIN SMALL LETTER L WITH LINE BELOW" } },  
  /* LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW */
  { "L>",  {'L','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e3c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "L->", "LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW" } },  
  /* LATIN SMALL LETTER l WITH CIRCUMFLEX BELOW */
  { "l>",  {'l','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e3d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "l->", "LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW" } },  
  /* LATIN CAPITAL LETTER M WITH ACUTE */
  { "M'",  {'M','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e3e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "M'", "LATIN CAPITAL LETTER M WITH ACUTE" } },  
  /* LATIN SMALL LETTER M WITH ACUTE */
  { "m'",  {'m','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e3f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "m'", "LATIN SMALL LETTER M WITH ACUTE" } },  
  /* LATIN CAPITAL LETTER M WITH DOT ABOVE */
  { "M.",  {'M','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e40,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "M.", "LATIN CAPITAL LETTER M WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER m WITH DOT ABOVE */
  { "m.",  {'m','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e41,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "m.", "LATIN SMALL LETTER M WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER M WITH DOT BELOW */
  { "M-.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e42,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "M-.", "LATIN CAPITAL LETTER M WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER m WITH DOT BELOW */
  { "m-.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e43,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "m-.", "LATIN SMALL LETTER M WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER N WITH DOT ABOVE */
  { "N.",  {'N','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e44,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "N.", "LATIN CAPITAL LETTER N WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER n WITH DOT ABOVE */
  { "n.",  {'n','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e45,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "n.", "LATIN SMALL LETTER N WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER N WITH DOT BELOW */
  { "N-.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e46,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "N-.", "LATIN CAPITAL LETTER N WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER n WITH DOT BELOW */
  { "n-.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e47,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "n-.", "LATIN SMALL LETTER N WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER N WITH LINE BELOW */
  { "N_",  {'N','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e48,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "N_", "LATIN CAPITAL LETTER N WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER n WITH LINE BELOW */
  { "n_",  {'n','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e49,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "n_", "LATIN SMALL LETTER N WITH LINE BELOW" } },  
  /* LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW */
  { "N>",  {'N','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e4a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "N->", "LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW" } },  
  /* LATIN SMALL LETTER n WITH CIRCUMFLEX BELOW */
  { "n>",  {'n','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e4b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "n->", "LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW" } },  
  /* LATIN CAPITAL LETTER P WITH ACUTE */
  { "P'",  {'P','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e54,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "P'", "LATIN CAPITAL LETTER P WITH ACUTE" } },  
  /* LATIN SMALL LETTER p WITH ACUTE */
  { "p'",  {'p','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e55,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "p'", "LATIN SMALL LETTER P WITH ACUTE" } },  
  /* LATIN CAPITAL LETTER P WITH DOT ABOVE */
  { "P.",  {'P','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e56,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "P.", "LATIN CAPITAL LETTER P WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER p WITH DOT ABOVE */
  { "p.",  {'p','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e57,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "p.", "LATIN SMALL LETTER P WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER R WITH DOT ABOVE */
  { "R.",  {'R','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e58,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "R.", "LATIN CAPITAL LETTER R WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER r WITH DOT ABOVE */
  { "r.",  {'r','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e59,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "r.", "LATIN SMALL LETTER R WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER R WITH DOT BELOW */
  { "R_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e5a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "R-.", "LATIN CAPITAL LETTER R WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER r WITH DOT BELOW */
  { "r_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e5b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "r-.", "LATIN SMALL LETTER R WITH DOT BELOW" } }, 
  /* LATIN CAPITAL LETTER R WITH LINE BELOW */
  { "R_",  {'R','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e5e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "R_", "LATIN CAPITAL LETTER R WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER r WITH LINE BELOW */
  { "r_",  {'r','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e5f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "r_", "LATIN SMALL LETTER R WITH LINE BELOW" } },  
  /* LATIN CAPITAL LETTER S WITH DOT ABOVE */
  { "S.",  {'S','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e60,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "S.", "LATIN CAPITAL LETTER S WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER s WITH DOT ABOVE */
  { "s.",  {'s','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e61,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "s.", "LATIN SMALL LETTER S WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER S WITH DOT BELOW */
  { "S_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e62,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "S-.", "LATIN CAPITAL LETTER S WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER s WITH DOT BELOW */
  { "s_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e63,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "s-.", "LATIN SMALL LETTER S WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER T WITH DOT ABOVE */
  { "T.",  {'T','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e6a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "T.", "LATIN CAPITAL LETTER T WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER t WITH DOT ABOVE */
  { "t.",  {'t','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e6b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "t.", "LATIN SMALL LETTER T WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER T WITH DOT BELOW */
  { "T_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e6c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "T-.", "LATIN CAPITAL LETTER T WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER t WITH DOT BELOW */
  { "t_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e6d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "t-.", "LATIN SMALL LETTER T WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER T WITH LINE BELOW */
  { "T_",  {'T','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e6e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "T_", "LATIN CAPITAL LETTER T WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER t WITH LINE BELOW */
  { "t_",  {'t','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e6f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "t_", "LATIN SMALL LETTER T WITH LINE BELOW" } },  
  /* LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW */
  { "T>",  {'T','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e70,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "T->", "LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW" } },  
  /* LATIN SMALL LETTER t WITH CIRCUMFLEX BELOW */
  { "t>",  {'t','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e71,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "t->", "LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW" } },  

  /* Missing: xxxx WITH DIAERESIS BELOW */

  /* LATIN CAPITAL LETTER U WITH TILDE BELOW */
  { "U_~",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e74,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "U-?", "LATIN CAPITAL LETTER U WITH TILDE BELOW" } },  
  /* LATIN SMALL LETTER u WITH TILDE BELOW */
  { "u_~",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e75,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "u-?", "LATIN SMALL LETTER U WITH TILDE BELOW" } },  
  /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW */
  { "U>",  {'U','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e76,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "U->", "LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW" } },  
  /* LATIN SMALL LETTER u WITH CIRCUMFLEX BELOW */
  { "u>",  {'u','>'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e77,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "u->", "LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW" } },  
  /* CAPITAL LETTER V WITH TILDE */
  { "V~",  {'V','~'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e7c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "V?", "LATIN CAPITAL LETTER V WITH TILDE" } },
  /* SMALL LETTER v WITH TILDE */
  { "v~",  {'v','~'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e7d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "v?", "LATIN SMALL LETTER V WITH TILDE" } }, 
  /* LATIN CAPITAL LETTER V WITH DOT BELOW */
  { "V_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e7e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "V-.", "LATIN CAPITAL LETTER V WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER v WITH DOT BELOW */
  { "v_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e7f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "v-.", "LATIN SMALL LETTER V WITH DOT BELOW" } },  
  /* CAPITAL LETTER W WITH GRAVE ACCENT */
  { "W`",  {'W','`'},1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x1e80,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "W!", "LATIN CAPITAL LETTER W WITH GRAVE" } },
  /* SMALL LETTER w WITH GRAVE ACCENT */
  { "w`",  {'w','`'},1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x1e81,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "w!", "LATIN SMALL LETTER W WITH GRAVE" } },   
  /* LATIN CAPITAL LETTER W WITH ACUTE */
  { "W'",  {'W','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e82,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "W'", "LATIN CAPITAL LETTER W WITH ACUTE" } },  
  /* LATIN SMALL LETTER w WITH ACUTE */
  { "w'",  {'w','\''}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e83,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "w'", "LATIN SMALL LETTER W WITH ACUTE" } }, 
  /* LATIN CAPITAL LETTER W WITH DIAERESIS */
  { "W\"",  {'W','"'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e84,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "W:", "LATIN CAPITAL LETTER W WITH DIAERESIS" } },  
  /* LATIN SMALL LETTER w WITH DIAERESIS */
  { "w\"",  {'w','"'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e85,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "w:", "LATIN SMALL LETTER W WITH DIAERESIS" } },  
  /* LATIN CAPITAL LETTER W WITH DOT ABOVE */
  { "W.",  {'W','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e86,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "W.", "LATIN CAPITAL LETTER W WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER w WITH DOT ABOVE */
  { "w.",  {'w','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e87,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "w.", "LATIN SMALL LETTER W WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER W WITH DOT BELOW */
  { "W_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e88,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "W-.", "LATIN CAPITAL LETTER W WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER w WITH DOT BELOW */
  { "w_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e89,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "w-.", "LATIN SMALL LETTER W WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER X WITH DOT ABOVE */
  { "X.",  {'X','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e8a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "X.", "LATIN CAPITAL LETTER X WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER x WITH DOT ABOVE */
  { "x.",  {'x','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e8b,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "x.", "LATIN SMALL LETTER X WITH DOT ABOVE" } },  
  /* LATIN CAPITAL LETTER X WITH DIAERESIS */
  { "X\"",  {'X','"'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e8c,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "X:", "LATIN CAPITAL LETTER X WITH DIAERESIS" } },  
  /* LATIN SMALL LETTER x WITH DIAERESIS */
  { "x\"",  {'x','"'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e8d,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "x:", "LATIN SMALL LETTER X WITH DIAERESIS" } },  
  /* LATIN CAPITAL LETTER Y WITH DOT ABOVE */
  { "Y.",  {'Y','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e8e,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "Y.", "LATIN CAPITAL LETTER Y WITH DOT ABOVE" } },  
  /* LATIN SMALL LETTER y WITH DOT ABOVE */
  { "y.",  {'y','.'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e8f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "y.", "LATIN SMALL LETTER Y WITH DOT ABOVE" } },  
  /* CAPITAL LETTER Z WITH WITH CIRCUMFLEX */
  { "Z^",  {'Z','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x1e90,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Z>", "LATIN CAPITAL LETTER Z WITH CIRCUMFLEX" } },
  /* SMALL LETTER z WITH WITH CIRCUMFLEX */
  { "z^",  {'z','^'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,        -1,
		  -1,   0x1e91,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "z>", "LATIN SMALL LETTER Z WITH CIRCUMFLEX" } },  
  /* LATIN CAPITAL LETTER Z WITH DOT BELOW */
  { "Z_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e92,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "Z-.", "LATIN CAPITAL LETTER Z WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER z WITH DOT BELOW */
  { "z_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e93,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "z-.", "LATIN SMALL LETTER Z WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER Z WITH LINE BELOW */
  { "Z_",  {'Z','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e94,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "Z_", "LATIN CAPITAL LETTER Z WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER z WITH LINE BELOW */
  { "z_",  {'z','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e95,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "z_", "LATIN SMALL LETTER Z WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER h WITH LINE BELOW */
  { "h_",  {'h','_'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e96,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "h_", "LATIN SMALL LETTER H WITH LINE BELOW" } },  
  /* LATIN SMALL LETTER t WITH DIAERESIS */
  { "t\"",  {'t','"'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e97,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "t:", "LATIN SMALL LETTER T WITH DIAERESIS" } },  
  /* SMALL LETTER w WITH RING ABOVE */
  { "wo",  {'w','o'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e98,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "w0", "LATIN SMALL LETTER W WITH RING ABOVE" } },
  /* SMALL LETTER y WITH RING ABOVE */
  { "yo",  {'y','o'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1e99,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "y0", "LATIN SMALL LETTER Y WITH RING ABOVE" } },
  /* LATIN CAPITAL LETTER A WITH DOT BELOW */
  { "A_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ea0,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "A-.", "LATIN CAPITAL LETTER A WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER a WITH DOT BELOW */
  { "a_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ea1,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "a-.", "LATIN SMALL LETTER A WITH DOT BELOW" } },  
   /* Missing: xxx WITH HOOK ABOVE */
  /* LATIN CAPITAL LETTER I WITH DOT BELOW */
  { "I_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1eca,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "I-.", "LATIN CAPITAL LETTER I WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER i WITH DOT BELOW */
  { "i_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ecb,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "i-.", "LATIN SMALL LETTER I WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER O WITH DOT BELOW */
  { "O_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ecc,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "O-.", "LATIN CAPITAL LETTER O WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER o WITH DOT BELOW */
  { "o_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ecd,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "o-.", "LATIN SMALL LETTER O WITH DOT BELOW" } },  
  /* LATIN CAPITAL LETTER U WITH DOT BELOW */
  { "U_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ee4,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "U-.", "LATIN CAPITAL LETTER U WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER u WITH DOT BELOW */
  { "u_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ee5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "u-.", "LATIN SMALL LETTER U WITH DOT BELOW" } },  
  /* CAPITAL LETTER Y WITH GRAVE ACCENT */
  { "Y`",  {'Y','`'},1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x1ef2,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Y!", "LATIN CAPITAL LETTER Y WITH GRAVE" } },
  /* SMALL LETTER y WITH GRAVE ACCENT */
  { "y`",  {'y','`'},1, NULL,
      {            -1,       -1,      -1,     -1,       -1,
		   -1,       -1,      -1,     -1,       -1,
                   -1,       -1,     -1,      -1,       -1,
                   -1,       -1,     -1,      -1,        -1,
		   -1,   0x1ef3,   -1,        -1,       -1,
		   -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "y!", "LATIN SMALL LETTER Y WITH GRAVE" } },   
  /* LATIN CAPITAL LETTER Y WITH DOT BELOW */
  { "Y_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ef4,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "Y-.", "LATIN CAPITAL LETTER Y WITH DOT BELOW" } },  
  /* LATIN SMALL LETTER y WITH DOT BELOW */
  { "y_.",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ef5,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 }, 
      { "y-.", "LATIN SMALL LETTER Y WITH DOT BELOW" } },  
  /* CAPITAL LETTER Y WITH TILDE */
  { "Y~",  {'Y','~'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ef8,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "Y?", "LATIN CAPITAL LETTER Y WITH TILDE" } },
  /* SMALL LETTER y WITH TILDE */
  { "y~",  {'y','~'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x1ef9,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { "y?", "LATIN SMALL LETTER Y WITH TILDE" } }, 
   /* LATIN SMALL LETTER LONG S */
  { "ss",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x017f,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER LONG S" } },  /* Not in RFC1345! */
   /* LATIN SMALL LETTER B WITH STROKE
      LATIN SMALL LETTER B BAR */
  { "b/",  {'b','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0180,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0062] & [0335] */
      { NULL, "LATIN SMALL LETTER B WITH STROKE" } },  /* Not in RFC1345! */
   /* LATIN CAPITAL LETTER B WITH HOOK
      LATIN CAPITAL LETTER B HOOK */
  { "b",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0181,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER B WITH HOOK" } },  /* Not in RFC1345! */
   /* LATIN CAPITAL LETTER B WITH TOPBAR
      LATIN CAPITAL LETTER B TOPBAR */
  { "B",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0182,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER B WITH TOPBAR" } },  /* Not in RFC1345! */
   /* LATIN SMALL LETTER B WITH TOPBAR
      LATIN SMALL LETTER B TOPBAR */
  { "b",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0183,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER B WITH TOPBAR" } },  /* Not in RFC1345! */
   /* Missing: LATIN CAPITAL LETTER TONE SIX,   UNICODE: 0x0184 
               LATIN SMALL LETTER TONE SIX,     UNICODE: 0x0185 */
   /* LATIN CAPITAL LETTER C WITH HOOK
      LATIN CAPITAL LETTER C HOOK */
  { "C",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0187,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER C WITH HOOK" } },  /* Not in RFC1345! */
   /* LATIN SMALL LETTER C WITH HOOK
      LATIN SMALL LETTER C HOOK */
  { "c",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0188,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER C WITH HOOK" } },  /* Not in RFC1345! */
      /* Missing: LATIN CAPITAL LETTER AFRICAN D,   UNICODE: 0x0189 */
   /* LATIN CAPITAL LETTER D WITH HOOK
      LATIN CAPITAL LETTER D HOOK */
  { "D",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x018a,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER D WITH HOOK" } },  /* Not in RFC1345! */
   /* LATIN CAPITAL LETTER D WITH TOPBAR
      LATIN CAPITAL LETTER D TOPBAR */
  { "D",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x018B,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER D WITH TOPBAR" } },  /* Not in RFC1345! */
   /* LATIN SMALL LETTER D WITH TOPBAR
      LATIN SMALL LETTER D TOPBAR */
  { "d",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x018C,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER D WITH TOPBAR" } },  /* Not in RFC1345! */
  /* Missing: LATIN SMALL LETTER TURNED DELTA,   UNICODE 0x018d */
  /* LATIN CAPITAL LETTER REVERSED E
     LATIN CAPITAL LETTER TURNED E */
  { "E",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x018E,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER REVERSED E" } },  /* Not in RFC1345! */
  /* Missing: LATIN CAPITAL LETTER SCHWA,    UNICODE 0x018F */
  /* LATIN CAPITAL LETTER OPEN E
     LATIN CAPITAL LETTER EPSILON */
  { "E",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,   0x65|FC_fallback,      
                                            -1,        -1,
		  -1,   0x0190,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER OPEN E" } },  /* Not in RFC1345! */
   /* LATIN CAPITAL LETTER F WITH HOOK
      LATIN CAPITAL LETTER F HOOK */
  { "F",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0191,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER F WITH HOOK" } },  /* Not in RFC1345! */
   /* LATIN SMALL LETTER F WITH HOOK
      LATIN SMALL LETTER SCRIPT F */
  { "F",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0192,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER F WITH HOOK" } },  /* Not in RFC1345! */
   /* LATIN CAPITAL LETTER G WITH HOOK
      LATIN CAPITAL LETTER G HOOK */
  { "G",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0193,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER G WITH HOOK" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER GAMMA */
  { "G",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,     226 | FC_fallback,  
                                  0x47 | FC_fallback,      
                                            -1,        -1,
		  -1,   0x0194,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER GAMMA" } },  /* Not in RFC1345! */
  /* LATIN SMALL LETTER HV
     LATIN SMALL LETTER H V */
  { "hv",  {'h','v'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0195,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER HV" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER IOTA */
  { "I",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    0x69|FC_fallback,      
                                             -1,        -1,
		  -1,   0x0196,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER IOTA" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER I WITH STROKE
     LATIN CAPITAL LETTER BARRED I */
  { "I/",  {'I','/'}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0197,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0049] & [0335] */
      { NULL, "LATIN CAPITAL LETTER I WITH STROKE" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER K WITH HOOK
     LATIN CAPITAL LETTER K HOOK */
  { "K",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0198,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER K WITH HOOK" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL SMALL K WITH HOOK
     LATIN CAPITAL SMALL K HOOK */
  { "k",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x0199,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN SMALL LETTER K WITH HOOK" } },  /* Not in RFC1345! */
      /* Missing: LATIN SMALL LETTER LAMBDA WITH STROKE,
	                LATIN SMALL LETTER BARRED LAMBDA, UNICODE 0x019B,
			UNICODE Decomposition: [03BB] & [0335] */
   /* LATIN CAPITAL LETTER TURNED M */
  { "k",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x019C,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER TURNED M" } },  /* Not in RFC1345! */
  /* LATIN CAPITAL LETTER N WITH LEFT HOOK
     LATIN CAPITAL LETTER N HOOK */
  { "N",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		  -1,       -1,      -1,     -1,      -1,
                  -1,       -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x019D,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { NULL, "LATIN CAPITAL LETTER N WITH LEFT HOOK" } },/* Not in RFC1345! */
  /* Missing: LATIN SMALL LETTER N WITH LONG RIGHT LEG, UNICODE 0x019E */

  /* Modifiers */
  /* Missing: MODIFIER LETTER SMALL H, UNICODE 0x02B0,
                       UNICODE Decomposition: <+sup> [0068] <-sup> 
	      MODIFIER LETTER SMALL H WITH HOOK,
	               MODIFIER LETTER SMALL H HOOK, UNICODE 0x02B1,
		       UNICODE Decomposition: <+sup> [0266] <-sup> 
              MODIFIER LETTER SMALL J, UNICODE 0x02B2,
	               UNICODE Decomposition: <+sup> [006A] <-sup> 
              MODIFIER LETTER SMALL R, UNICODE 0x02B3,
	               UNICODE Decompostion: <+sup> [0072] <-sup> 
              MODIFIER LETTER SMALL TURNED R, UNICODE 0x02B4,
                       UNICODE Decomposition: <+sup> [0279] <-sup> 
	      MODIFIER LETTER SMALL TURNED R WITH HOOK,
                       MODIFIER LETTER SMALL TURNED R HOOK, UNICODE 0x02B5,
		       UNICODE Decomposition: <+sup> [027B] <-sup> 
              MODIFIER LETTER SMALL CAPITAL INVERTED R, UNICODE 0x02B6,
	               UNICODE Decomposition: <+sup> [0281] <-sup> 
              MODIFIER LETTER SMALL W, UNICODE 0x02B7,
	               UNICODE Decomposition: <+sup> [0077] <-sup> 
              MODIFIER LETTER SMALL Y, UNICODE 0x02B8,
	               UNICODE Decomposition: <+sup> [0079] <-sup> 
              MODIFIER LETTER PRIME, UNICODE 0x02B9 
              MODIFIER LETTER DOUBLE PRIME, UNICODE 0x02BA
	      MODIFIER LETTER TURNED COMMA, UNICODE 0x02BB
              MODIFIER LETTER APOSTROPHE, UNICODE 0x02BC
	      MODIFIER LETTER REVERSED COMMA, UNICODE 0x02BD
	      MODIFIER LETTER RIGHT HALF RING, UNICODE 0x02BE */
  /* MODIFIER LETTER LEFT HALF RING */
  { ";S",  {0,0}, 1, NULL,
      {           -1,       -1,      -1,     -1,       -1,
		   -1,      -1,      -1,     -1,       -1,
                   -1,      -1,     -1,      -1,       -1,
                   -1,       -1,    -1,      -1,        -1,
		  -1,   0x02bf,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      { ";S", "MODIFIER LETTER LEFT HALF RING" } }, 
   /* Missing: MODIFIER LETTER GLOTTAL STOP, UNICODE 0x02C0
               MODIFIER LETTER REVERSED GLOTTAL STOP, UNICODE 0x02C1
	       MODIFIER LETTER LEFT ARROWHEAD, UNICODE 0x02C2
	       MODIFIER LETTER RIGHT ARROWHEAD, UNICODE 0x02C3
	       MODIFIER LETTER UP ARROWHEAD, UNICOCE 0x02C4
	       MODIFIER LETTER DOWN ARROWHEAD, UNICODE 0x02C5
	       MODIFIER LETTER CIRCUMFLEX ACCENT,
	                MODIFIER LETTER CIRCUMFLEX, UNICODE 0x02C6 */
  /* CARON (UNICODE 0xc7) is elsewhere */
   /* Missing: MODIFIER LETTER VERTICAL LINE, UNICODE 0x02C8
               MODIFIER LETTER MACRON,
	                Mandarin Chinese first tone, UNICODE 0x02C9
	       MODIFIER LETTER ACUTE ACCENT,
	                Mandarin Chinese second tone,
			MODIFIER LETTER ACUTE, UNICODE 0x02CA,
			UNICODE Decomposition: [0020] & [0301] 
	       MODIFIER LETTER GRAVE ACCENT,
                        Mandarin Chinese fourth tone,
                        MODIFIER LETTER GRAVE, UNICODE 0x02CB,
			UNICODE Decomposition: [0020] & [0300] 
               MODIFIER LETTER LOW VERTICAL LINE, UNICODE 0x02CC
	       MODIFIER LETTER LOW MACRON, UNICODE 0x02CD
	       MODIFIER LETTER LOW GRAVE ACCENT,
	                MODIFIER LETTER LOW GRAVE, UNICODE 0x02CE
	       MODIFIER LETTER LOW ACUTE ACCENT,
	                MODIFIER LETTER LOW ACUTE, UNICODE 0x02CF
               MODIFIER LETTER TRIANGULAR COLON, UNICODE 0x02D0
	       MODIFIER LETTER HALF TRIANGULAR COLON, UNICODE 0x02D1
	       MODIFIER LETTER CENTRED RIGHT HALF RING,
	                MODIFIER LETTER CENTERED RIGHT HALF RING, 
			UNICODE 0x02D2
               MODIFIER LETTER CENTRED LEFT HALF RING,
	                MODIFIER LETTER CENTERED LEFT HALF RING, UNICODE 0x02D3
	       MODIFIER LETTER UP TACK, UNICODE 0x02D4
	       MODIFIER LETTER DOWN TACK, UNICODE 0x02D5
	       MODIFIER LETTER PLUS SIGN, UNICODE 0x02D6
	       MODIFIER LETTER MINUS SIGN, UNICODE 0x02D7 */
  /* BREVE (UNICODE 0x02D8) is elsewhere */
  /* DOT ABOVE (UNICODE 0x02D9) is elsewhere */
  /* RING ABOVE
     SPACING RING ABOVE */
  { "o",  {0,0}, 1, NULL,
      {           -1,0xB0|FC_fallback,0xB0|FC_fallback,0x66|FC_fallback,-1,
		   -1,      -1,      -1,  176|FC_fallback,176|FC_fallback,
                   -1,0xB0|FC_fallback,0x5B|FC_fallback,      -1,       -1,
                  176|FC_fallback,248|FC_fallback,-1,0x7C|FC_fallback,0xA1|FC_fallback,
		  0x5B|FC_fallback,   0x02DA,   -1,        -1,       -1,
		  -1,        -1,      -1,      -1,       -1,
                     -1,     -1,      -1,      -1,      -1,
                   -1,      -1,      -1,      -1 },
      /* UNICODE Decomposition: [0020] & [030A]   */
      { "'0", "RING ABOVE" } }, 
  /* OGONEK (UNICODE 0x02DB) is elsewhere */
  /* Missing: SMALL TILDE, SPACING TILDE, UNICODE 0x02DC,
                     UNICODE Decomposition: [0020] & [0303] */
  /* DOUBLE ACUTE ACCENT (UNICODE 0x02DD) is elsewhere */
  /* Missing: MODIFIER LETTER RHOTIC HOOK,  UNICODE 0x02DE
              MODIFIER LETTER SMALL GAMMA,  UNICODE 0x02E0,
	               UNICODE Decomposition: <+sup> [0263] <-sup> 
              MODIFIER LETTER SMALL L, UNICODE 0x02E1,
	               UNICODE Decomposition: <+sup> [006C] <-sup> 
	      MODIFIER LETTER SMALL S, UNICODE 0x02E2,
	               UNICODE Decomposition: <+sup> [0073] <-sup> 
              MODIFIER LETTER SMALL X, UNICODE 0x02E3,
	               UNICODE Decomposition: <+sup> [0078] <-sup> 
              MODIFIER LETTER SMALL REVERSED GLOTTAL STOP, UNICODE 0x02E4,
	               UNICODE Decomposition: <+sup> [0295] <-sup> 
              MODIFIER LETTER EXTRA-HIGH TONE BAR, UNICODE 0x02E5
	      MODIFIER LETTER HIGH TONE BAR, UNICODE 0x02E6
	      MODIFIER LETTER MID TONE BAR, UNICODE 0x02E7
	      MODIFIER LETTER LOW TONE BAR, UNICODE 0x02E8
	      MODIFIER LETTER EXTRA-LOW TONE BAR, UNICODE 0x02E9 */

   /* Composing characters */

   /* Missing: COMBINING GRAVE ACCENT, Varia,
	                 NON-SPACING GRAVE, UNICODE 0x0300
	       COMBINING ACUTE ACCENT, Oxia,
	                 NON-SPACING ACUTE, UNICODE 0x0301   
	       COMBINING CIRCUMFLEX ACCENT,
	                 NON-SPACING CIRCUMFLEX, UNICODE 0x0302
	       COMBINING TILDE,
	                 NON-SPACING TILDE, UNICODE 0x0303
	       COMBINING MACRON,
	                 NON-SPACING MACRON, UNICODE 0x0304
               COMBINING OVERLINE,
	                 NON-SPACING OVERSCORE, UNICODE 0x0305
               COMBINING BREVE, Vrachy, 
	                 NON-SPACING BREVE, UNICODE 0x0306
               COMBINING DOT ABOVE,
	                 NON-SPACING DOT ABOVE, UNICODE 0x0307
               COMBINING DIAERESIS, Dialytika,
	                 NON-SPACING DIAERESIS, UNICODE 0x0308
	       COMBINING HOOK ABOVE,
	                 NON-SPACING HOOK ABOVE, UNICODE 0x0309
	       COMBINING RING ABOVE,
	                 NON-SPACING RING ABOVE, UNICODE 0x030A
               COMBINING DOUBLE ACUTE ACCENT,
	                 NON-SPACING DOUBLE ACUTE, UNICODE 0x030B
	       COMBINING CARON,
	                 NON-SPACING HACEK, UNICODE 0x030C
	       COMBINING VERTICAL LINE ABOVE, Tonos,
	                 NON-SPACING VERTICAL LINE ABOVE, UNICODE 0x030D
               COMBINING DOUBLE VERTICAL LINE ABOVE,
	                 NON-SPACING DOUBLE VERTICAL LINE ABOVE, UNICODE 0x030E
	       COMBINING DOUBLE GRAVE ACCENT,
	                 NON-SPACING DOUBLE GRAVE, UNICODE 0x030F
	       COMBINING CANDRABINDU,
	                 NON-SPACING CANDRABINDU, UNICODE 0x0310
	       COMBINING INVERTED BREVE,
	                 NON-SPACING INVERTED BREVE, UNICODE 0x0311
               COMBINING TURNED COMMA ABOVE,
	                 NON-SPACING TURNED COMMA ABOVE, UNICODE 0x0312
               COMBINING COMMA ABOVE, Psili,
	                 NON-SPACING COMMA ABOVE, UNICODE 0x0313
               COMBINING REVERSED COMMA ABOVE, Dasia,
	                 NON-SPACING REVERSED COMMA ABOVE, UNICODE 0x0314
               COMBINING COMMA ABOVE RIGHT,
	                 NON-SPACING COMMA ABOVE RIGHT, UNICODE 0x0315
	       COMBINING GRAVE ACCENT BELOW,
	                 NON-SPACING GRAVE BELOW, UNICODE 0x0316
	       COMBINING ACUTE ACCENT BELOW,
	                 NON-SPACING ACUTE BELOW, UNICODE 0x0317
               COMBINING LEFT TACK BELOW,
	                 NON-SPACING LEFT TACK BELOW, UNICODE 0x0318
               COMBINING RIGHT TACK BELOW,
	                 NON-SPACING RIGHT TACK BELOW, UNICODE 0x0319
               COMBINING LEFT ANGLE ABOVE,
	                 NON-SPACING LEFT ANGLE ABOVE, UNICODE 0x031A
	       COMBINING HORN,
	                 NON-SPACING HORN, UNICODE 0x031B
	       COMBINING LEFT HALF RING BELOW,
	                 NON-SPACING LEFT HALF RING BELOW, UNICODE 0x031C
               COMBINING UP TACK BELOW,
	                 NON-SPACING UP TACK BELOW, UNICODE 0x031D
               COMBINING DOWN TACK BELOW,
	                 NON-SPACING DOWN TACK BELOW, UNICODE 0x031E
               COMBINING PLUS SIGN BELOW,
	                 NON-SPACING PLUS SIGN BELOW, UNICODE 0x031F
	       COMBINING MINUS SIGN BELOW,
	                 NON-SPACING MINUS SIGN BELOW, UNICODE 0x0320
	       COMBINING PALATALIZED HOOK BELOW,
	                 NON-SPACING PALATALIZED HOOK BELOW, UNICODE 0x0321
               COMBINING RETROFLEX HOOK BELOW,
	                 NON-SPACING RETROFLEX HOOK BELOW, UNICODE 0x0322
               COMBINING DOT BELOW,
	                 NON-SPACING DOT BELOW, UNICODE 0x0323
               COMBINING DIAERESIS BELOW,
	                 NON-SPACING DOUBLE DOT BELOW, UNICODE 0x0324
               COMBINING RING BELOW,
	                 NON-SPACING RING BELOW, UNICODE 0x0325
               COMBINING COMMA BELOW,
	                 NON-SPACING COMMA BELOW, UNICODE 0x0326
	       COMBINING CEDILLA,
	                 NON-SPACING CEDILLA, UNICODE 0x0327
               COMBINING OGONEK,
	                 NON-SPACING OGONEK, UNICODE 0x0328
               COMBINING VERTICAL LINE BELOW,
	                 NON-SPACING VERTICAL LINE BELOW, UNICODE 0x0329
               COMBINING BRIDGE BELOW,
	                 NON-SPACING BRIDGE BELOW, UNICODE 0x032A
               COMBINING INVERTED DOUBLE ARCH BELOW,
                         NON-SPACING INVERTED DOUBLE ARCH BELOW, UNICODE 0x032B
               COMBINING CARON BELOW,
	                 NON-SPACING HACEK BELOW, UNICODE 0x032C
               COMBINING CIRCUMFLEX ACCENT BELOW,
	                 NON-SPACING CIRCUMFLEX BELOW, UNICODE 0x032D
               COMBINING BREVE BELOW,
	                 NON-SPACING BREVE BELOW, UNICODE 0x032E
               COMBINING INVERTED BREVE BELOW,
	                 NON-SPACING INVERTED BREVE BELOW, UNICODE 0x032F
               COMBINING TILDE BELOW,
	                 NON-SPACING TILDE BELOW, UNICODE 0x0330
               COMBINING MACRON BELOW,
	                 NON-SPACING MACRON BELOW, UNICODE 0x0331
               COMBINING LOW LINE,
	                 NON-SPACING UNDERSCORE, UNICODE 0x0332
               COMBINING DOUBLE LOW LINE,
	                 NON-SPACING DOUBLE UNDERSCORE, UNICODE 0x0333
               COMBINING TILDE OVERLAY,
	                 NON-SPACING TILDE OVERLAY, UNICODE 0x0334
               COMBINING SHORT STROKE OVERLAY,
	                 NON-SPACING SHORT BAR OVERLAY, UNICODE 0x0335
	       COMBINING LONG STROKE OVERLAY,
	                 NON-SPACING LONG BAR OVERLAY, UNICODE 0X0336
               COMBINING SHORT SOLIDUS OVERLAY,
                         NON-SPACING SHORT SLASH OVERLAY, UNICODE 0X0337
               COMBINING LONG SOLIDUS OVERLAY,
	                 NON-SPACING LONG SLASH OVERLAY, UNICODE 0X0338
               COMBINING RIGHT HALF RING BELOW,
	                 NON-SPACING RIGHT HALF RING BELOW, UNICODE 0X0339
               COMBINING INVERTED BRIDGE BELOW,
	                 NON-SPACING INVERTED BRIDGE BELOW, UNICODE 0x033A
               COMBINING SQUARE BELOW,
	                 NON-SPACING SQUARE BELOW, UNICODE 0x033B
               COMBINING SEAGULL BELOW,
	                 NON-SPACING SEAGULL BELOW, UNICODE 0x033C
               COMBINING X ABOVE,
	                 NON-SPACING X ABOVE, UNICODE 0x033D
               COMBINING VERTICAL TILDE,
	                 NON-SPACING VERTICAL TILDE, UNICODE 0x033E
               COMBINING DOUBLE OVERLINE,
	                 NON-SPACING DOUBLE OVERSCORE, UNICODE 0x033F
               COMBINING GRAVE TONE MARK, Vietnamese,
	                 NON-SPACING GRAVE TONE MARK, UNICODE 0x0340
               COMBINING ACUTE TONE MARK, Vietnamese, 
	                 NON-SPACING ACUTE TONE MARK, UNICODE 0x0341
               COMBINING GREEK xxx, UNICODE range 0x0342 - 0x0345
               COMBINING DOUBLE TILDE, UNICODE 0x0360,
	                 UNICODE Decomposition: [FE22] [FE23] 
               COMBINING DOUBLE INVERTED BREVE, UNICODE 0x0361,
	                 UNICODE Decomposition: [FE20] & [FE21] */

/* Missing:    COMBINING LEFT HARPOON ABOVE,
	                 NON-SPACING LEFT HARPOON ABOVE, UNICODE 0x20D0
               COMBINING RIGHT HARPOON ABOVE
	                 NON-SPACING RIGHT HARPOON ABOVE, UNICODE 0x20D1
               COMBINING LONG VERTICAL LINE OVERLAY
	                 NON-SPACING LONG VERTICAL BAR OVERLAY, UNICODE 0x20D2
               COMBINING SHORT VERTICAL LINE OVERLAY
	                 NON-SPACING SHORT VERTICAL BAR OVERLAY, UNICODE 0x20D3
               COMBINING ANTICLOCKWISE ARROW ABOVE
	                 NON-SPACING ANTICLOCKWISE ARROW ABOVE, UNICODE 0x20D4
               COMBINING CLOCKWISE ARROW ABOVE
	                 NON-SPACING CLOCKWISE ARROW ABOVE, UNICODE 0x20D5
               COMBINING LEFT ARROW ABOVE
	                 NON-SPACING LEFT ARROW ABOVE, UNICODE 0x20D6
               COMBINING RIGHT ARROW ABOVE
	                 NON-SPACING RIGHT ARROW ABOVE, UNICODE 0x20D7
               COMBINING RING OVERLAY
	                 NON-SPACING RING OVERLAY, UNICODE 0x20D8
               COMBINING CLOCKWISE RING OVERLAY
	                 NON-SPACING CLOCKWISE RING OVERLAY, UNICODE 0x20D9
               COMBINING ANTICLOCKWISE RING OVERLAY
	                 NON-SPACING ANTICLOCKWISE RING OVERLAY, UNICODE 0x20DA
               COMBINING THREE DOTS ABOVE
	                 NON-SPACING THREE DOTS ABOVE, UNICODE 0x20DB
               COMBINING FOUR DOTS ABOVE
	                 NON-SPACING FOUR DOTS ABOVE, UNICODE 0x20DC
               COMBINING ENCLOSING CIRCLE
	                 ENCLOSING CIRCLE, UNICODE 0x20DD
               COMBINING ENCLOSING SQUARE
	                 ENCLOSING SQUARE, UNICODE 0x20DE
               COMBINING ENCLOSING DIAMOND
	                 ENCLOSING DIAMOND, UNICODE 0x20DF
               COMBINING ENCLOSING CIRCLE BACKSLASH
	                 ENCLOSING CIRCLE SLASH, UNICODE 0x20E0
               COMBINING LEFT RIGHT ARROW ABOVE
	                 NON-SPACING LEFT RIGHT ARROW ABOVE, UNICODE 0x20E1 */

/* Specially: */
  /* WHITE SMILING FACE */   /* See also: 2323: Smile */
  { ":-)", {0,0}, 1,NULL,
      {            -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
		   -1,   0x263A,     -1,      -1,      -1,
		   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1,      -1,
                   -1,       -1,     -1,      -1 },
      { "0u", "WHITE SMILING FACE" } }, 

};

CHAR_IDX CHARS_COUNT_ = CHARS_COUNT;

INLINE static int hash_string(const char *c, int dom) {
  const int divided = INT_MAX >>5;
  unsigned int r=0;
  for (; '\0' != *c; c++) { 
    CHAR C = rCc(*c); 
    r = (((r<<5) + (C&31)) ^ ((C>>5)*131)) % divided;
  }
  return r % dom;
}

static struct Table {
  enum { tt_direct, tt_char_hashe } tt_type;
  int len;
  int *direct;
  struct Table_id { 
    int ilen;
    int *imap;
  } *idirect;
} tables[MAP_COUNT+ENT_COUNT];

CHAR_IDX inmap(int map,int ch) {
  switch(tables[map].tt_type) {
  case tt_direct:
    if (ch >= tables[map].len) return -1;
    return tables[map].direct[ch];
  default:
    return -1;
  }
}

CHAR_IDX inmapc(int map, const char *c) {
  switch(tables[map].tt_type) {
    int hash_value,i;
  case tt_char_hashe:
    hash_value = hash_string(c,tables[map].len);
    for (i=0; i < tables[map].idirect[hash_value].ilen; i++) {
      const int indx = tables[map].idirect[hash_value].imap[i];
      if (0 == strcmp(c,
		      chars[indx].evector[map-MAP_COUNT]))
	return indx;
    }
    return -1;
  default:
    return -1;
  }
}







static int utf7_table[256];

void init_tables(void) {
  int i,table,j;
  CHAR c;

  for (i = 0; i < 256; i++) utf7_table[i]= -1;
  j = 0;
  for (c = (CHAR) 'A'; c <= (CHAR) 'Z'; c++) utf7_table[c] = j++;
  for (c = (CHAR) 'a'; c <= (CHAR) 'z'; c++) utf7_table[c] = j++;
  for (c = (CHAR) '0'; c <= (CHAR) '9'; c++) utf7_table[c] = j++;
  utf7_table[(CHAR)'+'] = j++;
  utf7_table[(CHAR)'/'] = j++;
  if (j != 64) 
    CrashMe("init_tables: Creating of UTF7 table failed");
  
  for (table = 0; table < MAP_COUNT+ENT_COUNT; table++) {
    tables[table].len=0;
    tables[table].direct=NULL;
    tables[table].idirect=NULL;
  }

  for (i = 0; i < CHARS_COUNT; i++) {
    if (chars[i].mark != NULL)
      *chars[i].mark = i;
    for (table = 0; table < MAP_COUNT; table++) {
      int code = chars[i].vector[table] & CHAR_code;
      if (tables[table].len <= code)
	tables[table].len = code+1;
    }
  }

  for (table = 0; table < MAP_COUNT; table++) {
    tables[table].tt_type=tt_direct;
    tables[table].direct = pg_alloc(tables[table].len*sizeof(int));
    for (i = 0; i < tables[table].len; i++) 
      tables[table].direct[i] = -1;
  }

  for (i = 0; i < CHARS_COUNT; i++) 
    for (table = 0; table < MAP_COUNT; table++) 
      if (-1 != chars[i].vector[table] &&
	  0 == (chars[i].vector[table] & FC_fallback) &&
	  0 == (chars[i].vector[table] & FC_alias)) {
	if (-1 != tables[table].direct[chars[i].vector[table] & CHAR_code]) {
	  CHAR *s = map_name(table,0);
	  print_notify("Software error: table=%d (%s) "
		       "ind(1)=%d = ind(2)=%d; char = 0x%02X (%d); "
                       "fallback(1)='%s'; fallback(2)='%s'; "
		       "name(1)='%s'; name(2)='%s' ",
		       table,s,
		       tables[table].direct[chars[i].vector[table] &CHAR_code],
		       i,
		       chars[i].vector[table] & CHAR_code,
		       chars[i].vector[table] & CHAR_code,
		       chars[tables[table].direct[chars[i].vector[table] 
						  & CHAR_code]].fallback,
		       chars[i].fallback,
		       chars[tables[table].direct[chars[i].vector[table] 
						  & CHAR_code]]
		       .evector[ENT_name] ? 
		       chars[tables[table].direct[chars[i].vector[table] 
						  & CHAR_code]]
		       .evector[ENT_name] : "",
		       chars[i].evector[ENT_name] ? 
		       chars[i].evector[ENT_name] : ""
		       );
	} else 
	  tables[table].direct[chars[i].vector[table] & CHAR_code] = i;
      }

  for (i = 0; i < CHARS_COUNT; i++) 
    for (table = 0; table < ENT_COUNT; table++) 
      if (chars[i].evector[table])
	tables[table+MAP_COUNT].len++;

  for (table = 0; table < ENT_COUNT; table++) {
    tables[table+MAP_COUNT].tt_type=tt_char_hashe;
    tables[table+MAP_COUNT].idirect = 
      pg_alloc(tables[table+MAP_COUNT].len*sizeof(struct Table_id));
    for (i = 0; i < tables[table+MAP_COUNT].len; i++) {
      tables[table+MAP_COUNT].idirect[i].ilen = 0;
      tables[table+MAP_COUNT].idirect[i].imap = NULL;
    }
  }

  for (table = 0; table < ENT_COUNT; table++) {
    int collisions = 0;
    int max = 0;
    int ecount = 0;

    for (i = 0; i < CHARS_COUNT; i++) {
      const char *c = chars[i].evector[table];
      if (c) {
	CHAR_IDX old = inmapc(table+MAP_COUNT,c);
	if (-1 != old) {
	  CHAR *s = map_name(table+MAP_COUNT,0);
	  print_notify("Software error: table=%d (%d, %s): "
		       "ind(1)=%d = ind(2)=%d; string='%s'; "
		       "fallback(1)='%s'; fallback(2)='%s'; "
		       "name(1)='%s'; name(2)='%s' ",
		       table,table+MAP_COUNT,s,
		       old,i,c,
		       chars[old].fallback,
		       chars[i].fallback,
		       chars[old].evector[ENT_name] ? 
		       chars[old].evector[ENT_name] : "",
		       chars[i].evector[ENT_name] ? 
		       chars[i].evector[ENT_name] : ""
		       );
	} else {	  
	  const int hash_value = hash_string(c,tables[table+MAP_COUNT].len);
	  int ilen = tables[table+MAP_COUNT].idirect[hash_value].ilen;

	  if (ilen) collisions++;
	  else ecount++;
	  
	  tables[table+MAP_COUNT].idirect[hash_value].imap =
	    pg_realloc(tables[table+MAP_COUNT].idirect[hash_value].imap,
		    (ilen+1)*sizeof(int));
	  tables[table+MAP_COUNT].idirect[hash_value].imap[ilen] = i;
	  tables[table+MAP_COUNT].idirect[hash_value].ilen = ilen+1;
	  if (max < ilen+1) max = ilen+1;
	}
      }
    }
    if (DEBUG_CHARMAP) {
      CHAR *s = map_name(table+MAP_COUNT,0);
      print_debug("Table %d (%d, %s): collisions=%d max=%d avg=%1.1f codes=%d",
		  table,table+MAP_COUNT,s,collisions,max,
		  ((float)tables[table+MAP_COUNT].len/ecount),
		  tables[table+MAP_COUNT].len);
    }
  }
}

int string_value(int len, CHAR_IDX *buffer) {
  int value = 0;
  while (len > 0) {
    if (*buffer >= CH_ZERO && *buffer < CH_ZERO + 10)
      value = value * 10 + *buffer - CH_ZERO;
    else 
      return value;
    buffer++; len--;
  }
  return value;
}

void map_input(int table, int len, CHAR *source, CHAR_IDX *target) {
  int i;

  /* Target[] is index to chars table or unmapped character code
     as negative value */

  if (table < 0 || table >= MAP_COUNT) {
    print_notify("(%s) Software error/map_input: table=%d (max=%d)",
		 prog,table,MAP_COUNT-1);
    CrashMe("map_input failed");
  }

  for (i = 0; i < len; i++) {
    const CHAR_IDX code = inmap(table,source[i]);
    if (-1 != code)
      target[i] = code;
    else target[i] = -source[i];
  }
}

/* Mnemonics encoding ------------------------------------------------- */

static int Mnem_open (struct CH_t *T,CHAR *params) {
  int esc = 29;
  
  if (params) {
    if (!isdigit(params[0])) return 0; /* fail */
    esc = atoi(Cs(params));
  }
  T->p.mnem.code=1;
  T->p.mnem.esc=esc;
  return 1; /* ok */
}

static CHAR * Mnem_param (struct CH_t *T) {
   static S=1;
   static CHAR buffer[2][10];
   CHAR *ret = buffer[S];
   S=(S+1)%2;
   sprintf(Cs(ret),"%d",T->p.mnem.esc);
   return ret;
}

static int Mnem_first (struct CH_t *T,CHAR t) {
  return t == T->p.mnem.esc;
}

static int Mnem_convert (struct CH_t *T,CHAR *p, int max,
			CHAR_IDX *result, int *result_len,
			int flush,int *err) {
  *err = 0;
  *result_len = 0;
  if (max < 1) { CrashMe("Mnem_convert: max < 1"); }
  if (p[0] != T->p.mnem.esc) 
    return 0;
  if (flush && max < 3) { *err = 1; return max; }
  if (max < 3) return -1;
  if (p[1] == '_') { /* variable len encoding */
    int i = 3;
    CHAR_IDX res;
    CHAR *c;
    while (i < max && '_' != p[i] && 32 < p[i]) i++;
    if (i >= max && !flush) return -1;
    if ('_' != p[i]) {
      *err = 1;
      return i;
    }
    c = pg_alloc(i);
    memcpy((void *)c,(void *)(p+2),i-2);
    c[i-2]='\0';
    res = inmapc(MAP_Mnem,Cs(c));
    pg_free(c);
    if (res >= 0) {
      *result = res;
      *result_len = 1;
      return i+1;
    }
    *err = 1;
    return i+1;
    
  } else { /* two character coding */
    CHAR_IDX res;
    CHAR enc[3];
    enc[0] = p[1];
    enc[1] = p[2];
    enc[2] = '\0';
    res = inmapc(MAP_Mnem,Cs(enc));
    if (res >= 0) {
      *result = res;
      *result_len = 1;
      return 3;
    }
    *err = 1;
    return 3;
  }
 

}

/* UTF8 routines ------------------------------------------------------ */
static int UTF8_open(struct CH_t *T,CHAR *params) {
  T->p.utf8.code=3;
  return 1;
}

static int UTF8_first(struct CH_t *T,CHAR t) {
  return t >= 0x80;
}

static int UTF8_convert(struct CH_t *T,CHAR *p, int max,
			CHAR_IDX *result, int *result_len,
			int flush, int *err) {
  unsigned long res = 0;
  int mask = 0x80;
  int i,r;
  int c, val;

  *err = 0;
  *result_len = 0;

  if (max < 1) { CrashMe("UTF8_convert: max < 1"); }
  if (p[0] < 0x80) return 0;
  if (flush && max < 2) { *err = 1; return max; }
  if (max < 2) return -1;

  if (p[0] < 0xC0) {   /* Handle error */
    for (i=0; i< max; i++) {
      if (p[i] >= 0xC0 && p[i] < 0x80) break;
    }
    *err = 1;
    return i-1;
  }
  /* count characters */
  res = p[0];
  for (val = p[0],c=0; val >= 0x80; val = (val << 1) & 0xFF, c++) {
    res &= ~mask;
    mask = mask >> 1;
  }

  if (flush && max < c) { *err = 1; return max; }
  if (max < c) return -1;
  for (i =1 ; i < c; i++) {
    if (p[i] < 0x80 || p[i] >= 0xC0) {
      *err = 1;
      return i;
    }
    val = p[i] & 0xBF;
    res = res << 6 | val;
  }
  if (res > CHAR_code) 
    r = CH_OVER;
  else
    r = inmap(MAP_UNICODE11,res);
  if (-1 == r) *result = -res;
  else *result = r;
  *result_len = 1;
  return c;
}

static CHAR * UTF8_param(struct CH_t *T) {
  return NULL; /* No param */
}

/* UTF7 routines ------------------------------------------------------ */

static int UTF7_open(struct CH_t *T,CHAR *params) {
  T->p.utf7.code=2;
  return 1;
}

static int UTF7_first(struct CH_t *T,CHAR t) {
  return t == '+';
}

static int UTF7_convert(struct CH_t *T,CHAR *p, int max,
			CHAR_IDX *result, int *result_len,
			int flush, int *err) {
  int i;
  int bit = 0;
  int ptr = 0;
  unsigned long res = 0;

  *err = 0;
  *result_len = 0;

  if (max < 1) { CrashMe("UTF7_convert: max < 1"); }
  if (p[0] != '+') return 0;
  if (flush && max < 2) { *err = 1; return max; }
  if (max < 2) return -1;

  if (p[0] == '-') {
    *result = CH_PLUS;
    *result_len = 1;
    return 2;
  }

  if (!flush) {
    int ok = 0;
    for (i = 1; i < max; i++) {
      if (-1 == utf7_table[p[i]]) {
	ok = i;
	break;
      }
    }
    if (0 == ok) {
      return -1;
    }
  }

  for (i= 1;i < max; i++) {
    int val = utf7_table[p[i]];
    if (p[i] == '-') {
      *result_len = ptr;
      return i+1;
    }
    if (val < 0) {
      *result_len = ptr;
      return i;
    }
    res = (res << 6) | val;
    bit += 6;
    if (bit >= 16) {
      CHAR_IDX r;
      unsigned long ch = res >> (bit - 16);
      res -= ch << (bit -16);
      bit -= 16;
      if (ch > CHAR_code) 
	r = CH_OVER;
      else
	r = inmap(MAP_UNICODE11,ch);
      if (-1 == r) result[ptr++] = -ch;
      else result[ptr++] = r;
    }
  }
  *result_len = ptr;
  return i;
}

static CHAR * UTF7_param(struct CH_t *T) {
  return NULL; /* No param */
}

/* NULL routines ------------------------------------------------------ */

static int NULL_OpenChr(struct CH_t *T,CHAR *params) {
  CrashMe("NULL_OpenChr");
}

static int NULL_CheckChr(struct CH_t *T,CHAR t) {
  CrashMe("NULL_CheckChr");
}

static int NULL_SpanChr(struct CH_t *T,CHAR *p, int max,
			CHAR_IDX *result, int *result_len,
			int flush, int *err) {
  CrashMe("NULL_SpanChr");
}

static CHAR * NULL_NameChr(struct CH_t *T) {
  CrashMe("NULL_NameChr");
}

const chtable NULL_chtable = { -1, -1, 
				 NULL_OpenChr, NULL_CheckChr, NULL_SpanChr,
                                 NULL_NameChr,
				 { 0 } };

/* ----------------------------------------------------------------------- */

static chtable multicodes[] = {
  { MAP_Mnem, MAP_ASCII, Mnem_open, Mnem_first, Mnem_convert, Mnem_param },
  { MAP_UTF7, MAP_ASCII, UTF7_open, UTF7_first, UTF7_convert, UTF7_param },
  { MAP_UTF8, MAP_ASCII, UTF8_open, UTF8_first, UTF8_convert, UTF8_param },
};

void copy_table(chtable *T,chtable *old) {
  *T = *old;
}

void name_table(chtable *T, int *mapname, CHAR **params) {
  *mapname = T->tablenum;
  if (NULL_NameChr == T->give_param)
    *params = NULL;
  else
    *params  = T->give_param(T);
}

int open_table(chtable *T, int mapname, CHAR *params) {
  int i;
  if (DEBUG_CHARMAP) {
    if (params)
      print_debug("open_table(T,mapname=%d(%s),params=\"%s\")",
		  mapname,map_name(mapname,0),params);
    else
      print_debug("open_table(T,mapname=%d(%s),params=NULL)",
		  mapname,map_name(mapname,0));
  }
  if (-1 != T->tablenum) 
    close_table(T);
  if (mapname < 0) { 
    *T = NULL_chtable; 
    if (DEBUG_CHARMAP) 
      print_debug("open_table = 0 (bad mapname)");
    return 0; 
  }
  if (mapname < MAP_COUNT) { /* Normal charset */
    T->tablenum = mapname;
    T->rtable   = mapname;
    T->first_char = NULL_CheckChr;
    T->convert_one = NULL_SpanChr;
    T->give_param = NULL_NameChr;
    T->p.code = 0;
    if (DEBUG_CHARMAP) 
      print_debug("open_table = 1 (normal charset)");
    return 1; /* opened */
  }
  for (i=0; i < sizeof (multicodes) / sizeof (chtable); i++) {
    if (mapname == multicodes[i].tablenum) {
      *T = multicodes[i];
      if (DEBUG_CHARMAP) 
	print_debug("open_table: Trying open - idx = %d",i);
      if (T->open_it(T,params)) {
	if (DEBUG_CHARMAP) 
	  print_debug("open_table = 1 (open succeed)");
	return 1; /* opened */
      }
      *T = NULL_chtable; 
      if (DEBUG_CHARMAP) 
	print_debug("open_table = 0 (open failed)");
      return 0; /* failed */
    }
  }
  *T = NULL_chtable; 
  if (DEBUG_CHARMAP) 
    print_debug("open_table = 0 (mapname (multi) not found)");
  return 0; 
}

void close_table(chtable *T) {
  if (-1 == T->tablenum) return;
  *T = NULL_chtable;
}


/* 0 = Nothing in this mode, -1 = need more data, 0 > converted,
   target preallocted  */
int map2_input(chtable *T, int slen,CHAR *source, 
	       int *tlen, CHAR_IDX *target, 
	       int mbyte,int flush) {
  int lookup_to = slen;

  *tlen = 0;
  if (0 == lookup_to) return -1; /* need more data */
  if (!mbyte && T->first_char != NULL_CheckChr &&
      T->first_char(T,source[0])) {
    return 0; /* change mode */
  }

  if (mbyte) {
    int len,count=0,eated=0;

    if (!T->first_char(T,source[0]))
      return 0; /* change mode */

    do {
      int err, reslen;

      len=T->convert_one(T,source+eated,
			 slen-eated,
			 target+count, &reslen,
			 flush,&err);
      if (len > 0 && 0 == err) { eated+=len; 
				 count+=reslen; }
      if (len > 0 && err > 0) { 
	int i;
	for (i = 0; i < len; i++) 
	  target[count++] = -source[eated+i];
	eated+=len; 
      }
    }
    while (len >0 && eated < slen);
    *tlen = count;
    if (0 == eated && len < 0 && !flush) return -1;
    if (eated > 0) return eated;
    CrashMe("map2_input: eated == 0");
  }

  if (!mbyte) {
    if (T->first_char != NULL_CheckChr) {
      int i; /* look from second byte! */
      for (i=1; i < lookup_to; i++)
	if (T->first_char(T,source[i]))
	  lookup_to = i;
    }    
    map_input(T->rtable,lookup_to,source,target);
    *tlen = lookup_to;
    return lookup_to;
  }
  CrashMe("Unreachable");
}


int unmap_string(int table,int len, CHAR_IDX *source, CHAR *target) {
  int i,res = 0;
  for (i = 0; i < len; i++) 
    if (source[i] >= 0 && chars[source[i]].vector[table] >= 0) 
      target[res++] = chars[source[i]].vector[table];
  return res;
}

static struct TN { 
  char *name;
  int table;
  enum nt { NT_name, NT_MIME, NT_joker, NT_IANA } nametype;
} tablenames[] = {
  { "Ascii",                MAP_ASCII,         NT_name },
  { "US-ASCII",             MAP_ASCII,         NT_MIME },
  { "ANSI_X3.4-1968",       MAP_ASCII,         NT_IANA },
  { "ISO646-US",            MAP_ASCII,         NT_IANA },
/*
  { "UNKNOWN-8BIT",         MAP_ASCII,         NT_query },
*/
  { "Latin/1",              MAP_LATIN1,        NT_name },
  { "ISO-8859-1",           MAP_LATIN1,        NT_MIME },
  { "ISO_8859-1:1987",      MAP_LATIN1,        NT_IANA },
  { "ISO_8859-1",           MAP_LATIN1,        NT_IANA },
  { "Latin/2",              MAP_LATIN2,        NT_name },
  { "ISO-8859-2",           MAP_LATIN2,        NT_MIME },
  { "ISO_8859-2:1987",      MAP_LATIN2,        NT_IANA },
  { "ISO_8859-2",           MAP_LATIN2,        NT_IANA },
  { "Latin/3",              MAP_LATIN3,        NT_name },
  { "ISO-8859-3",           MAP_LATIN3,        NT_MIME },
  { "ISO_8859-3:1988",      MAP_LATIN3,        NT_IANA },
  { "ISO_8859-3",           MAP_LATIN3,        NT_IANA },
  { "Latin/4",              MAP_LATIN4,        NT_name },
  { "ISO-8859-4",           MAP_LATIN4,        NT_MIME },
  { "ISO_8859-4:1988",      MAP_LATIN4,        NT_IANA },
  { "ISO_8859-4",           MAP_LATIN4,        NT_IANA },
/*
  { "Cyrillic",             MAP_CYRILLIC,      NT_name },
  { "ISO-8859-5",           MAP_CYRILLIC,      NT_MIME },
  { "ISO_8859-5:1988",      MAP_CYRILLIC,      NT_IANA },
  { "ISO_8859-5",           MAP_CYRILLIC,      NT_IANA },
  { "Arabic",               MAP_ARABIC,        NT_name },
  { "ISO-8859-6",           MAP_ARABIC,        NT_MIME },
  { "ISO_8859-6:1987",      MAP_ARABIC,        NT_IANA },
  { "ISO_8859-6",           MAP_ARABIC,        NT_IANA },
  { "Greek",                MAP_GREEK,         NT_name },
  { "ISO-8859-7",           MAP_GREEK,         NT_MIME },
  { "ISO_8859-7:1987",      MAP_GREEK,         NT_IANA },
  { "ISO_8859-7",           MAP_GREEK,         NT_IANA },
  { "Hebrew",               MAP_HEBREW,        NT_name },
  { "ISO-8859-8",           MAP_HEBREW,        NT_MIME },
  { "ISO_8859-8:1988",      MAP_HEBREW,        NT_IANA },
  { "ISO_8859-8",           MAP_HEBREW,        NT_IANA },
*/
  { "Latin/5",              MAP_LATIN5,        NT_name },
  { "ISO-8859-9",           MAP_LATIN5,        NT_MIME },
  { "ISO_8859-9:1989",      MAP_LATIN5,        NT_IANA },
  { "ISO_8859-9",           MAP_LATIN5,        NT_IANA },
  { "ISO 8859 family",      MAP_LATIN_ANY,     NT_name },
  { "ISO-8859-",            MAP_LATIN_ANY,     NT_joker },
  { "Multinational",        MAP_MULTINATIONAL, NT_name },
  { "X-DEC-MCS",            MAP_MULTINATIONAL, NT_MIME },
  { "DEC-MCS",              MAP_MULTINATIONAL, NT_IANA },
  { "MS-DOS CP437",         MAP_CP437,         NT_name },
  { "MS-DOS",               MAP_CP437,         NT_name },
  { "X-CP437",              MAP_CP437,         NT_MIME },
  { "X-MS-DOS",             MAP_CP437,         NT_MIME },
  { "IBM437",               MAP_CP437,         NT_IANA },
  { "cp437",                MAP_CP437,         NT_IANA },
  { "Macintosh",            MAP_MAC,           NT_name },
  { "X-MAC",                MAP_MAC,           NT_MIME },
  { "macintosh",            MAP_MAC,           NT_IANA },
  { "DEC Finnish",          MAP_FINNISH,       NT_name },
  { "X-ISO646-FI",          MAP_FINNISH,       NT_MIME },
  { "X-ISO646-SF",          MAP_FINNISH,       NT_MIME },
  { "X-ISO646-FIN",         MAP_FINNISH,       NT_MIME },
  { "ISO Swedish",          MAP_ISO_se,       NT_name },
  { "SEN_850200_B",         MAP_ISO_se,       NT_IANA },
  { "ISO646-FI",            MAP_ISO_se,       NT_IANA },
  { "ISO646-SE",            MAP_ISO_se,       NT_IANA },
  { "ISO Swedish 2",        MAP_ISO_se2,      NT_name },
  { "SEN_850200_C",         MAP_ISO_se2,      NT_IANA },
  { "ISO646-SE2",           MAP_ISO_se2,      NT_IANA },
  { "UK-ASCII",             MAP_UK,            NT_name },
  { "ISO British",          MAP_UK,            NT_name },
  { "X-UK-ASCII",           MAP_UK,            NT_MIME },
  { "X-ISO646-GB",          MAP_UK,            NT_MIME },
  { "X-ISO646-GBR",         MAP_UK,            NT_MIME },
  { "BS_4730",              MAP_UK,            NT_IANA },
  { "ISO646-GB",            MAP_UK,            NT_IANA },
  { "ISO Danish",           MAP_NOR,           NT_name },
  { "DEC Norwegian",        MAP_NOR,           NT_name },
  { "X-ISO646-NO",          MAP_NOR,           NT_MIME },
  { "X-ISO646-NOR",         MAP_NOR,           NT_MIME },
  { "X-ISO646-DK",          MAP_NOR,           NT_MIME },
  { "X-ISO646-DNK",         MAP_NOR,           NT_MIME },
  { "ISO646-DK",            MAP_NOR,           NT_MIME },
  { "DS_2089",              MAP_NOR,           NT_IANA },
  { "ISO Norwegian",        MAP_ISO_no,        NT_name },
  { "NS_4551-1",            MAP_ISO_no,        NT_IANA },
  { "ISO646-NO",            MAP_ISO_no,        NT_IANA },
  { "ISO Norwegian 2",      MAP_ISO_no2,       NT_name },
  { "NS_4551-2",            MAP_ISO_no2,       NT_IANA },
  { "ISO646-NO2",           MAP_ISO_no2,       NT_IANA },
  { "ISO Chinese",          MAP_ISO_cn,        NT_name },
  { "GB_1988-80",           MAP_ISO_cn,        NT_IANA },
  { "ISO646-CN",            MAP_ISO_cn,        NT_IANA },
  { "ISO Japanese",         MAP_ISO_jp,        NT_name },
  { "JIS_C6220-1969-ro",    MAP_ISO_jp,        NT_IANA },
  { "ISO646-JP",            MAP_ISO_jp,        NT_IANA },
  { "ISO Portuguese",       MAP_ISO_pt,        NT_name },
  { "PT",                   MAP_ISO_pt,        NT_IANA },
  { "ISO646-PT",            MAP_ISO_pt,        NT_IANA },
  { "ISO Portuguese 2",     MAP_ISO_pt2,       NT_name },
  { "PT2",                  MAP_ISO_pt2,       NT_IANA },
  { "ISO646-PT2",           MAP_ISO_pt2,       NT_IANA },
  { "ISO Spanish",          MAP_ISO_es,        NT_name },
  { "ES",                   MAP_ISO_es,        NT_IANA },
  { "ISO646-ES",            MAP_ISO_es,        NT_IANA },
  { "ISO Spanish 2",        MAP_ISO_es2,       NT_name },
  { "ES2",                  MAP_ISO_es2,       NT_IANA },
  { "ISO646-ES2",           MAP_ISO_es2,       NT_IANA },
  { "ISO Hungarian",        MAP_ISO_hu,        NT_name },
  { "MSZ_7795.3",           MAP_ISO_hu,        NT_IANA },
  { "ISO646-HU",            MAP_ISO_hu,        NT_IANA },
  { "ISO Yugoslavian",      MAP_ISO_yu,        NT_name },
  { "JUS_I.B1.002",         MAP_ISO_yu,        NT_IANA },
  { "ISO646-YU",            MAP_ISO_yu,        NT_IANA },
  { "ISO Cuban",            MAP_ISO_cu,        NT_name },
  { "NC_NC00-10:81",        MAP_ISO_cu,        NT_IANA },
  { "ISO646-CU",            MAP_ISO_cu,        NT_IANA },
  { "ISO Korean (South)",   MAP_ISO_kr,        NT_name },
  { "KSC5636",              MAP_ISO_kr,        NT_IANA },
  { "ISO646-KR",            MAP_ISO_kr,        NT_IANA },
  { "ISO Canadian",         MAP_CAN,           NT_name },
  { "DEC French Canadian",  MAP_CAN,           NT_name },
  { "DEC Canadian",         MAP_CAN,           NT_name },
  { "X-ISO646-CA",          MAP_CAN,           NT_MIME },
  { "X-ISO646-CAN",         MAP_CAN,           NT_MIME },
  { "CSA_Z243.4-1985-1",    MAP_CAN,           NT_IANA },
  { "ISO646-CA",            MAP_CAN,           NT_IANA },
  { "ISO Canadian 2",       MAP_ISO_ca2,       NT_name },
  { "CSA_Z243.4-1985-2",    MAP_ISO_ca2,       NT_IANA },
  { "ISO646-CA2",           MAP_ISO_ca2,       NT_IANA },
  { "ISO French 1",         MAP_BEL,           NT_name },
  { "DEC French/Belgian",   MAP_BEL,           NT_name },
  { "DEC Flemish",          MAP_BEL,           NT_name },
  { "X-ISO646-FR",          MAP_BEL,           NT_MIME },
  { "X-ISO646-FRA",         MAP_BEL,           NT_MIME },
  { "X-ISO646-BE",          MAP_BEL,           NT_MIME },
  { "X-ISO646-BEL",         MAP_BEL,           NT_MIME },
  { "NF_Z_62-010_(1973)",   MAP_BEL,           NT_IANA },
  { "ISO646-FR1",           MAP_BEL,           NT_IANA },
  { "ISO French",           MAP_ISO_fr,        NT_name },
  { "NF_Z_62-010",          MAP_ISO_fr,        NT_IANA },
  { "ISO646-FR",            MAP_ISO_fr,        NT_IANA },
  { "ISO German",           MAP_GER,           NT_name },
  { "X-ISO646-DE",          MAP_GER,           NT_MIME },
  { "X-ISO646-DEU",         MAP_GER,           NT_MIME },
  { "DIN_66003",            MAP_GER,           NT_IANA },
  { "ISO646-DE",            MAP_GER,           NT_IANA },  
  { "DEC Swedish",          MAP_SWE,           NT_name },
  { "X-ISO646-SE",          MAP_SWE,           NT_MIME },
  { "X-ISO646-SWE",         MAP_SWE,           NT_MIME },
  { "DEC Spanish",          MAP_SPA,           NT_name },
  { "X-ISO646-SPA",         MAP_SPA,           NT_MIME },
  { "ISO Italian",          MAP_ITAL,          NT_name },
  { "X-ISO646-ITA",         MAP_ITAL,          NT_MIME },
  { "IT",                   MAP_ITAL,          NT_IANA },
  { "ISO646-IT",            MAP_ITAL,          NT_IANA },
  { "DEC Swiss",            MAP_SWISS,         NT_name },
  { "X-ISO646-CH",          MAP_SWISS,         NT_MIME },
  { "Mnemonics",            MAP_Mnem,          NT_name },
  { "MNEMONIC",             MAP_Mnem,          NT_IANA }, /* ?? */
  { "Unicode 1.1 with UTF7",MAP_UTF7,          NT_name },
  { "UNICODE-1-1-UTF-7",    MAP_UTF7,          NT_MIME },
  { "UNICODE-1-1-UTF-7",    MAP_UTF7,          NT_IANA },
  { "Unicode 1.1 with UTF8",MAP_UTF8,          NT_name },
  { "UNICODE-1-1-UTF-8",    MAP_UTF8,          NT_MIME },
  { "X-FSS-UTF",            MAP_UTF8,          NT_MIME },
/*
  { "UNICODE-1-1-UCS-2",    MAP_UCS2,          NT_IENA },
  { "UNICODE-1-1-UCS-4",    MAP_UCS4,          NT_IENA },
*/
};

static struct label {
  int next;
  CHAR *value;
  int map;
} *labels = NULL;

static int label_count = 0;

static int mime_labels = -1;
static int rename_labels = -1;

init_item charset_items[] = {
  { &mime_labels,   "use.charset.label",   V_LABEL },
  { &rename_labels, "use.renamed.charset", V_LABEL },

  { NULL, NULL, V_LAST }
};



static int find_from_label(int mime, CHAR *value) {
  int i;

  if (mime > 1) 
    return -1;
  for (i = mime ? mime_labels : rename_labels ; -1 != i; i = labels[i].next)
    if (0 == strcasecmp(Cs(value),Cs(labels[i].value)))
      return labels[i].map;
  return -1;
}

int cs_names(int map, int mime, int size, CHAR *vector[]) {
  int i;
  int count = 0;
  enum nt T = NT_name;

  if (1 == mime) T = NT_MIME;
  if (2 == mime) T = NT_IANA;

  if (mime < 2) {
    for (i = mime ? mime_labels : rename_labels;  -1 != i; i = labels[i].next)
      if (map == labels[i].map && 
	  count < size)
	vector[count++] = labels[i].value;      
  }

  for (i = 0; i < sizeof(tablenames) / sizeof (struct TN); i++) 
    if (map == tablenames[i].table &&
	(tablenames[i].nametype == T) &&
	-1 == find_from_label(mime,rCs(tablenames[i].name)) &&
	count < size)
      vector[count++] = rCs(tablenames[i].name);
  return count;
}

CHAR *map_name(int map, int mime) {
  CHAR *vector[1];
  if (cs_names(map,mime,1,vector))
    return vector[0];
  return rCs("Unknown");
}

int find_mime_map (CHAR *name) {
  int i,l,k=strlen(Cs(name));

  i = find_from_label(1,name);
  if (-1 != i) return i;

  for (i = 0; i < sizeof(tablenames) / sizeof (struct TN); i++) 
    if (NT_MIME == tablenames[i].nametype && 
	0 == strcasecmp(Cs(name),tablenames[i].name))
      return tablenames[i].table;

  for (i = 0; i < sizeof(tablenames) / sizeof (struct TN); i++) 
    if (NT_IANA == tablenames[i].nametype && 
	0 == strcasecmp(Cs(name),tablenames[i].name))
      return tablenames[i].table;

  for (i = 0; i < sizeof(tablenames) / sizeof (struct TN); i++) 
    if (NT_joker == tablenames[i].nametype &&
	k > (l = strlen(tablenames[i].name)) &&
	0 == strncasecmp(Cs(name),tablenames[i].name,l)) {
      /* print_notify ("Charset %s not known, using known subset: %s",
		    name,map_name(tablenames[i].table,0));
		    */
      return tablenames[i].table;
    }
  
  return -1;
}

int find_map (CHAR *name) {
  int i,l,k=strlen(Cs(name));

  i = find_from_label(0,name);
  if (-1 != i) return i;

  i = find_from_label(1,name);
  if (-1 != i) return i;

  for (i = 0; i < sizeof(tablenames) / sizeof (struct TN); i++) 
    if (NT_joker != tablenames[i].nametype && 
	0 == strcasecmp(Cs(name),tablenames[i].name))
      return tablenames[i].table;

  for (i = 0; i < sizeof(tablenames) / sizeof (struct TN); i++) 
    if (NT_joker == tablenames[i].nametype &&
	k > (l = strlen(tablenames[i].name)) &&
	0 == strncasecmp(Cs(name),tablenames[i].name,l)) {
      print_notify ("Charset %s not known, using known subset: %s",
		    name,map_name(tablenames[i].table,0));
      return tablenames[i].table;
    }
  
  return -1;
}

int map_label(CHAR *value, int *var) {
  char *p = strchr(Cs(value),'=');
  char *c;
  CHAR *new;
  int map;

  if (NULL == p) return -1;
  *p = '\0';

  for (c = p; c > Cs(value) && (' ' == *(c-1) || '\t' == *(c-1)); c--)
       *(c-1) = '\0';

  for (p++; ' ' == *p || '\t' == *p; p++);

  map = find_map(value);
  if (-1 == map) return -1;

  new = concat_text(NULL,rCs(p));
  labels = (struct label *) pg_realloc((void *)labels,
				    (label_count+1) * sizeof(struct label));

  labels[label_count].next  = *var;
  labels[label_count].map   = map;
  labels[label_count].value = new;
  return label_count++; /* *var = label_count */
}



