/*  file: window.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#define WIN_HEADER   0
#define WIN_TEXT     1
#define WIN_ERROR    2
#define WIN_EDIT     3
#define WIN_PROMPT   4
#define WIN_UNPARSED 5

#define JUST_left   0
#define JUST_right  1
#define JUST_center 2
#define JUST_both   3

extern void int_windows(void);
extern void print_to_window(int win,int X, int Y, int flags,
			    int len,CHAR_IDX *mapped);
extern void clear_window_line(int win,int Y);
extern void cut_window_line(int win,int X, int Y);

extern void scroll_window(int win);
extern void scroll_window_R(int win);
extern void map_window(int win,int line,int Y);
extern void unmap_window(int win);
extern int window_lines(int win);
extern void clear_window(int win);
extern void rewrap_windows(void);
extern void window_pos(int win,int *Y,int *offset, int *roffset,
		       int *pagenum, int *pages);
extern int window_rlines(int win);
extern void get_window_status(int win,int *tab, int *wrap, int *showspc,
			      int *tab_step,int *indent_step, int *priority,
			      int *pagemode);
extern void set_window_status(int win,int tab, int wrap, int showspc,
			      int tab_step, int indent_step, int priority,
			      int pagemode);
extern void set_win_prompt(int win,int X,int Y);
extern void set_win_hl(int win,int flags,int X1,int X2,int Y);
extern int find_buffer_text(int win,int len,CHAR_IDX *mapped,
			    int *X,int *Y,int *rY,
			    int *mlen);
extern CHAR_IDX read_win_char(int win, int X, int Y);
extern int win_line_len(int win,int Y);
extern void get_line_status(int win,int Y, int *indent, int *rindent, 
			    int *submargin, int *justify,
			    int *excerpt_count, int *excerpt_flag,
			    int *force_wrap);
extern void set_line_status(int win,int Y, int indent,  int rindent,
			    int submargin, int justify,
			    int excerpt_count, int excerpt_flag,
			    int force_wrap);
extern void init_windows(void);
extern void flush_window(int win);
extern int win_is_page_top(int win);
