/*  file: terminal.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#include <signal.h>

extern int terminal;
extern int printerror;
extern volatile int need_redraw ;
#define MAX_ESCAPE_SEQUENCE (3+16*3+2)
#define INPUT_BUFFER_SIZE 1024
/* Must be between 1 and 127 !! */
#define WANNA_CHARACTERS 20
extern char *error_text(int code);
extern void print_notify(char *frm, ...);
extern void print_debug(char *frm, ...);
extern void print_error(int code, char *frm, ...);
extern void close_terminal(void);
extern int open_terminal(void);

#define MAX_OUTPUT (2048)
#define ERROR_LEN 1024

#define BS  (010)
#define TAB (011)
#define CR  (015)
#define LF  (012)
#define DEL (0177)

#define ESC (033)
#define CAN (030)
#define SI  (017)
#define SO  (016)

#define IND (0204)
#define NEL (0205)
#define HTS (0210)
#define RI  (0215)
#define SS2 (0216)
#define SS3 (0217)
#define DCS (0220)
#define CSI (0233)
#define ST  (0234)
#define OSC (0235)
#define PM  (0236)
#define APC (0237)

extern void print_to_terminal(CHAR *text);
extern int read_from_terminal(CHAR *buffer);
extern void feed_queued_error(CHAR *message);

extern volatile int lines, columns;
extern void set_terminal_size(int columns,int lines);

typedef sigset_t block_state;

extern void BLOCK  (block_state *s);
extern void UNBLOCK(block_state *s);

extern int need_flush_buffer(void);
extern void flush_buffer(int noerror);

extern int def_lines;
extern int def_columns;

