/*  file: rc.c
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "kehpager.h"
#include "memory.h"
#include "rc.h"
#include "charset.h"
#include "terminal.h"
#include "keyboard.h"
#include "control.h"
#include "content.h"

static init_item *init_lists[] = { control_items, kehpager_items,
				     keyboard_items, env_items,
				     terminal_items, charset_items };

static char *cur_filename = "";
static int  cur_linenum = 0;
extern int errno;

void eval_value (CHAR *var, CHAR *value) {
  int g1 = -1,g2=-1,i,j;
  int a = -1;
  float tmp;

  for (i = 0; i < sizeof(init_lists) / sizeof(init_item *); i++)
    for(j = 0; V_LAST != init_lists[i][j].what; j++) {
      if ( 0 == strcasecmp(init_lists[i][j].name,Cs(var))) {
	g1 = i;
	g2 = j;
	break;
      }
    }
  if (-1 == g1) {
    print_notify("%3d: %s: %s\n     unknown variable %s in file %s in line %d", 
		 cur_linenum,var,value,var,cur_filename,cur_linenum);
    return;
  }
  switch(init_lists[g1][g2].what) {
  case V_BOOL:
    if (0 == strcasecmp(Cs(value),"Enabled")) a = 1;
    else if (0 == strcasecmp(Cs(value),"Disabled")) a = 0;
    else if (0 == strcasecmp(Cs(value),"True")) a = 1;
    else if (0 == strcasecmp(Cs(value),"False")) a = 0;
    else if (0 == strcasecmp(Cs(value),"On")) a = 1;
    else if (0 == strcasecmp(Cs(value),"Off")) a = 0;
    break;
  case V_MODE:
    if (0 == strcasecmp(Cs(value),"None")) a = 0;
    else if (0 == strcasecmp(Cs(value),"Disabled")) a = 0;
    else if (0 == strcasecmp(Cs(value),"National")) a = 1;
    else if (0 == strcasecmp(Cs(value),"Multinational")) a = 2;
    break;
  case V_NUM: 
    if (isdigit(Cc(value[0]))) a = atoi(Cs(value));
    break;
  case V_MAP:
    a = find_map(value);
    break;
  case V_TIMER:
    if (1 == sscanf(Cs(value),"%f",&tmp)) {
      a = tmp*10.0;
      if (a < 1) a = 1;
    }
    break;
  case V_KEY:
    a = map_key(value,init_lists[g1][g2].variable);
    break;
  case V_LABEL:
    a = map_label(value,init_lists[g1][g2].variable);
    break;
  case V_ATTR:
    a = map_attribute(value,init_lists[g1][g2].variable);
    break;
  case V_CONTENT:
    a = search_content(value,0);
    break;
  case V_LAST:
    print_notify("(%s) Software error/eval_value: variable type is V_LAST\n"
		 "%3d: %s: %s\n"
		 "     bad type of variable %s in file %s in line %d", 
		 prog,
		 cur_linenum,var,value,
		 var,cur_filename,cur_linenum);
    return;    
  }
  
  if (-1 == a) {
    print_notify("%3d: %s: %s\n     unknown value %s in file %s in line %d", 
		 cur_linenum,var,value,value,cur_filename,cur_linenum);
    return;
  }

  *(init_lists[g1][g2].variable) = a;
}

#define MAX_LINE 1000

extern void read_rc_file(CHAR *filename) {
  CHAR buffer[MAX_LINE+1];
  FILE *rc = fopen(Cs(filename),"r");

  if (NULL == rc) return;

  cur_filename = Cs(filename);
  cur_linenum = 0;

  while(fgets(Cs(buffer),MAX_LINE,rc)) {
    CHAR *C,*C1;
    cur_linenum++;
    if(!(C = rCs(strchr(Cs(buffer),'\n')))) {
      print_notify("%3d: %s\n     too long line in file %s in line %d", 
		   cur_linenum,buffer,cur_filename,cur_linenum);
      fclose(rc);
      return;
    } else {
      while(C > buffer && (' ' == *(C-1) || '\t' == *(C-1))) C--;
      *C = '\0';
    }
    
    if (NULL != (C1 = rCs(strchr(Cs(buffer),'#')))) {
      while(C1 > buffer && (' ' == *(C1-1) || '\t' == *(C1-1))) C1--;
      *C1 = '\0';
    }
    
    if ('\0' == buffer[0]) continue;

    if (!(C1=rCs(strchr(Cs(buffer),':')))) {
      print_notify("%3d: %s\n     No ':' in file %s in line %d", 
		   cur_linenum,buffer,cur_filename,cur_linenum);
      continue;
    }
      
    *C1++ = '\0';
    while (' ' == *C1 || '\t' == *C1) C1++;
    
    C = buffer;
    while (' ' == *C || '\t' == *C) C++;
    
    eval_value(C,C1);
  }

  if (ferror(rc)) {
    int code=errno;
    print_error(code,"Error when reading line %d in file %s", 
		cur_linenum+1,cur_filename);
  }
  fclose(rc);
}
