/*  file: memory.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#include <stdlib.h>

extern void *MALLOC(size_t size);
extern void *REALLOC(void *orig,size_t size);
extern void FREE(void *ptr);
extern CHAR * concat_text(CHAR *str,CHAR *text);

typedef struct S_t {
  size_t alloced;
  size_t len;
  CHAR *buffer;
} String;

#define StrLEN(s) (s).len
#define StrPTR(s) (s).buffer

extern void StrInit(String *S, size_t size);
extern void StrFree(String *S);
extern void StrSet(String *S,CHAR *text);
extern void StrSet2(String *S,int len,CHAR *text);
extern void StrAdd(String *S, CHAR c);
extern void StrCat(String *S,String *S2);
