/*  file: memory.c
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#include <string.h>
#include <stdio.h>

#include "kehpager.h"
#include "memory.h"
#include "terminal.h"

#define MAX_POSSIBLE 100000L

static void check_error(size_t size) {
  /* For debugging... */
  if (size > MAX_POSSIBLE ) {
    print_notify("(%s) Allocation size = %d > %d\n   Aborting...",
		 prog,size,MAX_POSSIBLE);
    flush_error_buffer();
    abort();
  }
}

void *MALLOC(size_t size)
{
	void *ptr=malloc(size);
	if (!ptr) {
	  if (DEBUG_MEM) 
	    print_debug("MALLOC(%ld)=       ...",(long)size);
	  print_notify("(%s) Can't malloc %d bytes.\n",prog,size);
	  close_files();
	  close_terminal();
	  flush_error_buffer();
	  check_error(size);
	  exit(5);
	}
	if (DEBUG_MEM) {
	  print_debug("MALLOC(%ld)=       0x%lx",(long)size,(long)ptr);
	}
	return ptr;
}

void *REALLOC(void *orig,size_t size)
{
	void *ptr=orig ? realloc(orig,size) : malloc(size);
	if (!ptr) {
	  if (DEBUG_MEM) 
	    print_debug("REALLOC(0x%lx,%ld)=  ...",(long)orig,(long)size);
	  print_notify("(%s) Can't realloc %d bytes.\n",prog,size);
	  close_files();
	  close_terminal();
	  flush_error_buffer();
	  check_error(size);
	  exit(5);
	}
	if (DEBUG_MEM) {
	  print_debug("REALLOC(0x%lx,%ld)=  0x%lx",(long)orig,(long)size,(long)ptr);
	}
	return ptr;
}

void FREE(void *ptr) {
  if (DEBUG_MEM) {
    print_debug("FREE(0x%lx)",(long)ptr);
  }
  free(ptr);
}

CHAR * concat_text(CHAR *str,CHAR *text)
{
	int len = strlen(Cs(text));
	if (!str) {
		str = (CHAR *) MALLOC(len+1);
		strcpy(Cs(str),Cs(text));
		return str;
	}
	str = (CHAR *) REALLOC((void *)str,strlen(Cs(str))+len+1);
	strcat(Cs(str),Cs(text));
	return str;
}

void StrInit(String *S, size_t size) {
  S->len = 0,
  S->buffer = (CHAR *)MALLOC(size);
  S->alloced = size;
}

void StrFree(String *S) {
  if (S->buffer) FREE((void *)S->buffer);
  S->buffer = NULL;
  S->alloced = 0;
  S->len = 0;
}

void StrSet2(String *S,int len,CHAR *text) {
  S->buffer=(CHAR *)REALLOC((void *)S->buffer,len+1);
  memcpy(Cs(S->buffer),Cs(text),len);
  Cs(S->buffer)[len]='\0';
  S->alloced = len+1;
  S->len = len;
}

void StrSet(String *S,CHAR *text) {
  int len = strlen(Cs(text));
  StrSet2(S,len,text);
}

extern void StrAdd(String *S, CHAR c) {
  int req = S->len +2;
  if (req > S->alloced) {
    S->buffer=(CHAR *)REALLOC((void *)S->buffer,req+10);
    S->alloced=req+10;
  }
  S->buffer[S->len]=c;
  S->buffer[S->len+1]='\0';
  S->len++;
}

void StrCat(String *S,String *S2) {
  int req = S->len + S2->len +1;
  if (req > S->alloced) {
    S->buffer=(CHAR *)REALLOC((void *)S->buffer,req+10);
    S->alloced=req+10;
  }
  memcpy((void *)(S->buffer+S->len),(void *)(S2->buffer),S2->len);
  S->len += S2->len;
  S->buffer[S->len] = '\0';
}

