/*  file: keyboard.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

extern int map_key(CHAR *key, int *pos);
extern int *parse_key(int cmd, int group, CHAR_IDX *ch);
extern int *parse_char(CHAR c, int group, CHAR_IDX *ch);
extern CHAR *give_mapping(int *pos);
extern CHAR *give_ctl_mapping(int *pos);
extern int control_key(int *pos, CHAR *ch);
extern CHAR *key_name(int cmd);
extern CHAR *composing(void);
extern void make_default(int *pos, CHAR ch);

extern int key_quit;
extern int key_tab;
extern int key_prompt;
extern int key_pagemode;
extern int key_wrap;
extern int key_time;
extern int key_spc;
extern int key_next;
extern int key_page;
extern int key_prev;
extern int key_help;
extern int key_redraw;
extern int key_lnext;
extern int key_lprev;
extern int key_top;
extern int key_bottom;
extern int key_mquit;
extern int key_debug;
extern int key_copyright;

extern int key_nogroup;

extern int key_goto;
extern int key_genter;
extern int key_gpercnt;

extern int key_nl;
extern int key_nl_unix;
extern int key_nl_network;
extern int key_nl_enter;

extern int key_ct;
extern int key_ct_insert;
extern int key_ct_enter;

extern int key_ts;
extern int key_ts_insert;
extern int key_ts_enter;
extern int key_is;
extern int key_is_insert;
extern int key_is_enter;

extern int key_search;
extern int key_searchf;
extern int key_searchn;
extern int key_ssearchn;
extern int key_ssearchf;
extern int key_sinsert;
extern int key_senter;

extern int key_edel;
extern int key_eerase;

extern int key_reread;
extern int key_forward;
extern int key_charset;
extern int key_cinsert;
extern int key_center;

extern int key_cancel;
extern int key_compose;
extern int key_kill;
extern int key_suspend;
extern int key_flush;
extern int key_abort;
extern int key_res1;
extern int key_res2;

#define GROUP_count 10
#define G_PAGER 0
#define G_MESSAGE 1
#define G_MESSAGE_LAST 2
#define G_GOTO 3
#define G_SEARCH 4
#define G_CHARSET 5
#define G_NEWLINE 6
#define G_CONTENT 7
#define G_TABSTEP  8
#define G_INDENTSTEP 9
