/*  file: kehpager.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#ifdef __GNUC__
#define INLINE __inline__
#else
#define INLINE
#endif

typedef unsigned char CHAR;
INLINE static char * Cs(CHAR *s) { return (char *)s; } 
INLINE static CHAR * rCs(char *s) { return (CHAR *)s; } 
INLINE static char   Cc(CHAR s) { return (char)s; } 
INLINE static CHAR   rCc(CHAR s) { return (CHAR)s; } 
#if defined MAX
#undef MAX
#endif
INLINE static int MAX(int A,int B) { return A > B ? A : B; }

/* Yes, these is really statis function */

extern char *prog;
extern int quitflag;
extern int debugflag;

#define DEBUG_MEM (debugflag & 1)
#define DEBUG_TERM (debugflag & 2)
#define DEBUG_CURSOR (debugflag & 4)
#define DEBUG_WRAP (debugflag & 8)
#define DEBUG_PROMPT (debugflag & 16)
#define DEBUG_SIGNAL (debugflag & 32)
#define DEBUG_NOGROUP (debugflag & 64)
#define DEBUG_ENRICHED (debugflag & 128)
#define DEBUG_BUFFER (debugflag & 256)
#define DEBUG_MWRAP (debugflag & 512)
#define DEBUG_LBUFFER (debugflag & 1024)
#define DEBUG_FILIO (debugflag & 2048)
#define DEBUG_CHARMAP (debugflag & 4096)

extern int error_callback(CHAR *string);
extern void close_files(void);
extern void flush_error_buffer(void);

#define CrashMe(text) { static in_crash_me = 0; \
  if (!in_crash_me) { in_crash_me = 1; reset_terminal_state(); \
  close_files(); close_terminal(); \
  print_notify("(%s) Software error: %s\n\tFile %s line %d\n" \
               "\tAborting (will produce core dump) ...", \
               prog, text,__FILE__, __LINE__); flush_error_buffer(); \
	       } abort(); } 

			  
