/*  file: esc.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#include <limits.h>

typedef enum { C_text, C_ctl, C_escape, C_escpair, C_string,
	       C_single} c_type;

#define MAX_COMMANDS 100
#define MAX_INTCMS 16
#define MAX_STRINGCMS 256 

extern struct command {
  c_type what;
  unsigned char cmd;
  int len;
  char *char_arr;
} commands[];

extern int command_len;
extern int personality_8bit;

extern void parse_input(CHAR *buffer, int len);
extern void rem_command(int ptr);
extern CHAR *unparsed_printable(void);
extern CHAR * printable_command(int ptr);
extern CHAR * printable_sequence(int ptr);
extern CHAR * map_buffer(CHAR *buffer, int need_mapping,
			 CHAR *static_buffer, int static_len);
void char2names(String *source,CHAR **target);
