/*  file: env.c
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "kehpager.h"
#include "env.h"
#include "memory.h"
#include "terminal.h"
#include "rc.h"

int disable_fast_start = 0;
static int use_display = 0;
static int use_size = 1;

init_item env_items[] = {
  { &use_display,  "env.display",  V_BOOL },
  { &use_size,     "env.size",     V_BOOL },
  { NULL, NULL, V_LAST }
};

static int find_item (char *name) {
  int i;
  for (i = 0; NULL != kehpager_term[i].id; i++) 
    if (0 == strcmp(kehpager_term[i].id,name)) return i;
  return -1;
}

static int find_item2 (char *name) {
  int i;
  for (i = 0; NULL != kehpager_term2[i].id; i++) 
    if (0 == strcmp(kehpager_term2[i].id,name)) return i;
  return -1;
}


static CHAR *gen_fields(void) {
  CHAR *result = NULL;
  int i;
  for(i=0; NULL != kehpager_term[i].id; i++) 
    if (-1 != *(kehpager_term[i].var)) {
      CHAR buffer[10];
      if (NULL != result) result = concat_text(result,rCs(":"));
      result = concat_text(result,rCs(kehpager_term[i].id));
      result = concat_text(result,rCs("="));
      sprintf(Cs(buffer),"%d",*(kehpager_term[i].var));
      result = concat_text(result,buffer);
  }
  for(i=0; NULL != kehpager_term2[i].id; i++) 
    if (-1 != *(kehpager_term2[i].var)) {
      CHAR buffer[10];
      if (NULL != result) result = concat_text(result,rCs(":"));
      result = concat_text(result,rCs(kehpager_term2[i].id));
      result = concat_text(result,rCs("="));
      sprintf(Cs(buffer),"%ld",*(kehpager_term2[i].var));
      result = concat_text(result,buffer);
  }
  return result;
}

static void read_fields(CHAR *string) {
  CHAR *temp = concat_text(NULL,string);
  char *a1;

  for (a1 = strtok(Cs(temp),"="); a1 != NULL; a1 = strtok(NULL,"=")) {
    char *a2 = strtok(NULL,":");
    int field;
    if (NULL == a2) {
      print_notify("No value for field %s in KEHPAGER_TERM",a1);
      continue;
    }
    if (!isdigit(a2[0])) {
      print_notify("Bad value %s field %s in KEHPAGER_TERM",a2,a1);
      continue;
    }

    if (-1 != (field = find_item(a1)))
      *(kehpager_term[field].var) = atoi(a2);
    else if (-1 != (field = find_item2(a1)))
      *(kehpager_term2[field].var) = atol(a2);
  }
  FREE(temp);
}


int init_from_kehpager_term(void) {
  CHAR * kehpager_term = 
    rCs(getenv("KEHPAGER_TERM"));
  if (!kehpager_term || disable_fast_start) return 0;
  read_fields(kehpager_term);
  return 1;
}

int set_lines=-1;
int set_columns=-1;

void print_kehpager_term(char *pre, 
			 char *form_one, 
			 char *fin_one,
			 char *final) {
  char value2[5];
  CHAR * value = gen_fields();
  if (pre)
    printf(pre);  
  printf(form_one,"KEHPAGER_TERM",value);
  if (fin_one)
    printf(fin_one,"KEHPAGER_TERM");
  if (-1 != set_columns) {
    sprintf(value2,"%d",set_columns);
    printf(form_one,"COLUMNS",value2);
    if (fin_one)
      printf(fin_one,"COLUMNS");
  }
  if (-1 != set_lines) {
    sprintf(value2,"%d",set_lines);
    printf(form_one,"LINES",value2);
    if (fin_one)
      printf(fin_one,"LINES");
  }
  if (final)
    printf(final);
  FREE(value);
}

int is_xterm(void) {
  char *display = getenv("DISPLAY");
  char *term = getenv("TERM");

  return (use_display && display &&  '\0' != display[0]) || 
  	(term && (0 == strcmp(term,"xterm") ||
		0 == strcmp(term,"ixterm")));
}


void import_vars(void) {
  char *Lines = getenv("LINES");
  char *Columns = getenv("COLUMNS");

  if (use_size && Lines && '\0' != Lines[0] && isdigit(Lines[0])) {
    int val = atoi(Lines);
    if (val > 0) def_lines = val;
  }

  if (use_size && Columns && '\0' != Columns[0] && isdigit(Columns[0])) {
    int val = atoi(Columns);
    if (val > 0) def_columns = val;
  }

}
