/*  file: control.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

extern volatile int pager_state;
extern volatile int down_line;
extern int timer_per_char;
extern int set_xterm_latin1;
extern int default_language;
extern int keyboard_charset;
extern int force_mode;
extern int limit_query;
extern int query_terminal_size;

extern void reset_terminal_state(void);
extern void get_terminal_state(void);
extern void set_terminal_state(void);
extern void do_redraw(void);
extern volatile int need_redraw;
extern int ask_timeout(long *timeout); /* 1/10 seconds */
extern void do_timeout(void);
extern int do_escape(int cmd);
extern void clear_line(int line);
extern void clear_rest_of_line(int x,int line);
extern int print_XY(int X, int Y, int flags,int len,CHAR_IDX *mapped, 
		    int showspc, int priority);
extern void clear_from_line(int line);
extern void delete_line(int line);
extern void insert_line(int line);
extern void scroll_area(int Y1,int Y2);
extern void set_hard(int X,int Y);
extern void set_margins(int Y1, int Y2);
extern int printable_len(int len,CHAR_IDX *mapped, int *list,int showspc);
extern void give_debug_page(void (*printer)(CHAR *line, int header));
extern int map_attribute(CHAR *value,int *ptr);
extern int sum_fl_attr(int flags, int new);
extern int flush_some_lines(void);
extern int need_line_flush(void);
extern void flush_to_priority(int priority);

/* To save memory and speed up */
#define MAX_LINES (402) 

#define FL_BOLD    (1 << 0)
#define FL_DIM     (1 << 1)
/* #define FL_CONCEAL (1 << 2) */
#define FL_UNDER   (1 << 3)
#define FL_REVERSE (1 << 4)
#define FL_BLINK   (1 << 5)

/* output priorities */
#define PRI_NORMAL   0
#define PRI_EDIT     1
#define PRI_COMPLETE 5
#define PRI_WAIT     6      /* print immediately */

/* Hazards */
extern long hazards;
#define HAZ_wrap     (1L<<0)   /* May wrap in right edge */
#define HAZ_national (1L<<1)   /* National mode */
#define HAZ_ONLCR    (1L<<2)   /* May map LF -> CR LF */
#define HAZ_TAB      (1L<<3)   /* May expand TAB -> SPCs */
#define HAZ_newline  (1L<<4)   /* LF may do newline, return produces CR LF */
#define HAZ_application (1L<<5) /* cursor keys is in application mode */

#define HAZ_DOES(x) (hazards |= (x))
#define HAZ_DONT(x) (hazards &= ~(x))
#define HAZ_MAY(x)  ((hazards & (x)) == (x))
