/*  file: content.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */

#define CT_plain    0
#define CT_terminal 1
#define CT_enriched 2
#define CT_richtext 3

typedef struct CT content;
struct CT {
  int ct;
  int *fp;
  int win;
  int cs_flag;
  int multi;
  void (* init)(content *CT);
  int (* handle)(content *CT,int len, CHAR *buffer);
  int (* handle_multi)(content *CT,int len, CHAR *buffer,int flush);
  void (* handle_eoln)(content *CT);
  void (* exit)(content *CT);
  void (* update)(content *CT);
  int last_line_Y;
  int last_line_X;
  union {
    struct {
       int magic;
       int attrib_char_flag;
       int owerwrite;
       String attrib_buffer; 

    } terminal;
    int plain;
    struct {      /* both Enriched and Richtext uses this same structure */
      int magic;
      String cmd_buffer; 
      int nl_count;
      int spc_count;
      int verbatim;
      int no_nl; /* used by richtext */
      struct er_STACK {
	struct er_STACK *previous;
	int indent;
	int pindent;   /* used by richtext */
	chtable cs;        /* used by richtext */
	int submargin;
	int param; /* 2 = richtext comment */
	int nofill;
	int justify;
	int excerpt_count;
	int excerpt_flag;
	int attrib_flag;
	int force_wrap;
	int er_function;
	CHAR *name;
      } *stack_top;
    } enriched;
  } c;
  chtable cs;
  String multi_buffer;
};

extern const content NULL_content;

extern void init_content(int content_type,int *fp,int win, 
			 int cs, CHAR *cs_param,
			 content *CT);
extern void handle_content(content *CT, int len, unsigned char *buffer);
extern void eoln_content(content *CT);
extern void exit_content(content *CT);
extern void update_content(content *CT);
extern int search_content(CHAR *name,int mime);
extern CHAR *content_name(int content, int mime);
		    
extern void scroll_it(int win);

extern int enable_fulljust;

