/*  file: charset.h
 *
 *  kehpager, Charset aware pager, Kari E. Hurtta
 *
 *  Copyright (c) 1993, 1994 Kari E. Hurtta
 *
 *  Redistribution and use in source and binary forms are permitted
 *  provided that the above copyright notice and this paragraph are
 *  duplicated in all such forms. This software is provided 'as is'
 *  and without any warranty. 
 */


#define MAP_COUNT 22

#define MAP_ASCII 0
#define MAP_LATIN1 1
#define MAP_MULTINATIONAL 2
#define MAP_SPECIAL 3
#define MAP_FINNISH 4
#define MAP_UK      5
#define MAP_NOR     6
#define MAP_SWE     7
#define MAP_LATIN4  8
#define MAP_LATIN5  9
#define MAP_LATIN_ANY  10
#define MAP_LATIN2  11
#define MAP_BEL     12
#define MAP_GER     13
#define MAP_CAN     14
#define MAP_LATIN3  15
#define MAP_CP437   16
#define MAP_TECHNICAL 17
#define MAP_SPA     18
#define MAP_MAC     19
#define MAP_ITAL    20
#define MAP_UNICODE11 21 /* Unicode 1.1 */


#define ENT_COUNT   2
#define MULTI_COUNT  2

#define ENT_Mnem    0                   /* Mnemonics encoding (RFC 1345) */
#define ENT_name    1                   /* Long name */

#define BASE_MULTI (MAP_COUNT+ENT_COUNT)

#define MAP_Mnem   (MAP_COUNT+ENT_Mnem)

#define MAP_UTF7   (BASE_MULTI+0)       /* Unicode 1.1 with UTF 7 */
#define MAP_UTF8   (BASE_MULTI+1)       /* Unicode 1.1 with UTF 8 */

#define TOTAL_MAP_COUNT (BASE_MULTI+MULTI_COUNT)

#define MAX_FALLBACK 15

/* CHAR_IDX must handle range from -CHAR_code to +CHAR_code */
typedef long CHAR_IDX;

extern struct CV {
  char *fallback;
  char compose[2];
  int printable;
  CHAR_IDX *mark;
  int vector[MAP_COUNT];
  char *evector[ENT_COUNT];
} chars[];

#define CHARS_COUNT (sizeof (chars) / sizeof (struct CV))
extern CHAR_IDX CHARS_COUNT_;

extern CHAR_IDX inmap(int map,int ch);
extern CHAR_IDX inmapc(int map, const char *c);

extern void init_tables(void);
extern void map_input(int table, int len, CHAR *source, CHAR_IDX *target);
extern int unmap_string(int table,int len, CHAR_IDX *source, CHAR *target);
extern int find_map (CHAR *name);
extern int find_mime_map (CHAR *name);
extern CHAR *map_name(int map, int mime);
extern int cs_names(int map, int mime, int size, CHAR *vector[]);
extern int string_value(int len, CHAR_IDX *buffer);
extern int map_label(CHAR *value, int *var);

struct CH_t;
typedef int CheckChr(struct CH_t *T,CHAR t);
typedef int SpanChr(struct CH_t *T,CHAR *p, int max,
		    CHAR_IDX *result, int *result_len,
		    int flush,int *err);
typedef int OpenChr(struct CH_t *T,CHAR *params);
typedef CHAR * NameChr(struct CH_t *T);

typedef struct CH_t {
  int tablenum;
  int rtable;  
  OpenChr *open_it;
  CheckChr *first_char;
  SpanChr *convert_one;
  NameChr *give_param;
  union {
    /* 0 */
    int code;
    /* 1 */
    struct {
      int code;
      int esc;

    } mnem;
    /* 2 */
    struct {
      int code;

    } utf7;
    /* 3 */
    struct {
      int code;

    } utf8;
  } p;
} chtable;

extern int open_table(chtable *T, int mapname, CHAR *params);
extern void close_table(chtable *T);
/* 0 = Nothing in this mode, -1 = need more data, 0 > converted,
   target preallocted  */
extern int map2_input(chtable *T, int slen, CHAR *source, 
		      int *tlen,
		      CHAR_IDX *target, 
		      int mbyte,int flush);
extern void copy_table(chtable *T,chtable *old);
extern void name_table(chtable *T, int *mapname, CHAR **params);

extern const chtable NULL_chtable;

extern CHAR_IDX CH_SPC;
extern CHAR_IDX CH_TAB;
extern CHAR_IDX CH_SHY;
extern CHAR_IDX CH_NBSP;
extern CHAR_IDX CH_HY;
extern CHAR_IDX CH_HY2;
extern CHAR_IDX CH_NBHY;
extern CHAR_IDX CH_SHY2;
extern CHAR_IDX CH_UL;
extern CHAR_IDX CH_WRA;
extern CHAR_IDX CH_NL;
extern CHAR_IDX CH_GT;
extern CHAR_IDX CH_LT;
extern CHAR_IDX CH_FF;
extern CHAR_IDX CH_PLUS;

/* Marks: */
extern CHAR_IDX CH_SUB_M;
extern CHAR_IDX CH_SUP_M;
extern CHAR_IDX CH_END_M;
extern CHAR_IDX CH_SPC_C;
extern CHAR_IDX CH_IND_B;
extern CHAR_IDX CH_IND_E;
extern CHAR_IDX CH_MAR_B;
extern CHAR_IDX CH_MAR_E;
extern CHAR_IDX CH_NP;
extern CHAR_IDX CH_OVER;
extern CHAR_IDX CH_LSEP;
extern CHAR_IDX CH_PSEP;

#define CHAR_code    0x00FFFF
#define CHAR_flags   0xFF0000
#define FC_uncertain 0x010000
#define FC_fallback  0x020000
#define FC_alias     0x040000

