;# $Id: depend.pl,v 3.0.1.1 1993/10/16 13:54:35 ram Exp $
;#
;#  Copyright (c) 1991-1993, Raphael Manfredi
;#  
;#  You may redistribute only under the terms of the Artistic Licence,
;#  as specified in the README file that comes with the distribution.
;#  You may reuse parts of this distribution only within the terms of
;#  that same Artistic Licence; a copy of which may be found at the root
;#  of the source tree for dist 3.0.
;#
;# $Log: depend.pl,v $
;# Revision 3.0.1.1  1993/10/16  13:54:35  ram
;# patch12: added minimal support for ?P: lines (not ready yet)
;#
;# Revision 3.0  1993/08/18  12:10:21  ram
;# Baseline for dist 3.0 netwide release.
;#
;# Metaconfig-dependent part of the dependency extranction.
;#
# Process the ?W: lines
sub p_wanted {
	# Syntax is ?W:<shell symbols>:<C symbols>
	local($active) = $_[0] =~ /^([^:]*):/;		# Symbols to activate
	local($look_symbols) = $_[0] =~ /:(.*)/;	# When those are used
	local(@syms) = split(/ /, $look_symbols);	# Keep original spacing info
	$active =~ s/\s+/\n/g;						# One symbol per line

	# Concatenate quoted strings, so saying something like 'two words' will
	# be introduced as one single symbol "two words".
	local(@symbols);				# Concatenated symbols to look for
	local($concat) = '';			# Concatenation buffer
	foreach (@syms) {
		if (s/^\'//) {
			$concat = $_;
		} elsif (s/\'$//) {
			push(@symbols, $concat . ' ' . $_);
			$concat = '';
		} else {
			push(@symbols, $_) unless $concat;
			$concat .= ' ' . $_ if $concat;
		}
	}

	# Now record symbols in master and wanted tables
	foreach (@symbols) {
		$cmaster{$_} = undef;					# Asks for look-up in C files
		$cwanted{$_} = "$active" if $active;	# Shell symbols to activate
	}
}

# Process the ?INIT: lines
sub p_init {
	local($_) = @_;
	print INIT "?$unit:", $_;		# Wanted only if unit is loaded
}

# Process the ?D: lines
sub p_default {
	local($_) = @_;
	s/^([A-Za-z_]+)=(.*)/@if !$1\n%$1:$1=$2\n@define $1\n@end/
		&& ($hasdefault{$1}++, print INIT $_);
}

# Process the ?P: lines
sub p_public {
	local($_) = @_;
	local($csym);					# C symbol(s) we're trying to look at
	local($nosym);					# List of symbol(s) which mustn't be wanted
	local($cfile);					# Name of file implementing csym (no .ext)
	($csym, $nosym, $cfile) = /([^()]+)\s*(\(.*\))\s*:\s*(\S+)/;
	unless ($csym eq '' || $cfile eq '') {
		# Add dependencies for each C symbol, of the form:
		#	-pick public <sym> <file> <notdef symbols list>
		# and the file will be added to config.c whenever sym is wanted and
		# none of the notdef symbols is wanted.
		foreach $sym (split(' ', $csym)) {
			$dependencies .= "\t-pick public $sym $cfile $nosym\n";
		}
	}
}

# Process the ?L: lines
# There should not be any '-l' in front of the library name
sub p_library {
	&write_out("L:$_");
}

# Process the ?I: lines
sub p_include {
	&write_out("I:$_");
}

# Write out line in file Extern.U. The information recorded there has the
# following prototypical format:
#   ?symbol:L:inet bsd
# If 'symbol' is wanted, then 'inet bsd' will be added to $libswanted.
sub write_out {
	local($_) = @_;
	local($target) = $defined;		# By default, applies to defined symbols
	$target = $1 if s/^(.*)://;		# List is qualified "?L:target:symbols"
	local(@target) = split(' ', $target);
	chop;
	foreach $key (@target) {
		print EXTERN "?$key:$_\n";	# EXTERN file defined in xref.pl
	}
}

