#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ($#argv >= 1) && ("$1" != "") ) then
  set DIRDEF = "$1"
else if ( ! $?DIRDEF ) then
  set DIRDEF = saphir
endif
  
#
# vms.csh [DIRDEF]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
*** 
*** 
***  USAGE: $0 [DIRDEF]
*** 
***    DIRDEF  is the name of the project (saphir)
*** 
*** 
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# Informationen anzeigen
#
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project object library         =   $OBJLIB
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif

#
# Aufrauemen
#
set CLEAN="*.o"
action cleaning up
rm -f $CLEAN

#
# Dateien erzeugen
#
action creating objects
check make lib

#
# Library aufbauen
#
action copying objects
check ar rv $OBJLIB *.o

#
# Aufraeumen
#
action cleaning up
rm -f $CLEAN

#
# Fertig
#
action VMS support library installation complete

