#include <saphir/vmsdef.h>

#include <saphir/modules/FILE.h>

struct item_list_3
       {
	short blen;
	short code;
	char  *addr;
	short *rlen;
       };

#define SDOT		1
#define EDOT		2
#define ZDOT		4
#define MDOT		(SDOT|EDOT)

#define DNONE		0
#define DANALYZE	1
#define DMERGE		2

static int dircode,defcode,defID = DNONE,Fdir,Ffile,Fsuff,Fvers,dirflag;
static struct epcbFILE *pcb = 0;

char translate_vms_config[16] = " DRDRDRDDDRDRDRD";

extern struct epcbFILE *getpcb();
extern char *parse_error();

#define GETIT(b,n)	(pcb->pcb_start[n] ? b+pcb->pcb_start[n]-pcb->pcb_start[1] : 0)
#define FAIL()		{res=(char *)-1;break;}

#define DEFTAB		"LNM$FILE_DEV"
#define MAXSIZE		255

#define NOSTR		((char *)0)

/*
  Uebersetze einen VAX/VMS Dateinamen in einen BOSS/UNIX-Dateinamen. Dabei
  werden eventuell benutzte logische Namen uebersetzt.
*/
char *translate_vms(vms)
char *vms;
{
 static char fbuf[1024]; 
 static int level = 0;
 char *base,*node,*proxy,*device,*dir,*file,*suff,*vers,*res = fbuf,*out,ch,*tmp,lbuf[256];
 int attr,zero = 0,acmode = PSL$C_USER,inattr = 0,dlen,zap = -2,cmp;
 struct item_list_3 trn[4];
 short len;

 /* Initialisierung */
 if ( !level )
  {
   dirflag = 0;
   Fdir = Ffile = Fsuff = Fvers = -1;
  }
 /* Konsistenztest */
 if ( strlen(vms) >= MAXSIZE ) return (char *)-1;
 /* Parsertabelle suchen */ 
 if ( !pcb && !(pcb = getpcb(pcbFILE_module)) ) return NOSTR;
 /* Dateiname auswerten */
 if ( parse(pcb,vms) ) return (char *)-1;
 /* Bezugsadresse ermitteln */
 base = (char *)pcb->pcb_tree;
 /* Namensabschluss sicherstellen */
 if ( *pcb->sys_pcb.pcb_line )
  {
   free(base);
   return (char *)-1;
  }
 /* - DECNet Knoten */
 node = GETIT(base,2);
 /* - Logininformation */
 if ( proxy = GETIT(base,3) )
  {
   *proxy++ = '\0';
   zap = -3;
  }
 /* - Device */
 if ( device = GETIT(base,4) )
  {
   if ( device != base ) device[zap] = '\0';
   zap = -1;
  }
 /* - Directory */
 if ( dir = GETIT(base,5) )
  {
   if ( dir != base ) dir[zap] = '\0';
   *dir++ = '\0';
   zap = -1;
  } 
 /* - Dateiname */
 if ( (file = GETIT(base,6)) && (file != base) ) file[zap] = '\0';
 /* - Dateisuffix */
 if ( suff = GETIT(base,7) ) *suff++ = '\0';
 /* - Versionsnummer */
 if ( vers = GETIT(base,8) ) *vers++ = '\0';
 /* Dateiname in Hochkommas wird einfach uebernommen */
 if ( !node && !proxy && !device && !dir && !file && !suff && !vers )
  {
   /* In der neuen Version ist der Text einschliesslich der Hochkommas */
   strcpy(fbuf,base+1);
   if ( len = strlen(fbuf) ) fbuf[len-1] = '\0'; 
   /* Keine Zusaetze mehr */
   dirflag = 5;
   /* Speicher freigeben und Erfolg melden */
   free(base);
   return (defID == DANALYZE) ? ((char *)-1) : fbuf;
  }
 /* Abschluesse setzen */
 if ( !file )
  {
   if ( dir )
    file = dir+strlen(dir)-1;
   else if ( device )
    file = device+strlen(device)-1;
   else if ( proxy )
    file = proxy+strlen(proxy)-3;
   else if ( node )
    file = node+strlen(node)-2;
   else
    file = base;
   *file = '\0';
  }
 else if ( (file == base) && !suff && !vers )
  file = (device = file)+strlen(file);
 /* Keine Unterstuetzung von DECNet */
 if ( node )
  {
   free(base);
   return (char *)-1;
  }
 /* Eventuelle logischen Namen ersetzen */
 if ( device )
  {
   /* Laenge ermitteln */
   dlen = strlen(device);
   /* Struktur aufsetzen */
   trn[0].code = LNM$_INDEX;
   trn[0].blen = sizeof(zero);
   trn[0].addr = (char *)&zero;
   trn[0].rlen = 0;
   trn[1].code = LNM$_ATTRIBUTES;
   trn[1].blen = sizeof(attr);
   trn[1].addr = (char *)&attr;
   trn[1].rlen = 0;
   trn[2].code = LNM$_STRING;
   trn[2].blen = sizeof(lbuf)-1;
   trn[2].addr = lbuf;
   trn[2].rlen = &len;
   trn[3].code = trn[3].blen = 0;
   /* Informationen abfragen */
   if ( !(sys$trnlnm_(&inattr,DEFTAB,device,&acmode,trn,sizeof(DEFTAB)-1,dlen)&1) )
    {
     /* Kein logischer Name */
     if ( file == (device+dlen) )
      {
       /* Praktisch unveraendert weitergeben */
       Ffile = 0;
       Fsuff = Fvers = -1;
       lowcase(base,fbuf);
      }
     else
      res = 0;
     /* Fertig */
     free(base);
     return res;
    }
   lbuf[len] = '\0';
   /* Weiter zerlegen, falls noetig */
   if ( !(attr&LNM$M_TERMINAL) )
    {
     /* Rekursiv aufrufen, falls noch nicht alle Ebenen ausgeschoepft */
     if ( level == 9 )
      {
       free(base);
       return NOSTR;
      }
     /* Naechste Ebene aufrufen */
     level++;
     tmp = translate_vms(lbuf);
     level--;
     /* Ergebnis auswerten */
     if ( tmp != fbuf )
      {
       free(base);
       return tmp;
      }
     /* Ergebnis ergaenzen */
     len = strlen(fbuf);
     /* Directoryanfang markieren */
     if ( attr&LNM$M_CONCEALED )
      {
       Fdir = len;
       Ffile = Fsuff = Fvers = -1;
      }  
    }
   else
    {
     /* Ermittelten Wert platzieren */
     Fdir = len;
     Ffile = Fsuff = Fvers = -1;
     strcpy(fbuf,lbuf);
    }
  }
 else
  len = 0;
 /* Ausgabezeiger */
 out = fbuf+len;
 if ( (dir || *file || suff || vers) && len && (out[-1] != '/') ) *out++ = '/';
 /* Directory bearbeiten */
 if ( dir )
  do
   {
    /* Directoryelement ermitteln */
    tmp = dir;
    while ( (ch = *dir++) && (ch != '.') && (ch != ']') && (ch != '>') )
     if ( (ch == '*') || (ch == '%') ) FAIL();
    if ( res != fbuf ) break;
    /* Ist eine Fortsetzung ueberhaupt erlaubt */
    if ( dirflag >= 3 ) FAIL();
    /* Analyse des Directoryelementes */
    if ( (dir-tmp) > 1 )
     {
      /* Normales Element bearbeiten */
      dir[-1] = '\0';
      /* Vaterdirectory */
      if ( *tmp == '-' )
       {
	if ( Fdir < 0 ) Fdir = out-fbuf;
	if ( !dirflag )
	 if ( defID == DANALYZE )
	  defcode |= SDOT;
	 else if ( defID == DMERGE )
	  dircode |= SDOT;
	for ( ; *tmp == '-' ; tmp++ )
	 {
	  strcpy(out,"../");
	  out += 3;
	 }
        if ( *tmp ) FAIL();
       }
      else
       {
	/* Besondere Rolle der 000000 beachten */
	if ( !(cmp = strcmp(tmp,"000000")) )
	 if ( !dirflag && (defID == DMERGE) && (defcode&EDOT) )
	   dircode |= ZDOT;
	 else if ( dirflag != 1 )
	  cmp = 1;
	/* Normale Directory anhaengen */
        if ( cmp )
         {
	  if ( Fdir < 0 ) Fdir = out-fbuf;
	  lowcase(tmp,out);
	  out += dir-tmp;
	  out[-1] = '/';
	 }
       }
      /* Naechstes Element vorbereiten */
      dirflag = (ch == '.') ? 2 : 3;
     }
    else if ( ch != '.' )
     dirflag = (dirflag == 2) ? 1 : 3;
    else if ( !dirflag )
     {
      switch (defID)
       {
        case DANALYZE : defcode |= SDOT;
	 	        break;
        case DMERGE   : dircode |= SDOT;
	  		break;
        default       : strcpy(out,"./");
	  		out += 2;
       }
      dirflag = 2;
     }
    else
     FAIL();
    /* Zeiger auf naechstes Directoryelement posistionieren */
    if ( (ch == ']') || (ch == '>') ) dir++;
   }
  while ( ch );
 /* Kontrolltest */
 if ( *file || suff || vers )
  if ( dirflag && (dirflag != 3) )
   if ( (defID == DANALYZE) && (dirflag == 1) )
    {
     dirflag = 4;
     defcode |= EDOT;
    }
   else if ( (defID == DMERGE) && (dirflag == 1) )
    {
     dirflag = 4;
     dircode |= EDOT;
    }
   else
    res = (char *)-1;
  else
   dirflag = 4;
 else if ( !level && (dirflag == 1) )
  if ( defID == DANALYZE )
   defcode |= EDOT;
  else if ( defID == DMERGE )
   dircode |= EDOT;
 /* Filename bearbeiten */
 if ( res == fbuf )
  for ( ; ch = *file++ ; *out++ = ch )
   {
    if ( Ffile < 0 ) Ffile = out-fbuf;
    if ( (ch == '*') || (ch == '%') ) FAIL();
    if ( (ch >= 'A') && (ch <= 'Z') ) ch += 'a'-'A';
   }
 /* Suffix bearbeiten */
 if ( (res == fbuf) && (suff || vers) )
  {
   if ( Fsuff < 0 ) Fsuff = out-fbuf;
   *out++ = '.';
   if ( suff )
    for ( ; ch = *suff++ ; *out++ = ch )
     {
      if ( (ch == '*') || (ch == '%') ) FAIL();
      if ( (ch >= 'A') && (ch <= 'Z') ) ch += 'a'-'A';
     }
  }
 /* Versionsnummer bearbeiten */
 if ( (res == fbuf) && vers )
  {
   if ( Fvers < 0 ) Fvers = out-fbuf;
   *out++ = '.';
   for ( ; ch = *vers++ ; *out++ = ch )
    if ( (ch < '0') || (ch > '9') ) FAIL();
  }
 /* Name beenden */
 *out = '\0';
 /* Fertig */
 free(base);
 return res;
} 

/*
  Uebersetze eine VAX/VMS Dateiname unter Benutzung eines Defaultnamens in einen
  BOSS/UNIX-Dateinamen. Eventuell benutzte logische Namen werden mit Hilfe des
  LNM umgesetzt.
*/
char *translate_vms_default(vms,def)
char *vms,*def;
{
 static char keep[1024],fbuf[1024];
 char *out,*res,*Ddevice,*Ddir,*Dfile,*Dsuff,*Dvers,*Rdevice,*Rdir,*Rfile,*Rsuff,*Rvers,op;
 int isabs;

 /* Abkuerzen, wenn moeglich */
 if ( !def ) return translate_vms(vms);
 /* Defaultnamen zerlegen */
 dircode = defcode = 0;
 defID = DANALYZE;
 res = translate_vms(def);
 if ( (res != NOSTR) && (res != (char *)-1) )
  {
   /* Absoluter Dateiname ? */
   isabs = (*res == '/');
   /* Defaultzeiger zusammensetzen */
   strcpy(keep,res);
   rearrange(keep,&Ddevice,&Ddir,&Dfile,&Dsuff,&Dvers);
   /* Dateiname zerlegen */
   defID = DMERGE;
   res = translate_vms(vms);
   if ( (res != NOSTR) && (res != (char *)-1) && (dirflag != 5) )
    {
     /* Absoluter Dateiname ? */
     isabs |= (*res == '/');
     /* Ergebnis zusammensetzen */
     rearrange(res,&Rdevice,&Rdir,&Rfile,&Rsuff,&Rvers);
     /* Spezialfall abhandeln */
     if ( (dircode&SDOT) && !Ddir ) Ddir = "./";
     /* Operationsart ermitteln und Fehler abfangen */
     op = translate_vms_config[(dircode&MDOT)+4*(defcode&MDOT)];
     if ( op == 'X' )
      res = (char *)-1;
     else
      {
       /* Dateiname zusammensetzen */
       out = fbuf;
       /* - Device */
       addDir(&out,1,Rdevice ? Rdevice : (Ddevice ? Ddevice : (isabs ? "/" : NOSTR)),0);
       /* - Directory */
       if ( Rdir || Ddir )
	{
	 if ( !Rdir || !Ddir )
	  addDir(&out,out == fbuf,Rdir ? Rdir : Ddir,(Rdir ? dircode : defcode)&SDOT);
	 else
          switch (op)
	   {
	    case 'R' : addDir(&out,out == fbuf,Rdir,dircode&SDOT);
		       addDir(&out,out == fbuf,Ddir,0);
		       break;
	    case 'D' : addDir(&out,out == fbuf,Ddir,defcode&SDOT);
	    default  : addDir(&out,out == fbuf,Rdir,(op != 'D') && (dircode&SDOT));
	   } 
	}
       /* - Dateiname */
       addFile(&out,Rfile ? Rfile : Dfile,0);
       /* - Suffix */
       if ( Rsuff )
	addFile(&out,Rsuff,'.');
       else if ( Dsuff )
	addFile(&out,Dsuff,'.');
       else if ( Rvers || Dvers )
	*out++ = '.';
       /* - Version */
       addFile(&out,Rvers ? Rvers : Dvers,'.');
       /* Fertig */
       *out = '\0';
       res = fbuf;
      }
    }
  }
 /* Aufraeumen */
 defID = DNONE;
 /* Ergebnis melden */
 return res;
}

/*
  Directorynamen anhaengen.
*/
addDir(out,first,dir,dot)
char **out,*dir;
int first,dot;
{
 char *del,*up;

 /* Kontrolltest */
 if ( !(del = dir) ) return;
 up = del+strlen(del);
 /* Anfangszeichen setzen */
 if ( first && (*del != '.') )
  {
   if ( dot ) *out[0]++ = '.';
   *out[0]++ = '/';
  }
 /* Trennzeichen eleminieren */
 while ( *del == '/' ) del++;
 while ( (--up >= del) && (*up == '/') );
 if ( up < del ) return;
 /* Name anhaengen */
 strcpy(out[0],del);
 out[0] += up-del+1;
 /* Endzeichen setzen */
 *out[0]++ = '/';
}

/*
  Dateinamen anhaengen.
*/
addFile(out,file,pref)
char **out,*file,pref;
{
 /* Kontrolltest */
 if ( !file ) return;
 /* Prefix */
 if ( pref ) *out[0]++ = pref;
 /* Name */
 strcpy(out[0],file);
 out[0] += strlen(file);
}

/*
  Name in Kleinschreibung umwandeln.
*/
static lowcase(s1,s2)
char *s1,*s2;
{
 char c;

 do
  {
   c = *s1++;
   if ( (c >= 'A') && (c <= 'Z') ) c += 'a'-'A';
  }
 while ( *s2++ = c );
}

/*
  Zerlegung in Komponenten nach (!) Umsetzung der logischen Namen.
*/
static rearrange(base,device,dir,file,suff,vers)
char *base,**device,**dir,**file,**suff,**vers;
{
 /* Initialisierung */
 device[0] = dir[0] = file[0] = suff[0] = vers[0] = 0;
 /* Device */
 if ( Fdir > 0 ) device[0] = base;
 /* Directory */
 if ( Fdir >= 0 )
  {
   dir[0] = base+Fdir;
   if ( Fdir )
    {
     if ( dir[0][-1] == '/' )
      {
       if ( device[0] == dir[0]-1 ) device[0] = "/";
       dir[0][-1] = '\0';
      }
     if ( dir[0][0] == '/' ) *dir[0]++ = '\0';
    }
  }
 /* Dateiname */
 if ( Ffile >= 0 )
  {
   file[0] = base+Ffile;
   if ( Ffile && (file[0][-1] == '/') ) file[0][-1] = '\0';
  }
 /* Suffix */
 if ( Fsuff >= 0 )
  {
   suff[0] = base+Fsuff;
   *suff[0]++ = '\0';
  }
 /* Version */
 if ( Fvers >= 0 )
  {
   vers[0] = base+Fvers;
   *vers[0]++ = '\0';
  }
 /* Ueberfluessiges eleminieren */
 if ( device[0] && !device[0][0] ) device[0] = 0;
 if ( dir[0] && !dir[0][0] ) dir[0] = 0;
 if ( file[0] && !file[0][0] ) file[0] = 0;
 if ( suff[0] && !suff[0][0] ) suff[0] = 0;
 if ( vers[0] && !vers[0][0] ) vers[0] = 0;
 if ( dir[0] == file[0] ) dir[0] = 0;
}
