#include <time.h>
#include <limits.h>

#include <sys/time.h>
#include <sys/types.h>

#include <saphir/vmsdef.h>

#include <saphir/modules/DATETIME.h>

static struct epcbDATETIME *pcb = 0;

extern struct epcbDATETIME *getpcb();
extern struct tm *localtime();
extern char *parse_error();

#define MILLION		1000000

/*
  Umsetzen einer Uhrzeit im VAX/VMS-Format in das UNIX-Format. 
*/
struct timeval *translate_datetime(tstr)
char *tstr;
{
 static struct timeval res;
 static char tbuf[100];
 struct tm tnow,*pnow;
 struct timeval corr;
 time_t zero = 0;

 /* Konvertieren */ 
 if ( (strlen(tstr)+2) >= sizeof(tbuf) ) return 0;
 if ( *tstr != '"' )
  {
   /* Volle VAX-Notation erlauben */
   strcpy(tbuf,"\"");
   strcpy(tbuf+1,tstr);
   strcat(tbuf,"\"");
   tstr = tbuf;
  }
 /* Parsertabelle suchen */ 
 if ( !pcb && !(pcb = getpcb(pcbDATETIME_module)) ) return 0;
 /* Dateiname auswerten */
 if ( parse(pcb,tstr) ) return 0;
 /* Bezugsadresse ermitteln */
 free(pcb->pcb_tree);
 /* Namensabschluss sicherstellen */
 if ( *pcb->sys_pcb.pcb_line ) return 0;
 /* Das jetzt ermitteln, vor allem auch Charakteristika wie Sommerzeit */
 if ( !(pnow = localtime(&zero)) ) return 0;
 /* Werte uebertragen */
 tnow = *pnow;
 tnow.tm_mday = pcb->pcb_times[1];
 tnow.tm_mon = pcb->pcb_times[2]-1;
 tnow.tm_year = pcb->pcb_times[3]-1900;
 tnow.tm_hour = pcb->pcb_times[4];
 tnow.tm_min = pcb->pcb_times[5];
 tnow.tm_sec = pcb->pcb_times[6];
 /* Umrechnen */
 if ( (res.tv_sec = mktime(&tnow)) == -1 ) return 0;
 if ( (res.tv_usec = frac(pcb->pcb_times+7)) == MILLION )
  {
   res.tv_sec++;
   res.tv_usec = 0;
  }
 /* Eventuell Korrektur mit einer Deltazeit */
 if ( pcb->pcb_times[9] )
  {
   /* Werte uebertragen */
   tnow.tm_mday = pcb->pcb_times[10]+1;
   tnow.tm_mon = 0;
   tnow.tm_year = 70;
   tnow.tm_hour = pcb->pcb_times[11];
   tnow.tm_min = pcb->pcb_times[12];
   tnow.tm_sec = pcb->pcb_times[13];
   /* Umrechnen */
   if ( (corr.tv_sec = mktime(&tnow)) == -1 ) return 0;
   if ( (corr.tv_usec = frac(pcb->pcb_times+14)) == MILLION )
    {
     corr.tv_sec++;
     corr.tv_usec = 0;
    }
   /* Gesamtwert berechnen, Grenzen beachten */
   if ( pcb->pcb_times[9] == '+' )
    {
     /* Summieren */
     res.tv_sec += corr.tv_sec;
     if ( (res.tv_usec += corr.tv_usec) >= MILLION )
      {
       res.tv_sec++;
       res.tv_usec -= MILLION;
      }
    }
   else
    {
     /* Subtrahieren */
     res.tv_sec -= corr.tv_sec;
     if ( (res.tv_usec -= corr.tv_usec) < 0 )
      {
       res.tv_sec--;
       res.tv_usec += MILLION;
      }
    }
   /* Grenzen beachten */
   if ( res.tv_sec < 0 ) return 0;
  }
 /* Fertig */
 return &res;
} 

/*
  Mikrosekunden ermitteln.
*/
static long frac(finfo)
long finfo[2];
{
 long usec;
 int n;
 
 /* Initialer Wert */
 usec = finfo[0];
 /* Stellenzahl korrigieren */
 if ( (n = finfo[1]) > 6 )
  {
   while ( n-- > 7 ) usec /= 10;
   usec = (usec+5)/10; 
  }
 else
  while ( n++ < 6 ) usec *= 10;
 /* Ergebnis melden */
 return usec;
}
