#include <stdio.h>
#include <netdb.h>
#include <mntent.h>

#include <sys/stat.h>
#include <sys/param.h>
#include <sys/sysmacros.h>

#include <netinet/in.h>

extern char *getwd(),*realpath(),*strdup(),*strstr(),*strchr(),*calloc();
static long mnthost(),pmthost();

#define PMTNAME		"/dev/pmt/"
#define PMTTABNAME	"/etc/pmttapetab"

#define MALLOC(t,n)	((t *)calloc(n,sizeof(t)))


/*
  Ermittele den TCP/IP Knoten, zu dessen der angegebenen Dateiname lokal ist.
*/
long getfilehost(name)
char *name;
{
 static char real[MAXPATHLEN],nbuf[MAXPATHLEN];
 char *scan;
 int len;

 /* Parameter testen */
 if ( (*name != '/') || ((len = strlen(name)) >= MAXPATHLEN) ) return -1;
 /* Absoluten Namen umsetzen */
 if ( realpath(name,real) != real )
  {
   /* Letztes Element koennte ein Dateiname sein */
   strcpy(nbuf,name);
   for ( scan = nbuf+len ; *--scan != '/' ; );
   scan[1] = '\0';
   /* Versuchen, den Rest umzusetzen */
   if ( realpath(nbuf,real) != real ) return -1;
  }
 /* Nachsehen, ob es ein Bandgeraet auf einer anderen Maschine ist */
 if ( !memcmp(real,PMTNAME,sizeof(PMTNAME)-1) ) return pmthost(real+sizeof(PMTNAME)-1);
 /* Zur Partition gehoerigen Rechner ermitteln */
 return mnthost(real);
}

static long mnthost(path)
char *path;
{
 static int adir = 0,ndir = 0,done = 0;
 static long *ip = 0,mip = 0;
 static char **dir = 0;
 struct hostent *host;
 struct mntent *ent;
 char **nd,*scan;
 int i,flen,len;
 long *ni,res;
 FILE *mntf;

 /* Eigene TCP/IP Nummer ermitteln */
 if ( !mip ) mip = ntohl(gethostid());
 /* Spezialkommando */
 if ( !path ) return mip;
 /* Datei einlesen */
 if ( !done )
  {
   done = 1;
   /* Datei oeffnen */
   if ( !(mntf = setmntent(MNTTAB,"r")) ) return mip;
   /* Eintraege auslesen */
   while ( ent = getmntent(mntf) )
    if ( !strcmp(ent->mnt_type,MNTTYPE_NFS) && (scan = strchr(ent->mnt_fsname,':')) )
     {
      /* Zugehoerigen Rechner ermitteln */
      *scan = '\0';
      if ( !(host = gethostbyname(ent->mnt_fsname)) || (host->h_length != sizeof(mip)) )
       continue;
      /* Platz fuer einen neuen Eintrag schaffen */
      if ( ndir == adir )
       {
	/* Speicher reservieren */
	if ( !(nd = MALLOC(char *,adir+10)) ) break;
	if ( !(ni = MALLOC(long,adir+10)) )
	 {
	  free(nd);
	  break;
	 }
	/* Alte Daten bei Bedarf kopieren und Speicher freigeben */
	if ( adir )
	 {
	  memmove(nd,dir,adir*sizeof(nd[0]));
	  memmove(ni,ip,adir*sizeof(ip[0]));
	  free(dir);
	  free(ip);
	 }
	/* Variablen aktualisieren */
	dir = nd;
	ip = ni;
	adir += 10;
       }
      /* Eintragen */
      if ( dir[ndir] = strdup(ent->mnt_dir) ) memmove(ip+ndir++,host->h_addr,host->h_length);
     }
   /* Datei schliessen */
   endmntent(mntf);
  }
 /* Name suchen */
 for ( res = mip, flen = 0, i = ndir ; i-- ; )
  if ( ((len = strlen(dir[i])) > flen) && !memcmp(path,dir[i],len) &&
       ((path[len-1] == '/') || !path[len] || (path[len] == '/')) )
   {
    flen = len;
    res = ntohl(ip[i]);
   }
 /* Fertig */
 return res;
}

static long pmthost(path)
char *path;
{
 static int apmt = 0,npmt = 0,done = 0;
 static char **pmt = 0,buf[256];
 static long *ip = 0;
 char **np,*el1,*el2,*end;
 struct hostent *host;
 FILE *pmtf;
 long *ni;
 int i;

 /* Datei einlesen */
 if ( !done )
  {
   done = 1;
   /* Datei oeffnen */
   if ( !(pmtf = fopen(PMTTABNAME,"r")) ) return mnthost((char *)0);
   /* Eintraege auslesen */
   while ( fgets(buf,sizeof(buf),pmtf) )
    if ( buf[0] != '#' )
     {
      /* Erstes Element suchen */
      for ( el1 = buf ; (*el1 == ' ') || (*el1 == '\t') ; el1++ );
      if ( !*el1 ) continue;
      /* Ende des ersten Elementes suchen */
      for ( el2 = el1 ; *el2 && (*el2 != ' ') && (*el2 != '\t') ; el2++ );
      if ( !*el2 ) continue;
      *el2++ = '\0';
      /* Zweites Element suchen */
      for ( ; (*el2 == ' ') || (*el2 == '\t') ; el2++ );
      if ( !*el2 ) continue;
      /* Ende des zweiten Elementes suchen */
      for ( end = el2 ; *end && (*end != ' ') && (*end != '\t') ; end++ );
      if ( !*end ) continue;
      *end++ = '\0';
      if ( !(host = gethostbyname(el2)) || (host->h_length != sizeof(long)) ) continue;
      /* Platz fuer einen neuen Eintrag schaffen */
      if ( npmt == apmt )
       {
	/* Speicher reservieren */
	if ( !(np = MALLOC(char *,apmt+10)) ) break;
	if ( !(ni = MALLOC(long,apmt+10)) )
	 {
	  free(np);
	  break;
	 }
	/* Alte Daten bei Bedarf kopieren und Speicher freigeben */
	if ( apmt )
	 {
	  memmove(np,pmt,apmt*sizeof(np[0]));
	  memmove(ni,ip,apmt*sizeof(ip[0]));
	  free(pmt);
	  free(ip);
	 }
	/* Variablen aktualisieren */
	pmt = np;
	ip = ni;
	apmt += 10;
       }
      /* Eintragen */
      if ( pmt[npmt] = strdup(el1) ) memmove(ip+npmt++,host->h_addr,host->h_length);
     }
   /* Datei schliessen */
   fclose(pmtf);
  }
 /* Name suchen */
 for ( i = npmt ; i-- && strcmp(path,pmt[i]) ; );
 /* Fertig */
 return ((i < 0) ? mnthost((char *)0) : ntohl(ip[i]));
}
