#include "lnmlib.h"

/*
  Logischen Namen suchen.
*/
sys$trnlnm_(attr,tabnam,lognam,acmode,itmlst,tlen,llen)
int *attr,*acmode,tlen,llen;
char *tabnam,*lognam;
struct item_list_3 *itmlst;
{
 char tbuf[LNM$C_TABNAMLEN+1],lbuf[LNM$C_NAMLENGTH+1];
 int res = 0,ix,flags;
 logname *lnm;
 trnlnm_t tl;

 /* Parameter ueberpruefen */
 if ( !tabnam || !lognam ||
      (tlen < 0) || (tlen > LNM$C_TABNAMLEN) || (llen < 0) || (llen > LNM$C_NAMLENGTH) )
  return SS$_BADPARAM;
 /* Struktur aufsetzen */
 memcpy(tbuf,tabnam,tlen);
 memcpy(lbuf,lognam,llen);
 tbuf[tlen] = lbuf[llen] = '\0';
 tl.name = lbuf;
 tl.parent = tbuf;
 tl.pid = getpid();
 tl.acmode = acmode ? *acmode : PSL$C_USER;
 tl.flags = attr ? *attr : 0;
 /* Befehl ausfuehren */
 callLNM(lnm,trnlnm_1,&tl);
 /* Itemliste auswerten */
 if ( lnm->acmode < 0 )
  res = -lnm->acmode;
 else
  for ( ix = 0 ; !res && itmlst && itmlst->code ; itmlst++ )
   switch (itmlst->code)
    {
     case LNM$_ACMODE     : res = copy_int(itmlst,lnm->acmode);
	                    break;
     case LNM$_ATTRIBUTES : flags = lnm->flags&(LNM$M_CONFINE|LNM$M_NO_ALIAS);
                            if ( lnm->info.table == TRUE )
       		             flags |= LNM$M_TABLE;
                            else if ( ix < lnm->WLEN )
		             flags |= LNM$M_EXISTS|lnm->WERT[ix].flags;
	                    res = copy_int(itmlst,flags);
	                    break;
     case LNM$_CHAIN      : itmlst = ((struct item_list_3 *)itmlst->buf)-1;
	                    break;
     case LNM$_INDEX      : memcpy((char *)&ix,itmlst->buf,4);
	                    if ( (ix < 0) || (ix >= MAXWERT) ) res = SS$_BADPARAM;
		            break;
     case LNM$_LENGTH     : if ( (lnm->info.table == TRUE) || (ix >= lnm->WLEN) )
	                     res = copy_int(itmlst,0);
	                    else
		             res = copy_int(itmlst,strlen(lnm->WERT[ix].name));
		            break;
     case LNM$_MAX_INDEX  : if ( lnm->info.table == FALSE )
	                     res = copy_int(itmlst,lnm->WLEN-1);
	                    else
		             res = copy_int(itmlst,-1);
	                    break;
     case LNM$_STRING     : if ( (lnm->info.table == FALSE) && (ix < lnm->WLEN) )
		             res = copy_str(itmlst,lnm->WERT[ix].name);
		            else if ( itmlst->len )
		             *itmlst->len = 0;
		            break;
     case LNM$_TABLE      : res = copy_str(itmlst,lnm->parent);
	                    break;
    }
 /* Aufraeumen und Ergbenis melden */
 clnt_freeres(lnmlibLNM,xdr_logname,lnm);
 return res ? res : SS$_NORMAL;
}

/*
  Integerwert kopieren.
*/
static copy_int(il,val)
struct item_list_3 *il;
int val;
{
 /* Laenge ueberpruefen */
 if ( il->blen < 4 ) return SS$_BUFFEROVF;
 /* Kopieren */
 if ( il->buf ) memcpy(il->buf,(char *)&val,4);
 if ( il->len ) *il->len = 4;
 /* Fertig */
 return 0;
}

/*
  String kopieren
*/
static copy_str(il,val)
struct item_list_3 *il;
char *val;
{
 int len = strlen(val);

 /* Laenge ueberpruefen */
 if ( len > il->blen ) return SS$_BUFFEROVF;
 /* Werte uebertragen */
 if ( il->buf )
  {
   memcpy(il->buf,val,len);
   memset(il->buf+len,' ',il->blen-len);
  }
 if ( il->len ) *il->len = len;
 /* Ergebnis melden */
 return 0; 
}

