#include <sys/un.h>
#include <sys/uio.h>
#include <sys/socket.h>

#include <saphir/vmsdef.h>

#include "symbols.h"

extern char *getenv();
static char *pipename = 0;

#define LEAVE(code)		{ close(comm); return code; }

/*
  Kanal zum Symbolserver oeffnen, Nachricht abschicken und Antwort abwarten.
*/
symbol_operation(op,flags,in1,len1,in2,len2,out,leno,rlen)
int op,*flags,len1,len2,leno,*rlen;
char *in1,*in2,*out;
{
 int iol = 1,len,rflags,scratch,comm,tlen;
 struct symbol_request sreq;
 struct sockaddr_un sun;
 struct iovec io[3];
 char ch;

 /* Environment auslesen */
 if ( !pipename && !(pipename = getenv("DCLSYMBOLS")) ) return LIB$_NOCLI;
 /* Socket oeffnen */
 if ( (comm = socket(AF_UNIX,SOCK_STREAM,0)) == -1 ) return LIB$_FATERRLIB;
 /* Verbindung herstellen */
 sun.sun_family = AF_UNIX;
 strcpy(sun.sun_path,pipename);
 if ( connect(comm,&sun,sizeof(sun.sun_family)+strlen(pipename)) == -1 ) LEAVE(LIB$_FATERRLIB);
 /* Struktur aufbauen */
 sreq.op = op; 
 sreq.flags = flags ? *flags : 0;
 sreq.namelen = in1 ? len1 : -1;
 sreq.vallen = in2 ? len2 : -1;
 /* Ausgabe aufsetzen */
 io[0].iov_base = (char *)&sreq;
 io[0].iov_len = len = sizeof(sreq);
 if ( in1 )
  {
   io[iol].iov_base = in1;
   io[iol].iov_len = len1;
   iol++;
   len += len1;
  }
 if ( in2 )
  {
   io[iol].iov_base = in2;
   io[iol].iov_len = len2;
   iol++;
   len += len2;
  }
 /* Abschicken */
 if ( writev(comm,io,iol) != len ) LEAVE(LIB$_NOCLI);
 /* Antwort einlesen */
 if ( (read(comm,&rflags,sizeof(rflags)) != sizeof(rflags)) ||
      (read(comm,&len,sizeof(len)) != sizeof(len)) ) 
  LEAVE(LIB$_UNECLIERR);
 /* Antwort auswerten */
 if ( len < 0 ) LEAVE(-len);
 if ( flags ) *flags = rflags;
 /* Laenge merken */
 if ( rlen ) *rlen = len;
 /* Rest auslesen */
 if ( !out ) 
  leno = 0;
 else if ( leno > len ) 
  leno = len;
 while ( leno )
  if ( (tlen = read(comm,out,leno)) > 0 )
   {
    /* Zaehler aktualisieren */
    out += tlen;
    leno -= tlen;
    len -= tlen;
   }
  else
   /* Nicht alle Daten erhalten */
   LEAVE(LIB$_FATERRLIB);
 if ( !len ) LEAVE(SS$_NORMAL);
 /* Kanal leeren */
 while ( len-- ) 
  if ( read(comm,&ch,1) != 1 )
   LEAVE(LIB$_FATERRLIB);
 /* Halben Erfolg melden */
 LEAVE(LIB$_STRTRU);
}

