#include <sgtty.h>
#include <stdio.h>

#include <saphir/CLI.h>
#include <saphir/vmsdef.h>

extern char *strstr();

int EDITsize = 256; 	/* 256 Zeichen pro Zeile     */
int EDITcnt = 20;	/* 20 Zeilen plus ein Buffer */
int EDITinsert = 0;	/* INSERT mode ist aus       */
int EDITredo = -1;      /* RECALL aktiv              */

/* Verwaltungsstruktur */
struct EDITcontrol
       {
	int  size;
	int  cnt;
	int  cur;
	char buf[sizeof(int)];
       };

struct EDITcontrol *EDITctrl = 0;

/* Interne Konstanten */
#define	EDIT_COMPLETE	0
#define EDIT_UP		1
#define EDIT_DOWN	2
#define EDIT_EOF	3

#define E_SOL		'\010'
#define E_EOL		'\005'
#define E_CLR1		'\025'
#define E_CLR2		'\030'
#define E_ESC		'\033'
#define E_INSERT	'\001'
#define E_RETYPE	'\022'

#define E_BACK		0x100
#define E_FORW		0x101
#define E_UP		0x102
#define E_DOWN		0x103

#define E_BS		'\010'

#define E_DEL		'\177'
#define E_CR		'\012'
#define E_EOF		'\004'

#define EI_DEL		0
#define EI_EOF		1
#define EI_CR		2

#define lenCHAR(c)	((((c)>=0)&&((c)<' '))?2:1)

/*
  Verwaltungsstruktur erzeugen.
*/
static createEDIT()
{
 char *calloc();
 int sum;

 /* Fertig, falls sie schon existiert */
 if ( EDITctrl ) return 1;
 /* Nach Vorgabe der gloablen Variablen Zeichenbuffer allokieren */
 sum = sizeof(*EDITctrl)-sizeof(int)+(EDITsize+1)*(EDITcnt+1);
 if ( !(EDITctrl = (struct EDITcontrol *)calloc(1,sum)) ) return 0;
 /* Struktur initialisieren */
 EDITctrl->size = EDITsize;
 EDITctrl->cnt = EDITcnt;
 EDITctrl->cur = 0;
 return 1;
}

/*
  Einlesen einer Zeile mit Editieren.
*/
static readEDIT(buf,size,rlen,ctrl)
char *buf,*ctrl;
int size,*rlen;
{
 int ins = EDITinsert,len,pos,esc = 0,il;
 unsigned int ch;
 char *mv1,*mv2;

 /* Etwaigen Inhalt der Zeile anzeigen */
 if ( len = pos = strlen(buf) ) prtEDIT(buf,pos);
 /* Zeichen einlesen */
 while ( (ch = getchar()) != ctrl[EI_EOF] )
  {
   /* Ende einer Zeile */
   if ( ch == ctrl[EI_CR] ) break;
   /* Kontrollsequenzen zusammensetzen */
   if ( esc || (ch == E_ESC) )
    switch (esc++)
     {
      case 1 : if ( (ch != '[') && (ch != 'O') )
		{
		 addEDIT(E_ESC,buf,size,ins,&len,&pos);
		 break;
		}
      case 0 : continue;
      case 2 : switch (ch)
		{
		 case 'A' : ch = E_UP;
			    break; 
		 case 'B' : ch = E_DOWN;
			    break; 
		 case 'C' : ch = E_FORW;
			    break;
		 case 'D' : ch = E_BACK;
			    break;
		 /* Bei nicht definierten Sequenzen Zeichen einfuegen */
		 default  : addEDIT(E_ESC,buf,size,ins,&len,&pos);
			    addEDIT('[',buf,size,ins,&len,&pos);
		}
     }
   esc = 0;
   /* Auswerten und nach Zeichen verzweigen */
   if ( ch != ctrl[EI_DEL] )
    switch (ch)
     {
      /* Zeile muss geloescht werden */
      case E_UP     :
      case E_DOWN   :
      case E_CLR1   :
      case E_CLR2   : prtCHAR(lenEDIT(buf,pos),E_BS);
	 	      il = lenEDIT(buf,len);
		      prtCHAR(il,' ');
		      prtCHAR(il,E_BS);
		      if ( ch == E_UP ) return EDIT_UP;
		      if ( ch == E_DOWN ) return EDIT_DOWN;
		      len = pos = 0;
		      break;	
      /* An den Anfang der Zeile */
      case E_SOL    : prtCHAR(lenEDIT(buf,pos),E_BS);
		      pos = 0;
		      break;
      /* Zeile vollstaendig neu ausgeben */
      case E_RETYPE : prtCHAR(lenEDIT(buf,pos),E_BS);
		      pos = 0;
      /* Ans Ende der Zeile */
      case E_EOL    : prtEDIT(buf+pos,len-pos);
		      pos = len;
		      break;
      /* Cursor eine Stelle nach rechts */
      case E_FORW   : if ( pos == len ) break;
		      prtEDIT(buf+pos,1);
		      pos++;
		      break;
      /* Cursor eine Stelle nach links */
      case E_BACK   : if ( !pos ) break;
		      pos--;
		      prtCHAR(lenCHAR(buf[pos]),E_BS);
		      break;
      /* INSERT mode umschalten */
      case E_INSERT : ins = 1-ins;
		      break;		
      /* Zeichen einfuegen */
      default       : addEDIT(ch,buf,size,ins,&len,&pos);
     }
   else if ( pos )
    {
     /* Zeichen loeschen */
     mv1 = buf+pos;
     mv2 = mv1-1;
     prtCHAR(il = lenCHAR(*mv2),E_BS);
     prtEDIT(mv1,len-pos);
     prtCHAR(il,' ');
     prtCHAR(len-pos+il,E_BS);
     pos--;
     len--;
     for ( il = len-pos ; il-- > 0 ; *mv2++ = *mv1++ );
    }
  }
 /* Zeile beenden und Ergebnis melden */
 prtEDIT(buf+pos,len-pos);
 putchar('\n'); 
 buf[len] = '\0';
 if ( rlen ) *rlen = len;
 return (ch == ctrl[EI_EOF]) ? EDIT_EOF : EDIT_COMPLETE;
}

/*
  Ausgabelaenge berechnen.
*/
static lenEDIT(buf,len)
char *buf;
int len;
{
 char ch;
 int all = len;

 /* Kontrollsequenzen werden in der Form ^X ausgegeben */
 while ( len-- > 0 ) 
  if ( ((ch = *buf++) >= 0) && (ch < ' ') )
   all++;
 return all;
}

/*
  Text ausgeben, Kontrollzeichen markieren.
*/
static prtEDIT(buf,len)
char *buf;
int len;
{
 int ch;
 
 if ( len <= 0 ) return;
 /* Falls keine Kontrollzeichen, Text als ganzes ausgeben */
 if ( len == lenEDIT(buf,len) )
  fwrite(buf,1,len,stdout);
 else
  /* Jedes Zeichen muss einzeln bearbeitet werden */
  while ( len-- > 0 )
   {
    if ( ((ch = *buf++) >= 0) && (ch < ' ') )
     {
      putchar('^');
      ch += '@';
     }
    putchar(ch);
   }  
 /* Buffer leeren */
 fflush(stdout);
}

/*
  Ein Zeichen mehrmals ausgeben.
*/
static prtCHAR(n,c)
int n,c;
{
 char backs[256];
 int cnt = 0;

 /* Schnelle Ausgabe ueber Zwischenspeicher */
 memset(backs,c,sizeof(backs));
 while ( (n -= cnt) > 0 )
  {
   if ( (cnt = n) > sizeof(backs) ) cnt = sizeof(backs);
   fwrite(backs,1,cnt,stdout);
  }
 /* Buffer leeren */
 if ( cnt ) fflush(stdout);
}

/*
  Zeichen eintragen und eventuell veraenderten Text ausgeben.
*/
static addEDIT(ch,buf,size,ins,len,pos)
char *buf;
int ch,size,ins,*len,*pos;
{
 char *mv1,*mv2;
 int il1,il2,il,p = *pos,l = *len;

 /* INSERT mode anpassen */
 if ( p == l ) ins = 1;
 /* Ausgabezeichenlaengen berechnen */
 il1 = lenCHAR(buf[p]);
 il2 = lenCHAR(ch);
 if ( !ins )
  {
   /* OVERWRITE mode */
   buf[p] = ch;
   /* Zeichen einfach ersetzen */
   if ( !(il = (il1-il2)) )
    prtEDIT(buf+p,1);
   else
    {
     /* Ausgabe korriegieren */
     prtEDIT(buf+p,l-p);
     if ( il < 0 )
      il = 0;
     else
      prtCHAR(il,' ');
     prtCHAR(lenEDIT(buf+p+1,l-p-1)+il,E_BS);
    }
   p++;
  }
 else if ( l < size )
  {
   /* INSERT mode */
   mv1 = buf+l;
   mv2 = mv1-1;  
   for ( il = l-p ; il-- > 0 ; *mv1-- = *mv2-- );
   buf[p] = ch;
   /* Neue Zeichenkette ausgeben */
   prtEDIT(buf+p,l-p+1);
   p++;
   l++;
   prtCHAR(lenEDIT(buf+p,l-p),E_BS); 
  } 
 /* Werte uebertragen */
 *pos = p;
 *len = l;
}

/*
  Einlesen einer Zeile unter Zurhilfename des globalen Zeilenbuffers EDITctrl.
*/
#define BUF(n)		(EDITctrl->buf+(n)*(EDITctrl->size+1))

static readLINE(res,rlen,len,keys)
char *res,*keys;
int rlen,*len;
{
 int pos,mlen,goon,size;
 char *buf;

 /* Kontrollstruktur erzeugen, falls noetig */
 if ( !createEDIT() ) return 0;
 /* Initialisierung des Zeileninhaltes */
 if ( (size = EDITctrl->size) > rlen ) size = rlen;
 *(buf = BUF(EDITctrl->cnt)) = '\0';
 /* Zeile einlesen */
 for ( pos = EDITctrl->cur ; goon = 1 ; )
  {
   /* RECALL bearbeiten */
   if ( EDITredo >= 0 )
    {
     pos = EDITredo;
     EDITredo = -1;
    }
   else
    /* Einzelne Eingabezeile entgegennehmen */
    switch (readEDIT(buf,size,&mlen,keys))
     {
      /* Andere Eingabezeilen zurueckrufen */
      case EDIT_UP       : pos += EDITctrl->cnt-1;
			   break;
      case EDIT_DOWN     : pos++;
			   break;
      /* Eingabezeile beendet */
      case EDIT_EOF      : goon = 0;
      case EDIT_COMPLETE : pos = (EDITctrl->cur+EDITctrl->cnt-1)%EDITctrl->cnt;
			   /* Bei Veraenderung eintragen */
			   if ( strcmp(buf,BUF(pos)) )
			    {
			     strcpy(BUF(EDITctrl->cur),buf);
			     EDITctrl->cur = (EDITctrl->cur+1)%EDITctrl->cnt; 
 			    }
			   /* Ergebnisfeld fuellen */
			   bcopy(buf,res,mlen);
			   if ( len ) *len = mlen;
			   /* Resultat uebertragen */
			   return goon ? CLI$_NORMAL : CLI$_EOF;
     }
   /* Andere Zeile in den aktuellen Buffer schreiben */
   pos %= EDITctrl->cnt;
   strcpy(buf,BUF(pos));
  }
}

/*
  Zeile mit Line-Editing und Recall einlesen. Unter UNIX muessen einige
  Terminalcharakteristika umgeschaltet werden.
*/
static struct sgttyb info;
static int loaded = 0,valid = 0;

lib$get_input_(res,pro,len,rlen,plen)
char *res,*pro;
int *len,rlen,plen;
{
 int cleanupLIB(),code,olen;
 struct sgttyb new;
 struct tchars tk;
 char keys[3];

 /* Nur bei Terminals */
 if ( isatty(0) )
  {
   /* EXIT-Handler aufsetzen */
   if ( !loaded )
    {
     atexit(cleanupLIB);
     loaded = 1;
    }
   keys[EI_DEL] = E_DEL;
   keys[EI_CR] = E_CR;
   keys[EI_EOF] = E_EOF;
   /* Charakteristika abfragen und gewuenschte Werte setzen */
   if ( ioctl(0,TIOCGETP,&info) != -1 )
    {
     valid = 1;
     new = info;
     new.sg_flags |= CBREAK;
     new.sg_flags &= ~ECHO;
     ioctl(0,TIOCSETN,&new);
     if ( info.sg_erase ) keys[EI_DEL] = info.sg_erase;
    }
   /* Kontrollzeichen auslesen */
   if ( ioctl(0,TIOCGETC,&tk) != -1 )
    {
     if ( tk.t_brkc > 0 ) keys[EI_CR] = tk.t_brkc;
     if ( tk.t_eofc > 0 ) keys[EI_EOF] = tk.t_eofc;
    }
   /* Ergebnisfeld loeschen */
   memset(res,' ',rlen);
   if ( len ) *len = 0;
   /* Prompt ausgeben, falls vorhanden */
   if ( pro )
    {
     fwrite(pro,1,plen,stdout);
     fflush(stdout);
    }
   /* Zeile einlesen */
   *res = '\0';
   code = readLINE(res,rlen,len,keys);
   /* Aufrauemen und Fehlercode melden */
   cleanupLIB();
  }
 /* Eingabe aus einer Datei */
 else if ( fgets(res,rlen,stdin) )
  {
   /* Umwandeln in FORTRAN Konvention */
   if ( ((olen = strlen(res)) > 0) && (res[olen-1] == '\n') ) olen--;
   memset(res+olen,' ',rlen-olen);
   if ( len ) *len = olen;
   /* Ergebnis melden */
   code = CLI$_NORMAL;
  }
 else
  code = CLI$_EOF;
 return code;
}

/*
  Terminalcharakteristika zuruecksetzen.
*/
static cleanupLIB()
{
 if ( valid ) ioctl(0,TIOCSETN,&info);
 valid = 0;
}
