#include <sgtty.h>
#include <stdio.h>

#include <sys/dg_process_info.h>

#include <saphir/CLI.h>
#include <saphir/vmsdef.h>

extern char *strstr();

/*
  Einlesen der Commandozeile.
*/
lib$get_foreign_(res,pro,len,flags,rlen,plen)
char *res,*pro;
int *len,*flags,rlen,plen;
{
 static char cmd[_PT_COMM_SIZE];
 int need = 0,stat,clen;

 /* Parameter testen */
 if ( !res ) return SS$_BADPARAM;
 /* Zeile einlesen */
 if ( flags && (*flags&1) )
  need = 1;
 else
  need = (!getinfo(cmd) || !(clen = strlen(cmd)));
 /* Ausgabeparameter setzen */
 memset(res,rlen,' ');
 if ( len ) *len = 0;
 if ( flags ) *flags |= 1;
 /* Eventuell nachhelfen */
 if ( need )
  {
   if ( !pro ) return SS$_NORMAL;
   if ( !((stat = lib$get_input_(cmd,pro,&clen,sizeof(cmd),plen))&1) ) return stat;
  }
 /* Zeile kopieren */
 if ( clen > rlen ) clen = rlen;
 memcpy(res,cmd,clen);
 while ( (clen > 0) && ((cmd[clen-1] == ' ') || (cmd[clen-1] == '\t')) ) clen--;
 /* Ergebnis melden */
 if ( len ) *len = clen;
 return SS$_NORMAL;
}

/*
  Processinformation abfragen.
*/
static getinfo(cmd)
char *cmd;
{
 struct dg_process_info pi;
 int len1,len2;
 char *start;
 long key;

 /* Aufruf durchfuehren */ 
 key = DG_PROCESS_INFO_INITIAL_KEY;
 if ( dg_process_info(DG_PROCESS_INFO_SELECTOR_PID,getpid(),DG_PROCESS_INFO_CMD_NAME_ONLY,
		      &key,&pi,DG_PROCESS_INFO_VERSION_0) != 1 )
  return 0;
 len1 = strlen(pi.cmd);
 strcpy(cmd,pi.cmd);
 /* Aufruf durchfuehren */ 
 key = DG_PROCESS_INFO_INITIAL_KEY;
 if ( dg_process_info(DG_PROCESS_INFO_SELECTOR_PID,getpid(),DG_PROCESS_INFO_CMD_NAME_AND_ARGS,
		      &key,&pi,DG_PROCESS_INFO_VERSION_0) != 1 )
  return 0;
 len2 = strlen(pi.cmd);
 /* Laenge validieren */
 if ( (len2 < len1) || !(start = strstr(pi.cmd,cmd)) ) return 0;
 /* Genutzte Laenge ermitteln */
 start += len1;
 while ( (*start == ' ') || (*start == '\t') ) start++;
 /* Daten uebertragen */
 strcpy(cmd,start);
 return 1;
}
