#include "lnmlib.h"

/*
  Erzeuge eine Tabelle logischer Namen.
*/
sys$crelnt_(attr,resnam,reslen,quota,promsk,tabnam,partab,acmode,trlen,ttlen,tplen)
int *attr,*reslen,*quota,*promsk,*acmode,trlen,ttlen,tplen;
char *resnam,*tabnam,*partab;
{
 char tbuf[LNM$C_TABNAMLEN+1],pbuf[LNM$C_TABNAMLEN+1];
 int rlen = 0,tlen = 0,plen = 0,res;
 logname *lnt;
 crelnt_t cl;

 /* Parameter auslesen */
 if ( !partab ) return SS$_BADPARAM;
 if ( resnam )
  {
   rlen = trlen;
   if ( tabnam )
    {
     tlen = ttlen;
     plen = tplen;
    }
   else
    plen = ttlen;
  }
 else if ( tabnam )
  {
   tlen = trlen;
   plen = ttlen;
  }
 else
  plen = trlen;
 if ( (tlen < 0) || (tlen > LNM$C_TABNAMLEN) || (plen < 0) || (plen > LNM$C_TABNAMLEN) )
  return SS$_BADPARAM;
 /* Definitionsstruktur fuellen */
 memcpy(tbuf,tabnam,tlen);
 memcpy(pbuf,partab,plen);
 tbuf[tlen] = pbuf[plen] = '\0';
 cl.name = tbuf;
 cl.parent = pbuf;
 cl.pid = getpid();
 cl.flags = attr ? *attr : 0;
 cl.acmode = acmode ? *acmode : PSL$C_SUPER;
 cl.quota = quota ? *quota : -1;
 cl.prot = promsk ? *promsk : -1;
 /* Definition durchfuehren */
 callLNM(lnt,crelnt_1,&cl);
 /* Ergebnis auswerten */
 if ( lnt->acmode < 0 )
  res = -lnt->acmode;
 else
  {
   res = SS$_LNMCREATED;
   /* Tabellenname auswerten */
   tlen = strlen(lnt->name);
   if ( resnam )
    {
     if ( rlen < tlen )
      res = SS$_RESULTOVF;
     else
      {
       memcpy(resnam,lnt->name,tlen);
       memset(resnam+tlen,' ',rlen-tlen);
      }
    }
   if ( reslen ) *reslen = tlen;
   /* Ergebniswert korrigieren */
   if ( res == SS$_LNMCREATED )
    if ( lnt->flags&LNM$M_EXISTS )
     res = SS$_NORMAL;
    else if ( lnt->flags&LNM$M_SUPERSEDE )
     res = SS$_SUPERSEDE;
  }
 /* Aufraeumen und Ergebnis melden */
 clnt_freeres(lnmlibLNM,xdr_logname,lnt);
 return res;
}
