#include "lnmlib.h"

/*
  Erzeuge einen logischen Namen.
*/
sys$crelnm_(attr,tabnam,lognam,acmode,itmlst,tlen,llen)
int *attr,*acmode,tlen,llen;
char *tabnam,*lognam;
struct item_list_3 *itmlst;
{
 char tbuf[LNM$C_TABNAMLEN+1],nbuf[LNM$C_NAMLENGTH+1],wbuf[MAXWERT][LNM$C_NAMLENGTH+1];
 struct item_list_3 *anstab = 0;
 equiv_t wert[MAXWERT];
 int flags = 0,res;
 logname *lnm;
 crelnm_t cl;

 /* Parameterueberpruefung */
 if ( !tabnam || !lognam ||
      (tlen < 0) || (tlen > LNM$C_TABNAMLEN) ||
      (llen < 0) || (llen > LNM$C_NAMLENGTH) )
  return SS$_BADPARAM;
 /* Struktur aufsetzen */
 memcpy(tbuf,tabnam,tlen);
 memcpy(nbuf,lognam,llen);
 tbuf[tlen] = nbuf[llen] = '\0';
 cl.name = nbuf;
 cl.pid = getpid();
 cl.flags = attr ? *attr : 0;
 cl.acmode = acmode ? *acmode : PSL$C_SUPER;
 cl.parent = tbuf;
 cl.names.names_len = 0;
 cl.names.names_val = wert;
 /* Itemliste durchgehen */
 for ( ; itmlst && itmlst->code ; itmlst++ )
  switch (itmlst->code)
   {
    case LNM$_ATTRIBUTES : memcpy((char *)&flags,itmlst->buf,sizeof(flags));
                           break;
    case LNM$_CHAIN      : itmlst = ((struct item_list_3 *)itmlst->buf)-1;
                           break;
    case LNM$_STRING     : if ( cl.names.names_len == MAXWERT ) return SS$_BADPARAM;
                           if ( (itmlst->blen < 0) || (itmlst->blen > LNM$C_NAMLENGTH) )
			    return SS$_BADPARAM;
                           memcpy(wbuf[cl.names.names_len],itmlst->buf,itmlst->blen);
                           wbuf[cl.names.names_len][itmlst->blen] = '\0';
                           wert[cl.names.names_len].name = wbuf[cl.names.names_len];
                           wert[cl.names.names_len++].flags = flags;
                           break;
    case LNM$_TABLE      : anstab = itmlst;
                           break;
    default              : return SS$_BADPARAM;
   }
 /* Aufruf durchfuehren */
 callLNM(lnm,crelnm_1,&cl);
 /* Ergebnis auswerten */
 if ( lnm->acmode < 0 )
  res = -lnm->acmode;
 else
  {
   res = 0;
   /* Tabellenname uebertragen, falls noetig */
   if ( anstab ) res = copy_str(anstab,lnm->parent);
   if ( !res && (lnm->flags&LNM$M_SUPERSEDE) ) res = SS$_SUPERSEDE;
  }
 /* Aufraeumen und Ergebnis melden */
 clnt_freeres(lnmlibLNM,xdr_logname,lnm); 
 return res ? res : SS$_NORMAL;
}

/*
  String kopieren
*/
static copy_str(il,val)
struct item_list_3 *il;
char *val;
{
 int len = strlen(val);

 /* Laenge ueberpruefen */
 if ( len > il->blen ) return SS$_BUFFEROVF;
 /* Werte uebertragen */
 if ( il->buf )
  {
   memcpy(il->buf,val,len);
   memset(il->buf+len,' ',il->blen-len);
  }
 if ( il->len ) *il->len = len;
 /* Ergebnis melden */
 return 0; 
}

