#include "tablib.h"

char *malloc();
static long IDcnt = 0;

struct tl_table *tl_create(elsize,cmp)
int elsize;
int (*cmp)();
{
 struct tl_table *ntab = 0;

 if ( (elsize >= sizeof(struct tl_node)) &&
      (ntab = (struct tl_table *)malloc(sizeof(struct tl_table))) )
  {
   ntab->entries = 0;
   ntab->ents = 0;
   ntab->bits = 3;
   ntab->size = elsize;
   ntab->cmp = cmp;
  }
 return ntab;
}

void tl_destroy(tab)
struct tl_table *tab;
{
 free(tab->entries);
 free(tab);
}

struct tl_node *tl_byname(tab,name)
struct tl_table *tab;
char *name;
{
 int ix;

 for ( ix = tab->ents ; ix-- ; )
  if ( tab->entries[ix] && !(*tab->cmp)(tab->entries[ix]->name,name) )
   return tab->entries[ix];
 return 0;
}

struct tl_node *tl_byID(tab,ID)
struct tl_table *tab;
int ID;
{
 int ix;

 ix = ID&((1L<<((ID>>27)&31))-1);
 if ( (ix < tab->ents) && tab->entries[ix] && (tab->entries[ix]->ID == ID) )
  return tab->entries[ix];
 return 0;
}

void tl_remove(tab,node)
struct tl_table *tab;
struct tl_node *node;
{
 int ix;

 if ( node ) 
  for ( ix = tab->ents ; ix-- ; )
   if ( tab->entries[ix] == node )
    {
     free(node->name);
     free(node);
     tab->entries[ix] = 0;
     return;
    } 
}

struct tl_node *tl_add(tab,name)
struct tl_table *tab;
char *name;
{
 struct tl_node *nn = 0,**narr;
 int n,l = strlen(name)+1,nc;
 char *nbuf;

 for ( n = tab->ents ; n-- && tab->entries[n] ; );
 if ( n < 0 )
  {
   nc = (n = tab->ents) ? n*2 : 16;
   if ( !(narr = (struct tl_node **)malloc(nc*sizeof(struct tl_node *))) )
    return 0;
   if ( tab->entries )
    {
     bcopy(tab->entries,narr,n*sizeof(struct tl_node *));
     free(tab->entries);
    }
   bzero(narr+n,(nc-n)*sizeof(struct tl_node *));
   tab->entries = narr;
   tab->ents = nc;
   tab->bits++;
  }
 if ( nbuf = malloc(l) )
  if ( nn = (struct tl_node *)malloc(tab->size) )
   {
    strcpy(nbuf,name);
    nn->ID = (tab->bits<<27)|((++IDcnt&((1L<<(27-tab->bits))-1))<<tab->bits)|n;
    nn->name = nbuf;
    tab->entries[n] = nn;
   }
  else
   free(nbuf);
 return nn;
}

