#define VIPTYPE		0x5650

#define HEADERSIZE	64
#define MAILMAX	    	1450		  
#define MAILMAXF        (MAILMAX&~3)	

#define NM_COM		'SCOM'		

#ifndef VD_MAXBOX
#define VD_MAXBOX	40		
#endif

#ifndef VD_MAXXID
#define	VD_MAXXID	20		
#endif

#define	NETXID		-1
#define IOCXID		0

typedef short MINT[2];

#define EXBIT		(1<<4)
#define WRBIT		(1<<5)
#define RDBIT		(1<<6)
#define ERBIT		(1<<7)
#define FIBIT		(1<<11)
#define	NRBIT		(1<<12)
#define FRBIT		(1<<13)
#define RYBIT		(1<<14)
#define SEBIT		(1<<15)

typedef struct mailbox
        { 
         short mbrnet[3];		  
         short mbtnet[3];		  
         short mbtype;			  
         short mbcode;			  
         short mbstatus;		  
         short mbnum;			
         int   mblink;			
         int   mbres;			
	 int   mbrxid;		        
         int   mbscom;		        
         int   mbsxid;		        
         int   mbicom;		        
         int   mbixid;			
         int   mbfid;			
         short mbexpd;			
         MINT  mbsaddr;			
         MINT  mbaddr;			
         short mblen;		        
         char  mbdata[MAILMAX];		
	} MAILBOX;

typedef struct accesslist
	{
	 short	addr[3];		
	 MINT	com;			
	 MINT	xid;			
	 short	res;			
	} ACCESSLIST;

#define IOC$DEFNAME		10
#define IOC$GETNAME		11
#define IOC$DELNAME		12
#define IOC$GETADDR		13
#define IOC$DEFPROG		14
#define IOC$GETPROG		15
#define IOC$DELPROG		16
#define IOC$DEFTASK		17
#define IOC$GETTASK		18
#define IOC$DELTASK		19
#define IOC$REQUEST		22
#define IOC$GETTIME		23
#define IOC$SETTIME		24
#define IOC$RESET		25
#define IOC$DELADDR		26

#define FOS$OPEN		0
#define FOS$CLOSE		1
#define FOS$FREAD		2
#define FOS$UREAD		3
#define FOS$FWRITE		4
#define FOS$UWRITE		5
#define FOS$DELETE		6
#define FOS$RENAME		7
#define FOS$STRUCT		8
#define FOS$CTRL		9
#define FOS$SERVER		10
#define FOS$FAO			11

#ifndef DRIVER
extern struct vaxmhs
       {
        int		freelist;
	int		xids[VD_MAXXID];
        MAILBOX		vd_boxes[VD_MAXBOX];
        short		boxcnt;
        int		iocxid;
        int		netxid;
        short		paddr[3];
        short		running;
        int		sosversion;
        short		experiment;
        int		sessions;
        short		vm_end;
       } vaxmhs_data;
#endif

#define EVENT$SAPHIR	    10505

#define EVB$OK		0
#define EVB$STOP	30
#define EVB$START	31
#define EVB$FLUSH	32
#define EVB$BOOK	33
#define EVB$RELEASE	34
#define EVB$SETMAX	35
#define EVB$STATUS	36
#define EVB$LOAD	37
#define EVB$RUNSTART    38
#define EVB$RUNSTOP	39
#define EVB$ZERO	40
#define EVB$SUSPEND	41
#define EVB$RESUME	42
#define EVB$TRIGGER	43
#define EVB$TOSTART	44
#define EVB$TOSTOP	45
#define EVB$SETBIT	46
#define EVB$CLRBIT	47
#define EVB$CLRALL	48
#define EVB$SETMESS	49

#define	EVD$ALLOCATE	40
#define EVD$GETEVENT	41
#define EVD$DEALLOCATE	42
#define EVD$FLUSH	43
#define EVD$STATUS	44

#define EVD$SIMPLE	0
#define EVD$EXCLUSIVE	1
#define EVD$SAMPLEALL	2

#define EVS$STOP	50
#define EVS$START	51
#define EVS$STATUS	52
#define EVS$SET	        53

#define DAT$EVENT	1000
#define DAT$COMMENT	1001
#define DAT$PARAMETER	1002

struct EventHeader
       {
        unsigned short	evlen;
	short		evdid;
	unsigned short	evhdr;
        short		evtyp;
	unsigned short	evrun;
	unsigned short	evnum;
	unsigned char	evclk[8];
	long		evtrg;
#define evhtrg	evtrg[0]
#define evstrg	evtrg[1]
	unsigned short	evptr[16];
	long		everr;
	short		evpar;
	short		evrid;
       };

#define HDR		sizeof(struct EventHeader)

#define ER$DISTRIBUTOR	31
#define ER$OVERFLOW	30
#define ER$DUPLICATE	29
#define ER$NOMAIL	28
#define ER$RESYNC	27
#define ER$SOFTTRIG	26
#define ER$PARAMETER	17
#define PAR$REQUEST	0
#define PAR$DATA	1
#define ER$RUN		16
#define RUN$STOP	0
#define RUN$START	1
#define RUN$DONE	2
#define RUN$COMMENT	3
#define RUN$ABORTSTART	4
#define RUN$ABORTSTOP	5

#define EQ$TRIGGER	0x0001
#define EQ$TAGGING	0x0002
#define EQ$TOF		0x0004
#define EQ$AECHZ	0x0008
#define EQ$CDC		0x0010
#define EQ$PDC		0x0020
#define EQ$FDC		0x0040
#define EQ$EMC		0x0080

/*
  FORTRAN Schnittstelle
*/
#define VM_ERROR	vm_error_
#define VMEINI		vmeini_
#define VMEFORK		vmefork_
#define ILOCL		ilocl_
#define SNDMAIL		sndmail_
#define VMEOPT		vmeopt_
#define VMEOPN		vmeopn_
#define VMECLO		vmeclo_
#define VMEINP		vmeinp_
#define VMEOUT		vmeout_
#define VMEBIN		vmebin_
#define VMEBOU		vmebou_
#define	VMESTRUCT	vmestruct_
#define VMEDELETE	vmedelete_
#define VMERENAME	vmerename_
#define VMEDEF		vmedef_
#define VMEGET		vmeget_
#define VMELOG		vmelog_
#define VMEDEL		vmedel_
#define VMEDLOG		vmedlog_
#define TIMEGET		timeget_
#define UNLOAD		unload_
#define NOXID		noxid_
#define IADDMB		iaddmb_
#define IGETMB		igetmb_
#define IIOCMB		iiocmb_
#define ISENDMB		isendmb_
#define ICALCMB		icalcmb_
#define	IREADYMB	ireadymb_
#define IGENX		igenx_
#define IDELETEX	ideletex_
#define IREQX		ireqx_

#define WORD(s,d)	bcopy(s,d,2)
#define LONG(s,d)	bcopy(s,d,4)
#define QUAD(s,d)	bcopy(s,d,8)
#define SWORD		WORD
#define SLONG		LONG
#define SREAL		LONG
#define VREAL		LONG
#define SWARR(s,d,l)	bcopy(s,d,2*(*(l)))
#define SLARR(s,d,l)	bcopy(s,d,4*(*(l)))		

/*
  Treiberbefehle und Antworten
*/
#define SOS_BIND		(('1'<<8)|1)
#define SOS_UNBIND		(('2'<<8)|1)
#define SOS_REQUEST		(('3'<<8)|1)
