#!/usr/bin/csh

#
# Befehl mit Abfrage auf Fehler ausfuehren
#
alias check  '\!* ; if ( $status != 0 ) exit $status'
alias action 'echo "+++" \!*'
alias error  'echo "***" \!*'

#
# Umgebung
#
set nonomatch
set path = (. $path)

#
# Defaults setzen
#
if ( ! $?BINDIR ) then
  set BINDIR = /usr/bin
endif
if ( ! $?LIBDIR ) then
  set LIBDIR = /usr/lib
endif
if ( ! $?INCDIR ) then
  set INCDIR = /usr/include
endif

if ( ($#argv >= 1) && ("$1" != "") ) then
  set DIRDEF = "$1"
else if ( ! $?DIRDEF ) then
  set DIRDEF = "saphir"
endif
if ( ($#argv >= 2) && ("$2" != "") ) then
  set MHSDIR = "$2"
else if ( ! $?MHSDIR ) then
  set MHSDIR = "/usr/mhs"
endif
if ( ($#argv >= 3) && ("$3" != "") ) then
  set DEVLIB = "$3"
else if ( ! $?DEVLIB ) then
  set DEVLIB = "/usr/src/uts/aviion/lb/boss.a"
endif
  
#
# mhs.csh [(DIRDEF | "") [(MHSDIR|"") [DEVLIB]]]
#
# DIRDEF ist der Projektname. Er darf nur Buchstaben, Zahlen und _
# enthalten
#
if ( "$DIRDEF" == "" ) then
  error no project name given 
#
# Kurze Erklaerung
#
USAGE:
  cat << EOF
***  
***  
***  USAGE: $0 [(DIRDEF | "") [(MHSDIR|"") [DEVLIB]]]
***  
***    DIRDEF  is the name of the project (saphir)
***    MHSDIR  is the root of all executables (/usr/mhs)
***    DEVLIB  is the library for the driver object code
***            (/usr/src/uts/aviion/lb/boss.a)
***  
***  
EOF
  exit 1
endif
echo "$DIRDEF" | grep > /dev/null '[^A-Za-z0-9_]'
if ( $status == 0 ) then
  error project name '"'"$DIRDEF"'"' must be built from A-Za-z0-9_
  goto USAGE
endif

#
# Informationen anzeigen
#
set LIBDIR1 = "$INCDIR"/"$DIRDEF"
set OBJLIB = "$LIBDIR"/lib"$DIRDEF".a
set MHSLIB = "$LIBDIR"/libmhs.a
cat << EOF
+++
+++  directory for executables      =   $BINDIR
+++  directory for includes         =   $INCDIR
+++  directory for libraries        =   $LIBDIR
+++
+++  project include directory      =   $LIBDIR1
+++  project object library         =   $OBJLIB
+++  SOS mail handling directory    =   $MHSDIR
+++  SOS mail handling library      =   $MHSLIB
+++
+++  driver object library          =   $DEVLIB
+++
EOF

#
# Systemdirectories suchen
#
if ( ! -d "$BINDIR" ) then
  error directory "$BINDIR" for executable does not exist
  exit 1
endif
if ( ! -d "$INCDIR" ) then
  error directory "$INCDIR" for includes does not exist
  exit 1
endif
if ( ! -d "$LIBDIR" ) then
  error directory "$LIBDIR" for libraries does not exist
  exit 1
endif

#
# Systemdirectories erzeugen
#
if ( ! -d "$LIBDIR1" ) then
  action creating "$LIBDIR1"
  check mkdir "$LIBDIR1"
endif
if ( ! -d "$MHSDIR" ) then
  action creating "$MHSDIR"
  check mkdir "$MHSDIR"
endif

#
# Aufrauemen
#
set CLEAN="*.o ioc bcon"
action cleaning up
rm -f $CLEAN

#
# Headerdatei kopieren
#
action copying header files
check cp vaxmhs_data.h "$LIBDIR1"

#
# Library erzeugen
#
action creating mail handling library
check make lib
action copying objects to library
check ar rv "$MHSLIB" *.o

#
# Treiber erzeugen
#
action creating mail handling driver 
action ignore five multi-character character constant warnings
check make -f MakeDriver
action copying object to library
check ar rv "$DEVLIB" sos_driver.o

#
# Utilities erzeugen
#
action creating executables
check make ioc bcon OBJLIB="$MHSLIB"
action copying executables
check cp ioc bcon "$MHSDIR"

#
# Aufraeumen
#
action cleaning up
rm -f $CLEAN

#
# Fertig
#
action SOS mail handling system installation complete

