#include "vaxmhs_subs.h"

/*
  Mail abschicken.
*/
isendmb_(mp)
int *mp;
{
 struct mailbox *mbox;
 struct strbuf write;
 short slen;
 int fd,xid;

 /* Konsistenztests */
 if ( (*mp < 0) || (*mp >= VD_MAXBOX) ) return ERRARG;
 mbox = vaxmhs_data.vd_boxes+*mp;
 /* Richtigen Exchange zum Abschicken suchen */
 if ( (xid = _mhs_readyxid) == -1 )
  for ( xid = 0 ; (xid < VD_MAXXID) && (vaxmhs_data.xids[xid] < 0) ; xid++ );
 /* Exchange verifizieren */
 if ( (xid < 0) || (xid >= VD_MAXXID) ) return ERRARG;
 if ( (fd = vaxmhs_data.xids[xid]) < 0 ) return ERRARG;
 /* Abschicken */
 write.buf = (char *)mbox;
 write.len = HEADERSIZE;
 if ( mbox->mbstatus&WRBIT )
  {
   SWORD(&mbox->mblen,&slen);
   if ( (slen < 0) || (slen > MAILMAX) ) return ERRARG;
   write.len += slen;
  }
 while ( putmsg(fd,(struct strbuf *)0,&write,0) == -1 ) 
  if ( errno != EINTR )
   return ERRARG;
 /* Mail freigeben */
 mbox->mblink = vaxmhs_data.freelist;
 vaxmhs_data.freelist = *mp;
 /* Hat funktioniert */
 return 0;
}
