#include "vaxmhs_subs.h"

/*
  Nachricht entgegennehmen. Dabei muessen die diversen Benutzeroptionen
  fuer die maximale Zeit beruecksichtigt werden. 
*/
ireqx_(xp,mp,wait,time)
int *xp,*mp,*wait,*time;
{
 static long buf[2] = { 0, 0 };
 int fd,prio,com = NM_COM,res;
 struct strbuf data,ctrl;
 struct strpeek sp;
 long tout;

 /* Konsistenztests */
 if ( (*xp < 0) || (*xp >= VD_MAXXID) || ((fd = vaxmhs_data.xids[*xp]) < 0) ) return 1;
 /* Warteintervall aufsetzen */
 if ( !*wait && *time )
  {
   /* Kontrollblock fuer den Treiber */
   ++buf[0];
   buf[1] = (*time)/100.0*sysconf(_SC_CLK_TCK);
   ctrl.buf = (char *)buf;
   ctrl.len = sizeof(buf);
   /* Timeout setzen */
   while ( putmsg(fd,&ctrl,(struct strbuf *)0,0) == -1 ) 
    if ( errno != EINTR )
     return 1;
  }
 /* Mail holen */
 if ( IGETMB(mp,&com) ) return 1;
 /* Mail abwarten */
 for ( res = -1 ; res == -1 ; )
  {
   /* Kontrollblocks aufsetzen */
   data.buf = (char *)vaxmhs_data.vd_boxes[*mp].mbrnet;
   data.maxlen = HEADERSIZE+MAILMAX;
   ctrl.buf = (char *)&tout;
   ctrl.maxlen = sizeof(tout);
   /* Nur nachsehen */
   if ( *wait )
    {
     /* Kontrollblock aufsetzen */
     sp.databuf = data;
     sp.ctlbuf = ctrl;
     sp.flags = 0;
     /* Informationen abfragen */
     switch (ioctl(fd,I_PEEK,&sp))
      {
       case -1 : /* Fehler */
	 	 res = 1;
		 continue;
       case  0 : /* Keine Nachricht */
	 	 res = -128;
		 continue;
      }
    }
   /* Nachricht einlesen */
   prio = 0;
   if ( getmsg(fd,&ctrl,&data,&prio) == -1 )
    if ( errno == EINTR )
     continue;
    else
     /* Fehler */
     res = 1;
   /* Kontrollnachricht */
   else if ( data.len >= HEADERSIZE )
    /* Daten erhalten */
    res = 0;
   else if ( (ctrl.len == 4) && (tout == *buf) && !*wait ) 
    /* Timeout */
    res = -127;
  }
 /* Aufraeumen */
 if ( res ) IADDMB(mp);
 return res;
}
