#include "vaxmhs_subs.h"

/*
  Antwortmail ermitteln. Dazu werden die Informationen ueber den neuen
  Empfaenger aus der erhaltenen Mail extrahiert. Danach arbeitet die
  Routine aehnlich wie 'icalcmb_'.
*/
ireadymb_(mp,op,cp)
int *mp,*op,*cp;
{
 int err,com = NM_COM;
 struct mailbox *mbox,*rbox;

 if ( (*op < 0) || (*op >= VD_MAXBOX) ) return ERRARG;
 mbox = vaxmhs_data.vd_boxes+*op;
 if ( !mbox->mbrnet[0] && (mbox->mbscom != NM_COM) ) return ERRARG;
 if ( err = IGETMB(mp,&com) ) return err;
 rbox = vaxmhs_data.vd_boxes+*mp;
 if ( !mbox->mbrnet[0] )
  {
   rbox->mbrxid = mbox->mbsxid;
   rbox->mbrnet[0] = rbox->mbstatus = 0;
  } 
 else
  {
   rbox->mbrxid = vaxmhs_data.netxid;
   bcopy(mbox->mbtnet,rbox->mbrnet,sizeof(rbox->mbrnet));
   rbox->mbicom = mbox->mbscom;
   rbox->mbixid = mbox->mbsxid;
   LONG(mbox->mbsaddr,rbox->mbsaddr);
   rbox->mbstatus = mbox->mbstatus;
   rbox->mbstatus &= ~(FRBIT|NRBIT);
  }
 rbox->mbexpd = mbox->mbexpd;
 rbox->mbnum = mbox->mbnum;
 rbox->mbfid = mbox->mbfid;
 rbox->mblen = rbox->mbres = 0;
 rbox->mbstatus |= RYBIT;
 rbox->mbcode = *cp;
 return 0;
}
