#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <syslog.h>
#include <unistd.h>
#include <stropts.h>

#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stream.h>
#include <sys/signal.h>
#include <sys/stropts.h>
#include <sys/sysmacros.h>

#include "vaxmhs_data.h"

extern int called_from_ioc;
extern char *malloc();


struct entry
       {
	struct entry *nexthash;
	int	     logname[2];
	struct entry *nextnum;
	short	     lognum;
	char	     options;
	char	     type;
	int	     start;
	int	     xid;
	struct entry *rnext;
	struct entry *rprev;
	short 	     rnum;
       };
#define OFOS		(1<<0)
#define OLAD		(1<<1)
#define TUSR		0
#define TPRG		125
#define TTASK		126
#define TNIL		127

struct entry *hashtab[32],*acthash,*rlist,*rlast = 0;
short rnum = 1;

#define AENTRY		(acthash = (struct entry *)malloc(sizeof(struct entry)))

#define FAIL(s)		{s;break;}

/*
  Der IOC.
*/
main(argc,argv)
int argc;
char **argv;
{
 int tabix,mb,rb,null = 0,xid,code,com = NM_COM,rfnd,forward,inum,discard,define;
 unsigned short len,options,net,act,prg,num,lad = OLAD,rix,rcode,me = 'JM';
 char name[8],addr[6],rbuf[1000];
 struct mailbox *mbox,*rbox;
 int field,mix,moff,rlen;
 struct entry **ref;

 /* Und anbinden */
 called_from_ioc = 1;
 VMEINI();
 /* Treiber initialisieren */
 sos_initialize();
 /* Broadcastadresse aufsetzen */
 multicast(SOS_BIND,"BROADCAST",vaxmhs_data.iocxid);
 /* Lokale Initialisierung */
 tabix = 1;
 /* Die ewige Schleife */
 for ( ; ; )
  {
   /* Mail abwarten */
   while ( IREQX(&vaxmhs_data.iocxid,&mb,&null,&null) );
   /* Daten auslesen */
   mbox = vaxmhs_data.vd_boxes+mb;
   QUAD(mbox->mbdata+0,name);
   LONG(mbox->mbdata+8,&xid);
   SWORD(mbox->mbdata+12,&options);
   SWORD(&mbox->mblen,&len);
   /* ETHERNET-Flags setzen */
   net = mbox->mbrnet[0];
   /* Selektion starten */
   code = forward = discard = define = 0;
   SWORD(&mbox->mbcode,&act);
   prg = (act-9)&12;
   /* Mail auswerten */
   switch (act)
    {
     case IOC$DEFNAME : /* Konsistenztests */
			if ( net ) FAIL(discard = 1);
			if ( len != 14 ) FAIL(code = 34);
			/* Logische Adresse definieren */
		 	if ( !(options&OLAD) )
			 /* Gleich definieren */
			 define = 1;
			/* Eintragen, wenn moeglich */
			else if ( !multicast(SOS_BIND,name,xid) ) 
			 FAIL(code = 35);
			break;
     case IOC$DEFPROG : 
     case IOC$DEFTASK : /* Konsistenztest */
			if ( net ) FAIL(discard = 1);
			if ( len != 16 ) FAIL(code = 34);
			define = 1;
			break;
     case IOC$GETNAME :
     case IOC$GETPROG :
     case IOC$GETTASK : /* Konsistenzchecks */
			if ( !(mbox->mbstatus&ERBIT) ) FAIL(discard = 1);
			if ( len != 10 ) FAIL(code = 34);
			/* Parameter auslesen */
			SWORD(mbox->mbdata+8,&num);
			/* Name suchen */
		 	if ( !searchln(name,num,num != 0,prg,&inum,&ref) ) FAIL(forward = 1);
			break;
     case IOC$DELNAME : 
     case IOC$DELPROG :
     case IOC$DELTASK : /* Konsistenzchecks */
			if ( net ) FAIL(discard = 1);
			if ( len != 10 ) FAIL(code = 34);
			/* Parameter auslesen */
			SWORD(mbox->mbdata+8,&num);
			/* Name suchen */
			if ( !searchln(name,num,1,prg,&inum,&ref) ) FAIL(code = 37);
			/* Und loeschen */
			deleteln(ref);
			break;
     case IOC$GETADDR : /* Konsistenzchecks */
			if ( !(mbox->mbstatus&ERBIT) || net ) FAIL(discard = 1);
			if ( len != 8 ) FAIL(code = 34);
			break;
     case IOC$DELADDR : /* Konsistenztests */
			if ( net ) FAIL(discard = 1);
			if ( len != 12 ) FAIL(code = 34);
			/* Parameter auslesen */
			if ( !multicast(SOS_UNBIND,name,xid) ) FAIL(code = 38);
			break;
     /* Informationen auslesen */
     case IOC$REQUEST : /* Parameter auslesen */
			SWORD(mbox->mbdata+0,&rcode);
			SWORD(mbox->mbdata+2,&rix);
			/* Konsistenztests */
			if ( (len != 4) || (rcode < 0) || (rcode > 4) ||
			     (rix < 0) || (rix >= rnum) ||
			     ((rcode == 4) && rix) )
			 FAIL(code = 34);
			break;
     /* Befehl an andere IOCs weitergeben */
     default 	      : forward = 1;
    } 
   /* Eintrag in die Hashtabelle bringen */
   if ( define )
    {
     /* Parameter verifizieren */
     if ( !name[0] ) 
      code = 32;
     /* Neuen Eintrag erzeugen */
     else if ( !AENTRY )
      code = 33;
     else
      {
       /* Name neu erzeugen mit automatischer Nummerierung */
       if ( !newln(acthash,name,num = 0,0,prg,&inum,&ref) )
        num = 1;
       else
        num = (*ref)->lognum+1;
       /* Auffuellen */
       acthash->lognum = num;
       acthash->xid = xid;
       /* Selektion nach Eintragstyp */
       if ( act == IOC$DEFNAME )
        {
         acthash->type = TUSR;
         acthash->options = options;
        }
       else
        {
         LONG(mbox->mbdata+12,&acthash->start);
         acthash->type = (act == IOC$DEFPROG) ? TPRG : TTASK;
        }	
       /* Und einfuegen in die Hashtabelle */
       insertln(inum,ref);
      }
    }
   /* Mail an die anderen IOCs weitergeben */
   if ( forward )
    {
     /* Nur fuer interne Mails */
     if ( !net )
      {
       mbox->mbstatus |= FIBIT;
       memset(mbox->mbrnet,-1,6);
       mbox->mbrxid = vaxmhs_data.netxid;
       if ( !ISENDMB(&mb) ) mb = -1; 
      }
     if ( mb == -1 ) continue;
     /* ETHERNET Mail wegschmeissen */
     discard = 1;
    }
   /* Mail beantworten */
   if ( !discard && (mbox->mbstatus&ERBIT) )
    if ( !IREADYMB(&rb,&mb,&code) )
     {
      /* Immer zu fuellende Antwortparameter setzen */
      len = 0;
      rbox = vaxmhs_data.vd_boxes+rb;
      rbox->mbstatus |= WRBIT;
      rbox->mbres = vaxmhs_data.sosversion;
      if ( !code )
       {
	/* Daten bereitstellen */
	switch (act)
	 {
	  case IOC$DEFNAME :
	  case IOC$DEFPROG :
	  case IOC$DEFTASK : /* Logische Nummer zurueck */
			     SWORD(&num,rbox->mbdata);
			     len = 2;
			     break;
	  case IOC$GETNAME :
	  case IOC$GETPROG :
	  case IOC$GETTASK : /* ETHERNET Adresse */
			     if ( net )
			      bcopy(vaxmhs_data.paddr,rbox->mbdata,6);
			     else
			      WORD(&null,rbox->mbdata);
			     /* COM */
			     LONG(&com,rbox->mbdata+6);
			     /* Exchange */
			     LONG(&acthash->xid,rbox->mbdata+10);
			     /* Und der Rest */
			     if ( act == IOC$GETNAME )
			      {
			       /* Typ und Optionen */
			       rbox->mbdata[16] = acthash->type;
			       rbox->mbdata[17] = acthash->options;
			       len = 20;
			      }
			     else
			      {
			       /* Informationsadresse */
			       LONG(&acthash->start,rbox->mbdata+16);
			       len = 22;
			      }
			     /* Rechner, auf dem der Eintrag definiert wurde */
			     WORD(vaxmhs_data.paddr+2,rbox->mbdata+len-2);
			     break;
	  case IOC$GETADDR : /* Besondere Behandlung fuer BROADCASTs */
			     makemulti(name,rbox->mbdata,-1);
			     /* COM und Echange */
			     LONG(&null,rbox->mbdata+6);
			     LONG(&null,rbox->mbdata+10);
			     /* Optionen */
			     SWORD(&lad,rbox->mbdata+16);
			     /* Nummer des Rechners */
			     WORD(&null,rbox->mbdata+18);
			     len = 20;
			     break;
	  case IOC$REQUEST : /* Zugriffsliste des IOCs */
			     bcopy(vaxmhs_data.paddr,rbox->mbdata,6);
			     LONG(&com,rbox->mbdata+6);
			     LONG(&vaxmhs_data.iocxid,rbox->mbdata+10);	
			     WORD(&me,rbox->mbdata+14);
			     WORD(&null,rbox->mbdata+16);
			     len = 18;
			     /* Logische Adressen */
			     if ( rcode == 4 ) 
			      {
			       /* Informationen einlesen */
			       if ( (rlen = request(rbuf)) == -1 ) break;
			       /* Feldgroesse ermitteln */
			       LONG(rbuf,&field);
			       moff = 4*(2+field);
			       /* Alle Eintraege bearbeiten */
			       for ( mix = 4 ; (mix+moff) <= rlen ; mix += moff )
				if ( !addmulticast(rbuf+mix,field,rbox->mbdata,&len) )
				 break;
			       /* Fertig */
			       break;
			      }
			     /* Module */
			     if ( !rcode ) break;
			     /* Logische Namen, Programmmodule, Prozesse */
			     switch (rcode)
			      {
			       case 1 : rfnd = TUSR;
					break;
			       case 2 : rfnd = TPRG;
					break;
			       case 3 : rfnd = TTASK;
			      }
			     /* Anfang suchen */
			     acthash = rlist;
			     while ( acthash && (acthash->rnum < rix) )
			      acthash = acthash->rnext;
			     if ( !acthash ) break;
			     /* Liste durchgehen */
			     for ( ; acthash ; acthash = acthash->rnext )
			      {
			       /* Informationsart ueberpruefen */
			       if ( acthash->type != rfnd ) continue;
			       /* Mailgroesse beachten */
			       if ( (len+28) > MAILMAX )
				{
				 SWORD(&acthash->rnum,rbox->mbdata+16);
				 break;
				} 
			       /* Information eintragen */ 
			       WORD(&acthash->options,rbox->mbdata+len);
			       QUAD(acthash->logname,rbox->mbdata+len+2);
			       SWORD(&acthash->lognum,rbox->mbdata+len+10);
			       LONG(&com,rbox->mbdata+len+12);
			       LONG(&acthash->xid,rbox->mbdata+len+16);
			       len += 20;
			       /* Logischen Namen */
			       if ( acthash->type == TUSR ) continue;
			       /* Programmmodule */
			       LONG(&acthash->start,rbox->mbdata+len);
			       len += 4;
			       if ( acthash->type == TPRG ) continue;
			       /* Prozesse */
			       LONG(&null,rbox->mbdata+len);
			       len += 4;
			      }
			     break;
 	 }
       }
      /* Mail komplettieren und abschicken */
      SWORD(&len,&rbox->mblen);
      if ( ISENDMB(&rb) )
       {
	IADDMB(&rb);
	VM_ERROR("IOC can't send READYMB",0,0);
       }
     }
    else
     VM_ERROR("IOC can't get READYMB",0,0);
   /* Alte Mail eleminieren */
   IADDMB(&mb);
  }
}

/*
  Hashindex berechnen.
*/
static calchash(name)
int name[2];
{
 int hash,cur,i;

 /* Simpeler Algorithmus */
 for ( hash = 0, cur = name[1], i = 1 ; i <= 14 ; i++ )
  {
   hash ^= cur;
   cur = (i == 7) ? name[0] : (cur>>5); 
  }
 /* Index in die Hashtabelle */
 return cur&31;
}

/*
  Eintrag der Hashtabelle sowie Vorgaenger ermitteln.
*/
searchln(name,num,snum,prg,numins,prev)
int name[2],snum,*numins;
short num,prg;
struct entry ***prev;
{
 int res = 0,ix = calchash(name);
 struct entry **ref,*hash;
 char type;

 /* Initialisierung */ 
 *numins = 0; 
 hash = *(ref = hashtab+ix);
 /* Liste vorhanden */
 if ( hash )
  {
   /* Namensliste durchgehen */
   while ( hash && ((name[0] > hash->logname[0]) ||
	   ((name[0] == hash->logname[0]) && (name[1] > hash->logname[1]))) )
    hash = *(ref = &hash->nexthash);
   /* Nummernliste vorhanden */
   if ( hash && !memcmp((char *)name,(char *)hash->logname,8) )
    {
     /* Ergebnisse setzen */
     *numins = 1;
     /* Definitionsgruppen ueberspringen */
     if ( !prg )
      type = TPRG;
     else if ( prg == 4 )
      {
       while ( hash && (hash->type != TPRG) ) hash = *(ref = &hash->nextnum);
       type = TTASK; 
      }
     else
      {
       while (hash && (hash->type != TTASK) ) hash = *(ref = &hash->nextnum);
       type = TNIL;
      }
     /* Nummernliste durchsuchen */
     if ( hash )
      if ( !snum )
       res = (hash->type < type);
      else
       {
        while ( hash && (hash->type < type) && (hash->lognum < num) )
 	 hash = *(ref = &hash->nextnum);
        res = (hash && (hash->type < type) && (hash->lognum == num));
       }
    }
  }
 /* Ergebnisse setzen */
 acthash = hash;
 *prev = ref;
 return res;
}

/*
  Neuen Eintrag initialisieren.
*/
newln(ent,name,num,snum,prg,numins,prev)
struct entry *ent,***prev;
int name[2],snum,*numins;
short num,prg;
{
 int res;

 /* Vorgaenger ermitteln */
 res = searchln(name,num,snum,prg,numins,prev);
 /* Eintrag fuellen */
 ent->logname[0] = name[0];
 ent->logname[1] = name[1];
 ent->lognum = num;
 ent->options = 0;
 acthash = ent;
 /* Linear fuer IOC$REQUEST verketten */
 ent->rnum = rnum++;
 ent->rprev = rlast;
 ent->rnext = 0;
 if ( rlast ) rlast->rnext = ent;
 if ( !rlist ) rlist = ent;
 rlast = ent; 
 /* Ergebnis melden */
 return res;
}

/*
  Neuen Eintrag in die Hashtabelle stecken.
*/
insertln(numins,prev)
int numins;
struct entry **prev;
{
 if ( numins )
  {
   /* In eine Hashkette unterordnen */
   acthash->nextnum = *prev;
   if ( *prev )
    {
     acthash->nexthash = (*prev)->nexthash;
     (*prev)->nexthash = 0;
    }
   else
    acthash->nexthash = 0;
  }
 else
  {
   /* Global einordnen */
   acthash->nexthash = *prev;
   acthash->nextnum = 0;
  }
 /* Verkettung vervollstaendigen */
 *prev = acthash; 
}

/*
  Eintrag aus der Hashtabelle entfernen.
*/
deleteln(prev)
struct entry **prev;
{
 /* Aus der jeweiligen Liste entfernen */
 if ( !(*prev = acthash->nextnum) )
  *prev = acthash->nexthash;
 else
  (*prev)->nexthash = acthash->nexthash;
 /* Aus der linearen Liste fuer IOC$REQUEST entfernen */
 if ( acthash->rprev )
  acthash->rprev->rnext = acthash->rnext; 
 else
  rlist = acthash->rnext;
 if ( rlast == acthash ) rlast = acthash->rprev;
 /* Speicher freigeben */
 free(acthash);
}

/*
  Initialisierung des SOS-Devices als IOC.
*/
static sos_initialize()
{
 int sos,inen,name,xid;

 /* Exchangenummer muss IOCXID sein */
 if ( IGENX(&name,&xid) ) VM_ERROR("Could not create IOCXID",1,0);
 if ( xid != vaxmhs_data.iocxid ) VM_ERROR("IOC is already running",1,0);
 sos = vaxmhs_data.xids[xid];
 /* INEN-Device oeffen */
 if ( (inen = open("/dev/inen0",O_RDWR)) < 0 ) VM_ERROR("ETHERNET device not found",1,0);
 /* ETHERNET Konfigurieren */
 if ( ioctl(sos,I_LINK,inen) == -1 ) VM_ERROR("Could not configure network",1,0);
 close(inen);
 /* Hardwareadresse auslesen */
 _mhs_paddr(sos);
}

/*
  Logische Adresse anbinden oder loesen
*/
static multicast(op,addr,xid)
int op,xid;
char *addr;
{
 static char mbuf[10];
 struct strioctl bind;

 /* Daten aufsetzen */
 makemulti(addr,mbuf+0);
 bcopy(&xid,mbuf+6,4);
 bind.ic_cmd = op;
 bind.ic_timout = 60;
 bind.ic_dp = (char *)&mbuf;
 bind.ic_len = sizeof(mbuf);
 /* Operation durchfuehren */
 return (ioctl(vaxmhs_data.xids[IOCXID],I_STR,&bind) != -1);
}

/*
  Multicastdaten auslesen.
*/
static request(addr)
char *addr;
{
 struct strioctl request;

 /* Daten aufsetzen */
 request.ic_cmd = SOS_REQUEST;
 request.ic_timout = 10;
 request.ic_dp = addr;
 request.ic_len = 0;
 /* Operation durchfuehren */
 if ( ioctl(vaxmhs_data.xids[IOCXID],I_STR,&request) == -1 ) return -1;
 /* Laenge melden */
 return request.ic_len;
}

/*
  Multicastadresse umsetzen.
*/
static makemulti(src,dst)
char *src,*dst;
{
 /* BROADCAST */
 if ( !memcmp(src,"BROADCAS",8) )
  bcopy("\377\377\377\377\377\377",dst,6);
 else
  {
   /* Logische Adressen */
   bcopy("\253\000\004",dst,3);
   bcopy(src,dst+3,3);
  }
}

/*
  Multicastfeld in logische Adressen umsetzen.
*/
static addmulticast(src,cnt,dst,dixp)
char *src,*dst;
int cnt;
unsigned short *dixp;
{
 static int com = NM_COM;
 unsigned long *users,mask,cur;
 int xid;

 /* Alle Bits durchgehen */
 for ( users = (unsigned long *)(src+8), xid = 0 ; cnt-- > 0 ; )
  for ( cur = *users++, mask = 1 ; mask ; mask += mask, xid++ )
   if ( mask&cur )
    {
     /* Information eintragen */
     if ( (*dixp)+16 > MAILMAX ) return 0;
     /* Kopieren */
     bcopy(src,dst+(*dixp),6);
     bcopy(&com,dst+(*dixp)+6,4);
     bcopy(&xid,dst+(*dixp)+10,4);
     bzero(dst+(*dixp)+14,2);
     /* Zaehler korrigieren */
     (*dixp) += 16;
    }
 /* Alles in Ordnung */
 return 1;
}
